﻿app.controller("appCtrl", ['$rootScope', '$scope', '$http', '$state', '$localStorage','$location', 'Flash', 'appSettings', '$interval','Idle','Keepalive','$q',
    function ($rootScope, $scope, $http, $state,$localStorage, $location, Flash, appSettings, $interval,Idle,Keepalive,$q) {

        // Default bindings
        var vm = this;
        $scope.currentUser = 'User';
        $rootScope.buildCode = "IND";
        $rootScope.showUI = "";
        $scope.state = 'dashboard';
        $scope.role = 'role';
        loadServerUI();

        // Load User
        $scope.loadCurrentUser = function () {
            $http.get('api/v2/dashboard/currentuser')
                .then(function (response) {
                    if (response.data) {
                        $scope.currentUser = response.data.currentUser;
                        $rootScope.buildCode = response.data.buildCode;
                        $scope.role = response.data.role;
                    }
                });
        }

        // Default call for Server Stats
        loadServerStat();



        function loadServerUI() {
            var def = $q.defer();
            $http.get('api/v2/nodelinks/switchui')
                .then(function (response) {
                    if (response.data) {
                        $rootScope.showUI = response.data.ui;
                        if (response.data.ui == 'sw') {
                            $scope.state = 'swdashboard'
                            vm.menuItems = [
                                        {
                                            title: "Dashboard",
                                            icon: "fas fa-lg fa-tachometer-alt",
                                            state: "dashboardsw"
                                        },
                                        {
                                            title: "Discovery",
                                            icon: "fas fa-lg fa-crosshairs",
                                            // icon: "discoveryIcon",
                                            state: "discovery"
                                        },
                                        {
                                            title: "Topology",
                                            icon: "fas fa-lg fa-sitemap",
                                            state: "topology"
                                        },

                                        {
                                            title: "Configuration",
                                            icon: "fas fa-lg fa-cogs",
                                            state: "config"
                                        },
                                        {
                                            title: "Events",
                                            icon: "fas fa-lg fa-star",
                                            state: "events"
                                        },
                                        {
                                            title: "Inventory Reports",
                                            icon: "fas fa-lg fa-file-alt",
                                            state: "reports"
                                        },
                                        {
                                            title: "Settings",
                                            icon: "fas fa-lg fa-cog",
                                            state: "globalsettings"
                                        }
                                    ];

                            def.resolve(response.data.ui);
                        } else {
                            vm.menuItems = [
                                        {
                                            title: "Dashboard",
                                            icon: "fas fa-lg fa-tachometer-alt",
                                            state: "dashboard"
                                        },
                                        {
                                            title: "Discovery",
                                            icon: "fas fa-lg fa-crosshairs",
                                            // icon: "discoveryIcon",
                                            state: "discovery"
                                        },
                                        {
                                            title: "Topology",
                                            icon: "fas fa-lg fa-sitemap",
                                            state: "topology"
                                        },

                                        {
                                            title: "Configuration",
                                            icon: "fas fa-lg fa-cogs",
                                            state: "config"
                                        },
                                        {
                                            title: "Events",
                                            icon: "fas fa-lg fa-star",
                                            state: "events"
                                        },
                                        {
                                            title: "Inventory Reports",
                                            icon: "fas fa-lg fa-file-alt",
                                            state: "reports"
                                        },
                                        {
                                            title: "Settings",
                                            icon: "fas fa-lg fa-cog",
                                            state: "globalsettings"
                                        }
                                    ];

                        }
                    }
                });
                return def.promise;
        }

        // Load Default Server stats and initiate timer
        function loadServerStat() {
            $http.get('api/v2/nodelinks/serverstats',{showdiv:false})
                .then(function (response) {
                    if (response.data) {
                        $scope.serverStat = response.data;
                        //$rootScope.buildCode = response.data.;
                    }
                });
                Idle.watch();
            $scope.timer = $interval(function () { $scope.loadInterval() }, 5000);
        }

        // Load server stats in intervals
        $scope.loadInterval = function () {
            $http.get('api/v2/nodelinks/serverstats',{showdiv:false})
                .then(function (response) {
                    if (response.data) {
                        $scope.serverStat = response.data;
                    }
                });
        }

        //Sidebar items
        vm.menuItems = [
            {
                title: "Dashboard",
                icon: "fas fa-lg fa-tachometer-alt",
                state: "dashboard"
            },
            {
                title: "Discovery",
                icon: "fas fa-lg fa-crosshairs",
                // icon: "discoveryIcon",
                state: "discovery"
            },
            {
                title: "Topology",
                icon: "fas fa-lg fa-sitemap",
                state: "topology"
            },

            {
                title: "Configuration",
                icon: "fas fa-lg fa-cogs",
                state: "config"
            },
            {
                title: "Events",
                icon: "fas fa-lg fa-star",
                state: "events"
            },
            {
                title: "Inventory Reports",
                icon: "fas fa-lg fa-file-alt",
                state: "reports"
            },
            {
                title: "Settings",
                icon: "fas fa-lg fa-cog",
                state: "globalsettings"
            }
        ];

        // Display Tooltip
        $(function () {
            $('[data-toggle="tooltip"]').tooltip()
        })

        // Toggle side bar
        $("#sidebarToggle").on('click', function (e) {
            e.preventDefault();
            $("body").toggleClass("sidebar-toggled");
            $(".sidebar").toggleClass("toggled");
        });

        // Toggle Sidebar in window width
        vm.sideBar = function (value) {
            debugger
            $localStorage.iparray=[];
            $localStorage.showtopology='ip';
            if ($(window).width() <= 767) {
                if ($("body").hasClass('sidebar-open'))
                    $("body").removeClass('sidebar-open');
                else
                    $("body").addClass('sidebar-open');
            }
            else {
                if (value == 1) {
                    if ($("body").hasClass('sidebar-collapse'))
                        $("body").removeClass('sidebar-collapse');
                    else
                        $("body").addClass('sidebar-collapse');
                }
            }
        };

        // Navigate to search page
        vm.search = function () {
            $state.go('app.search');
        };

        //Timeout logout
        $scope.$on('IdleStart', function() { 
            $scope.logOut();
            });

         // Logout button click
         $scope.logOut = function(){
          $http.get('api/v2/dashboard/logout')
                         .then(function (response) {
                             if (response.statusText== "OK") {
                                window.location.href = 'j_spring_security_logout';
                             }
                         });
         }

         $scope.selectedmenufun = function (val) {
//                 if(val=='events'||val=='reports'){
//                         $localStorage.facilities=[];
//                          $localStorage.locations=[];
//                          $localStorage.regions=[];
//                          $localStorage.basestations=[];
//                          $localStorage.regionselectedid='';
//                          $localStorage.locationselectedid='';
//                          $localStorage.facilityselectedid='';
//                         // $localStorage.selectedView='';
//                 }
                     if (val == 'topology') {
                         $localStorage.selectedradiomode = 'all';
                         // if ($localStorage.isExpand) {
                         // $localStorage.isExpand = false;
                         // $rootScope.$emit("CallParentMethodmanagement", {});
                         // setTimeout(function () { $window.location.reload(true); }, 10);
                         // // $location.path("/app."+val);
                         // }
                     }
                 }

                 $scope.timeout = [{
                     "value": 5
                 }, {
                     "value": 10
                 }];
                 $scope.data = {};
                 $scope.data.selectedvalue = true;
                 // $scope.data.settime = '';


                 $scope.openPopup = function () {
                     $("#logouttimepopup").modal('show');
                 }

                 $scope.savelogout = function () {
                     if ($scope.data.selectedvalue) {
                         if ($scope.data.settime.value) {
                             var timeset = parseInt($scope.data.settime.value);
                             var time = timeset * 60;
                             Idle.setIdle(time);
                             $http({
                                 method: 'POST',
                                 url: 'rest/users/timeout/' + timeset,
                                 headers: {
                                     'Content-Type': 'application/json'
                                 },
                                 // data:[]
                             }).success(function () {
                                 //$scope.showAlert('success', 'Saved Successfully');
                                 $scope.loadCurrentUser();
                             }).error(function (msg) {
                                 alert("error" + msg);
                                 //$scope.showAlert('error', 'Error updating data: ' + msg);
                             });
                         }
                     } else {
                         Idle.unwatch();
                         $http({
                             method: 'POST',
                             url: 'rest/users/timeout/0',
                             headers: {
                                 'Content-Type': 'application/json'
                             },
                             data: []
                         }).success(function () {
                             //$scope.showAlert('success', 'Saved Successfully');
                             $scope.loadCurrentUser();
                         }).error(function (msg) {
                             alert("error" + msg);
                             //$scope.showAlert('error', 'Error updating data: ' + msg);
                         });
                     }
                     $("#logouttimepopup").modal('hide');
                 }
    }]);
