﻿﻿﻿﻿﻿dashboard.controller("ConfigController", ['$rootScope', '$scope', '$mdDialog', '$http', '$state', '$location', 'dashboardService', 'Flash', '$interval', '$q',
    function ($rootScope, $scope, $mdDialog, $http, $state, $location, dashboardService, Flash, $interval, $q) {

        // Default Table bindings
        var vm = this;
        $scope.pagesizes = [5, 10, 25, 50, 100];
        $scope.pagesize = $scope.pagesizes[2];
        $scope.currentpage = 1;

        $scope.pagesizesbulk = [5, 10, 25, 50, 100];
        $scope.pagesizebulk = $scope.pagesizesbulk[1];
        $scope.currentpagebulk = 1;


        $scope.tasksArray = [];
        $scope.chngType = 0;
        $scope.singleConfig = {};
        $scope.allToggle = true;
        $rootScope.existingdevicetext = {};
        $scope.configdata = {};
        $scope.configdata.existingdevicetextnew = {};
        $scope.configdata.existingconfigtextnew = {};
        $scope.configdata.newdevicetext = "";
        $rootScope.selectedserialNumber = '';
        $rootScope.selectednode = '';
        $scope.selectedtemplatedup = '';
        $rootScope.selectedtemplate = '';
        $scope.status = [
            { name: 'All', value: 4, status: true },
            { name: 'Pending', value: 0, status: false },
            { name: 'Running', value: 1, status: false },
            { name: 'Succesful', value: 2, status: false },
            { name: 'Failed', value: 3, status: false },
        ]
        $scope.view_tasks = false;
        //$scope.selectAlltasks = false;
        $scope.hwreplacenew = {};
        // Default page bindings
        $scope.activeClass = "background-color:rgb(246, 246, 246);color:black";
        //$scope.tableWidth = "col-md-7";
        $scope.tableWidth = "col-lg-12 col-md-12 col-sm-12 col-xs-12";
        /*$scope.selectedPage = 'vlan_profile';
        $scope.selectedForm = "create_vlan_profile";*/

        $scope.applyFirmwareForm = false;
        $scope.query = "Select";

        $scope.selectedPage = 'vlan_profile';
        $scope.selectedForm = "";
        $scope.openForm = true;
        $scope.basestations = [];
        $scope.isImmediate = true;
        $scope.sdate = '';
        $scope.selectAlltasks = false;
        $scope.tRemText = 'Cancel';

        // Radio Mode Options for table filter
        $scope.radioMode = [{
            'name': "All",
            'value': '-1'
        },
        {
            'name': "AP",
            'value': '1'
        }, {
            'name': "SU",
            'value': '2'
        }
        ];

        $scope.selectedFirmware = {};

        // Link Type Options for table filter
        $scope.linkType = [{
            'name': "All",
            'value': '-1'
        }, {
            'name': "PTP",
            'value': '1'
        }, {
            'name': "BackHaul",
            'value': '2'
        }, {
            'name': "PTMP",
            'value': '3'
        }
        ];

        $scope.singleConfig = [{
            'dName': '',
            'key': "",
            'value': '',
            'pValues': ''
        }
        ];

        // Default Arrays and objects
        $scope.filter = {}; // for rMode & lType
        $scope.newFirmware = {};
        $scope.deviceArray = [];
        $scope.applyFirmware = {};


        // Default bindings for the Table filter
        $scope.filter.rMode = $scope.radioMode[0];
        $scope.filter.lType = $scope.linkType[0];
        $scope.applyForm = {};
        if ($scope.filter.lType.value === 'all') {
            $scope.ltype = -1;
        }

        $scope.radiodata={};
        $scope.radiodata.selectedDeviceradio = "existingdevice";
        $scope.selectedProfile = "allprofile";

        // Default Call
        defaultCall();

        // Default function
        function defaultCall() {
            if (!$scope.ttype) {
                $scope.ttype = 1;
            }
            if (!$scope.rtype || !$scope.ltype || !$scope.sortField || !$scope.sortOrder) {
                $scope.rtype = -1;
                $scope.ltype = -1;
                $scope.sortField = 'name';
                $scope.sortOrder = 'asc';
                //$scope.reverse = true;
            }
            var url = 'api/v2/profiles/template/list?ttype=' + $scope.ttype + '&ltype=' + $scope.ltype + '&rtype=' + $scope.rtype + '&page=' + $scope.currentpage + '&limit=' + $scope.pagesize + '&sort=' + $scope.sortField + '.' + $scope.sortOrder;
            $http.get(url).then(function (response) {

                for (var i = 0; i < response.data.length; i++) {
                    for (var j = 0; j < $scope.linkType.length; j++) {
                        if (response.data[i].linkType == $scope.linkType[j].value) {
                            response.data[i].linkTypeName = $scope.linkType[j].name;
                        }
                    }
                    for (var k = 0; k < $scope.radioMode.length; k++) {
                        if (response.data[i].radioMode == $scope.radioMode[k].value) {
                            response.data[i].radioModeName = $scope.radioMode[k].name;
                        }
                    }
                }
                $scope.profileDataObj = response.data;

                if (response.data.length < $scope.pagesize) {
                    $scope.nextBtnDisable = true;
                }
                $scope.TotalPages = response.data.length;
                if ($scope.profileDataObj == null) {
                    $scope.TotalPages = 0;
                }
                $scope.pagenumber = Math.ceil($scope.profileDataObj.length / $scope.pagesize);
                if ($scope.pagenumber == 0) {
                    $scope.pagenumber = 1;
                }
            });
        }

        // Reload table from other controllers - After success
        $rootScope.$on("defaultCall", function (event, opt) {
            $scope.ttype = opt;
            defaultCall();
        });

        $rootScope.provisionpage = "";
        // Page Selection
        $scope.showPage = function (selectedPage) {
            $scope.stopTimer();
            $scope.tableWidth = "col-lg-12 col-md-12 col-sm-12 col-xs-12";
            $scope.activeClass = "";
            $scope.selectedForm = "";
            $rootScope.profileID = "";
            $scope.openForm = false;
            $scope.isnameDisable = false;
            $scope.nodesToApply = [];
            $scope.basestations = [];
            $scope.selectedRow = null; // initialize our variable to null
            if (selectedPage == 'profiles') {
                $scope.selectedPage = selectedPage;
            } else if (selectedPage == 'firmwares') {

                $scope.loadRegions();
                //$scope.applyFirmware = obj;
                $scope.openForm = true;
                //$scope.selectedForm = "applyFirmware";
                $scope.sortField = 'fileName';
                $scope.sortOrder = 'asc';

                $scope.getFirmwares();
                $scope.selectedPage = selectedPage;

            } else if (selectedPage == 'bulkip' || selectedPage == 'breboot' || selectedPage == 'bconfback' || selectedPage == 'bchpassbulk' || selectedPage == 'bulkfirm' || selectedPage == 'configpush') {
                $scope.chngType = 0;
                $scope.loadRegions();
                $scope.selectedstatus = 0;
                $scope.getTasks(selectedPage, 0);
                //$scope.applyFirmware = obj;
                $scope.openForm = true;
                $scope.tRemText = 'Cancel';

//                $scope.getTaskData(selectedPage);
                if (selectedPage == 'bulkfirm') {
                    $scope.pagesize = -1;
                    $scope.allFirmwares();
                } else if (selectedPage == 'configpush') {
                    $scope.getSingleConfigList();
                }
                $scope.check.rebootselect = false;
                $scope.pagesizebulk = $scope.pagesizesbulk[1];
                $scope.currentpagebulk = 1;
                $scope.selectedPage = selectedPage;
                $scope.getTasks($scope.selectedPage, $scope.selectedstatus);
            }
            else if (selectedPage == 'vlan_profile') {
                $scope.sortField = 'name';
                $scope.sortOrder = 'asc';
                $scope.getProfilesData(1);
                $scope.selectedPage = selectedPage;
                //$scope.tableWidth = "col-md-7";
                $scope.openForm = true;
                //$scope.selectedForm = "create_vlan_profile";
                $scope.$emit("init_vlan");
            } else if (selectedPage == 'ethernet_profile') {
                //$scope.tableWidth = "col-md-7";
                $scope.openForm = true;
                //$scope.selectedForm = "create_ethernet_profile";
                $scope.$emit("init_ethernet");
                $scope.sortField = 'name';
                $scope.sortOrder = 'asc';
                $scope.getProfilesData(2);
                $scope.selectedPage = selectedPage;
            } else if (selectedPage == 'radius_profile') {
                //$scope.tableWidth = "col-md-7";
                $scope.openForm = true;
                //$scope.selectedForm = "create_radius_profile";
                $scope.$emit("init_radius");
                $scope.sortField = 'name';
                $scope.sortOrder = 'asc';
                $scope.getProfilesData(3);
                $scope.selectedPage = selectedPage;
            } else if (selectedPage == 'dhcp_profile') {
                //$scope.tableWidth = "col-md-7";
                $scope.openForm = true;
                //$scope.selectedForm = "create_dhcp_profile";
                $scope.$emit("init_dhcp");
                $scope.sortField = 'name';
                $scope.sortOrder = 'asc';
                $scope.getProfilesData(4);
                $scope.selectedPage = selectedPage;
            } else if (selectedPage == 'wireless_profile') {
                //$scope.tableWidth = "col-md-7";
                $scope.openForm = true;
                //$scope.selectedForm = "create_wireless_profile";
                $scope.$emit("init_wireless");
                $scope.sortField = 'name';
                $scope.sortOrder = 'asc';
                $scope.getProfilesData(5);
                $scope.selectedPage = selectedPage;
            } else if (selectedPage == 'ddrsatpc_profile') {
                //$scope.tableWidth = "col-md-7";
                $scope.openForm = true;
                //$scope.selectedForm = "create_ddrsatpc_profile";
                $scope.$emit("init_ddrsatpc");
                $scope.sortField = 'name';
                $scope.sortOrder = 'asc';
                $scope.getProfilesData(6);
                $scope.selectedPage = selectedPage;
            } else if (selectedPage == 'snmp_profile') {
                //$scope.tableWidth = "col-md-7";
                $scope.openForm = true;
                //$scope.selectedForm = "create_ddrsatpc_profile";
                $scope.$emit("init_snmp");
                $scope.sortField = 'name';
                $scope.sortOrder = 'asc';
                $scope.getProfilesData(7);
                $scope.selectedPage = selectedPage;
            } else if (selectedPage == 'autoprovisioning') {
                $rootScope.provisionpage = "step1";
                $scope.selectedPage = selectedPage;
                $rootScope.selectedserialNumber = '';
                $rootScope.selectednode = '';
                $rootScope.existingdevicetext = {};
                $scope.radiodata.selectedDeviceradio = 'existingdevice';
                $scope.configdata = {};
                $scope.existingdeviceFun();
            } else if (selectedPage == 'hardwarereplacement') {
                $scope.selectedPage = selectedPage;
                $scope.loadRegions();
            }
            $scope.taskDetails(4, $scope.status[0], 0);
            if ($scope.selectedPage == 'bulkip' || $scope.selectedPage == 'breboot' || $scope.selectedPage == 'bconfback' || $scope.selectedPage == 'configpush' || $scope.selectedPage == 'bchpassbulk' || $scope.selectedPage == 'bulkfirm') {
                $scope.DataTimer = $interval(function () { $scope.getTasks($scope.selectedPage, $scope.selectedstatus); }, 2000);
            }
        }

        $scope.existingdeviceFun = function () {
            var url = 'api/v2/nodes/unprovserial?_s=assetRecord.serialNumber==*&limit=1005&offset=0&order=asc';
            $http.get(url).then(function (response) {
                $scope.existingConfigArray = [];
                $scope.existingDeviceArray = [];
                var proarray = response.data.nodes;
                if (proarray.length > 0 || proarray != null) {
                    for (var i = 0; i < proarray.length; i++) {
                        if (proarray[i].cexist == false) {
                            $scope.existingDeviceArray.push(proarray[i]);
                        } else {
                            $scope.existingConfigArray.push(proarray[i]);
                        }
                    }
                }
                console.log("existingDeviceArray", $scope.existingDeviceArray);
                console.log("existingConfigArray", $scope.existingConfigArray);
            });
        }

        $scope.templateArray = [];
        $scope.templateFun = function () {
            $scope.templateArray = [];
            $scope.selectedtemplatedup = '';
            var url = 'api/v2/autopro/templatenames/all';
            $http.get(url).then(function (response) {
                  $scope.templateArray = response.data.names;
                // $scope.templateArray = [
                //     { name: 'default-template' },
                //     { name: 'ap-template' },
                //     { name: 'su-template' }
                // ]
                // $rootScope.selectedtemplate = $scope.templateArray[0].name;
                // $scope.selectedtemplatedupall = $scope.templateArray[0].name;
            });
        }

$scope.changedvalue=function(type,value){
    if(type=='all'){
        $scope.selectedtemplatedupall =value;
    }else if(type=='ap'){
        $scope.selectedtemplatedupap =value;
    }else{
        $scope.selectedtemplatedupsu=value;
    }
}

        $scope.selectedtemplatedupall = {};
        $scope.selectedtemplatedupap = {};
        $scope.selectedtemplatedupsu = {};
        $scope.changeprofileFun = function (selectedProfile) {
            $scope.templateArray = [];
            $scope.selectedProfile = selectedProfile;

            if ($scope.selectedProfile == 'allprofile') {
                var url = 'api/v2/autopro/templatenames/all';
                $http.get(url).then(function (response) {
                    $scope.templateArray = response.data.names;
                    $scope.selectedtemplatedupap = {};
        $scope.selectedtemplatedupsu = {};
                    // $rootScope.selectedtemplate = $scope.templateArray[0].name;
                    // $scope.selectedtemplatedupall = $scope.templateArray[0].name;
                });
            }
            if ($scope.selectedProfile == 'approfile') {
                var url = 'api/v2/autopro/templatenames/ap';
                $http.get(url).then(function (response) {
                    $scope.templateArray = response.data.names;
                    $scope.selectedtemplatedupall = {};
                    $scope.selectedtemplatedupsu = {};
                    // $rootScope.selectedtemplate = $scope.templateArray[0].name;
                    // $scope.selectedtemplatedupap = $scope.templateArray[0].name;
                });
            }
            if ($scope.selectedProfile == 'suprofile') {
                var url = 'api/v2/autopro/templatenames/su';
                $http.get(url).then(function (response) {
                    $scope.templateArray = response.data.names;
                    $scope.selectedtemplatedupall = {};
                    $scope.selectedtemplatedupap = {};
                    // $rootScope.selectedtemplate = $scope.templateArray[0].name;
                    // $scope.selectedtemplatedupsu = $scope.templateArray[0].name;
                });
            }

            //   if ($scope.selectedProfile == 'allprofile') {
            //     $scope.templateArray=[
            //         { name: 'default-template' },
            //         { name: 'ap-template' },
            //         { name: 'su-template' }
            //     ]
            //     $rootScope.selectedtemplate = $scope.templateArray[0].name;
            //     $scope.selectedtemplatedupall = $scope.templateArray[0].name;
            // }
            // if ($scope.selectedProfile == 'approfile') {
            //     $scope.templateArray=[
            //         { name: 'ap-template' },
            //     ]
            //     $rootScope.selectedtemplate = $scope.templateArray[0].name;
            //     $scope.selectedtemplatedupap = $scope.templateArray[0].name;
            // }
            // if ($scope.selectedProfile == 'suprofile') {
            //     $scope.templateArray=[
            //         { name: 'su-template' }
            //     ]
            //     $rootScope.selectedtemplate = $scope.templateArray[0].name;
            //     $scope.selectedtemplatedupsu = $scope.templateArray[0].name;
            // }

        }

        $scope.existingdeviceChange = function (existingdevicetext) {
            $scope.radiodata.selectedDeviceradio = 'existingdevice';
            $rootScope.existingdevicetext = existingdevicetext;
            $rootScope.selectedserialNumber = existingdevicetext.serial;
            $rootScope.selectednode = existingdevicetext.id;
            $scope.configdata.newdevicetext = "";
            $scope.configdata.existingconfigtextnew = {};
        }

        $scope.addNewDevice = function () {
            if ($scope.configdata.newdevicetext) {
                $scope.radiodata.selectedDeviceradio = 'newdevice';
                $scope.configdata.existingconfigtextnew = {};
                $scope.configdata.existingdevicetextnew = {};
            }
        }

        $scope.existingconfigChange = function (existingdevicetext) {
            $scope.configdata.existingconfigtextnew = existingdevicetext;
            $rootScope.existingdevicetext = existingdevicetext;
            $rootScope.selectedserialNumber = existingdevicetext.serial;
            $rootScope.selectednode = existingdevicetext.id;
            $scope.configdata.newdevicetext = "";
            $scope.configdata.existingdevicetextnew = {};
            $("#existingconfigpopup").modal('hide');
        }

        //Select All for Bulk
        $scope.selectAll = function (val) {
            $scope.selectAlltasks=val;
            if ($scope.tasksArray.length > 0) {
                for (var i = 0; i < $scope.tasksArray.length; i++) {
                    if (val) {
                        $scope.tasksArray[i].checked = true;
                    } else {
                        $scope.tasksArray[i].checked = false;
                    }

                }
            }
        }

        //Delete all method
        $scope.deleteAll = function () {
            var list = [];
            for (var i = 0; i < $scope.tasksArray.length; i++) {
                if ($scope.tasksArray[i].checked == true) {
                    list.push($scope.tasksArray[i].taskId);
                }

            }
            if (!list.length > 0) {
                $scope.showAlert('Warning', "No Task(s) selected!");
            } else {
                var url = 'api/v2/task/deletetasks';
                var status = 0;
                var confirm = $scope.deleteDialog('Do you wish to delete?');
                $mdDialog.show(confirm).then(function () {
                    list = JSON.stringify({ list });
                    $http({
                        method: 'POST',
                        url: url,
                        data: list,
                        headers: { 'Content-Type': 'application/json' }
                    }).success(function () {
                        $scope.showAlert('Success', "Deleted successfully!");
                        if ($scope.tasksArray[0].status == 'Successful') {
                            status = 2;
                        } else if ($scope.tasksArray[0].status == 'Failed') {
                            status = 3;
                        }
                        $scope.selectedstatus = status;
                        $scope.getTasks($scope.selectedPage, status);
                    }).error(function (msg) {
                        $scope.showAlert('Warning', 'Error occurred while deleting task due to : ' + msg);
                    });
                });
            }
        }

        // Form Selection
        $scope.showForm = function (selectedForm, obj) {

            $scope.basestations = [];
            if (selectedForm == 'createProfile') {
                $scope.selectedForm = selectedForm;
            } else if (selectedForm == 'editProfile') {
                $scope.selectedForm = selectedForm;
            } else if (selectedForm == 'retrieveProfile') {
                $scope.selectedForm = selectedForm;
            } else if (selectedForm == 'applyProfile') {
                if (obj.linkType) {
                    $scope.applyForm.linkTypeName = obj.linkTypeName;
                    $scope.applyForm.lType = obj.linkType;
                }
                if (obj.radioMode) {
                    $scope.applyForm.radioModeName = obj.radioModeName;
                    $scope.applyForm.rMode = obj.radioMode;
                }
                $scope.loadRegions();
                $scope.nodes = [];
                $scope.profile_name = obj.name;
                $scope.profileToApply = obj.id;
                $scope.selectedForm = selectedForm;
            } else if (selectedForm == 'uploadFirmware') {
                $scope.selectedForm = selectedForm;
                $scope.newFirmware = {};
                $scope.view_tasks = false;
            } else if (selectedForm == 'applyFirmwareForm') {
                $scope.nodes = [];
                $scope.loadRegions();
                $scope.view_tasks = false;
                $scope.applyFirmware = obj;
                $scope.applyFirmware['isImmediate'] = true;
                $scope.applyFirmware['sdate'] = '';
                $scope.selectedForm = selectedForm;
            } else if (selectedForm == 'bulkip_form' || selectedForm == 'breboot_form' || selectedForm == 'bconfback_form' || selectedForm == 'bchbass_form' || selectedForm == 'configchange_form' || selectedForm == 'bulkfirm_form') {
                $scope.selectedForm = selectedForm;
                $scope.isImmediate = true;
                $scope.applyConfig = {};
                $scope.applyConfig['isImmediate'] = false;//true;
                if(selectedForm=='bulkfirm_form'){
                    $scope.applyConfig['isImmediate'] = true;
                }
                $scope.applyConfig['sdate'] = '';
                $scope.applyFirmware = {};
                $scope.applyFirmware['isImmediate'] = false//true;
                $scope.applyFirmware['sdate'] = '';
                $scope.sdate = '';
                $scope.tasksArray = [];
                if (selectedForm == 'configchange_form') {
                    $scope.query = "";
                    $scope.getSingleConfigList();
                }
            } else if (selectedForm == 'create_vlan_profile') {

                $scope.selectedForm = selectedForm;
                $rootScope.profileID = "";
                $scope.$emit("init_vlan");
                $scope.isnameDisable = false;

            } else if (selectedForm == 'edit_vlan_profile') {
                $scope.selectedForm = selectedForm;
                $rootScope.profileID = obj.id;
                $scope.$emit("init_vlan");
                $scope.isnameDisable = true;

            } else if (selectedForm == 'create_ethernet_profile') {
                $scope.selectedForm = selectedForm;
                $rootScope.profileID = "";
                $scope.$emit("init_ethernet");
                $scope.isnameDisable = false;
            } else if (selectedForm == 'edit_ethernet_profile') {
                $scope.selectedForm = selectedForm;
                $rootScope.profileID = obj.id;
                $scope.$emit("init_ethernet");
                $scope.isnameDisable = true;
            } else if (selectedForm == 'create_radius_profile') {
                $scope.selectedForm = selectedForm;
                $rootScope.profileID = "";
                $scope.$emit("init_radius");
                $scope.isnameDisable = false;
            } else if (selectedForm == 'edit_radius_profile') {
                $scope.selectedForm = selectedForm;
                $rootScope.profileID = obj.id;
                $scope.$emit("init_radius");
                $scope.isnameDisable = true;
            } else if (selectedForm == 'create_dhcp_profile') {
                $scope.selectedForm = selectedForm;
                $rootScope.profileID = "";
                $scope.$emit("init_dhcp");
                $scope.isnameDisable = false;
            } else if (selectedForm == 'edit_dhcp_profile') {
                $scope.selectedForm = selectedForm;
                $rootScope.profileID = obj.id;
                $scope.$emit("init_dhcp");
                $scope.isnameDisable = true;
            } else if (selectedForm == 'create_wireless_profile') {
                $scope.selectedForm = selectedForm;
                $rootScope.profileID = "";
                $scope.$emit("init_wireless");
                $scope.isnameDisable = false;
            } else if (selectedForm == 'edit_wireless_profile') {
                $scope.selectedForm = selectedForm;
                $rootScope.profileID = obj.id;
                $scope.$emit("init_wireless");
                $scope.isnameDisable = true;
            } else if (selectedForm == 'create_ddrsatpc_profile') {
                $scope.selectedForm = selectedForm;
                $rootScope.profileID = "";
                $scope.$emit("init_ddrsatpc");
                $scope.isnameDisable = false;
            } else if (selectedForm == 'edit_ddrsatpc_profile') {
                $scope.selectedForm = selectedForm;
                $rootScope.profileID = obj.id;
                $scope.$emit("init_snmp");
                $scope.isnameDisable = true;
            } else if (selectedForm == 'create_snmp_profile') {
                $scope.selectedForm = selectedForm;
                $rootScope.profileID = "";
                $scope.$emit("init_snmp");
                $scope.isnameDisable = false;
            } else if (selectedForm == 'edit_snmp_profile') {
                $scope.selectedForm = selectedForm;
                $rootScope.profileID = obj.id;
                $scope.$emit("init_ddrsatpc");
                $scope.isnameDisable = true;
            }
            $scope.tableWidth = "col-md-7";
            $scope.openForm = true;

        }

        // Version check using Regex
        $scope.checkVersion = function (version, group, type) {
            var versionRegex = /^\d+\_\d+$/;
            if (type == 'version') {
                if (!version.match(versionRegex)) {
                    $scope.newFirmware.version = "";
                }
            }
        }

        $scope.delCancel = function (task) {
            var url = 'api/v2/task/canceltask/' + task.taskId;
            var status = 0;
            if (task.status == 'Successful' || task.status == 'Failed') {
                url = 'api/v2/task/deletetask/' + task.taskId;
            }
            var confirm = $scope.deleteDialog('Do you wish to delete the task?'); // Apply Profile Confirm Modal
            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: url,
                    headers: { 'Content-Type': 'application/json' }
                }).success(function () {
                    $scope.showAlert('Success', 'The task has been deleted/canceled.');
                    if (task.status == 'Successful') {
                        status = 2;
                    } else if (task.status == 'Failed') {
                        status = 3;
                    }
                    $scope.selectedstatus = status;
                    $scope.getTasks($scope.selectedPage, status);
                }).error(function (msg) {
                    $scope.showAlert('Warning', 'Error occurred while deleting task due to : ' + msg);
                });

            });

        }

        $scope.selectedstatus = 0;
        $scope.showAll = function () {
            for (var i = 0; i < $scope.status.length; i++) {
                $scope.status[i].status = false;
            }
            if ($scope.allToggle) {
                // $scope.allToggle=true;
                console.log("query " + $scope.selectedPage + " status" + 4)
                $scope.selectedstatus = 4;
                $scope.getTasks($scope.selectedPage, 4);
            } else {
                // $scope.allToggle=false;
                $scope.status[0].status = true;
                $scope.selectedstatus = 0;
                $scope.getTasks($scope.selectedPage, 0);
                console.log("query " + $scope.selectedPage + " status" + 0)
            }
        }

        $scope.taskDetails = function (status, data, index) {
            if (status == 4) {
                // if ($scope.status[0].status) {
                    for (var i = 1; i < $scope.status.length; i++) {
                        $scope.status[i].status = false;
                    }
                    $scope.status[0].status=true;
                    console.log("query " + $scope.selectedPage + " status" + 4)
                    $scope.selectedstatus = 4;
                    $scope.getTasks($scope.selectedPage, 4);
               // }
                // else {
                //     for (var i = 0; i < $scope.status.length; i++) {
                //         if (i != 1) {
                //             $scope.status[i].status = false;
                //         }
                //     }
                //     $scope.status[1].status = true;
                //     $scope.selectedstatus = 0;
                //     $scope.getTasks($scope.selectedPage, 0);
                //     console.log("query " + $scope.selectedPage + " status" + 0)
                // }
            } else {
                for (var i = 0; i < $scope.status.length; i++) {
                    if (i != index) {
                        $scope.status[i].status = false;
                    }
                }
                data.status = true;
                if (status == 1) {
                    $scope.tRemText = undefined;
                } else if (status == 2 || status == 3) {
                    $scope.tRemText = 'Delete';
                } else if (status == 0) {
                    $scope.tRemText = 'Cancel';
                }
                console.log("query " + $scope.selectedPage + " status" + status)
                $scope.selectedstatus = status;
                $scope.getTasks($scope.selectedPage, status);
            }
            $("#statusmenu").dropdown("toggle");
        }

        // $scope.taskDetails = function (status, data, index) {
        //     if (status == 4) {
        //         if ($scope.status[0].status) {
        //             for (var i = 1; i < $scope.status.length; i++) {
        //                 $scope.status[i].status = false;
        //             }
        //             console.log("query " + $scope.selectedPage + " status" + 4)
        //             $scope.selectedstatus = 4;
        //             $scope.getTasks($scope.selectedPage, 4);
        //         } else {
        //             for (var i = 0; i < $scope.status.length; i++) {
        //                 if (i != 1) {
        //                     $scope.status[i].status = false;
        //                 }
        //             }
        //             $scope.status[1].status = true;
        //             $scope.selectedstatus = 0;
        //             $scope.getTasks($scope.selectedPage, 0);
        //             console.log("query " + $scope.selectedPage + " status" + 0)
        //         }
        //         //$scope.status[0].status=true;

        //     } else {
        //         for (var i = 0; i < $scope.status.length; i++) {
        //             if (i != index) {
        //                 $scope.status[i].status = false;
        //             }
        //         }
        //         data.status = true;
        //         if (status == 1) {
        //             $scope.tRemText = undefined;
        //         } else if (status == 2 || status == 3) {
        //             $scope.tRemText = 'Delete';
        //         } else if (status == 0) {
        //             $scope.tRemText = 'Cancel';
        //         }
        //         console.log("query " + $scope.selectedPage + " status" + status)
        //         $scope.selectedstatus = status;
        //         $scope.getTasks($scope.selectedPage, status);
        //     }
        //     $("#statusmenu").dropdown("toggle");
        // }

        // Change page Size method
        $scope.changePageSize = function (pagesize) {
            $scope.currentpage = 1;
            $scope.pagesize = pagesize;
            if ($scope.selectedPage == 'firmwares') {
                var url = 'api/v2/firmware/firmwares?' + '&page=' + $scope.currentpage + '&limit=' + $scope.pagesize + '&sort=' + $scope.sortField + '.' + $scope.sortOrder;
                $http.get(url).then(function (response) {

                    $scope.firmwareArray = response.data;
                    $scope.TotalPages = response.data.length;
                    if (response.data.length < $scope.pagesize) {
                        $scope.nextBtnDisable = true;
                    } else {
                        $scope.nextBtnDisable = false;
                    }
                    if ($scope.firmwareArray == null) {
                        $scope.TotalPages = 0;

                    }
                    $scope.pagenumber = Math.ceil($scope.firmwareArray.length / $scope.pagesize);
                    if ($scope.pagenumber == 0) {
                        $scope.pagenumber = 1;
                    }
                });
            } else {
                var url = 'api/v2/profiles/template/list?ttype=' + $scope.ttype + '&ltype=' + $scope.ltype + '&rtype=' + $scope.rtype + '&page=' + $scope.currentpage + '&limit=' + $scope.pagesize + '&sort=' + $scope.sortField + '.' + $scope.sortOrder;
                $http.get(url).then(function (response) {
                    for (var i = 0; i < response.data.length; i++) {
                        for (var j = 0; j < $scope.linkType.length; j++) {
                            if (response.data[i].linkType == $scope.linkType[j].value) {
                                response.data[i].linkTypeName = $scope.linkType[j].name;
                            }
                        }
                        for (var k = 0; k < $scope.radioMode.length; k++) {
                            if (response.data[i].radioMode == $scope.radioMode[k].value) {
                                response.data[i].radioModeName = $scope.radioMode[k].name;
                            }
                        }
                    }
                    $scope.profileDataObj = response.data;
                    $scope.TotalPages = response.data.length;
                    if (response.data.length < $scope.pagesize) {
                        $scope.nextBtnDisable = true;
                    } else {
                        $scope.nextBtnDisable = false;
                    }
                    if ($scope.profileDataObj == null) {
                        $scope.TotalPages = 0;

                    }
                    $scope.pagenumber = Math.ceil($scope.profileDataObj.length / $scope.pagesize);
                    if ($scope.pagenumber == 0) {
                        $scope.pagenumber = 1;
                    }
                });
            }
        }

        // Paging method
        $scope.paging = function (type, totalPages, val) {

            if (val == 'previous') {
                --$scope.currentpage;
            } else if (val == 'next') {
                ++$scope.currentpage;
            }
            if ($scope.selectedPage == 'firmwares') {
                var url = 'api/v2/firmware/firmwares?' + '&page=' + $scope.currentpage + '&limit=' + $scope.pagesize + '&sort=' + $scope.sortField + '.' + $scope.sortOrder;
                $http.get(url).then(function (response) {

                    $scope.firmwareArray = response.data;

                    if (val == "next") {
                        if (response.data.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        }
                    } else {
                        if (response.data.length >= $scope.pagesize) {
                            $scope.nextBtnDisable = false;
                        }
                    }

                });
            } else {
                var url = 'api/v2/profiles/template/list?ttype=' + $scope.ttype + '&ltype=' + $scope.ltype + '&rtype=' + $scope.rtype + '&page=' + $scope.currentpage + '&limit=' + $scope.pagesize + '&sort=' + $scope.sortField + '.' + $scope.sortOrder;
                $http.get(url).then(function (response) {
                    for (var i = 0; i < response.data.length; i++) {
                        for (var j = 0; j < $scope.linkType.length; j++) {
                            if (response.data[i].linkType == $scope.linkType[j].value) {
                                response.data[i].linkTypeName = $scope.linkType[j].name;
                            }
                        }
                        for (var k = 0; k < $scope.radioMode.length; k++) {
                            if (response.data[i].radioMode == $scope.radioMode[k].value) {
                                response.data[i].radioModeName = $scope.radioMode[k].name;
                            }
                        }
                    }
                    $scope.profileDataObj = response.data;

                    if (val == "next") {
                        if (response.data.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        }
                    } else {
                        if (response.data.length >= $scope.pagesize) {
                            $scope.nextBtnDisable = false;
                        }
                    }

                });
            }
        }

        // Sort method
        $scope.sort = function (sortField) {
            $scope.currentpage = 1;
            if (sortField == $scope.sortField) {
                $scope.sortOrder = $scope.sortOrder == 'asc' ? 'desc' : 'asc';
            } else {
                $scope.sortField = sortField;
                $scope.sortOrder = 'asc';
            }
            if ($scope.selectedPage == 'firmwares') {
                $scope.getFirmwares();
            } else {
                $scope.getProfilesData($scope.ttype);
            }
        }



        // Profiles Start

        // Radio Mode Filter for the profiles table
        $scope.rmodeFilterApply = function (rtype) {
            $scope.rtype = rtype.value;
            $scope.getProfilesData($scope.ttype);
        }

        // Link Type Filter for the profiles table
        $scope.ltypeFilterApply = function (ltype) {

            if (ltype.value != 'All') {
                $scope.ltype = ltype.value;
                $scope.getProfilesData($scope.ttype);
            } else {
                $scope.ltype = -1;
                $scope.getProfilesData($scope.ttype);
            }
        }





        $scope.getTaskData = function (ttype) {
            $http.get('api/v2/task/list?page=0&limit=10&show=all', {
                showdiv: false
            })
                .success(function (response) {
                    $scope.tasksArray = response;

                });
        }

        $scope.attachedFile = function (element) {
            $scope.$apply(function ($scope) {
                $scope.file = element.files[0];
                $scope.uploadedFileName = element.files[0].name;
            });
            console.log('file attached');
        };

        /*$scope.clickUploadFunc = function() {
            var confirm = scope.uploadConfirm();
            var fileExtension = scope.fileName.split('.');
            if (fileExtension[1] == 'csv' || fileExtension[1] == 'CSV') {
                var url = 'admin/discovery/scanUploadConfig?action=UploadIncludeRange';
                var fd = new FormData();
                fd.append("upfile", scope.uploadedFile);
                var request = {
                    method: 'POST',
                    url: 'admin/discovery/scanUploadConfig?action=UploadIncludeRange',
                    data: fd,
                    headers: {
                        'Content-Type': undefined
                    }
                };
                $http(request)
                    .success(function(data, status, headers, config) {
                        scope.showAlert('Success', 'Uploaded Successfully.');
                        scope.fileName = "";
                    })
                    .error(function(data, status, headers, config) {
                        console.log('error');
                        if (status == 403) {
                            scope.showAlert('Error', 'Upload failed due to unautherized access.');
                        } else {
                            scope.showAlert('Error', 'Uploaded Failed.');
                        }

                    })
            } else {
                scope.showAlert('Error', "File Extension Not Supported");
            }
        };*/

        //Get Profiles for the table
        $scope.getProfilesData = function (ttype) {

            $scope.ttype = ttype;
            if (!$scope.rtype || !$scope.ltype || !$scope.sortField || !$scope.sortOrder) {
                $scope.rtype = -1;
                $scope.ltype = -1;
                $scope.sortField = 'name';
                $scope.sortOrder = 'asc';
                //$scope.reverse = true;
            }

            var url = 'api/v2/profiles/template/list?ttype=' + $scope.ttype + '&ltype=' + $scope.ltype + '&rtype=' + $scope.rtype + '&page=' + $scope.currentpage + '&limit=' + $scope.pagesize + '&sort=' + $scope.sortField + '.' + $scope.sortOrder;


            $http.get(url).then(function (response) {
                for (var i = 0; i < response.data.length; i++) {
                    for (var j = 0; j < $scope.linkType.length; j++) {
                        if (response.data[i].linkType == $scope.linkType[j].value) {
                            response.data[i].linkTypeName = $scope.linkType[j].name;
                        }
                    }
                    for (var k = 0; k < $scope.radioMode.length; k++) {
                        if (response.data[i].radioMode == $scope.radioMode[k].value) {
                            response.data[i].radioModeName = $scope.radioMode[k].name;
                        }
                    }
                }
                $scope.profileDataObj = response.data;
                if (response.data.length < $scope.pagesize) {
                    $scope.nextBtnDisable = true;
                }
                $scope.TotalPages = response.data.length;
                if ($scope.profileDataObj == null) {
                    $scope.TotalPages = 0;
                }
                $scope.pagenumber = Math.ceil($scope.profileDataObj.length / $scope.pagesize);
                if ($scope.pagenumber == 0) {
                    $scope.pagenumber = 1;
                }
            });
        }

        // Get Devices for apply firmware based on search
        $scope.searchDevices = function (searchName) {
            if (!searchName) {
                searchName = '';
            }
            if (!$scope.DynamicUrl) {
                $scope.DynamicUrl = '';
            }
            loadAllNodes(searchName, $scope.DynamicUrl);
        }

        // Load firmwares for apply firmware based on criteria
        function loadAllNodes(searchName, DynamicUrl) {
            var config = {
                params: {
                    'limit': $scope.limit,
                    '_s': 'productCode==ptp,productCode==ptmp,productCode==indoorap,productCode==outdoorap'
                }
            };
            //latest url
            var url = 'api/v2/treeview/facility/' + $scope.facility + '/nodes?show=' + $scope.applyForm.rMode + '&link=' + $scope.applyForm.lType
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.nodesToApply = [];
                        $scope.nodes = response.data;
                    }
                });
        }

        // Apply profile Modal
        $scope.applyProfileConfirm = function (ev) {
            if($scope.selectedForm=='bulkfirm_form'){
                var label='Are you sure you want to upgrade firmare?';
            }else{
                var label='Are you sure you want to apply this profile?';
            }
            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title(label)
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };

        // Apply Profile
        $scope.apply_profile = function () {
            if ($scope.profileToApply === '' || $scope.nodesToApply.length === 0) {
                $scope.showAlert('error', 'Select a profile and nodes to apply');
                return;
            }
            var confirm = $scope.applyProfileConfirm(); // Apply Profile Confirm Modal
            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/profiles/' + $scope.profileToApply + '/applyToNodes',
                    headers: { 'Content-Type': 'application/json' },
                    data: $scope.nodesToApply
                }).success(function () {
                    $scope.showAlert('Success', 'The profile has been initiated to apply for the selected nodes.');
                    $scope.toggleForm();
                    $scope.profileToApply = '';
                    $scope.nodesToApply = [];
                    $scope.nodes = [];
                    $('#nodesToApply').val("");
                }).error(function (msg) {
                    $scope.showAlert('Error', 'Cannot apply the profile: ' + msg);
                });
            });
        };

        // Delete Profile Confirm
        $scope.deleteProfileConfirm = function (ev) {

            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Are you sure you want to delete this profile?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };

        // Delete Profile
        $scope.deleteProfile = function (obj) {
            var confirm = $scope.deleteProfileConfirm();
            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'DELETE',
                    url: 'api/v2/profiles/' + obj.id
                }).success(function () {
                    $scope.showAlert('Success', 'The profile has been deleted successfully.');
                    defaultCall();
                }).error(function (msg) {
                    $scope.showAlert('Error', 'Error deleting the profile: ' + msg);
                });
            });
        }

        // Profiles End

        // Firmware Start

        // Upload Firmware Modal
        // Upload firmware Function is in the directive code
        $scope.uploadFirmwareConfirm = function (ev) {

            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Are you sure you want to upload this firmware?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };

        $scope.showTasks = function (tasktype) {
            $http.get('api/v2/task/list?show=all', {
                showdiv: false
            })
                .success(function (response) {
                    $scope.tasksArray = response;

                });
        }

        $scope.selectedarray=[];
        $scope.selectedtasks=function(task){
            if(task.checked){
                $scope.selectedarray.push(task);
            }else{
                if($scope.selectedarray.length>0){
                    for(var i=0;i<$scope.selectedarray.length;i++){
                        if($scope.selectedarray[i].taskId==task.taskId){
                            $scope.selectedarray.splice(i,1);
                        }
                    }
                }
            }
        }

        $scope.getTasks = function (tasktype, status) {
            if (tasktype == 'bulkip') {
                tasktype = "ipClass";
            } else if (tasktype == 'breboot') {
                tasktype = "rebootClass";
            } else if (tasktype == 'bconfback') {
                tasktype = "confDownClass";
            } else if (tasktype == 'bchpassbulk') {
                tasktype = "passwordClass";
            } else if (tasktype == 'bulkfirm') {
                tasktype = "firmwareClass";
            }

            /*public static final String CLASS_IP = "ipClass";
                public static final String CLASS_PASSWORD = "passwordClass";
                public static final String CLASS_REBOOT = "rebootClass";
                public static final String CLASS_FIRMWARE = "firmwareClass";
                public static final String CLASS_CONFDOWN = "confDownClass";*/

            var url='api/v2/task/list?show=' + tasktype + '&status=' + status + '&offset=' + (($scope.currentpagebulk-1)*$scope.pagesizebulk) + '&count=' + $scope.pagesizebulk;
            $http.get(url, {
                showdiv: false
            })
                .success(function (response) {
                    $scope.tasksArray = response;
                    if($scope.selectAlltasks){
                        for (var i = 0; i < $scope.tasksArray.length; i++) {
                            $scope.tasksArray[i].checked = true;
                        }
                    }
                    if($scope.selectedarray.length>0){
                        for(var j=0;j<$scope.selectedarray.length;j++){
                            for (var i = 0; i < $scope.tasksArray.length; i++) {
                                if ($scope.tasksArray[i].taskId == $scope.selectedarray[j].taskId) {
                                    $scope.tasksArray[i].checked = true;
                                }
                            }
                        }
                    }
                    if ($scope.selectedtaskid != '') {
                        for (var i = 0; i < $scope.tasksArray.length; i++) {
                            if ($scope.tasksArray[i].taskId == $scope.selectedtaskid) {
                                $scope.tasksArray[i].collapse = '';
                            }
                        }
                    }
                    if ($scope.tasksArray.length < $scope.pagesizebulk) {
                        $scope.nextBtnDisablebulk = true;
                    } else {
                        $scope.nextBtnDisablebulk = false;
                    }
                    $scope.stopTimer();
                    if ($scope.selectedPage == 'bulkip' || $scope.selectedPage == 'breboot' || $scope.selectedPage == 'bconfback' || $scope.selectedPage == 'configpush' || $scope.selectedPage == 'bchpassbulk' || $scope.selectedPage == 'bulkfirm') {
                         $scope.DataTimer = $interval(function () {
                         $scope.getTasks($scope.selectedPage, $scope.selectedstatus); }, 10000);
                    }
//                    if ($scope.selectedPage == 'bulkip' || $scope.selectedPage == 'breboot' || $scope.selectedPage == 'bconfback' || $scope.selectedPage == 'configpush' || $scope.selectedPage == 'bchpassbulk' || $scope.selectedPage == 'bulkfirm') {
//                        setTimeout(function () {
//                            console.log("timer getTaskks");
//                            $scope.getTasks($scope.selectedPage, $scope.selectedstatus);
//                        }, 4000);
//                    }
                });
        }


        $scope.changePageSizebulk = function (pagesizebulk) {
            $scope.currentpagebulk = 1;
            $scope.pagesizebulk = pagesizebulk;
            $scope.getTasks($scope.selectedPage, $scope.selectedstatus);
        }

        // Paging method
        $scope.pagingbulk = function (type, totalPagesbulk, val) {
            if (val == 'previous') {
                --$scope.currentpagebulk;
            } else if (val == 'next') {
                ++$scope.currentpagebulk;
            }
            $scope.getTasks($scope.selectedPage, $scope.selectedstatus);
        }


        $scope.allFirmwares = function () {

            if (!$scope.sortField || !$scope.sortOrder) {
                $scope.sortField = 'fileName';
                $scope.sortOrder = 'asc';
            }

            $scope.selectedFirmware = { "fileName": "Select", "bindName": "Select" };

            $http.get('api/v2/firmware/firmwares?&page=-1&limit=-1&sort=fileName.asc')
                .success(function (response) {
                    /*for (var i = 0 ; i< response.data.length; i++) {
                       // var json =
                        $scope.selectFirms.push(response.data[i]);
                    }*/
                    $scope.selectFirms = response;
                    for (var j = 0; j < $scope.selectFirms.length; j++) {
                        $scope.selectFirms[j].bindName = $scope.selectFirms[j].fileName + ' ( ' + $scope.selectFirms[j].version + ' ) ';
                    }
                    $scope.selectFirms.unshift($scope.selectedFirmware);
                    //$scope.upgradeForm.selectedFirmware = $scope.firmwareArray[0];

                });
        }

        $scope.selectedParam = function (config) {
            $scope.singleConfig.dName = config.dName;
            $scope.singleConfig.pValues = config.pValues;
            $scope.singleConfig.key = config.command;
            $scope.query = config.dName;
        }

        $scope.getSingleConfigList = function () {



            $scope.selectedConfigs = { "fileName": "Select", "bindName": "Select" };

            $http.get('api/v2/profiles/ucilist')
                .success(function (response) {
                    /*for (var i = 0 ; i< response.data.length; i++) {
                       // var json =
                        $scope.selectFirms.push(response.data[i]);
                    }*/

                    $scope.sconfig = response;
                    console.log('single conigs')
                    //$scope.upgradeForm.selectedFirmware = $scope.firmwareArray[0];

                });
        }

        // Get Firmwares to load in table
        $scope.getFirmwares = function () {
            if (!$scope.sortField || !$scope.sortOrder) {
                $scope.sortField = 'fileName';
                $scope.sortOrder = 'asc';
            }
            $http.get('api/v2/firmware/firmwares?' + '&page=' + $scope.currentpage + '&limit=' + $scope.pagesize + '&sort=' + $scope.sortField + '.' + $scope.sortOrder)
                .success(function (response) {
                    $scope.firmwareArray = response;
                    if ($scope.firmwareArray.length < $scope.pagesize) {
                        $scope.nextBtnDisable = true;
                    }else{
                        $scope.nextBtnDisable = false;
                    }
                });
//            $http.get('api/v2/task/list?page=0&limit=10&show=all', {
//                showdiv: false
//            })
//                .success(function (response) {
//                    $scope.tasksArray = response;
//                });
        }

        $scope.selectedtaskid = '';
        $scope.selectedbulkarray=[];
        $scope.onTaskSelect = function (task, ev) {
            $scope.selectedtaskid ='';
            var field = ev.target.id;
            if (!field == 'inId' || !field == 'delId' || field == "") {
                if ($scope.tasksArray && $scope.tasksArray.length > 0) {
                    var c = task.collapse;
                    for (var i = 0; i < $scope.tasksArray.length; i++) {
                        $scope.tasksArray[i].collapse = "collapse";
//                        if (c != "" && task.taskId == $scope.tasksArray[i].taskId) {
                        if (task.taskId == $scope.tasksArray[i].taskId) {
                            $scope.tasksArray[i].collapse = "";
                            $scope.selectedtaskid = task.taskId;
//                            $scope.selectedbulkarray = task.taskDetails;
//                               $("#bulkconfigpopup").modal('show');
                        }
                    }
                }
            }
        }

        $scope.onTaskSelectpopup=function(task, ev){
           $http.get('api/v2/task/tdetails?taskId=' + task.taskId)
                .success(function (response) {
                   $scope.selectedbulkarray = response.taskDetails;
                   console.log("selectedbulkarray", $scope.selectedbulkarray);
                    $("#bulkconfigpopup").modal('show');
                });
        }

        // Get Devices for apply firmware based on search
        $scope.searchFirmwareNodes = function (searchName) {
            if (!searchName) {
                searchName = '';
            }
            if (!$scope.DynamicUrl) {
                $scope.DynamicUrl = '';
            }
            loadFirmwareNodes(searchName, $scope.DynamicUrl);
        }

        // Load firmwares for apply firmware based on criteria
        function loadFirmwareNodes(searchName, DynamicUrl) {
            var config = {
                params: {
                    'limit': $scope.limit,
                    '_s': 'productCode==ptp,productCode==ptmp,productCode==indoorap,productCode==outdoorap'
                }
            };
            var url = 'api/v2/treeview/facility/' + $scope.facility + '/nodes';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.nodesToApply = [];
                        $scope.nodes = response.data;
                    }
                });
        }

 $scope.managementMasking = function (inputid, maskid) {
      var x = document.getElementById(inputid);
      var y = document.getElementById(maskid);
      if (x.type === "password") {
        x.type = "text";
        y.src = "./images/eye.png";
      } else {
        x.type = "password";
        y.src = "./images/eye-slash.png";
      }
    }

        // Apply Firmware Modal
        $scope.applyFirmwareConfirm = function (ev) {

            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Are you sure you want to apply this firmware?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };

        $scope.apply_firmware1 = function (firmware) {
            $scope.apply_firmware(firmware.actualName);
        }

        $scope.stateChanged = function () {
            if ($scope.isImmediate == true) {
                $scope.isImmediate = false;
            } else if ($scope.isImmediate == false) {
                $scope.isImmediate = true;
            }
        }

        // Apply Firmware
        $scope.apply_firmware = function (firmware) {
            // $scope.nodesToApply = angular.element($('#nodesToApply')).val();
            if (firmware === '' || $scope.nodesToApply.length === 0) {
                // if no nodes are selected
                $scope.showAlert('error', 'Select Firmware and nodes to apply');
                return;
            }
            var imm = 'lat';
            var sdate = new Date().getTime();
            if ($scope.applyConfig.isImmediate) {
                imm = 'im';
                sdate = new Date().getTime();
            } else {
		    if($scope.applyConfig.sdate){
		        sdate = new Date($scope.applyConfig.sdate).getTime();
		    }
            }
            var url = 'api/v2/bulk/applyFirmware/' + imm + '/' + sdate + '/?firmware=' + firmware;
            var confirm = $scope.applyFirmwareConfirm(); // Apply Firmware Confirm Modal
            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: url,
                    headers: { 'Content-Type': 'application/json' },
                    data: $scope.nodesToApply
                }).success(function () {
                    $scope.showAlert('Success', 'The firmware has been initiated to apply for the selected nodes.');
                    //$scope.toggleForm();
                    //$scope.view_tasks = true;
                    $scope.applyFirmware = {}; // Clear the form
                    $scope.nodesToApply = [];   // Clear nodes selection
                    $scope.nodes = []; // Clear nodes
                    $('#nodesToApply').val("");

                }).error(function (msg) {
                    $scope.showAlert('Error', 'Cannot apply the firmware: ' + msg);
                });
            });
        };

        $scope.configPush = function (firmware) {
            // $scope.nodesToApply = angular.element($('#nodesToApply')).val();
            if ($scope.nodesToApply.length === 0) {
                // if no nodes are selected
                $scope.showAlert('error', 'configure param and nodes to apply');
                return;
            }
            var imm = 'lat';
            var sdate = new Date().getTime();
            if ($scope.applyFirmware.isImmediate) {
                imm = 'im';
                sdate = new Date().getTime();
            } else {
                sdate = new Date($scope.applyFirmware.sdate).getTime();
            }
            var url = 'api/v2/bulk/pushconfig/' + imm + '/' + sdate + '/?key=' + $scope.singleConfig.key + '&val=' + $scope.singleConfig.value;
            var confirm = $scope.applyProfileConfirm(); // Apply Firmware Confirm Modal
            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: url,
                    headers: { 'Content-Type': 'application/json' },
                    data: $scope.nodesToApply
                }).success(function () {
                    $scope.showAlert('Success', 'The Task has been successfully created.');
                    $scope.toggleForm();
                    $scope.view_tasks = true;
                    $scope.applyFirmware = {}; // Clear the form
                    $scope.nodesToApply = [];   // Clear nodes selection
                    $scope.nodes = []; // Clear nodes
                    $('#nodesToApply').val("");
                    $scope.getTasks($scope.selectedPage, $scope.selectedstatus);
                }).error(function (msg) {
                    $scope.showAlert('Error', 'failed to create task due to: ' + msg);
                });
            });
        };

        // Delete Firmware
        $scope.deleteFirmware = function (obj) {
            var confirm = $scope.deleteFirmwareConfirm();
            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    //url: 'api/v2/firmware/' + obj.fileName
                    url: 'api/v2/firmware/delete?firmware=' + obj.actualName
                }).success(function () {
                    $scope.showAlert('Success', 'The firmware has been deleted successfully.');
                    $scope.getFirmwares();
                }).error(function (msg) {
                    $scope.showAlert('Error', 'Error deleting the firmware: ' + msg);
                });
            });
        }

        // Delete Firmware Modal
        $scope.deleteFirmwareConfirm = function (ev) {

            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Are you sure you want to delete this firmware?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };

        // Firmware End

        // Node Selection for Apply
        $scope.selectedDevice = function (deviceID) {
            //$scope.nodesToApply = [];
            // for(var i=0;i<$scope.basestations.length;i++){
            //     $scope.basestations[i].selected="";
            // }
            if (deviceID.selected == "") {
                deviceID.selected = 'trselected';
                $scope.nodesToApply.push(deviceID.data.id);
            } else {
                deviceID.selected = '';
                var remo = -1;
                for (var i = 0; i < $scope.nodesToApply.length; i++) {
                    if ($scope.nodesToApply[i] == deviceID.data.id) {
                        $scope.nodesToApply.splice(i, 1);
                        i--;
                    }
                }
            }
            // if($scope.nodesToApply.length==0){
            //     $scope.check.rebootselect=false;
            // }
            if ($scope.nodesToApply.length == $scope.basestations.length) {
                $scope.check.rebootselect = true;
            } else {
                $scope.check.rebootselect = false;
            }
        }

        $scope.selectedDeviceHardware = function (deviceID) {
            $scope.nodesToApply = [];
            for(var i=0;i<$scope.basestations.length;i++){
                $scope.basestations[i].selected="";
                 $scope.basestations[i].checkeddata = false;
            }
            if (deviceID.selected == "") {
                deviceID.selected = 'trselected';
                $scope.nodesToApply.push(deviceID.data.id);
            } else {
                deviceID.selected = '';
                var remo = -1;
                for (var i = 0; i < $scope.nodesToApply.length; i++) {
                    if ($scope.nodesToApply[i] == deviceID.data.id) {
                        $scope.nodesToApply.splice(i, 1);
                        i--;
                    }
                }
            }
            // if($scope.nodesToApply.length==0){
            //     $scope.check.rebootselect=false;
            // }
            if ($scope.nodesToApply.length == $scope.basestations.length) {
                $scope.check.rebootselect = true;
            } else {
                $scope.check.rebootselect = false;
            }
        }
        $scope.check = {};
        $scope.check.rebootselect = false;
        $scope.selctAllReboot = function () {
            if ($scope.check.rebootselect) {
                $scope.nodesToApply = [];
                for (var i = 0; i < $scope.basestations.length; i++) {
                    $scope.basestations[i].selected = 'trselected';
                    $scope.basestations[i].checkeddata = true;
                    $scope.nodesToApply.push($scope.basestations[i].data.id);
                }
            } else {
                $scope.nodesToApply = [];
                for (var i = 0; i < $scope.basestations.length; i++) {
                    $scope.basestations[i].selected = '';
                    $scope.basestations[i].checkeddata = false;
                }
            }
        }

        // Load Regions for Apply form
        $scope.loadRegions = function () {
            var url = 'api/v2/treeview/regions';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.basestation = response.data;
                        $scope.regions = response.data;
                    }
                });
        }

        // On Region Change, Load Locations of selected region
        $scope.regionChange = function (regionId) {
            $scope.DynamicUrl = "&ar=reg&facilities=" + regionId.data.id;
            $scope.facility = regionId.data.id;
            var url = 'api/v2/treeview/regions/' + regionId.data.id + '/locations';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.locations = response.data;
                        $scope.facilities = "";
                        $scope.basestations=[];
                    }
                });
        }

        // On Location Change, Load Facilities of selected location
        $scope.locationChange = function (locationID) {
            $scope.DynamicUrl = "&ar=loc&facilities=" + locationID.data.id;
            $scope.facility = locationID.data.id;

            var url = 'api/v2/treeview/locations/' + locationID.data.id + '/facilities';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.facilities = response.data;
                        $scope.basestations=[];
                        //                                $scope.div_select = srcval;
                    }
                });
        }

        // On Facility Change, Load Nodes of selected Facility
        $scope.facilityChange = function (facilityId) {
            /* var rm = 'ap';
             if (radioMode == 'SU') {
                 rm = 'sta';
             }

             var lt = linkType.toLowerCase();*/
            $scope.basestations = [];
            $scope.nodesToApply = [];
            $scope.DynamicUrl = "&ar=fac&facilities=" + facilityId.data.id;
            $scope.facility = facilityId.data.id;
            facilityId = facilityId.data.id;
            var url = 'api/v2/treeview/facility/' + facilityId + '/treenodes';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        //$scope.basestations = response.data;
                        for (var i = 0; i < response.data.length; i++) {
                            console.log(response.data[i].text);
                            response.data[i].selected = "";
                            response.data[i].checkeddata = false;
                            $scope.basestations.push(response.data[i]);
                            if (response.data[i].children.length > 0) {
                                var child = response.data[i].children;
                                for (var j = 0; j < child.length; j++) {
                                    console.log(child[j].text);
                                    child[j].selected = "";
                                    $scope.basestations.push(child[j]);
                                }
                            } /*else {
                                console.log(response.data[i].text);
                            }*/
                        }
                    }
                });
        }

        //new
        $scope.locationsnew = [];
        $scope.facilitiesnew = [];
        $scope.regionChangenew = function (regionId) {
            $scope.DynamicUrl = "&ar=reg&facilities=" + regionId.data.id;
            $scope.facility = regionId.data.id;
            var url = 'api/v2/treeview/regions/' + regionId.data.id + '/locations';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.locationsnew = response.data;
                        $scope.basestationsnew=[];
                        $scope.facilitiesnew = "";
                    }
                });
        }

        $scope.locationChangenew = function (locationID) {
            $scope.DynamicUrl = "&ar=loc&facilities=" + locationID.data.id;
            $scope.facility = locationID.data.id;
            var url = 'api/v2/treeview/locations/' + locationID.data.id + '/facilities';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.facilitiesnew = response.data;
                        $scope.basestationsnew=[];
                    }
                });
        }

        // On Facility Change, Load Nodes of selected Facility
        $scope.facilityChangenew = function (facilityId) {
            $scope.basestationsnew = [];
            $scope.nodesToApplynew = [];
            $scope.DynamicUrl = "&ar=fac&facilities=" + facilityId.data.id;
            $scope.facility = facilityId.data.id;
            facilityId = facilityId.data.id;
            var url = 'api/v2/treeview/facility/' + facilityId + '/treenodes';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        for (var i = 0; i < response.data.length; i++) {
                            response.data[i].selected = "";
                            $scope.basestationsnew.push(response.data[i]);
                            if (response.data[i].children.length > 0) {
                                var child = response.data[i].children;
                                for (var j = 0; j < child.length; j++) {
                                    child[j].selected = "";
                                    $scope.basestationsnew.push(child[j]);
                                }
                            }
                        }
                    }
                });
        }

        $scope.selectedDevicenew = function (deviceID) {
            $scope.nodesToApplynew=[];
            for(var i=0;i<$scope.basestationsnew.length;i++){
                $scope.basestationsnew[i].selected="";
            }
            if (deviceID.selected == "") {
                deviceID.selected = 'trselected';
                $scope.nodesToApplynew.push(deviceID.data.id);
            } else {
                deviceID.selected = '';
                var remo = -1;
                for (var i = 0; i < $scope.nodesToApplynew.length; i++) {
                    if ($scope.nodesToApplynew[i] == deviceID.data.id) {
                        $scope.nodesToApplynew.splice(i, 1);
                        i--;
                    }
                }
            }
        }

        $scope.replaceHardware = function () {
            if ($scope.nodesToApply.length > 0 && $scope.nodesToApplynew.length > 0) {
                var from = $scope.nodesToApply[0];
                var to = $scope.nodesToApplynew[0];
                $http({
                    method: 'POST',
                    url: 'api/v2/profiles/rephard/' + from + '/' + to,
                }).success(function () {
                    $scope.showAlert('success', 'Saved Successfully');
                    $scope.basestation = [];
                    $scope.locations = [];
                    $scope.facilities = [];
                    $scope.locationsnew = [];
                    $scope.facilitiesnew = [];
                    $scope.basestations = [];
                    $scope.basestationsnew = [];
                    $scope.hwreplacenew = {};
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error updating data: ' + msg);
                });
            } else {
                $scope.showAlert('Error', 'Select hardware');
            }
        }

        // Toggle Form to open and close form
        $scope.toggleForm = function () {
            $scope.selectedForm = "";
            $scope.openForm = false;
            $scope.basestations = [];
            $scope.sconfig = {};
            $scope.singleConfig = {};
            $scope.tableWidth = "col-lg-12 col-md-12 col-sm-12 col-xs-12";
        }

        // Toggle Form to open and close form for other controllers
        $rootScope.$on("toggleFormFunction", function () {
            $scope.selectedForm = "";
            $scope.openForm = false;
            $scope.tableWidth = "col-lg-12 col-md-12 col-sm-12 col-xs-12";
        });

        $scope.selectedRow = null; // initialize selected row to null

        // Selected Row function
        $scope.setClickedRow = function (index) {
            $scope.selectedRow = index;
        }

        // Show Alert function for controller
        $scope.showAlert = function (msgType, msg, ev) {
            $mdDialog.show(
                $mdDialog.alert()
                    .parent(angular.element(document.querySelector('#popupContainer')))
                    .clickOutsideToClose(true)
                    .title(msgType)
                    .textContent(msg)
                    .ariaLabel('Alert')
                    .ok('OK')
                    .targetEvent(ev)
            );
        };

        // Accordian Function
        $(document).ready(function () {
            $("#accordian a").click(function () {

                var link = $(this);
                var closest_ul = link.closest("ul");
                var parallel_active_links = closest_ul.find(".active")
                var closest_li = link.closest("li");
                var link_status = closest_li.hasClass("active");
                var count = 0;

                closest_ul.find("ul").slideUp(function () {
                    if (++count == closest_ul.find("ul").length)
                        parallel_active_links.removeClass("active");
                });
                if (!link_status) {
                    closest_li.children("ul").slideDown();
                    closest_li.addClass("active");

                }
                $('.activeItem').click(function (e) {
                    $('.activeItem').css("background-color", "white", "color", "black");
                    $(this).css("background-color", "#f6f6f6", "color", "white", "font-weight", "bold");
                });
            })
        });

        // Old Profiles and Firmwares Start
        $scope.profiles = [];
        $scope.newProfile = {
            'name': '',
            'ssid': '',
            'opMode': '',
            'bandwidth': '',
            'channel': '',
            'minimumFirmware': '',
            'nmsServerAddress': '',
            'tftpServerAddress': ''
        };
        $scope.nodeProfile = {};
        $scope.profileToApply = '';
        $scope.nodesToApply = [];
        $scope.nodes = [];
        $scope.fileData = {};

        // init function
        $scope.init = function () {
            $scope.loadProfiles();
            $scope.getVlanProfiles();
            $scope.toggleForm();
        }

        /* PROFILES -- START */
        // ??
        $scope.getServerAddress = function () {
            $http.get('api/v2/profiles/serveraddress')
                .success(function (msg) {
                    $scope.vm.serveraddress = msg;
                });
        };

        // Load Profiles
        $scope.loadProfiles = function () {
            var paramObj = { 'params': { 'limit': 0 } };
            $http.get('api/v2/profiles', paramObj)
                .success(function (result) {

                    $scope.profiles = result.profile;
                })
                .error(function (msg) {
                    $scope.showAlert('error', msg);
                });
        };

        // Retreive Profiles
        $scope.retrieveProfile = function (nodeId) {
            var configObj = {
                'params': {
                    'nodeId': nodeId
                }
            };
            $http.get('api/v2/profiles/retrieveProfile', configObj)
                .then(function (response) {
                    if (response.status === 200) {
                        $scope.showAlert('Success', 'Successfully retrieved profile to server.');
                    }
                })
                .catch(function (response) {
                    if (response.data['errorMessage']) {
                        $scope.showAlert('Error', response.data['errorMessage']);
                    } else {
                        $scope.showAlert('Error', 'Error retrieving profile.');
                    }
                });
        };

        // Populate profile of device
        $scope.populateFormWithProfile = function (nodeId) {
            var configObj = {
                'params': {
                    'nodeId': nodeId
                }
            };
            $http.get('api/v2/profiles/extractProfile', configObj)
                .then(function (response) {
                    if (response.data) {
                        $scope.newProfile.ssid = response.data['ssid'];
                        $scope.newProfile.opMode = response.data['opModeId'];
                        $scope.newProfile.bandwidth = response.data['bandwidthId'];
                        $scope.newProfile.channel = response.data['channel'];
                        $scope.newProfile.nmsServerAddress = response.data['host'];
                        $scope.newProfile.tftpServerAddress = response.data['passwd'];
                        $scope.vm.serveraddress = response.data['serveraddress'];
                    }
                })
                .catch(function (response) {
                    if (response.data['errorMessage']) {
                        $scope.showAlert('error', response.data['errorMessage']);
                    } else {
                        $scope.showAlert('error', 'Error retrieving profile.');
                    }
                });
        };

        // Save profile
        $scope.saveProfile = function () {
            if ($scope.useConfiguredAddress == true) {
                $scope.newProfile.nmsServerAddress = $scope.vm.serveraddress;
            }

            $http({
                method: 'POST',
                url: 'api/v2/profiles',
                headers: { 'Content-Type': 'application/json' },
                data: $scope.newProfile
            }).success(function () {
                $scope.showAlert('Success', 'The profile has been created successfully.');
                $scope.newProfile = {};
                $scope.loadProfiles();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating the profile: ' + msg);
            });
        };

        $scope.deleteDialog = function (msg, ev) {
            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title(msg)
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No');

            return confirm;
        };

        // Profile delete modal
        $scope.deleteConfirm = function (profileId, ev) {
            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Are you sure you want to delete this profile?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No');

            $mdDialog.show(confirm).then(function () {
                $scope.deleteProfile(profileId);
            });
        };
        /* PROFILES -- END */

        /* FIRMWARES -- START */
        // Attach a firmware file to upload
        $scope.attachedFile1 = function (element) {
            $scope.$apply(function ($scope) {
                $scope.file = element.files[0];
            });
            console.log('file attached');
        };

        // Upload Firmware
        $scope.uploadFirmware = function () {
            var confirm = $scope.uploadFirmwareConfirm();
            $mdDialog.show(confirm).then(function () {
                var fileExtension = $scope.newFirmware.firmwareFile.name.split('.');
                if (fileExtension[1] == 'bin' || fileExtension[1] == 'BIN' || fileExtension[1] == 'img' || fileExtension[1] == 'IMG') {
                    var url = 'api/v2/firmware/uploaddiscctx/' + $scope.newFirmware.version;
                    var fd = new FormData();
                    fd.append("upfile", $scope.newFirmware.firmwareFile);
                    var request = {
                        method: 'POST',
                        url: url,
                        data: fd,
                        headers: {
                            'Content-Type': 'multipart/form-data'
                        }
                    };
                    $http(request)
                        .success(function (data, status, headers, config) {
                            console.log('Success');
                            $scope.toggleForm();
                            $scope.newFirmware.firmwareFile = '';
                            $scope.getFirmwares();
                            $('#upload-file').val('');
                        })
                        .error(function (data, status, headers, config) {
                            $scope.showAlert('error', data, status, headers, config);
                        });
                } else {
                    $scope.showAlert('Error', "File Extension Not Supported");
                }
            });
        }

        $scope.bulkuploadBoth = function (service) {
            $scope.applyre(service + 'n');
        }

        $scope.showHide = function () {
            console.log("Calledd showw ad");
        }


        $scope.applyre = function (service) {
            if ($scope.nodesToApply.length === 0) {
                $scope.showAlert('error', 'Select nodes to apply');
                return;
            }
            var confirm = $scope.applyProfileConfirm(); // Apply Profile Confirm Modal
            $scope.isImmediate;
            //scope.sdate = '';
            var imm = 'lat';
            var sdate = new Date().getTime();
            if ($scope.applyConfig.isImmediate) {
                imm = 'im';
                sdate = new Date().getTime();
            } else {
                sdate = new Date($scope.applyConfig.sdate).getTime();
            }

            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/bulk/' + service + '/' + imm + '/' + sdate,
                    headers: { 'Content-Type': 'application/json' },
                    data: $scope.nodesToApply
                }).success(function () {
                    $scope.showAlert('Success', 'The task has been initiated to apply for the selected nodes.');
                    $scope.toggleForm();
                    $scope.nodesToApply = [];
                    $scope.nodes = [];
                    $('#nodesToApply').val("");
                }).error(function (msg) {
                    $scope.showAlert('Error', 'failed to initiate the task: ' + msg);
                });
            });
        };

        /*$scope.upload = function(service) {
            var confirm = $scope.uploadFirmwareConfirm(); // Confirm Modal
            $mdDialog.show(confirm).then(function() {

                var fileExtension = $scope.fileName.split('.');
                if (fileExtension[1] == 'csv' || fileExtension[1] == 'CSV' || fileExtension[1] == 'img' || fileExtension[1] == 'IMG') {
                    var imm = 'lat';
                    var sdate = new Date().getTime();
                    if (scope.isImmediate) {
                        imm = 'im';
                        sdate = new Date().getTime();
                    } else {
                        sdate = new Date(scope.sdate).getTime();
                    }
                    //var sd = scope.sdate
                    if ($scope.isImmediate) {
                        imm = 1;
                        $scope.sdate = new Date().getTime();
                    }
                    var url = 'api/v2/bulk/' + service + '/' + imm + '/' + sdate;

                    var fd = new FormData();
                    fd.append("upfile", scope.newFirmware.firmwareFile);
                    var request = {
                        method: 'POST',
                        url: url,
                        data: fd,
                        headers: {
                            'Content-Type': 'multipart/form-data'
                        }
                    };
                    $http(request)
                        .success(function(data, status, headers, config) {
                            $scope.toggleForm();
                            $scope.newFirmware.firmwareFile = '';
                            $scope.getFirmwares();
                            // ('#upload-file').val('');
                        })
                        .error(function(data, status, headers, config) {
                            $scope.showAlert('error', data, status, headers, config);
                        });
                } else {
                    $scope.showAlert('Error', "File Extension Not Supported");
                }
            });
        };*/
        // File upload
        $scope.fileupload = function () {
            var fileExtension = $scope.file.name.split('.');
            if (fileExtension[1] == 'bin' || fileExtension[1] == 'BIN') {
                var url = 'api/v2/firmware/uploaddiscctx';
                var fd = new FormData();
                fd.append("upfile", $scope.file);
                var request = {
                    method: 'POST',
                    url: url,
                    data: fd,
                    headers: {
                        'Content-Type': 'multipart/form-data'
                    }
                };
                $http(request)
                    .success(function (data, status, headers, config) {
                        console.log('Success');
                        $scope.file = '';
                        $scope.getFirmwares();
                        $('#upload-file').val('');
                    })
                    .error(function (data, status, headers, config) {
                        console.log('error');
                    });
            } else {
                $scope.showAlert('Error', "File Extension Not Supported");
            }
        }

        // Upload file change
        $scope.fileChange = function (element) {
            $scope.$apply(function ($scope) {
                $scope.newFirmware.firmwareFile = element.files[0];
            });
            console.log("file changed");
        }
        /* FIRMWARES -- END */
        // Old Profiles and Firmwares End

        $scope.searchstring = "";
        $scope.existingconf = function () {
            //$scope.radiodata.selectedDeviceradio = selectedDeviceradio;
            if ($scope.radiodata.selectedDeviceradio == 'existingconfig') {
                $("#existingconfigpopup").modal('show');
            }
        }
        $scope.existingconf1 = function () {
            $scope.radiodata.selectedDeviceradio = 'existingconfig';
            $("#existingconfigpopup").modal('show');
        }

        $scope.backFun = function () {
            $rootScope.provisionpage = "step1";
        }

        $scope.delConfig=function(obj){
          $http({
                method: 'POST',
                url: 'api/v2/autopro/delete/'+obj.serial,
                headers: {
                  'Content-Type': 'application/json'
                },
//                data: createobj
              }).success(function () {
                 $scope.showAlert('success', 'Deleted successfully.');
                 $scope.existingdeviceFun();
                 $scope.configdata.existingconfigtextnew={};
                 $("#existingconfigpopup").modal('hide');
              }).error(function (msg) {
                $scope.showAlert('error', 'Error creating Data: ' + msg);
              });
            console.log("config obj",obj);
        }


        $scope.nextstep = false;
        $scope.nextProvision = function (newdevicetext, selectedDeviceradio) {
            $scope.nextstep = false;
            $scope.configdata.newdevicetext = newdevicetext;
            if ($scope.configdata.newdevicetext == undefined) {
                $scope.configdata.newdevicetext = '';
            }
            $scope.radiodata.selectedDeviceradio = selectedDeviceradio;
            if ($scope.radiodata.selectedDeviceradio == 'existingdevice') {
                if (typeof $scope.configdata.existingdevicetextnew == 'object' && $scope.configdata.existingdevicetextnew.serial) {
                    $scope.nextstep = true;
                }
            } else if ($scope.radiodata.selectedDeviceradio == 'newdevice') {
                if ($scope.configdata.newdevicetext != '') {
                    $scope.nextstep = true;
                }
            } else if ($scope.radiodata.selectedDeviceradio == 'existingconfig') {
                if (typeof $scope.configdata.existingconfigtextnew == 'object' && $scope.configdata.existingconfigtextnew.serial) {
                    $scope.nextstep = true;
                }
            }
            if ($scope.nextstep) {
                if ($scope.configdata.newdevicetext) {
                    $rootScope.selectedserialNumber = $scope.configdata.newdevicetext;
                    $rootScope.selectednode = '';
                    $rootScope.existingdevicetext = {};
                    $scope.configdata.existingdevicetextnew = {};
                    $scope.configdata.existingconfigtextnew = {};
                }
                if ($scope.radiodata.selectedDeviceradio == 'newdevice' && $scope.configdata.newdevicetext == '') {
                    $rootScope.selectedserialNumber = $scope.configdata.newdevicetext;
                    $rootScope.selectednode = '';
                }
                if ($rootScope.selectedserialNumber) {
                    if ($scope.radiodata.selectedDeviceradio == 'existingconfig') {
                        $rootScope.provisionpage = "step3";
                        $state.existingconfig = true;
                    } else {
                        $rootScope.provisionpage = "step2";
                        $scope.templateFun();
                        //when list is all
                        // $scope.selectedProfile = "allprofile";
                        //added hen ap is default
                        $scope.selectedProfile = "approfile";
                        $scope.changeprofileFun($scope.selectedProfile);

                        $scope.selectedtemplatedupall = {};
                    }
                } else {
                    $scope.showAlert("Please select device");
                }
            } else {
                $scope.showAlert("Please select device");
            }
        }

        $scope.nextstep3Fun = function (selectedtemplate) {
            $scope.selectedtemplatedup = selectedtemplate;
            $rootScope.selectedtemplate = selectedtemplate;
            if ($rootScope.selectedtemplate) {
                if ($rootScope.selectedtemplate) {
                    $rootScope.provisionpage = "step3";
                    $state.existingconfig = false;
                } else {
                    $scope.showAlert("Please select template");
                }
            } else {
                $scope.showAlert("Please select template");
            }
        }

        $scope.backstep2Fun = function () {
            if ($state.existingconfig) {
                $rootScope.provisionpage = "step1";
            } else {
                $rootScope.provisionpage = "step2";
            }
        }

        $scope.backstep3Fun = function () {
            $rootScope.provisionpage = "step3";
        }
        $scope.cancelFun = function () {
            $rootScope.provisionpage = "step1";
            $rootScope.selectedserialNumber = '';
            $rootScope.selectednode = '';
            $rootScope.existingdevicetext = {};
            $scope.existingdeviceFun();
            $scope.configdata = {};
        }

        $scope.$on('$destroy', function () {
            $scope.stopTimer();
        });

        $scope.stopTimer = function () {
            if (angular.isDefined($scope.DataTimer)) {
                $interval.cancel($scope.DataTimer);
            }
        }

    }
]).directive('chooseFile', ['$http', '$mdDialog', function ($http, $mdDialog) {
    return {
        link: function (scope, elem, http, attrs) {
            var button = elem.find('button');
            var input = angular.element(elem[0].querySelector('input#fileInput'));
            button.bind('click', function () {
                input[0].click();
            });
            input.bind('change', function (e) {
                scope.$apply(function () {
                    var files = e.target.files;
                    if (files[0]) {
                        scope.fileName = files[0].name;
                        if (scope.newFirmware) {
                            scope.newFirmware.firmwareFile = files[0];
                        }
                    } else {
                        scope.fileName = null;
                    }
                });
            });

            scope.bulkupload = function (service) {
                if (scope.chngType == 0) {
                    scope.upload(service)
                } else {
                    scope.applyre(service);
                }

            }



            scope.upload = function (service) {
                var confirm = scope.applyProfileConfirm(); // Confirm Modal
                $mdDialog.show(confirm).then(function () {

                    var fileExtension = scope.fileName.split('.');
                    if (fileExtension[1] == 'csv' || fileExtension[1] == 'CSV' || fileExtension[1] == 'img' || fileExtension[1] == 'IMG') {
                        var imm = 'lat';
                        var sdate = new Date().getTime();
                        if (scope.applyConfig.isImmediate) {
                            imm = 'im';
                            sdate = new Date().getTime();
                        } else {
                            if(scope.applyConfig.sdate){
                                sdate = new Date(scope.applyConfig.sdate).getTime();
                            }else{
                                sdate = new Date().getTime();
                            }
                        }
                        //var imm = 2;
                        //var sd = scope.sdate
                        /*if (scope.isImmediate) {
                            imm = 'im';
                            scope.sdate = new Date().getTime();
                        }*/
                        scope.dopost=true;
                        if(service=='uploadfirm'){
                            if(scope.selectedFirmware.fileName!="Select"){
                                var url = 'api/v2/bulk/' + service + '/' + imm + '/' + sdate + '?firmware=' + scope.selectedFirmware.actualName;
                            }else{
                                scope.dopost=false
                            }
                        }else{
                            var url = 'api/v2/bulk/' + service + '/' + imm + '/' + sdate;
                        }

                        if(scope.dopost){
                            var fd = new FormData();
                            fd.append("upfile", scope.newFirmware.firmwareFile);
                            var request = {
                                method: 'POST',
                                url: url,
                                data: fd,
                                headers: {
                                    'Content-Type': 'multipart/form-data'
                                }
                            };
                            $http(request)
                                .success(function (data, status, headers, config) {
                                    scope.toggleForm();
                                    scope.newFirmware.firmwareFile = '';
                                    scope.getFirmwares();
                                    // ('#upload-file').val('');
                                })
                                .error(function (data, status, headers, config) {
                                    scope.showAlert('error', data, status, headers, config);
                                });
                        }else{
                            scope.showAlert('Error', "Please select firmware");
                        }
                    } else {
                        scope.showAlert('Error', "File Extension Not Supported");
                    }
                });
            };
            // To upload the firmware
            scope.clickFunc = function () {
                var confirm = scope.uploadFirmwareConfirm(); // Confirm Modal
                $mdDialog.show(confirm).then(function () {
                    var fileExtension = scope.fileName.split('.');
                    if (fileExtension[1] == 'bin' || fileExtension[1] == 'BIN' || fileExtension[1] == 'img' || fileExtension[1] == 'IMG') {
                        var url = 'api/v2/firmware/uploaddiscctx/' + scope.newFirmware.version;
                        var fd = new FormData();
                        fd.append("upfile", scope.newFirmware.firmwareFile);
                        var request = {
                            method: 'POST',
                            url: url,
                            data: fd,
                            headers: {
                                'Content-Type': 'multipart/form-data'
                            }
                        };
                        $http(request)
                            .success(function (data, status, headers, config) {
                                scope.toggleForm();
                                scope.newFirmware.firmwareFile = '';
                                scope.getFirmwares();
                                // ('#upload-file').val('');
                            })
                            .error(function (data, status, headers, config) {
                                scope.showAlert('error', data, status, headers, config);
                            });
                    } else {
                        scope.showAlert('Error', "File Extension Not Supported");
                    }
                });
            };
            scope.resetupload = function () {
                scope.fileName = "";
            }


        }
    };
}]);