dashboard.controller("DDRSATPCProfileConfigController", ['$rootScope', '$scope', '$mdDialog', '$http', '$state', '$location', 'dashboardService', 'Flash',
    function($rootScope, $scope, $mdDialog, $http, $state, $location, dashboardService, Flash) {

        //this is default width
        $scope.tableWidth = "col-md-12";
            $scope.ddrsStatusArray = [{
                "ddrsStatus": 1,
                "ddrsStatusVal": "Enable"
            }, {
                "ddrsStatus": 2,
                "ddrsStatusVal": "Disable"
            }];
            $scope.spacialStreamArray = [{
                    "spacialStream": 1,
                    "spacialStreamVal": "Single"
                }, {
                    "spacialStream": 2,
                    "spacialStreamVal": "Dual"
                },
                {
                    "spacialStream": 3,
                    "spacialStreamVal": "Auto"
                }
            ];
            $scope.atpcStatusArray = [{
                "atpcStatus": 1,
                "atpcStatusVal": "Enable"
            }, {
                "atpcStatus": 2,
                "atpcStatusVal": "Disable"
            }];
            $scope.modIndexArraymin = [];
            $scope.modIndexArraymax = [];
            $scope.modIndexArraytxRate = [];
            $scope.txRate = false;
            $scope.max_min = false;
        $scope.filter = {};
        $scope.defaultObj = {};
        $scope.showAtpcStat = false;
        $scope.showEirp = false;

        for (var i = 0; i < 10; i++) {
            $scope.mcsval = 'MCS' + i;
            $scope.modIndexArraymin.push({
                "minModIndex": i,
                "modeIndexVal": $scope.mcsval
            });
            $scope.modIndexArraymax.push({
                "maxModIndex": i,
                "modeIndexVal": $scope.mcsval
            });
            $scope.modIndexArraytxRate.push({
                "txRateIndex": i,
                "modeIndexVal": $scope.mcsval
            });
        }
        //radio mode
        $scope.radioMode = [{
            'name': "All",
            'value': -1
        }, {
            'name': "AP",
            'value': 1
        }, {
            'name': "SU",
            'value': 2
        }];
        //link types
        $scope.linkType = [{
            'name': "All",
            'value': -1
        }, {
            'name': "PTP",
            'value': 1
        }, {
            'name': "BackHaul",
            'value': 2
        }, {
            'name': "PTMP",
            'value': 3
        }];

        //from config controller to this method calling
        //if config controller click wireless this method initates
        $rootScope.$on("init_ddrsatpc", function() {

            $scope.init();
        });
        $scope.init = function() {

            $scope.defProfileObj = {};
            $scope.defProfileObj.ddrsStatusName = '';
            $scope.defProfileObj.spacialStreamName = '';
            $scope.defProfileObj.modIndexNamemin = '';
            $scope.defProfileObj.modIndexNamemax = '';
            $scope.defProfileObj.atpcStatusName = '';
            $scope.defProfileObj.eirpStatus = '';
            $scope.defProfileObj.transmitPower = '';
            $scope.defProfileObj.txRateIndexName = '';
            $scope.defProfileObj.mimot = '';
            $scope.defProfileObj.mimor = '';
            if (!$rootScope.profileID) {

                $scope.ddrsapcProfileObj = {};
                $scope.mimoData = {};
                $scope.mimoData.txa1 = false;
                $scope.mimoData.txa2 = false;
                $scope.mimoData.rxa1 = false;
                $scope.mimoData.rxa2 = false;
                $scope.create_ddrsatpc_profile = true;
                $scope.edit_ddrsatpc_profile = false;

                $scope.ddrsapcProfileObj.transmitPower = 26;
                //$scope.ddrsapcProfileObj.tPower = 26;

                $scope.defaultObj.rMode = $scope.radioMode[1];
                $scope.defaultObj.lType = $scope.linkType[3];

                $scope.ddrsapcProfileObj.ddrsStatusName = $scope.ddrsStatusArray[0];
                $scope.ddrsStatusSelection(1);
                $scope.ddrsapcProfileObj.atpcStatusName = $scope.atpcStatusArray[0];


            } else {
                $scope.ddrsapcProfileObj = {};
                $scope.mimoData = {};
                $scope.create_ddrsatpc_profile = false;
                $scope.edit_ddrsatpc_profile = true;
                var url = 'api/v2/profiles/template/get?profile=' + $rootScope.profileID;
                $http.get(url).then(function(response) {
                    $scope.ddrsapcProfileObj.ddrsatpcProfileName = response.data.name;
                    $scope.defaultObj.rMode = {
                        value: response.data.radioMode
                    }
                    $scope.defaultObj.lType = {
                        value: response.data.linkType
                    }

                    if ($scope.defaultObj.rMode.value == 1) {
                        $scope.apRadioMode = true;
                    }

                    $scope.ddrsapcProfileObj.ddrsStatusName = {
                        ddrsStatus:response.data.ddrsatpc.ddrsStatus
                    }

                    $scope.ddrsapcProfileObj.spacialStreamName = {
                        spacialStream:response.data.ddrsatpc.spacialStream
                    }
                    $scope.chanegStream($scope.ddrsapcProfileObj.spacialStreamName);
                    $scope.ddrsapcProfileObj.modIndexNamemin = {
                        minModIndex:response.data.ddrsatpc.minModIndex
                    }
                    $scope.ddrsapcProfileObj.modIndexNamemax = {
                        maxModIndex:response.data.ddrsatpc.maxModIndex
                    }
                    if (response.data.ddrsatpc.atpcStatus != null) {
                        $scope.ddrsapcProfileObj.atpcStatusName = {
                            atpcStatus:response.data.ddrsatpc.atpcStatus
                        }
                        $scope.showAtpcStat = true;
                        if (response.data.ddrsatpc.atpcStatus == 1) {
                            $scope.showEirp = true;
                        }


                    }
                    $scope.ddrsapcProfileObj.eirpStatus = response.data.ddrsatpc.eirpStatus;;
                    $scope.ddrsapcProfileObj.transmitPower = response.data.ddrsatpc.transmitPower;
                    $scope.ddrsapcProfileObj.txRateIndexName = {
                        txRateIndex:response.data.ddrsatpc.txRate
                    }

                    if (response.data.radioMimo.txChaimMask == 1) {
                        $scope.mimoData.txa1 = true;
                        $scope.mimoData.txa2 = false;
                    } else if (response.data.radioMimo.txChaimMask == 2) {
                        $scope.mimoData.txa1 = false;
                        $scope.mimoData.txa2 = true;
                    } else {
                        $scope.mimoData.txa1 = true;
                        $scope.mimoData.txa2 = true;
                    }

                    if (response.data.radioMimo.rxChainMask == 1) {
                        $scope.mimoData.rxa1 = true;
                        $scope.mimoData.rxa2 = false;
                    } else if (response.data.radioMimo.rxChainMask == 2) {
                        $scope.mimoData.rxa1 = false;
                        $scope.mimoData.rxa2 = true;
                    } else {
                        $scope.mimoData.rxa1 = true;
                        $scope.mimoData.rxa2 = true;
                    }
                });
            }
        }

       /* $scope.removeProperty = function(propery) {
            console.log(propery);
            //propery = null;
            $scope.radiusProfileObj[propery] = null;
            $scope.defProfileObj[propery] = 'display:none;';
        }*/

        $scope.removeProperty = function(propery) {
            console.log(propery);
            //propery = null;
            $scope.ddrsapcProfileObj[propery] = null;
            $scope.defProfileObj[propery] = 'display:none;';
        }

        $scope.removePropertymimt = function(propery) {
            console.log(propery);
                        //propery = null;
            $scope.mimoData.txa1 = false;
            $scope.mimoData.txa2 = false;
            $scope.defProfileObj[propery] = 'display:none;';
        }

        $scope.removePropertymimr = function(propery) {
            console.log(propery);
            //propery = null;
            $scope.mimoData.rxa1 = false;
            $scope.mimoData.rxa2 = false;
            $scope.defProfileObj[propery] = 'display:none;';
        }


            //radionstatus array

        //close the selected form
        $scope.toggleForm = function() {
                $scope.$emit("toggleFormFunction");
        }

         function getTxChainMask() {
            if ($scope.mimoData.txa1 && $scope.mimoData.txa2) {
                return 3;
            } else if ($scope.mimoData.txa1 == true && $scope.mimoData.txa2 == false) {
                return 1;
            } else if ($scope.mimoData.txa1 == false && $scope.mimoData.txa2 == true) {
                return 2;
            } else if ($scope.mimoData.txa1 == false && $scope.mimoData.txa2 == false) {
                return -1;
            }
        }

         function getRxChainMask() {
            if ($scope.mimoData.rxa1 && $scope.mimoData.rxa2) {
                return 3;
            } else if ($scope.mimoData.rxa1 == true && $scope.mimoData.rxa2 == false) {
                return 1;
            } else if ($scope.mimoData.rxa1 == false && $scope.mimoData.rxa2 == true) {
                return 2;
            } else if ($scope.mimoData.rxa1 == false && $scope.mimoData.rxa2 == false) {
                return -1;
            }
        }

            //post call for wireless profile
        $scope.createDDRSATPCProfile = function() {
            var txChainMask = getTxChainMask();
            var rxChainMask = getRxChainMask();
            var atpc = $scope.showAtpc();
            if (!atpc) {
                $scope.ddrsapcProfileObj.atpcStatusName = null;
            }
            if (!$scope.txRate) {
                $scope.ddrsapcProfileObj.txRateIndexName = null;
            }
            if ($scope.showEirp) {
                $scope.ddrsapcProfileObj.transmitPower = null;
            } else {
                $scope.ddrsapcProfileObj.eirpStatus = null;
            }
            var ddrsatpcObj = {
                "profileType": 6,
                "name": $scope.ddrsapcProfileObj.ddrsatpcProfileName.split(" ").join(""),
                "radioMode": $scope.defaultObj.rMode ? $scope.defaultObj.rMode.value : null,
                "linkType": $scope.defaultObj.lType ? $scope.defaultObj.lType.value : null,
                "ddrsatpc": {
                    "radio": 0,
                    "nodeId": 0,
                    "status": 0,
                    "message": null,
                    "ddrsStatus": $scope.ddrsapcProfileObj.ddrsStatusName ? $scope.ddrsapcProfileObj.ddrsStatusName.ddrsStatus : null,
                    "spacialStream": $scope.ddrsapcProfileObj.spacialStreamName ? $scope.ddrsapcProfileObj.spacialStreamName.spacialStream : null,
                    "minModIndex": $scope.ddrsapcProfileObj.modIndexNamemin ? $scope.ddrsapcProfileObj.modIndexNamemin.minModIndex : null,
                    "maxModIndex": $scope.ddrsapcProfileObj.modIndexNamemax ? $scope.ddrsapcProfileObj.modIndexNamemax.maxModIndex : null,
                    "ddrsRateIncTimer": null,
                    "ddrsRateDecTimer": null,
                    "ddrsRateIncThresh": null,
                    "ddrsRateIncRTXThresh": null,
                    "ddrsRateDecRTXThreshl": null,
                    "atpcStatus": $scope.ddrsapcProfileObj.atpcStatusName ? $scope.ddrsapcProfileObj.atpcStatusName.atpcStatus : null,
                    "transmitPower": $scope.ddrsapcProfileObj.transmitPower ? $scope.ddrsapcProfileObj.transmitPower : null,
                    "eirpStatus" : $scope.ddrsapcProfileObj.eirpStatus ? $scope.ddrsapcProfileObj.eirpStatus : null,
                    "txRate": $scope.ddrsapcProfileObj.txRateIndexName ? $scope.ddrsapcProfileObj.txRateIndexName.txRateIndex : null,
                },
                "radioMimo":{
                        "shortGI":-1,
                        "amsdu":-1,
                        "ampdu":-1,
                        "txChaimMask": txChainMask,
                        "rxChainMask": rxChainMask,
                }
            }

                //   hear is our service call
            var confirm = $scope.createConfirm();

            $mdDialog.show(confirm).then(function() {
                $http({
                    method: 'POST',
                    url: 'api/v2/profiles/template',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: ddrsatpcObj
                }).success(function() {
                    $scope.showAlert('Success', 'Saved successfully.');
                    $scope.ddrsatpc = {};
                    $scope.ttype = 6;
                    $scope.$emit("defaultCall", $scope.ttype);
                    $scope.$emit("toggleFormFunction");
                    //$scope.init();
                    //$scope.init();
                }).error(function(msg) {
                    $scope.showAlert('Error', 'Error creating Data: ' + msg);
                });
            });

        }

        $scope.showAtpc = function() {
            var showat = true;
            if ($scope.defaultObj.rMode.value == 1 && $scope.defaultObj.lType.value == 3) {
                showat = false;
                //$scope.ddrsapcProfileObj.transmitPower = 26;
                $scope.ddrsapcProfileObj.atpcStatusName = {
                    atpcStatus:2
                }
            } /*else {
                $scope.ddrsapcProfileObj.atpcStatusName = null;
            }*/
            return showat;
        }

        $scope.atpcStatusChange = function() {
            $scope.ddrsapcProfileObj.transmitPower = 26;
            if ($scope.ddrsapcProfileObj.atpcStatusName.atpcStatus == 1) {
                $scope.showEirp = true;
            } else {
                $scope.showEirp = false;
            }
        }


        $scope.radioTypeChange = function(rMode) {
            if ($scope.defaultObj.rMode.value == 1 && $scope.defaultObj.lType.value == 3) {
                $scope.showAtpcStat = false;
                $scope.showEirp = false;
            } else {
                $scope.showAtpcStat = true;
            }
            if ($scope.showAtpcStat) {
                $scope.atpcStatusChange();
            }

        }

        $scope.linkTypeChange = function(ltype) {
            $scope.radioTypeChange();
            $scope.chanegStream($scope.ddrsapcProfileObj.spacialStreamName);

        }

        $scope.enableTransmitPower = function() {
            var disable = false;
            //console.log($scope.ddrsapcProfileObj.atpcStatusName);
            if ($scope.ddrsapcProfileObj.atpcStatusName.atpcStatus == 2) {
                disable = true;
            }
            return disable;

        }

        $scope.enableAndShowEirp = function() {
            /*var disable = false;
            //console.log($scope.ddrsapcProfileObj.atpcStatusName);
            if ($scope.ddrsapcProfileObj.atpcStatusName != null) {
                if ($scope.ddrsapcProfileObj.atpcStatusName.atpcStatus == 1) {
                    disable = true;
                }
            }*/

            return true;

        }

        $scope.ddrsStatusSelection = function(ddrsStatus) {
            var json = {
                "spacialStream": 3,
                "spacialStreamVal": "Auto"
            };
            if (ddrsStatus == 1) {
                if ($scope.spacialStreamArray.length == 2) {
                    $scope.spacialStreamArray.push(json);
                }
                $scope.max_min = true;
                $scope.txRate = false;
            } else if (ddrsStatus == 2) {
                $scope.max_min = false;
                $scope.txRate = true;
                $scope.spacialStreamArray.pop();
            }
            $scope.ddrsapcProfileObj.spacialStreamName = $scope.spacialStreamArray[0];
            $scope.chanegStream($scope.ddrsapcProfileObj.spacialStreamName);
        }
            //update call for wireless profile
        $scope.updateDDRSATPCProfile = function() {
            var txChainMask = getTxChainMask();
            var rxChainMask = getRxChainMask();
            /*var atpc = $scope.showAtpc();
            if (!atpc) {
            }*/
            var ddrsatpcObj = {
                "profileType": 6,
                "name": $scope.ddrsapcProfileObj.ddrsatpcProfileName.split(" ").join(""),
                "profileId": $rootScope.profileID,
                "radioMode": $scope.defaultObj.rMode ? $scope.defaultObj.rMode.value : null,
                "linkType": $scope.defaultObj.lType ? $scope.defaultObj.lType.value : null,
                "ddrsatpc": {
                    "radio": 0,
                    "nodeId": 0,
                    "status": 0,
                    "message": null,
                    "ddrsStatus": $scope.ddrsapcProfileObj.ddrsStatusName ? $scope.ddrsapcProfileObj.ddrsStatusName.ddrsStatus : null,
                    "spacialStream": $scope.ddrsapcProfileObj.spacialStreamName ? $scope.ddrsapcProfileObj.spacialStreamName.spacialStream : null,
                    "minModIndex": $scope.ddrsapcProfileObj.modIndexNamemin ? $scope.ddrsapcProfileObj.modIndexNamemin.minModIndex : null,
                    "maxModIndex": $scope.ddrsapcProfileObj.modIndexNamemax ? $scope.ddrsapcProfileObj.modIndexNamemax.maxModIndex : null,
                    "ddrsRateIncTimer": null,
                    "ddrsRateDecTimer": null,
                    "ddrsRateIncThresh": null,
                    "ddrsRateIncRTXThresh": null,
                    "ddrsRateDecRTXThreshl": null,
                    "atpcStatus": $scope.ddrsapcProfileObj.atpcStatusName ? $scope.ddrsapcProfileObj.atpcStatusName.atpcStatus : null,
                    "transmitPower": $scope.ddrsapcProfileObj.transmitPower ? $scope.ddrsapcProfileObj.transmitPower : null,
                    "eirpStatus" : $scope.ddrsapcProfileObj.eirpStatus ? $scope.ddrsapcProfileObj.eirpStatus : null,
                    "txRate": $scope.ddrsapcProfileObj.txRateIndexName ? $scope.ddrsapcProfileObj.txRateIndexName.txRateIndex : null,
                },
                "radioMimo":{
                    "shortGI":-1,
                    "amsdu":-1,
                    "ampdu":-1,
                    "txChaimMask": txChainMask,
                    "rxChainMask": rxChainMask,
                }
            }

                    //   hear is our service call
                var confirm = $scope.saveconfirm();

                $mdDialog.show(confirm).then(function() {
                    $http({
                        method: 'POST',
                        url: 'api/v2/profiles/template/update',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        data: ddrsatpcObj
                    }).success(function() {
                        $scope.showAlert('Success', 'Updated successfully.');
                        $scope.ttype = 6;
                        $scope.$emit("defaultCall", $scope.ttype);
                        $scope.$emit("toggleFormFunction");
                    }).error(function(msg) {
                        $scope.showAlert('Error', 'Error updating Data: ' + msg);
                    });
                });

            }

        $scope.chanegStream = function(streamValue) {
            $scope.modIndexArraymin = [];
            $scope.modIndexArraymax = [];
            $scope.modIndexArraytxRate = [];
            $scope.max_min = true;
              if (streamValue.spacialStream == 1) {    //single
                             if($scope.defaultObj.lType.value==3){   //ptmmp
                                $scope.value=4;
                             }else{                                            //ptp or bachaul
                                $scope.value=7;
                             }
                            if ($scope.ddrsapcProfileObj.ddrsStatusName.ddrsStatus == 1) {  //enable
                                $scope.max_min = true;
                            }else{
                                $scope.value=9;
                            }
                            for (var i = 0; i <= $scope.value; i++) {
                                $scope.mcsval = 'MCS' + i;
                                $scope.modIndexArraymin.push({
                                    "minModIndex": i,
                                    "modeIndexVal": $scope.mcsval
                                });
                                $scope.modIndexArraymax.push({
                                    "maxModIndex": i,
                                    "modeIndexVal": $scope.mcsval
                                });
                                $scope.modIndexArraytxRate.push({
                                    "txRateIndex": i,
                                    "modeIndexVal": $scope.mcsval
                                });
                            }
                             $scope.ddrsapcProfileObj.txRateIndexName = $scope.modIndexArraytxRate[3]
                                        $scope.ddrsapcProfileObj.modIndexNamemax = $scope.modIndexArraymax[$scope.modIndexArraymax.length-1];
                                         $scope.ddrsapcProfileObj.modIndexNamemin = $scope.modIndexArraymin[0];
                        } else if (streamValue.spacialStream == 2) {   //dual
                            if($scope.defaultObj.lType.value==3){   //ptmmp
                                $scope.value=14;
                             }else{                                            //ptp or bachaul
                                $scope.value=19;
                             }
                            if ($scope.ddrsapcProfileObj.ddrsStatusName.ddrsStatus == 1) {
                                $scope.max_min = true;
                            }else{
                                $scope.value=19;
                            }
                            for (var i = 10; i <=  $scope.value; i++) {
                                $scope.mcsval = 'MCS' + i;
                                $scope.modIndexArraymin.push({
                                    "minModIndex": i,
                                    "modeIndexVal": $scope.mcsval
                                });
                                $scope.modIndexArraymax.push({
                                    "maxModIndex": i,
                                    "modeIndexVal": $scope.mcsval
                                });
                                $scope.modIndexArraytxRate.push({
                                    "txRateIndex": i,
                                    "modeIndexVal": $scope.mcsval
                                });
                            }
                             $scope.ddrsapcProfileObj.txRateIndexName = $scope.modIndexArraytxRate[3]
                                        $scope.ddrsapcProfileObj.modIndexNamemax = $scope.modIndexArraymax[$scope.modIndexArraymax.length-1];
                                         $scope.ddrsapcProfileObj.modIndexNamemin = $scope.modIndexArraymin[0];
                            //$scope.modIndexArraytxRate = $scope.modIndexArraymax;
                        }
//            if (streamValue.spacialStream == 1) {
//                for (var i = 0; i < 10; i++) {
//                    $scope.mcsval = 'MCS' + i;
//                    $scope.modIndexArraymin.push({
//                        "minModIndex": i,
//                        "modeIndexVal": $scope.mcsval
//                    });
//                    $scope.modIndexArraymax.push({
//                        "maxModIndex": i,
//                        "modeIndexVal": $scope.mcsval
//                    });
//                    $scope.modIndexArraytxRate.push({
//                        "txRateIndex": i,
//                        "modeIndexVal": $scope.mcsval
//                   });
//                }
//                // Commented by Srinivas to handle the case in a single loop
//                /*for (var i = 0; i < 10; i++) {
//                    $scope.mcsval = 'MCS' + i;
//                    $scope.modIndexArraymax.push({
//                        "maxModIndex": i,
//                        "modeIndexVal": $scope.mcsval
//                    });
//                }*/
//                $scope.ddrsapcProfileObj.modIndexNamemax = $scope.modIndexArraymax[9];
//                $scope.ddrsapcProfileObj.modIndexNamemin = $scope.modIndexArraymin[0];
//                $scope.ddrsapcProfileObj.txRateIndexName = $scope.modIndexArraytxRate [3]
//            } else if (streamValue.spacialStream == 2) {
//                for (var i = 10; i < 20; i++) {
//                    $scope.mcsval = 'MCS' + i;
//                    $scope.modIndexArraymin.push({
//                        "minModIndex": i,
//                        "modeIndexVal": $scope.mcsval
//                    });
//                     $scope.modIndexArraymax.push({
//                        "maxModIndex": i,
//                         "modeIndexVal": $scope.mcsval
//                     });
//
//                    $scope.modIndexArraytxRate.push({
//                        "txRateIndex": i,
//                        "modeIndexVal": $scope.mcsval
//                    });
//                }
//
//                $scope.ddrsapcProfileObj.modIndexNamemax = $scope.modIndexArraymax[9];
//                $scope.ddrsapcProfileObj.modIndexNamemin = $scope.modIndexArraymin[0];
//                $scope.ddrsapcProfileObj.txRateIndexName = $scope.modIndexArraytxRate [3]
//            }
            if(streamValue.spacialStream == 3) {
                $scope.max_min = false;
            }
            if ($scope.ddrsapcProfileObj.ddrsStatusName.ddrsStatus == 2) {
                $scope.max_min = false;
                $scope.txRate = true;
            }
        }



            //  this method is used for removing undefined and null ke values from object
        function clean(obj) {
            for (var propName in obj) {
                if (obj[propName] === null || obj[propName] === undefined || obj[propName] === "") {
                    delete obj[propName];
                }
            }
            return obj;
        }
        //create conformation
        $scope.createConfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to create this profile?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };
        //update conformation
        $scope.saveconfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to update these changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };


    }
]);
