dashboard.controller("DhcpProfileConfigController", ['$rootScope', '$scope', '$mdDialog', '$http', '$state', '$location', 'dashboardService', 'Flash',
    function($rootScope, $scope, $mdDialog, $http, $state, $location, dashboardService, Flash) {
        $scope.defaultObj = {};
        $scope.fiveGHZObj = {};
        $scope.twopointfourGHZObj = {};
        $scope.filter = {};
        $scope.tableWidth = "col-md-12";
        //radio mode
        $scope.radioMode = [{
                'name': "All",
                'value': -1
            },
            {
                'name': "AP",
                'value': 1
            }, {
                'name': "SU",
                'value': 2
            }
        ];
        //link types
        $scope.linkType = [{
            'name': "All",
            'value': -1
        }, {
            'name': "PTP",
            'value': 1
        }, {
            'name': "BackHaul",
            'value': 2
        }, {
            'name': "PTMP",
            'value': 3
        }];
        //dhcp server
        $scope.dhcpServerArray = [{
            "id": 1,
            "val": "Disable"
        }, {
            "id": 0,
            "val": "Enable"
        }];
        //from config controller to this method calling
        //if config controller click dhcp this method initates
        $rootScope.$on("init_dhcp", function() {

            $scope.init();
        });

        //set default values for 5ghz
        $scope.default5values = function() {
                $scope.fiveGHZObj.startIP = '192.168.1.100';
                $scope.fiveGHZObj.endIP = '192.168.1.150';
                $scope.fiveGHZObj.leaseTime = 43200;
            }
            //set default values for 2.4ghz
        $scope.default24values = function() {
                $scope.twopointfourGHZObj.startIP = '192.168.1.100';
                $scope.twopointfourGHZObj.endIP = '192.168.1.101';
                $scope.twopointfourGHZObj.leaseTime = 43200;
            }
            //reset set default values for 5ghz
        $scope.null5values = function() {
            $scope.fiveGHZObj.startIP = '';
            $scope.fiveGHZObj.endIP = '';
            $scope.fiveGHZObj.leaseTime = '';
        }
            //re set default values for 2.4ghz
        $scope.null24values = function() {
            $scope.twopointfourGHZObj.startIP = '';
            $scope.twopointfourGHZObj.endIP = '';
            $scope.twopointfourGHZObj.leaseTime = '';
        }
        $scope.init = function() {
            $scope.defProfileObj5 = {};
            $scope.defProfileObj5.startIP = '';
            $scope.defProfileObj5.endIP = '';
            $scope.defProfileObj5.leaseTime = '';
            $scope.defProfileObj = {};
            $scope.defProfileObj.startIP = '';
            $scope.defProfileObj.endIP = '';
            $scope.defProfileObj.leaseTime = '';
            $scope.defProfileObj.dhcpServer = '';
            $scope.vdefProfileObj ={}
            $scope.vdefProfileObj.startIP = 'required';
            $scope.vdefProfileObj.endIP = 'required';
            $scope.vdefProfileObj.leaseTime = 'required';
            $scope.vdefProfileObj.dhcpServer = 'required';
            if (!$rootScope.profileID) {

                $scope.create_dhcp_profile = true;
                $scope.edit_dhcp_profile = false;

                $scope.defaultObj = {};
                $scope.fiveGHZObj = {};
                $scope.twopointfourGHZObj = {};

                $scope.defaultObj.rMode = $scope.radioMode[0];
                $scope.defaultObj.lType = $scope.linkType[0];

                $scope.fiveGHZ = false;
                //                $scope.fiveGHZObj.dhcpServer = $scope.dhcpServerArray[0];
                $scope.subDiv5ghz = false;

                $scope.twopointfourGHZObj.ipaddress = "192.168.5.1";
                $scope.twopointfourGHZObj.subnetmask = "255.255.255.0";

                $scope.twopointfourGHZObj.dhcpServer = $scope.dhcpServerArray[1];
                $scope.subDiv2_4ghz = true;

                $scope.default24values();


            } else {

                $scope.create_dhcp_profile = false;
                $scope.edit_dhcp_profile = true;
                var url = 'api/v2/profiles/template/get?profile=' + $rootScope.profileID;
                //  var url = 'api/v2/profiles/template/list?ttype=' +$scope.ttype +'&ltype=' +$scope.ltype + '&rtype=' +$scope.rtype;
                $http.get(url).then(function(response) {
                    console.log("init function");
                    $scope.defaultObj.dhcpProfileName = response.data.name;
                    $scope.defaultObj.rMode = {
                        value: response.data.radioMode
                    }
                    $scope.defaultObj.lType = {
                        value: response.data.linkType
                    }
                    $scope.fiveGHZObj.dhcpServer = {
                        id: response.data.dhdto.dhcpServer
                    }
                    if (response.data.radioMode == 1 && (response.data.linkType == 1 || response.data.linkType == 3)) {
                        $scope.fiveGHZ = true;
                    } else {
                        $scope.fiveGHZ = false;
                    }
                    if (response.data.radioMode == 1 && (response.data.linkType == 1 || response.data.linkType == 3) && response.data.dhdto.dhcpServer == 0) {
                        $scope.subDiv5ghz = true;
                    } else {
                        $scope.subDiv5ghz = false;
                    }
                    $scope.fiveGHZObj.startIP = response.data.dhdto.startIPAddress;
                    $scope.fiveGHZObj.endIP = response.data.dhdto.endIPAddress;
                    $scope.fiveGHZObj.leaseTime = response.data.dhdto.leaseTime;

                    $scope.twopointfourGHZObj.ipaddress = response.data.dhdto.klanIPAddress;
                    $scope.twopointfourGHZObj.subnetmask = response.data.dhdto.klanMask;

                    $scope.twopointfourGHZObj.dhcpServer = {
                        id: response.data.dhdto.klandhcpServer
                    }

                    if (response.data.dhdto.klandhcpServer == 0) {
                        $scope.subDiv2_4ghz = true;
                    }
                    $scope.twopointfourGHZObj.startIP = response.data.dhdto.klanstartIPAddress;
                    $scope.twopointfourGHZObj.endIP = response.data.dhdto.klanendIPAddress;
                    $scope.twopointfourGHZObj.leaseTime = response.data.dhdto.klanleaseTime;


                });
            }
        }

        $scope.removeProperty5 = function(propery) {
            console.log(propery);
            //propery = null;
            $scope.fiveGHZObj[propery] = null;
            $scope.defProfileObj5[propery] = 'display:none;';
        }

        $scope.removeProperty = function(propery) {
            console.log(propery);
            //propery = null;
            $scope.twopointfourGHZObj[propery] = null;
            $scope.defProfileObj[propery] = 'display:none;';
            $scope.vdefProfileObj[propery] = '';
        }

        //  based on ap or su enable 5ghz or 2.4 ghz logic implimentation
        //onchange for radio mode ap or su
        $scope.radioTypeChange = function(rmode) {

                if (rmode.value == 1 && ($scope.defaultObj.lType.value == 1 || $scope.defaultObj.lType.value == 3)) {
                    $scope.fiveGHZ = true;
                    $scope.fiveGHZObj.dhcpServer = $scope.dhcpServerArray[0];
                    $scope.subDiv5ghz = false;
                    //                $scope.twopointfourGHZ = true;
                } else {
                    $scope.fiveGHZ = false;
                    $scope.fiveGHZObj.dhcpServer = "";
                    $scope.subDiv5ghz = false;
                    $scope.null5values();

                }

            }
            //link type change
        $scope.linkTypeChange = function(ltype) {
            if ((ltype.value == 1 || ltype.value == 3) && $scope.defaultObj.rMode.value == 1) {
                $scope.fiveGHZ = true;
                $scope.fiveGHZObj.dhcpServer = $scope.dhcpServerArray[0];
                $scope.subDiv5ghz = false;
            } else {
                $scope.fiveGHZ = false;
                $scope.fiveGHZObj.dhcpServer = "";
                $scope.subDiv5ghz = false;
                $scope.null5values();
            }

        }

        //dhcp server status change method
        $scope.dhcpServer5GHZ = function(dhcpServer) {

                if (dhcpServer.val == 'Disable') {
                    $scope.subDiv5ghz = false;
                    // $scope.subDiv2_4ghz = false;
                    $scope.null5values();
                } else {
                    $scope.subDiv5ghz = true;
                    $scope.default5values();
                }
            }
            //dhcp server status change method for 2.4ghz
        $scope.dhcpServer24GHZ = function(dhcpServer) {

            if (dhcpServer.val == 'Disable') {
                $scope.subDiv2_4ghz = false;
                $scope.null24values();
            } else {
                $scope.subDiv2_4ghz = true;
                $scope.default24values();
            }
        }



        //ip range validation
        $scope.checkIP = function(ipAddress, group, type) {

                var ipRegex = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
                if (group == 'fiveGHZObj' || group == 'twopointfourGHZObj') {

                    if (!ipAddress.match(ipRegex)) {
                        $scope[group][type] = "";
                    }
                }
            }
            //lease time validation
        $scope.checkLeases = function(num, group, type) {

            if (num < 120 || num > 86400) {
                if (type == 'leaseTime') {
                    $scope[group][type] = "";
                }
            }
        }

        //post call for dhcp
        $scope.createDhcpProfile = function() {

                var dhcpObj = {
                    "profileType": 4,
                    "name": $scope.defaultObj.dhcpProfileName.split(" ").join(""),
                    "radioMode": $scope.defaultObj.rMode.value,
                    "linkType": $scope.defaultObj.lType.value,
                    "dhdto": {
                        "radio": 0,
                        "nodeId": 0,
                        "status": 0,
                        "message": null,
                        "dhcpServer": $scope.fiveGHZObj.dhcpServer ? $scope.fiveGHZObj.dhcpServer.id : null,
                        "startIPAddress": $scope.fiveGHZObj.startIP ? $scope.fiveGHZObj.startIP : null,
                        "endIPAddress": $scope.fiveGHZObj.endIP ? $scope.fiveGHZObj.endIP : null,
                        "leaseTime": $scope.fiveGHZObj.leaseTime ? $scope.fiveGHZObj.leaseTime : null,
                        "klanIPAddress": $scope.twopointfourGHZObj.ipaddress ? $scope.twopointfourGHZObj.ipaddress : null,
                        "klanMask": $scope.twopointfourGHZObj.subnetmask ? $scope.twopointfourGHZObj.subnetmask : null,
                        "klandhcpServer": $scope.twopointfourGHZObj.dhcpServer ? $scope.twopointfourGHZObj.dhcpServer.id : null,
                        "klanstartIPAddress": $scope.twopointfourGHZObj.startIP ? $scope.twopointfourGHZObj.startIP : null,
                        "klanendIPAddress": $scope.twopointfourGHZObj.endIP ? $scope.twopointfourGHZObj.endIP : null,
                        "klanleaseTime": $scope.twopointfourGHZObj.leaseTime ? $scope.twopointfourGHZObj.leaseTime : null
                    }
                }
                var confirm = $scope.createConfirm();

                $mdDialog.show(confirm).then(function() {
                    $http({
                        method: 'POST',
                        url: 'api/v2/profiles/template',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        data: dhcpObj
                    }).success(function() {
                        $scope.showAlert('Success', 'Saved successfully.');
                        $scope.defaultObj = {};
                        $scope.fiveGHZObj = {};
                        $scope.twopointfourGHZObj = {};
                        $scope.ttype = 4;
                        $scope.$emit("defaultCall", $scope.ttype);
                        $scope.$emit("toggleFormFunction");
                        $scope.init();
                    }).error(function(msg) {
                        $scope.showAlert('Error', 'Error creating Data: ' + msg);
                    });
                });


            }
            //update call for dhcp
        $scope.updateDhcpProfile = function() {
                var dhcpObj = {
                    "profileType": 4,
                    "name": $scope.defaultObj.dhcpProfileName.split(" ").join(""),
                    "profileId": $rootScope.profileID,
                    "radioMode": $scope.defaultObj.rMode.value,
                    "linkType": $scope.defaultObj.lType.value,
                    "dhdto": {
                        "radio": 0,
                        "nodeId": 0,
                        "status": 0,
                        "message": null,
                        "dhcpServer": $scope.fiveGHZObj.dhcpServer ? $scope.fiveGHZObj.dhcpServer.id : null,
                        "startIPAddress": $scope.fiveGHZObj.startIP ? $scope.fiveGHZObj.startIP : null,
                        "endIPAddress": $scope.fiveGHZObj.endIP ? $scope.fiveGHZObj.endIP : null,
                        "leaseTime": $scope.fiveGHZObj.leaseTime ? $scope.fiveGHZObj.leaseTime : null,
                        "klanIPAddress": $scope.twopointfourGHZObj.ipaddress ? $scope.twopointfourGHZObj.ipaddress : null,
                        "klanMask": $scope.twopointfourGHZObj.subnetmask ? $scope.twopointfourGHZObj.subnetmask : null,
                        "klandhcpServer": $scope.twopointfourGHZObj.dhcpServer ? $scope.twopointfourGHZObj.dhcpServer.id : null,
                        "klanstartIPAddress": $scope.twopointfourGHZObj.startIP ? $scope.twopointfourGHZObj.startIP : null,
                        "klanendIPAddress": $scope.twopointfourGHZObj.endIP ? $scope.twopointfourGHZObj.endIP : null,
                        "klanleaseTime": $scope.twopointfourGHZObj.leaseTime ? $scope.twopointfourGHZObj.leaseTime : null
                    }
                }
                var confirm = $scope.saveconfirm();

                $mdDialog.show(confirm).then(function() {
                    $http({
                        method: 'POST',
                        url: 'api/v2/profiles/template/update',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        data: dhcpObj
                    }).success(function() {
                        $scope.showAlert('Success', 'Updated successfully.');
                        $scope.defaultObj = {};
                        $scope.twopointfourGHZObj = {};
                        $scope.fiveGHZObj = {};
                        $scope.ttype = 4;
                        $scope.$emit("defaultCall", $scope.ttype);
                        $scope.$emit("toggleFormFunction");
                    }).error(function(msg) {
                        $scope.showAlert('Error', 'Error creating Data: ' + msg);
                    });
                });


            }
            //close the selected form
        $scope.toggleForm = function() {
                $scope.$emit("toggleFormFunction");

            }
            //create conformation
        $scope.createConfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to create this profile?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };
        //update conformation
        $scope.saveconfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to update these changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')


            return confirm;
        };

    }
]);
