dashboard.controller("DiscoveryController", ['$rootScope', '$scope', '$interval', '$mdDialog', '$http', '$state', '$location', 'dashboardService', 'Flash', '$localStorage',
    function ($rootScope, $scope, $interval, $mdDialog, $http, $state, $location, dashboardService, Flash, $localStorage) {
        var vm = this;
        localStorage.setItem("mapload", true);
        // Default Table variables
        $scope.pagesizes = [10, 25, 50, 100];
        $scope.pagesize = $scope.pagesizes[1];
        $scope.currentpage = 1;

        $scope.pagesizesTask = [10, 25, 50, 100];
        $scope.pagesizeTask = $scope.pagesizesTask[1];
        $scope.currentpageTask = 1;

        $scope.modes = [{ "mode": "Unassigned", "modeVal": "none" }, { "mode": "All", "modeVal": "all" }]; // Device Status Options
        $scope.selectedMode = $scope.modes[0]; // Selected Device Status filter for table
        $scope.nextBtnDisable = false;
        $scope.actionType = "upgrade"; // Selected action from dropdown
        $scope.actionValue = "upgrade"; // Selected action from dropdown
        $scope.view_tasks = false;

        // Discovery Tabs Variables
        $scope.vm.byNetMask = false;
        $scope.rangeText = '';
        $scope.rangeIPLabel = '';
        $scope.rangeplaceholder = '';

        $scope.discType = "Both";

        $scope.linkTypeDiv = false;  // Display Link Type filter
        $scope.radioModeDiv = false; // Display Radio Mode filter
        $scope.upgradeForm = {};

        $scope.upgradeForm['isImmediate'] = true;

        $scope.timer = null;

        $scope.upgradeAll = false;

        $scope.dis={};
        $scope.dis.provisionAll = false;

        $scope.modeofData = "";
        $scope.tableWidth = "col-md-8";
        $scope.taskdetails = true;
        $scope.startLinkTimer = function () {
            $scope.timer = $interval(function () {
                if (!$scope.clearSearch) {
                    $scope.discoveryTableData($scope.modeofData,$scope.sortOrder,$scope.sortField);
                }
                $scope.provisionCharttimer();
                $scope.dicoveryTasks();
            }, 10000);
        }

        $scope.$on('$destroy', function () {
            $scope.stopTimer();
            //nodesSource.close();
        });

        $scope.stopTimer = function () {
            if (angular.isDefined($scope.timer)) {
                $interval.cancel($scope.timer);
            }
        }

        $scope.gotoLinkStats = function (nodeId, lastView) {
            $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });
        }

        $scope.discoveryConfig = {
            'location': 'Default',
            'retries': '1',
            'timeout': '2000',
            /*'foreignSource': 'Default',*/
            'begin': '',
            'byNetMask': '',
            'end': ''
        };
        $scope.specificConfig = {
            'location': 'Default',
            'retries': '1',
            'timeout': '2000',
            'content': ''
        };

        // Directive functions
        $("button").click(function () {
            $("button").removeClass("active");
            $(this).addClass("active");
        });

        $scope.init = function () {
            $scope.rangeText = 'By Mask';//'By Range';
            $scope.rangeIPLabel = 'IP Range Begin';
            $scope.rangeplaceholder = 'End';
            $scope.discoveryConfig.byNetMask = 'false';
            $scope.discoveryTableData("");
            $scope.startLinkTimer();
            $scope.provisionChart();
            $scope.dicoveryTasks();
        }

        $scope.provisionChart = function () {
            $http.get('api/v2/discovery/gsummary', { showdiv: false }).then(function (response) {
                if (response.status == 204) {
                    $scope.provisionStats = [];
                } else if (response.status == 200 && response.data) {
                    $scope.provisionStats = {
                        "labels": ["Unprovisioned", "AP", "SU"],
                        "provision": [response.data.total, response.data.ap, response.data.su]
                    }
                }
                if ($scope.provisionStats == []) {
                    $scope.provision_config = {
                        type: 'bar',
                        data: {
                            datasets: [{
                                data: [0, 0, 0],
                                backgroundColor: ["#e74b4b", "#eb7f2c", "#f1aa00", "#f8e443", "#8dce71", "#cbcbcb", "#d9e893"]
                            }],
                            labels: $scope.provisionStats.labels
                        },
                        options: {
                            // responsive: true,
                            maintainAspectRatio: false,
                            //title: { display: true, text: "Severity"},
                            scales: {
                                xAxes: [{
                                    ticks: {
                                        fontSize: 10,
                                        fontStyle: 'bold'
                                    },
                                    barThickness: 30
                                }]
                            },
                            animation: { animateScale: true, animateRotate: true },
                            tooltips: {
                                callbacks: {
                                    label: function (tooltipItem, data) {
                                        var labelValue = 'No data';
                                        return labelValue;
                                    }
                                }
                            }
                        }
                    };
                } else {
                    $scope.provision_config = {
                        type: 'bar',
                        height: 100,
                        data: {
                            datasets: [{
                                data: $scope.provisionStats.provision,
                                backgroundColor: ["#e74b4b", "#eb7f2c", "#f1aa00", "#f8e443", "#8dce71", "#cbcbcb", "#d9e893"]
                            }],
                            labels: $scope.provisionStats.labels
                        },
                        options: {
                            // responsive: true,
                            maintainAspectRatio: false,
                            //title: { display: true, text: "Severity Chart for " +$scope.selectedMode + " for " + $scope.chart_time_label},
                            scales: {
                                xAxes: [{
                                    ticks: {
                                        fontSize: 10,
                                        fontStyle: 'bold'
                                    },
                                    barThickness: 30,
                                    gridLines: {
                                        display: false
                                    }
                                }],
                                yAxes: [{
                                    ticks: {
                                        beginAtZero: true
                                    }
                                }]
                            },
                            animation: { animateScale: true, animateRotate: true }
                        }
                    };
                }
                // Generate Severity Chart with config
                var provision_ctx = document.getElementById("provisionchart").getContext("2d");
                $scope.provisionchartnew = new Chart(provision_ctx, $scope.provision_config);
            });
        }

        $scope.provisionCharttimer = function () {
            $http.get('api/v2/discovery/gsummary', { showdiv: false }).then(function (response) {
                if (response.status == 204) {
                    $scope.provisionStats = [];
                } else if (response.status == 200 && response.data) {
                    $scope.provisionStats = {
                        "labels": ["Unprovisioned", "AP", "SU"],
                        "provision": [response.data.total, response.data.ap, response.data.su]
                    }
                }
                if ($scope.provisionStats == []) {
                    $scope.provision_config = {
                        type: 'bar',
                        data: {
                            datasets: [{
                                data: [0, 0, 0],
                                backgroundColor: ["#e74b4b", "#eb7f2c", "#f1aa00", "#f8e443", "#8dce71", "#cbcbcb", "#d9e893"]
                            }],
                            labels: $scope.provisionStats.labels
                        },
                        options: {
                            // responsive: true,
                            maintainAspectRatio: false,
                            //title: { display: true, text: "Severity"},
                            scales: {
                                xAxes: [{
                                    ticks: {
                                        fontSize: 10,
                                        fontStyle: 'bold'
                                    },
                                    barThickness: 30
                                }]
                            },
                            animation: { animateScale: true, animateRotate: true },
                            tooltips: {
                                callbacks: {
                                    label: function (tooltipItem, data) {
                                        var labelValue = 'No data';
                                        return labelValue;
                                    }
                                }
                            }
                        }
                    };
                } else {
                    $scope.provision_config = {
                        type: 'bar',
                        height: 100,
                        data: {
                            datasets: [{
                                data: $scope.provisionStats.provision,
                                backgroundColor: ["#e74b4b", "#eb7f2c", "#f1aa00", "#f8e443", "#8dce71", "#cbcbcb", "#d9e893"]
                            }],
                            labels: $scope.provisionStats.labels
                        },
                        options: {
                            // responsive: true,
                            maintainAspectRatio: false,
                            //title: { display: true, text: "Severity Chart for " +$scope.selectedMode + " for " + $scope.chart_time_label},
                            scales: {
                                xAxes: [{
                                    ticks: {
                                        fontSize: 10,
                                        fontStyle: 'bold'
                                    },
                                    barThickness: 30,
                                    gridLines: {
                                        display: false
                                    }
                                }],
                                yAxes: [{
                                    ticks: {
                                        beginAtZero: true
                                    }
                                }]
                            },
                            animation: { animateScale: true, animateRotate: true }
                        }
                    };
                }
                // Generate Severity Chart with config

                $scope.provisionchartnew.update();
                // var provision_ctx = document.getElementById("provisionchart").getContext("2d");
                //new Chart(provision_ctx, provision_config);
            });
        }

        $scope.Taskconfig = {
            params: {
                '_s': '',
                'limit': $scope.pagesizeTask,
                'offset': (($scope.currentpageTask - 1) * $scope.pagesizeTask),
                'orderBy': 'id',
                'order': 'desc'
            }
        };
        $scope.dicoveryTasks = function () {
            var url = 'api/v2/dtask/list?_s=&limit=' + $scope.pagesizeTask + '&offset=' + (($scope.currentpageTask - 1) * $scope.pagesizeTask) + '&order=' + 'desc' + '&orderBy=' + 'id';
            //$http.get('api/v2/dtask/list', $scope.Taskconfig,{ showdiv: false }).then(function (response) {       
            $http.get(url, { showdiv: false }).then(function (response) {
                if (response.status == 204) {
                    $scope.taskdata = [];
                } else if (response.status == 200 && response.data) {
                    $scope.taskdata = response.data.list;
                    if (response.data.list.length < $scope.pagesizeTask) {
                        $scope.nextBtnDisable = true;
                    }
                }
            });
        }

        // Pagination method
        $scope.pagingTask = function (val) {
            if (val == 'previous') {
                --$scope.currentpageTask;
            } else if (val == 'next') {
                ++$scope.currentpageTask;
            }
            $scope.Taskconfig = {
                params: {
                    '_s': '',
                    'limit': $scope.pagesizeTask,
                    'offset': (($scope.currentpageTask - 1) * $scope.pagesizeTask),
                    'orderBy': 'id',
                    'order': 'desc'
                }
            };
            var url = 'api/v2/dtask/list?_s=&limit=' + $scope.pagesizeTask + '&offset=' + (($scope.currentpageTask - 1) * $scope.pagesizeTask) + '&order=' + 'desc' + '&orderBy=' + 'id';
            $http.get(url, { showdiv: false }).then(function (response) {
                //$http.get('api/v2/dtask/list', $scope.Taskconfig,{ showdiv: false }).then(function (response) {                
                if (response.status == 204) {
                    $scope.taskdata = [];
                    $scope.nextBtnDisable = true;
                } else if (response.status == 200 && response.data) {
                    $scope.taskdata = response.data.list;
                    if (val == "next") {
                        if (response.data.list.length < $scope.pagesizeTask) {
                            $scope.nextBtnDisable = true;
                        }
                    } else {
                        if (response.data.list.length >= $scope.pagesizeTask) {
                            $scope.nextBtnDisable = false;
                        }
                    }
                }
            });
        }

        //Page size change method
        $scope.changePageSizeTask = function (pagesizeTask) {
            $scope.currentpageTask = 1;
            $scope.pagesizeTask = pagesizeTask;
            $scope.Taskconfig = {
                params: {
                    '_s': '',
                    'limit': $scope.pagesizeTask,
                    'offset': (($scope.currentpageTask - 1) * $scope.pagesizeTask),
                    'orderBy': 'id',
                    'order': 'desc'
                }
            };
            var url = 'api/v2/dtask/list?_s=&limit=' + $scope.pagesizeTask + '&offset=' + (($scope.currentpageTask - 1) * $scope.pagesizeTask) + '&order=' + 'desc' + '&orderBy=' + 'id';
            $http.get(url, { showdiv: false }).then(function (response) {
                if (response.status == 204) {
                    $scope.taskdata = [];
                    $scope.nextBtnDisable = true;
                } else if (response.status == 200 && response.data) {
                    $scope.taskdata = response.data.list;
                    if (response.data.list.length < $scope.pagesizeTask) {
                        $scope.nextBtnDisable = true;
                    } else {
                        $scope.nextBtnDisable = false;
                    }
                }
            });
        }

        // Toggle between Range and Mask in IP Range
        $scope.toggleText = function () {
            if ($scope.discoveryConfig.byNetMask == false) {
                $scope.rangeText = 'By Mask';//'By Range';
                $scope.rangeIPLabel = 'IP Range Begin';
                $scope.rangeplaceholder = 'End';
            } else if ($scope.discoveryConfig.byNetMask == true) {
                $scope.rangeText = 'By Mask';
                $scope.rangeIPLabel = 'Subnet Mask';
                $scope.rangeplaceholder = 'Subnet Mask';
            }
        }

        // Check local storage of Columns to load
        if (!$localStorage.flag_D) {
            $scope.cols = [
                { 'label': 'System Name', 'sortField': 'sysName', 'status': true, 'alignment': 'text-align:left' },
                { 'label': 'Primary IP', 'sortField': 'ipAddress', 'status': true, 'alignment': 'text-align:left' },
                { 'label': 'MAC Address', 'sortField': 'macaddress', 'status': true, 'alignment': 'text-align:left' },
                { 'label': 'Serial Number', 'sortField': 'serialNum', 'status': true, 'alignment': 'text-align:left' },
                { 'label': 'Model Number', 'sortField': 'modelNum', 'status': true,'alignment': 'text-align:left' },
                { 'label': 'Firmware', 'sortField': 'firmware', 'status': true,'alignment': 'text-align:right' },
                { 'label': 'Status', 'sortField': 'status', 'status': true,'alignment': 'text-align:right' },
                { 'label': 'Up Time', 'sortField': 'sysUptime', 'status': true,'alignment': 'text-align:right' },
                { 'label': 'Product Code', 'sortField': 'productCode', 'status': true },
                { 'label': 'Radio Mode', 'sortField': 'radioMode', 'status': true },
                { 'label': 'Operation Mode', 'sortField': 'opMode', 'status': false },
                { 'label': 'Frequency', 'sortField': 'frequency', 'status': false },
                { 'label': 'Bandwidth', 'sortField': 'bandwidth', 'status': false, 'alignment': 'text-align:left' },
                { 'label': 'Channel', 'sortField': 'channel', 'status': false },
                { 'label': 'Elevation', 'sortField': 'elevation', 'status': false },
                { 'label': 'SSID', 'sortField': 'ssid', 'status': false },
                { 'label': 'Local SNR', 'sortField': 'lsnr', 'status': false },
                { 'label': 'Remote Partners', 'sortField': 'remotePartners', 'status': false },
                { 'label': 'Backup IP', 'sortField': 'fallbackIP', 'status': false },
                { 'label': 'Net Mask', 'sortField': 'netmask', 'status': false, 'alignment': 'text-align:left' },
                { 'label': 'Gateway', 'sortField': 'gateway', 'status': false, 'alignment': 'text-align:left' },
                { 'label': 'Region', 'sortField': 'region', 'status': false },
                { 'label': 'Facility', 'sortField': 'location', 'status': false }

            ];
            $scope.allToggle = false;
        } else {
            $scope.cols = $localStorage.cols_D;
            $scope.allToggle = $localStorage.allToggle;
        }

        // To show or hide columns in the table
        $scope.showhideColinDiscovery = function (colObj, ind) {
            $scope.cols[ind].status = colObj.status;
            $localStorage.flag_D = true;
            $localStorage.cols_D = $scope.cols;
            $scope.allToggle = false;
            $localStorage.allToggle_D = false;
        }

        // To show all or default columns in table
        $scope.showAllCol = function (allToggle) {
            if (allToggle) {
                // Show all Columns in the table
                $scope.cols = [
                    { 'label': 'System Name', 'sortField': 'sysName', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Primary IP', 'sortField': 'ipAddress', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'MAC Address', 'sortField': 'macaddress', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Serial Number', 'sortField': 'serialNum', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Model Number', 'sortField': 'modelNum', 'status': true,'alignment': 'text-align:left' },
                    { 'label': 'Firmware', 'sortField': 'firmware', 'status': true ,'alignment': 'text-align:right'},
                    { 'label': 'Status', 'sortField': 'status', 'status': true,'alignment': 'text-align:right' },
                    { 'label': 'Up Time', 'sortField': 'sysUptime', 'status': true,'alignment': 'text-align:right' },
                    { 'label': 'Product Code', 'sortField': 'productCode', 'status': true },
                    { 'label': 'Radio Mode', 'sortField': 'radioMode', 'status': true },
                    { 'label': 'Operation Mode', 'sortField': 'opMode', 'status': true },
                    { 'label': 'Frequency', 'sortField': 'frequency', 'status': true },
                    { 'label': 'Bandwidth', 'sortField': 'bandwidth', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Channel', 'sortField': 'channel', 'status': true },
                    { 'label': 'Elevation', 'sortField': 'elevation', 'status': true },
                    { 'label': 'SSID', 'sortField': 'ssid', 'status': true },
                    { 'label': 'Local SNR', 'sortField': 'lsnr', 'status': true },
                    { 'label': 'Remote Partners', 'sortField': 'remotePartners', 'status': true },
                    { 'label': 'Backup IP', 'sortField': 'fallbackIP', 'status': true },
                    { 'label': 'Net Mask', 'sortField': 'netmask', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Gateway', 'sortField': 'gateway', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Region', 'sortField': 'region', 'status': true },
                    { 'label': 'Facility', 'sortField': 'facility', 'status': true }
                ];
                $scope.allToggle = true;
                $localStorage.allToggle_D = true;
            } else {
                // Show default columns in the table
                $scope.cols = [
                    { 'label': 'System Name', 'sortField': 'sysName', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Primary IP', 'sortField': 'ipAddress', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'MAC Address', 'sortField': 'macaddress', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Serial Number', 'sortField': 'serialNum', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Model Number', 'sortField': 'modelNum', 'status': true,'alignment': 'text-align:left' },
                    { 'label': 'Firmware', 'sortField': 'firmware', 'status': true,'alignment': 'text-align:right' },
                    { 'label': 'Status', 'sortField': 'status', 'status': true,'alignment': 'text-align:right' },
                    { 'label': 'Up Time', 'sortField': 'sysUptime', 'status': true,'alignment': 'text-align:right' },
                    { 'label': 'Product Code', 'sortField': 'productCode', 'status': false },
                    { 'label': 'Radio Mode', 'sortField': 'radioMode', 'status': false },
                    { 'label': 'Operation Mode', 'sortField': 'opMode', 'status': false },
                    { 'label': 'Frequency', 'sortField': 'frequency', 'status': false },
                    { 'label': 'Bandwidth', 'sortField': 'bandwidth', 'status': false, 'alignment': 'text-align:left' },
                    { 'label': 'Channel', 'sortField': 'channel', 'status': false },
                    { 'label': 'Elevation', 'sortField': 'elevation', 'status': false },
                    { 'label': 'SSID', 'sortField': 'ssid', 'status': false },
                    { 'label': 'Local SNR', 'sortField': 'lsnr', 'status': false },                  
                    { 'label': 'Remote Partners', 'sortField': 'remotePartners', 'status': false },
                    { 'label': 'Backup IP', 'sortField': 'fallbackIP', 'status': false },
                    { 'label': 'Net Mask', 'sortField': 'netmask', 'status': false, 'alignment': 'text-align:left' },
                    { 'label': 'Gateway', 'sortField': 'gateway', 'status': false, 'alignment': 'text-align:left' },
                    { 'label': 'Region', 'sortField': 'region', 'status': false },
                    { 'label': 'Facility', 'sortField': 'facility', 'status': false }
                ];
                $scope.allToggle = false;
                $localStorage.allToggle_D = false;
            }
            $localStorage.flag_D = true;
            $localStorage.cols_D = $scope.cols;
        }

        //$scope.searchInput = ''; //Default Search for Device table

        $scope.clearSearch = false; //Default clear search

        // Get Devices for the table
        $scope.discoveryTableData = function (modeofData, sortOrder, sortField) {
            //var prov
            if (!modeofData) {
                $scope.modeofData = "none";

            } else {
                $scope.modeofData = modeofData;
            }
            if (!sortOrder || !sortField) {
                // If no sort order or sort field
                $scope.sortField = "sysUptime";
                $scope.sortOrder = "desc";
            } else {
                $scope.sortField = sortField;
                $scope.sortOrder = sortOrder;
            }
            var url = "api/v2/discovery/showunprovisioned?show=" + modeofData + "&ofs=" + (($scope.currentpage - 1) * $scope.pagesize) + "&limit=" + $scope.pagesize + '&sort=' + $scope.sortField + '&by=' + $scope.sortOrder;;
            $http.get(url, { showdiv: false }).then(function (response) {
                if ($scope.radiomode && $scope.linktype) {
                    // If Radio mode and Link type is available
                    $scope.filterArray = [];
                    //$scope.upgradeArray = [];
                    $scope.discoveredDivices = response.data;
                    if ($scope.discoveredDivices) {
                        var rm = $scope.radiomode.val;
                        if ($scope.radiomode.val == 'sta') {
                            rm = 'SU';
                        }
                        // Adding ellipsis for the long string
                        for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                            $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                            if ($scope.discoveredDivices[i].productCode && $scope.discoveredDivices[i].radioMode) {

                                if ($scope.discoveredDivices[i].productCode.toLowerCase() == $scope.linktype.name.toLowerCase() && $scope.discoveredDivices[i].radioMode.toLowerCase() == rm.toLowerCase()) {
                                    $scope.filterArray.push($scope.discoveredDivices[i]);
                                }
                            }
                        }
                    }

                    $scope.discoveredDivices = $scope.filterArray;
                } else if ($scope.radiomode && !$scope.linktype) {
                    $scope.filterArray = [];
                    $scope.discoveredDivices = response.data;
                    if ($scope.discoveredDivices) {
                        var rm = $scope.radiomode.val;
                        if ($scope.radiomode.val == 'sta') {
                            rm = 'SU';
                        }
                        for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                            $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                            if ($scope.discoveredDivices[i].radioMode) {

                                if ($scope.discoveredDivices[i].radioMode.toLowerCase() == rm.toLowerCase()) {
                                    $scope.filterArray.push($scope.discoveredDivices[i]);
                                }
                            }
                        }
                    }

                    $scope.discoveredDivices = $scope.filterArray;
                } else if ($scope.linktype && !$scope.radiomode) {
                    $scope.filterArray = [];
                    $scope.discoveredDivices = response.data;
                    if ($scope.discoveredDivices) {
                        for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                            $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                            if ($scope.discoveredDivices[i].productCode) {

                                if ($scope.discoveredDivices[i].productCode.toLowerCase() == $scope.linktype.name.toLowerCase()) {
                                    $scope.filterArray.push($scope.discoveredDivices[i]);
                                }
                            }
                        }
                    }

                    $scope.discoveredDivices = $scope.filterArray;
                } else {
                    // if no Radio mode and Link type
                    $scope.discoveredDivices = response.data;
                    if ($scope.discoveredDivices) {
                        for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                            $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                        }
                    }
                }
                if ($scope.upgradeArray.length > 0) {
                    for (var t = 0; t < $scope.upgradeArray.length; t++) {
                        for (var j = 0; j < $scope.discoveredDivices.length; j++) {
                            if ($scope.upgradeArray[t].nodeId == $scope.discoveredDivices[j].nodeId) {
                                $scope.discoveredDivices[j].isUpgrade = true;
                            }
                        }
                    }
                }

                if ($scope.provisionArray.length > 0) {
                    for (var t = 0; t < $scope.provisionArray.length; t++) {
                        for (var j = 0; j < $scope.discoveredDivices.length; j++) {
                            if ($scope.provisionArray[t].nodeId == $scope.discoveredDivices[j].nodeId) {
                                $scope.discoveredDivices[j].isProvision = true;
                            }
                        }
                    }
                }

                if ($scope.discoveredDivices.length < $scope.pagesize) {
                    $scope.nextBtnDisable = true;
                } else {
                    $scope.nextBtnDisable = false;
                }
                $scope.TotalPages = response.data.length;
                if ($scope.discoveredDivices == null) {
                    $scope.TotalPages = 0;
                }
                $scope.pagenumber = Math.ceil($scope.discoveredDivices.length / $scope.pagesize);
                if ($scope.pagenumber == 0) {
                    $scope.pagenumber = 1;
                }
            });
        }

        $scope.clearsearchInput = function () {
            $scope.specificConfig.searchInput = '';
            $scope.clearSearch = false;
            $scope.discoveryTableData();
        }

        // Search for IP Address or System Name
        $scope.search = function (Input) {
            if (Input) {
                var url = 'api/v2/nodes/search?_s=sysName==' + Input + '*' + ',' + 'label==' + Input +',assetRecord.serialNumber=='+ Input + '&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=asc';
                $http.get(url, { showdiv: false })
                    .then(function (response) {
                        $scope.clearSearch = true;
                        if (response.data) {
                            $scope.discoveredDivices = response.data.nodes;
                            if ($scope.discoveredDivices) {

                                if ($scope.radiomode && $scope.linktype) {
                                    // If Radio mode and Link type is available
                                    $scope.filterArray = [];
                                    //$scope.upgradeArray = [];
                                    $scope.discoveredDivices = response.data.nodes;
                                    if ($scope.discoveredDivices) {
                                        var rm = $scope.radiomode.val;
                                        if ($scope.radiomode.val == 'sta') {
                                            rm = 'SU';
                                        }
                                        // Adding ellipsis for the long string
                                        for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                            $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                                            if ($scope.discoveredDivices[i].productCode && $scope.discoveredDivices[i].radioMode) {

                                                if ($scope.discoveredDivices[i].productCode.toLowerCase() == $scope.linktype.name.toLowerCase() && $scope.discoveredDivices[i].radioMode.toLowerCase() == rm.toLowerCase()) {
                                                    $scope.filterArray.push($scope.discoveredDivices[i]);
                                                }
                                            }
                                        }
                                    }

                                    $scope.discoveredDivices = $scope.filterArray;
                                } else if ($scope.radiomode && !$scope.linktype) {
                                    $scope.filterArray = [];
                                    $scope.discoveredDivices = response.data;
                                    if ($scope.discoveredDivices) {
                                        var rm = $scope.radiomode.val;
                                        if ($scope.radiomode.val == 'sta') {
                                            rm = 'SU';
                                        }
                                        for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                            $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                                            if ($scope.discoveredDivices[i].radioMode) {

                                                if ($scope.discoveredDivices[i].radioMode.toLowerCase() == rm.toLowerCase()) {
                                                    $scope.filterArray.push($scope.discoveredDivices[i]);
                                                }
                                            }
                                        }
                                    }

                                    $scope.discoveredDivices = $scope.filterArray;
                                } else if ($scope.linktype && !$scope.radiomode) {
                                    $scope.filterArray = [];
                                    $scope.discoveredDivices = response.data;
                                    if ($scope.discoveredDivices) {
                                        for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                            $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                                            if ($scope.discoveredDivices[i].productCode) {

                                                if ($scope.discoveredDivices[i].productCode.toLowerCase() == $scope.linktype.name.toLowerCase()) {
                                                    $scope.filterArray.push($scope.discoveredDivices[i]);
                                                }
                                            }
                                        }
                                    }

                                    $scope.discoveredDivices = $scope.filterArray;
                                } else {
                                    // if no Radio mode and Link type
                                    $scope.discoveredDivices = response.data.nodes;
                                    if ($scope.discoveredDivices) {
                                        for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                            $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                                        }
                                    }
                                }
                                if ($scope.upgradeArray.length > 0) {
                                    for (var t = 0; t < $scope.upgradeArray.length; t++) {
                                        for (var j = 0; j < $scope.discoveredDivices.length; j++) {
                                            if ($scope.upgradeArray[t].nodeId == $scope.discoveredDivices[j].nodeId) {
                                                $scope.discoveredDivices[j].isUpgrade = true;
                                            }
                                        }
                                    }
                                }

                                if ($scope.provisionArray.length > 0) {
                                    for (var t = 0; t < $scope.provisionArray.length; t++) {
                                        for (var j = 0; j < $scope.discoveredDivices.length; j++) {
                                            if ($scope.provisionArray[t].nodeId == $scope.discoveredDivices[j].nodeId) {
                                                $scope.discoveredDivices[j].isProvision = true;
                                            }
                                        }
                                    }
                                }
                                $scope.TotalPages = response.data.nodes.length;

                                if ($scope.discoveredDivices == null) {
                                    $scope.TotalPages = 0;
                                }
                                $scope.pagenumber = Math.ceil($scope.discoveredDivices.length / $scope.pagesize);
                                if ($scope.pagenumber == 0) {
                                    $scope.pagenumber = 1;
                                }
                                if (response.data.nodes.length < $scope.pagesize) {
                                    $scope.nextBtnDisable = true;
                                }
                            }
                        } else {
                            $scope.discoveredDivices = [];
                        }
                    });
            }
        }

        // To add ellipsis for long string in the middle
        function ellipsemodel(str) {
            if (str) {
                if (str.length > 15) {
                    return str.substr(0, 10) + ' ... ' + str.substr(str.length - 10, str.length);
                }
                return str;
            }
        }

        // Change the Device status to filter the table
        $scope.changeModeofData = function (modeofData) {
            $scope.specificConfig.searchInput = '';
            $scope.clearSearch = false;
            $scope.provisionArray = [];
            $scope.upgradeArray = [];
            $scope.dis.provisionAll = false;
            $scope.upgradeAll = false;
            $scope.sortOrder = $scope.sortOrder;
            $scope.sortField = $scope.sortField;
            $scope.modeofData = modeofData.modeVal;
            $scope.discoveryTableData($scope.modeofData, $scope.sortOrder, $scope.sortField);
        }

        // Change the page size or number of records per page in table
        $scope.changePageSize = function (pagesize) {
            $scope.provisionArray = [];
            $scope.upgradeArray = [];
            $scope.dis.provisionAll = false;
            $scope.upgradeAll = false;
            $scope.currentpage = 1;
            $scope.sortOrder = $scope.sortOrder;
            $scope.sortField = $scope.sortField;
            // Device Status filter
            if (!$scope.modeofData) {
                $scope.modeofData = "none";
            } else {
                $scope.modeofData = $scope.modeofData;
            }
            $scope.pagesize = pagesize;
            if (!$scope.clearSearch) {
                var url = "api/v2/discovery/showunprovisioned?show=" + $scope.modeofData + "&ofs=" + (($scope.currentpage - 1) * $scope.pagesize) + "&limit=" + $scope.pagesize + '&sort=' + $scope.sortField + '&by=' + $scope.sortOrder;
                $http.get(url, { showdiv: false }).then(function (response) {
                    if ($scope.radiomode && $scope.linktype) {
                        $scope.filterArray = [];
                        $scope.discoveredDivices = response.data;
                        var rm = $scope.radiomode.val;
                        if ($scope.radiomode.val == 'sta') {
                            rm = 'SU';
                        }
                        for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                            $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                        }
                        for (var t = 0; t < $scope.discoveredDivices.length; t++) {
                            if ($scope.discoveredDivices[t].productCode.toLowerCase() == $scope.linktype.name.toLowerCase() && $scope.discoveredDivices[t].radioMode.toLowerCase() == rm.toLowerCase()) {
                                $scope.filterArray.push($scope.discoveredDivices[t]);
                            }
                        }
                        $scope.discoveredDivices = $scope.filterArray;
                    } else if ($scope.radiomode && !$scope.linktype) {
                        $scope.filterArray = [];
                        $scope.discoveredDivices = response.data;
                        if ($scope.discoveredDivices) {
                            var rm = $scope.radiomode.val;
                            if ($scope.radiomode.val == 'sta') {
                                rm = 'SU';
                            }
                            for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                                if ($scope.discoveredDivices[i].radioMode) {

                                    if ($scope.discoveredDivices[i].radioMode.toLowerCase() == rm.toLowerCase()) {
                                        $scope.filterArray.push($scope.discoveredDivices[i]);
                                    }
                                }
                            }
                        }

                        $scope.discoveredDivices = $scope.filterArray;
                    } else if ($scope.linktype && !$scope.radiomode) {
                        $scope.filterArray = [];
                        $scope.discoveredDivices = response.data;
                        if ($scope.discoveredDivices) {
                            for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                                if ($scope.discoveredDivices[i].productCode) {

                                    if ($scope.discoveredDivices[i].productCode.toLowerCase() == $scope.linktype.name.toLowerCase()) {
                                        $scope.filterArray.push($scope.discoveredDivices[i]);
                                    }
                                }
                            }
                        }

                        $scope.discoveredDivices = $scope.filterArray;
                    } else {
                        $scope.discoveredDivices = response.data;
                        for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                            $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                        }
                    }
                    $scope.TotalPages = response.data.length;
                    if (response.data.length < $scope.pagesize) {
                        $scope.nextBtnDisable = true;
                    } else {
                        $scope.nextBtnDisable = false;
                    }
                    if ($scope.discoveredDivices == null) {
                        $scope.TotalPages = 0;
                    }
                    $scope.pagenumber = Math.ceil($scope.discoveredDivices.length / $scope.pagesize);
                    if ($scope.pagenumber == 0) {
                        $scope.pagenumber = 1;
                    }
                });
            } else {
                var url = 'api/v2/nodes/search?_s=sysName==' + $scope.specificConfig.searchInput + '*' + ',' + 'label==' + $scope.specificConfig.searchInput + '&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=asc';
                $http.get(url, { showdiv: false })
                    .then(function (response) {
                        if ($scope.radiomode && $scope.linktype) {
                            $scope.filterArray = [];
                            $scope.discoveredDivices = response.data.nodes;
                            var rm = $scope.radiomode.val;
                            if ($scope.radiomode.val == 'sta') {
                                rm = 'SU';
                            }
                            for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                            }
                            for (var t = 0; t < $scope.discoveredDivices.length; t++) {
                                if ($scope.discoveredDivices[t].productCode.toLowerCase() == $scope.linktype.name.toLowerCase() && $scope.discoveredDivices[t].radioMode.toLowerCase() == rm.toLowerCase()) {
                                    $scope.filterArray.push($scope.discoveredDivices[t]);
                                }
                            }
                            $scope.discoveredDivices = $scope.filterArray;
                        } else if ($scope.radiomode && !$scope.linktype) {
                            $scope.filterArray = [];
                            $scope.discoveredDivices = response.data;
                            if ($scope.discoveredDivices) {
                                var rm = $scope.radiomode.val;
                                if ($scope.radiomode.val == 'sta') {
                                    rm = 'SU';
                                }
                                for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                    $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                                    if ($scope.discoveredDivices[i].radioMode) {

                                        if ($scope.discoveredDivices[i].radioMode.toLowerCase() == rm.toLowerCase()) {
                                            $scope.filterArray.push($scope.discoveredDivices[i]);
                                        }
                                    }
                                }
                            }

                            $scope.discoveredDivices = $scope.filterArray;
                        } else if ($scope.linktype && !$scope.radiomode) {
                            $scope.filterArray = [];
                            $scope.discoveredDivices = response.data;
                            if ($scope.discoveredDivices) {
                                for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                    $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                                    if ($scope.discoveredDivices[i].productCode) {

                                        if ($scope.discoveredDivices[i].productCode.toLowerCase() == $scope.linktype.name.toLowerCase()) {
                                            $scope.filterArray.push($scope.discoveredDivices[i]);
                                        }
                                    }
                                }
                            }

                            $scope.discoveredDivices = $scope.filterArray;
                        } else {
                            $scope.discoveredDivices = response.data.nodes;
                            for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                            }
                        }
                        $scope.TotalPages = response.data.nodes.length;
                        if (response.data.nodes.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        } else {
                            $scope.nextBtnDisable = false;
                        }
                        if ($scope.discoveredDivices == null) {
                            $scope.TotalPages = 0;
                        }
                        $scope.pagenumber = Math.ceil($scope.discoveredDivices.length / $scope.pagesize);
                        if ($scope.pagenumber == 0) {
                            $scope.pagenumber = 1;
                        }
                    });
            }

        }

        // Table Pagination - Change page number
        $scope.paging = function (type, totalPages, val) {
            $scope.sortOrder = $scope.sortOrder;
            $scope.sortField = $scope.sortField;
            if (!$scope.modeofData) {
                $scope.modeofData = "none";
            } else {
                $scope.modeofData = $scope.modeofData;
            }
            if (val == 'previous') {
                --$scope.currentpage;
            } else if (val == 'next') {
                ++$scope.currentpage;
            }
            if (!$scope.clearSearch) {
                var url = "api/v2/discovery/showunprovisioned?show=" + $scope.modeofData + "&ofs=" + (($scope.currentpage - 1) * $scope.pagesize) + "&limit=" + $scope.pagesize + '&sort=' + $scope.sortField + '&by=' + $scope.sortOrder;
                $http.get(url, { showdiv: false }).then(function (response) {
                    if ($scope.radiomode && $scope.linktype) {
                        $scope.filterArray = [];
                        $scope.discoveredDivices = response.data;
                        var rm = $scope.radiomode.val;
                        if ($scope.radiomode.val == 'sta') {
                            rm = 'SU';
                        }
                        for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                            $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                        }
                        for (var t = 0; t < $scope.discoveredDivices.length; t++) {
                            if ($scope.discoveredDivices[t].productCode.toLowerCase() == $scope.linktype.name.toLowerCase() && $scope.discoveredDivices[t].radioMode.toLowerCase() == rm.toLowerCase()) {
                                $scope.filterArray.push($scope.discoveredDivices[t]);
                            }
                        }
                        $scope.discoveredDivices = $scope.filterArray;
                    } else if ($scope.radiomode && !$scope.linktype) {
                        $scope.filterArray = [];
                        $scope.discoveredDivices = response.data;
                        if ($scope.discoveredDivices) {
                            var rm = $scope.radiomode.val;
                            if ($scope.radiomode.val == 'sta') {
                                rm = 'SU';
                            }
                            for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                                if ($scope.discoveredDivices[i].radioMode) {

                                    if ($scope.discoveredDivices[i].radioMode.toLowerCase() == rm.toLowerCase()) {
                                        $scope.filterArray.push($scope.discoveredDivices[i]);
                                    }
                                }
                            }
                        }

                        $scope.discoveredDivices = $scope.filterArray;
                    } else if ($scope.linktype && !$scope.radiomode) {
                        $scope.filterArray = [];
                        $scope.discoveredDivices = response.data;
                        if ($scope.discoveredDivices) {
                            for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                                if ($scope.discoveredDivices[i].productCode) {

                                    if ($scope.discoveredDivices[i].productCode.toLowerCase() == $scope.linktype.name.toLowerCase()) {
                                        $scope.filterArray.push($scope.discoveredDivices[i]);
                                    }
                                }
                            }
                        }

                        $scope.discoveredDivices = $scope.filterArray;
                    } else {
                        $scope.discoveredDivices = response.data;
                        for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                            $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                        }
                    }
                    $scope.TotalPages = response.data.length;
                    if (val == "next") {
                        if (response.data.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        }
                    } else {
                        if (response.data.length >= $scope.pagesize) {
                            $scope.nextBtnDisable = false;
                        }
                    }
                    if ($scope.discoveredDivices == null) {
                        $scope.TotalPages = 0;
                    }
                    $scope.pagenumber = Math.ceil($scope.discoveredDivices.length / $scope.pagesize);
                    if ($scope.pagenumber == 0) {
                        $scope.pagenumber = 1;
                    }
                });
            } else {
                var url = 'api/v2/nodes/search?_s=sysName==' + $scope.specificConfig.searchInput + '*' + ',' + 'label==' + $scope.specificConfig.searchInput + '&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=asc';
                $http.get(url, { showdiv: false }).then(function (response) {
                    if (response.data) {
                        if ($scope.radiomode && $scope.linktype) {
                            $scope.filterArray = [];
                            $scope.discoveredDivices = response.data.nodes;
                            var rm = $scope.radiomode.val;
                            if ($scope.radiomode.val == 'sta') {
                                rm = 'SU';
                            }
                            for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                            }
                            for (var t = 0; t < $scope.discoveredDivices.length; t++) {
                                if ($scope.discoveredDivices[t].productCode.toLowerCase() == $scope.linktype.name.toLowerCase() && $scope.discoveredDivices[t].radioMode.toLowerCase() == rm.toLowerCase()) {
                                    $scope.filterArray.push($scope.discoveredDivices[t]);
                                }
                            }
                            $scope.discoveredDivices = $scope.filterArray;
                        } else if ($scope.radiomode && !$scope.linktype) {
                            $scope.filterArray = [];
                            $scope.discoveredDivices = response.data;
                            if ($scope.discoveredDivices) {
                                var rm = $scope.radiomode.val;
                                if ($scope.radiomode.val == 'sta') {
                                    rm = 'SU';
                                }
                                for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                    $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                                    if ($scope.discoveredDivices[i].radioMode) {

                                        if ($scope.discoveredDivices[i].radioMode.toLowerCase() == rm.toLowerCase()) {
                                            $scope.filterArray.push($scope.discoveredDivices[i]);
                                        }
                                    }
                                }
                            }

                            $scope.discoveredDivices = $scope.filterArray;
                        } else if ($scope.linktype && !$scope.radiomode) {
                            $scope.filterArray = [];
                            $scope.discoveredDivices = response.data;
                            if ($scope.discoveredDivices) {
                                for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                    $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                                    if ($scope.discoveredDivices[i].productCode) {

                                        if ($scope.discoveredDivices[i].productCode.toLowerCase() == $scope.linktype.name.toLowerCase()) {
                                            $scope.filterArray.push($scope.discoveredDivices[i]);
                                        }
                                    }
                                }
                            }

                            $scope.discoveredDivices = $scope.filterArray;
                        } else {
                            $scope.discoveredDivices = response.data.nodes;
                            for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                            }
                        }
                        $scope.TotalPages = response.data.nodes.length;
                        if (val == "next") {
                            if (response.data.nodes.length < $scope.pagesize) {
                                $scope.nextBtnDisable = true;
                            }
                        } else {
                            if (response.data.nodes.length >= $scope.pagesize) {
                                $scope.nextBtnDisable = false;
                            }
                        }
                        if ($scope.discoveredDivices == null) {
                            $scope.TotalPages = 0;
                        }
                        $scope.pagenumber = Math.ceil($scope.discoveredDivices.length / $scope.pagesize);
                        if ($scope.pagenumber == 0) {
                            $scope.pagenumber = 1;
                        }
                    } else {
                        $scope.nextBtnDisable = true;
                    }


                });
            }

        }

        // Sorting the table
        $scope.sort = function (sortField) {
            $scope.currentpage = 1;
            if (!$scope.clearSearch) {
                if (sortField == $scope.sortField) {
                    // If same sort field is selected
                    $scope.sortOrder = $scope.sortOrder == 'asc' ? 'desc' : 'asc';
                } else {
                    // If different sort field is selected
                    $scope.sortField = sortField;
                    $scope.sortOrder = 'asc';
                }
                if (!$scope.modeofData) {
                    $scope.modeofData = 'none'
                }
                $scope.discoveryTableData($scope.modeofData, $scope.sortOrder, $scope.sortField);
            } else {
                if ($scope.specificConfig.searchInput) {

                    switch (sortField) {
                        case 'ipAddress': $scope.sortField = 'id';
                            break;

                        case 'macaddress': $scope.sortField = 'macAddress';
                            break;

                        case 'serialNum': $scope.sortField = 'assetRecord.serialNumber';
                            break;

                        case 'modelNum': $scope.sortField = 'assetRecord.modelNumber';
                            break;

                        case 'firmware': $scope.sortField = 'assetRecord.firmware';
                            break;

                        case 'status': $scope.sortField = 'id';
                            break;

                        case 'netmask': $scope.sortField = 'ipConfig.netMask';
                            break;

                        case 'gateway': $scope.sortField = 'ipConfig.gateway';
                            break;

                        default: $scope.sortField = sortField;
                    }

                    //$scope.sortField = 'id';
                    $scope.sortOrder = $scope.sortOrder == 'asc' ? 'desc' : 'asc';
                    var url = 'api/v2/nodes/search?_s=sysName==' + $scope.specificConfig.searchInput + '*' + ',' + 'label==' + $scope.specificConfig.searchInput + '&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=' + $scope.sortOrder + '&orderBy=' + $scope.sortField + '&';
                    $http.get(url, { showdiv: false })
                        .then(function (response) {
                            if (response.data) {
                                $scope.discoveredDivices = response.data.nodes;
                                if ($scope.discoveredDivices) {
                                    for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                                        $scope.discoveredDivices[i].sysNameEllipse = ellipsemodel($scope.discoveredDivices[i].sysName);
                                    }
                                    $scope.TotalPages = response.data.nodes.length;

                                    if ($scope.discoveredDivices == null) {
                                        $scope.TotalPages = 0;
                                    }
                                    $scope.pagenumber = Math.ceil($scope.discoveredDivices.length / $scope.pagesize);
                                    if ($scope.pagenumber == 0) {
                                        $scope.pagenumber = 1;
                                    }
                                    if (response.data.nodes.length < $scope.pagesize) {
                                        $scope.nextBtnDisable = true;
                                    }
                                }
                            }
                        });
                }
            }

        }

        // Scans for IP Range (Begin and End Address)
        $scope.scanDiscovery = function () {
            $http({
                method: 'POST',
                url: 'api/v2/discovery/rangedisc',
                headers: {
                    'Content-Type': 'application/json'
                },
                data: $scope.discoveryConfig
            }).success(function (data, status) {
                $scope.showAlertCustom('Success', 'Discovery scan has been initiated.');
                $scope.discoveryConfig.byNetMask=false;
                // $scope.showAlert('Success', 'Discovery scan has been initiated.');
                $scope.discoveryConfig.begin = "";
                $scope.discoveryConfig.end = "";
                $scope.rangeIPLabel='IP Range Begin';
                $scope.discoveryTableData();
            }).error(function (msg, status) {
                if (status == 412) {
                    //  $scope.showAlert('Info', ' Invalid address.');
                    $scope.showAlertCustom('Info','Invalid address.');
                } else if (status == 412) {
                    // $scope.showAlert('Error', 'User is forbidden to perform the operation.');
                    $scope.showAlertCustom('Error','User is forbidden to perform the operation.');
                } else {
                    //$scope.showAlert('Error', 'Range is invalid or begin range is higher ');
                    $scope.showAlertCustom('Error','Range is invalid or begin range is higher ');
                }
            });
        }

        // Reset the IP Range Tab form
        $scope.resetRangeDiscovery = function () {
            $scope.discoveryConfig.begin = "";
            $scope.discoveryConfig.end = "";
        }

        // Clear the Upload File Tab form
        $scope.resetFile = function () {
            $scope.uploadedFileName = '';
        }

        // Attach a file to the form
        $scope.attachedFile = function (element) {
            $scope.$apply(function ($scope) {
                $scope.file = element.files[0];
                $scope.uploadedFileName = element.files[0].name;
            });
            console.log('file attached');
        };

        // Scans for IP Address
        $scope.scanSpecificAddr = function () {
            $http({
                method: 'POST',
                url: 'api/v2/discovery/specificdisc',
                headers: {
                    'Content-Type': 'application/json'
                },
                data: $scope.specificConfig
            }).success(function (data, status) {
                // $scope.showAlert('Success', 'Discovery scan has been initiated.');
                $scope.showAlertCustom('Success', 'Discovery scan has been initiated.');

                $scope.specificConfig = {};
                $scope.discoveryTableData();
            }).error(function (msg, status) {
                if (status == 302) {
                    //  $scope.showAlert('Info', $scope.specificConfig.content + ' Device already available.');
                    $scope.showAlertCustom( 'Info',$scope.specificConfig.content + ' Device already available.');
                } else if (status == 412) {
                    //$scope.showAlert('Info', $scope.specificConfig.content + ' Invalid address.');
                    $scope.showAlertCustom( 'Info',$scope.specificConfig.content + ' Invalid address.');
                } else {
                    //$scope.showAlert('Error', 'Scan failed due to: ' + msg);
                    $scope.showAlertCustom('Error', 'Scan failed due to: ' + msg);
                }
            });
        }

        // Clear IP Address Tab form
        $scope.resetSpecificAddr = function () {
            $scope.specificConfig.content = "";
        }

        // Default table & form bindings
        $scope.dynamic_col_left_status = true;
        $scope.dynamic_col_left = "col-md-12"

        // Load table & filters based on the Upgrade or Provision selected in the dropdown
        $scope.actionTypeCall = function (actionType) {
            $scope.specificConfig.searchInput = '';
            $scope.clearSearch = false;
            $scope.tableWidth = "col-md-8";
            $scope.taskdetails = true;
            if (actionType == 'upgrade') {
                $scope.dynamic_col_left = "col-md-12";
                $scope.actionValue = actionType;
                $scope.view_provision = false;
                $scope.view_upgrade = false;
                $scope.linkTypeDiv = false;
                $scope.radioModeDiv = false;
                $scope.linktype = "";
                $scope.radiomode = "";
                $scope.discoveryTableData($scope.modeofData, $scope.sortOrder, $scope.sortField);
            }
            if (actionType == 'provision') {
                $scope.dynamic_col_left = "col-md-12";
                $scope.actionValue = actionType;
                $scope.view_provision = false;
                $scope.view_upgrade = false;
                $scope.linkType = [{
                    'name': "PTP",
                    'value': 1
                },
                {
                    'name': "BackHaul",
                    'value': 2
                },
                {
                    'name': "PTMP",
                    'value': 3
                }
                ];
                $scope.radioMode = [{
                    'name': "AP",
                    'value': 1,
                    'val': "ap"
                },
                {
                    'name': "SU",
                    'value': 2,
                    'val': "sta"
                }
                ];
                //$scope.linktype = $scope.linkType[0]; // Default Link type
                //$scope.radiomode = $scope.radioMode[0]; // Default Radio mode
                $scope.linkTypeDiv = true; // Display Link type
                $scope.radioModeDiv = true; // Display Radio mode
                $scope.discoveryTableData($scope.modeofData, $scope.sortOrder, $scope.sortField);
            }
        }

        // On Link type change, load devices of selected link type in table
        $scope.linkTypeChange = function (selectedLinkType) {
            $scope.specificConfig.searchInput = '';
            $scope.clearSearch = false;
            $scope.provisionArray = [];
            $scope.upgradeArray = [];
            $scope.dis.provisionAll = false;
            $scope.upgradeAll = false;
            $scope.linktype = selectedLinkType;
            $scope.discoveryTableData($scope.modeofData);
        }

        // On Radio mode change, load devices of selected Radio mode in table
        $scope.radioModeChange = function (selectedRadioMode) {
            $scope.specificConfig.searchInput = '';
            $scope.clearSearch = false;
            $scope.provisionArray = [];
            $scope.upgradeArray = [];
            $scope.dis.provisionAll = false;
            $scope.upgradeAll = false;
            $scope.radiomode = selectedRadioMode;
            $scope.discoveryTableData($scope.modeofData);
        }

        // Open Upgrade form & load firmware
        $scope.upgrade = function () {
            if ($scope.upgradeArray.length > 0) {
                getFirmwares();
                $scope.dynamic_col_left = "col-md-8";
                $scope.dynamic_col_right = "col-md-4";
                $scope.view_upgrade = true;
                $scope.view_provision = false;
                $scope.tableWidth = "col-md-12";
                $scope.taskdetails = false;
            } else {
                //$scope.showAlert('Warning', 'Please select atleast one device.');
                $scope.showAlertCustom('Warning','Please select atleast one device.');
            }
        }

        // Close form
        $scope.cancel = function () {
            $scope.dynamic_col_left = "col-md-12";
            $scope.dynamic_col_right = "";
            $scope.view_upgrade = false;
            $scope.view_provision = false;
            $scope.tableWidth = "col-md-8";
            $scope.taskdetails = true;
        }

        // Open Provision form and load profiles
        $scope.provision = function () {
            if ($scope.provisionArray.length > 0) {
                // If atleast one device is selected
                getFirmwares();   // Load firmwares for selection
                $scope.dynamic_col_left = "col-md-8";
                $scope.dynamic_col_right = "col-md-4";
                $scope.view_provision = true;
                $scope.view_upgrade = false;
                $scope.tableWidth = "col-md-12";
                $scope.taskdetails = false;
                // Profile Type Options
                $scope.profileTypeArray = [{
                    "name": "Default Profile",
                    "value": -1
                }, {
                    "name": "VLAN Profile",
                    "value": 1
                }, {
                    "name": "Ethernet Profile",
                    "value": 2
                }, {
                    "name": "Radius Profile",
                    "value": 3
                }, {
                    "name": "DHCP Profile",
                    "value": 4
                }, {
                    "name": "Wireless Profile",
                    "value": 5
                }, {
                    "name": "DDRS/ATPC Profile",
                    "value": 6
                }, {
                    "name": "Snmp Profile",
                    "value": 7
                }];
                $scope.selectedProfileType = $scope.profileTypeArray[0]; // Default selected profile type
                $scope.selectedProfileMethod($scope.selectedProfileType);
            } else {
                // If no devices are selected
                //$scope.showAlert('Warning', 'Please select atleast one device.');
                $scope.showAlertCustom('Warning','Please select atleast one device.');
            }
        }

        // Get Profiles based on Profile Type selection
        $scope.selectedProfileMethod = function (selectedProfileType) {
            var url = 'api/v2/profiles/template/list?ttype=' + selectedProfileType.value + '&ltype=-1&rtype=-1&page=1&limit=&sort=name.asc';
            $http.get(url, { showdiv: false })
                .then(function (response) {
                    $scope.profilesArray = response.data;
                    $scope.selectedProfile = $scope.profilesArray[0];
                });
        }

        // To expand the form to full width
        $scope.toggle_window_size = function () {
            if (!$scope.max_set) {
                $scope.dynamic_col_left_status = false;
                $scope.dynamic_col_right = "col-md-12";
                $scope.max_set = true;
            } else {
                $scope.dynamic_col_left_status = true;
                $scope.dynamic_col_right = "col-md-4";
                $scope.max_set = false;
            }
        }

        // Show Alert function for controller
        $scope.showAlert = function (msgType, msg, ev) {
            $mdDialog.show(
                $mdDialog.alert()
                    .parent(angular.element(document.querySelector('#popupContainer')))
                    .clickOutsideToClose(true)
                    .title(msgType)
                    .textContent(msg)
                    .ariaLabel('Alert')
                    .ok('OK')
                    .targetEvent(ev)
            );
        };

        $scope.showalertdiscovery = function (title,msg, ev) {
            var confirm = $mdDialog.confirm()
                .title(title)
                .textContent(msg)
                .targetEvent(ev)
                .ok('Ok')
            return confirm;
        }

        // Keep open the Select columns dropdown
        $("document").ready(function () {
            $('.dropdown-menu').on('click', function (e) {
                if ($(this).hasClass('dropdown-menu')) {
                    e.stopPropagation();
                }
            });
        });

        $scope.provisionArray = []; // Selected devices for provision

        $scope.selectAllProvision = function () {
            $scope.provisionArray = [];
            $scope.dis.provisionAll = event.target.checked;
            for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                $scope.discoveredDivices[i].isProvision = $scope.dis.provisionAll;
                if ($scope.discoveredDivices[i].isProvision) {
                    $scope.provisionArray.push($scope.discoveredDivices[i]);
                }
            }

            if ($scope.provisionArray.length == 0) {
                $scope.dynamic_col_left = "col-md-12";
                $scope.dynamic_col_right = "";
                $scope.view_upgrade = false;
                $scope.view_provision = false;
            }

        }

        // Add Devices to the Provision Array
        $scope.checkprovisioning = function (index, data) {
            $scope.provisionArray = [];
            if ($scope.discoveredDivices[index].isProvision) {
                $scope.discoveredDivices[index].isProvision = false;
            } else {
                $scope.discoveredDivices[index].isProvision = true;
            }
            for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                if ($scope.discoveredDivices[i].isProvision) {
                    $scope.provisionArray.push($scope.discoveredDivices[i]);
                }
            }
            if ($scope.provisionArray.length == 0) {
                $scope.dynamic_col_left = "col-md-12";
                $scope.dynamic_col_right = "";
                $scope.view_upgrade = false;
                $scope.view_provision = false;
            }
        }

        $scope.upgradeArray = [];  // Selected devices for upgrade

        $scope.selectAllUpgrade = function () {
            $scope.upgradeArray = [];
            $scope.upgradeAll = event.target.checked;
            for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                $scope.discoveredDivices[i].isUpgrade = $scope.upgradeAll;
                if ($scope.discoveredDivices[i].isUpgrade) {
                    $scope.upgradeArray.push($scope.discoveredDivices[i]);
                }
            }

            if ($scope.upgradeArray.length == 0) {
                $scope.dynamic_col_left = "col-md-12";
                $scope.dynamic_col_right = "";
                $scope.view_upgrade = false;
                $scope.view_provision = false;
            }
        }

        // Add Devices to the Upgrade Array
        $scope.checkupgrade = function (index, data) {
            $scope.upgradeArray = [];
            if ($scope.discoveredDivices[index].isUpgrade) {
                $scope.discoveredDivices[index].isUpgrade = false;
            } else {
                $scope.discoveredDivices[index].isUpgrade = true;
            }
            for (var i = 0; i < $scope.discoveredDivices.length; i++) {
                if ($scope.discoveredDivices[i].isUpgrade) {
                    $scope.upgradeArray.push($scope.discoveredDivices[i]);
                }
            }
            if ($scope.upgradeArray.length == 0) {
                $scope.dynamic_col_left = "col-md-12";
                $scope.dynamic_col_right = "";
                $scope.view_upgrade = false;
                $scope.view_provision = false;
            }
        }

        $scope.iconsbackground = '#D7D7D7';
        // Get Firmwares to apply to devices
        function getFirmwares() {
            if (!$scope.sortField || !$scope.sortOrder) {
                $scope.sortField = 'fileName';
                $scope.sortOrder = 'asc';
            }
            $http.get('api/v2/firmware/firmwares?' + '&page=' + $scope.currentpage + '&limit=' + -1 + '&sort=' + $scope.sortField + '.' + $scope.sortOrder)
                .success(function (response) {
                    $scope.firmwareArray = response;
                    for (var j = 0; j < $scope.firmwareArray.length; j++) {
                        $scope.firmwareArray[j].bindName = $scope.firmwareArray[j].fileName + ' ( ' + $scope.firmwareArray[j].version + ' ) ';
                    }
                    $scope.upgradeForm.selectedFirmware = $scope.firmwareArray[0];
                })
                .error(function (msg) {
                      // $scope.showAlert('Error', msg);
                      $scope.showAlertCustom('Error',msg);
                });
        }


        // Apply upgrade to selected devices
        $scope.applyUpgrade = function () {
            $(".fixedheaderdashboard").css("background-color", "transparent");
            $scope.iconsbackground = 'grey';
            var confirm = $scope.applyFirmwareConfirm();
            $scope.nodeArray = [];
            $mdDialog.show(confirm).then(function () {
                $(".fixedheaderdashboard").css("background-color", "white");
                $scope.iconsbackground = '#D7D7D7';
                $scope.nodesToApply = $scope.upgradeArray;
                if ($scope.upgradeForm.selectedFirmware.actualName === '' || $scope.nodesToApply.length === 0) {
                    // $scope.showAlert('error', 'Select Firmware and nodes to apply');
                    $scope.showAlertCustom('Error','Select Firmware and nodes to apply');
                    return;
                } else {
                    for (var i = 0; i < $scope.nodesToApply.length; i++) {
                        $scope.nodeArray.push($scope.nodesToApply[i].nodeId)
                    }
                      var imm = 'lat';
                                var sdate = new Date().getTime();
                                if ($scope.upgradeForm.isImmediate) {
                                    imm = 'im';
                                    sdate = new Date().getTime();
                                } else {
                                    sdate = new Date($scope.upgradeForm.sdate).getTime();
                                }
                                var url = 'api/v2/bulk/applyFirmware/' + imm + '/' + sdate + '/?firmware=' + $scope.upgradeForm.selectedFirmware.actualName;

                    $http({
                        method: 'POST',
                        // url: 'api/v2/firmware/applyFirmware?firmware=' + $scope.upgradeForm.selectedFirmware.actualName,
                        url: url,
                        headers: { 'Content-Type': 'application/json' },
                        data: $scope.nodeArray
                    }).success(function () {
                        // $scope.showAlert('The Upgrade has been initiated', 'Please check the events log for additional updates');
                         //$scope.showAlertCustom('Success','The Upgrade has been initiated.'+ ' Please check the events log for additional updates');
                          $(".fixedheaderdashboard").css("background-color", "transparent");
                          $scope.iconsbackground = 'grey';
                          var confirm = $scope.applyprovisionwarning('The Upgrade has been initiated. Please check the events log for additional updates');
                            $mdDialog.show(confirm).then(function () {
                               $(".fixedheaderdashboard").css("background-color", "white");
                               $scope.iconsbackground = '#D7D7D7';
                               $scope.dynamic_col_left = "col-md-12";
                               $scope.upgradeAll=false;
                               $scope.showTasks();
                               //$scope.view_tasks = true;
                               $scope.applyFirmware = {};
                               $scope.nodesToApply = [];
                               $scope.upgradeArray = [];
                               $scope.tableWidth="col-md-8";
                               $scope.taskdetails = true;
                               $('#nodesToApply').val("");
                               $scope.discoveryTableData($scope.modeofData);
                            });
                        //$scope.toggleForm();
                        //$scope.view_provision = false;
                        //$scope.view_upgrade = false;

                    }).error(function (msg) {
                        //$scope.showAlert('Error', 'Cannot apply the firmware: ' + msg);
                        $scope.showAlertCustom('Error','Cannot apply the firmware: ' + msg);
                    });
                }

            });
        };

        $scope.showTasks = function () {
            $http.get('api/v2/task/list?page=0&limit=10&show=all', { showdiv: false })
                .success(function (response) {
                    $scope.tasksArray = response;

                });
        }

        $scope.onTaskSelect = function (task) {
            if ($scope.tasksArray && $scope.tasksArray.length > 0) {
                var c = task.collapse;
                for (var i = 0; i < $scope.tasksArray.length; i++) {
                    $scope.tasksArray[i].collapse = "collapse";
                    if (c != "" && task.taskId == $scope.tasksArray[i].taskId) {
                        $scope.tasksArray[i].collapse = "";
                    }
                }
            }
        }

        // Apply Provision to devices
        $scope.applyProvision = function () {
         $scope.taskdetails = false;
            $(".fixedheaderdashboard").css("background-color", "transparent");
            $scope.iconsbackground = 'grey';
            var confirm = $scope.applyProfileConfirm();
            $scope.nodeArray = [];
            $mdDialog.show(confirm).then(function () {
                $(".fixedheaderdashboard").css("background-color", "white");
                $scope.iconsbackground = '#D7D7D7';
                $scope.nodesToApply = $scope.provisionArray;
                if ($scope.upgradeForm.selectedProfile === '' || $scope.nodesToApply.length === 0) {
                    //$scope.showAlert('error', 'Select a profile to apply');
                    $scope.showAlertCustom('Error','Select a profile to apply');
                    return;
                } else {
                    for (var i = 0; i < $scope.nodesToApply.length; i++) {
                        $scope.nodeArray.push($scope.nodesToApply[i].nodeId)
                    }
                    $http({
                        method: 'POST',
                        url: 'api/v2/profiles/' + $scope.upgradeForm.selectedProfile.id + '/applyToNodes',
                        headers: { 'Content-Type': 'application/json' },
                        data: $scope.nodeArray
                    }).success(function () {
                        //$scope.showAlert('The Provision has been initiated', 'Please check the events log for additional updates');
                         $(".fixedheaderdashboard").css("background-color", "transparent");
                          $scope.iconsbackground = 'grey';
                          var confirm = $scope.applyprovisionwarning('The Provision has been initiated. Please check the events log for additional updates');
                            $mdDialog.show(confirm).then(function () {
                                $(".fixedheaderdashboard").css("background-color", "white");
                                $scope.iconsbackground = '#D7D7D7';
                                $scope.view_provision = false;
                                $scope.view_upgrade = false;
                                $scope.dynamic_col_left = "col-md-12";
                                $scope.tableWidth="col-md-8";
                                $scope.profileToApply = '';
                                $scope.nodesToApply = [];
                                $scope.provisionArray = [];
                                $('#nodesToApply').val("");
                                $scope.dis.provisionAll = false;
                                $scope.discoveryTableData($scope.modeofData);
                                 $scope.taskdetails = true;
                            });
                       // $scope.showAlertCustom('Warning','The Provision has been initiated. Please check the events log for additional updates');
                    }).error(function (msg) {
                        //$scope.showAlert('error', 'Cannot apply the profile: ' + msg);
                        $scope.showAlertCustom('Error','Cannot apply the profile: ' + msg);
                    });
                }
            });
        };
         $scope.applyprovisionwarning = function (msg,ev) {
          var confirm = $mdDialog.confirm()
                        .title('Success')
                        .textContent(msg)
                        .targetEvent(ev)
                        .ok('Ok')
                    return confirm;
            };



        // Apply Firmware confirmation modal
        $scope.applyFirmwareConfirm = function (ev) {
            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Are you sure you want to upgrade these devices?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };

        // Apply profile confirmation Modal
        $scope.applyProfileConfirm = function (ev) {
            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Are you sure you want to provision these devices?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };

        // Redirect to Node View Page
        $scope.gotoNode = function (nodeId, lastView,type) {
//            $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });
            if (type == 'Switch') {
                localStorage.setItem('selectednodetype','switch');
                localStorage.setItem("modetype",'');
                    $state.go('app.swnodeView', { "nodeId": nodeId, "lastView": lastView });
            } else {
                localStorage.setItem('selectednodetype','');
                    $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });
            }
        }

          $scope.gotoLinkStats = function(nodeId, lastView,type) {
                    if (type == 'Switch') {
                    localStorage.setItem('selectednodetype','switch');
                    lastView='app.system';
                        $state.go('app.swnodeView', { "nodeId": nodeId, "lastView": lastView });
                    } else {
                    localStorage.setItem('selectednodetype','');
                        $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });
                    }
                }

        // Upload File Confirmation Modal
        $scope.uploadConfirm = function (ev) {

            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Are you sure you want to upload these file?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };

        $scope.showAlertCustom=function(title,msg){
            $(".fixedheaderdashboard").css("background-color", "transparent");
            $scope.iconsbackground = 'grey';
            var confirm = $scope.showalertdiscovery(title,msg);
            $mdDialog.show(confirm).then(function () {
                $(".fixedheaderdashboard").css("background-color", "white");
                $scope.iconsbackground = '#D7D7D7';
            });
        }

    }
]).directive('chooseFiles', ['$http', function ($http, $mdDialog) {
    return {
        link: function (scope, elem, http, attrs) {
            var button = elem.find('button');
            var input = angular.element(elem[0].querySelector('input#fileInput'));
            button.bind('click', function () {
                input[0].click();
            });
            // Attach file for Upload for Discovery
            input.bind('change', function (e) {
                scope.$apply(function () {
                    var files = e.target.files;
                    if (files[0]) {
                        scope.fileName = files[0].name;
                        scope.uploadedFile = files[0];
                        var r = new FileReader();
                        r.onload = function (e) {
                            var contents = e.target.result;
                            scope.$apply(function () {
                                scope.fileReader = contents;
                            });
                        };

                        r.readAsText(files[0]);
                    } else {
                        scope.fileName = null;
                        scope.fileReader = null;
                    }
                });
            });
            // Upload function for Discovery
            scope.clickUploadFunc = function () {
                var confirm = scope.uploadConfirm();
                var fileExtension = scope.fileName.split('.');
                if (fileExtension[1] == 'csv' || fileExtension[1] == 'CSV') {
                    var url = 'admin/discovery/scanUploadConfig?action=UploadIncludeRange';
                    var fd = new FormData();
                    fd.append("upfile", scope.uploadedFile);
                    var csvObj = parseCSV(scope.fileReader);

                    var checkIP = 0;
                    var checkIPtext = "";
                    var checkFromToIPFlag = 0;
                    var checkFromToIPFlagtext = "";
                    var checkFromToVal = 0;
                    var checkFromToValtext = "";

                    for (var i = 1; i < csvObj.length; i++) {
                        if (!csvObj[i][1] || !csvObj[i][2]) {
                            checkIP++;
                            checkIPtext = parseInt(i) + 1;
                            break;
                        } else {
                            var fromIP = csvObj[i][1].split(".").join("");
                            var toIP = csvObj[i][2].split(".").join("");
                            var fromCheckval = !isNaN(fromIP);
                            var toCheckVal = !isNaN(toIP);

                            if (fromCheckval && !toCheckVal) {
                                checkFromToIPFlag++;
                                checkFromToIPFlagtext = checkFromToIPFlagtext + csvObj[i][2] + " ,";
                            } else if (!fromCheckval && toCheckVal) {
                                checkFromToIPFlag++;
                                checkFromToIPFlagtext = checkFromToIPFlagtext + csvObj[i][1] + " ,";
                            } else if (!fromCheckval && !toCheckVal) {
                                checkFromToIPFlag++;
                                checkFromToIPFlagtext = checkFromToIPFlagtext + csvObj[i][1] + " & " + csvObj[i][2];
                            } else if (fromCheckval && toCheckVal) {
                                fromIPIntVal = convertIpToNumeric(csvObj[i][1]);
                                toIPIntVal = convertIpToNumeric(csvObj[i][2]);
                                if (fromIPIntVal > toIPIntVal) {
                                    checkFromToVal++;
                                    checkFromToValtext = checkFromToValtext + csvObj[i][1] + " & " + csvObj[i][2] + " ,";
                                }
                            }
                        }
                    }

                    if (checkIP != 0) {
                        //scope.showAlert('Warning', checkIPtext + "th row have empty IP");
                        scope.showAlertCustom('Warning',checkIPtext + "th row have empty IP");
                    } else {
                        if (checkFromToIPFlag != 0) {
                            checkFromToIPFlagtext = checkFromToIPFlagtext.replace(/,\s*$/, "");
                            //  scope.showAlert('Warning', "Invalid IP(s) found (" + checkFromToIPFlagtext + ")");
                            scope.showAlertCustom('Warning',"Invalid IP found");
                            // scope.showAlertCustom('Warning',"Invalid IP(s) found (" + checkFromToIPFlagtext + ")");
                        } else {
                            if (checkFromToVal != 0) {
                                checkFromToValtext = checkFromToValtext.replace(/,\s*$/, "");
                                // scope.showAlert('Warning', "Start IP exceeding End IP (" + checkFromToValtext + ")");
                                scope.showAlertCustom('Warning',"Start IP exceeding End IP (" + checkFromToValtext + ")");
                            } else {
                                var request = {
                                    method: 'POST',
                                    url: 'api/v2/discovery/uploaddiscctx',
                                    data: fd,
                                    headers: {
                                        'Content-Type': undefined
                                    }
                                };
                                $http(request)
                                    .success(function (data, status, headers, config) {
                                        //scope.showAlert('Success', 'Uploaded Successfully.');
                                        scope.showAlertCustom('Success', 'Uploaded Successfully.');
                                        scope.fileName = null;
                                        scope.fileReader = null;
                                    })
                                    .error(function (data, status, headers, config) {
                                        console.log('error');
                                        if (status == 403) {
                                            //scope.showAlert('Error', 'Upload failed due to unautherized access.');
                                            scope.showAlertCustom('Error','Upload failed due to unautherized access.');
                                        } else {
                                            // scope.showAlert('Error', 'Uploaded Failed.');
                                            scope.showAlertCustom('Error','Uploaded Failed.');
                                        }

                                    })
                            }
                        }
                    }
                } else {
                    //  scope.showAlert('Error', "File Extension Not Supported");
                    scope.showAlertCustom('Error',"File Extension Not Supported");
                }
            };

            scope.downloadTemplate = function () {
                $http.get('api/v2/firmware/firmwares?' + '&page=' + $scope.currentpage + '&limit=' + -1 + '&sort=' + $scope.sortField + '.' + $scope.sortOrder)
                    .success(function (response) {
                        /*$scope.firmwareArray = response;
                        for (var j = 0; j < $scope.firmwareArray.length; j++) {
                            $scope.firmwareArray[j].bindName = $scope.firmwareArray[j].fileName + ' ( ' + $scope.firmwareArray[j].version + ' ) ';
                        }
                        $scope.upgradeForm.selectedFirmware = $scope.firmwareArray[0];*/
                    });
                /*.error(function(msg) {
                    $scope.showAlert('Error', msg);
                });*/
            };

            function parseCSV(str) {
                var arr = [];
                var quote = false;  // 'true' means we're inside a quoted field

                // Iterate over each character, keep track of current row and column (of the returned array)
                for (var row = 0, col = 0, c = 0; c < str.length; c++) {
                    var cc = str[c], nc = str[c + 1];        // Current character, next character
                    arr[row] = arr[row] || [];             // Create a new row if necessary
                    arr[row][col] = arr[row][col] || '';   // Create a new column (start with empty string) if necessary

                    // If the current character is a quotation mark, and we're inside a
                    // quoted field, and the next character is also a quotation mark,
                    // add a quotation mark to the current column and skip the next character
                    if (cc == '"' && quote && nc == '"') { arr[row][col] += cc; ++c; continue; }

                    // If it's just one quotation mark, begin/end quoted field
                    if (cc == '"') { quote = !quote; continue; }

                    // If it's a comma and we're not in a quoted field, move on to the next column
                    if (cc == ',' && !quote) { ++col; continue; }

                    // If it's a newline (CRLF) and we're not in a quoted field, skip the next character
                    // and move on to the next row and move to column 0 of that new row
                    if (cc == '\r' && nc == '\n' && !quote) { ++row; col = 0; ++c; continue; }

                    // If it's a newline (LF or CR) and we're not in a quoted field,
                    // move on to the next row and move to column 0 of that new row
                    if (cc == '\n' && !quote) { ++row; col = 0; continue; }
                    if (cc == '\r' && !quote) { ++row; col = 0; continue; }

                    // Otherwise, append the current character to the current column
                    arr[row][col] += cc;
                }
                return arr;
            }

            function convertIpToNumeric(ipAddress) {
                var arrIp = ipAddress.split('.');

                var segment1 = parseInt(arrIp[0]);
                var segment2 = parseInt(arrIp[1]);
                var segment3 = parseInt(arrIp[2]);
                var segment4 = parseInt(arrIp[3]);

                var calc = segment4 + (segment3 * 256) + (segment2 * 65536) + (segment1 * 16777216);

                return calc;

            }
        }
    };
}]);

dashboard.directive('netmask', function () {
    return {
        require: 'ngModel',
        link: function (scope, elem, attrs, ctrl) {
            ctrl.$validators.netmask = function (modelValue, viewValue) {
                if (ctrl.$isEmpty(modelValue)) {
                    return false;
                }
                var matcher;
                if ((matcher = viewValue.match(/^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})$/)) != null) {
                    var i;
                    var availableMasks = ["255", "254", "252", "248", "240", "224", "192", "128", "0"];
                    var previous = "255";
                    for (i = 1; i < 5; i++) {
                        if (previous === "255" && (availableMasks.indexOf(matcher[i]) !== -1)) {
                            previous = matcher[i];
                        }
                        else {
                            if (matcher[i] !== "0") {
                                return false;
                            }
                        }
                    }
                    return true;
                }
                else {
                    return false;
                }
            }
        }
    }
});

dashboard.directive('ipaddress', function () {
    return {
        require: 'ngModel',
        link: function (scope, elem, attrs, ctrl) {
            ctrl.$validators.ipaddress = function (modelValue, viewValue) {
                if (ctrl.$isEmpty(modelValue)) {
                    return false;
                }
                var matcher;
                if ((matcher = viewValue.match(/^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})$/)) != null) {
                    var i;
                    var previous = "255";
                    for (i = 1; i < 5; i++) {
                        var octet = parseInt(matcher[i]);
                        if (octet > 255) return false;
                    }
                    return true;
                }
                else {
                    return false;
                }
            }
        }
    }
});