dashboard.controller("EthernetProfileConfigController", ['$rootScope', '$scope', '$mdDialog', '$http', '$state', '$location', 'dashboardService', 'Flash',
    function($rootScope, $scope, $mdDialog, $http, $state, $location, dashboardService, Flash) {
        $scope.tableWidth = "col-md-12";
        $scope.ethProfileObj = {};
        $scope.filter = {};
        //radio mode
        $scope.radioMode = [{
                'name': "All",
                'value': -1
            },
            {
                'name': "AP",
                'value': 1
            }, {
                'name': "SU",
                'value': 2
            }
        ];
        //link types
        $scope.linkType = [{
            'name': "All",
            'value': -1
        }, {
            'name': "PTP",
            'value': 1
        }, {
            'name': "BackHaul",
            'value': 2
        }, {
            'name': "PTMP",
            'value': 3
        }];
        //ethernet inactive status
        $scope.ethInActivityArray = [{
                                                 "id": 5,
                                                 "val": "Enable"
                                             }];

        //ethernet speed array
        $scope.ethSpeedArray = [{
            "id": 0,
            "val": "Auto Negotiation"
        }];
        //from config controller to this method calling
        //if config controller click ethernet this method initates
        $rootScope.$on("init_ethernet", function() {
            //alert('Ctrl2 MyFunction')
            $scope.init();
        });
        $scope.init = function() {
            $scope.aethProfileObj = {};
            $scope.aethProfileObj.ethSpeed = '';
            $scope.aethProfileObj.ethInactivity = '';
            $scope.aethProfileObj.ethMTU = 0;
            $scope.vdefProfileObj = {};
            $scope.vdefProfileObj.ethSpeed = 'required';
            $scope.vdefProfileObj.ethInactivity = 'required';
            $scope.vdefProfileObj.ethMTU = 'required';
            if (!$rootScope.profileID) {
                $scope.create_ethernet_profile = true;
                $scope.edit_ethernet_profile = false;
                $scope.ethProfileObj = {};
                $scope.ethProfileObj.rMode = $scope.radioMode[0];
                $scope.ethProfileObj.lType = $scope.linkType[0];
                $scope.ethProfileObj.ethSpeed = $scope.ethSpeedArray[0];
                $scope.ethProfileObj.ethInactivity = $scope.ethInActivityArray[0];
                $scope.ethProfileObj.ethMTU = 1500;

            } else {
                $scope.create_ethernet_profile = false;
                $scope.edit_ethernet_profile = true;
                $scope.ethProfileObj = {};
                var url = 'api/v2/profiles/template/get?profile=' + $rootScope.profileID;


                $http.get(url).then(function(response) {
                    $scope.ethProfileObj.ethName = response.data.name;
                    $scope.ethProfileObj.rMode = {
                        value: response.data.radioMode
                    }
                    $scope.ethProfileObj.lType = {
                        value: response.data.linkType
                    }
                    $scope.ethProfileObj.ethSpeed = {
                        id: response.data.edto.ethMode
                    }
                    $scope.ethProfileObj.ethInactivity = {
                        id: response.data.edto.ethInactivity
                    }
                    $scope.ethProfileObj.ethMTU = response.data.edto.ethMTU
                });
            }
        }

        //form open
        $scope.showForm = function(selectedForm) {
                $scope.openForm = true;
                $scope.tableWidth = "col-md-7";
                $scope.selectedForm = selectedForm;
            }
            //close the selected form
        $scope.toggleForm = function() {
                $scope.selectedForm = "";
                $scope.openForm = false;
                $scope.tableWidth = "col-lg-12 col-md-12 col-sm-12 col-xs-12";
            }
            //ethmtu validation
        $scope.checkEthMTU = function(num) {

            if (num < 1500 || num > 9000) {
                $scope.ethProfileObj['ethMTU'] = "";
            }
        }

        $scope.removeProperty = function(propery) {
            console.log(propery);
            //propery = null;
            $scope.ethProfileObj[propery] = null;
            $scope.aethProfileObj[propery] = 'display:none;';
            $scope.vdefProfileObj[propery] = '';
        }
            //post call for ethernet profile
        $scope.createEthProfile = function() {

            var ethObj = {
                "profileType": 2,
                "name": $scope.ethProfileObj.ethName.split(" ").join(""),
                "radioMode": $scope.ethProfileObj.rMode.value,
                "linkType": $scope.ethProfileObj.lType.value,
                "edto": {
                    "radio": 0,
                    "nodeId": 0,
                    "status": 0,
                    "message": null,
                    "ethMode": $scope.ethProfileObj.ethSpeed ? $scope.ethProfileObj.ethSpeed.id : null,
                    "ethInactivity": $scope.ethProfileObj.ethInactivity ? $scope.ethProfileObj.ethInactivity.id : null,
                    "ethMTU": $scope.ethProfileObj.ethMTU ? $scope.ethProfileObj.ethMTU : null,
                    "ethCableLen": null
                }
            }

            //   hear is our service call
            var confirm = $scope.createConfirm();

            $mdDialog.show(confirm).then(function() {
                $http({
                    method: 'POST',
                    url: 'api/v2/profiles/template',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: ethObj
                }).success(function() {
                    $scope.showAlert('Success', 'Created successfully.');
                    $scope.ttype = 2;
                    $scope.$emit("defaultCall", $scope.ttype);
                    $scope.$emit("toggleFormFunction");
                    $scope.init();
                }).error(function(msg) {
                    $scope.showAlert('Error', 'Error creating Data: ' + msg);
                });
            });

        }

        //update call for ethernet
        $scope.updateEthProfile = function() {

                var ethObj = {
                    "profileType": 2,
                    "name": $scope.ethProfileObj.ethName.split(" ").join(""),
                    "profileId": $rootScope.profileID,
                    "radioMode": $scope.ethProfileObj.rMode.value,
                    "linkType": $scope.ethProfileObj.lType.value,
                    "edto": {
                        "radio": 0,
                        "nodeId": 0,
                        "status": 0,
                        "message": null,
                        "ethMode": $scope.ethProfileObj.ethSpeed ? $scope.ethProfileObj.ethSpeed.id : null,
                        "ethInactivity": $scope.ethProfileObj.ethInactivity ? $scope.ethProfileObj.ethInactivity.id : null,
                        "ethMTU": $scope.ethProfileObj.ethMTU ? $scope.ethProfileObj.ethMTU : null,
                        "ethCableLen": null
                    }
                }

                //   hear is our service call
                var confirm = $scope.saveconfirm();

                $mdDialog.show(confirm).then(function() {
                    $http({
                        method: 'POST',
                        url: 'api/v2/profiles/template/update',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        data: ethObj
                    }).success(function() {
                        $scope.showAlert('Success', 'Updated successfully.');
                        $scope.ttype = 2;
                        $scope.$emit("defaultCall", $scope.ttype);
                        $scope.$emit("toggleFormFunction");
                    }).error(function(msg) {
                        $scope.showAlert('Error', 'Error creating Data: ' + msg);
                    });
                });

            }
            //create conformation
        $scope.createConfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to create this profile?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };
        //save conformation
        $scope.saveconfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to update these changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')


            return confirm;
        };
        //close the selected form
        $scope.toggleForm = function() {
            $scope.$emit("toggleFormFunction");
        }
    }
]);
