﻿﻿dashboard.controller("EventsController", ['$rootScope', '$scope', '$state', '$interval', '$mdDialog', '$http', '$location', 'dashboardService', 'Flash', '$localStorage',
    function ($rootScope, $scope, $state, $interval, $mdDialog, $http, $location, dashboardService, Flash, $localStorage) {
        localStorage.setItem("mapload", true);
        // Default Bindings
        $scope.pagesizes = [25, 50, 75, 100];
        $scope.pagesize = $scope.pagesizes[1];
        $scope.currentpage = 1;
        $scope.nextBtnDisable = false;
        $scope.nodeFilerId = -1;
        $scope.showevent = true;
        $scope.showauditlog = false;
        $scope.auditlogconfig = {
            params: {
                '_s': '',
                'limit': $scope.pagesize,
                'offset': (($scope.currentpage - 1) * $scope.pagesize),
                'orderBy': 'id',
                'order': 'desc'
            }, showdiv: false
        };
        // Events Type Options for Events Table
        $scope.typeArray = [{
            "id": 'events',
            "val": "Events"
        }, {
            "id": 'syslogd',
            "val": "Syslogs"
        }, {
            "id": 'auditlog',
            "val": "Audit Log"
        }];
        // Severity Options for Events Table
        $scope.severityArray = [{
            "id": -1,
            "val": "All"
        }, {
            "id": 7,
            "val": "Critical"
        }, {
            "id": 6,
            "val": "Major"
        }, {
            "id": 5,
            "val": "Minor"
        }, {
            "id": 4,
            "val": "Warning"
        }, {
            "id": 3,
            "val": "Normal"
        }, {
            "id": 2,
            "val": "Cleared"
        }, {
            "id": 1,
            "val": "Indeterminate"
        }];
        // Category Options for Events Table
        $scope.categoryArray = [{
            "id": "",
            "val": "All"
        }, {
            "id": "uei.opennms.org/nodes/nodeUp",
            "val": "Up"
        }, {
            "id": "uei.opennms.org/nodes/nodeDown",
            "val": "Down"
        }, {
            "id": "uei.opennms.org/traps/KEYWEST-MIB/associatedTrap",
            "val": "Associated"
        }, {
            "id": "uei.opennms.org/traps/KEYWEST-MIB/disassociatedTrap",
            "val": "Dissociated"
        }, {
            "id": "uei.opennms.org/traps/KEYWEST-MIB/dyinggaspBSUTrap",
            "val": "Dying Gasp AP"
        }, {
            "id": "uei.opennms.org/traps/KEYWEST-MIB/dyinggaspRemoteTrap",
            "val": "Dying Gasp SU"
        }];
        // Time Options for Events Table
        $scope.timeRangeArray = [{
            "id": "",
            "val": "All"
        }, {
            "id": 3600000,
            "val": "Last hour"
        }, {
            "id": 28800000,
            "val": "8 hours"
        }, {
            "id": 86400000,
            "val": "24 hours"
        }, {
            "id": 172800000,
            "val": "48 hours"
        }];
        // Default bindings for the Table filters
        $scope.eventType = $scope.typeArray[0];
        $scope.eventSeverity = $scope.severityArray[0];
        $scope.eventCategory = $scope.categoryArray[0];
        $scope.eventTimeRange = $scope.timeRangeArray[3];
        $scope.chart_time_label = $scope.timeRangeArray[3].val;
        $scope.events = [];
        $scope.auditlog = [];
        // To Display Charts or not
        if ($scope.eventTimeRange.val == "All") {
            $scope.chartsEnable = false;
            $scope.tableStyle = "height:80vh;overflow-y:auto";
        } else {
            $scope.chartsEnable = true;
            $scope.tableStyle = "height:50vh;overflow-y:auto";
        }

        // Check to see Scope in the local storage
        if ($localStorage.selectedView) {
            $scope.selectedMode = $localStorage.selectedView;
        } else {
            $scope.selectedMode = "Global";
        }

        $scope.clearsearch = function () {
            $scope.clearSearch = false;
            $scope.nodeFilerId = -1;
            loadEvents();
            $scope.searchText = "";
        }

        // Generate Config for URL
        $scope.generateConfig = function () {
            var filterVal = 'eventDisplay==Y';
            if ($scope.eventType.id === 'syslogd') {
                filterVal += ';eventSource==syslogd';
            } else {
                filterVal += ';eventSource!=syslogd';
            }
            if ($scope.nodeFilerId != -1) {
                filterVal += ';node.id==' + $scope.nodeFilerId;
            }
            if ($scope.eventSeverity.id > -1) {
                filterVal += ';eventSeverity==' + $scope.eventSeverity.id;
            }
            if ($scope.eventCategory.id != "") {
                filterVal += ';eventUei==' + $scope.eventCategory.id;
            }
            if ($scope.eventTimeRange.id != "") {
                filterVal += ';eventCreateTime=gt=' + (Date.now() - $scope.eventTimeRange.id);
            }
            if (!$localStorage.facilitiesArray) {
                $scope.config = {
                    params: {
                        '_s': filterVal,
                        'limit': $scope.pagesize,
                        'offset': (($scope.currentpage - 1) * $scope.pagesize),
                        'ar': 'glob',
                        'orderBy':'id',
                        'order':'desc'
                    } //, showdiv: false
                };
            } else {
                var locVal = '';
                var facilitiesArray = $localStorage.facilitiesArray;
                for (var j = 0; j < facilitiesArray.length; j++) {
                    locVal = locVal + facilitiesArray[j];
                    if ((j + 1) != facilitiesArray.length) {
                        locVal = locVal + ',';
                    }
                }
                $scope.config = {
                    params: {
                        '_s': filterVal,
                        'limit': $scope.pagesize,
                        'offset': (($scope.currentpage - 1) * $scope.pagesize),
                        'ar': $localStorage.ar,
                        'fac': facilitiesArray,
                        'orderBy':'id',
                        'order':'desc'

                    } //, showdiv: false
                };
            }
        }

        // Generate Chart Config
        $scope.generateGraphConfig = function () {
            var filterVal = 'eventDisplay==Y';
            if ($scope.eventType.id === 'syslogd') {
                filterVal += ';eventSource==syslogd';
            }
            if ($scope.eventTimeRange.id != "") {
                filterVal += ';eventCreateTime=gt=' + (Date.now() - $scope.eventTimeRange.id);
            }
            if (!$localStorage.facilitiesArray) {
                $scope.chartConfig = {
                    params: {
                        '_s': filterVal,
                        'ar': 'glob'
                    }, showdiv: false
                };
            } else {
                var locVal = '';
                var facilitiesArray = $localStorage.facilitiesArray;
                for (var j = 0; j < facilitiesArray.length; j++) {
                    locVal = locVal + facilitiesArray[j];
                    if ((j + 1) != facilitiesArray.length) {
                        locVal = locVal + '&';
                    }
                }
                $scope.chartConfig = {
                    params: {
                        '_s': filterVal,
                        'ar': $localStorage.ar,
                        'fac': facilitiesArray
                    }, showdiv: false
                };
            }
        }

        // Default or Init call
        loadEvents();

        $scope.showEvent = function () {
            console.log("event selected")
        }

        $scope.searchText="";
        $scope.searchNode = function () {
            // Add sort parameters if not available
            if (!$scope.sortField) {
                $scope.orderBy = 'id'
                $scope.sortField = 'id';
            }
            if (!$scope.sortOrder) {
                $scope.sortOrder = 'asc'
            }
            // Add Scope to the URL
            //var url = 'assetRecord.serialNumber==' + $scope.searchText +',label==' + $scope.searchText
            if($scope.searchText!=""){
                var url = 'label==' + $scope.searchText
                // Generate config
                var config = {
                    params: {
                        'offset': (($scope.currentpage - 1) * $scope.pagesize),
                        'limit': 1,
                        'order': $scope.sortOrder,
                        'orderBy': $scope.sortField,
                        '_s': url
                    }
                };
                $scope.clearSearch = true;
                // URL formation
                var url = 'api/v2/nodes?_s=' + url;
                $http.get(url)
                    .then(function (response) {
                        if (response.data) {
                            $scope.totalNodesCount = response.data.totalCount; // Total number of devices
                            $scope.nodes = response.data.node;
                            for (var i = 0; i < $scope.nodes.length; i++) {
                                $scope.nodeFilerId = $scope.nodes[i].id;
    
                            }
                            loadEvents();
                        } else {
                            $scope.events = [];
                        }
                        loadEvents();
                    }
                    );
            } else{
                $scope.showAlert('Warning', 'Please enter text to search');
            }        
        }

        $scope.showAlert = function (msgType, msg, ev) {
            $mdDialog.show(
                $mdDialog.alert()
                    .parent(angular.element(document.querySelector('#popupContainer')))
                    .clickOutsideToClose(true)
                    .title(msgType)
                    .textContent(msg)
                    .ariaLabel('Alert')
                    .ok('OK')
                    .targetEvent(ev)
            );
        };

        // Load Events
        function loadEvents() {
            $scope.generateConfig();  // Generate URL config
            // Listing table
            var config = $scope.config;
            $http.get('api/v2/events/list', config).then(function (response) {
                if (response.status == 204) {
                    $scope.events = [];
                } else if (response.status == 200 && response.data) {
                    $scope.events = response.data.event;
                    if (response.data.event.length < $scope.pagesize) {
                        $scope.nextBtnDisable = true;
                    }
                }
            });
            // Generating chart
            if ($scope.eventTimeRange.id != "") {
                $scope.generateGraphConfig();
                generateSeverityChart();
                generateCategoryChart();
            }
        }

        //  Generate Severity Chart
        function generateSeverityChart() {
            $http.get('api/v2/events/graph', $scope.chartConfig).then(function (response) {
                // Binding response to chart data
                if (response.status == 204) {
                    $scope.severityStats = [];
                } else if (response.status == 200 && response.data) {
                    $scope.severityStats = {
                        "labels": ["Critical", "Major", "Minor", "Warning", "Normal", "Cleared", "Indeterminate"],
                        "severity": [response.data.severity.CRITICAL, response.data.severity.MAJOR, response.data.severity.MINOR, response.data.severity.WARNING, response.data.severity.NORMAL, response.data.severity.CLEARED, response.data.severity.INDETERMINATE]
                    }
                }
                if ($scope.severityStats == []) {
                    // If no data is available, generate severity config empty chart
                    var severity_config = {
                        type: 'bar',
                        data: {
                            datasets: [{
                                data: [1],
                                backgroundColor: ["#cccccc"]
                            }],
                            labels: ["no data"]
                        },
                        options: {
                            // responsive: true,
                            maintainAspectRatio: false,
                            title: { display: true, text: "Severity" },
                            scales: {
                                xAxes: [{
                                    ticks: {
                                        fontSize: 10,
                                        fontStyle: 'bold'
                                    },
                                    barThickness: 30
                                }]
                            },
                            animation: { animateScale: true, animateRotate: true },
                            tooltips: {
                                callbacks: {
                                    label: function (tooltipItem, data) {
                                        var labelValue = 'No devices';
                                        return labelValue;
                                    }
                                }
                            }
                        }
                    };
                } else {
                    // Generate Severity Config for non-null values
                    var severity_config = {
                        type: 'bar',
                        data: {
                            datasets: [{
                                data: $scope.severityStats.severity,
                                backgroundColor: ["#e74b4b", "#eb7f2c", "#f1aa00", "#f8e443", "#8dce71", "#cbcbcb", "#d9e893"]
                            }],
                            labels: $scope.severityStats.labels
                        },
                        options: {
                            // responsive: true,
                            maintainAspectRatio: false,
                            title: { display: true, text: "Severity Chart for " + $scope.selectedMode + " for " + $scope.chart_time_label },
                            scales: {
                                xAxes: [{
                                    ticks: {
                                        fontSize: 10,
                                        fontStyle: 'bold'
                                    },
                                    barThickness: 30
                                }],
                                yAxes: [{
                                    ticks: {
                                        beginAtZero: true
                                    }
                                }]
                            },
                            animation: { animateScale: true, animateRotate: true }
                        }
                    };
                }
                // Generate Severity Chart with config
                var severity_ctx = document.getElementById("severity_chart").getContext("2d");
                // severity_ctx.height = 500;
                new Chart(severity_ctx, severity_config);
            });
        }

        // Generate Category Chart
        function generateCategoryChart() {
            $http.get('api/v2/events/catgraph', $scope.chartConfig).then(function (response) {
                // Binding the response to the Category chart data
                if (response.status == 204) {
                    $scope.categoryStats = [];
                } else if (response.status == 200 && response.data) {
                    $scope.categoryStats = {
                        "labels": ["Up", "Down", "Associated", "Dissociated", "Dying Gasp"],
                        "category": [response.data.category.Up, response.data.category.Down, response.data.category.Associated, response.data.category.DisAssociated, response.data.category.DyingGasp]
                    }
                }
                if ($scope.categoryStats == []) {
                    // Generate Category chart config for null values
                    var category_config = {
                        type: 'bar',
                        data: {
                            datasets: [{
                                data: [1],
                                backgroundColor: ["#cccccc"]
                            }],
                            labels: ["no data"]
                        },
                        options: {
                            // responsive: true,
                            maintainAspectRatio: false,
                            title: { display: true, text: "Category" },
                            scales: {
                                xAxes: [{
                                    ticks: {
                                        fontSize: 10,
                                        fontStyle: 'bold'
                                    },
                                    barThickness: 30
                                }]
                            },
                            animation: { animateScale: true, animateRotate: true },
                            tooltips: {
                                callbacks: {
                                    label: function (tooltipItem, data) {
                                        var labelValue = 'No devices';
                                        return labelValue;
                                    }
                                }
                            }
                        }
                    };
                } else {
                    // Generate Category chart for non-null values
                    var category_config = {
                        type: 'bar',
                        data: {
                            datasets: [{
                                data: $scope.categoryStats.category,
                                backgroundColor: ["#8dce71", "#e74b4b", "#f1aa00", "#f8e443", "#d9e893"]
                            }],
                            labels: $scope.categoryStats.labels
                        },
                        options: {
                            // responsive: true,
                            maintainAspectRatio: false,
                            title: { display: true, text: "Category Chart for " + $scope.selectedMode + " for " + $scope.chart_time_label },
                            //                            title: { display: true, text: "Category" },
                            scales: {
                                xAxes: [{
                                    ticks: {
                                        fontSize: 10,
                                        fontStyle: 'bold'
                                    },
                                    barThickness: 30
                                }],
                                yAxes: [{
                                    ticks: {
                                        beginAtZero: true
                                    }
                                }]
                            },
                            animation: { animateScale: true, animateRotate: true }
                        }
                    };
                }
                // Generate Category Chart with config
                var category_ctx = document.getElementById("category_chart").getContext("2d");
                new Chart(category_ctx, category_config);
            });
        }

        //Redirect to Node view page
        $scope.gotoNode = function (nodeId, evn, lastView) {
            if (evn.ipAddress) {
                // Redirect to Node View Summary page
                $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });
            } else {
                // redirect to Node View Events page
                $state.go('app.events', { "nodeId": nodeId, "lastView": lastView });
            }
        }

        $scope.timer = null;
        $scope.timer = $interval(function () {
            $scope.eventTypeChangetimer($scope.eventType);
        }, 30000);

        $scope.$on('$destroy', function () {
            $scope.stopTimer();
            //nodesSource.close();
        });

        $scope.stopTimer = function () {
            if (angular.isDefined($scope.timer)) {
                $interval.cancel($scope.timer);
            }
        }
        $scope.eventTypeChangetimer = function (eventType) {
            if (eventType.id == 'syslogd' || eventType.id == 'events') {
                $scope.showevent = true;
                $scope.showauditlog = false;
                //$scope.currentpage = 1;
                $scope.eventType = eventType;
                $scope.generateConfig();
                var config = $scope.config;
                config.showdiv = false;
                $http.get('api/v2/events/list', config).then(function (response) {
                    if (response.status == 204) {
                        $scope.events = [];
                    } else if (response.status == 200 && response.data) {
                        $scope.events = response.data.event;
                        if (response.data.event.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        }
                    }
                });
                generateSeverityChart();
                generateCategoryChart();
            } else {
                $scope.showevent = false;
                $scope.showauditlog = true;
                //$scope.currentpage = 1;
                var auditlogconfig = $scope.auditlogconfig;
                auditlogconfig.showdiv = false;
                $http.get('api/v2/audit/list', auditlogconfig).then(function (response) {
                    if (response.status == 204) {
                        $scope.auditlog = [];
                    } else if (response.status == 200 && response.data) {
                        $scope.auditlog = response.data.audits;
                        console.log("audit data", $scope.auditlog);
                        if (response.data.audits.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        }
                    }
                });
            }
        }

        //Event Type Change for Events table
        $scope.eventTypeChange = function (eventType) {
            if (eventType.id == 'syslogd' || eventType.id == 'events') {
                $scope.showevent = true;
                $scope.showauditlog = false;
                $scope.currentpage = 1;
                $scope.eventType = eventType;
                $scope.generateConfig();
                $http.get('api/v2/events/list', $scope.config).then(function (response) {
                    if (response.status == 204) {
                        $scope.events = [];
                    } else if (response.status == 200 && response.data) {
                        $scope.events = response.data.event;
                        if (response.data.event.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        }
                    }
                });
                generateSeverityChart();
                generateCategoryChart();
            } else {
                $scope.showevent = false;
                $scope.showauditlog = true;
                $scope.currentpage = 1;
                // $scope.config
                $http.get('api/v2/audit/list', $scope.auditlogconfig).then(function (response) {
                    if (response.status == 204) {
                        $scope.auditlog = [];
                    } else if (response.status == 200 && response.data) {
                        $scope.auditlog = response.data.audits;
                        console.log("audit data", $scope.auditlog);
                        if (response.data.audits.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        }
                    }
                });
            }
        }

        //Severity Change for Events Table
        $scope.severityChange = function (eventSeverity) {
            $scope.currentpage = 1;
            $scope.eventSeverity = eventSeverity;
            $scope.generateConfig();
            $http.get('api/v2/events/list', $scope.config).then(function (response) {
                if (response.status == 204) {
                    $scope.events = [];
                } else if (response.status == 200 && response.data) {
                    $scope.events = response.data.event;
                    if (response.data.event.length < $scope.pagesize) {
                        $scope.nextBtnDisable = true;
                    }else{
                                             $scope.nextBtnDisable = false;
                                         }
                }
            });
        }
        //Category Change for Events Table
        $scope.categoryChange = function (eventCategory) {
            $scope.currentpage = 1;
            $scope.eventCategory = eventCategory;
            $scope.generateConfig();
            $http.get('api/v2/events/list', $scope.config).then(function (response) {
                if (response.status == 204) {
                    $scope.events = [];
                } else if (response.status == 200 && response.data) {
                    $scope.events = response.data.event;
                    if (response.data.event.length < $scope.pagesize) {
                        $scope.nextBtnDisable = true;
                    }else{
                        $scope.nextBtnDisable = false;
                    }

                }
            });
        }
        //Time Range Change for Events table
        $scope.timeRangeChange = function (eventTimeRange) {
            $scope.chart_time_label = eventTimeRange.val;
            $scope.currentpage = 1;
            $scope.eventTimeRange = eventTimeRange;
            $scope.generateConfig();
            $http.get('api/v2/events/list', $scope.config).then(function (response) {
                if (response.status == 204) {
                    $scope.events = [];
                } else if (response.status == 200 && response.data) {
                    $scope.events = response.data.event;
                    if (response.data.event.length < $scope.pagesize) {
                        $scope.nextBtnDisable = true;
                    }else{
                        $scope.nextBtnDisable = false;
                    }
                }
            });
            // Generating the charts based on Time filter change
            if ($scope.eventTimeRange.val == "All") {
                // Not display charts
                $scope.chartsEnable = false;
                //$scope.chartsEnable = true;
                $scope.tableStyle = "height:82vh;overflow-x:auto;overflow-y:auto";
            } else {
                // Display Charts
                $scope.chartsEnable = true;
                $scope.tableStyle = "height:50vh;overflow-x:auto;overflow-y:auto";
                $scope.generateGraphConfig();
                generateSeverityChart();
                generateCategoryChart();
            }
        }
        // Pagination method
        $scope.paging = function (val) {
            if (val == 'previous') {
                --$scope.currentpage;
            } else if (val == 'next') {
                ++$scope.currentpage;
            }
            if ($scope.showevent) {
                $scope.generateConfig();
                $http.get('api/v2/events/list', $scope.config).then(function (response) {
                    $scope.events = response.data.event;
                    // Pagination button disable conidtions
                    if (val == "next") {
                        if (response.data.event.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        }
                    } else {
                        if (response.data.event.length >= $scope.pagesize) {
                            $scope.nextBtnDisable = false;
                        }
                    }
                });
            }
            if ($scope.showauditlog) {
                $scope.auditlogconfig = {
                    params: {
                        '_s': '',
                        'limit': $scope.pagesize,
                        'offset': (($scope.currentpage - 1) * $scope.pagesize),
                        'orderBy': 'id',
                        'order': 'desc'
                    } //,showdiv: false
                };
                $http.get('api/v2/audit/list', $scope.auditlogconfig).then(function (response) {
                    if (response.status == 204) {
                        $scope.auditlog = [];
                        $scope.nextBtnDisable = true;
                    } else if (response.status == 200 && response.data) {
                        $scope.auditlog = response.data.audits;
                        if (val == "next") {
                            if (response.data.audits.length < $scope.pagesize) {
                                $scope.nextBtnDisable = true;
                            }
                        } else {
                            if (response.data.audits.length >= $scope.pagesize) {
                                $scope.nextBtnDisable = false;
                            }
                        }
                    }
                });
            }
        }
        //Page size change method
        $scope.changePageSize = function (pagesize) {
            $scope.currentpage = 1;
            $scope.pagesize = pagesize;
            if ($scope.showevent) {
                $scope.generateConfig();
                $http.get('api/v2/events/list', $scope.config).then(function (response) {
                    if (response.status == 204) {
                        $scope.events = [];
                    } else if (response.status == 200 && response.data) {
                        $scope.events = response.data.event;
                        console.log("page size events", $scope.events);

                        if (response.data.event.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        } else {
                            $scope.nextBtnDisable = false;
                        }
                    }
                });
                generateSeverityChart();
                generateCategoryChart();
            }
            if ($scope.showauditlog) {
                $scope.auditlogconfig = {
                    params: {
                        '_s': '',
                        'limit': $scope.pagesize,
                        'offset': (($scope.currentpage - 1) * $scope.pagesize),
                        'orderBy': 'id',
                        'order': 'desc'
                    } //,showdiv: false
                };
                $http.get('api/v2/audit/list', $scope.auditlogconfig).then(function (response) {
                    if (response.status == 204) {
                        $scope.auditlog = [];
                        $scope.nextBtnDisable = true;
                    } else if (response.status == 200 && response.data) {
                        $scope.auditlog = response.data.audits;
                        if (response.data.audits.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        } else {
                            $scope.nextBtnDisable = false;
                        }
                    }
                });
            }
        }

        $scope.regionsData='';
        $scope.locationData='';
        $scope.facData='';

        // Scope Start
        // Display Scope Modal function
        $scope.showpopup = function () {
            $scope.errNotify = '';
            if ($localStorage.selectedView) {
                $scope.value = $localStorage.selectedView;
                $scope.div_select = $localStorage.selectedView;

                //new added for displaying previous selection in popup
                if($localStorage.facilities==undefined){
                       $localStorage.facilities=[];
                   }
                   if($localStorage.locations==undefined){
                       $localStorage.locations=[];
                   }
                   if($localStorage.regions==undefined){
                       $localStorage.regions=[];
                   }
                   if($localStorage.basestations==undefined){
                       $localStorage.basestations=[];
                   }
                 if($localStorage.facilities.length>0){
                    $scope.facilities=$localStorage.facilities;
                 }
                 if($localStorage.locations.length>0){
                    $scope.locations=$localStorage.locations;
                 }
                 if($localStorage.regions.length>0){
                    $scope.regions=$localStorage.regions;
                 }
                 if($localStorage.basestations.length>0){
                    $scope.basestations=$localStorage.basestations;
                 }
                 $scope.regionsData =$localStorage.regionselectedid;
                 $scope.locationData =$localStorage.locationselectedid;
                 $scope.facData =$localStorage.facilityselectedid;
                $("#myModal").modal("show");
                //$scope.modeSelection($scope.div_select);
            } else {
                $scope.value = "Global";
                $scope.div_select = "Global";
                $scope.modeSelection($scope.div_select);
                $("#myModal").modal("show");
            }
        }

          loadRegions();
                function loadRegions(){
                    var url = 'api/v2/treeview/regions';
                    $http.get(url)
                        .then(function (response) {
                            if (response.data) {
                                $scope.regions = response.data;
                            }
                        });
                }

        // Radio Buttons for tab selection function
        $scope.modeSelection = function (srcval) {
//             $scope.facilities=[];
//             $scope.locations=[];
//             $scope.regions=[];
//             $scope.basestations=[];
//             $scope.regionsData ='';
//             $scope.locationData ='';
//             $scope.facData ='';

            $scope.errNotify = '';
            if (srcval == 'Global') {
                // If Selected tab is Global
                $scope.div_select = srcval;
            } else if (srcval == 'Region') {
                // If Selected tab is Region
//                var url = 'api/v2/treeview/regions';
//                $http.get(url)
//                    .then(function (response) {
//                        if (response.data) {
//                            $scope.vm.node = response.data;
//                            $scope.regions = response.data;
//                            $scope.div_select = srcval;
//                        }
//                    });
 $scope.div_select = srcval;
            } else if (srcval == 'Facility') {
                // If Selected tab is Facility
//                var url = 'api/v2/treeview/regions';
//                $http.get(url)
//                    .then(function (response) {
//                        if (response.data) {
//                            $scope.regions = response.data;
//                            $scope.regions = response.data;
//                            $scope.div_select = srcval;
//                        }
//                    });
    $scope.div_select = srcval;
            } else if (srcval == 'Location') {
                // If Selected tab is Location
//                var url = 'api/v2/treeview/regions';
//                $http.get(url)
//                    .then(function (response) {
//                        if (response.data) {
//                            $scope.regions = response.data;
//                            $scope.regions = response.data;
//                            $scope.div_select = srcval;
//                        }
//                    });
 $scope.div_select = srcval;
            } else if (srcval == 'Basestation') {
                // If Selected tab is Basestation
                var url = 'api/v2/treeview/regions';
//                $http.get(url)
//                    .then(function (response) {
//                        if (response.data) {
//                            $scope.basestation = response.data;
//                            $scope.regions = response.data;
//                            $scope.div_select = srcval;
//                        }
//                    });
  $scope.div_select = srcval;
            }
        }

        // On Region Change, Load Locations of selected region
        $scope.regionChange = function (regionId) {
            $localStorage.regionselectedid=regionId;
            var url = 'api/v2/treeview/regions/' + regionId.data.id + '/locations';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.locations = response.data;
                    }
                });
        }

        // On Location Change, Load Facilities of selected Location
        $scope.locationChange = function (locationID) {
        $localStorage.locationselectedid=locationID;
            var url = 'api/v2/treeview/locations/' + locationID.data.id + '/facilities';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.facilities = response.data;
                    }
                });
        }

        // On Facility Change, Load Basestations of selected facility
        $scope.facilityChange = function (facilityId) {
         $localStorage.facilityselectedid=facilityId;
           var facilityId1 = facilityId.data.id;
            var url = 'api/v2/treeview/facility/' + facilityId1 + '/treenodes';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.basestations = response.data;
                    }
                });
        }

        // Selected facilities using Checkbox
        $scope.selectedFac = function (selectedFacility) {
            if (selectedFacility.checked) {
                selectedFacility.checked = false;
            } else {
                selectedFacility.checked = true;
            }
        }

        // Selected Regions using Checkbox
        $scope.selectedReg = function (selectedRegion) {
            if (selectedRegion.checked) {
                selectedRegion.checked = false;
            } else {
                selectedRegion.checked = true;
            }
        }

        // Selected locations using Checkbox
        $scope.selectedLocation = function (selectedLocation) {
            if (selectedLocation.checked) {
                selectedLocation.checked = false;
            } else {
                selectedLocation.checked = true;
            }
        }

        // Selected basestation using Checkbox
        $scope.selectedBst = function (selectedBasestation) {
            if (selectedBasestation.checked) {
                selectedBasestation.checked = false;
            } else {
                selectedBasestation.checked = true;
            }
        }

        // Scope Apply Function or Change Scope Function
        $scope.apply = function () {
            if ($scope.div_select == 'Global') {
                // If Global Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $localStorage.ar = "glob";
                $localStorage.facilitiesArray = null;
                $("#myModal").modal("hide");  // Close modal
                $('body').removeClass('modal-open');
                $('.modal-backdrop').remove();
                showpageloading(true); // Display loading icon
                $state.reload(); // Page State reload
                showpageloading(false);  // Stop displaying loading icon
            } else if ($scope.div_select == 'Facility') {
                // If Facility Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $scope.facilities = $scope.facilities;
                $localStorage.facilities=$scope.facilities;
                if (!$scope.facilities) {
                    // If no facility is selected
                    $scope.errNotify = 'Please select facilities';
                } else {
                    $scope.tempArryFac = [];
                    for (var i = 0; i < $scope.facilities.length; i++) {
                        if ($scope.facilities[i].facisChecked) {
                            $scope.tempArryFac.push($scope.facilities[i].data.id);
                        }
                    }
                    if ($scope.tempArryFac.length == 0) {
                        // If no facility is selected
                        $scope.errNotify = 'Please select facilities';
                    } else {
                        $localStorage.facilitiesArray = $scope.tempArryFac;
                        $localStorage.ar = "fac";
                        $("#myModal").modal("hide");
                        $('body').removeClass('modal-open');
                        $('.modal-backdrop').remove();
                        showpageloading(true);
                        $state.reload();
                        showpageloading(false);
                    }
                }
            } else if ($scope.div_select == "Location") {
                // If Location Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $scope.locations = $scope.locations;
                 $localStorage.locations=$scope.locations;
                if (!$scope.locations) {
                    // If no location is selected
                    $scope.errNotify = "Please select locations";
                } else {
                    $scope.tempArrLoc = [];
                    for (var i = 0; i < $scope.locations.length; i++) {
                        if ($scope.locations[i].locisChecked) {
                            $scope.tempArrLoc.push($scope.locations[i].data.id);
                        }
                    }
                    if ($scope.tempArrLoc.length == 0) {
                        // If no location is selected
                        $scope.errNotify = "Please select locations";
                    } else {
                        $localStorage.facilitiesArray = $scope.tempArrLoc;
                        $localStorage.ar = "loc";
                        $("#myModal").modal("hide");
                        $('body').removeClass('modal-open');
                        $('.modal-backdrop').remove();
                        showpageloading(true);
                        $state.reload();
                        showpageloading(false);
                    }
                }
            } else if ($scope.div_select == 'Region') {
                // If Region Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $scope.regions = $scope.regions;
                $localStorage.regions=$scope.regions;
                if (!$scope.regions) {
                    // If no region is selected
                    $scope.errNotify = "Please select regions";
                } else {
                    $scope.tempArryReg = [];
                    for (var i = 0; i < $scope.regions.length; i++) {
                        if ($scope.regions[i].regisChecked) {
                            $scope.tempArryReg.push($scope.regions[i].data.id);
                        }
                    }
                    if ($scope.tempArryReg.length == 0) {
                        // If no region is selected
                        $scope.errNotify = "Please select regions";
                    } else {
                        $localStorage.facilitiesArray = $scope.tempArryReg;
                        $localStorage.ar = "reg";
                        $("#myModal").modal("hide");
                        $('body').removeClass('modal-open');
                        $('.modal-backdrop').remove();
                        $state.reload();
                    }
                }
            } else if ($scope.div_select == 'Basestation') {
                // If Basestation Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $scope.basestations = $scope.basestations;
                $localStorage.basestations=$scope.basestations;
                if (!$scope.basestations) {
                    // If no basestations is selected
                    $scope.errNotify = "Please select basestations";
                } else {
                    $scope.tempArryBst = [];
                    for (var i = 0; i < $scope.basestations.length; i++) {
                        if ($scope.basestations[i].bstisChecked) {
                            $scope.tempArryBst.push($scope.basestations[i].data.id);
                        }
                    }
                    if ($scope.tempArryBst.length == 0) {
                        // If no basestations is selected
                        $scope.errNotify = "Please select basestations";
                    } else {
                        $localStorage.facilitiesArray = $scope.tempArryBst;
                        $localStorage.ar = "node";
                        $("#myModal").modal("hide");
                        $('body').removeClass('modal-open');
                        $('.modal-backdrop').remove();
                        $state.reload();
                    }
                }
            }
        }

        $scope.showAdvanced = function (ev, event) {
            $mdDialog.show({
                locals: { e: event },
                controller: DialogController,
                templateUrl: 'dialog1.tmpl.html',
                parent: angular.element(document.body),
                targetEvent: ev,
                clickOutsideToClose: true,
                fullscreen: $scope.customFullscreen // Only for -xs, -sm breakpoints.
            })
            /*.then(function(answer) {
              $scope.status = 'You said the information was "' + answer + '".';
            }, function() {
              $scope.status = 'You cancelled the dialog.';
            });*/
        };

        function DialogController($scope, $mdDialog, e) {
            if (!e.nodeLabel) {
                e.nodeLabel = e.host;
            }
            $scope.selectedEvent = e;
            $scope.hide = function () {
                $mdDialog.hide();
            };

            $scope.cancel = function () {
                $mdDialog.cancel();
            };

            $scope.answer = function (answer) {
                $mdDialog.hide(answer);
            };
        }
        // Scope End

        $scope.showAdvancedaudit = function (ev, event) {
            $mdDialog.show({
                locals: { e: event },
                controller: DialogControlleraudit,
                templateUrl: 'dialog1audit.tmpl.html',
                parent: angular.element(document.body),
                targetEvent: ev,
                clickOutsideToClose: true,
                fullscreen: $scope.customFullscreen // Only for -xs, -sm breakpoints.
            })
            /*.then(function(answer) {
              $scope.status = 'You said the information was "' + answer + '".';
            }, function() {
              $scope.status = 'You cancelled the dialog.';
            });*/
        };

        function DialogControlleraudit($scope, $mdDialog, e) {
            if (!e.nodeLabel) {
                e.nodeLabel = e.host;
            }
            $scope.selectedEventAudit = e;
            $scope.hide = function () {
                $mdDialog.hide();
            };

            $scope.cancelAudit = function () {
                $mdDialog.cancel();
            };

            $scope.answer = function (answer) {
                $mdDialog.hide(answer);
            };
        }
    }
]);
