﻿dashboard.controller("HomeController", ['$rootScope', '$mdDialog', '$scope', '$http', '$state', '$location', '$interval', 'dashboardService', 'Flash', '$localStorage',
    function ($rootScope, $mdDialog, $scope, $http, $state, $location, $interval, dashboardService, Flash, $localStorage) {
        var vm = this;
        localStorage.setItem("mapload", true);
        // Status Options for Devices Table
        $scope.deviceStatusArray = [{
            "id": "all",
            "val": "All"
        }, {
            "id": "up",
            "val": "Good"
        }, {
            "id": "down",
            "val": "Down"
        }];
        // Time Options for Events
        $scope.timeRangeArray = [{
            "id": 3600000,
            "val": "Last hour"
        }, {
            "id": 28800000,
            "val": "8 hours"
        }, {
            "id": 86400000,
            "val": "24 hours"
        }, {
            "id": 172800000,
            "val": "48 hours"
        }];
        // Severity Options for Events
        $scope.severityArray = [{
            "id": -1,
            "val": "All"
        }, {
            "id": 7,
            "val": "Critical"
        }, {
            "id": 6,
            "val": "Major"
        }, {
            "id": 5,
            "val": "Minor"
        }, {
            "id": 4,
            "val": "Warning"
        }, {
            "id": 3,
            "val": "Normal"
        }, {
            "id": 2,
            "val": "Cleared"
        }, {
            "id": 1,
            "val": "Indeterminate"
        }];

        // Table Variables
        $scope.pagesizes = [10, 25, 50, 100];
        $scope.pagesize = $scope.pagesizes[1];
        $scope.eventpagesizes = [25, 50, 75, 100];
        $scope.eventpagesize = $scope.eventpagesizes[1];
        $scope.currentpage = 1;
        $scope.eventcurrentpage = 1;
        $scope.nextBtnDisable = false;
        $scope.eventnextBtnDisable = false;
        $scope.statusFormData = {};
        $scope.statusFormData.deviceStatus = $scope.deviceStatusArray[0];
        $scope.devStatus = null;
        $scope.downIP = {"ipAddress" : "test"}

        $scope.bhTitle = 'SWITCH';
        $scope.bhFilter = '';
        $scope.bhMode = '';





        // Default bindings for the Events
        $scope.eventTimeRange = $scope.timeRangeArray[2];
        $scope.eventSeverity = $scope.severityArray[0];

        var cpe_ptp_ctx = null;
        var cpe_ptp_chart = null;

        var cpe_ptmp_ctx = null;
        var cpe_ptmp_chart = null;

        var cpe_bh_ctx = null;
        var cpe_bh_chart = null;

        var ap_ptp_ctx = null;
        var ap_ptp_chart = null;

        var ap_ptmp_ctx = null;
        var ap_ptmp_chart = null;

        var ap_bh_ctx = null;
        var ap_bh_chart = null;

        var main_ctx = null;
        var main_chart = null;

        $scope.cpe_ptp_config = {
            type: 'doughnutLabels',
            data: {
                datasets: [{
                    data: [1],
                    backgroundColor: ["#cccccc"],
                    label: 'Dataset 1'
                }],
                labels: ["no data"]
            },
            options: {
                circumference: Math.PI,
                rotation: 1 * Math.PI,
                responsive: true,
                title: { display: false, text: "PTP" },
                hover: {
                      onHover: function(e) {
                        $("#cpe_ptp_Chart").css("cursor", e[0] ? "pointer" : "default");}},
                onClick: (point, elements) => { onClickAp(elements,'productCode', "PTP", 'sta')/*selectGraph('productCode', "PTP", 'sta', '', '', '')*/ },
                animation: { animateScale: false, animateRotate: false },
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, data) {
                            //var labelValue = 'good: 0, down: 0';
                            return graphTooltip(tooltipItem, data);
                        }
                    }
                }
            }
        };
        $scope.cpe_ptmp_config = {
            type: 'doughnutLabels',
            data: {
                datasets: [{
                    data: [1],
                    backgroundColor: ["#cccccc"],
                    label: 'Dataset 1'
                }],
                labels: ["no data"]
            },
            options: {
                circumference: Math.PI,
                rotation: 1 * Math.PI,
                responsive: true,
                title: { display: false, text: "PTMP" },
                hover: {
                      onHover: function(e) {
                        $("#cpe_ptmp_Chart").css("cursor", e[0] ? "pointer" : "default");}},
                onClick: (point, elements) => { onClickAp(elements,'productCode', "PTMP", 'sta')/*selectGraph('productCode', "PTMP", 'sta', '', '', '')*/ },
                animation: { animateScale: false, animateRotate: false },
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, data) {
                            //var labelValue = 'good: 0, down: 0';
                            return graphTooltip(tooltipItem, data);
                        }
                    }
                }
            }
        };

        $scope.cpe_bh_config = {
            type: 'doughnutLabels',
            data: {
                datasets: [{
                    data: [1],
                    backgroundColor: ["#cccccc"],
                    label: 'Dataset 1'
                }],
                labels: ["no data"]
            },
            options: {
                circumference: Math.PI,
                rotation: 1 * Math.PI,
                responsive: true,
                title: { display: false, text: $scope.bhTitle },
                hover: {
                      onHover: function(e) {
                        $("#cpe_bh_Chart").css("cursor", e[0] ? "pointer" : "default");}},
                onClick: (point, elements) => { onClickAp(elements,'productCode', "Switch", 'tmarc')/*selectGraph('productCode', "BACKHAUL", 'sta', '', '', '')*/ },
                animation: { animateScale: false, animateRotate: false },
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, data) {
                            //var labelValue = 'good: 0, down: 0';
                            return graphTooltip(tooltipItem, data);
                        }
                    }
                }
            }
        };

        function graphTooltip(tooltipItem,data) {
            var labelValue = 'Good: 0, Down: 0';
            var index = tooltipItem.index;
            var arrLen = data.datasets[0].data.length;
            if (arrLen == 2) {
                if (index == 1) {
                    labelValue = 'Down: ' + data.datasets[0].data[index];
                } else if (index == 0){
                    labelValue = 'Good: ' + data.datasets[0].data[index];
                }
            }


             return labelValue;
        }

        function onClickAp(es,pc,lt,rm) {
           var index = -1;
           if (es.length > 0) {
                index = es[0]._index;
           }
            var status = 'all';
            if (index == 0) {
                status = 'up';
            } else if (index == 1) {
                status = 'down';
            }
            $scope.currentpage=1;
            getDataBasedonSelection(pc, lt, rm, status, '', '');
         }

         function onClickBackhaul(es,pc,lt,rm) {
            if ($localStorage.showUI == 'sw') {
                lt = 'switch';
                rm = 'tmarc';
            }
            var index = -1;
            if (es.length > 0) {
                 index = es[0]._index;
            }
             var status = 'all';
             if (index == 0) {
                 status = 'up';
             } else if (index == 1) {
                 status = 'down';
             }
             getDataBasedonSelection(pc, lt, rm, status, '', '');
          }

        function onDoughnut(p, es) {
            var index = -1;
            if (es.length > 0) {
                index = es[0]._index;
            }
            $scope.filterType = 'ns';
            if (index == 0) {
                console.log("good");
                $scope.productCode = 'good';
            } else if (index == 1) {
                console.log("No link");
                $scope.productCode = 'nolink';
            } else if (index == 2) {
                console.log("down");
                $scope.productCode = 'down';
            } else if (index == 3) {
                console.log("unassinged")
                $scope.productCode = 'unprov';
            } else {
                console.log("all");
                $scope.productCode = 'all';
            }
            getDataBasedonSelection($scope.filterType, $scope.productCode, $scope.radioMode, $scope.devStatus, $scope.sortField, $scope.sortOrder);

        }

        /*fucntion onClickAp(point,elements) {
            console.log(point);
            console.log(elements);
        }*/

        $scope.ap_ptp_config = {
            type: 'doughnutLabels',
            data: {
                datasets: [{
                    data: [1],
                    backgroundColor: ["#cccccc"],
                    label: 'Dataset 1'
                }],
                labels: ["no data"]
            },
            options: {
                circumference: Math.PI,
                rotation: 1 * Math.PI,
                responsive: true,
                title: { display: true, text: "PTP" },
                hover: {
                      onHover: function(e) {
                        $("#ap_ptp_Chart").css("cursor", e[0] ? "pointer" : "default");}},
                onClick: (point, elements) => { onClickAp(elements,'productCode', "PTP", 'ap')/*selectGraph('productCode', "PTP", 'ap', '', '', '')*/ },
                animation: { animateScale: false, animateRotate: false },
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, data) {
                            //var labelValue = 'good: 0, down: 0';
                            return graphTooltip(tooltipItem, data);
                        }
                    }
                }
            }
        };

        $scope.ap_ptmp_config = {
            type: 'doughnutLabels',
            data: {
                datasets: [{
                    data: [1],
                    backgroundColor: ["#cccccc"],
                    label: 'Dataset 1'
                }],
                labels: ["no data"]
            },
            options: {
                circumference: Math.PI,
                rotation: 1 * Math.PI,
                responsive: true,
                title: { display: true, text: "PTMP" },
                hover: {
                          onHover: function(e) {
                            $("#ap_ptmp_Chart").css("cursor", e[0] ? "pointer" : "default");}},
                onClick: (point, elements) => { onClickAp(elements,'productCode', "PTMP", 'ap')/*selectGraph('productCode', "PTMP", 'ap', '', '', '')*/ },
                animation: { animateScale: false, animateRotate: false },
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, data) {
                            //var labelValue = 'good: 0, down: 0';
                            return graphTooltip(tooltipItem, data);
                        }
                    }
                }
            }
        };



        $scope.ap_bh_config = {
            type: 'doughnutLabels',
            data: {
                datasets: [{
                    data: [1],
                    backgroundColor: ["#cccccc"],
                    label: 'Dataset 1'
                }],
                labels: ["no data"]
            },
            options: {
                circumference: Math.PI,
                rotation: 1 * Math.PI,
                responsive: true,
                title: { display: true, text: $scope.bhTitle },
                hover: {
                      onHover: function(e) {
                        $("#ap_bh_Chart").css("cursor", e[0] ? "pointer" : "default");}},
                onClick: (point, elements) => { onClickBackhaul(elements,'productCode', "BACKHAUL", 'ap')/*selectGraph('productCode', "BACKHAUL", 'ap', '', '', '')*/ },
                animation: { animateScale: false, animateRotate: false },
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, data) {
                            //var labelValue = 'good: 0, down: 0';
                            return graphTooltip(tooltipItem, data);
                        }
                    }
                }
            }
        };

        $scope.main_config = {
            type: 'doughnutLabels',
            data: {
                datasets: [{
                    data: [1],
                    backgroundColor: ["#a5d478", "#f8d347", "#ef563d", "#00aeef"],
                    borderWidth:0,
                    label: 'Dataset 1'
                }],
                labels: ["Good", "No Link", "Down", "Unassigned"]
            },
            options: {
                circumference: 2 * Math.PI,
                rotation: -0.5 * Math.PI,
                responsive: true,
                legend: {
                    display: true,
                    position: 'bottom',
                    labels: {
                        boxWidth: 12
                    }
                },
                hover: {
                      onHover: function(e) {
                        $("#main-chart").css("cursor", e[0] ? "pointer" : "default");}},
                onClick: (point, elements) => { onDoughnut(point,elements)/*selectGraph('productCode', "BACKHAUL", 'ap', '', '', '')*/ },
                title: { display: false, text: 'Devices' },
                animation: { animateScale: false, animateRotate: false }
            }
        };

        $scope.timer = null;

        $scope.startLinkTimer = function () {
            $scope.timer = $interval(function () {
                if($scope.eventcurrentpage==1){
                    loadEvents();
                }
                loadDatabyDeviceType();
                if (!$scope.clearSearch) {
                    getDataBasedonSelection($scope.filterType, $scope.productCode, $scope.radioMode, $scope.devStatus, $scope.sortField, $scope.sortOrder);
                }
            }, 10000);
        }

        $scope.$on('$destroy', function () {
            $scope.stopTimer();
            nodesSource.close();
        });

        $scope.stopTimer = function () {
            if (angular.isDefined($scope.timer)) {

                $interval.cancel($scope.timer);
            }
        }

        // If scope is not available in local storage
        if (!$localStorage.ar) {
            $localStorage.ar = 'glob';
        }





        /* $scope.$on('$destroy', function() {
               nodesSource.close();
           });*/

        // Custom chart Start
        // Custom code to generate values on chart segments
        // This is applicable for only doughnut charts in the Dashboard page
        Chart.defaults.doughnutLabels = Chart.helpers.clone(Chart.defaults.doughnut);
        var helpers = Chart.helpers;
        var defaults = Chart.defaults;
        Chart.controllers.doughnutLabels = Chart.controllers.doughnut.extend({
            updateElement: function (arc, index, reset) {
                var _this = this;
                var chart = _this.chart,
                    chartArea = chart.chartArea,
                    opts = chart.options,
                    animationOpts = opts.animation,
                    arcOpts = opts.elements.arc,
                    centerX = (chartArea.left + chartArea.right) / 2,
                    centerY = (chartArea.top + chartArea.bottom) / 2,
                    startAngle = opts.rotation, // non reset case handled later
                    endAngle = opts.rotation, // non reset case handled later
                    dataset = _this.getDataset(),
                    circumference = reset && animationOpts.animateRotate ? 0 : arc.hidden ? 0 : _this.calculateCircumference(dataset.data[index]) * (opts.circumference / (2.0 * Math.PI)),
                    innerRadius = reset && animationOpts.animateScale ? 0 : _this.innerRadius,
                    outerRadius = reset && animationOpts.animateScale ? 0 : _this.outerRadius,
                    custom = arc.custom || {},
                    valueAtIndexOrDefault = helpers.getValueAtIndexOrDefault;

                helpers.extend(arc, {
                    // Utility
                    _datasetIndex: _this.index,
                    _index: index,

                    // Desired view properties
                    _model: {
                        x: centerX + chart.offsetX,
                        y: centerY + chart.offsetY,
                        startAngle: startAngle,
                        endAngle: endAngle,
                        circumference: circumference,
                        outerRadius: outerRadius,
                        innerRadius: innerRadius,
                        label: valueAtIndexOrDefault(dataset.label, index, chart.data.labels[index])
                    },

                    draw: function () {
                        var ctx = this._chart.ctx,
                            vm = this._view,
                            sA = vm.startAngle,
                            eA = vm.endAngle,
                            opts = this._chart.config.options;

                        var labelPos = this.tooltipPosition();
                        var segmentLabel = vm.circumference / opts.circumference * 100;
                        var segmentValue = dataset.data[index];

                        ctx.beginPath();

                        ctx.arc(vm.x, vm.y, vm.outerRadius, sA, eA);
                        ctx.arc(vm.x, vm.y, vm.innerRadius, eA, sA, true);

                        ctx.closePath();
                        ctx.strokeStyle = vm.borderColor;
                        ctx.lineWidth = vm.borderWidth;

                        ctx.fillStyle = vm.backgroundColor;

                        ctx.fill();
                        ctx.lineJoin = 'bevel';

                        if (vm.borderWidth) {
                            ctx.stroke();
                        }

                        if (vm.circumference > 0.0015) { // Trying to hide label when it doesn't fit in segment
                            ctx.beginPath();
                            ctx.font = helpers.fontString(opts.defaultFontSize, opts.defaultFontStyle, opts.defaultFontFamily);
                            ctx.fillStyle = "#111111";
                            ctx.textBaseline = "top";
                            ctx.textAlign = "center";

                            // Round percentage in a way that it always adds up to 100%
                            // ctx.fillText(segmentLabel.toFixed(2) + "%", labelPos.x, labelPos.y);
                            if (chart.data.labels[0] == "no data") {
                                ctx.fillText(0, labelPos.x, labelPos.y);
                            } else {
                                ctx.fillText(segmentValue, labelPos.x, labelPos.y);
                            }

                            //display in the center the total sum of all segments
                            var total = dataset.data.reduce((sum, val) => parseInt(sum) + parseInt(val), 0);
                            if (chart.data.labels[0] == "no data") {
                                ctx.fillText(0, vm.x, vm.y - 20, 200);
                            } else {
                                ctx.fillText(total, vm.x, vm.y - 20, 200);
                            }
                        }

                    }
                });

                var model = arc._model;
                model.backgroundColor = custom.backgroundColor ? custom.backgroundColor : valueAtIndexOrDefault(dataset.backgroundColor, index, arcOpts.backgroundColor);
                model.hoverBackgroundColor = custom.hoverBackgroundColor ? custom.hoverBackgroundColor : valueAtIndexOrDefault(dataset.hoverBackgroundColor, index, arcOpts.hoverBackgroundColor);
                model.borderWidth = custom.borderWidth ? custom.borderWidth : valueAtIndexOrDefault(dataset.borderWidth, index, arcOpts.borderWidth);
                model.borderColor = custom.borderColor ? custom.borderColor : valueAtIndexOrDefault(dataset.borderColor, index, arcOpts.borderColor);

                // Set correct angles if not resetting
                if (!reset || !animationOpts.animateRotate) {
                    if (index === 0) {
                        model.startAngle = opts.rotation;
                    } else {
                        model.startAngle = _this.getMeta().data[index - 1]._model.endAngle;
                    }

                    model.endAngle = model.startAngle + model.circumference;
                }

                arc.pivot();
            }
        });

        $scope.hide_ap_stat = true; // To hide the AP Stats (AP Counter & 3 AP Charts)

        // Display the Scope from local storage
        if ($localStorage.selectedView) {
            $scope.selectedMode = $localStorage.selectedView;
            if ($scope.selectedMode == "Global") {
                $scope.next_tier = "Regions";
            } else if ($scope.selectedMode == "Region") {
                $scope.next_tier = "Locations";
            } else if ($scope.selectedMode == "Location") {
                $scope.next_tier = "Facilities";
            } else if ($scope.selectedMode == "Facility") {
                $scope.next_tier = "Base Stations";
            } else if ($scope.selectedMode == "Basestation") {
                $scope.hide_ap_stat = false;
                $scope.next_tier = "Devices";
            }
        } else {
            $scope.selectedMode = "Global";
            $scope.next_tier = "Regions";
            $scope.hide_ap_stat = true;
        }


        vm.dashboard = {}; // Dashboard object
        vm.dashboard.events = []; // To store Events

        // Default Events call


        // GET Events to load in dashboard
        function loadEvents() {
            generateConfig(); // Generate URL config
            $http.get('api/v2/events/list', $scope.config).then(function (response) {
                if (response.status == 204) {
                    vm.dashboard.events = [];
                } else if (response.status == 200 && response.data) {
                    vm.dashboard.events = response.data.event;
                    if (response.data.event.length < $scope.eventpagesize) {
                        $scope.eventnextBtnDisable = true;
                    }else{
                        $scope.eventnextBtnDisable = false;
                    }
                }
            });
        }

        // Default to get Device Type Status

        loadEvents();
        loadGraphs();
        initGraphs();

        loadDatabyDeviceType();


        $scope.init = function () {

        }

        function initGraphs() {
        if($localStorage.showUI == 'sw') {
            $scope.bhTitle = 'SWITCH';
        }
        $scope.cpe_ptp_config.data.datasets[0].data = [1];
        $scope.cpe_ptp_config.data.labels =  ["no data"];
        $scope.cpe_ptp_config.data.datasets[0].backgroundColor = ["#cccccc"];

            $scope.cpe_ptmp_config.data.datasets[0].data = [1];
            $scope.cpe_ptmp_config.data.labels = ["no data"];
            $scope.cpe_ptmp_config.data.datasets[0].backgroundColor = ["#cccccc"];

            $scope.cpe_bh_config.data.datasets[0].data = [1];
            $scope.cpe_bh_config.data.labels = ["no data"];
            $scope.cpe_bh_config.data.datasets[0].backgroundColor = ["#cccccc"];

            $scope.ap_bh_config.options.title.text = $scope.bhTitle;

            if ($localStorage.selectedView) {
                if ($localStorage.selectedView == 'Basestation') {
                    $scope.cpe_ptp_config.options.title.display = true;
                    $scope.cpe_ptmp_config.options.title.display = true;
                    $scope.cpe_bh_config.options.title.display = true;
                }

            }


        }

        function loadGraphs() {

            reloadAPPTPGraph();
            reloadAPPTMPGraph();
            reloadAPBHGraph();

            reloadSUPTPGraph();
            reloadSUPTMPGraph();
            reloadSUBHGraph();
        }

        function reloadSUBHGraph() {
            cpe_bh_ctx = document.getElementById("cpe_bh_Chart");
            if (cpe_bh_ctx != null) {
                cpe_bh_ctx = document.getElementById("cpe_bh_Chart").getContext("2d");
                cpe_bh_chart = new Chart(cpe_bh_ctx, $scope.cpe_bh_config);
            }

        }


        function reloadSUPTMPGraph() {
            cpe_ptmp_ctx = document.getElementById("cpe_ptmp_Chart");
            if (cpe_ptmp_ctx != null) {
                cpe_ptmp_ctx = document.getElementById("cpe_ptmp_Chart").getContext("2d");
                cpe_ptmp_chart = new Chart(cpe_ptmp_ctx, $scope.cpe_ptmp_config);
            }

        }

        function reloadSUPTPGraph() {
            cpe_ptp_ctx = document.getElementById("cpe_ptp_Chart");
            if (cpe_ptp_ctx != null) {
                cpe_ptp_ctx = document.getElementById("cpe_ptp_Chart").getContext("2d"); // Gets element id
                cpe_ptp_chart = new Chart(cpe_ptp_ctx, $scope.cpe_ptp_config); // Generate new chart with selected config
            }
        }

        function loadMainGraph() {
            main_ctx = document.getElementById("main-chart").getContext("2d");
            main_chart = new Chart(main_ctx, $scope.main_config);

        }

        function reloadAPPTPGraph() {
            ap_ptp_ctx = document.getElementById("ap_ptp_Chart");
            if (ap_ptp_ctx != null) {
                ap_ptp_ctx = document.getElementById("ap_ptp_Chart").getContext("2d");
                ap_ptp_chart = new Chart(ap_ptp_ctx, $scope.ap_ptp_config);
            }
        }

        function reloadAPPTMPGraph() {
            ap_ptmp_ctx = document.getElementById("ap_ptmp_Chart");
            if (ap_ptmp_ctx != null) {
                ap_ptmp_ctx = document.getElementById("ap_ptmp_Chart").getContext("2d");
                ap_ptmp_chart = new Chart(ap_ptmp_ctx, $scope.ap_ptmp_config);
            }
        }

        function reloadAPBHGraph() {
            ap_bh_ctx = document.getElementById("ap_bh_Chart");
            if (ap_bh_ctx != null) {
                ap_bh_ctx = document.getElementById("ap_bh_Chart").getContext("2d");
                ap_bh_chart = new Chart(ap_bh_ctx, $scope.ap_bh_config);
            }
        }

        // GET Device Type Status and Generate 6 Charts
        function loadDatabyDeviceType() {
            if (!$localStorage.facilitiesArray) {
                // If scope is not available in local storage
                var url = 'api/v2/dashboard/networkstatus?filter=productCode&ar=';
                var countURL = 'api/v2/dashboard/facilities?&ar=glob';
            } else {
                // If scope is available in local storage
                var url = 'api/v2/dashboard/networkstatus?filter=productCode&ar=' + $localStorage.ar;
                var countURL = 'api/v2/dashboard/facilities?&ar=' + $localStorage.ar;
                var facilitiesArray = $localStorage.facilitiesArray;
                for (var j = 0; j < facilitiesArray.length; j++) {
                    url = url + '&facilities=' + facilitiesArray[j];
                    countURL = countURL + '&regions=' + facilitiesArray[j];
                }
            }
            //$('#mydiv').show();
            nextTierCount(countURL); // Get Next tier count
            // Get data & generate Device Type Status charts
            $http.get(url, { showdiv: false })
                .then(function (response) {
                    //$('#mydiv').hide();
                    $scope.ptparraysta = [];
                    if (response.data) {
                        $scope.deviceTypeData = response.data;
                        // SU config
                        $scope.sta = {
                            "name": "SU",
                            "total": $scope.deviceTypeData.sta.total,
                            "labels": ["good", "down"],
                            "ptpOpt": { circumference: Math.PI, cutoutPercentage: 50, rotation: -1 * Math.PI, title: { display: true, text: 'PTP' }, onClick: (point, elements) => { selectGraph("PTP") } },
                            "ptmpOpt": { circumference: Math.PI, cutoutPercentage: 50, rotation: -1 * Math.PI, title: { display: true, text: 'PTMP' }, onClick: (point, elements) => { selectGraph("PTMP") } },
                            "bhOpt": { circumference: Math.PI, cutoutPercentage: 50, rotation: -1 * Math.PI, title: { display: true, text: 'BH' }, onClick: (point, elements) => { selectGraph("BH") } },
                            "ptp": [$scope.deviceTypeData.sta.ptp.up, $scope.deviceTypeData.sta.ptp.down],
                            "ptmp": [$scope.deviceTypeData.sta.ptmp.up, $scope.deviceTypeData.sta.ptmp.down],
                            "bh": [$scope.deviceTypeData.sta.backhaul.up, $scope.deviceTypeData.sta.backhaul.down]
                        }

                        if ($scope.sta.ptp[0] == 0 && $scope.sta.ptp[1] == 0) {
                            // SU-PTP Chart Config for null values
                            $scope.cpe_ptp_config.data.datasets[0].data = [1];
                            $scope.cpe_ptp_config.data.labels = ["no data"];
                            $scope.cpe_ptp_config.data.datasets[0].backgroundColor = ["#cccccc"];
                        } else {
                            $scope.cpe_ptp_config.data.datasets[0].data = $scope.sta.ptp;
                            $scope.cpe_ptp_config.data.labels = $scope.sta.labels;
                            $scope.cpe_ptp_config.data.datasets[0].backgroundColor = ["#a5d478", "#ef563d"];
                            $scope.cpe_ptp_config.data.datasets[0].borderWidth = 0;
                            $scope.cpe_ptp_config.options.animation.animateScale = false;;//, animateRotate: false },
                            $scope.cpe_ptp_config.options.animation.animateRotate = false;
                            $scope.cpe_ptp_config.options.animation.duration = 0;
                            $scope.cpe_ptp_config.options.responsiveAnimationDuration = 0;
                            $scope.cpe_ptp_config.options.circumference = Math.PI;
                            $scope.cpe_ptp_config.options.rotation = Math.PI;

                            $scope.cpe_ptp_config.options.tooltips = {};
                        }

                        if (cpe_ptp_chart != null) {
                            cpe_ptp_chart.update();
                        } else {
                            reloadSUPTPGraph;
                        }


                        // SU-PTP Chart generation


                        if ($scope.sta.ptmp[0] == 0 && $scope.sta.ptmp[1] == 0) {

                            $scope.cpe_ptmp_config.data.datasets[0].data = [1];
                            $scope.cpe_ptmp_config.data.labels = ["no data"];
                            $scope.cpe_ptmp_config.data.datasets[0].backgroundColor = ["#cccccc"];
                            $scope.cpe_ptp_config.options.animation.animateScale = false;;//, animateRotate: false },
                            $scope.cpe_ptp_config.options.animation.animateRotate = false;
                            // SU-PTMP Chart Config for null values


                        } else {
                            $scope.cpe_ptmp_config.data.datasets[0].data = $scope.sta.ptmp;
                            $scope.cpe_ptmp_config.data.labels = $scope.sta.labels;
                            $scope.cpe_ptmp_config.data.datasets[0].backgroundColor = ["#a5d478", "#ef563d"];
                            $scope.cpe_ptmp_config.data.datasets[0].borderWidth = 0;
                            $scope.cpe_ptmp_config.options.circumference = Math.PI;
                            $scope.cpe_ptmp_config.options.rotation = Math.PI;
                            $scope.cpe_ptmp_config.options.animation.animateScale = false;;//, animateRotate: false },
                            $scope.cpe_ptmp_config.options.animation.animateRotate = false;
                            $scope.cpe_ptmp_config.options.animation.duration = 0;
                            $scope.cpe_ptmp_config.options.responsiveAnimationDuration = 0;

                        }
                        //cpe_ptmp_chart.update();
                        if (cpe_ptmp_chart != null) {
                            cpe_ptmp_chart.update();
                        } else {
                            reloadSUPTMPGraph;
                        }

                        if ($scope.sta.bh[0] == 0 && $scope.sta.bh[1] == 0) {
                            // SU-BH Chart Config for null values
                            $scope.cpe_bh_config.data.datasets[0].data = [1];
                            $scope.cpe_bh_config.data.labels = ["no data"];
                            $scope.cpe_bh_config.data.datasets[0].backgroundColor = ["#cccccc"];
                        } else {
                            $scope.cpe_bh_config.data.datasets[0].data = $scope.sta.bh;
                            $scope.cpe_bh_config.data.labels = $scope.sta.labels;
                            $scope.cpe_bh_config.data.datasets[0].backgroundColor = ["#a5d478", "#ef563d"];
                            $scope.cpe_bh_config.data.datasets[0].borderWidth = 0;
                            $scope.cpe_bh_config.options.circumference = Math.PI;
                            $scope.cpe_bh_config.options.rotation = Math.PI;
                            $scope.cpe_bh_config.options.animation.animateScale = false;;//, animateRotate: false },
                            $scope.cpe_bh_config.options.animation.animateRotate = false;
                            $scope.cpe_bh_config.options.animation.duration = 0;
                            $scope.cpe_bh_config.options.responsiveAnimationDuration = 0;
                            // SU-BH Chart Config for non-null values
                        }
                        //cpe_bh_chart.update();
                        if (cpe_bh_chart != null) {
                            cpe_bh_chart.update();
                        } else {
                            reloadSUBHGraph;
                        }
                        // SU-BH Chart generation

                        $scope.ap = {
                            "name": "AP",
                            "total": $scope.deviceTypeData.ap.total,
                            "labels": ["good", "down"],
                            "ptpOpt": { circumference: Math.PI, cutoutPercentage: 50, rotation: -1 * Math.PI, title: { display: true, text: 'PTP' }, onClick: (point, elements) => { selectGraph("PTP") } },
                            "ptmpOpt": { circumference: Math.PI, cutoutPercentage: 50, rotation: -1 * Math.PI, title: { display: true, text: 'PTMP' }, onClick: (point, elements) => { selectGraph("PTMP") } },
                            "bhOpt": { circumference: Math.PI, cutoutPercentage: 50, rotation: -1 * Math.PI, title: { display: true, text: 'BH' }, onClick: (point, elements) => { selectGraph("BH") } },
                            "ptp": [$scope.deviceTypeData.ap.ptp.up, $scope.deviceTypeData.ap.ptp.down],
                            "ptmp": [$scope.deviceTypeData.ap.ptmp.up, $scope.deviceTypeData.ap.ptmp.down],
                            "bh": [$scope.deviceTypeData.ap.backhaul.up, $scope.deviceTypeData.ap.backhaul.down],
                            "switch" : [$scope.deviceTypeData.switch.switch.up, $scope.deviceTypeData.switch.switch.down]
                        }

                        if ($scope.ap.ptp[0] == 0 && $scope.ap.ptp[1] == 0) {
                            $scope.ap_ptp_config.data.datasets[0].data = [1];
                            $scope.ap_ptp_config.data.labels =  ["no data"];
                            $scope.ap_ptp_config.data.datasets[0].backgroundColor = ["#cccccc"];
                            // AP-PTP Chart Config for null values
                        } else {
                            $scope.ap_ptp_config.data.datasets[0].data = $scope.ap.ptp;
                            $scope.ap_ptp_config.data.labels = $scope.ap.labels;
                            $scope.ap_ptp_config.data.datasets[0].backgroundColor = ["#a5d478", "#ef563d"];
                            $scope.ap_ptp_config.data.datasets[0].borderWidth = 0;
                            $scope.ap_ptp_config.options.circumference = Math.PI;
                            $scope.ap_ptp_config.options.rotation = Math.PI;
                            $scope.ap_ptp_config.options.animation.animateScale = false;;//, animateRotate: false },
                            $scope.ap_ptp_config.options.animation.animateRotate = false;
                            $scope.ap_ptp_config.options.animation.duration = 0;
                            $scope.ap_ptp_config.options.responsiveAnimationDuration = 0;
                        }
                        // AP-PTP Chart generation
                        if (ap_ptp_chart != null) {
                            ap_ptp_chart.update();
                        } else {
                            reloadAPPTPGraph();
                        }

                        if ($scope.ap.ptmp[0] == 0 && $scope.ap.ptmp[1] == 0) {
                            // AP-PTMP Chart Config for null values
                            $scope.ap_ptmp_config.data.datasets[0].data = [1];
                            $scope.ap_ptmp_config.data.labels =  ["no data"];
                            $scope.ap_ptmp_config.data.datasets[0].backgroundColor = ["#cccccc"];

                        } else {
                            // AP-PTMP Chart Config for non-null values
                            $scope.ap_ptmp_config.data.datasets[0].data = $scope.ap.ptmp;
                            $scope.ap_ptmp_config.data.labels = $scope.ap.labels;
                            $scope.ap_ptmp_config.data.datasets[0].backgroundColor = ["#a5d478", "#ef563d"];
                            $scope.ap_ptmp_config.data.datasets[0].borderWidth = 0;
                            $scope.ap_ptmp_config.options.circumference = Math.PI;
                            $scope.ap_ptmp_config.options.rotation = Math.PI;
                            $scope.ap_ptmp_config.options.animation.animateScale = false;;//, animateRotate: false },
                            $scope.ap_ptmp_config.options.animation.animateRotate = false;
                            $scope.ap_ptmp_config.options.animation.duration = 0;
                            $scope.ap_ptmp_config.options.responsiveAnimationDuration = 0;
                        }
                        // AP-PTMP Chart generation
                        if (ap_ptmp_chart != null) {
                            ap_ptmp_chart.update();
                        } else {
                            reloadAPPTMPGraph();
                        }
                        /*var ap_ptmp_ctx = document.getElementById("ap_ptmp_Chart").getContext("2d");
                        new Chart(ap_ptmp_ctx, ap_ptmp_config);*/

                        if ($localStorage.showUI != 'sw') {
                            if ($scope.ap.bh[0] == 0 && $scope.ap.bh[1] == 0) {
                                // AP-BH Chart Config for null values
                                $scope.ap_bh_config.data.datasets[0].data = [1];
                                $scope.ap_bh_config.data.labels =  ["no data"];
                                $scope.ap_bh_config.data.datasets[0].backgroundColor = ["#cccccc"];
                            } else {
                                // AP-BH Chart Config for non-null values
                                $scope.ap_bh_config.data.datasets[0].data = $scope.ap.bh;
                                $scope.ap_bh_config.data.labels = $scope.ap.labels;
                                $scope.ap_bh_config.data.datasets[0].backgroundColor = ["#a5d478", "#ef563d"];
                                $scope.ap_bh_config.data.datasets[0].borderWidth = 0;
                                $scope.ap_bh_config.options.animation.animateScale = false;;//, animateRotate: false },
                                $scope.ap_bh_config.options.animation.animateRotate = false;
                                $scope.ap_bh_config.options.animation.duration = 0;
                                $scope.ap_bh_config.options.responsiveAnimationDuration = 0;
                                $scope.ap_bh_config.options.circumference = Math.PI;
                                $scope.ap_bh_config.options.rotation = Math.PI;

                            }

                        } else {

                            if ($scope.ap.switch[0] == 0 && $scope.ap.switch[1] == 0) {
                                // AP-BH Chart Config for null values
                                $scope.ap_bh_config.data.datasets[0].data = [1];
                                $scope.ap_bh_config.data.labels =  ["no data"];
                                $scope.ap_bh_config.data.datasets[0].backgroundColor = ["#cccccc"];
                            } else {
                                // AP-BH Chart Config for non-null values
                                if ($scope.ap.switch[1] == undefined) {
                                    $scope.ap.switch[1] = 0;
                                }
                                if ($scope.ap.switch[0] == undefined) {
                                    $scope.ap.switch[0] = 0;
                                }
                                $scope.ap_bh_config.data.datasets[0].data = $scope.ap.switch;
                                $scope.ap_bh_config.data.labels = $scope.ap.labels;
                                $scope.ap_bh_config.data.datasets[0].backgroundColor = ["#a5d478", "#ef563d"];
                                $scope.ap_bh_config.data.datasets[0].borderWidth = 0;
                                $scope.ap_bh_config.options.animation.animateScale = false;;//, animateRotate: false },
                                $scope.ap_bh_config.options.animation.animateRotate = false;
                                $scope.ap_bh_config.options.animation.duration = 0;
                                $scope.ap_bh_config.options.responsiveAnimationDuration = 0;
                                $scope.ap_bh_config.options.circumference = Math.PI;
                                $scope.ap_bh_config.options.rotation = Math.PI;

                            }
                        }
                        if (ap_bh_chart != null) {
                            ap_bh_chart.update();
                        } else {
                            reloadAPBHGraph();
                        }
                    }
                });

        }

        // GET next Tier Count
        function nextTierCount(countUrl) {
            $http.get(countUrl, { showdiv: false })
                .then(function (response) {
                    $scope.next_Tier_Count = response.data;
                });
        }

        $scope.startLinkTimer();

        // Device Status/Main Chart Variables
        $scope.dashboard_data = [0, 0, 0, 0];

        // Generate URL for Device Status/Main chart data
        if (!$localStorage.facilitiesArray) {
            $scope.countSummaryUrl = 'api/v2/dashboard/nodes/counts_fsummary'
        } else {
            $scope.countSummaryUrl = 'api/v2/dashboard/nodes/counts_fsummary?ar=' + $localStorage.ar + '&';
            var facilitiesArray = $localStorage.facilitiesArray;
            for (var j = 0; j < facilitiesArray.length; j++) {
                $scope.countSummaryUrl = $scope.countSummaryUrl + 'facilities=' + facilitiesArray[j];
                if ((j + 1) != facilitiesArray.length) {
                    $scope.countSummaryUrl = $scope.countSummaryUrl + '&';
                }
            }
        }

        // Event Source function to get Device Status/Main chart data
        var nodesSource = new EventSource($scope.countSummaryUrl);

        // Generate Device Status/ Main Chart
        nodesSource.onmessage = function (event) {
            if (event.data) {
                var nodesObj = JSON.parse(event.data);
                $scope.$apply(function () {
                    $scope.dashboard_data = [nodesObj.active, nodesObj.nolink, nodesObj.inactive, nodesObj.unprovisioned];
                    // Device Status Chart Config
                    $scope.main_config.data.datasets[0].data = $scope.dashboard_data;
                    $scope.main_config.data.datasets[0].backgroundColor = ["#a5d478", "#f8d347", "#ef563d", "#00aeef"];
                    $scope.main_config.data.datasets[0].borderWidth = 0;
                    $scope.main_config.data.datasets[0].label = 'Dataset 1';
                    $scope.main_config.data.labels = ["Good", "No Link", "Down", "Unassigned"];

                    // Generate Device status/main Chart
                    if (main_chart != null) {
                        main_chart.update();
                    } else {
                        loadMainGraph();
                    }
                });
            }
            //nodesSource.close();
        };

        // Redirect to the Events page in Node View
        $scope.showNode = function (nodeId, evn, lastView) {
            if (evn.ipAddress) {
                $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });
            } else {
                $state.go('app.events', { "nodeId": nodeId, "lastView": lastView });
            }
        }

        function selectGraph(p1, p2, p3, p4, p5, p6) {
            //selectGraph('productCode', "BACKHAUL", 'sta', '', '', '')
            getDataBasedonSelection(p1, p2, p3, p4, p5, p6);
        }

        // To redirect to Node view page
        $scope.gotoNode = function(nodeId, lastView,type) {
            if (type == 'Switch') {
            localStorage.setItem('selectednodetype','switch');
            localStorage.setItem("modetype",'');
                $state.go('app.swnodeView', { "nodeId": nodeId, "lastView": lastView });
            } else {
            localStorage.setItem('selectednodetype','');
                $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });
            }

        }

        /*$scope.gotoLinkStats = function(nodeId, lastView) {
            $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });
        }*/

        $scope.gotoLinkStats = function(nodeId, lastView,type) {
            if (type == 'Switch') {
            localStorage.setItem('selectednodetype','switch');
            lastView='app.system';
                $state.go('app.swnodeView', { "nodeId": nodeId, "lastView": lastView });
            } else {
            localStorage.setItem('selectednodetype','');
                $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });
            }
        }



        // Default Init call for devices table
        getDataBasedonSelection('', '', '', '', '', '');
        setTimeout(function(){
            var selectedroute= window.location.href.substr(window.location.href.lastIndexOf('/') + 1);
            if(selectedroute=='swdashboard'){
                  getDataBasedonSelection('radioMode', 'ap', 'ap', 'all', '', ''); // Get data based on Tile selection
            }
        }, 1000);

        // Get devices for the Table
        function getDataBasedonSelection(filterType, productCode, radioMode, deviceStatus, sortField, sortOrder) {
            //$('#mydiv').show();
            $scope.addCss = "border:4px solid red";
            if (!filterType || !productCode || !radioMode) {
                // Set the device filters if not passed
                $scope.filterType = 'productCode';
                $scope.productCode = 'ptp';
                $scope.radioMode = 'ap';
            } else {
                $scope.filterType = filterType;
                $scope.productCode = productCode.toLowerCase();
                $scope.radioMode = radioMode;
            }
            // Set the sort if not passed
            if (!sortField || !sortOrder) {
                $scope.sortField = 'sysUptime';
                $scope.sortOrder = 'desc';

            }
            $scope.devStatus = deviceStatus;
            // Set the status filter if not passed
            if (!deviceStatus) {
                $scope.statusFormData.deviceStatus = $scope.deviceStatusArray[0];
                $scope.devStatus = $scope.statusFormData.deviceStatus.id;
            } else {
                if (deviceStatus.id) {
                    $scope.devStatus = deviceStatus.id;
                } else {
                    $scope.devStatus = deviceStatus;
                }
            }
            if(radioMode!='sta'){
                if($localStorage.selectedView=='Basestation'){
                     $scope.productCode='sta';
                     $scope.radioMode='sta';
                }
            }
            // GET Call based on the scope filter selection
            if (!$localStorage.facilitiesArray) {
                $scope.url = 'api/v2/dashboard/filternodes?filter=' + $scope.filterType + '&value=' + $scope.productCode + '&offset=' + $scope.currentpage + '&limit=' + $scope.pagesize + '&status=' + $scope.devStatus + '&rd=' + $scope.radioMode + '&sort=' + $scope.sortField + '&by=' + $scope.sortOrder + '&ar=' + $localStorage.ar;
            } else {
                $scope.url = 'api/v2/dashboard/filternodes?filter=' + $scope.filterType + '&value=' + $scope.productCode + '&offset=' + $scope.currentpage + '&limit=' + $scope.pagesize + '&status=' + $scope.devStatus + '&rd=' + $scope.radioMode + '&sort=' + $scope.sortField + '&by=' + $scope.sortOrder + '&ar=' + $localStorage.ar + '&';
                var facilitiesArray = $localStorage.facilitiesArray;
                for (var j = 0; j < facilitiesArray.length; j++) {
                    $scope.url = $scope.url + 'facilities=' + facilitiesArray[j];
                    if ((j + 1) != facilitiesArray.length) {
                        $scope.url = $scope.url + '&';
                    }
                }
            }
            $http.get($scope.url, { showdiv: false }).then(function (response) {
                // $('#mydiv').hide();
                $scope.dashboardData = response.data.nodes;
                console.log("dashboard data",$scope.dashboardData);
                for (var i = 0; i < $scope.dashboardData.length; i++) {
                    $scope.dashboardData[i].sysNameEllipse = ellipsemodel($scope.dashboardData[i].sysName);
                }
                if (response.data.nodes.length < $scope.pagesize) {
                    $scope.nextBtnDisable = true;
                } else {
                    $scope.nextBtnDisable = false;
                }
                $scope.TotalPages = response.data.length;
                if ($scope.dashboardData == null) {
                    $scope.TotalPages = 0;
                }
                $scope.pagenumber = Math.ceil($scope.dashboardData.length / $scope.pagesize);
                if ($scope.pagenumber == 0) {
                    $scope.pagenumber = 1;
                }
            });
        }

        // Making the Ellipsis in middle for Long String
        function ellipsemodel(str) {
            // If string length is longer than 10
            if (str.length > 10) {
                return str.substr(0, 5) + ' ... ' + str.substr(str.length - 5, str.length);
            }
            return str;
        }

        $scope.selectedRow = null; // Initialize Selected Row to Null

        // Selected Row function
        $scope.setClickedRow = function (index) {
            $scope.selectedRow = index;
        }

        //$scope.selectedCol = 'ptp_ap';  // initialize our variable to null

        // Function that sets the value of selectedRow to current index
        $scope.setClickedCol = function (selectedColDiv) {
            $scope.selectedCol = selectedColDiv;
        }

        // AP/SU Tile On Click function
        $scope.tileSelection = function (productCode, radioMode) {
            if (!productCode || !radioMode) {
                // If no product code or radio mode is passed
                $scope.productCode = "ap";
                $scope.radioMode = "ap";
            } else {
                $scope.productCode = productCode;
                $scope.radioMode = radioMode;
            }
            getDataBasedonSelection('radioMode', $scope.productCode, $scope.radioMode, '', '', ''); // Get data based on Tile selection
        }

        // Default bindings for Device Table Columns
        if (!$localStorage.flag_Dash) {
            $scope.cols = [
                { 'label': 'System Name', 'sortField': 'sysName', 'status': true, 'alignment': 'text-align:left' },
                { 'label': 'Primary IP', 'sortField': 'ipAddress', 'status': true, 'alignment': 'text-align:left' },
                { 'label': 'MAC Address', 'sortField': 'macAddress', 'status': true,'alignment': 'text-align:left' },
                { 'label': 'Serial Number', 'sortField': 'serialNum', 'status': true,'alignment': 'text-align:left' },
                { 'label': 'Model Number', 'sortField': 'modelNum', 'status': true,'alignment': 'text-align:left' },
                { 'label': 'Firmware', 'sortField': 'firmware', 'status': true,'alignment': 'text-align:right' },
                { 'label': 'Status', 'sortField': 'status', 'status': true,'alignment': 'text-align:right' },
                { 'label': 'Up Time ', 'sortField': 'sysUptime', 'status': true,'alignment': 'text-align:right' },
                { 'label': 'Product Code', 'sortField': 'productCode', 'status': false },
                { 'label': 'Radio Mode', 'sortField': 'radioMode', 'status': false },
                { 'label': 'Operation Mode', 'sortField': 'opMode', 'status': false },
                { 'label': 'Frequency', 'sortField': 'frequency', 'status': false },
                { 'label': 'Bandwidth', 'sortField': 'bandwidth', 'status': false, 'alignment': 'text-align:left' },
                { 'label': 'Channel', 'sortField': 'channel', 'status': false },
                { 'label': 'Elevation', 'sortField': 'elevation', 'status': false },
                { 'label': 'SSID', 'sortField': 'ssid', 'status': false },
                { 'label': 'Local SNR', 'sortField': 'lsnr', 'status': false },
                { 'label': 'Remote Partners', 'sortField': 'remotePartners', 'status': false },
                { 'label': 'Backup IP', 'sortField': 'fallbackIP', 'status': false },
                { 'label': 'Net Mask', 'sortField': 'netmask', 'status': false },
                { 'label': 'Gateway', 'sortField': 'gateway', 'status': false },
                { 'label': 'Region', 'sortField': 'region', 'status': false },
                { 'label': 'Facility', 'sortField': 'facility', 'status': false }
            ];
            $scope.allToggle = false;
        } else {
            $scope.cols = $localStorage.cols_Dash;
            $scope.allToggle = $localStorage.allToggle_Dash;
        }

        // To show or hide columns in the table
        $scope.showhideCol = function (colObj, ind) {
            $scope.cols[ind].status = colObj.status;
            $localStorage.flag_Dash = true;
            $localStorage.cols_Dash = $scope.cols;
            $scope.allToggle = false;
            $localStorage.allToggle_Dash = false;
        }

        // To show all or default columns in table
        $scope.showAllCol = function (allToggle) {
            if (allToggle) {
                // To display all columns
                $scope.cols = [
                    { 'label': 'System Name', 'sortField': 'sysName', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Primary IP', 'sortField': 'ipAddress', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'MAC Address', 'sortField': 'macAddress', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Serial Number', 'sortField': 'serialNum', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Model Number', 'sortField': 'modelNum', 'status': true,'alignment': 'text-align:left' },
                    { 'label': 'Firmware', 'sortField': 'firmware', 'status': true,'alignment': 'text-align:right' },
                    { 'label': 'Status', 'sortField': 'status', 'status': true,'alignment': 'text-align:right' },
                    { 'label': 'Up Time ', 'sortField': 'sysUptime', 'status': true,'alignment': 'text-align:right' },
                    { 'label': 'Product Code', 'sortField': 'productCode', 'status': true },
                    { 'label': 'Radio Mode', 'sortField': 'radioMode', 'status': true },
                    { 'label': 'Operation Mode', 'sortField': 'opMode', 'status': true },
                    { 'label': 'Frequency', 'sortField': 'frequency', 'status': true },
                    { 'label': 'Bandwidth', 'sortField': 'bandwidth', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Channel', 'sortField': 'channel', 'status': true },
                    { 'label': 'Elevation', 'sortField': 'elevation', 'status': true },
                    { 'label': 'SSID', 'sortField': 'ssid', 'status': true },
                    { 'label': 'Local SNR', 'sortField': 'lsnr', 'status': true },
                    { 'label': 'Remote Partners', 'sortField': 'remotePartners', 'status': true },
                    { 'label': 'Backup IP', 'sortField': 'fallbackIP', 'status': true },
                    { 'label': 'Net Mask', 'sortField': 'netmask', 'status': true },
                    { 'label': 'Gateway', 'sortField': 'gateway', 'status': true },
                    { 'label': 'Region', 'sortField': 'region', 'status': true },
                    { 'label': 'Facility', 'sortField': 'facility', 'status': true }
                ];
                $scope.allToggle = true;
                $localStorage.allToggle_Dash = true;
            } else {
                // To display Default columns
                $scope.cols = [
                    { 'label': 'System Name', 'sortField': 'sysName', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Primary IP', 'sortField': 'ipAddress', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'MAC Address', 'sortField': 'macAddress', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Serial Number', 'sortField': 'serialNum', 'status': true , 'alignment': 'text-align:left'},
                    { 'label': 'Model Number', 'sortField': 'modelNum', 'status': true,'alignment': 'text-align:left' },
                    { 'label': 'Firmware', 'sortField': 'firmware', 'status': true,'alignment': 'text-align:right' },
                    { 'label': 'Status', 'sortField': 'status', 'status': true,'alignment': 'text-align:right' },
                    { 'label': 'Up Time ', 'sortField': 'sysUptime', 'status': true,'alignment': 'text-align:right' },
                    { 'label': 'Product Code', 'sortField': 'productCode', 'status': false },
                    { 'label': 'Radio Mode', 'sortField': 'radioMode', 'status': false },
                    { 'label': 'Operation Mode', 'sortField': 'opMode', 'status': false },
                    { 'label': 'Frequency', 'sortField': 'frequency', 'status': false },
                    { 'label': 'Bandwidth', 'sortField': 'bandwidth', 'status': false, 'alignment': 'text-align:left' },
                    { 'label': 'Channel', 'sortField': 'channel', 'status': false },
                    { 'label': 'Elevation', 'sortField': 'elevation', 'status': false },
                    { 'label': 'SSID', 'sortField': 'ssid', 'status': false },
                    { 'label': 'Local SNR', 'sortField': 'lsnr', 'status': false },
                    { 'label': 'Remote Partners', 'sortField': 'remotePartners', 'status': false },
                    { 'label': 'Backup IP', 'sortField': 'fallbackIP', 'status': false },
                    { 'label': 'Net Mask', 'sortField': 'netmask', 'status': false, 'alignment': 'text-align:left' },
                    { 'label': 'Gateway', 'sortField': 'gateway', 'status': false, 'alignment': 'text-align:left' },
                    { 'label': 'Region', 'sortField': 'region', 'status': false },
                    { 'label': 'Facility', 'sortField': 'facility', 'status': false }
                ];
                $scope.allToggle = false;
                $localStorage.allToggle_Dash = false;
            }
            $localStorage.flag_Dash = true;
            $localStorage.cols_Dash = $scope.cols;
        }

        //Default Search for Device table
        $scope.dashboardInput = '';

        // Change the page size of the Device table
        $scope.changePageSize = function (pagesize) {
            // $scope.dashboardInput = '';
            // $scope.clearSearch = false;
            $scope.pagesize = pagesize;
            $scope.currentpage = 1; // Set page to 1
            if (!$scope.filterType || !$scope.productCode || !$scope.radioMode) {
                $scope.filterType = 'productCode';
                $scope.productCode = 'ptp';
                $scope.radioMode = 'ap';
            } else {
                $scope.filterType = $scope.filterType;
                $scope.productCode = $scope.productCode.toLowerCase();
                $scope.radioMode = $scope.radioMode;
            }
            if (!$scope.statusFormData.deviceStatus) {
                $scope.statusFormData.deviceStatus = $scope.deviceStatusArray[0];
            }
            if ($scope.clearSearch) {
                if ($scope.dashboardInput) {
                    var url = 'api/v2/nodes/search?_s=assetRecord.serialNumber=='+$scope.dashboardInput+',sysName==' + $scope.dashboardInput + ',' + 'label==' + $scope.dashboardInput + '&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=asc';
                    //var url = 'api/v2/nodes/search?_s=sysName==' + dashboardInput + '*' + ',' + 'label=='+dashboardInput;
                    $http.get(url, { showdiv: false })
                        .then(function (response) {
                            if (response.data) {
                                $scope.dashboardData = response.data.nodes;
                                if ($scope.dashboardData) {
                                    for (var i = 0; i < $scope.dashboardData.length; i++) {
                                        $scope.dashboardData[i].sysNameEllipse = ellipsemodel($scope.dashboardData[i].sysName);
                                    }
                                    $scope.TotalPages = response.data.nodes.length;

                                    if ($scope.dashboardData == null) {
                                        $scope.TotalPages = 0;
                                    }
                                    $scope.pagenumber = Math.ceil($scope.dashboardData.length / $scope.pagesize);
                                    if ($scope.pagenumber == 0) {
                                        $scope.pagenumber = 1;
                                    }
                                    if (response.data.nodes.length < $scope.pagesize) {
                                        $scope.nextBtnDisable = true;
                                    }
                                }
                            }
                        });
                }

            } else {
                if (!$localStorage.facilitiesArray) {
                    $scope.url = 'api/v2/dashboard/filternodes?filter=' + $scope.filterType + '&value=' + $scope.productCode + '&offset=' + $scope.currentpage + '&limit=' + $scope.pagesize + '&status=' + $scope.statusFormData.deviceStatus.id + '&rd=' + $scope.radioMode + '&sort=' + $scope.sortField + '&by=' + $scope.sortOrder + '&ar=' + $localStorage.ar;
                } else {
                    $scope.url = 'api/v2/dashboard/filternodes?filter=' + $scope.filterType + '&value=' + $scope.productCode + '&offset=' + $scope.currentpage + '&limit=' + $scope.pagesize + '&status=' + $scope.statusFormData.deviceStatus.id + '&rd=' + $scope.radioMode + '&sort=' + $scope.sortField + '&by=' + $scope.sortOrder + '&ar=' + $localStorage.ar + '&';
                    var facilitiesArray = $localStorage.facilitiesArray;
                    for (var j = 0; j < facilitiesArray.length; j++) {
                        $scope.url = $scope.url + 'facilities=' + facilitiesArray[j];
                        if ((j + 1) != facilitiesArray.length) {
                            $scope.url = $scope.url + '&';
                        }
                    }
                }
                $http.get($scope.url, { showdiv: false })
                    .then(function (response) {
                        $scope.dashboardData = response.data.nodes;
                        for (var i = 0; i < $scope.dashboardData.length; i++) {
                            $scope.dashboardData[i].sysNameEllipse = ellipsemodel($scope.dashboardData[i].sysName);
                        }
                        $scope.TotalPages = response.data.totalCount;
                        $scope.TotalRecords = response.data.totalCount;
                        if (response.data.nodes.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        } else {
                            $scope.nextBtnDisable = false;
                        }
                        if ($scope.dashboardData == null) {
                            $scope.TotalPages = 0;
                        }
                        $scope.pagenumber = Math.ceil($scope.dashboardData.length / $scope.pagesize);
                        if ($scope.pagenumber == 0) {
                            $scope.pagenumber = 1;
                        }
                    });
            }

        }

        // Paging function of Device Table
        $scope.paging = function (type, totalPages, val) {
            // If clicked on Previous page or Next page button
            if (val == 'previous') {
                --$scope.currentpage;
            } else if (val == 'next') {
                ++$scope.currentpage;
            }
            if ($scope.clearSearch) {
                if ($scope.dashboardInput) {
                    var url = 'api/v2/nodes/search?_s=assetRecord.serialNumber'+ $scope.dashboardInput +',sysName==' + $scope.dashboardInput + ',' + 'label==' + $scope.dashboardInput + '&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=asc';
                    //var url = 'api/v2/nodes/search?_s=sysName==' + dashboardInput + '*' + ',' + 'label=='+dashboardInput;
                    $http.get(url, { showdiv: false })
                        .then(function (response) {
                            if (response.data) {
                                $scope.dashboardData = response.data.nodes;
                                if ($scope.dashboardData) {
                                    for (var i = 0; i < $scope.dashboardData.length; i++) {
                                        $scope.dashboardData[i].sysNameEllipse = ellipsemodel($scope.dashboardData[i].sysName);
                                    }
                                    $scope.TotalPages = response.data.nodes.length;

                                    if ($scope.dashboardData == null) {
                                        $scope.TotalPages = 0;
                                    }
                                    $scope.pagenumber = Math.ceil($scope.dashboardData.length / $scope.pagesize);
                                    if ($scope.pagenumber == 0) {
                                        $scope.pagenumber = 1;
                                    }
                                    if (val == "next") {
                                        if (response.data.nodes.length < $scope.pagesize) {
                                            $scope.nextBtnDisable = true;
                                        }
                                    } else {
                                        if (response.data.nodes.length >= $scope.pagesize) {
                                            $scope.nextBtnDisable = false;
                                        }
                                    }
                                }
                            }
                        });
                }

            } else {
                if (!$scope.filterType || !$scope.productCode || !$scope.radioMode) {
                    $scope.filterType = 'productCode';
                    $scope.productCode = 'ptp';
                    $scope.radioMode = 'ap'
                } else {
                    $scope.filterType = $scope.filterType;
                    $scope.productCode = $scope.productCode.toLowerCase();
                    $scope.radioMode = $scope.radioMode;
                }

                if (!$scope.statusFormData.deviceStatus) {
                    $scope.statusFormData.deviceStatus = $scope.deviceStatusArray[0];
                }
                if (!$localStorage.facilitiesArray) {
                    $scope.url = 'api/v2/dashboard/filternodes?filter=' + $scope.filterType + '&value=' + $scope.productCode + '&offset=' + $scope.currentpage + '&limit=' + $scope.pagesize + '&status=' + $scope.statusFormData.deviceStatus.id + '&rd=' + $scope.radioMode + '&sort=' + $scope.sortField + '&by=' + $scope.sortOrder + '&ar=' + $localStorage.ar;
                } else {
                    $scope.url = 'api/v2/dashboard/filternodes??filter=' + $scope.filterType + '&value=' + $scope.productCode + '&offset=' + $scope.currentpage + '&limit=' + $scope.pagesize + '&status=' + $scope.statusFormData.deviceStatus.id + '&rd=' + $scope.radioMode + '&sort=' + $scope.sortField + '&by=' + $scope.sortOrder + '&ar=' + $localStorage.ar + '&';
                    var facilitiesArray = $localStorage.facilitiesArray;
                    for (var j = 0; j < facilitiesArray.length; j++) {
                        $scope.url = $scope.url + 'facilities=' + facilitiesArray[j];
                        if ((j + 1) != facilitiesArray.length) {
                            $scope.url = $scope.url + '&';
                        }
                    }
                }
                $http.get($scope.url, { showdiv: false })
                    .then(function (response) {
                        $scope.dashboardData = response.data.nodes;
                        for (var i = 0; i < $scope.dashboardData.length; i++) {
                            $scope.dashboardData[i].sysNameEllipse = ellipsemodel($scope.dashboardData[i].sysName);
                        }
                        $scope.TotalPages = response.data.length;

                        if (val == "next") {
                            if (response.data.nodes.length < $scope.pagesize) {
                                $scope.nextBtnDisable = true;
                            }
                        } else {
                            if (response.data.nodes.length >= $scope.pagesize) {
                                $scope.nextBtnDisable = false;
                            }
                        }
                        if ($scope.dashboardData == null) {
                            $scope.TotalPages = 0;
                        }
                        $scope.pagenumber = Math.ceil($scope.dashboardData.length / $scope.pagesize);
                        if ($scope.pagenumber == 0) {
                            $scope.pagenumber = 1;
                        }
                    });
            }
        }

        $scope.clearsearch = function () {
            $scope.clearSearch = false;
            getDataBasedonSelection('', '', '', '', '', '');
            $scope.dashboardInput = '';
        }

        // Search for IP Address or System Name
        $scope.search = function (dashboardInput) {
            if (dashboardInput) {
                // var sysOrIP = '';
                // var splitdashboardInput = dashboardInput.split(".").join("");
                // var searchVal = !isNaN(splitdashboardInput);
                // if (searchVal) {
                //     sysOrIP = dashboardInput;
                // }
                // else {
                //     sysOrIP = dashboardInput + '*';
                // }

                var url = 'api/v2/nodes/search?_s=assetRecord.serialNumber=='+ dashboardInput +',sysName==' + dashboardInput + ',' + 'label==' + dashboardInput + '&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=asc';
                //var url = 'api/v2/nodes/search?_s=sysName==' + dashboardInput + '*' + ',' + 'label=='+dashboardInput;
                $http.get(url, { showdiv: false })
                    .then(function (response) {
                        $scope.clearSearch = true;
                        if (response.data) {
                            $scope.dashboardData = response.data.nodes;
                            if ($scope.dashboardData) {

                                for (var i = 0; i < $scope.dashboardData.length; i++) {
                                    $scope.dashboardData[i].sysNameEllipse = ellipsemodel($scope.dashboardData[i].sysName);
                                }
                                $scope.TotalPages = response.data.nodes.length;

                                if ($scope.dashboardData == null) {
                                    $scope.TotalPages = 0;
                                }
                                $scope.pagenumber = Math.ceil($scope.dashboardData.length / $scope.pagesize);
                                if ($scope.pagenumber == 0) {
                                    $scope.pagenumber = 1;
                                }
                                if (response.data.nodes.length < $scope.pagesize) {
                                    $scope.nextBtnDisable = true;
                                }
                            }
                        }else{
                            $scope.dashboardData = [];
                        }
                    });
            }
        }

        // Change Device Status for Device Table
        $scope.changeDeviceStatus = function (deviceStatus) {
            $scope.statusFormData.deviceStatus = deviceStatus;
            // Device Table GET Call
            getDataBasedonSelection($scope.filterType, $scope.productCode, $scope.radioMode, $scope.statusFormData.deviceStatus, $scope.sortField, $scope.sortOrder);
        }

        $scope.mo = function(){
            // $(this).tooltip('hide')
            $("[data-toggle='tooltip']").tooltip('hide');
        }

        // Sorting of the Device Table
        $scope.sort = function (sortField) {
            $scope.currentpage = 1; // Make the page to 1

            // Device Table GET Call
            if (!$scope.clearSearch) {
                if (sortField == $scope.sortField) {
                    // If clicked on same field
                    $scope.sortOrder = $scope.sortOrder == 'asc' ? 'desc' : 'asc'; // Change Sort Order
                } else {
                    // If clicked on different field
                    $scope.sortField = sortField;
                    $scope.sortOrder = 'asc';
                }
                getDataBasedonSelection($scope.filterType, $scope.productCode, $scope.radioMode, $scope.statusFormData.deviceStatus, $scope.sortField, $scope.sortOrder);
            } else {
                if ($scope.dashboardInput) {

                    switch (sortField) {
                        case 'ipAddress': $scope.sortField = 'id';
                            break;

                        case 'serialNum': $scope.sortField = 'assetRecord.serialNumber';
                            break;

                        case 'modelNum': $scope.sortField = 'assetRecord.modelNumber';
                            break;

                        case 'firmware': $scope.sortField = 'assetRecord.firmware';
                            break;

                        case 'status': $scope.sortField = 'id';
                            break;

                        case 'netmask': $scope.sortField = 'ipConfig.netMask';
                            break;

                        case 'gateway': $scope.sortField = 'ipConfig.gateway';
                            break;

                        default :$scope.sortField = sortField;
                    }

                    //$scope.sortField = 'id';
                    $scope.sortOrder = $scope.sortOrder == 'asc' ? 'desc' : 'asc';
                    var url = 'api/v2/nodes/search?_s=sysName==' + $scope.dashboardInput + ',' + 'label==' + $scope.dashboardInput + ',assetRecord.serialNumber=='+ $scope.dashboardInput + '&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=' + $scope.sortOrder + '&orderBy=' + $scope.sortField + '&';
                    //var url = 'api/v2/nodes/search?_s=sysName==' + dashboardInput + '*' + ',' + 'label=='+dashboardInput;
                    $http.get(url, { showdiv: false })
                        .then(function (response) {
                            if (response.data) {
                                $scope.dashboardData = response.data.nodes;
                                if ($scope.dashboardData) {
                                    for (var i = 0; i < $scope.dashboardData.length; i++) {
                                        $scope.dashboardData[i].sysNameEllipse = ellipsemodel($scope.dashboardData[i].sysName);
                                    }
                                    $scope.TotalPages = response.data.nodes.length;

                                    if ($scope.dashboardData == null) {
                                        $scope.TotalPages = 0;
                                    }
                                    $scope.pagenumber = Math.ceil($scope.dashboardData.length / $scope.pagesize);
                                    if ($scope.pagenumber == 0) {
                                        $scope.pagenumber = 1;
                                    }
                                    if (response.data.nodes.length < $scope.pagesize) {
                                        $scope.nextBtnDisable = true;
                                    }
                                }
                            }
                        });
                }
            }

        }

        // Generate Event URL Config
        function generateConfig() {
            var filterVal = 'eventDisplay==Y;eventSource!=syslogd';
            if ($scope.eventSeverity.id > -1) {
                filterVal += ';eventSeverity==' + $scope.eventSeverity.id;
            }
            if ($scope.eventTimeRange.id != "") {
                filterVal += ';eventCreateTime=gt=' + (Date.now() - $scope.eventTimeRange.id);
            }
            if (!$localStorage.facilitiesArray) {
                $scope.config = {
                    showdiv: false,
                    params: {
                        '_s': filterVal,
                        'limit': $scope.eventpagesize,
                        'offset': (($scope.eventcurrentpage - 1) * $scope.eventpagesize),
                        'ar': 'glob'

                    }
                };
            } else {
                var locVal = '';
                var facilitiesArray = $localStorage.facilitiesArray;
                for (var j = 0; j < facilitiesArray.length; j++) {
                    locVal = locVal + facilitiesArray[j];
                    if ((j + 1) != facilitiesArray.length) {
                        locVal = locVal + '&';
                    }
                }
                $scope.config = {
                    showdiv: false,
                    params: {
                        '_s': filterVal,
                        'limit': $scope.eventpagesize,
                        'offset': (($scope.eventcurrentpage - 1) * $scope.eventpagesize),
                        'ar': $localStorage.ar,
                        'fac': facilitiesArray//locVal

                    }
                };
            }
        }

        //Time Range Change for Events
        $scope.timeRangeChange = function (eventTimeRange) {
            $scope.eventTimeRange = eventTimeRange;
            generateConfig();
            $http.get('api/v2/events/list', $scope.config).then(function (response) {
                if (response.status == 204) {
                    vm.dashboard.events = [];
                } else if (response.status == 200 && response.data) {
                    vm.dashboard.events = response.data.event;
                    if (response.data.event.length < $scope.eventpagesize) {
                        $scope.eventnextBtnDisable = true;
                    }else{
                        $scope.eventnextBtnDisable = false;
                    }
                }
            });
        }

        //Severity Change for events
        $scope.severityChange = function (eventSeverity) {
        $scope.eventcurrentpage=1;
            $scope.eventSeverity = eventSeverity;
            generateConfig();
            $http.get('api/v2/events/list', $scope.config).then(function (response) {
                if (response.status == 204) {
                    vm.dashboard.events = [];
                    $scope.eventnextBtnDisable = true;
                } else if (response.status == 200 && response.data) {
                    vm.dashboard.events = response.data.event;
                    if (response.data.event.length < $scope.eventpagesize) {
                        $scope.eventnextBtnDisable = true;
                    }else{
                        $scope.eventnextBtnDisable = false;
                    }
                }
            });
        }

        // Event Pagination method
        $scope.eventpaging = function(val) {
            if (val == 'previous') {
                --$scope.eventcurrentpage;
            } else if (val == 'next') {
                ++$scope.eventcurrentpage;
            }
            generateConfig();
            $http.get('api/v2/events/list', $scope.config).then(function(response) {
                vm.dashboard.events = response.data.event;
                // Pagination button disable conidtions
                if (val == "next") {
                    if (response.data.event.length < $scope.eventpagesize) {
                        $scope.eventnextBtnDisable = true;
                    }
                } else {
                    if (response.data.event.length >= $scope.eventpagesize) {
                        $scope.eventnextBtnDisable = false;
                    }
                }
            });
        }

        // Event Page size change method
        $scope.changeeventPageSize = function(pagesize) {
            $scope.eventcurrentpage = 1;
            $scope.eventpagesize = pagesize;
            generateConfig();
            $http.get('api/v2/events/list', $scope.config).then(function(response) {
                vm.dashboard.events = response.data.event;
                if (response.data.event.length < $scope.eventpagesize) {
                    $scope.eventnextBtnDisable = true;
                } else {
                    $scope.eventnextBtnDisable = false;
                }
            });
        }

        // Event Page goto Home method
        $scope.eventgotoHome = function() {
            $scope.eventcurrentpage = 1;
            generateConfig();
            $http.get('api/v2/events/list', $scope.config).then(function(response) {
                vm.dashboard.events = response.data.event;
                if (response.data.event.length < $scope.eventpagesize) {
                    $scope.eventnextBtnDisable = true;
                } else {
                    $scope.eventnextBtnDisable = false;
                }
            });
        }


        $scope.eventLabel = function (event) {
            if ('nms' == event.host || 'NMS' == event.host) {
                return event.host;
            }
            return event.ipAddress;
        }

        // Show Alert function for controller
        $scope.showAlert = function (msgType, msg, ev) {
            $mdDialog.show(
                $mdDialog.alert()
                    .parent(angular.element(document.querySelector('#popupContainer')))
                    .clickOutsideToClose(true)
                    .title(msgType)
                    .textContent(msg)
                    .ariaLabel('Alert')
                    .ok('OK')
                    .targetEvent(ev)
            );
        };

        // Select Columns Dropdown function
        $("document").ready(function () {
            $('.dropdown-menu').on('click', function (e) {
                if ($(this).hasClass('dropdown-menu')) {
                    e.stopPropagation();
                }
            });
            $('[data-toggle="tooltip"]').tooltip();
            $('[rel="tooltip"]').on('click', function () {
            $(this).tooltip('hide')
            })
        });

        // Scope Start
        // Display Scope Modal function
        $rootScope.showpopup = function () {
            $scope.errNotify = '';
            if ($localStorage.selectedView) {
                $scope.value = $localStorage.selectedView;
                $scope.div_select = $localStorage.selectedView;
                $("#myModal").modal("show");
                $scope.modeSelection($scope.div_select);
            } else {
                $scope.value = "Global";
                $scope.div_select = "Global";
                $scope.modeSelection($scope.div_select);
                $("#myModal").modal("show");
            }
        }

        // Radio Buttons for tab selection function
        $scope.modeSelection = function (srcval) {
            $scope.errNotify = '';
            if (srcval == 'Global') {
                // If Selected tab is Global
                $scope.div_select = srcval;
            } else if (srcval == 'Region') {
                // If Selected tab is Region
                var url = 'api/v2/treeview/regions';
                $http.get(url)
                    .then(function (response) {
                        if (response.data) {
                            $scope.vm.node = response.data;
                            // Check local storage for region in scope
                            if ($localStorage.selectedregArray) {
                                $scope.regions = $localStorage.selectedregArray;
                            } else {
                                $scope.regions = response.data;
                            }
                            $scope.div_select = srcval;
                        }
                    });
            } else if (srcval == 'Facility') {
                // If Selected tab is Facility
                var url = 'api/v2/treeview/regions';
                $http.get(url)
                    .then(function (response) {
                        if (response.data) {
                            $scope.regions = response.data;
                            // Check local storage for region in scope
                            if ($localStorage.selectedRegID) {
                                $scope.regionsData = $localStorage.selectedRegID;
                                $scope.selectedRegID = $localStorage.selectedRegID;
                            }
                            // Check local storage for location in scope
                            if ($localStorage.selectedLocID) {
                                var url = 'api/v2/treeview/regions/' + $localStorage.selectedRegID.data.id + '/locations';
                                $http.get(url)
                                    .then(function (response) {
                                        if (response.data) {
                                            $scope.locations = response.data;
                                            $scope.locationData = $localStorage.selectedLocID;
                                            $scope.selectedLocID = $localStorage.selectedLocID;
                                        }
                                    });
                            }
                            // Check local storage for facility in scope
                            if ($localStorage.selectedfacArray) {
                                $scope.facilities = $localStorage.selectedfacArray;
                            }
                            $scope.div_select = srcval;
                        }
                    });
            } else if (srcval == 'Location') {
                // If Selected tab is Location
                var url = 'api/v2/treeview/regions';
                $http.get(url)
                    .then(function (response) {
                        if (response.data) {
                            $scope.regions = response.data;
                            // Check local storage for region in scope
                            if ($localStorage.selectedRegID) {
                                $scope.regionsData = $localStorage.selectedRegID;
                                $scope.selectedRegID = $localStorage.selectedRegID;
                            }
                            // Check local storage for location in scope
                            if ($localStorage.selectedlocArray) {
                                $scope.locations = $localStorage.selectedlocArray;
                            }
                            $scope.div_select = srcval;
                        }
                    });
            } else if (srcval == 'Basestation') {
                // If Selected tab is Base Station
                var url = 'api/v2/treeview/regions';
                $http.get(url)
                    .then(function (response) {
                        if (response.data) {
                            //$scope.basestation = response.data;
                            $scope.regions = response.data;
                            // Check local storage for region in scope
                            if ($localStorage.selectedRegID) {
                                $scope.regionsData = $localStorage.selectedRegID;
                                $scope.selectedRegID = $localStorage.selectedRegID;
                            }
                            // Check local storage for location in scope
                            if ($localStorage.selectedLocID) {
                                var url = 'api/v2/treeview/regions/' + $localStorage.selectedRegID.data.id + '/locations';
                                $http.get(url)
                                    .then(function (response) {
                                        if (response.data) {
                                            $scope.locations = response.data;
                                            $scope.locationData = $localStorage.selectedLocID;
                                            $scope.selectedLocID = $localStorage.selectedLocID;
                                        }
                                    });
                            }
                            // Check local storage for Facility in scope
                            if ($localStorage.selectedFacID) {
                                var url = 'api/v2/treeview/locations/' + $localStorage.selectedLocID.data.id + '/facilities';
                                $http.get(url)
                                    .then(function (response) {
                                        if (response.data) {
                                            $scope.facilities = response.data;
                                            $scope.facData = $localStorage.selectedFacID;
                                            $scope.selectedFacID = $localStorage.selectedFacID;
                                        }
                                    });
                            }
                            // Check local storage for Base Station in scope
                            if ($localStorage.selectedbseArray) {
                                $scope.basestations = $localStorage.selectedbseArray;
                            }
                            $scope.div_select = srcval;
                        }
                    });
            }
        }

        // On Region Change, Load Locations of selected region
        $scope.regionChange = function (regionId) {
            if (regionId) {
                // if Region is available
                $scope.locations = "";
                $scope.facilities = "";
                $scope.basestations = "";
                $scope.selectedRegID = regionId;
                var url = 'api/v2/treeview/regions/' + regionId.data.id + '/locations';
                $http.get(url)
                    .then(function (response) {
                        if (response.data) {
                            $scope.locations = response.data;
                            $scope.locationData = {};
                            $scope.facData = {};
                        }
                    });
            } else {
                // If region is not available
                $scope.locations = "";
                $scope.facilities = "";
                $scope.basestations = "";
            }
        }

        // On Location Change, Load Facilities of selected Location
        $scope.locationChange = function (locationID) {
            if (locationID) {
                // If Location is available
                $scope.facilities = "";
                $scope.basestations = "";
                $scope.selectedLocID = locationID;
                var url = 'api/v2/treeview/locations/' + locationID.data.id + '/facilities';
                $http.get(url)
                    .then(function (response) {
                        if (response.data) {
                            $scope.facilities = response.data;
                            $scope.facData = {};
                        }
                    });
            } else {
                // If Location is not available
                $scope.facilities = "";
                $scope.basestations = "";
            }
        }

        // On Facility Change, Load Basestations of selected facility
        $scope.facilityChange = function (facilityId) {
            if (facilityId) {
                // If Facility is available
                $scope.basestations = "";
                $scope.selectedFacID = facilityId;
                var url = 'api/v2/treeview/facility/' + facilityId.data.id + '/treenodes?link=ap';
                $http.get(url)
                    .then(function (response) {
                        if (response.data) {
                            $scope.basestations = response.data;
                        }
                    });
            } else {
                // If facility is not available
                $scope.basestations = "";
            }
        }

        // Selected Regions using Checkbox
        $scope.selectedReg = function (selectedRegion) {
            if (selectedRegion.checked) {
                selectedRegion.checked = false;
            } else {
                selectedRegion.checked = true;
            }
        }

        // Selected Locations using Checkbox
        $scope.selectedLocation = function (selectedLocation) {
            if (selectedLocation.checked) {
                selectedLocation.checked = false;
            } else {
                selectedLocation.checked = true;
            }
        }

        // Selected Facilities using Checkbox
        $scope.selectedFac = function (selectedFacility) {
            if (selectedFacility.checked) {
                selectedFacility.checked = false;
            } else {
                selectedFacility.checked = true;
            }
        }

        // Selected Base Stations using Checkbox
        $scope.selectedBst = function (selectedBasestation) {
            if (selectedBasestation.checked) {
                selectedBasestation.checked = false;
            } else {
                selectedBasestation.checked = true;
            }
        }

        // Scope Apply Function or Change Scope Function
        $scope.apply = function () {
            $scope.cpe_bh_config.options.title.display = false;
            $scope.cpe_ptmp_config.options.title.display = false;
            $scope.cpe_ptp_config.options.title.display = false;


            if ($scope.div_select == 'Global') {
                // If Global Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $localStorage.selectedregArray = "";
                $localStorage.selectedlocArray = "";
                $localStorage.selectedfacArray = ""
                $localStorage.selectedbseArray = "";
                $localStorage.selectedRegID = "";
                $localStorage.selectedLocID = "";
                $localStorage.selectedFacID = "";
                $localStorage.ar = "glob";
                $localStorage.facilitiesArray = null;
                $("#myModal").modal("hide"); // Close modal
                $('body').removeClass('modal-open');
                $('.modal-backdrop').remove();
                showpageloading(true); // Display loading icon
                $state.reload(); // Page State reload
                showpageloading(false); // Stop displaying loading icon
            } else if ($scope.div_select == 'Facility') {
                // If Facility Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $scope.facilities = $scope.facilities;
                $localStorage.selectedfacArray = $scope.facilities;
                $localStorage.selectedRegID = $scope.selectedRegID
                $localStorage.selectedLocID = $scope.selectedLocID;
                $localStorage.selectedregArray = "";
                $localStorage.selectedlocArray = "";
                $localStorage.selectedbseArray = "";
                $localStorage.selectedFacID = "";
                if (!$scope.facilities) {
                    // If no facility is selected
                    //$scope.showAlert('error', 'Please Select Facilities');
                    $scope.errNotify = 'Please select facilities';
                } else {
                    // If facility is selected
                    $scope.tempArryFac = [];
                    for (var i = 0; i < $scope.facilities.length; i++) {
                        if ($scope.facilities[i].facisChecked) {
                            $scope.tempArryFac.push($scope.facilities[i].data.id);
                        }
                    }
                    if ($scope.tempArryFac.length == 0) {
                        // If no facility is selected
                        //$scope.showAlert('error', 'Please Select Facilities');
                        $scope.errNotify = 'Please select facilities';
                    } else {
                        // If facility is selected
                        $localStorage.facilitiesArray = $scope.tempArryFac;
                        $localStorage.ar = "fac";
                        $("#myModal").modal("hide");
                        $('body').removeClass('modal-open');
                        $('.modal-backdrop').remove();
                        showpageloading(true);
                        $state.reload();
                        showpageloading(false);
                    }
                }
            } else if ($scope.div_select == "Location") {
                // If Location Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $localStorage.selectedlocArray = $scope.locations;
                $localStorage.selectedRegID = $scope.selectedRegID;
                $localStorage.selectedregArray = "";
                $localStorage.selectedfacArray = ""
                $localStorage.selectedbseArray = "";
                $localStorage.selectedLocID = "";
                $localStorage.selectedFacID = "";
                $scope.locations = $scope.locations;
                if (!$scope.locations) {
                    // If no location is selected
                    $scope.errNotify = "Please select locations";
                } else {
                    // If location is selected
                    $scope.tempArrLoc = [];
                    for (var i = 0; i < $scope.locations.length; i++) {
                        if ($scope.locations[i].locisChecked) {
                            $scope.tempArrLoc.push($scope.locations[i].data.id);
                        }
                    }
                    if ($scope.tempArrLoc.length == 0) {
                        // If no location is selected
                        $scope.errNotify = "Please select locations";
                    } else {
                        // If location is selected
                        $localStorage.facilitiesArray = $scope.tempArrLoc;
                        $localStorage.ar = "loc";
                        $("#myModal").modal("hide");
                        $('body').removeClass('modal-open');
                        $('.modal-backdrop').remove();
                        showpageloading(true);
                        $state.reload();
                        showpageloading(false);
                    }
                }
            } else if ($scope.div_select == 'Region') {
                // If Region Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $localStorage.selectedregArray = $scope.regions;
                $localStorage.selectedlocArray = "";
                $localStorage.selectedfacArray = ""
                $localStorage.selectedbseArray = "";
                $localStorage.selectedRegID = "";
                $localStorage.selectedLocID = "";
                $localStorage.selectedFacID = "";
                $scope.regions = $scope.regions;
                if (!$scope.regions) {
                    // If no region is selected
                    $scope.errNotify = "Please select regions";
                } else {
                    // If region is selected
                    $scope.tempArryReg = [];
                    for (var i = 0; i < $scope.regions.length; i++) {
                        if ($scope.regions[i].regisChecked) {
                            $scope.tempArryReg.push($scope.regions[i].data.id);
                        }
                    }
                    if ($scope.tempArryReg.length == 0) {
                        // If no region is selected
                        $scope.errNotify = "Please select regions";
                    } else {
                        // If region is selected
                        $localStorage.facilitiesArray = $scope.tempArryReg;
                        $localStorage.ar = "reg";
                        $("#myModal").modal("hide");
                        $('body').removeClass('modal-open');
                        $('.modal-backdrop').remove();
                        $state.reload();
                    }
                }
            } else if ($scope.div_select == 'Basestation') {
                // If Base Station Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $scope.basestations = $scope.basestations;
                $localStorage.selectedbseArray = $scope.basestations;
                $localStorage.selectedRegID = $scope.selectedRegID;
                $localStorage.selectedLocID = $scope.selectedLocID;
                $localStorage.selectedFacID = $scope.selectedFacID;
                $localStorage.selectedregArray = "";
                $localStorage.selectedlocArray = "";
                $localStorage.selectedfacArray = ""
                $scope.cpe_bh_config.options.title.display = true;
                $scope.cpe_ptmp_config.options.title.display = true;
                $scope.cpe_ptp_config.options.title.display = true;
                if (!$scope.basestations) {
                    // If no base station is selected
                    $scope.errNotify = "Please select basestations";
                } else {
                    // If base station is selected
                    $scope.tempArryBst = [];
                    for (var i = 0; i < $scope.basestations.length; i++) {
                        if ($scope.basestations[i].bstisChecked) {
                            $scope.tempArryBst.push($scope.basestations[i].data.id);
                        }
                    }
                    if ($scope.tempArryBst.length == 0) {
                        // If no base station is selected
                        $scope.errNotify = "Please select basestations";
                    } else {
                        // If base station is selected
                        $localStorage.facilitiesArray = $scope.tempArryBst;
                        $localStorage.ar = "node";
                        $("#myModal").modal("hide");
                        $('body').removeClass('modal-open');
                        $('.modal-backdrop').remove();
                        $state.reload();
                    }
                }

            }
        }
        // Scope End
    }
]);
