﻿﻿dashboard.controller("ManagementController", ['$rootScope', '$scope', '$mdDialog', '$http', '$state', '$window', '$location', 'dashboardService', 'Flash', '$localStorage', '$interval', '$timeout',
    function ($rootScope, $scope, $mdDialog, $http, $state, $window, $location, dashboardService, Flash, $localStorage, $interval, $timeout) {
        // Default Variables    
        var vm = this;
        $scope.limit = 10;
        $scope.statusTimer = null;

        $scope.showsystemIP = $localStorage.showtopology; //'ip';

        var su4UpURL = "images/ap_nms_icon.png";
        var su4DownURL = "images/ap_nms_icon_disable.png";

        var apUpIcon = "images/su4_nms_icon.png";
        var apDownIcon = "images/su4_nms_icon_disable.png";

        var serip = "System-Name";

        var network = null;
        $scope.viewingNetwork = false;

        $scope.networkLoaded = false;

        $scope.showSerial = false;
        $scope.tabIndex = 2;

        $rootScope.iparray = [];
        //$rootScope.iparray = $localStorage.iparray;

        // Counters Variables
        $scope.vm.nodes = [];
        $scope.vm.totalNodesCount = 0;
        $scope.vm.activeNodesCount = 0;

        // Discovery Variables
        $scope.vm.byNetMask = false;
        $scope.rangeText = '';
        $scope.rangeIPLabel = '';
        $scope.rangeplaceholder = '';

        // Profile variables
        $scope.useConfiguredAddress = false;
        $scope.vm.serveraddress = '';
        $scope.vm.hostpwd = '';
        $scope.currentSelectedFacility = 0;
        $scope.selectedLocation = null;

        $scope.mytree = {
            currentNode: {}
        }

        // storing devices in map

        $scope.markerHashMap = new Map();
        $scope.verticeHashMap = new Map();

        // Move Device Modal Variables
        $scope.optregions = [];
        $scope.optlocations = [];
        $scope.optFacilities = [];
        $scope.optregionSelected;
        $scope.optlocationSelected;
        $scope.optFacilitySelected;
        $scope.treedata = null;
        $scope.positionChangedMarker = null;


        // Radio Type Options in Tree View
        $scope.diviceTypeOpt = ["All", "AP", "SU"];
        if ($localStorage.selectedradiomode == 'all') {
            $scope.deviceType = $scope.diviceTypeOpt[0];
        } else if ($localStorage.selectedradiomode == 'ap') {
            $scope.deviceType = $scope.diviceTypeOpt[1];
        } else {
            $scope.deviceType = $scope.diviceTypeOpt[2];
        }

        // Directive functions
        $("button").click(function () {
            $("button").removeClass("active");
            $(this).addClass("active");
        });


        var network = null;
        // Init Controller call
        $scope.init = function () {
            if ($localStorage.cachedTree != null) {
                $scope.treedata = $localStorage.cachedTree;
            } else if ($localStorage.isExpand) {
                $localStorage.isExpand = false;
                $scope.manageState();
            } else {
                $('#mydiv').show();
                $scope.buildTree(); // To generate tree
                $('#mydiv').hide();
            }
            // var res = findNode(2,$scope.treedata,true);
            $scope.prepareMap();
            if ($localStorage.cachedMap != null) {
                $scope.markers = [];
            }
            /*else {

                           }*/
            if ($localStorage.cachedCurrentNode != null) {
                $scope.mytree.currentNode = $localStorage.cachedCurrentNode;
                $scope.markers = [];
            }
            $scope.loadAllNodes();
            $scope.loadManagementNodes();
            $scope.loadActiveNodesCount();
            $scope.startLinkTimer();
            // Create default map
            $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden"; // Set map container by default
        }

        $scope.manageState = function () {
            var treeObj = JSON.parse(localStorage.getItem('state_demo'));
            console.log(treeObj, "treeObj");
            if (treeObj.state.core.open) {
                console.log("$localStorage.lastSelected", $localStorage.lastSelected);
                if ($localStorage.lastSelected) {
                    var lastSelected = $localStorage.lastSelected.indexOf("#");
                    if (lastSelected) {
                        var lastSelectedNewObj = $localStorage.lastSelected.slice(0, lastSelected);
                        lastSelectedNewObj = lastSelectedNewObj.reverse();
                        if (lastSelectedNewObj) {
                            treeObj.state.core.open = [];
                            var latestnodeId = lastSelectedNewObj[lastSelectedNewObj.length - 1];
                            //treeObj.state.core.selected = [latestnodeId];
                            treeObj.state.core.open = lastSelectedNewObj;
                            console.log("newTree", treeObj.state.core.open);
                            localStorage.setItem('state_demo', JSON.stringify(treeObj));
                        }
                    }
                }
            }
            $scope.buildTree();
        }



        function findNode1(id, currentNode) {
            if (angular.isObject(currentNode)) {
                console.log("it is a object");
            }
            console.log(currentNode[0].data.id)
            console.log(currentNode[text])
            console.log(currentNode.data)
        }

        $scope.startLinkTimer = function () {
            $scope.statusTimer = $interval(function () {
                // $scope.deviceStatusGetter();
            }, 20000);
        }

        $scope.$on('$destroy', function () {
            $scope.stopTimer();
            //nodesSource.close();
        });

        $scope.stopTimer = function () {
            if (angular.isDefined($scope.statusTimer)) {

                $interval.cancel($scope.statusTimer);
            }
        }

        $scope.showactive = function () {
            $('#myTab a:last').tab('show');
            //$('#myTab a:last').tab('show');
        }

        $scope.closenodeview = function (index) {
            $rootScope.iparray.splice(index, 1);
            $localStorage.iparray = $rootScope.iparray;
            $scope.linkviewvisibility=true;
            $timeout(function () {
                $('#myTab a:first').tab('show');
                if ($scope.selectedlevel == 'node') {
                    $scope.mapchartshow = true;
                    $scope.chartGrid = true;
                    deviceData();
                    $scope.mapDynamicHeight = "width:100%;height:60vh;position:relative;overflow:hidden";
                }
            }, 1000);
        }

        $scope.shownodeview = function (nodeId) {
            //$scope.mapActive = "false";
            //$scope.topoActive = "false";
            //$scope.nodeviewActive = "true";
            $scope.linkviewvisibility=false;
            $state.params.nodeId = nodeId;
            $localStorage.nodeId = $state.params.nodeId;
            $scope.mapchartshow = false;
            $scope.chartGrid = false;
            $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
            $scope.stopDeviceTimer();
            $scope.stopNetworkViewTimer();
        }

        // Load all Regions in Tree view
        $scope.loadTreeRegions = function () {
            return $http.get('api/v2/treeview/regions', {
                //showdiv: false
            })
                .then(function (response) {
                    if (response.data) {
                        return response.data;
                    }
                });
        }

        // Load locations based on region in Tree View
        $scope.loadTreeLocations = function (regionId) {
            return $http.get('api/v2/treeview/regions/' + regionId + '/locations', {
                //showdiv: false
            })
                .then(function (response) {
                    if (response.data) {
                        return response.data;
                    }
                });
        }

        $scope.loadLocationLinks = function (locationId) {
            return $http.get('api/v2/treeview/locations/' + locationId + '/links?show=' + $scope.nodesFilter, {
                //showdiv: false
            })
                .then(function (response) {

                    if (response.data) {
                        return response.data;
                    }
                });
        }

        // Load Facilities based on location in Tree View
        $scope.loadTreeFacilities = function (locationId) {
            $scope.locationId = locationId;
            if (!$scope.nodesFilter) {
                $scope.nodesFilter = "all"
            }
            return $http.get('api/v2/treeview/locations/' + locationId + '/facilitiesn?show=' + $scope.nodesFilter, {
                //showdiv: false
            })
                .then(function (response) {

                    if (response.data) {
                        return response.data;
                    }
                });
        }

        // Load Nodes based on facility in Tree View
        $scope.loadTreeNodes = function (location) {
            return $http.get('api/v2/treeview/location/' + location + '/nodes', {
                //showdiv: false
            })
                .then(function (response) {
                    if (response.data) {
                        return response.data;
                    }
                });
        }



        var locales = {
            en: {
                edit: 'Edit',
                del: 'Delete selected',
                back: 'Back',
                addNode: 'Add Node',
                addEdge: 'Add Link',
                editNode: 'Edit Node',
                editEdge: 'Edit Edge',
                addDescription: 'Click in an empty space to place a new node.',
                edgeDescription: 'Click on a node and drag the edge to another node to connect them.',
                editEdgeDescription: 'Click on the control points and drag them to a node to connect to it.',
                createEdgeError: 'Cannot link edges to a cluster.',
                deleteClusterError: 'Clusters cannot be deleted.',
                editClusterError: 'Clusters cannot be edited.'
            }
        }

        $scope.loadTopology = function (location) {
            if ($scope.viewingNetwork) {
                destroy();
                var url = 'api/v2/treeview/topology/' + location;
                $scope.serip = "System-Name";
                if ($scope.showSerial) {
                    url = 'api/v2/treeview/topology/' + location + '?ser=1';
                    $scope.serip = "IP Address";
                }
                $http.get(url, {
                    //showdiv: false
                })
                    .then(function (response) {
                        if (response.data) {
                            for (var i = 0; i < response.data.nodes.length; i++) {
                                if (response.data.nodes[i].x == 0 || response.data.nodes[i].y == 0) {
                                    delete response.data.nodes[i]['x'];
                                    delete response.data.nodes[i]['y'];
                                }
                            }
                            $scope.topnodes = new vis.DataSet(response.data.nodes);
                            $scope.topedges = new vis.DataSet(response.data.edges);
                            draw();
                            if (network != null) {
                                network.fit();
                            }
                        }
                    });
            }
        }

        $scope.showNetwork = function () {
            console.log("clicked Network view");
            $scope.mapchartshow = false;
            $scope.viewingNetwork = true;
            $scope.linkviewvisibility=false;
            //$scope.mapActive = "false";
            //$scope.topoActive = "true";
            //$scope.nodeviewActive = "false";            
            $scope.chartGrid = false;
            $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
            $scope.stopDeviceTimer();
            if ($scope.selectedLocation != null) {
                networkViewStatus();
                  setTimeout(function () {
                      $scope.loadTopology($scope.selectedLocation);
                 }, 1000);
            }
        }

        function destroy() {
            if (network !== null) {
                network.destroy();
                network = null;
                $scope.networkLoaded = false;
            }
        }

        function networkViewStatus() {
            $scope.networkViewTimer = $interval(function () {
                $scope.shownetworkstatus()
            }, $scope.networkstatusTimer);
        }

        $scope.stopNetworkViewTimer = function () {
            if (angular.isDefined($scope.networkViewTimer)) {
                $interval.cancel($scope.networkViewTimer);
                delete $scope.networkViewTimer;
            }
        }

        $scope.mapchartshow = true;
        $scope.linkviewvisibility=true;
        // Load Nodes based on facility in Tree View
        $scope.onMapClick = function () {
            /*console.log("on map click");
            var octl = angular.element('home-tab');
            octl.tab('show')*/
            // $scope.mapActive = "true";
            // $scope.topoActive = "false";
            // $scope.nodeviewActive = "false";
            $scope.linkviewvisibility=true;
            $scope.mapchartshow = true;
            $scope.viewingNetwork = false;
            $scope.stopNetworkViewTimer();
            if ($scope.selectedlevel == 'node') {
                $scope.chartGrid = true;
                $scope.mapDynamicHeight = "width:100%;height:60vh;position:relative;overflow:hidden";
            }

            var zoomlevel = $scope.map.getZoom();
            if (zoomlevel === 1 || zoomlevel === 0) {
                $scope.map.setZoom(10);
            }
        }

        $scope.shownetworkstatus = function () {
            if ($scope.selectedLocation != null) {
                $http.get('api/v2/treeview/topostatus/' + $scope.selectedLocation, {
                    showdiv: false
                })
                    .then(function (response) {
                        if (response.data) {
                            console.log("data");
                            $scope.topedges;
                            for (var i = 0; i < response.data.nodes.length; i++) {
                                $scope.topnodes.update({
                                    id: response.data.nodes[i].id,
                                    image: response.data.nodes[i].image
                                })
                            }
                            for (var i = 0; i < response.data.edges.length; i++) {
                                $scope.topedges.update({
                                    id: response.data.edges[i].id,
                                    color: response.data.edges[i].color
                                })
                            }
                        }
                    });
            }
        }

        function draw() {
            var container = document.getElementById('mynetwork');
            var GRAY = 'gray';
            var locales = {
                ornmslocale: {
                    edit: 'Edit',
                    del: 'Delete selected',
                    back: 'Back',
                    addNode: 'Store Position',
                    addEdge: 'Add Link',
                    editNode: 'Edit Node',
                    editEdge: 'Edit Edge',
                    addDescription: 'Click in an empty space to place a new node.',
                    edgeDescription: 'Click on a node and drag the edge to another node to connect them.',
                    editEdgeDescription: 'Click on the control points and drag them to a node to connect to it.',
                    createEdgeError: 'Cannot link edges to a cluster.',
                    deleteClusterError: 'Clusters cannot be deleted.',
                    editClusterError: 'Clusters cannot be edited.'
                }
            }

            // provide the data in the vis format
            var data = {
                nodes: $scope.topnodes,
                edges: $scope.topedges
            };
            var options = {
                width: '100%',
                height: '100%',
                locales: locales,
                locale: 'ornmslocale',
                edges: {
                    color: GRAY,
                    width: 2,
                    smooth: false
                },
                nodes: {
                    scaling: {
                        min: 8,
                        max: 32
                    }
                },
                physics: {
                    "enabled": false,
                    barnesHut: {
                        gravitationalConstant: -30000
                    },
                    stabilization: {
                        iterations: 2500
                    }
                },
                /*layout: {
                    hierarchical: {
                        direction: 'LR'
                    }},*/
                groups: {
                    'switch': {
                        shape: 'image',
                        image: './images/topswitch.png'
                    },
                    'topap': {
                        shape: 'image',
                        image: './images/topap.png'
                    },
                    'topsta': {
                        shape: 'image',
                        image: './images/topsta.png'
                    }
                },
                manipulation: {
                    addNode: false,
                    deleteNode: false,
                    addEdge: function (data, callback) {
                        if (data.from == data.to) { } else {
                            var confirm = $scope.saveconfirm("Do you wish to create link?");
                            $mdDialog.show(confirm).then(function () {
                                $scope.onAddLink(data, callback);
                                console.log('');
                            });
                        }
                    },
                    deleteEdge: function (data, callback) {
                        if (data.edges.length == 1) {
                            var confirm = $scope.saveconfirm("Do you wish to delete link?");
                            $mdDialog.show(confirm).then(function () {
                                var item = $scope.topedges.get(data.edges[0]);
                                $scope.ondelLink(item, callback);
                            });

                        }
                    }
                }
            };
            network = new vis.Network(container, data, options);
            $scope.networkLoaded = true;
            network.on("doubleClick", function (params) {
                if (params.nodes.length > 0) {
                    var item = $scope.topnodes.get(params.nodes[0]);
                    if (item) {
                        if ("Switch" == item.type) {
                            $state.go('app.swnodeView', {
                                "nodeId": params.nodes[0],
                                "lastView": "app.topology"
                            });
                        } else {
                            $state.go('app.nodeView', {
                                "nodeId": params.nodes[0],
                                "lastView": "app.topology"
                            });
                        }
                    }
                    //
                }

                //document.getElementById('eventSpan').innerHTML = '<h2>doubleClick event:</h2>' + JSON.stringify(params, null, 4);
            });

            network.on("dragEnd", function (params) {
                params.event = "[original event]";
                // document.getElementById('eventSpan').innerHTML = '<h2>dragEnd event:</h2>' + JSON.stringify(params, null, 4);
                console.log('dragEnd Event:', params);
                //console.log('dragEnd event, getNodeAt returns: ' + this.getNodeAt(params.pointer.DOM));
                //var positions = network.getPosition(params.nodes[0]);
            });
  if (network != null) {
                                network.fit();
                            }
//           window.onresize = function() {
//             setInterval(function() {
//               network.fit();
//             }, 2000);
//           };

            /* network.on("oncontext", function(params) {
              params.event.preventDefault();

              console.log();
             });*/

        }


        $scope.mapActive = "true";
        $scope.topoActive = "false";
        $scope.nodeviewActive = "false";
        $scope.storeNodePositions = function () {
            network.storePositions();
            var items = $scope.topnodes.get({
                fields: ['id', 'x', 'y']

            });
            $scope.storePositions(items);
        }

        $scope.showSerialFun = function () {
            $scope.showNetwork();
            /* network.storePositions();
             var items = $scope.topnodes.get({
               fields: ['id', 'x','y']

             });
             $scope.storePositions(items);*/
        }



        $scope.onAddLink = function (data, callback) {
            $http({
                method: 'POST',
                url: 'api/v2/treeview/addlink/' + data.from + '/' + data.to
            }).success(function () {
                callback(data);
                $scope.showAlert('Success', 'Link Successfully added');
            }).error(function (msg) {
                $scope.showAlert('Error', 'Failed to add link due to' + msg);
                callback(null);
            });
        }

        $scope.ondelLink = function (data, callback) {
            $http({
                method: 'POST',
                url: 'api/v2/treeview/dellink/' + data.from + "/" + data.to
            }).success(function () {
                callback(data);
                $scope.showNetwork();
                $scope.showAlert('Success', 'Link Successfully removed');
            }).error(function (msg) {
                $scope.showAlert('Error', 'Failed to remove link due to' + msg);
                callback(null);
            });
        }

        $scope.storePositions = function (data) {
            $http({
                method: 'POST',
                url: 'api/v2/treeview/updatepositions/',
                headers: {
                    'Content-Type': 'application/json'
                },
                data: data
            }).success(function () {
                $scope.showAlert('Success', 'Saved successfully.');
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating Data: ' + msg);
            });
        }

        // Load Nodes based on facility in Tree View
        $scope.onToplogyClick = function (location) {
            console.log("on topologuy click");
            var octl = angular.element('profile-tab');
            octl.tab('show')
            $scope.mapActive = "false";
            $scope.topoActive = "true";
        }

        // Node Action methods
        $scope.actionNode = function (action_type) {
            if (action_type === 'rescan') {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodes/rescanNode',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: $scope.nodeID
                }).success(function () {
                    $scope.showAlert('Success', 'Rescanning of the node initiated');
                }).error(function (msg) {
                    $scope.showAlert('Error', 'Failed to resan the node: ' + msg);
                });
            } else if (action_type === "commit") {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodelinks/commit?nodeId=' + $scope.nodeID,
                    headers: {
                        'Content-Type': 'application/json'
                    }
                }).success(function () {
                    $scope.showAlert('Success', 'Commit of the node initiated');
                }).error(function (msg) {
                    $scope.showAlert('Error', 'Failed to commit the node: ' + msg);
                });
            } else if (action_type === "reboot") {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodelinks/reboot?nodeId=' + $scope.nodeID,
                    headers: {
                        'Content-Type': 'application/json'
                    }
                }).success(function () {
                    $scope.showAlert('Success', 'Reboot of the node initiated');
                }).error(function (msg) {
                    $scope.showAlert('Error', 'Failed to reboot the node: ' + msg);
                });
            }
        }

        // Right Click on SU in Tree View
        $scope.sta = [ //node
            ['Rescan', function ($itemScope) {
                console.log("node", $itemScope);
                $scope.rescanNodeObj = $itemScope.node;
                console.log('STA' + $itemScope.node.text + ' ' + +$itemScope.node.data.id + ' ' + $itemScope.node.data.type);
            }],
            ['Move to facility', function ($itemScope) {
                $scope.rescanNodeObj = $itemScope.node;
                console.log('STA' + $itemScope.node.text + ' ' + +$itemScope.node.data.id + ' ' + $itemScope.node.data.type);
                $scope.showAdvanced();
            }],
            ['NodeView', function ($itemScope) {
                $scope.nodeviewFun($itemScope.node);
                //console.log("node",$itemScope.node.text);
            }]
        ];

        $scope.tmarc = [
            ['Rescan', function ($itemScope) {
                $scope.rescanNodeObj = $itemScope.node;
                console.log('STA' + $itemScope.node.text + ' ' + +$itemScope.node.data.id + ' ' + $itemScope.node.data.type);
            }],
            null, ['Move to facility', function ($itemScope) {
                $scope.rescanNodeObj = $itemScope.node;
                console.log('STA' + $itemScope.node.text + ' ' + +$itemScope.node.data.id + ' ' + $itemScope.node.data.type);
                $scope.showAdvanced();
            }]
        ];

        // Right Click on AP in Tree View
        $scope.ap = [ //basestation
            ['Rescan', function ($itemScope) {
                $scope.rescanNodeObj = $itemScope.node;
                console.log('STA' + $itemScope.node.text + ' ' + +$itemScope.node.data.id + ' ' + $itemScope.node.data.type);
            }],
            null, ['Move to facility', function ($itemScope) {
                $scope.rescanNodeObj = $itemScope.node;
                console.log('STA' + $itemScope.node.text + ' ' + +$itemScope.node.data.id + ' ' + $itemScope.node.data.type);
                $scope.showAdvanced();
            }],
            null, ['NodeView', function ($itemScope) {
                $scope.nodeviewFun($itemScope.node);
                // console.log("basestation",$itemScope.node.text);
            }]
        ];

        $rootScope.$on("Calltabname", function (event, args) {
            $scope.nodeviewFun(args.tabobj);
            //$rootScope.$emit("CallinitGraph",{});
        })

        localStorage.setItem("modetype",'');
        $scope.nodeviewFun = function (selectedNode) {
        $scope.linkviewvisibility=false;
              localStorage.setItem("modetype",selectedNode.data.mode);
              if(selectedNode.data.mode=='tmarc'){
               localStorage.setItem('selectednodetype','switch');
               }else{
               localStorage.setItem('selectednodetype','');
               }
            $scope.chartGrid = false;
            $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
            $scope.mapchartshow = false;
            $scope.stopDeviceTimer();
            var nodeselect = false;
            $scope.previousslectednode = $("#container").jstree("get_selected", true);
            //var selectednodemenu= $('#container').jstree(true).get_node('j-n'+selectedNode.data.id);
            $("#container").jstree("select_node", 'j-n' + selectedNode.data.id);
            if( $scope.previousslectednode.length>0){
                if(selectedNode.id!=$scope.previousslectednode[0].id){
                    $("#container").jstree("deselect_node", $scope.previousslectednode[0].id);
                }
            }

            // if(selectednodemenu!=null){
            //     var selectednodemenuparent= $('#container').jstree(true).get_node(selectednodemenu.parent);
            //     if(selectednodemenuparent!=null){
            //         selectednodemenuparent.state.selected=false;
            //         selectednodemenu.state.selected=true;
            //     }                
            //     console.log("selectednodemenu",selectednodemenu)
            // }
            if ($rootScope.iparray.length == 1) {
                $rootScope.iparray.splice(0, 1);
                $localStorage.iparray = $rootScope.iparray;

                var obj = {
                    showtabname: selectedNode.text,
                    ip: selectedNode.text,
                    system: selectedNode.data.systemname,
                    nodeId: selectedNode.data.id,
                    data: selectedNode.data,
                    showtab: false,
                    modetype:selectedNode.data.mode
                };
                if ($rootScope.iparray.length > 0) {
                    for (var k = 0; k < $rootScope.iparray.length; k++) {
                        if ($rootScope.iparray[k].nodeId == obj.nodeId) {
                            nodeselect = true;
                        }
                    }
                }
                if (!nodeselect) {
                    $rootScope.iparray.push(obj);
                }
                if ($scope.showsystemIP == 'ip') {
                    if ($rootScope.iparray.length > 0) {
                        for (var k = 0; k < $rootScope.iparray.length; k++) {
                            $rootScope.iparray[k].showtabname = $rootScope.iparray[k].ip;
                        }
                    }
                } else {
                    if ($rootScope.iparray.length > 0) {
                        for (var k = 0; k < $rootScope.iparray.length; k++) {
                            $rootScope.iparray[k].showtabname = $rootScope.iparray[k].system;
                        }
                    }
                }
                if (!nodeselect) {
                    $localStorage.iparray = $rootScope.iparray;
                    $scope.mapActive = "false";
                    $scope.topoActive = "false";
                    $scope.nodeviewActive = "true";
                    $state.params.nodeId = obj.nodeId;
                    $localStorage.nodeId = $state.params.nodeId;

                    $timeout(function () {
                        $("#nodeview-" + obj.nodeId).ready(function () {
                            $scope.showactive();
                        })
                    });
                }
            } else {

                var obj = {
                    showtabname: selectedNode.text,
                    ip: selectedNode.text,
                    system: selectedNode.data.systemname,
                    nodeId: selectedNode.data.id,
                    data: selectedNode.data,
                    showtab: false,
                      modetype:selectedNode.data.mode
                };
                if ($rootScope.iparray.length > 0) {
                    for (var k = 0; k < $rootScope.iparray.length; k++) {
                        if ($rootScope.iparray[k].nodeId == obj.nodeId) {
                            nodeselect = true;
                        }
                    }
                }
                if (!nodeselect) {
                    $rootScope.iparray.push(obj);
                }
                if ($scope.showsystemIP == 'ip') {
                    if ($rootScope.iparray.length > 0) {
                        for (var k = 0; k < $rootScope.iparray.length; k++) {
                            $rootScope.iparray[k].showtabname = $rootScope.iparray[k].ip;
                        }
                    }
                } else {
                    if ($rootScope.iparray.length > 0) {
                        for (var k = 0; k < $rootScope.iparray.length; k++) {
                            $rootScope.iparray[k].showtabname = $rootScope.iparray[k].system;
                        }
                    }
                }
                if (!nodeselect) {
                    $localStorage.iparray = $rootScope.iparray;
                    $scope.mapActive = "false";
                    $scope.topoActive = "false";
                    $scope.nodeviewActive = "true";
                    $state.params.nodeId = obj.nodeId;
                    $localStorage.nodeId = $state.params.nodeId;
                    $timeout(function () {
                        $("#nodeview-" + obj.nodeId).ready(function () {
                            $scope.showactive();
                        })
                    });
                }
            }
        };

        // Load Regions for Move Device Modal
        $scope.showAdvanced = function () {
            $scope.loadTreeRegions().then(function (data) {
                $scope.optregions = data;
                $("#successMdl").modal("show");
            });
        };
        $scope.searchText = '';
        $scope.clearSearch = function () {
            $scope.searchText = '';
            $("#container").jstree(true).clear_search();
        }

        $scope.searchNode = function (searchVal) {
            $("#container").jstree(true).search($("#searchtree").val());
            if ($scope.showsystemIP == 'ip') {
                var url = '/ornms/api/v2/nodes/search?_s=assetRecord.serialNumber==' + $scope.searchText + ',label==' + $scope.searchText;
            } else {
                var url = '/ornms/api/v2/nodes/search?_s=sysName==' + $scope.searchText + ',label==' + $scope.searchText;
            }
            //var url = '/ornms/api/v2/nodes?_s=assetRecord.serialNumber==' + $scope.searchText + ',label==' + $scope.searchText
            $http.get(url, {
                //showdiv: false
            })
                .then(function (response) {
                    if (response.data) {
                        if (response.data.totalCount > 0) {
                            for (var i = 0; i < response.data.nodes.length; i++) {
                                $scope.setMapOnSingleMarkerOnSearch(response.data.nodes[i]);
                            }
                        }

                        //Highlight searched IP Address
                        // var allTableCells = document.getElementsByClassName('highlightText');
                        // for (var i = 0, max = allTableCells.length; i < max; i++) {
                        //     var node = allTableCells[i];
                        //     var currentText = node.innerText;
                        //     node.classList.remove('selected');
                        //     if (currentText === searchVal) {
                        //         node.classList.add('selected');
                        //     }
                        // }
                    } else {
                        $scope.showAlert('IP Address or Serial Number not found');
                    }
                });
        };

        // On Region Change, Load Locations of selected region
        $scope.showOptionLoc = function (region) {
            $scope.loadTreeLocations(region.data.id).then(function (data) {
                $scope.optlocations = data;
            });
        };

        $scope.showOptionFacility = function (loc) {
            $scope.loadTreeFacilities(loc.data.id).then(function (data) {
                $scope.optFacilities = data;
            });
        };

        // Save changes of Move device Modal
        $scope.savelocation = function (optrs) {
            console.log($scope.rescanNodeObj);
            console.log(optrs)

            $http({
                method: 'POST',
                url: 'api/v2/treeview/movenodetofacility/' + optrs.data.id + '/' + $scope.rescanNodeObj.data.id,
            }).success(function () {
                $scope.treedata;
                var movedNode = {};


                // optrs.children.push($scope.rescanNodeObj.childobj);
                // $scope.rescanNodeObj = {};

                // $('#container').jstree("refresh");

                //  $('#container').empty().load($window.location.href + '#container');
                // $('#container').jstree(true).redraw(true);
                // $route.reload();
                // var currentPageTemplate = $location.path();
                // $templateCache.remove(currentPageTemplate);
                // $('#container').jstree({plugins: ["state"]});

                // remove from the tree
                // for (var i = 0; i < $scope.treedata[0].children.length; i++) {
                //     var regions = $scope.treedata[0].children[i];
                //     if (regions.data.type == 'region') {
                //         for (var r = 0; r < regions.children.length; r++) {
                //             var locations = regions.children[r];
                //             if (locations.data.type == 'location') {
                //                 for (var l = 0; l < locations.children.length; l++) {
                //                     var fac = locations.children[l];
                //                     for (var f = 0; f < fac.children.length; f++) {
                //                         var aps = fac.children[f];
                //                         if (aps.data.id == $scope.rescanNodeObj.data.id) {
                //                             $scope.treedata[0].children[i].children[r].children[l].children.splice(f, 1);
                //                             movedNode = aps;
                //                             //console.log('remove ap' + est.data);
                //                         } else {
                //                             for (s = 0; s < aps.children.length; s++) {
                //                                 if ($scope.rescanNodeObj.data.id == aps.children[s].data.id) {
                //                                     var rem = aps.children[s];
                //                                     movedNode = rem;
                //                                     $scope.treedata[0].children[i].children[r].children[l].children[f].children.splice(s, 1);
                //                                     console.log('remove su ' + rem);
                //                                 }
                //                             }

                //                         }
                //                     } // facilities children loop
                //                 } // location children loop

                //             } // location check if
                //         } // region children loop
                //     } // region if close
                // }

                // // add to tree
                // for (var i = 0; i < $scope.treedata[0].children.length; i++) {
                //     var regions = $scope.treedata[0].children[i];
                //     if (regions.data.type == 'region') {
                //         for (var r = 0; r < regions.children.length; r++) {
                //             var locations = regions.children[r];
                //             if (locations.data.type == 'location') {
                //                 for (var l = 0; l < locations.children.length; l++) {
                //                     var fac = locations.children[l];
                //                     if (fac.data.id == optrs.data.id) {
                //                         $scope.treedata[0].children[i].children[r].children[l].children.push(movedNode);
                //                     }
                //                 } // location children loop

                //             } // location check if
                //         } // region children loop
                //     } // region if close
                // } // root close

                $scope.optregionSelected = '';
                $scope.optlocationSelected = '';
                //var confirm = $scope.showAlert('success', 'The selected device has been moved selected facility.');
                var confirm = $scope.saveconfirmfacility("The selected device has been moved selected facility.");
                $mdDialog.show(confirm).then(function () {
                    // setTimeout(function () { $window.location.reload(true); }, 10);
                    $scope.maprefresh = false;
                    $scope.slectednode = $("#container").jstree("get_selected", true);
                    if ($scope.slectednode.length > 0) {
                        $scope.slectednode[0].state.opened = false;
                        console.log("selected node", $scope.slectednode);
                    }
                    $('#container').jstree(true).refresh();
                    // setTimeout(function () {
                    //     $('#container').jstree(true).open_node($scope.slectednode[0].id);
                    // }, 500);

                    // $('#container').jstree(true).refresh_node($('#container').jstree(true).get_node('j'+optrs.data.id).parent);
                });
            }).error(function (msg) {
                $scope.showAlert('error', 'Failed to move device to facility. ' + msg);
            });
            $scope.mytree.currentNode;
            $scope.optregionSelected = '';
            $scope.optlocationSelected = '';
            $("#successMdl").modal("hide");
        }


        // Google Map Start
        // Map Variables
        $scope.map = null;
        $scope.markers = [];
        $scope.linkPolygons = [];
        $scope.linkPolygon;
        $scope.rescanNodeObj = {};
        // var infoWindow = new google.maps.InfoWindow(); // Not needed here

        // Prepare Map
        $scope.prepareMap = function () {
            $scope.systemOnline = $window.navigator.onLine; // Check to see if system is connected to network
            if ($scope.systemOnline) {
                $scope.infoWindow = new google.maps.InfoWindow();
                $scope.bounds = new google.maps.LatLngBounds();

                var styledMapType = new google.maps.StyledMapType(
                    [{
                        "featureType": "administrative",
                        "elementType": "geometry",
                        "stylers": [{
                            "visibility": "off"
                        }]
                    },
                    {
                        "featureType": "poi",
                        "stylers": [{
                            "visibility": "off"
                        }]
                    },
                    {
                        "featureType": "road",
                        "elementType": "labels.icon",
                        "stylers": [{
                            "visibility": "on"
                        }]
                    },
                    {
                        "featureType": "road.arterial",
                        "elementType": "labels",
                        "stylers": [{
                            "visibility": "on"
                        }]
                    },
                    {
                        "featureType": "road.highway",
                        "elementType": "labels",
                        "stylers": [{
                            "visibility": "on"
                        }]
                    },
                    {
                        "featureType": "road.local",
                        "stylers": [{
                            "visibility": "on"
                        }]
                    },
                    {
                        "featureType": "transit",
                        "stylers": [{
                            "visibility": "off"
                        }]
                    }
                    ], {
                    name: 'KeyWestMap'
                });

                var mapOptions = {
                    zoom: 17,
                    //            center : new google.maps.LatLng('17.4938439','78.428827'),
                    center: new google.maps.LatLng('24.555035', '-81.780629'),
                    //mapTypeControl: false,
                    streetViewControl: false
                }
                $scope.map = new google.maps.Map(document.getElementById('map'), mapOptions);
                $scope.map.mapTypes.set('KeyWestMap', styledMapType);
                $scope.map.setMapTypeId('KeyWestMap');
            } else {
                document.getElementById('map').innerHTML = "<p style='text-align:center;vertical-align:middle;display:table-cell;'> No Internet Connection </p>"
            }

            var centerControlDiv = document.createElement('div');
            var centerControl = new SaveMarkerUI(centerControlDiv, map);

            centerControlDiv.index = 1;
            $scope.map.controls[google.maps.ControlPosition.TOP_CENTER].push(centerControlDiv);
        }

        // To display nodes on map  --Not using
        $scope.showNodesOnMap = function () {
            /*if ($scope.vm.totalNodesCount > 0) {
                $scope.bounds = new google.maps.LatLngBounds();
                for (var i = 0; i < $scope.vm.totalNodesCount; i++) {
                    //$scope.addNodeOnMap($scope.vm.nodes[i]);
                }
                $scope.map.fitBounds($scope.bounds);
            }*/
        }

        $scope.deviceStatusGetter = function () {
            if ($scope.markerHashMap.size > 0) {
                //console.log($scope.markerHashMap);
                var list = [];
                for (var key of $scope.markerHashMap.keys()) {
                    list.push(key);
                }
                var url = 'api/v2/treeview/nstatus?tnodes=' + list;
                $http.get(url, {
                    //showdiv: false
                })
                    .then(function (response) {
                        if (response.data) {
                            var tmpMap = new Map();
                            var jsonArray = response.data;
                            for (var ob in jsonArray) {
                                var j = jsonArray[ob];
                                var key = j.key;
                                var value = j.status;
                                tmpMap.set(parseInt(key), value);
                                var marker = $scope.markerHashMap.get(key);
                                if (value) {
                                    if (marker.mode == 'ap') {
                                        marker.setIcon(apUpIcon);
                                    } else {
                                        marker.setIcon(su4UpURL);
                                    }

                                } else {
                                    if (marker.mode == 'ap') {
                                        marker.setIcon(apDownIcon);
                                    } else {
                                        marker.setIcon(su4DownURL);
                                    }
                                }
                                // updateStatus(key,$scope.treedata[0],value);
                            }

                            for (var ele of $scope.verticeHashMap) {
                                console.log(ele[0]);
                                var parentStatus = tmpMap.get(parseInt(ele[0]));
                                var values = ele[1];

                                if (values) {
                                    for (var i = 0; i < values.length; i++) {
                                        var color = '#000000';
                                        if (!parentStatus) {
                                            color = '#ff0000';
                                        } else {
                                            var childStatus = tmpMap.get(parseInt(values[i].id));
                                            if (!childStatus) {
                                                color = '#ff0000';
                                            }
                                        }
                                        values[i].setOptions({
                                            strokeColor: color
                                        });

                                    }
                                }
                            }



                            /*for(var v of $scope.verticeHashMap.keys()) {
                                var key = v;
                                var id = v.id;
                                var pid = v.pid;
                                if (pid != -1) {

                                }
                                var parentStatus = tmpMap.get(parseInt(key[0]));
                                var childStatus = tmpMap.get(parseInt(key[1]));
                                var verticePath = $scope.verticeHashMap.get(v);
                                if (parentStatus && childStatus) {
                                    verticePath.setOptions({strokeColor: '#000000'});
                                } else if (parentStatus && !childStatus) {
                                    verticePath.setOptions({strokeColor: '#ff0000'});
                                } else if (!parentStatus && childStatus) { // this state occurs but if sta poller is delayed to ap poller
                                    verticePath.setOptions({strokeColor: '#ff0000'});
                                } else if (!parentStatus && !childStatus) {
                                    verticePath.setOptions({strokeColor: '#ff0000'});
                                }
                                //console.log(key[0] + " " + key[1]);
                            }*/


                        }
                    });

            }
        }

        function updateStatus(id, cn, value) {
            var i,
                currentChild,
                result;
            if (id == cn.data.id && cn.data.type == 'node') {
                cn.data.active = value;
                return cn;
            } else { }

            // The node has not been found and we have no more options
            return false;
        }
        //}



        $scope.clearMarkers = function () {
            $scope.setMapOnAll(null);
        }

        // To set markers on map
        $scope.setMapOnAll = function (map) {
            for (var i = 0; i < $scope.markers.length; i++) {
                $scope.markers[i].setMap(map);
            }
            if (map == null) {
                $scope.markers = [];
            }
            //$scope.linkPolygons.push(polyline);
            for (var i = 0; i < $scope.linkPolygons.length; i++) {
                $scope.linkPolygons[i].setMap(map);
            }
            /*for(var v of $scope.verticeHashMap.keys()) {
                $scope.verticeHashMap.get(v).setMap(map);
            }*/
            if (map == null) {
                $scope.verticeHashMap = new Map();
                $scope.linkPolygons = [];
            }
            //$scope.verticeHashMap =
        }

        // To set a single marker on map when user clicked on device in tree view
        $scope.setMapOnSingleMarker = function (nodeId) {
            console.log("nodelinks", $scope.nodeLinks);
            var countCheck = 0;
            for (var i = 0; i < $scope.markers.length; i++) {
                var nId = $scope.markers[i].id;
                if (nodeId == $scope.markers[i].id) {
                    $scope.markers[i].setMap($scope.map);
                    google.maps.event.trigger($scope.markers[i], 'click');
                    const centerControlDiv = document.createElement("div");
                    CenterControl(centerControlDiv, $scope.map, $scope.markers[i], $scope.nodeLinks);
                    $scope.map.controls[google.maps.ControlPosition.RIGHT_TOP].clear();
                    $scope.map.controls[google.maps.ControlPosition.RIGHT_TOP].push(centerControlDiv);
                    countCheck++;

                }
            }
            if (countCheck == 0) {
                console.log("No markers found. Preparing markers...");
                var node = $('#container').jstree(true).get_node('j-' + 'n' + nodeId);
                if (node != null) {
                    console.log(node, "node");
                    var Parentnode = $('#container').jstree(true).get_node(node.parent);
                    console.log(Parentnode, "Parentnode");
                    $scope.clearMarkers(); //new
                    var testarray2 = [];
                    if(Parentnode.original.type=='facility'){
                        var childnode = $('#container').jstree(true).get_node(node.id);
                        // var childnode = $('#container').jstree(true).get_node(Parentnode.children);
                        testarray2.push(childnode.original.childobj);
                    }else{
                        testarray2.push(Parentnode.original.childobj);
                    }
                  
                    $scope.showLinksOnMap(testarray2);
                    $scope.setMapOnSingleMarkerbasedonCondition(nodeId);
                }
            }
        }
        // $scope.setMapOnSingleMarker = function (nodeId) {
        //     console.log("nodelinks", $scope.nodeLinks);
        //     for (var i = 0; i < $scope.markers.length; i++) {
        //         var nId = $scope.markers[i].id;
        //         if (nodeId == $scope.markers[i].id) {
        //             $scope.markers[i].setMap($scope.map);
        //             google.maps.event.trigger($scope.markers[i], 'click');
        //             const centerControlDiv = document.createElement("div");
        //             CenterControl(centerControlDiv, $scope.map, $scope.markers[i], $scope.nodeLinks);
        //             $scope.map.controls[google.maps.ControlPosition.RIGHT_TOP].clear();
        //             $scope.map.controls[google.maps.ControlPosition.RIGHT_TOP].push(centerControlDiv);

        //         }
        //     }
        // }
        $scope.setMapOnSingleMarkerbasedonCondition = function (nodeId) {
            for (var i = 0; i < $scope.markers.length; i++) {
                var nId = $scope.markers[i].id;
                if (nodeId == $scope.markers[i].id) {
                    $scope.markers[i].setMap($scope.map);
                    google.maps.event.trigger($scope.markers[i], 'click');
                    const centerControlDiv = document.createElement("div");
                    CenterControl(centerControlDiv, $scope.map, $scope.markers[i], $scope.nodeLinks);
                    $scope.map.controls[google.maps.ControlPosition.RIGHT_TOP].clear();
                    $scope.map.controls[google.maps.ControlPosition.RIGHT_TOP].push(centerControlDiv);
                }
            }
        }

        function CenterControl(controlDiv, map, markers, nodeLinks) {
            console.log("markers click center", markers);
            if (markers.title) {
                var markerhtml = '<html><body><div id="MyCoolDiv"><table><tr><td colspan="3" style="text-align:left">' + markers.title + '</td></tr>' +
                    '<tr><td colspan="3" style="text-align:left;color:blue">' + markers.ip + '<span style="margin-left:10px;text-align:left;color:grey">' + markers.title + '</span></td></tr>' +
                    '<tr><td colspan="3" style="text-align:left">SSID:<span style="color:grey">' + markers.ssid + '</span></td></tr>' +
                    '<tr><td colspan="3"><hr style="border-top:1px solid black"></td></tr>';
                if (nodeLinks.length > 0) {
                    for (var i = 0; i < nodeLinks.length; i++) {
                        localCustName = nodeLinks[i].localCustName;
                        var distance = 0;
                        if (!isNaN(parseFloat(nodeLinks[i].distance))) {
                            distance = parseFloat(nodeLinks[i].distance).toFixed(2);
                        }
                        var str = '<tr><td style="text-align: left;"><a href=http://' + nodeLinks[i].ipAddress + ' target="_blank" style="color: blue;font-weight: 500;" >' + nodeLinks[i].ipAddress + '</a>&nbsp&nbsp' + nodeLinks[i].remoteCustName + '</td>' +
                            '<td><span style="font-weight:400;font-style:normal;text-align: left;">' + '' + '</span></td><td></td></tr>' +
                            '<tr><td style="text-align: left;"><span style="font-weight:400;font-style:normal;text-align: left;"><b>SNR: L </b>' + nodeLinks[i].localSNRA1 + '<b>-</b>' + nodeLinks[i].localSNRA2 + '<b> : R </b>' + nodeLinks[i].remoteSNRA1 + '<b>-</b>' + nodeLinks[i].remoteSNRA2 + '</span></td>' +
                            '<td style="text-align: left;"><span style="font-weight:400;font-style:normal;text-align: left;padding-left: 10px;"><b> Link Id : </b>' + nodeLinks[i].remoteLinkId + '</span></td>' +
                            '<td><span style="font-weight:400;font-style:normal;text-align: left;padding-left: 10px;">' + distance + ' Km</span></td></tr>';
                        markerhtml = markerhtml + str;
                    }
                } else {
                    var str = '<tr> <td>No Links</td>';
                    markerhtml = markerhtml + str;
                }

                var str1 = '</table></div></body></html>';
                markerhtml = markerhtml + str1;
            } else {
                var markerhtml = 'Links';
            }
            // Set CSS for the control border.
            const controlUI = document.createElement("div");
            controlUI.style.backgroundColor = "#fff";
            controlUI.style.border = "2px solid #fff";
            controlUI.style.borderRadius = "3px";
            controlUI.style.boxShadow = "0 2px 6px rgba(0,0,0,.3)";
            controlUI.style.cursor = "pointer";
            controlUI.style.marginBottom = "22px";
            controlUI.style.textAlign = "center";
            controlUI.title = "Click";
            controlDiv.appendChild(controlUI);
            // Set CSS for the control interior.
            const controlText = document.createElement("div");
            controlText.style.color = "rgb(25,25,25)";
            controlText.style.fontFamily = "Roboto,Arial,sans-serif";
            controlText.style.fontSize = "16px";
            controlText.style.lineHeight = "15px";
            controlText.style.paddingLeft = "5px";
            controlText.style.paddingRight = "5px";
            // controlText.someid="someid";
            // document.getElementById('someid').src=markerhtml;
            controlText.innerHTML = markerhtml; //"Center Map";
            controlUI.appendChild(controlText);
            // Setup the click event listeners: simply set the map to Chicago.
            // controlUI.addEventListener("click", () => {
            //   map.setCenter({ lat: 41.85, lng: -87.65 });
            // });
        }

        $scope.setMapOnSingleMarkerOnSearch = function (node) {
            var idFound = false;
            $scope.searchBounds = new google.maps.LatLngBounds();
            $scope.clearMarkers();
//            for (var i = 0; i < $scope.markers.length; i++) {
//                var nId = $scope.markers[i].id;
//                if (node.nodeId == $scope.markers[i].id) {
//                    idFound = true;
//                    if(node.status=="Up"){
//                        var status=true;
//                    }else{
//                        var status=false;
//                    }
//                  if (node.radioMode == 'ap' || node.radioMode == 'AP') {
//                        if (status) {
//                            var iconURL= "images/ap_nms_icon.png";
//                        } else {
//                            var iconURL= "images/ap_nms_icon_disable.png";
//                        }
//                    } else {
//                        if (status) {
//                            var iconURL= "images/su4_nms_icon.png";
//                        } else {
//                            var iconURL= "images/su4_nms_icon_disable.png";
//                        }
//                    }
//                    $scope.markers[i].icon = iconURL;
//                    $scope.markers[i].setMap($scope.map);
//                    google.maps.event.trigger($scope.markers[i], 'click');
//                    $scope.searchBounds.extend($scope.markers[i].position);
//                }
//            }

            if (!idFound) {
                $scope.addLinkObjOnMapBySearch(node);
            }
            $scope.map.fitBounds($scope.searchBounds);
        }

        // To set a node on map
        $scope.addNodeOnMap = function (nodeObj) {
            if (nodeObj != null) {
                var latitude = nodeObj.assetRecord.latitude;
                var longitude = nodeObj.assetRecord.longitude;
                if ((latitude != undefined || latitude != null) && (longitude != undefined || longitude != null)) {
                    var myLatlng = new google.maps.LatLng(latitude, longitude);

                    google.maps.event.addListener(marker, 'click', function () {
                        /*$scope.infoWindow.setContent('<b>' + marker.title + '</b>' +
                            '<p><b>Address:</b>' +
                            marker.title +
                            '<br/><b>SSID:</b>' + marker.ssid +
                            '</p>'
                        );
                        $scope.infoWindow.open($scope.map, marker);*/
                        getLinkDetails(marker);
                    });

                    google.maps.event.addListener(marker, 'dragend', function () {

                        moveMarker(marker);

                    });
                    //marker.setMap($scope.map);

                    $scope.markers.push(marker);
                }
            }
        }

        function moveMarker(marker, isap) {
            console.log(marker.getPosition().lng());
            var svMarkerDiv = false;
            var key = marker.id;
            if (!isap) {
                key = marker.pid;
            }
            $scope.positionChangedMarker = marker;
            marker.posChanged = true;
            console.log($scope.positionChangedMarker.ip + '' + $scope.positionChangedMarker.posChanged);
            var vertices = $scope.verticeHashMap.get(key);
            if (vertices) {
                if (isap) {
                    for (i = 0; i < vertices.length; i++) {
                        var polyline = vertices[i];
                        polyline.getPath().setAt(0, marker.getPosition())
                    }
                } else {
                    for (i = 0; i < vertices.length; i++) {
                        var polyline = vertices[i];
                        if (polyline.id == marker.id) {
                            polyline.getPath().setAt(1, marker.getPosition());
                        }
                    }
                }
            }
            var markerDiv = document.getElementById("mvMarker");
            if (markerDiv) {
                if (markerDiv.style.display === "none") {
                    markerDiv.style.display = "block";
                }

            }
        }

        function SaveMarkerUI(controlDiv, map) {

            // Set CSS for the control border.
            var controlUI = document.createElement('div');
            controlUI.style.backgroundColor = '#27d69f';
            controlUI.style.border = '0px solid #27d69f';
            controlUI.style.borderRadius = '3px';
            controlUI.style.boxShadow = '0 2px 6px rgba(0,0,0,.3)';
            controlUI.style.cursor = 'pointer';
            controlUI.style.marginBottom = '22px';
            controlUI.style.textAlign = 'center';
            controlUI.title = 'Save marker location';
            controlDiv.appendChild(controlUI);

            // Set CSS for the control interior.
            var controlText = document.createElement('div');
            controlText.style.color = '#333333';
            controlText.style.fontFamily = 'Roboto,Arial,sans-serif';
            controlText.style.fontSize = '12px';
            controlText.style.lineHeight = '25px';
            controlText.style.paddingLeft = '5px';
            controlText.style.paddingRight = '5px';
            controlText.innerHTML = 'Save Position';
            controlUI.appendChild(controlText);

            controlDiv.id = 'mvMarker';
            controlDiv.style.display = 'none';

            // Setup the click event listeners: simply set the map to Chicago.
            controlUI.addEventListener('click', function () {
                controlDiv.style.display = 'none';
                $scope.saveDeviceLocation()
            });

        }

        $scope.saveDeviceLocation = function () {
            $http({
                method: 'POST',
                url: 'api/v2/nodemanageview/savelocation/' + $scope.positionChangedMarker.id + '?lat=' +
                    $scope.positionChangedMarker.getPosition().lat().toFixed(6) + '&lng=' + $scope.positionChangedMarker.getPosition().lng().toFixed(6),
                headers: {
                    'Content-Type': 'application/json'
                },
                data: {}
            }).success(function () {
                $scope.showAlert('Success', 'Saved successfully.');
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating Data: ' + msg);
            });
        }

        // To display links on map
        $scope.showLinksOnMap = function (links) {
            if (links.length > 0) {
                $scope.bounds = new google.maps.LatLngBounds();
                for (var i = 0; i < links.length; i++) {
                    if(links[i].data.mode!='tmarc' && links[i].data.mode!='switch'){
                        $scope.addLinkObjOnMap(links[i]);
                    }
                }
                $scope.map.fitBounds($scope.bounds);
            }
        }

        $scope.showLinksOnMapByFacility = function (links) {
            if (links.length > 0) {
                $scope.bounds = new google.maps.LatLngBounds();
                for (var i = 0; i < links.length; i++) {
                    var marker = $scope.markerHashMap.get(links[i].data.id);
                    if (marker) {
                        $scope.bounds.extend(marker.position);
                    }

                }
                $scope.map.fitBounds($scope.bounds);
            }
        }

        $scope.addLinkObjOnMapBySearch = function (nodeObj) {
            var iconURL = "";
            if (nodeObj != null) {
                var latitude = nodeObj.latitude;//nodeObj.assetRecord.latitude;
                var longitude = nodeObj.longitude;
                if (latitude == undefined) {
                    latitude = 0;
                }
                if (longitude == undefined) {
                    longitude = 0;
                }
                if ((latitude != undefined || latitude != null) && (longitude != undefined || longitude != null)) {
                    var myLatlng = new google.maps.LatLng(latitude, longitude);
                    if(nodeObj.status=='Up'){
                        var status=true;
                    }else{
                    var status=false;
                    }
                    var iconURL = getIcon(nodeObj.radioMode, status);
                    var marker = new google.maps.Marker({
                        map: $scope.map,
                        id: nodeObj.id,
                        pid: -1,
                        isap: true,
                        draggable: true,
                        position: myLatlng,
                        posChanged: false,
                        title: nodeObj.sysName,
                        dist: -1,
                        icon: iconURL,
                        ssid: nodeObj.ssid,
                        ip: nodeObj.text?nodeObj.text:nodeObj.ipAddress,
                        mode: nodeObj.radioMode,
                        model: nodeObj.productcode
                    });
                    //images/icon2.png
                    google.maps.event.addListener(marker, 'click', function () {
                        getLinkDetails(marker);
                    });
                    google.maps.event.addListener(marker, 'dragend', function () {

                        moveMarker(marker, true);
                    });
                    var parent = nodeObj.id;
                    /* if (nodeObj.children.length > 0) {
                         for (var j = 0; j < nodeObj.children.length; j++) {
                             $scope.addNodeVerticesOnMap(nodeObj,nodeObj.children[j], myLatlng);
                         }
                     }*/
                    $scope.searchBounds.extend(marker.position);
                    $scope.markers.push(marker);
                    //$scope.markerHashMap.set(nodeObj.data.id,marker);
                    google.maps.event.trigger(marker, 'click');

                    //$scope.markerHashMap['"'+ nodeObj.data.id+ '"'] = marker;
                }
            }
        }

        // To add a link on map
        $scope.addLinkObjOnMap = function (nodeObj) {
            var iconURL = "";
            if (nodeObj != null) {
                var latitude = nodeObj.data.lat;
                var longitude = nodeObj.data.long;
                if ((latitude != undefined || latitude != null) && (longitude != undefined || longitude != null)) {
                    var myLatlng = new google.maps.LatLng(latitude, longitude);
                    var iconURL = getIcon(nodeObj.data.mode, nodeObj.data.active);
                    var marker = new google.maps.Marker({
                        map: $scope.map,
                        id: nodeObj.data.id,
                        pid: -1,
                        isap: true,
                        draggable: true,
                        position: myLatlng,
                        posChanged: false,
                        title: nodeObj.data.systemname,
                        dist: -1,
                        icon: iconURL,
                        ssid: nodeObj.data.ssid,
                        ip: nodeObj.text,
                        mode: nodeObj.data.mode,
                        model: nodeObj.data.model
                    });
                    //images/icon2.png
                    google.maps.event.addListener(marker, 'click', function () {
                        getLinkDetails(marker);
                    });
                    google.maps.event.addListener(marker, 'dragend', function () {

                        moveMarker(marker, true);
                    });
                    var parent = nodeObj.data.id;
                    if (nodeObj.children.length > 0) {
                        for (var j = 0; j < nodeObj.children.length; j++) {
                            $scope.addNodeVerticesOnMap(nodeObj, nodeObj.children[j], myLatlng);
                        }
                    }
                    $scope.bounds.extend(marker.position);
                    $scope.markers.push(marker);
                    $scope.markerHashMap.set(nodeObj.data.id, marker);
                    //$scope.markerHashMap['"'+ nodeObj.data.id+ '"'] = marker;
                }
            }
        }

        function getIcon(type, status) {
            if (type == 'ap' || type == 'AP') {
                if (status) {
                    return apUpIcon;
                } else {
                    return apDownIcon;
                }
            } else {
                if (status) {
                    return su4UpURL;
                } else {
                    return su4DownURL;
                }
            }
        }

        function getLinkDetails(marker) {
            var url = 'api/v2/nodelinks/linkstats?nodeId=' + marker.id;
            var nodeLinks = null;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        nodeLinks = response.data.links;
                        $scope.nodeLinks = response.data.links;
                        console.log("markers link details");
                        // var nodeLinks= $scope.nodeLinks;
                        var dataStr = '';
                        var localCustName = '';
                        var infoTable = ''
                        if (nodeLinks.length > 0) {
                            for (var i = 0; i < nodeLinks.length; i++) {
                                localCustName = nodeLinks[i].localCustName;
                                var distance = 0;
                                if (!isNaN(parseFloat(nodeLinks[i].distance))) {
                                    distance = parseFloat(nodeLinks[i].distance).toFixed(2);
                                }

                                var str = '<tr><td style="text-align: left;"><a style="color: blue;font-weight: 500;" href=http://' + nodeLinks[i].ipAddress + ' target="_blank">' + nodeLinks[i].ipAddress + '</a>&nbsp&nbsp' + nodeLinks[i].remoteCustName + '</td>' +
                                    '<td><span style="font-weight:400;font-style:normal;text-align: left;">' + '' + '</span></td><td></td></tr>' +
                                    '<tr><td style="text-align: left;"><span style="font-weight:400;font-style:normal;text-align: left;"><b>SNR: L </b>' + nodeLinks[i].localSNRA1 + '<b>-</b>' + nodeLinks[i].localSNRA2 + '<b> : R </b>' + nodeLinks[i].remoteSNRA1 + '<b>-</b>' + nodeLinks[i].remoteSNRA2 + '</span></td>' +
                                    '<td style="text-align: left;"><span style="font-weight:400;font-style:normal;text-align: left;padding-left: 10px;"><b> Link Id : </b>' + nodeLinks[i].remoteLinkId + '</span></td>' +
                                    '<td><span style="font-weight:400;font-style:normal;text-align: left;padding-left: 10px;">' + distance + ' Km</span></td></tr>';

                                /*var str =  '<p><a href=http://'+ marker.ip +'target="_blank" >' + nodeLinks[i].ipAddress + '</a> &nbsp &nbsp  &nbsp &nbsp &nbsp  &nbsp' + nodeLinks[i].remoteCustName +'<br/>' +
                                           '<b>SNR: L </b>' + nodeLinks[i].localSNRA1 + '<b>-</b>' + nodeLinks[i].localSNRA2 + '<b> : R </b>' + nodeLinks[i].remoteSNRA1 + '<b>-</b>' + nodeLinks[i].remoteSNRA2 + "&nbsp &nbsp" + '<b> Link Id : </b>' + nodeLinks[i].remoteLinkId  + "</p>";
                                */
                                /*'<b> Link Id : </b>' + nodeLinks[i].remoteLinkId +'<br/>' +*/
                                dataStr = dataStr + str;

                            }
                        } else {
                            var str = '<tr> <td>No Links</td>';
                            dataStr = dataStr + str;
                        }
                        infoTable = infoTable  + '</tbody></table>';   //hide link details
                        //infoTable = infoTable + dataStr + '</tbody></table>';        //show link details
                        if (marker.pid != -1) {
                            var content = '<b>' + marker.title + '</b>' +
                                '<p><a style="color: blue;font-weight: 500;" href=http://' + marker.ip + ' target="_blank" >' +
                                marker.ip + '</a> &nbsp &nbsp &nbsp ' + localCustName +
//                                '<br/><b>SSID:</b>' + marker.ssid + '</br><hr style="border-top: 1px solid #000000;"><table><tbody>' +
                                '<br/><b>SSID:</b>' + marker.ssid + '</br><table><tbody>' +
                                '<thead> <tr><th></th><th></th><th></th></tr></thead>' +
                                /*'<br/><b>Distance:</b>' + marker.dist +*/
                                /* '</p>' +*/
                                infoTable;
                        } else {
                            var content = '<b>' + marker.title + '</b>' +
                                '<p><a style="color: blue;font-weight: 500;" href=http://' + marker.ip + ' target="_blank" >' +
                                marker.ip + '</a> &nbsp &nbsp' + localCustName +
//                                '<br/><b>SSID:</b>' + marker.ssid + '</br><hr style="border-top: 1px solid #000000;"><table><tbody>' +
                                '<br/><b>SSID:</b>' + marker.ssid + '</br><table><tbody>' +
                                '<thead> <tr><th></th><th></th><th></th></tr></thead>' +
                                /* '</p>' +*/
                                infoTable;
                        }
                        $scope.infoWindow.setContent(content);
                        $scope.infoWindow.open($scope.map, marker);
                    }
                });

        }

        function getLinkColor(parentStatus, childStatus) {
            if (parentStatus && childStatus) {
                return '#000000';
            } else if (parentStatus && !childStatus) {
                return '#ff0000';
            } else if (!parentStatus && childStatus) { // this state occurs but if sta poller is delayed to ap poller
                return '#ff0000';
            } else if (!parentStatus && !childStatus) {
                return '#ff0000';
            }
            return black;
        }




        function distance(lat1, lon1, lat2, lon2) {
            var R = 6371; // km (change this constant to get miles)
            var dLat = (lat2 - lat1) * Math.PI / 180;
            var dLon = (lon2 - lon1) * Math.PI / 180;
            var a = Math.sin(dLat / 2) * Math.sin(dLat / 2) +
                Math.cos(lat1 * Math.PI / 180) * Math.cos(lat2 * Math.PI / 180) *
                Math.sin(dLon / 2) * Math.sin(dLon / 2);
            var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
            var d = R * c;
            var metrics = $rootScope.metrics;
            if (!metrics) {
                metrics = $rootScope.buildCode;
            }
            if (metrics == 'US') {
                d = d * 0.621371;
                return parseFloat(d).toFixed(2) + ' Mi'

            } else {
                if (d > 1) return Math.round(d) + " Km";
                else if (d <= 1) return Math.round(d * 1000) + " mtrs";

            }

            return d;
        }



        // To draw a line on map
        $scope.addNodeVerticesOnMap = function (parentObj, nodeObj, startPoint) {
            if (nodeObj != null) {
                var latitude = nodeObj.data.lat;
                var longitude = nodeObj.data.long;
                var lat1 = startPoint.lat();
                var lng1 = startPoint.lng();
                if ((latitude != undefined || latitude != null) && (longitude != undefined || longitude != null)) {
                    var dist = distance(lat1, lng1, latitude, longitude);
                    var iconURL = getIcon(nodeObj.data.mode, nodeObj.data.active);
                    var myLatlng = new google.maps.LatLng(latitude, longitude);
                    var marker = new google.maps.Marker({
                        map: $scope.map,
                        id: nodeObj.data.id,
                        draggable: true,
                        pid: parentObj.data.id,
                        position: myLatlng,
                        posChanged: false,
                        title: nodeObj.data.systemname,
                        dist: dist,
                        icon: iconURL,
                        ssid: nodeObj.data.ssid,
                        ip: nodeObj.text,
                        mode: nodeObj.data.mode,
                        model: nodeObj.data.model
                    });
                    google.maps.event.addListener(marker, 'click', function () {
                        getLinkDetails(marker);
                    });
                    google.maps.event.addListener(marker, 'dragend', function () {
                        moveMarker(marker, false);
                    });
                    $scope.markers.push(marker);
                    $scope.markerHashMap.set(nodeObj.data.id, marker);
                    $scope.bounds.extend(marker.position);
                    var vPaths = [];
                    vPaths.push([startPoint, myLatlng]);
                    var key = parentObj.data.id + "~" + nodeObj.data.id;
                    var color = getLinkColor(parentObj.data.active, nodeObj.data.active);
                    var polyline = new google.maps.Polygon({
                        paths: vPaths,
                        id: nodeObj.data.id,
                        pid: parentObj.data.id,
                        icon: iconURL,
                        verticekey: key,
                        strokeColor: color,
                        strokeWeight: 2,
                        strokeOpacity: 1
                    });
                    polyline.infoWindow = new google.maps.InfoWindow({
                        content: "<p> Distance: " + dist + "</p>",
                        position: startPoint
                    });
                    google.maps.event.addListener(polyline, 'mouseover', function (e) {
                        var latLng = e.latLng;
                        this.setOptions({
                            fillOpacity: 0.1
                        });
                        polyline.infoWindow.setPosition(latLng);
                        polyline.infoWindow.open($scope.map);
                    });
                    google.maps.event.addListener(polyline, 'mouseout', function () {
                        this.setOptions({
                            fillOpacity: 0.35
                        });
                        polyline.infoWindow.close();
                    });
                    /*var infowindow = new google.maps.InfoWindow({
                          content: "<p>Distance : 5mts</p>",
                          position: vPaths[0]
                       });

                    google.maps.event.addListener(polyline,
                            'click', infoCallback(infowindow));*/

                    polyline.setMap($scope.map);
                    var v = $scope.verticeHashMap.get(parentObj.data.id);
                    if (v) {
                        $scope.verticeHashMap.get(parentObj.data.id).push(polyline);
                    } else {
                        var po = [];
                        po.push(polyline);
                        $scope.verticeHashMap.set(parentObj.data.id, po);
                    }
                    //$scope.verticeHashMap.set(key,polyline);
                    $scope.linkPolygons.push(polyline);
                }
            }
        }
        // Google Map End
        $scope.nodes = [];

        // Load all Nodes
        $scope.loadAllNodes = function () {
            var config = {
                params: {
                    'limit': $scope.limit,
                    '_s': 'productCode==ptp,productCode==ptmp,productCode==indoorap,productCode==outdoorap'
                },
                //showdiv: false
            };
            var url = 'api/v2/nodes';
            $http.get(url, config)
                .then(function (response) {
                    if (response.data) {
                        $scope.nodes = response.data.node;
                    }
                });
        }

        // Redirect to Node view
        $scope.showNode = function (nodeId, lastView) {
            $state.go('app.nodeView', {
                "nodeId": nodeId,
                "lastView": lastView
            });
        }

        // Not using o Load Node by Id
        $scope.loadNodeById = function (nodeId) {
            var url = 'api/v2/nodes/' + nodeId;
            return $http.get(url, {
                //showdiv: false
            })
                .then(function (response) {
                    if (response.data) {
                        return response.data;
                    }
                });
        }


        // Change Radio Mode in the Tree View
        $scope.changeDeviceType = function (nodesFilter, sd) {
            //  showpageloading(true);
            $scope.nodesFilter = nodesFilter.toLowerCase();
            $localStorage.selectedradiomode = $scope.nodesFilter;
            $localStorage.locationId = $scope.locationId;
            // $window.location.reload(true);
            $scope.maprefresh = true;       //make true for refresh map when cahnge radio mode
            $scope.slectednode = $("#container").jstree("get_selected", true);
            if ($scope.slectednode.length > 0) {
                $scope.slectednode[0].state.opened = false;
                console.log("selected node", $scope.slectednode);
            }
            $('#container').jstree(true).refresh();
            // setTimeout(function () {
            //     $('#container').jstree(true).open_node($scope.slectednode[0].id);
            // }, 500);



            // $http.get('api/v2/treeview/locations/' + $scope.locationId + '/facilitiesn?show=' + $scope.nodesFilter) //,{showdiv:false}
            //     .then(function (response) {
            //         if (response.data) {
            //             // showpageloading(false);
            //             if ($scope.mytree.currentNode.data.id == $scope.locationId) {
            //                 $scope.mytree.currentNode.children = response.data;
            //                 if (response.data[0].data) {
            //                     $scope.isEnable = true;
            //                     $scope.nodeID = response.data[0].data.id;
            //                 }

            //             }
            //         }
            //     });

            // $http.get('api/v2/treeview/locations/' + $scope.locationId + '/links?show=all', {
            //     //showdiv: false
            // })
            //     .then(function (response) {
            //         if (response.data) {
            //             if ($scope.mytree.currentNode.data.id == $scope.locationId) {
            //                 $scope.clearMarkers();
            //                 $scope.showLinksOnMap(response.data)
            //             }
            //         }
            //     });

        }


        // Load Nodes under the facility
        $scope.loadFacilityNodes = function (facilityId) {
            $scope.facilityId = facilityId;
            if (!$scope.nodesFilter) {
                $scope.nodesFilter = "all"
            }
            var url = 'api/v2/treeview/facility/' + facilityId + '/treenodes?show=' + $scope.nodesFilter;
            return $http.get(url, {
                //showdiv: false
            })
                .then(function (response) {
                    if (response.data) {
                        return response.data;
                    }
                });
        }

        // Not Using - Load all nodes
        $scope.loadNodes = function (loc) {
            var config = {
                params: {
                    'limit': $scope.limit,
                    '_s': 'productCode==ptp,productCode==ptmp,productCode==indoorap,productCode==outdoorap'
                }
            };
            var url = 'api/v2/nodes';
            if (loc && loc != '') {
                url = 'api/v2/treeview/' + loc + '/nodes';
            }
            return $http.get(url, config)
                .then(function (response) {
                    if (response.data) {
                        return response.data;
                    }
                });
        }

        $scope.loadManagementNodes = function () {
            var config = {
                params: {
                    'limit': $scope.limit,
                    '_s': '(productCode==ptp,productCode==ptmp,productCode==indoorap,productCode==outdoorap)'
                }
            };

            var url = 'api/v2/nodes';

            $http.get(url, config)
                .then(function (response) {
                    if (response.data) {
                        $scope.vm.totalNodesCount = response.data.count;
                        $scope.vm.nodes = response.data.node;
                    }
                });
        }

        // Load Active Nodes
        $scope.loadActiveNodesCount = function () {
            $http.get('api/v2/nodes/active/count', {
                //showdiv: false
            })
                .then(function (response) {
                    if (response.data) {
                        $scope.vm.activeNodesCount = response.data;
                    }
                });
        }

        $scope.rescanLocation = function (facilityid) {
            $http({
                method: 'POST',
                url: 'api/v2/nodes/scanloc/' + facilityid,
                headers: {
                    'Content-Type': 'application/json'
                },
                // data: dataObjSystemConfig
            }).success(function () {
                $scope.showAlert('Success', 'Rescan successfully.');
            }).error(function (msg) {
                $scope.showAlert('Error', msg);
            });
        }

        $scope.selectedlevel = '';
        $scope.slectednode = [];
        $scope.maprefresh = true;
        // Default generate Tree
        $scope.buildTree = function () {
            $scope.countStat = false;
            // $localStorage.cachedTree = true
            //$scope.loadTreeRegions();
            //            $scope.treedata = [
            //                { 'text': 'Global', 'systemtext':'Global','data': { 'id': '-1', 'type': 'root', 'mode': 'root','systemname':'Global' }, 'children': [], isexpand:false }
            //            ];
            var selectedTree;
            $('#container').jstree({
                "state": { "key": "state_demo" },
                "plugins": ["contextmenu", "search", "state"], //plugin declaration
                "contextmenu": { //context menu  
                    "select_node": false,
                    "items": function ($node) {
                        selectedTree = $node.original;
                        // it will open context menu based on conditions
                        if (selectedTree.type == 'facility') {
                            return {
                                "Rescan": {
                                    "seperator_before": false,
                                    "seperator_after": false,
                                    "label": "Rescan Facility",
                                    "icon": "glyphicon glyphicon-refresh",
                                    action: function (obj, node) {
                                        $scope.rescanLocation(selectedTree.fid);
                                        // selectedTree.data = selectedTree.datas;
                                        // $scope.rescanNodeObj = selectedTree;
                                    }
                                }
                            }
                        }
                        if (selectedTree.type === 'node') {
                            var tree = $("#container").jstree(true);
                            return {
                                "Move to facility": {
                                    "seperator_before": false,
                                    "seperator_after": false,
                                    "label": "Move to facility",
                                    //"icon": "https://www.jstree.com/tree.png",
                                    "icon": "glyphicon glyphicon-move",
                                    action: function (obj, node) {
                                        selectedTree.data = selectedTree.datas;
                                        $scope.rescanNodeObj = selectedTree;
                                        $scope.showAdvanced();
                                    }
                                },
                                "Rescan": {
                                    "seperator_before": false,
                                    "seperator_after": false,
                                    "label": "Rescan",
                                    "icon": "glyphicon glyphicon-refresh",
                                    action: function (obj, node) {
                                        selectedTree.data = selectedTree.datas;
                                        $scope.rescanNodeObj = selectedTree;
                                    }
                                },
                                "NodeView": {
                                    "seperator_before": false,
                                    "seperator_after": false,
                                    "label": "NodeView",
                                    "icon": "glyphicon glyphicon-home",
                                    action: function (obj, node) {
                                        selectedTree.data = selectedTree.datas;
                                        $scope.rescanNodeObj = selectedTree;
                                        if(selectedTree.type === 'node'){
                                            $scope.selectedlevel = 'node';
                                        }
                                        $scope.setMapOnSingleMarker(selectedTree.nid);
                                        $scope.nodeviewFun(selectedTree);
                                    }
                                }
                            }
                        }
                    }
                },
                'core': {
                    "check_callback": true,
                    'data': function (node, cb) { //callback based data calls
                        node.disable_close = true;
                        for (var i = 0; i < circles.length; i++) {
                            circles[i].setMap(null);
                        }
                        $scope.labelText = "";
                        var treeNode = $("#container").jstree("get_selected");
                        console.log("treeNode", treeNode);
                        if (node.id === "#") {
                            $scope.selectedlevel = '';
                            $scope.chartGrid = false;
                            $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
                            cb([{
                                "text": "Global",
                                "id": "1",
                                "children": true,
                                "type": "root",
                                "icon": "./images/globalOpen.png",
                            }]);
                        } else if (node.original.type == "root") {
                            $scope.selectedlevel = '';
                            $scope.chartGrid = false;
                            $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
                            $localStorage.isExpand = true;
                            if ($scope.maprefresh) {
                                $scope.clearMarkers(); //new
                            }
                            $scope.viewMode = "Region";
                            $scope.selectedLocation = null;
                            // if($scope.mytree.currentNode.isexpand){
                            $scope.loadTreeRegions().then((data) => {
                                // data[0].isexpand=true;
                                if (data.length > 0) {
                                    for (var i = 0; i < data.length; i++) {
                                        data[i].id = 'j-' + 'r' + data[i].data.id;
                                        data[i].data.systemname = data[i].text;
                                    }
                                }
                                $scope.mytree.currentNode.children = data;
                                if ($scope.maprefresh) {
                                    const centerControlDiv = document.createElement("div");
                                    CenterControl(centerControlDiv, $scope.map, {}, []);
                                    $scope.map.controls[google.maps.ControlPosition.RIGHT_TOP].clear();
                                    $scope.map.controls[google.maps.ControlPosition.RIGHT_TOP].push(centerControlDiv);
                                }
                                var obj = new Array();
                                for (var i = 0; i < data.length; i++) {
                                    obj[i] = {
                                        "id": data[i].id,
                                        "rid": data[i].data.id,
                                        "text": data[i].text,
                                        "type": data[i].data.type,
                                        "children": data[i].children.length > 0 ? true : true,
                                        "datas": data[i].data,
                                        "icon": "./images/normalregion.png"
                                    }
                                }
                                cb(obj);
                            });
                        } else if (node.original.type == "region") {
                            $scope.selectedlevel = '';
                            $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
                            $scope.chartGrid = false;
                            $localStorage.isExpand = true;
                            if ($scope.maprefresh) {
                                $scope.clearMarkers(); //new
                            }
                            $scope.viewMode = "Location";
                            $scope.selectedLocation = null;
                            // if($scope.mytree.currentNode.isexpand){
                            $scope.loadTreeLocations(node.original.rid).then((data) => {
                                // data[0].isexpand=true;
                                if (data.length > 0) {
                                    for (var i = 0; i < data.length; i++) {
                                        data[i].id = 'j-' + 'l' + data[i].data.id;
                                        data[i].data.systemname = data[i].text;
                                    }
                                }
                                $scope.mytree.currentNode.children = data;
                                var obj = new Array();
                                for (var i = 0; i < data.length; i++) {
                                    obj[i] = {
                                        "id": data[i].id,
                                        "lid": data[i].data.id,
                                        "text": data[i].text,
                                        "type": data[i].data.type,
                                        "children": data[i].children.length > 0 ? true : true,
                                        "datas": data[i].data,
                                        "icon": "./images/exploca.png"
                                    }
                                }
                                cb(obj);
                            });
                        } else if (node.original.type == "location") {
                            $scope.selectedlevel = '';
                            $scope.chartGrid = false;
                            $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
                            $localStorage.isExpand = true;
                            if ($scope.maprefresh) {
                                $scope.clearMarkers(); //new
                            }
                            $scope.viewMode = "Facilities";
                            // if( $localStorage.selectedradiomode=='all'){
                            $scope.loadTreeFacilities(node.original.lid).then(function (data) {
                                if (data.length > 0) {
                                    for (var i = 0; i < data.length; i++) {
                                        data[i].id = 'j-' + 'f' + data[i].data.id;
                                        data[i].data.systemname = data[i].text;
                                    }
                                }
                                $scope.mytree.currentNode.children = data;
                                if ($scope.systemOnline) {
                                    $localStorage.cachedMap = data;
                                }
                                var obj = new Array();
                                for (var i = 0; i < data.length; i++) {
                                    obj[i] = {
                                        "id": data[i].id,
                                        "fid": data[i].data.id,
                                        "text": data[i].text,
                                        "type": data[i].data.type,
                                        "children": data[i].children.length > 0 ? true : false,
                                        "datas": data[i].data,
                                        "icon": "./images/expfac.png"
                                    }
                                }
                                cb(obj);
                            });
                            $scope.selectedLocation = node.original.lid;
                            if ($scope.selectedLocation != null) {
                                $scope.loadTopology($scope.selectedLocation);
                            }
                            // $localStorage.cachedCurrentNode = $scope.mytree.currentNode;
                        } else if (node.original.type === 'facility') { // location -- facility or locations under region
                            $scope.selectedlevel = '';
                            $scope.chartGrid = false;
                            $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
                            if($scope.slectednode.length>0){
                                if($scope.slectednode[0].original.type=="node"){
                                    $scope.mapchartshow=true;
                                    $scope.chartGrid = true;
                                    $scope.mapDynamicHeight = "width:100%;height:60vh;position:relative;overflow:hidden";
                                }
                            }
                            $localStorage.isExpand = true;
                            if ($scope.maprefresh) {
                                $scope.clearMarkers(); //new
                            }
                            //$scope.prepareMap();
                            $scope.viewMode = "Devices";                           
                            $scope.nodesFilter = $localStorage.selectedradiomode.toLowerCase();                           
                            $scope.loadFacilityNodes(node.original.fid).then(function (data) {
                                $scope.currentSelectedFacility = node.original.fid;
                                if ($scope.maprefresh) {
                                    $scope.clearMarkers(); //new
                                    $scope.showLinksOnMap(data) //new
                                }
                                $scope.mytree.currentNode.children = data;
                                if (data.length > 0) {
                                    $scope.isEnable = true;
                                    $scope.nodeID = data[0].data.id;
                                }
                                var obj = new Array();
                                 var checkChildren = false;
                                 if ($localStorage.selectedradiomode == 'all') {
                                       checkChildren = true;
                                 }
                                 var j = 0;
                                 for (var i = 0; i < data.length; i++) {
                                     if (data[i].data.addtotree == true) {
                                         var text = data[i].data.systemname;
                                         if ($scope.showsystemIP == 'ip') {
                                             text = data[i].text;
                                         }
                                        // if (checkChildren) {
                                            checkChildren =  data[i].children.length > 0 ? true : false;
                                         //}

                                         if (checkChildren) {
                                            var childs = [];
                                            for (var k = 0; k <data[i].children.length; k++) {
                                                if (data[i].children[k].data.addtotree == true) {
                                                    childs.push(data[i].children[k]);

                                                }
                                            }
                                            data[i].children = childs;
                                         }
                                         if(data[i].data.mode == 'ap'){
                                            var icon="./images/cloapdown.png";
                                         }else if(data[i].data.mode == 'sta'){
                                            var icon="./images/clostadown.png";
                                         }else{
                                            var icon="./images/topswitch.png";
                                         }

                                         obj[j] = {
                                             "id": 'j-' + 'n' + data[i].data.id,
                                             "nid": data[i].data.id,
                                             "ipdata": data[i].text,
                                             "text": text,
                                             "type": data[i].data.type,
                                             "children": checkChildren,
                                             "childobj": data[i],
                                             "datas": data[i].data,
                                             "icon": icon
                                         }
                                         j++;
                                     }
                                 }
                                 console.log("ffacilty uild",obj);
                                 console.log("ffacilty uild data",data);
                                 $scope.facilityobj = obj;
                                 cb(obj);
                                $scope.selectedLocation = node.parent.substring(3);
                                if ($scope.selectedLocation != null) {
                                    $scope.loadTopology($scope.selectedLocation);
                                }
                            });
                        } else if (node.original.type === 'node') {
                            $state.params.nodeId = node.original.nid;
                            // $scope.prepareMap();
                            $scope.selectedlevel = 'node';
                            if ($scope.mapchartshow) {
                                $scope.chartGrid = true;
                                 if ($scope.device_throughput_config) {
                                    for (i = 0; i < $scope.arrayLimit; i++) {
                                        if (i % 20 == 0) {
                                            // Generate the Labels (at each minute)
                                            $scope.device_throughput_config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                                        } else {
                                            // Empty Labels at rest of the places
                                            $scope.device_throughput_config.data.labels[i] = "";
                                        }
                                        // Null values
                                        $scope.device_throughput_config.data.datasets[0].data[i] = null;
                                        $scope.device_throughput_config.data.datasets[1].data[i] = null;
                                        $scope.device_throughput_config.data.datasets[2].data[i] = null;
                                    }
                                }
                                $scope.mapDynamicHeight = "width:100%;height:60vh;position:relative;overflow:hidden";
                            } else {
                                $scope.chartGrid = false;
                                $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
                            }
                             if($scope.slectednode.length>0){
                                if($scope.slectednode[0].original.type=="node"){
                                    $scope.mapchartshow=true;
                                    $scope.chartGrid = true;
                                    $scope.mapDynamicHeight = "width:100%;height:60vh;position:relative;overflow:hidden";
                                }
                            }
                            $localStorage.isExpand = true;
                            var id = node.original.nid;
                            var data = node.original.childobj.children;
                            var obj = new Array();
                            for (var i = 0; i < data.length; i++) {
                                var text = data[i].data.systemname;
                                if ($scope.showsystemIP == 'ip') {
                                    text = data[i].text;
                                }
                                obj[i] = {
                                        "id": 'j-' + 'n' + data[i].data.id,
                                        "nid": data[i].data.id,
                                        "ipdata": data[i].text,
                                        "text": text,
                                        "type": data[i].data.type,
                                        "children": data[i].children.length > 0 ? true : false,
                                        "datas": data[i].data,
                                        "childobj": data[i].children,
                                        "icon": "./images/clostadown.png"
                                    }
                            }
                            cb(obj);
                            $scope.bounds = new google.maps.LatLngBounds();
                            var marker = $scope.markerHashMap.get(id);
                            if (marker) {
                                $scope.bounds.extend(marker.position);
                            }
                            $scope.map.fitBounds($scope.bounds);
                            if ($scope.systemOnline) {
                                //$scope.clearMarkers();
                                //$scope.linkVertexPaths = [];

                                if ($scope.maprefresh) {
                                    var url = 'api/v2/nodelinks/linkstats?nodeId=' + id;
                                    $scope.nodeLinks = [];
                                    $http.get(url)
                                        .then(function (response) {
                                            if (response.data) {
                                                $scope.nodeLinks = response.data.links;
                                                if ($scope.nodeLinks.length > 0) {
                                                    for (var l = 0; l < $scope.nodeLinks.length; l++) {
                                                        if ($scope.nodeLinks[l].distance == null) {
                                                            $scope.nodeLinks[l].distance = 0;
                                                        }
                                                    }
                                                }
                                                $scope.setMapOnSingleMarker(id);
                                            }
                                        });
                                }
                            }
                            //                            if($scope.countStat){
                            //                                location.reload();
                            //                             }
                        }
                        // $scope.maprefresh=true;
                    }
                }
            })
                //     .on('ready.jstree', function () {
                //         $('#container').jstree(true).open_node($scope.slectednode[0].id);
                //   }) 
                //   .on('load_all.jstree', function (e, data) {
                //         debugger
                //         if($scope.slectednode.length>0){
                //             if($scope.slectednode[0].id){
                //                 $("#container").jstree()._open_to( $scope.slectednode[0].id );
                //             }
                //         }
                //     })
                // .on('close_node.jstree',function(e,data){
                //     setTimeout(function() {
                //         data.instance.open_node(data.node);
                //       }, 0);
                // })
                .on('select_node.jstree', function (e, data) {
                    // if(data.node.state.opened){
                    //     data.node.state.opened=false;
                    // }
                    // $localStorage.node = data.node;
                    $scope.searchText = '';
                    $("#container").jstree(true).clear_search();
                    selectedTree = data.node.original;
                    if ($scope.maprefresh) {
                        $scope.expandTree(data);
                    }
                    setTimeout(function () { $scope.maprefresh = true; }, 10);

                    if (data.node.state.opened && data.node.disable_close) {                 //to disable collapse when click
                        return (false)
                    }
                    return data.instance.toggle_node(data.node); //this is used for onclick expand
                })
            // .on("before_open.jstree", function (e, data) {
            //     // $localStorage.node = data.node;
            //     selectedTree = data.node.original;
            //     console.log("jstree click",data);
            //     $scope.expandTree(data);
            //     });
        }

        $scope.expandTree = function (data) {
            $scope.map.controls[google.maps.ControlPosition.RIGHT_TOP].clear();
            if (data.node.original.type == 'root') {
                $scope.selectedlevel = '';
                $scope.chartGrid = false;
                $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
                $scope.viewMode = "Region";
                $scope.mytree.currentNode.children = data.node.children;
                var treeObj = JSON.parse(localStorage.getItem('state_demo'));
                console.log(treeObj, "treeObj");
                console.log("parentData root", data.node.parents);
                $localStorage.lastSelected = data.node.parents;
                //$localStorage.lastSelected.push(data.node.id);

            } else if (data.node.original.type == 'region') {
                $scope.selectedlevel = '';
                $scope.chartGrid = false;
                $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
                $scope.viewMode = "Location";
                if ($scope.maprefresh) {
                    $scope.clearMarkers(); //new
                }
                $("#container").jstree(true).set_id(data.node.id, 'j-' + 'r' + data.node.original.rid)
                // if($localStorage.lastOpenedNodeDetails){
                //     $localStorage.lastOpenedNodeDetails = {};
                // }
                // $localStorage.lastOpenedNodeDetails.level = 'region';
                // $localStorage.lastOpenedNodeDetails.region = data.node.id;
                // $scope.mytree.currentNode.children = data.node.children;
                var treeObj = JSON.parse(localStorage.getItem('state_demo'));
                console.log(treeObj, "treeObj");
                console.log("parentData region", data.node.parents);
                $localStorage.lastSelected = data.node.parents;
                //$localStorage.lastSelected.push(data.node.id);
                $localStorage.isExpand = true;
                //$scope.prepareMap();
                $scope.regioncountarr = [];
                if ($scope.maprefresh) {
                    var url = 'api/v2/treeview/clust/region/' + data.node.original.rid;
                    $http.get(url).then((response) => {
                        if (response.data) {
                            if (response.data.region.length > 0) {
                                var regdata = response.data.region;
                                for (var m = 0; m < regdata.length; m++) {
                                    if (!regdata[m].lat) {
                                        regdata[m].lat = 0;
                                        regdata[m].long = 0;
                                    }
                                    var lat = regdata[m].lat
                                    var long = regdata[m].long;
                                    var total = regdata[m].total;
                                    lat = lat;
                                    lat = lat != 0 ? lat.replace(/[^\d.-]/g, '') : lat;
                                    long = long;
                                    long = long != 0 ? long.replace(/[^\d.-]/g, '') : long;
                                    var mapobj = {
                                        lat: lat,
                                        long: long,
                                        down: total,
                                        title:regdata[m].name
                                    }
                                    $scope.regioncountarr.push(mapobj);
                                }
                                if ($scope.regioncountarr.length > 0) {
                                    $scope.countStat = true;
                                    setTimeout(function () { initMaps($scope.regioncountarr); }, 10);
                                }
                            }
                        }
                    });
                }
            } else if (data.node.original.type == 'location') {
                $scope.selectedlevel = '';
                $scope.chartGrid = false;
                $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
                $scope.viewMode = "Facilities";
                if ($scope.maprefresh) {
                    $scope.clearMarkers(); //new
                }
                $scope.selectedLocation = data.node.original.lid;
                if ($scope.selectedLocation != null) {
                    $scope.loadTopology($scope.selectedLocation);
                }
                $("#container").jstree(true).set_id(data.node.id, 'j-' + 'l' + data.node.original.lid)
                $scope.mytree.currentNode.children = data.node.children;
                var treeObj = JSON.parse(localStorage.getItem('state_demo'));
                console.log(treeObj, "treeObj");
                console.log("parentData location", data.node.parents);
                $localStorage.lastSelected = data.node.parents;
                // $localStorage.lastSelected.push(data.node.id);
                console.log("in location");
                $localStorage.isExpand = true;
                //$scope.prepareMap();
                $scope.facilitycountarr = [];
                if ($scope.maprefresh) {
                    var url = 'api/v2/treeview/clust/location/' + data.node.original.lid;
                    $http.get(url).then((response) => {
                        if (response.data) {
                            if (response.data.location[0].facility.length > 0) {
                                var facdata = response.data.location[0].facility;
                                for (var m = 0; m < facdata.length; m++) {
                                    if (!facdata[m].lat) {
                                        facdata[m].lat = 0;
                                        facdata[m].long = 0;
                                    }
                                    var lat = facdata[m].lat
                                    var long = facdata[m].long;
                                    var total = facdata[m].total;
                                    lat = lat;
                                    lat = lat != 0 ? lat.replace(/[^\d.-]/g, '') : lat;
                                    long = long;
                                    long = long != 0 ? long.replace(/[^\d.-]/g, '') : long;
                                    var mapobj = {
                                        lat: lat,
                                        long: long,
                                        down: total,
                                        title:facdata[m].name
                                    }
                                    $scope.facilitycountarr.push(mapobj);
                                }
                                if ($scope.facilitycountarr.length > 0) {
                                    $scope.countStat = true;
                                    setTimeout(function () { initMaps($scope.facilitycountarr); }, 20);
                                }
                            } else {
                                var lat = response.data.location[0].lat
                                var long = response.data.location[0].long;
                                var total = response.data.location[0].total;
                                lat = lat;
                                lat = lat != 0 ? lat.replace(/[^\d.-]/g, '') : lat;
                                long = long;
                                long = long != 0 ? long.replace(/[^\d.-]/g, '') : long;
                                var mapobj = [{
                                    lat: lat,
                                    long: long,
                                    down: total,
                                    title:response.data.location[0].name
                                }]
                                if (mapobj[0].down > 0) {
                                    $scope.countStat = true;
                                    initMaps(mapobj);
                                }
                            }
                        }
                    });
                }
            }
            else if (data.node.original.type == 'facility') {
                $scope.selectedlevel = '';
                $scope.chartGrid = false;
                $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
                if($scope.slectednode.length>0){
                    if($scope.slectednode[0].original.type=="node"){
                        $scope.mapchartshow=true;
                        $scope.chartGrid = true;
                        $scope.mapDynamicHeight = "width:100%;height:60vh;position:relative;overflow:hidden";
                    }
                }
                if ($scope.maprefresh) {
                    $scope.clearMarkers(); //new
                }
                $("#container").jstree(true).set_id(data.node.id, 'j-' + 'f' + data.node.original.fid)
                $scope.mytree.currentNode.children = data.node.children;
                var treeObj = JSON.parse(localStorage.getItem('state_demo'));
                console.log(treeObj, "treeObj");

                console.log("parentData facility", data.node.parents);
                $localStorage.lastSelected = data.node.parents;
                //$localStorage.lastSelected.push(data.node.id);
                $localStorage.isExpand = true;
                //$scope.prepareMap();
                $scope.viewMode = "Devices";
                // if ($localStorage.selectedradiomode == 'all') {
                //     data.node.children= $scope.facilityobj;
                // }
                // if ($localStorage.selectedradiomode == 'ap') {
                //     data.node.children= $scope.facilityapobj;
                // }
                // if ($localStorage.selectedradiomode == 'su') {
                //     data.node.children= $scope.facilitysuobj;
                // }
                $scope.loadFacilityNodes(data.node.original.fid).then(function (data1) {
                    $scope.currentSelectedFacility = data.node.original.fid;
                    if ($scope.maprefresh) {
                        $scope.clearMarkers(); //new
                        $scope.showLinksOnMap(data1) //new
                    }
                    //$scope.mytree.currentNode.children = data;
                    if (data1.length > 0) {
                        $scope.isEnable = true;
                        $scope.nodeID = data1[0].data.id;
                    }
                });
                $scope.selectedLocation = data.node.parent.substring(3);
                if ($scope.selectedLocation != null) {
                    $scope.loadTopology($scope.selectedLocation);
                }
            }
            else if (data.node.original.nid) {
                if(data.node.original.datas.mode!='tmarc'){
                    $scope.selectedlevel = 'node';
                    $state.params.nodeId = data.node.original.nid;
                    if ($scope.mapchartshow) {
                        $scope.chartGrid = true;
                        if ($scope.device_throughput_config) {
                            for (i = 0; i < $scope.arrayLimit; i++) {
                                if (i % 20 == 0) {
                                    // Generate the Labels (at each minute)
                                    $scope.device_throughput_config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                                } else {
                                    // Empty Labels at rest of the places
                                    $scope.device_throughput_config.data.labels[i] = "";
                                }
                                // Null values
                                $scope.device_throughput_config.data.datasets[0].data[i] = null;
                                $scope.device_throughput_config.data.datasets[1].data[i] = null;
                                $scope.device_throughput_config.data.datasets[2].data[i] = null;
                            }
                        }
                        $scope.mapDynamicHeight = "width:100%;height:60vh;position:relative;overflow:hidden";
                    } else {
                        $scope.chartGrid = false;
                        $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
                    }
                if($scope.slectednode.length>0){
                    if($scope.slectednode[0].original.type=="node"){
                        $scope.mapchartshow=true;
                        $scope.chartGrid = true;
                        $scope.mapDynamicHeight = "width:100%;height:60vh;position:relative;overflow:hidden";
                    }
                }
                    $("#container").jstree(true).set_id(data.node.id, 'j-' + 'n' + data.node.original.nid)
                    $localStorage.isExpand = true;
                    //$scope.prepareMap();
                    var id = data.node.original.nid;
                    console.log("parentData node", data.node.parents);
                    $localStorage.lastSelected = data.node.parents;
                    //$localStorage.lastSelected.push(data.node.id);
                     $scope.bounds = new google.maps.LatLngBounds();
                    var marker = $scope.markerHashMap.get(id);
                    if (marker) {
                        $scope.bounds.extend(marker.position);
                    }
                    $scope.map.fitBounds($scope.bounds);
                    if($scope.linkviewvisibility){
                        if ($scope.systemOnline) {
                            //$scope.clearMarkers();
                            //$scope.linkVertexPaths = [];

                            var url = 'api/v2/nodelinks/linkstats?nodeId=' + id;
                            $scope.nodeLinks = [];
                            $http.get(url)
                                .then(function (response) {
                                    if (response.data) {
                                        $scope.nodeLinks = response.data.links;
                                        if ($scope.nodeLinks.length > 0) {
                                            for (var l = 0; l < $scope.nodeLinks.length; l++) {
                                                if ($scope.nodeLinks[l].distance == null) {
                                                    $scope.nodeLinks[l].distance = 0;
                                                }
                                            }
                                        }
                                        $scope.setMapOnSingleMarker(id);
                                    }
                                });
                        }
                    }
                }else{
                     $scope.chartGrid = false;
                      $scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden";
//                         if($scope.linkviewvisibility){
//                              if ($scope.systemOnline) {
//                                  //$scope.clearMarkers();
//                                  //$scope.linkVertexPaths = [];
//                                   var id = data.node.original.nid;
//                                  var url = 'api/v2/nodelinks/linkstats?nodeId=' + id;
//                                  $scope.nodeLinks = [];
//                                  $http.get(url)
//                                      .then(function (response) {
//                                          if (response.data) {
//                                              $scope.nodeLinks = response.data.links;
//                                              if ($scope.nodeLinks.length > 0) {
//                                                  for (var l = 0; l < $scope.nodeLinks.length; l++) {
//                                                      if ($scope.nodeLinks[l].distance == null) {
//                                                          $scope.nodeLinks[l].distance = 0;
//                                                      }
//                                                  }
//                                              }
//                                              $scope.setMapOnSingleMarker(id);
//                                          }
//                                      });
//                              }
//                      }
                }
            }
        }

        var circles = [];
        function initMaps(mapobjarr) {
            //debugger
            // if($scope.markers==undefined){
            $scope.markers = [];
            //}
            // var pos = new google.maps.LatLng(parseFloat(mapobjarr[0].lat), parseFloat(mapobjarr[0].long));
            // var myOptions = {
            //     zoom: 15,
            //     center: pos
            // };
            /*if (!$scope.map) {
                $scope.map = new google.maps.Map(document.getElementById('map'), { streetViewControl: false });
            }*/

            $scope.boundsmap = new google.maps.LatLngBounds();
            for (var k = 0; k < mapobjarr.length; k++) {
                $scope.boundsmap.extend(new google.maps.LatLng(parseFloat(mapobjarr[k].lat), parseFloat(mapobjarr[k].long)));
                $scope.map.fitBounds($scope.boundsmap);
            }

            for (var k = 0; k < mapobjarr.length; k++) {
                var mapobj = mapobjarr[k];
                if (mapobj.down > 0) {
                    var txt = mapobj.down.toString();
                    var markerA = new google.maps.Marker({
                        position: new google.maps.LatLng(parseFloat(mapobj.lat), parseFloat(mapobj.long)),
                        title:mapobj.title,
                        label: {
                            text: txt,
                            color: "white",
                            fontSize:"24px",
                            fontWeight:"bold",
                            fontFamily:"Roboto"
                        },
                        icon: {
                            url: 'data:image/svg+xml;charset=utf-8,' +
                                encodeURIComponent('<svg viewBox="0 0 220 220" xmlns="http://www.w3.org/2000/svg"><circle cx="110" cy="110" r="100" stroke="black" fill="blue" fill-opacity="1.0" stroke-width="1" /></svg>'),
                            size: new google.maps.Size(40, 40),
                            scaledSize: new google.maps.Size(40,40),
                            anchor: new google.maps.Point(16, 16),
                            labelOrigin: new google.maps.Point(20, 20)
                        },
//                        label: {
//                            text: txt,
//                            color: "white"
//                        },
//                        icon: {
//                            url: 'data:image/svg+xml;charset=utf-8,' +
//                                encodeURIComponent('<svg viewBox="0 0 220 220" xmlns="http://www.w3.org/2000/svg"><circle cx="110" cy="110" r="100" stroke="black" fill="rgb(29, 43, 82)" fill-opacity="1.0" stroke-width="1" /></svg>'),
//                            size: new google.maps.Size(32, 32),
//                            scaledSize: new google.maps.Size(32, 32),
//                            anchor: new google.maps.Point(16, 16),
//                            labelOrigin: new google.maps.Point(16, 16)
//                        },
                        optimized: false,
                        map: $scope.map
                    });
                    $scope.markers.push(markerA);
                }
            }
        }


        $scope.showmodalcontent = false; // Quick Edit Display
        $scope.colclass = "col-md-9"; // Map & Charts/Counters Container Class

        // Quick Edit Start
        // To Open Quick Edit
        $scope.showmodal = function () {
            if ($scope.isEnable) {
                $scope.showmodalcontent = true;
                $scope.colclass = "col-md-6";
            }
        }

        // To close Quick Edit
        $scope.hidemodal = function () {
            $scope.showmodalcontent = false;
            $scope.colclass = "col-md-9";
        }

        // Get System data in Quick Edit
        $scope.system = function () {
            //
            $scope.addrType = [{
                "addressType": "dhcp",
                "addressesVal": "Dynamic"
            }, {
                "addressType": "static",
                "addressesVal": "Static"
            }];
            $scope.vlanStatus = [{
                "vlanStatus": 1,
                "vlanStatusVal": "Enable"
            }, {
                "vlanStatus": 2,
                "vlanStatusVal": "Disable"
            }];
            $scope.vlanMode = [{
                "vlanMode": 0,
                "vlanModeVal": "Transparent"
            }];
            var url = 'api/v2/nodenetview/quicksystem?nodeId=' + $scope.nodeID;
            $http.get(url, {
                //showdiv: false
            })
                .then(function (response) {
                    if (response.data) {
                        $scope.systemData = response.data;
                        $scope.systemData.addr = {
                            addressType: $scope.systemData.ipConfig.addressType
                        }
                        $scope.systemData.vlanStat = {
                            vlanStatus: $scope.systemData.vlan.vlanStatus
                        }
                        $scope.systemData.vlanMod = {
                            vlanMode: $scope.systemData.vlan.vlanMode
                        }
                    }
                });
        }

        // Get Location data in Quick Edit
        $scope.location = function () {
            var url = 'api/v2/nodemanageview/quicklocation?nodeId=' + $scope.nodeID;
            $http.get(url, {
                //showdiv: false
            })
                .then(function (response) {
                    if (response.data) {
                        $scope.locationData = response.data;
                    }
                });

        }

        // Get 5GHz Radio data in Quick Edit
        $scope.oneghz = function () {
            $scope.radiomode = [{
                "radioMode": 'ap',
                "rmodeVal": "Outdoor Base"
            }, {
                "radioMode": 'sta',
                "rmodeVal": "Outdoor Subscriber"
            }];
            //$scope.country = [{ "countryCode": 5018, "countryName": "INDIA" }];
            $scope.country = [{
                "countryCode": 5018,
                "countryName": "INDIA"
            },
            {
                "countryCode": 5019,
                "countryName": "5Ghz"
            },
            {
                "countryCode": 5011,
                "countryName": "US"
            }
            ];
            $scope.operationalMode = [{
                "opMode": "11ac"
            }, {
                "opMode": "11nc"
            }];
            $scope.bw = [{
                "bandWIdthID": "HT40",
                "bandWidth": "40Mhz"
            }, {
                "bandWIdthID": "HT20",
                "bandWidth": "20Mhz"
            }, {
                "bandWIdthID": "HT80",
                "bandWidth": "80Mhz"
            }];
            $scope.channel_one = [];
            $scope.val = 5105;
            for (var i = 22; i < 184; i++) {
                $scope.val = $scope.val + 5;
                $scope.mhzval = $scope.val + 'MHZ';
                $scope.channel_one.push({
                    "chnnl": i,
                    "channelVal": i + '(' + $scope.mhzval + ')'
                });
            }
            $scope.channel_one.unshift({
                "chnnl": 0,
                "channelVal": 'auto'
            })
            var url = 'api/v2/nodewirelessview/quickfiveg?nodeId=' + $scope.nodeID;
            $http.get(url, {
                //showdiv: false
            })
                .then(function (response) {
                    if (response.data) {
                        $scope.wireLessData = response.data;
                        if ($scope.wireLessData.channel == 'auto') {
                            $scope.wireLessData.channel = 0;
                        }
                        $scope.wireLessData.chnnl = {
                            channelVal: $scope.wireLessData.channel
                        }
                        $scope.wireLessData.mode = {
                            opMode: $scope.wireLessData.opMode
                        }
                        $scope.wireLessData.countries = {
                            countryCode: $scope.wireLessData.country
                        }
                        $scope.wireLessData.bndwdt = {
                            bandWIdthID: $scope.wireLessData.bandwidth
                        }
                        $scope.wireLessData.rMode = {
                            radioMode: $scope.wireLessData.radioMode
                        }
                    }
                });
        }

        // Get 2.4GHz Radio data in Quick Edit
        $scope.twoghz = function () {
            $scope.radiomode2 = [{
                "radioMode": 'ap',
                "rmodeVal": "Access Point"
            }, {
                "radioMode": 'sta',
                "rmodeVal": "Client"
            }];
            $scope.country2 = [{
                "countryCode": 5018,
                "countryName": "INDIA"
            },
            {
                "countryCode": 5019,
                "countryName": "5Ghz"
            },
            {
                "countryCode": 5011,
                "countryName": "US"
            }
            ];
            //$scope.country2 = [{ "countryCode": 643, "countryName": "INDIA" }];
            $scope.operationalMode = [{
                "opMode": "11ac"
            }, {
                "opMode": "11nc"
            }];
            $scope.bw = [{
                "bandWIdthID": "HT40",
                "bandWidth": "40MHZ"
            }, {
                "bandWIdthID": "HT20",
                "bandWidth": "20MHZ"
            }, {
                "bandWIdthID": "HT80",
                "bandWidth": "80MHZ"
            }];
            $scope.channel_two = [];
            $scope.val = 2137;
            for (var i = 1; i < 14; i++) {
                $scope.val = $scope.val + 5;
                $scope.mhzval = $scope.val + 'MHZ';
                $scope.channel_two.push({
                    "channel": i,
                    "channelVal": i + '(' + $scope.mhzval + ')'
                });
            }
            $scope.channel_two.unshift({
                "channel": 0,
                "channelVal": 'auto'
            })
            var url = 'api/v2/nodewirelessview/quicktwog?nodeId=' + $scope.nodeID;
            $http.get(url, {
                //showdiv: false
            })
                .then(function (response) {

                    if (response.data) {
                        $scope.wireLess_Data = response.data;
                        if ($scope.wireLess_Data.country == '643') {
                            $scope.wireLess_Data.countryCD = 'INDIA';
                        }
                        $scope.wireLess_Data.chnnl = {
                            channelVal: $scope.wireLess_Data.channel
                        }
                        $scope.wireLess_Data.bndwdt = {
                            bandWIdthID: $scope.wireLess_Data.bandwidth
                        }
                        if ($scope.wireLess_Data.radioMode == 'ap') {
                            $scope.wireLess_Data.radioMode = 'Access Point'
                        } else {
                            $scope.wireLess_Data.radioMode = 'Client'
                        }

                    }
                });
        }

        // Save changes of System in Quick Edit
        $scope.saveSystemData = function () {
            var dataObjSystemConfig = {
                "radio": $scope.systemData.radio,
                "nodeId": $scope.nodeID,
                "status": $scope.systemData.status,
                "message": $scope.systemData.message,
                "ipConfig": {
                    "radio": $scope.systemData.ipConfig.radio,
                    "nodeId": $scope.systemData.ipConfig.nodeId,
                    "status": $scope.systemData.ipConfig.status,
                    "message": $scope.systemData.ipConfig.message,
                    "addressType": $scope.systemData.addr.addressType,
                    "ipAddress": $scope.systemData.ipConfig.ipAddress,
                    "netMask": $scope.systemData.ipConfig.netMask,
                    "gateway": $scope.systemData.ipConfig.gateway,
                    "dnsIP": $scope.systemData.ipConfig.dnsIP,
                    "clearStats": $scope.systemData.ipConfig.clearStats,
                    "mode": $scope.systemData.ipConfig.mode,
                    "natStatus": $scope.systemData.ipConfig.natStatus,
                    "wirelessIpAddress": $scope.systemData.ipConfig.wirelessIpAddress,
                    "wirelessNetMask": $scope.systemData.ipConfig.wirelessNetMask
                },
                "vlan": {
                    "radio": $scope.systemData.vlan.radio,
                    "nodeId": $scope.systemData.vlan.nodeId,
                    "status": $scope.systemData.vlan.status,
                    "message": $scope.systemData.vlan.message,
                    "vlanStatus": $scope.systemData.vlanStat.vlanStatus,
                    "vlanMode": $scope.systemData.vlanMod.vlanMode,
                    "vlanMgmtId": $scope.systemData.vlan.vlanMgmtId,
                    "vlanAccessId": $scope.systemData.vlan.vlanAccessId,
                    "vlanTrunkOptionId": $scope.systemData.vlan.vlanTrunkOptionId,
                    "vlanTrunkId": $scope.systemData.vlan.vlanTrunkId,
                    "vlanSvlanId": $scope.systemData.vlan.vlanSvlanId,
                    "vlanEtherType": $scope.systemData.vlan.vlanEtherType,
                    "vlanBackboneDestMAC": $scope.systemData.vlan.vlanBackboneDestMAC,
                    "vlanBackboneSrcMAC": $scope.systemData.vlan.vlanBackboneSrcMAC,
                    "vlanBackboneVlanId": $scope.systemData.vlan.vlanBackboneVlanId,
                    "vlanBackboneSrvInstanceVlanId": $scope.systemData.vlan.vlanBackboneSrvInstanceVlanId
                }
            }


            $http({
                method: 'POST',
                url: 'api/v2/nodenetview/quicksavesystem',
                headers: {
                    'Content-Type': 'application/json'
                },
                data: dataObjSystemConfig
            }).success(function () {
                $scope.showAlert('Success', 'Saved successfully.');
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating Data: ' + msg);
            });
        }



        // Save Changes of Location in Quick Edit
        $scope.saveLocationData = function () {
            var dataObjLocation = {
                "nodeId": $scope.nodeID,
                "custName": $scope.locationData.custName,
                "custLocation": $scope.locationData.custLocation,
                "custEmail": $scope.locationData.custEmail,
                "custPhone": $scope.locationData.custPhone,
                "baseStationId": $scope.locationData.baseStationId,
                "latitude": $scope.locationData.latitude,
                "longitude": $scope.locationData.longitude,
                "linkId": $scope.locationData.linkId
            }

            $http({
                method: 'POST',
                url: 'api/v2/nodemanageview/savequicklocation',
                headers: {
                    'Content-Type': 'application/json'
                },
                data: dataObjLocation
            }).success(function () {
                $scope.showAlert('Success', 'Saved successfully.');
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating Data: ' + msg);
            });
        }

        // Save Changes of 5GHz Radio in Quick Edit
        $scope.save5ghData = function () {
            var dataobj = {
                "radio": $scope.wireLessData.radio,
                "nodeId": $scope.nodeID,
                "status": $scope.wireLessData.status,
                "radioMode": $scope.wireLessData.rMode.radioMode,
                "ssid": $scope.wireLessData.ssid,
                "country": $scope.wireLessData.countries.countryCode,
                "opMode": $scope.wireLessData.mode.opMode,
                "bandwidth": $scope.wireLessData.bndwdt.bandWIdthID,
                "channel": $scope.wireLessData.chnnl.channel
            }
            $http({
                method: 'POST',
                url: 'api/v2/nodewirelessview/quicksavefiveg',
                headers: {
                    'Content-Type': 'application/json'
                },
                data: dataobj
            }).success(function () {
                $scope.showAlert('Success', 'Saved successfully.');
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating Data: ' + msg);
            });
        }

        // Save Changes of 2.4GHz Radio in Quick Edit
        $scope.save2ghzData = function () {
            var dataObj2ghz = {
                "radio": $scope.wireLess_Data.radio,
                "nodeId": $scope.nodeID,
                "status": $scope.wireLess_Data.status,
                "radioMode": "ap",
                "ssid": $scope.wireLess_Data.ssid,
                "country": $scope.wireLess_Data.country,
                "opMode": $scope.wireLess_Data.opMode,
                "bandwidth": $scope.wireLess_Data.bndwdt.bandWIdthID,
                "channel": $scope.wireLess_Data.chnnl.channelVal
            }

            $http({
                method: 'POST',
                url: 'api/v2/nodewirelessview/quicksavetwog',
                headers: {
                    'Content-Type': 'application/json'
                },
                data: dataObj2ghz
            }).success(function () {
                $scope.showAlert('Success', 'Saved successfully.');
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating Data: ' + msg);
            });
        }

        // Tree View Node Id
        $scope.treeid = function (data, id, cc, ss) { }
        // Quick Edit End

        // Charts And Table Start
        // Set values
        $scope.intervalTime = 3000; // Chart Interval Time in milliseconds
        $scope.arrayLimit = 61; // Chart data array limit

        $scope.networkstatusTimer = 30000;

        // Device Chart Stop timer
        $scope.stopDeviceTimer = function () {
            if (angular.isDefined($scope.deviceDataTimer)) {
                $interval.cancel($scope.deviceDataTimer);
            }
        }
        function deviceData() {
            $scope.deviceDataTimer = $interval(function () {
                $scope.addDeviceData()
            }, $scope.intervalTime);
        }
        // Device Charts & Tables Generation when clicked on node in Tree View
        $scope.device_init = function () {

            // Device Throughput Chart Configuration
            $scope.device_throughput_config = {
                type: 'line',
                data: {
                    labels: [],
                    datasets: [{
                        label: 'Transmit Rate',
                        backgroundColor: 'rgba(0,255,255,0.5)',
                        borderColor: 'rgba(0,255,255,0.5)',
                        fill: 'origin',
                        pointRadius: 2,
                        pointHitRadius: 10,
                        data: []
                    }, {
                        label: 'Receive Rate',
                        backgroundColor: 'rgba(0,166,255,0.5)',
                        borderColor: 'rgba(0,166,255,0.5)',
                        fill: 'origin',
                        pointRadius: 2,
                        pointHitRadius: 10,
                        data: []
                    }, {
                        label: 'Total Rate',
                        backgroundColor: 'rgba(102,51,153,0.5)',
                        borderColor: 'rgba(102,51,153,0.5)',
                        fill: 'origin',
                        pointRadius: 2,
                        pointHitRadius: 10,
                        data: []
                    }]
                },
                options: {
                    title: {
                        display: true,
                        text: "Throughput (in Mbps)"
                    },
                    animation: {
                        duration: 0
                    },
                    hover: {
                        animationDuration: 0
                    },
                    responsiveAnimationDuration: 0,
                    maintainAspectRatio: false,
                    legend: {
                        display: true,
                        position: 'top',
                        labels: {
                            boxWidth: 12
                        }
                    },
                    showLines: true,
                    scales: {
                        yAxes: [{
                            display: true,
                            ticks: {
                                beginAtZero: true
                            }
                        }],
                    },
                    elements: {
                        line: {
                            tension: 0
                        }
                    }
                }
            };

 // Creating a Empty chart config for a new device
            if (angular.isDefined($scope.deviceDataTimer)) {
                $interval.cancel($scope.deviceDataTimer); // Stop any Old Timer
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        $scope.device_throughput_config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                    } else {
                        $scope.device_throughput_config.data.labels[i] = "";
                    }
                    $scope.device_throughput_config.data.datasets[0].data[i] = null;
                    $scope.device_throughput_config.data.datasets[1].data[i] = null;
                    $scope.device_throughput_config.data.datasets[2].data[i] = null;
                }
            }

            // Initialize the Device Charts Config null data to display window on start
            for (i = 0; i < $scope.arrayLimit; i++) {
                if (i % 20 == 0) {
                    // Generate the Labels (at each minute)
                    $scope.device_throughput_config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                } else {
                    // Empty Labels at rest of the places
                    $scope.device_throughput_config.data.labels[i] = "";
                }
                // Null values
                $scope.device_throughput_config.data.datasets[0].data[i] = null;
                $scope.device_throughput_config.data.datasets[1].data[i] = null;
                $scope.device_throughput_config.data.datasets[2].data[i] = null;
            }

            // Init Device Charts
            // Throughput Chart
            var device_throughput_ctx = document.getElementById("device_throughput_chart").getContext("2d");
            var deviceThroughputChart = new Chart(device_throughput_ctx, $scope.device_throughput_config);


            // Default Device Data Call
            deviceData();
            // Device Chart Timer


            // Device Chart Destroy timer
            $scope.$on('$destroy', function () {
                $scope.stopDeviceTimer();
                $scope.stopNetworkViewTimer();
            });



            // Get new device data & update the chart config
            $scope.addDeviceData = function () {
                $scope.devMode = $state.params.mode;
                // Wireless Api
                $http.get('api/v2/nodelinks/wirelessstats?nodeId=' + $state.params.nodeId, {
                    showdiv: false
                }).then(function (response) {
                    // Check and remove oldest data from Array if it reaches the defined arrayLimit
                    if ($scope.device_throughput_config.data.datasets[0].data.length >= $scope.arrayLimit) {
                        $scope.device_throughput_config.data.datasets[0].data.splice(0, 1);
                        $scope.device_throughput_config.data.datasets[1].data.splice(0, 1);
                        $scope.device_throughput_config.data.datasets[2].data.splice(0, 1);
                    }
                    // Bind new data from response to the chart configs
                    $scope.wireless_data = response.data;
                    $scope.device_throughput_config.data.datasets[0].data.push(response.data.txThroughput);
                    $scope.device_throughput_config.data.datasets[1].data.push(response.data.rxThroughtput);
                    $scope.device_throughput_config.data.datasets[2].data.push(parseFloat(response.data.txThroughput) + parseFloat(response.data.rxThroughtput));
                    // Update the charts
                    deviceThroughputChart.update();
                });
                // Usage API

            }
        }

        // To null the data in Chart Config data
        function nullConfigData() {
            // Initialize the Device Charts Config null data to display window on start
            for (i = 0; i < $scope.arrayLimit; i++) {
                if (i % 20 == 0) {
                    $scope.device_throughput_config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                } else {
                    $scope.device_throughput_config.data.labels[i] = "";
                }
                $scope.device_throughput_config.data.datasets[0].data[i] = null;
                $scope.device_throughput_config.data.datasets[1].data[i] = null;
                $scope.device_throughput_config.data.datasets[2].data[i] = null;
            }
        }
        // Charts and Table End

        // Show Alert function for controller
        $scope.showAlert = function (msgType, msg, ev) {
            $mdDialog.show(
                $mdDialog.alert()
                    .parent(angular.element(document.querySelector('#popupContainer')))
                    .clickOutsideToClose(true)
                    .title(msgType)
                    .textContent(msg)
                    .ariaLabel('Alert')
                    .ok('OK')
                    .targetEvent(ev)
            );
        };

        $scope.saveconfirm = function (msg, ev) {
            var confirm = $mdDialog.confirm()
                .title(msg)
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')


            return confirm;
        };

        $scope.saveconfirmfacility = function (msg, ev) {
            var confirm = $mdDialog.confirm()
                .title(msg)
                .targetEvent(ev)
                .ok('Ok')


            return confirm;
        };

        $scope.changeSystemIpFun = function () {
            $localStorage.showtopology = $scope.showsystemIP;
            if ($scope.showsystemIP == 'ip') {
                if ($rootScope.iparray.length > 0) {
                    for (var k = 0; k < $rootScope.iparray.length; k++) {
                        $rootScope.iparray[k].showtabname = $rootScope.iparray[k].ip;
                    }
                }
            } else {
                if ($rootScope.iparray.length > 0) {
                    for (var k = 0; k < $rootScope.iparray.length; k++) {
                        $rootScope.iparray[k].showtabname = $rootScope.iparray[k].system;
                    }
                }
            }
            $localStorage.iparray = $rootScope.iparray;
            $scope.maprefresh = false;
            $scope.slectednode = $("#container").jstree("get_selected", true);
            // if($scope.slectednode[0].state.opened){
            //     $scope.slectednode[0].state.opened=false;
            // }
            // else{
            //     $scope.slectednode[0].state.opened=true;
            // }
            if ($scope.slectednode.length > 0) {
                $scope.slectednode[0].state.opened = false;
                console.log("selected node", $scope.slectednode);
            }
            $('#container').jstree(true).refresh();
            if ($scope.selectedlevel == "node") {
                $scope.mapchartshow=true;
                $scope.chartGrid = true;
                $scope.mapDynamicHeight = "width:100%;height:60vh;position:relative;overflow:hidden";
            }else if($scope.slectednode[0].original.type=="node"){
                $scope.mapchartshow=true;
                $scope.chartGrid = true;
                $scope.mapDynamicHeight = "width:100%;height:60vh;position:relative;overflow:hidden";
            }

            // setTimeout(function () {
            //     $('#container').jstree(true).open_node($scope.slectednode[0].id);
            // }, 500);

            //    var selected = $('#container').jstree(true).get_selected($localStorage.lastSelected[0]);
            //     console.log("last selected",selected);
            //     $('#container').jstree(true).refresh_node(selected[0].parent);
            // alert("radioi"+$scope.showsystemIP);
        }

    }
]);

dashboard.filter('showProductType', function () {
    return function (item) {
        if (item == undefined) {
            return 'Unknown';
        } else if (item === 'indoorap' || item === 'outdoorap') {
            return 'Access Point';
        } else {
            return item.toUpperCase();
        }
    }
});


dashboard.directive('showtab',
    function () {
        return {
            link: function (scope, element, attrs) {
                element.click(function (e) {
                    e.preventDefault();
                    $(element).tab('show');
                });
            }
        };
    });
