dashboard.controller("NodeLinkDetailsController", ['$localStorage', '$rootScope', '$scope', '$mdDialog', '$http', '$state', 'dashboardService', 'Flash', '$interval',
    function ($localStorage, $rootScope, $scope, $mdDialog, $http, $state, dashboardService, Flash, $interval) {
        $scope.tableStyle = "height:80vh;overflow-y:auto";
        $scope.duration = "1h";
        $scope.cpuduration = "1h";
        $scope.memduration = "1h";
        $scope.temduration = "1h";
        $scope.disduration = "1h";
        $scope.liveGraph = [true, true, true, true, true, true, true, true];
        $scope.liveGraphDuration = ['', '', '', ''];
        $scope.selectedGraph = ['lrssi', 'rrssi', 'lsnr', 'rsnr'];
        $scope.remainingGrap = ['util', 'err', 'channel'];
        $scope.graphChartConfig = [null, null, null, null, null, null, null, null];
        $scope.chartMap = {};

        $scope.backlinkstat = function () {
            $rootScope.$emit("calllinkstatistics", {});                      
        }

        $scope.selectGraph = [{
            "val": "Local RSSI",
            "id": "lrssi"

        }, {
            "val": "Remote RSSI",
            "id": "rrssi"

        }, {
            "val": "Local SNR",
            "id": "lsnr"
        }, {
            "val": "Remote SNR",
            "id": "rsnr"
        },
        {
            "val": "MCS",
            "id": "mcs"
        },
        {
            "val": "Utilization",
            "id": "util"
        },
        {
            "val": "Bit err",
            "id": "err"
        },
        {
            "val": "Channel Change",
            "id": "cha"
        },
        {
            "val": "Noise",
            "id": "nois"
        },
        ];

        $scope.intervalTime = 3000; // Chart Interval Time in milliseconds
        $scope.arrayLimit = 61;     // Chart data array limit


        /*$scope.local_rssi_data = {};
        $scope.remote_rssi_data = {};
        $scope.link_snr_data = {};
    
        $scope.link_mcs_data = {};*/


        var link_char1 = null;
        var chatObj1 = null;

        var link_char2 = null;
        var chatObj2 = null;

        var link_char3 = null;
        var chatObj3 = null;

        var link_char4 = null;
        var chatObj4 = null;

        var link_char5 = null;
        var chatObj5 = null;

        var link_char6 = null;
        var chatObj6 = null;

        var link_char7 = null;
        var chatObj7 = null;

        var link_char8 = null;
        var chatObj8 = null;

        $scope.macaddress = '';

        $scope.localMode = '';

        $scope.remoteMode = '';

        $scope.remoteIP = '';

        $scope.init = function () {

            var nodeid = $state.params.nodeId;
            $scope.macaddress = $rootScope.macaddress.replace(/:/g, "");
            $scope.macaddress = $scope.macaddress.toLowerCase();
            $scope.localMode = $rootScope.localMode;
            $scope.remoteMode = $rootScope.remoteMode;
            $scope.lerssi = $rootScope.lerssi;
            $scope.rerssi = $rootScope.rerssi;
            console.log("node id" + nodeid);
            console.log("macaddress" + $scope.macaddress);
            $scope.graph1Model = $scope.selectGraph[0];
            $scope.graph2Model = $scope.selectGraph[1];
            $scope.graph3Model = $scope.selectGraph[2];
            $scope.graph4Model = $scope.selectGraph[3];
            //$scope.selectedGraph = ['lrssi','rrssi','lsnr','mcs'];
            $scope.chartMap['lrssi'] = 'lsiga1,lsiga2';
            $scope.chartMap['rrssi'] = 'rsiga1,rsiga2';
            $scope.chartMap['lsnr'] = 'lsnra1,lsnra2';
            $scope.chartMap['rsnr'] = 'rsnra1,rsnra2';
            $scope.chartMap['mcs'] = 'lmcs,rmcs';
            $scope.chartMap['util'] = 'in,out';
            $scope.chartMap['err'] = 'lerr,rerr';
            $scope.chartMap['nois'] = 'lnoise,rnoise';
            $scope.chartMap['cha'] = 'channel';
            $scope.remoteIP = $rootScope.rip;
            initGraph();
            $scope.graphEvent4('lrssi', 3, 1)
        }

        // graphs configuraion declaration
        $scope.local_rssi_chart_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'A1',
                    backgroundColor: 'rgba(26,108,140,1)',
                    borderColor: 'rgba(26,108,140,0.4)',
                    fill: false,
                    pointRadius: 0,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'A2',
                    backgroundColor: 'rgba(60,37,74,1)',
                    borderColor: 'rgba(60,37,74,0.4)',
                    fill: false,
                    pointRadius: 0,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'Estimated',
                    backgroundColor: 'rgba(65,59,147,1)',
                    borderColor: 'rgba(65,59,147,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: false, text: "Local RSSI" },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'top',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        gridLines: {
                            display: false
                        },
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'Local RSSI',
                            fontStyle: 'bold'
                        },
                        display: true,
                        ticks: {
                            beginAtZero: true,
                            /*min: -100*/
                        }

                    }],
                },
                elements: {
                    line: { tension: 0 }
                }
            }
        };

        // Wireless Packets Chart Configuration
        $scope.remote_rssi_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'A1',
                    backgroundColor: 'rgba(26,108,140,1)',
                    borderColor: 'rgba(26,108,140,0.4)',
                    fill: false,
                    pointRadius: 0,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'A2',
                    backgroundColor: 'rgba(60,37,74,1)',
                    borderColor: 'rgba(60,37,74,0.4)',
                    fill: false,
                    pointRadius: 0,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'Estimated',
                    backgroundColor: 'rgba(65,59,147,1)',
                    borderColor: 'rgba(65,59,147,0.4)',
                    fill: false,
                    pointRadius: 0,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: false, text: "Remote RSSI" },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'top',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'Remote RSSI',
                            fontStyle: 'bold'
                        },
                        display: true,
                        ticks: {
                            beginAtZero: true,
                            /*min: -100*/
                        }
                    }],
                },
                elements: {
                    line: { tension: 0 }
                }
            }

        };

        $scope.local_snr_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'A1',
                    backgroundColor: 'rgba(24,178,157,1)',
                    borderColor: 'rgba(24,178,157,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'A2',
                    backgroundColor: 'rgba(102,51,153,1)',
                    borderColor: 'rgba(102,51,153,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: false, text: "Local SNR" },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'top',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'Local SNR',
                            fontStyle: 'bold'
                        },
                        display: true,
                        ticks: { beginAtZero: true }
                    }],
                },
                elements: {
                    line: { tension: 0 }
                }
            }
        };

        $scope.remote_snr_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'A1',
                    backgroundColor: 'rgba(24,178,157,1)',
                    borderColor: 'rgba(24,178,157,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'A2',
                    backgroundColor: 'rgba(102,51,153,1)',
                    borderColor: 'rgba(102,51,153,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: false, text: "Remote SNR" },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'top',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'Remote SNR',
                            fontStyle: 'bold'
                        },
                        display: true,
                        ticks: { beginAtZero: true }
                    }],
                },
                elements: {
                    line: { tension: 0 }
                }
            }
        };


        $scope.link_mcs_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'local',
                    backgroundColor: 'rgba(24,178,157,1)',
                    borderColor: 'rgba(24,178,157,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'remote',
                    backgroundColor: 'rgba(102,51,153,1)',
                    borderColor: 'rgba(102,51,153,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: false, text: "MCS" },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'top',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'MCS',
                            fontStyle: 'bold'
                        },
                        display: true,
                        ticks: { beginAtZero: true }
                    }],
                },
                elements: {
                    line: { tension: 0 }
                }
            }
        };

        $scope.link_noise_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'local',
                    backgroundColor: 'rgba(24,178,157,1)',
                    borderColor: 'rgba(24,178,157,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'remote',
                    backgroundColor: 'rgba(102,51,153,1)',
                    borderColor: 'rgba(102,51,153,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: false, text: "Noise Floor" },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'top',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'Noise Floor',
                            fontStyle: 'bold'
                        },
                        display: true,
                        ticks: { beginAtZero: true }
                    }],
                },
                elements: {
                    line: { tension: 0 }
                }
            }
        };

        $scope.link_util_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'In',
                    backgroundColor: 'rgba(239,201,76,1)',
                    borderColor: 'rgba(239,201,76,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'Out',
                    backgroundColor: 'rgba(226,122,63,1)',
                    borderColor: 'rgba(226,122,63,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: false, text: "Utilization" },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'top',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'Utilization',
                            fontStyle: 'bold'
                        },
                        display: true,
                        ticks: { beginAtZero: true }
                    }],
                },
                elements: {
                    line: { tension: 0 }
                }
            }
        };

        $scope.link_err_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'local',
                    backgroundColor: 'rgba(24,178,157,1)',
                    borderColor: 'rgba(24,178,157,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'remote',
                    backgroundColor: 'rgba(102,51,153,1)',
                    borderColor: 'rgba(102,51,153,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: false, text: "Bit Err" },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'top',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'Bit Err',
                            fontStyle: 'bold'
                        },
                        display: true,
                        ticks: { beginAtZero: true }
                    }],
                },
                elements: {
                    line: { tension: 0 }
                }
            }
        };

        $scope.channel_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'Channel',
                    backgroundColor: 'rgba(198,33,108,1)',
                    borderColor: 'rgba(198,33,108,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: false, text: "Channel" },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'top',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        ticks: {
                            fontSize: 10
                        },
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'Channel',
                            fontStyle: 'bold'
                        },
                        display: true,
                        ticks: {
                            beginAtZero: true,
                            steps: 10,
                            stepValue: 10
                        }
                    }],
                },
                elements: {
                    line: { tension: 0 }
                }
            }
        };


        function initGraph() {
            initOtherGraphs();
            destoryNinitLinkGraph(true)
            liveLinkDataTimer();
        }

        function destoryNinitLinkGraph(live) {
            destroyNInitLocalRSSIGraph(live);
            destroyNInitRemoteRSSIGraph(live);
            destroyNInitLinkSNRGraph(live);
            destroyNInitRemoteSNRraph(live);
            destroyNInitMCSGraph(live);
            destroyNInitUtilGraph(live);
            destroyNInitErrGraph(live);
            destroyNInitChanGraph(live);
        }

        function liveLinkDataTimer() {
            $scope.liveLinkTimer = $interval(function () { $scope.liveLinkData() }, $scope.intervalTime);
        }

        $scope.$on('$destroy', function () {
            //                console.log("left node view");
            $scope.stopLinkDataTimer();
        });

        $scope.stopLinkDataTimer = function () {
            if (angular.isDefined($scope.liveLinkTimer)) {
                //                console.log("Stopping the timer");
                $interval.cancel($scope.liveLinkTimer);
            }
        }

        function initOtherGraphs() {
            link_char1 = document.getElementById("link_char1").getContext("2d");
            link_char2 = document.getElementById("link_char2").getContext("2d");
            link_char3 = document.getElementById("link_char3").getContext("2d");
            link_char4 = document.getElementById("link_char4").getContext("2d");
            link_char5 = document.getElementById("link_char5").getContext("2d");
            link_char6 = document.getElementById("link_char6").getContext("2d");
            link_char7 = document.getElementById("link_char7").getContext("2d");
            link_char8 = document.getElementById("link_char8").getContext("2d");
        }

        $scope.spliceData = function (config) {
            for (var i = 0; i < config.data.datasets.length; i++) {
                if (config.data.datasets[i].data.length >= $scope.arrayLimit) {
                    config.data.datasets[i].data.splice(0, 1);
                }
            }
        }

        $scope.pushLocalRSSILive = function (linkData) {
            $scope.local_rssi_chart_config.data.datasets[0].data.push(linkData[0].localSignalA1);
            $scope.local_rssi_chart_config.data.datasets[1].data.push(linkData[0].localSignalA2);
            $scope.local_rssi_chart_config.data.datasets[2].data.push($scope.lerssi);
        }

        $scope.pushRemoteRSSILive = function (linkData) {
            $scope.remote_rssi_config.data.datasets[0].data.push(linkData[0].remoteSignalA1);
            $scope.remote_rssi_config.data.datasets[1].data.push(linkData[0].remoteSignalA2);
            $scope.remote_rssi_config.data.datasets[2].data.push($scope.rerssi);
        }
        $scope.pushLocalSNRLive = function (linkData) {
            $scope.local_snr_config.data.datasets[0].data.push(linkData[0].localSNRA1);
            $scope.local_snr_config.data.datasets[1].data.push(linkData[0].localSNRA2);
        }

        $scope.pushRemoteSNRLive = function (linkData) {
            $scope.remote_snr_config.data.datasets[0].data.push(linkData[0].remoteSNRA1);
            $scope.remote_snr_config.data.datasets[1].data.push(linkData[0].remoteSNRA2);
        }
        $scope.pushMCSLive = function (linkData) {
            $scope.link_mcs_config.data.datasets[0].data.push(linkData[0].rateTx);
            $scope.link_mcs_config.data.datasets[1].data.push(linkData[0].rateRx);
        }

        $scope.pushUtilLive = function (linkData) {
            $scope.link_util_config.data.datasets[0].data.push(linkData[0].throughputIn);
            $scope.link_util_config.data.datasets[1].data.push(linkData[0].throughputOut);
        }
        $scope.pushErrLive = function (linkData) {
            $scope.link_err_config.data.datasets[0].data.push(linkData[0].localRTX);
            $scope.link_err_config.data.datasets[1].data.push(linkData[0].remoteRTX);
        }

        $scope.pushChannelLive = function (linkData) {
            $scope.channel_config.data.datasets[0].data.push(linkData[0].channel);
        }

        $scope.pushNoiseLive = function (linkData) {
            $scope.link_noise_config.data.datasets[0].data.push(linkData[0].lNoise);
            $scope.link_noise_config.data.datasets[1].data.push(linkData[0].rNoise);
        }


        $scope.pushLiveData = function (linkData) {
            $scope.pushLocalRSSILive(linkData);
            $scope.pushRemoteRSSILive(linkData);
            $scope.pushLocalSNRLive(linkData);
            $scope.pushRemoteSNRLive(linkData);
            $scope.pushMCSLive(linkData);
            $scope.pushUtilLive(linkData);
            $scope.pushErrLive(linkData);
            $scope.pushChannelLive(linkData);
            $scope.pushNoiseLive(linkData);
            /*if ($scope.graph1Model.id == 'lrssi' || $scope.graph2Model.id == 'lrssi' || $scope.graph3Model.id == 'lrssi' || $scope.graph4Model.id == 'lrssi') {
    
            }
            if ($scope.graph1Model.id == 'rrssi' || $scope.graph2Model.id == 'rrssi' || $scope.graph3Model.id == 'rrssi' || $scope.graph4Model.id == 'rrssi') {
    
            }
            if ($scope.graph1Model.id == 'lsnr' || $scope.graph2Model.id == 'lsnr' || $scope.graph3Model.id == 'lsnr' || $scope.graph4Model.id == 'lsnr') {
    
            }
            if ($scope.graph1Model.id == 'rsnr' || $scope.graph2Model.id == 'rsnr' || $scope.graph3Model.id == 'rsnr' || $scope.graph4Model.id == 'rsnr') {
    
            }
            if ($scope.graph1Model.id == 'mcs' || $scope.graph2Model.id == 'mcs' || $scope.graph3Model.id == 'mcs' || $scope.graph4Model.id == 'mcs') {
    
            }
            if ($scope.graph1Model.id == 'util' || $scope.graph2Model.id == 'util' || $scope.graph3Model.id == 'util' || $scope.graph4Model.id == 'util') {
    
            }
            if ($scope.graph1Model.id == 'err' || $scope.graph2Model.id == 'err' || $scope.graph3Model.id == 'err' || $scope.graph4Model.id == 'err') {
    
            }
            if ($scope.graph1Model.id == 'cha' || $scope.graph2Model.id == 'cha' || $scope.graph3Model.id == 'cha' || $scope.graph4Model.id == 'cha') {
    
            }
    
            if ($scope.graph1Model.id == 'nois' || $scope.graph2Model.id == 'nois' || $scope.graph3Model.id == 'nois' || $scope.graph4Model.id == 'nois') {
    
            }*/

        }
        $scope.liveLinkData = function () {
            if (!$scope.liveGraph[0]) {
                return;
            }
            $http.get('api/v2/nodelinks/linkdet/' + $state.params.nodeId + '?mac=' + $scope.macaddress, { showdiv: false }).then(function (response) {
                var linkData = response.data.links;
                if (linkData.length > 0) {
                    if ($scope.liveGraph[0]) {
                        $scope.spliceData($scope.graphChartConfig[0]);
                        $scope.pushLiveData(linkData);
                    }
                    if ($scope.liveGraph[1]) {
                        $scope.spliceData($scope.graphChartConfig[1]);
                        $scope.pushLiveData(linkData);
                    }
                    if ($scope.liveGraph[2]) {
                        $scope.spliceData($scope.graphChartConfig[2]);
                        $scope.pushLiveData(linkData);
                    }
                    if ($scope.liveGraph[3]) {
                        $scope.spliceData($scope.graphChartConfig[3]);
                        $scope.pushLiveData(linkData);
                    }
                    if ($scope.liveGraph[4]) {
                        $scope.spliceData($scope.graphChartConfig[4]);
                        $scope.pushLiveData(linkData);
                    }

                    if ($scope.liveGraph[5]) {
                        $scope.spliceData($scope.graphChartConfig[5]);
                        $scope.pushLiveData(linkData);
                    }

                    if ($scope.liveGraph[6]) {
                        $scope.spliceData($scope.graphChartConfig[6]);
                        $scope.pushLiveData(linkData);
                    }

                    if ($scope.liveGraph[7]) {
                        $scope.spliceData($scope.graphChartConfig[7]);
                        $scope.pushLiveData(linkData);
                    }

                    chatObj1.update();
                    chatObj2.update();
                    chatObj3.update();
                    chatObj4.update();
                    chatObj5.update();
                    chatObj6.update();
                    chatObj7.update();
                    chatObj8.update();
                }


            });

        }


        function destroyNInitGraph1(isLive, config) {
            if (chatObj1 != null) {
                chatObj1.destroy();
            }

            if (isLive) {
                config.options.scales.xAxes[0] = {
                    gridLines: {
                        display: false
                    }
                };
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];

            } else {
                var seriesConfig = {
                    gridLines: {
                        display: false
                    },
                    type: 'time',
                    distribution: 'series',
                    displayFormats: {
                        quarter: 'MMM YYYY'
                    }
                }
                config.options.scales.xAxes[0] = seriesConfig;
            }
            //config.options.scales.yAxes[0].scaleLabel.labelString = 'RSSI ' + $scope.localMode;
            chatObj1 = new Chart(link_char1, config);
            if (isLive) {
                config.data.labels = [];
                // Initialize the Config null data to display window on start
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                    } else {
                        config.data.labels[i] = "";
                    }
                    if (config.data.datasets.length > 0) {
                        for (var j = 0; j < config.data.datasets.length; j++) {
                            config.data.datasets[j].data[i] = null;
                        }
                    }
                }
            } else {
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];
            }
        }
        function destroyNInitGraph2(isLive, config) {
            if (chatObj2 != null) {
                chatObj2.destroy();
            }

            if (isLive) {
                config.options.scales.xAxes[0] = {
                    gridLines: {
                        display: false
                    }
                };
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];

            } else {
                var seriesConfig = {
                    gridLines: {
                        display: false
                    },
                    type: 'time',
                    distribution: 'series',
                    displayFormats: {
                        quarter: 'MMM YYYY'
                    }
                }
                config.options.scales.xAxes[0] = seriesConfig;
            }
            //config.options.scales.yAxes[0].scaleLabel.labelString = 'RSSI ' + $scope.remoteMode;
            chatObj2 = new Chart(link_char2, config);
            if (isLive) {
                config.data.labels = [];
                // Initialize the Config null data to display window on start
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                    } else {
                        config.data.labels[i] = "";
                    }
                    if (config.data.datasets.length > 0) {
                        for (var j = 0; j < config.data.datasets.length; j++) {
                            config.data.datasets[j].data[i] = null;
                        }
                    }
                }
            } else {
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];
            }
        }
        function destroyNInitGraph3(isLive, config) {
            if (chatObj3 != null) {
                chatObj3.destroy();
            }

            if (isLive) {
                config.options.scales.xAxes[0] = {
                    gridLines: {
                        display: false
                    }
                };
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];

            } else {
                var seriesConfig = {
                    gridLines: {
                        display: false
                    },
                    type: 'time',
                    distribution: 'series',
                    displayFormats: {
                        quarter: 'MMM YYYY'
                    }
                }
                config.options.scales.xAxes[0] = seriesConfig;
            }
            //config.options.scales.yAxes[0].scaleLabel.labelString = 'SNR ' + $scope.localMode;
            chatObj3 = new Chart(link_char3, config);
            if (isLive) {
                config.data.labels = [];
                // Initialize the Config null data to display window on start
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                    } else {
                        config.data.labels[i] = "";
                    }
                    if (config.data.datasets.length > 0) {
                        for (var j = 0; j < config.data.datasets.length; j++) {
                            config.data.datasets[j].data[i] = null;
                        }
                    }
                }
            } else {
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];
            }
        }

        function destroyNInitGraph4(isLive, config) {
            if (chatObj4 != null) {
                chatObj4.destroy();
            }

            if (isLive) {
                config.options.scales.xAxes[0] = {
                    gridLines: {
                        display: false
                    }
                };
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];

            } else {
                var seriesConfig = {
                    gridLines: {
                        display: false
                    },
                    type: 'time',
                    distribution: 'series',
                    displayFormats: {
                        quarter: 'MMM YYYY'
                    }
                }
                config.options.scales.xAxes[0] = seriesConfig;
            }
            //config.options.scales.yAxes[0].scaleLabel.labelString = 'SNR ' + $scope.remoteMode;
            chatObj4 = new Chart(link_char4, config);
            if (isLive) {
                config.data.labels = [];
                // Initialize the Config null data to display window on start
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                    } else {
                        config.data.labels[i] = "";
                    }
                    if (config.data.datasets.length > 0) {
                        for (var j = 0; j < config.data.datasets.length; j++) {
                            config.data.datasets[j].data[i] = null;
                        }
                    }
                }
            } else {
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];
            }
        }

        function destroyNInitGraph5(isLive, config) {
            if (chatObj5 != null) {
                chatObj5.destroy();
            }

            if (isLive) {
                config.options.scales.xAxes[0] = {
                    gridLines: {
                        display: false
                    }
                };
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];

            } else {
                var seriesConfig = {
                    gridLines: {
                        display: false
                    },
                    type: 'time',
                    distribution: 'series',
                    displayFormats: {
                        quarter: 'MMM YYYY'
                    }
                }
                config.options.scales.xAxes[0] = seriesConfig;
            }

            /*if (config.data.datasets.length > 0) {
                for (var i = 0; i< config.data.datasets.length;i++) {
                    if (config.data.datasets[i].label == 'local') {
                        config.data.datasets[i].label = $scope.localMode;
                    }
    
                    if (config.data.datasets[i].label == 'remote') {
                        config.data.datasets[i].label = $scope.remoteMode;
                    }
                }
            }*/
            chatObj5 = new Chart(link_char5, config);
            if (isLive) {
                config.data.labels = [];
                // Initialize the Config null data to display window on start
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                    } else {
                        config.data.labels[i] = "";
                    }
                    if (config.data.datasets.length > 0) {
                        for (var j = 0; j < config.data.datasets.length; j++) {
                            config.data.datasets[j].data[i] = null;
                        }
                    }
                }
            } else {
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];
            }
        }

        function destroyNInitGraph6(isLive, config) {
            if (chatObj6 != null) {
                chatObj6.destroy();
            }

            if (isLive) {
                config.options.scales.xAxes[0] = {
                    gridLines: {
                        display: false
                    }
                };
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];

            } else {
                var seriesConfig = {
                    gridLines: {
                        display: false
                    },
                    type: 'time',
                    distribution: 'series',
                    displayFormats: {
                        quarter: 'MMM YYYY'
                    }
                }
                config.options.scales.xAxes[0] = seriesConfig;
            }

            chatObj6 = new Chart(link_char6, config);
            if (isLive) {
                config.data.labels = [];
                // Initialize the Config null data to display window on start
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                    } else {
                        config.data.labels[i] = "";
                    }
                    if (config.data.datasets.length > 0) {
                        for (var j = 0; j < config.data.datasets.length; j++) {
                            config.data.datasets[j].data[i] = null;
                        }
                    }
                }
            } else {
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];
            }
        }

        function destroyNInitGraph7(isLive, config) {
            if (chatObj7 != null) {
                chatObj7.destroy();
            }

            if (isLive) {
                config.options.scales.xAxes[0] = {
                    gridLines: {
                        display: false
                    }
                };
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];

            } else {
                var seriesConfig = {
                    gridLines: {
                        display: false
                    },
                    type: 'time',
                    distribution: 'series',
                    displayFormats: {
                        quarter: 'MMM YYYY'
                    }
                }
                config.options.scales.xAxes[0] = seriesConfig;
            }
            /*if (config.data.datasets.length > 0) {
                for (var i = 0; i< config.data.datasets.length;i++) {
                    if (config.data.datasets[i].label == 'local') {
                        config.data.datasets[i].label = $scope.localMode;
                    }
    
                    if (config.data.datasets[i].label == 'remote') {
                        config.data.datasets[i].label = $scope.remoteMode;
                    }
                }
            }*/

            chatObj7 = new Chart(link_char7, config);
            if (isLive) {
                config.data.labels = [];
                // Initialize the Config null data to display window on start
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                    } else {
                        config.data.labels[i] = "";
                    }
                    if (config.data.datasets.length > 0) {
                        for (var j = 0; j < config.data.datasets.length; j++) {
                            config.data.datasets[j].data[i] = null;
                        }
                    }
                }
            } else {
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];
            }
        }

        function destroyNInitGraph8(isLive, config) {
            if (chatObj8 != null) {
                chatObj8.destroy();
            }

            if (isLive) {
                config.options.scales.xAxes[0] = {
                    gridLines: {
                        display: false
                    }
                };
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];

            } else {
                var seriesConfig = {
                    gridLines: {
                        display: false
                    },
                    type: 'time',
                    distribution: 'series',
                    displayFormats: {
                        quarter: 'MMM YYYY'
                    }
                }
                config.options.scales.xAxes[0] = seriesConfig;
            }

            chatObj8 = new Chart(link_char8, config);
            if (isLive) {
                config.data.labels = [];
                // Initialize the Config null data to display window on start
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                    } else {
                        config.data.labels[i] = "";
                    }
                    if (config.data.datasets.length > 0) {
                        for (var j = 0; j < config.data.datasets.length; j++) {
                            config.data.datasets[j].data[i] = null;
                        }
                    }
                }
            } else {
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];
            }
        }

        function destroyNInitLocalRSSIGraph(isLive) {
            destroyNInitGraph1(true, $scope.local_rssi_chart_config);
            $scope.graphChartConfig[0] = $scope.local_rssi_chart_config;
        }

        function destroyNInitRemoteRSSIGraph(isLive) {
            destroyNInitGraph2(true, $scope.remote_rssi_config);
            $scope.graphChartConfig[1] = $scope.remote_rssi_config;
        }

        function destroyNInitLinkSNRGraph(isLive) {
            destroyNInitGraph3(true, $scope.local_snr_config);
            $scope.graphChartConfig[2] = $scope.local_snr_config;
        }

        function destroyNInitRemoteSNRraph(isLive) {
            destroyNInitGraph4(true, $scope.remote_snr_config);
            $scope.graphChartConfig[3] = $scope.remote_snr_config;
        }

        function destroyNInitMCSGraph(isLive) {
            destroyNInitGraph5(true, $scope.link_mcs_config);
            $scope.graphChartConfig[4] = $scope.link_mcs_config;
        }

        function destroyNInitUtilGraph(isLive) {
            destroyNInitGraph6(true, $scope.link_util_config);
            $scope.graphChartConfig[5] = $scope.link_util_config;
        }

        function destroyNInitErrGraph(isLive) {
            destroyNInitGraph7(true, $scope.link_err_config);
            $scope.graphChartConfig[6] = $scope.link_err_config;
        }

        function destroyNInitChanGraph(isLive) {
            destroyNInitGraph8(true, $scope.channel_config);
            $scope.graphChartConfig[7] = $scope.channel_config;
        }


        $scope.getConfig = function (id) {
            var config = null;
            if (id == 'lrssi') {
                config = $scope.local_rssi_chart_config;
            } else if (id == 'rrssi') {
                config = $scope.remote_rssi_config;
            } else if (id == 'lsnr') {
                config = $scope.local_snr_config;
            } else if (id == 'rsnr') {
                config = $scope.remote_snr_config;
            } else if (id == 'mcs') {
                config = $scope.link_mcs_config;
            } else if (id == 'util') {
                config = $scope.link_util_config;
            } else if (id == 'err') {
                config = $scope.link_err_config;
            } else if (id == 'cha') {
                config = $scope.channel_config;
            } else if (id == 'nois') {
                config = $scope.link_noise_config;
            }
            return config;
        }

        $scope.select1Graph = function (id) {
            console.log(id);
            var config = $scope.getConfig(id);
            $scope.graphChartConfig[0] = config;
            destroyNInitGraph1(true, config)

        }

        $scope.select2Graph = function (id) {
            console.log(id);
            var config = $scope.getConfig(id);
            $scope.graphChartConfig[1] = config;
            destroyNInitGraph2(true, config)
        }

        $scope.select3Graph = function (id) {
            console.log(id);
            var config = $scope.getConfig(id);
            $scope.graphChartConfig[2] = config;
            destroyNInitGraph3(true, config)
        }

        $scope.select4Graph = function (id) {
            console.log(id);
            var config = $scope.getConfig(id);
            $scope.graphChartConfig[3] = config;
            destroyNInitGraph4(true, config)
        }


        $scope.addResponseDataToGraph = function (data, id, gra) {
            //var config = $scope.graphChartConfig[id];
            if (gra == 'lrssi') {
                $scope.addLocalRSSIData(data);
            } else if (gra == 'rrssi') {
                $scope.addRemoteRSSIData(data);
            } else if (gra == 'lsnr') {
                $scope.addLocalSNRData(data);
            } else if (gra == 'rsnr') {
                $scope.addRemoteSNRData(data);
            } else if (gra == 'mcs') {
                $scope.addMCSData(data);
            } else if (gra == 'util') {
                $scope.addUtilData(data);
            } else if (gra == 'err') {
                $scope.addErrData(data);
            } else if (gra == 'cha') {
                $scope.addChannelData(data);
            } else if (gra == 'nois') {
                $scope.addNoiseData(data);
            }
            if (id == 1) {
                chatObj1.update();
            } else if (id == 2) {
                chatObj2.update();
            } else if (id == 3) {
                chatObj3.update();
            } else if (id == 4) {
                chatObj4.update();
            } else if (id == 5) {
                chatObj5.update();
            } else if (id == 6) {
                chatObj6.update();
            } else if (id == 7) {
                chatObj7.update();
            } else if (id == 8) {
                chatObj8.update();
            }
        }

        $scope.addLocalRSSIData = function (data) {
            var timeStamps = data.timestamps
            var values0 = data.columns[0].values;
            var values1 = data.columns[1].values;

            for (var i = 0; i < timeStamps.length - 1; i++) {
                if (values0[i] == 'NaN') {
                    values0[i] = 0;
                }
                if (values1[i] == 'NaN') {
                    values1[i] = 0;
                }
                var d = new Date(timeStamps[i]);
                $scope.local_rssi_chart_config.data.labels[i] = d;
                $scope.local_rssi_chart_config.data.datasets[0].data.push(parseFloat(values0[i]).toFixed(0));
                $scope.local_rssi_chart_config.data.datasets[1].data.push(parseFloat(values1[i]).toFixed(0));
                $scope.local_rssi_chart_config.data.datasets[2].data.push($scope.lerssi);

            }
        }

        $scope.addRemoteRSSIData = function (data) {
            var timeStamps = data.timestamps
            var values0 = data.columns[0].values;
            var values1 = data.columns[1].values;

            for (var i = 0; i < timeStamps.length - 1; i++) {
                if (values0[i] == 'NaN') {
                    values0[i] = 0;
                }
                if (values1[i] == 'NaN') {
                    values1[i] = 0;
                }
                var d = new Date(timeStamps[i]);
                $scope.remote_rssi_config.data.labels[i] = d;
                $scope.remote_rssi_config.data.datasets[0].data.push(parseFloat(values0[i]).toFixed(0));
                $scope.remote_rssi_config.data.datasets[1].data.push(parseFloat(values1[i]).toFixed(0));
                $scope.remote_rssi_config.data.datasets[2].data.push($scope.rerssi);

            }
        }
        $scope.addLocalSNRData = function (data) {
            var timeStamps = data.timestamps
            var values0 = data.columns[0].values;
            var values1 = data.columns[1].values;

            for (var i = 0; i < timeStamps.length - 1; i++) {
                if (values0[i] == 'NaN') {
                    values0[i] = 0;
                }
                if (values1[i] == 'NaN') {
                    values1[i] = 0;
                }
                var d = new Date(timeStamps[i]);
                $scope.local_snr_config.data.labels[i] = d;
                $scope.local_snr_config.data.datasets[0].data.push(parseFloat(values0[i]).toFixed(0));
                $scope.local_snr_config.data.datasets[1].data.push(parseFloat(values1[i]).toFixed(0));

            }
        }

        $scope.addRemoteSNRData = function (data) {
            var timeStamps = data.timestamps
            var values0 = data.columns[0].values;
            var values1 = data.columns[1].values;

            for (var i = 0; i < timeStamps.length - 1; i++) {
                if (values0[i] == 'NaN') {
                    values0[i] = 0;
                }
                if (values1[i] == 'NaN') {
                    values1[i] = 0;
                }
                var d = new Date(timeStamps[i]);
                $scope.remote_snr_config.data.labels[i] = d;
                $scope.remote_snr_config.data.datasets[0].data.push(parseFloat(values0[i]).toFixed(0));
                $scope.remote_snr_config.data.datasets[1].data.push(parseFloat(values1[i]).toFixed(0));

            }
        }


        $scope.addMCSData = function (data) {
            var timeStamps = data.timestamps
            var values0 = data.columns[0].values;
            var values1 = data.columns[1].values;

            for (var i = 0; i < timeStamps.length - 1; i++) {
                if (values0[i] == 'NaN') {
                    values0[i] = 0;
                }
                if (values1[i] == 'NaN') {
                    values1[i] = 0;
                }
                var d = new Date(timeStamps[i]);
                $scope.link_mcs_config.data.labels[i] = d;
                $scope.link_mcs_config.data.datasets[0].data.push(parseFloat(values0[i]).toFixed(0));
                $scope.link_mcs_config.data.datasets[1].data.push(parseFloat(values1[i]).toFixed(0));

            }
        }

        $scope.addUtilData = function (data) {
            var timeStamps = data.timestamps
            var values0 = data.columns[0].values;
            var values1 = data.columns[1].values;

            for (var i = 0; i < timeStamps.length - 1; i++) {
                if (values0[i] == 'NaN') {
                    values0[i] = 0;
                }
                if (values1[i] == 'NaN') {
                    values1[i] = 0;
                }
                var d = new Date(timeStamps[i]);
                $scope.link_util_config.data.labels[i] = d;
                $scope.link_util_config.data.datasets[0].data.push(parseFloat(values0[i]).toFixed(2));
                $scope.link_util_config.data.datasets[1].data.push(parseFloat(values1[i]).toFixed(2));

            }
        }
        $scope.addNoiseData = function (data) {
            var timeStamps = data.timestamps
            var values0 = data.columns[0].values;
            var values1 = data.columns[1].values;

            for (var i = 0; i < timeStamps.length - 1; i++) {
                if (values0[i] == 'NaN') {
                    values0[i] = 0;
                }
                if (values1[i] == 'NaN') {
                    values1[i] = 0;
                }
                var d = new Date(timeStamps[i]);
                $scope.link_noise_config.data.labels[i] = d;
                $scope.link_noise_config.data.datasets[0].data.push(values0[i]);
                $scope.link_noise_config.data.datasets[1].data.push(values1[i]);

            }
        }

        $scope.addErrData = function (data) {
            var timeStamps = data.timestamps
            var values0 = data.columns[0].values;
            var values1 = data.columns[1].values;

            for (var i = 0; i < timeStamps.length - 1; i++) {
                if (values0[i] == 'NaN') {
                    values0[i] = 0;
                }
                if (values1[i] == 'NaN') {
                    values1[i] = 0;
                }
                var d = new Date(timeStamps[i]);
                $scope.link_err_config.data.labels[i] = d;
                $scope.link_err_config.data.datasets[0].data.push(parseFloat(values0[i]).toFixed(0));
                $scope.link_err_config.data.datasets[1].data.push(parseFloat(values1[i]).toFixed(0));

            }
        }

        $scope.addChannelData = function (data) {
            var timeStamps = data.timestamps
            var values0 = data.columns[0].values;

            for (var i = 0; i < timeStamps.length - 1; i++) {
                if (values0[i] == 'NaN') {
                    values0[i] = 0;
                }
                var d = new Date(timeStamps[i]);
                $scope.channel_config.data.labels[i] = d;
                $scope.channel_config.data.datasets[0].data.push(parseFloat(values0[i]).toFixed(0));
            }
        }


        $scope.addLinkData = function (gra, duration, data, id) {
            if (gra == 'cha') {
                var url = 'rest/measurements/node%5B' + $state.params.nodeId + '%5D.nodeSnmp%5B%5D?aggregation=AVERAGE&att=channel&duration=' + duration;
                if (duration == '1c') {
                    console.log($scope.startDate);
                    console.log($scope.endDate);

                    url = 'rest/measurements/node%5B' + $state.params.nodeId + '%5D.nodeSnmp%5B%5D?aggregation=AVERAGE&att=channel&duration=' + duration + '&start=' + $scope.startsDate + '&end=' + $scope.endsDate;
                }
                $http.get(url, { showdiv: false })
                    .then(function (response) {
                        $scope.addResponseDataToGraph(response.data, id, gra);
                    });
            } else {
                var url = 'rest/measurements/node%5B' + $state.params.nodeId + '%5D.associndex%5B' + $scope.macaddress + '%5D?aggregation=AVERAGE&att=' + data + '&duration=' + duration;
                if (duration == '1c') {
                    console.log($scope.startDate);
                    console.log($scope.endDate);

                    url = 'rest/measurements/node%5B' + $state.params.nodeId + '%5D.associndex%5B' + $scope.macaddress + '%5D?aggregation=AVERAGE&att=' + data + '&duration=' + duration + '&start=' + $scope.startsDate + '&end=' + $scope.endsDate;
                }
                $http.get(url, { showdiv: false }).then(function (response) {
                    $scope.addResponseDataToGraph(response.data, id, gra);
                });

            }
        }

        $scope.showCustomeData = function () {
            console.log($scope.startDate);
            console.log($scope.endDate);
            $scope.startsDate = new Date($scope.startDate).getTime();
            $scope.endsDate = new Date($scope.endDate).getTime();
            $scope.graphEvent4('lrssi', 6, 1)

        }


        $scope.graphEvent4 = function (gra, event, id) {
            $scope.eventCode = event;
            var isLive = false;
            var d = "1h";
            if (event == 2) {
                d = "1h";
            } else if (event == 3) {
                d = "1d";
            } else if (event == 4) {
                d = "1m";
            } else if (event == 5) {
                d = "1w";
            } else if (event == 6) {
                d = "1c";
            } else {
                d = "1h";
                isLive = true;
            }

            console.log($scope.chartMap[gra]);
            var data = $scope.chartMap[gra];
            if (id == 1) {
                $scope.liveGraph[0] = isLive;
                $scope.liveGraph[1] = isLive;
                $scope.liveGraph[2] = isLive;
                $scope.liveGraph[3] = isLive;
                $scope.liveGraph[4] = isLive;
                $scope.liveGraph[5] = isLive;
                $scope.liveGraph[6] = isLive;
                $scope.liveGraph[7] = isLive;
                destroyNInitGraph1(isLive, $scope.graphChartConfig[0]);
                destroyNInitGraph2(isLive, $scope.graphChartConfig[1]);
                destroyNInitGraph3(isLive, $scope.graphChartConfig[2]);
                destroyNInitGraph4(isLive, $scope.graphChartConfig[3]);
                destroyNInitGraph5(isLive, $scope.graphChartConfig[4]);
                destroyNInitGraph6(isLive, $scope.graphChartConfig[5]);
                destroyNInitGraph7(isLive, $scope.graphChartConfig[6]);
                destroyNInitGraph8(isLive, $scope.graphChartConfig[7]);
            }

            if (!isLive) {
                $scope.addLinkData('lrssi', d, 'lsiga1,lsiga2', 1);
                $scope.addLinkData('rrssi', d, 'rsiga1,rsiga2', 2);
                $scope.addLinkData('lsnr', d, 'lsnra1,lsnra2', 3);
                $scope.addLinkData('rsnr', d, 'rsnra1,rsnra2', 4);
                $scope.addLinkData('mcs', d, 'lmcs,rmcs', 5);
                $scope.addLinkData('util', d, 'in,out', 6);
                $scope.addLinkData('err', d, 'lerr,rerr', 7);
                $scope.addLinkData('cha', d, 'channel', 8);
            }
        }

    }]);
