dashboard.controller("NodeViewManagementController", ['$localStorage', '$rootScope', '$scope', '$mdDialog', '$http', '$state', 'dashboardService', 'Flash', '$interval',
    function ($localStorage, $rootScope, $scope, $mdDialog, $http, $state, dashboardService, Flash, $interval) {
        //init method it checks selected view and activate get call based on rootscope.selectedView
        $scope.retainIPReset = false;
        var zoneval = "GMT0=Africa/Abidjan@GMT0=Africa/Accra@EAT-3=Africa/Addis Ababa@CET-1=Africa/Algiers@EAT-3=Africa/Asmara@GMT0=Africa/Bamako@WAT-1=Africa/Bangui@GMT0=Africa/Banjul@GMT0=Africa/Bissau@CAT-2=Africa/Blantyre@WAT-1=Africa/Brazzaville@CAT-2=Africa/Bujumbura@EET-2=Africa/Cairo@WET0WEST,M3.5.0,M10.5.0/3=Africa/Casablanca@CET-1CEST,M3.5.0,M10.5.0/3=Africa/Ceuta@GMT0=Africa/Conakry@GMT0=Africa/Dakar@EAT-3=Africa/Dar es Salaam@EAT-3=Africa/Djibouti@WAT-1=Africa/Douala@WET0WEST,M3.5.0,M10.5.0/3=Africa/El Aaiun@GMT0=Africa/Freetown@CAT-2=Africa/Gaborone@CAT-2=Africa/Harare@SAST-2=Africa/Johannesburg@EAT-3=Africa/Juba@EAT-3=Africa/Kampala@EAT-3=Africa/Khartoum@CAT-2=Africa/Kigali@WAT-1=Africa/Kinshasa@WAT-1=Africa/Lagos@WAT-1=Africa/Libreville@GMT0=Africa/Lome@WAT-1=Africa/Luanda@CAT-2=Africa/Lubumbashi@CAT-2=Africa/Lusaka@WAT-1=Africa/Malabo@CAT-2=Africa/Maputo@SAST-2=Africa/Maseru@SAST-2=Africa/Mbabane@EAT-3=Africa/Mogadishu@GMT0=Africa/Monrovia@EAT-3=Africa/Nairobi@WAT-1=Africa/Ndjamena@WAT-1=Africa/Niamey@GMT0=Africa/Nouakchott@GMT0=Africa/Ouagadougou@WAT-1=Africa/Porto-Novo@GMT0=Africa/Sao Tome@EET-2=Africa/Tripoli@CET-1=Africa/Tunis@WAT-1WAST,M9.1.0,M4.1.0=Africa/Windhoek@HST10HDT,M3.2.0,M11.1.0=America/Adak@AKST9AKDT,M3.2.0,M11.1.0=America/Anchorage@AST4=America/Anguilla@AST4=America/Antigua@BRT3=America/Araguaina@ART3=America/Argentina/Buenos Aires@ART3=America/Argentina/Catamarca@ART3=America/Argentina/Cordoba@ART3=America/Argentina/Jujuy@ART3=America/Argentina/La Rioja@ART3=America/Argentina/Mendoza@ART3=America/Argentina/Rio Gallegos@ART3=America/Argentina/Salta@ART3=America/Argentina/San Juan@ART3=America/Argentina/San Luis@ART3=America/Argentina/Tucuman@ART3=America/Argentina/Ushuaia@AST4=America/Aruba@PYT4PYST,M10.1.0/0,M3.4.0/0=America/Asuncion@EST5=America/Atikokan@BRT3=America/Bahia@CST6CDT,M4.1.0,M10.5.0=America/Bahia Banderas@AST4=America/Barbados@BRT3=America/Belem@CST6=America/Belize@AST4=America/Blanc-Sablon@AMT4=America/Boa Vista@COT5=America/Bogota@MST7MDT,M3.2.0,M11.1.0=America/Boise@MST7MDT,M3.2.0,M11.1.0=America/Cambridge Bay@AMT4AMST,M10.3.0/0,M2.3.0/0=America/Campo Grande@EST5=America/Cancun@VET4:30=America/Caracas@GFT3=America/Cayenne@EST5=America/Cayman@CST6CDT,M3.2.0,M11.1.0=America/Chicago@MST7MDT,M4.1.0,M10.5.0=America/Chihuahua@CST6=America/Costa Rica@MST7=America/Creston@AMT4AMST,M10.3.0/0,M2.3.0/0=America/Cuiaba@AST4=America/Curacao@GMT0=America/Danmarkshavn@PST8PDT,M3.2.0,M11.1.0=America/Dawson@MST7=America/Dawson Creek@MST7MDT,M3.2.0,M11.1.0=America/Denver@EST5EDT,M3.2.0,M11.1.0=America/Detroit@AST4=America/Dominica@MST7MDT,M3.2.0,M11.1.0=America/Edmonton@ACT5=America/Eirunepe@CST6=America/El Salvador@MST7=America/Fort Nelson@BRT3=America/Fortaleza@AST4ADT,M3.2.0,M11.1.0=America/Glace Bay@WGT3WGST,M3.5.0/-2,M10.5.0/-1=America/Godthab@AST4ADT,M3.2.0,M11.1.0=America/Goose Bay@AST4=America/Grand Turk@AST4=America/Grenada@AST4=America/Guadeloupe@CST6=America/Guatemala@ECT5=America/Guayaquil@GYT4=America/Guyana@AST4ADT,M3.2.0,M11.1.0=America/Halifax@CST5CDT,M3.2.0/0,M11.1.0/1=America/Havana@MST7=America/Hermosillo@EST5EDT,M3.2.0,M11.1.0=America/Indiana/Indianapolis@CST6CDT,M3.2.0,M11.1.0=America/Indiana/Knox@EST5EDT,M3.2.0,M11.1.0=America/Indiana/Marengo@EST5EDT,M3.2.0,M11.1.0=America/Indiana/Petersburg@CST6CDT,M3.2.0,M11.1.0=America/Indiana/Tell City@EST5EDT,M3.2.0,M11.1.0=America/Indiana/Vevay@EST5EDT,M3.2.0,M11.1.0=America/Indiana/Vincennes@EST5EDT,M3.2.0,M11.1.0=America/Indiana/Winamac@MST7MDT,M3.2.0,M11.1.0=America/Inuvik@EST5EDT,M3.2.0,M11.1.0=America/Iqaluit@EST5=America/Jamaica@AKST9AKDT,M3.2.0,M11.1.0=America/Juneau@EST5EDT,M3.2.0,M11.1.0=America/Kentucky/Louisville@EST5EDT,M3.2.0,M11.1.0=America/Kentucky/Monticello@AST4=America/Kralendijk@BOT4=America/La Paz@PET5=America/Lima@PST8PDT,M3.2.0,M11.1.0=America/Los Angeles@AST4=America/Lower Princes@BRT3=America/Maceio@CST6=America/Managua@AMT4=America/Manaus@AST4=America/Marigot@AST4=America/Martinique@CST6CDT,M3.2.0,M11.1.0=America/Matamoros@MST7MDT,M4.1.0,M10.5.0=America/Mazatlan@CST6CDT,M3.2.0,M11.1.0=America/Menominee@CST6CDT,M4.1.0,M10.5.0=America/Merida@AKST9AKDT,M3.2.0,M11.1.0=America/Metlakatla@CST6CDT,M4.1.0,M10.5.0=America/Mexico City@PMST3PMDT,M3.2.0,M11.1.0=America/Miquelon@AST4ADT,M3.2.0,M11.1.0=America/Moncton@CST6CDT,M4.1.0,M10.5.0=America/Monterrey@UYT3=America/Montevideo@AST4=America/Montserrat@EST5EDT,M3.2.0,M11.1.0=America/Nassau@EST5EDT,M3.2.0,M11.1.0=America/New York@EST5EDT,M3.2.0,M11.1.0=America/Nipigon@AKST9AKDT,M3.2.0,M11.1.0=America/Nome@FNT2=America/Noronha@CST6CDT,M3.2.0,M11.1.0=America/North Dakota/Beulah@CST6CDT,M3.2.0,M11.1.0=America/North Dakota/Center@CST6CDT,M3.2.0,M11.1.0=America/North Dakota/New Salem@MST7MDT,M3.2.0,M11.1.0=America/Ojinaga@EST5=America/Panama@EST5EDT,M3.2.0,M11.1.0=America/Pangnirtung@SRT3=America/Paramaribo@MST7=America/Phoenix@AST4=America/Port of Spain@EST5=America/Port-au-Prince@AMT4=America/Porto Velho@AST4=America/Puerto Rico@CST6CDT,M3.2.0,M11.1.0=America/Rainy River@CST6CDT,M3.2.0,M11.1.0=America/Rankin Inlet@BRT3=America/Recife@CST6=America/Regina@CST6CDT,M3.2.0,M11.1.0=America/Resolute@ACT5=America/Rio Branco@BRT3=America/Santarem@CLT4CLST,M8.2.6/24,M5.2.6/24=America/Santiago@AST4=America/Santo Domingo@BRT3BRST,M10.3.0/0,M2.3.0/0=America/Sao Paulo@EGT1EGST,M3.5.0/0,M10.5.0/1=America/Scoresbysund@AKST9AKDT,M3.2.0,M11.1.0=America/Sitka@AST4=America/St Barthelemy@NST3:30NDT,M3.2.0,M11.1.0=America/St Johns@AST4=America/St Kitts@AST4=America/St Lucia@AST4=America/St Thomas@AST4=America/St Vincent@CST6=America/Swift Current@CST6=America/Tegucigalpa@AST4ADT,M3.2.0,M11.1.0=America/Thule@EST5EDT,M3.2.0,M11.1.0=America/Thunder Bay@PST8PDT,M3.2.0,M11.1.0=America/Tijuana@EST5EDT,M3.2.0,M11.1.0=America/Toronto@AST4=America/Tortola@PST8PDT,M3.2.0,M11.1.0=America/Vancouver@PST8PDT,M3.2.0,M11.1.0=America/Whitehorse@CST6CDT,M3.2.0,M11.1.0=America/Winnipeg@AKST9AKDT,M3.2.0,M11.1.0=America/Yakutat@MST7MDT,M3.2.0,M11.1.0=America/Yellowknife@AWST-8=Antarctica/Casey@DAVT-7=Antarctica/Davis@DDUT-10=Antarctica/DumontDUrville@MIST-11=Antarctica/Macquarie@MAWT-5=Antarctica/Mawson@NZST-12NZDT,M9.5.0,M4.1.0/3=Antarctica/McMurdo@CLT4CLST,M8.2.6/24,M5.2.6/24=Antarctica/Palmer@ROTT3=Antarctica/Rothera@SYOT-3=Antarctica/Syowa@UTC0CEST-2,M3.5.0/1,M10.5.0/3=Antarctica/Troll@VOST-6=Antarctica/Vostok@CET-1CEST,M3.5.0,M10.5.0/3=Arctic/Longyearbyen@AST-3=Asia/Aden@ALMT-6=Asia/Almaty@EET-2EEST,M3.5.4/24,M10.5.5/1=Asia/Amman@ANAT-12=Asia/Anadyr@AQTT-5=Asia/Aqtau@AQTT-5=Asia/Aqtobe@TMT-5=Asia/Ashgabat@AST-3=Asia/Baghdad@AST-3=Asia/Bahrain@AZT-4=Asia/Baku@ICT-7=Asia/Bangkok@<+07>-7=Asia/Barnaul@EET-2EEST,M3.5.0/0,M10.5.0/0=Asia/Beirut@KGT-6=Asia/Bishkek@BNT-8=Asia/Brunei@YAKT-9=Asia/Chita@CHOT-8CHOST,M3.5.6,M9.5.6/0=Asia/Choibalsan@IST-5:30=Asia/Colombo@EET-2EEST,M3.5.5/0,M10.5.5/0=Asia/Damascus@BDT-6=Asia/Dhaka@TLT-9=Asia/Dili@GST-4=Asia/Dubai@TJT-5=Asia/Dushanbe@EET-2EEST,M3.5.6/1,M10.3.6/144=Asia/Gaza@EET-2EEST,M3.5.6/1,M10.3.6/144=Asia/Hebron@ICT-7=Asia/Ho Chi Minh@HKT-8=Asia/Hong Kong@HOVT-7HOVST,M3.5.6,M9.5.6/0=Asia/Hovd@IRKT-8=Asia/Irkutsk@WIB-7=Asia/Jakarta@WIT-9=Asia/Jayapura@IST-2IDT,M3.4.4/26,M10.5.0=Asia/Jerusalem@AFT-4:30=Asia/Kabul@PETT-12=Asia/Kamchatka@PKT-5=Asia/Karachi@NPT-5:45=Asia/Kathmandu@YAKT-9=Asia/Khandyga@IST-5:30=Asia/Kolkata@KRAT-7=Asia/Krasnoyarsk@MYT-8=Asia/Kuala Lumpur@MYT-8=Asia/Kuching@AST-3=Asia/Kuwait@CST-8=Asia/Macau@MAGT-10=Asia/Magadan@WITA-8=Asia/Makassar@PHT-8=Asia/Manila@GST-4=Asia/Muscat@EET-2EEST,M3.5.0/3,M10.5.0/4=Asia/Nicosia@KRAT-7=Asia/Novokuznetsk@NOVT-6=Asia/Novosibirsk@OMST-6=Asia/Omsk@ORAT-5=Asia/Oral@ICT-7=Asia/Phnom Penh@WIB-7=Asia/Pontianak@KST-8:30=Asia/Pyongyang@AST-3=Asia/Qatar@QYZT-6=Asia/Qyzylorda@MMT-6:30=Asia/Rangoon@AST-3=Asia/Riyadh@SAKT-11=Asia/Sakhalin@UZT-5=Asia/Samarkand@KST-9=Asia/Seoul@CST-8=Asia/Shanghai@SGT-8=Asia/Singapore@SRET-11=Asia/Srednekolymsk@CST-8=Asia/Taipei@UZT-5=Asia/Tashkent@GET-4=Asia/Tbilisi@IRST-3:30IRDT,J80/0,J264/0=Asia/Tehran@BTT-6=Asia/Thimphu@JST-9=Asia/Tokyo@ULAT-8ULAST,M3.5.6,M9.5.6/0=Asia/Ulaanbaatar@XJT-6=Asia/Urumqi@VLAT-10=Asia/Ust-Nera@ICT-7=Asia/Vientiane@VLAT-10=Asia/Vladivostok@YAKT-9=Asia/Yakutsk@YEKT-5=Asia/Yekaterinburg@AMT-4=Asia/Yerevan@AZOT1AZOST,M3.5.0/0,M10.5.0/1=Atlantic/Azores@AST4ADT,M3.2.0,M11.1.0=Atlantic/Bermuda@WET0WEST,M3.5.0/1,M10.5.0=Atlantic/Canary@CVT1=Atlantic/Cape Verde@WET0WEST,M3.5.0/1,M10.5.0=Atlantic/Faroe@WET0WEST,M3.5.0/1,M10.5.0=Atlantic/Madeira@GMT0=Atlantic/Reykjavik@GST2=Atlantic/South Georgia@GMT0=Atlantic/St Helena@FKST3=Atlantic/Stanley@ACST-9:30ACDT,M10.1.0,M4.1.0/3=Australia/Adelaide@AEST-10=Australia/Brisbane@ACST-9:30ACDT,M10.1.0,M4.1.0/3=Australia/Broken Hill@AEST-10AEDT,M10.1.0,M4.1.0/3=Australia/Currie@ACST-9:30=Australia/Darwin@ACWST-8:45=Australia/Eucla@AEST-10AEDT,M10.1.0,M4.1.0/3=Australia/Hobart@AEST-10=Australia/Lindeman@LHST-10:30LHDT-11,M10.1.0,M4.1.0=Australia/Lord Howe@AEST-10AEDT,M10.1.0,M4.1.0/3=Australia/Melbourne@AWST-8=Australia/Perth@AEST-10AEDT,M10.1.0,M4.1.0/3=Australia/Sydney@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Amsterdam@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Andorra@<+04>-4=Europe/Astrakhan@EET-2EEST,M3.5.0/3,M10.5.0/4=Europe/Athens@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Belgrade@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Berlin@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Bratislava@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Brussels@EET-2EEST,M3.5.0/3,M10.5.0/4=Europe/Bucharest@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Budapest@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Busingen@EET-2EEST,M3.5.0,M10.5.0/3=Europe/Chisinau@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Copenhagen@GMT0IST,M3.5.0/1,M10.5.0=Europe/Dublin@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Gibraltar@GMT0BST,M3.5.0/1,M10.5.0=Europe/Guernsey@EET-2EEST,M3.5.0/3,M10.5.0/4=Europe/Helsinki@GMT0BST,M3.5.0/1,M10.5.0=Europe/Isle of Man@EET-2EEST,M3.5.0/3,M10.5.0/4=Europe/Istanbul@GMT0BST,M3.5.0/1,M10.5.0=Europe/Jersey@EET-2=Europe/Kaliningrad@EET-2EEST,M3.5.0/3,M10.5.0/4=Europe/Kiev@WET0WEST,M3.5.0/1,M10.5.0=Europe/Lisbon@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Ljubljana@GMT0BST,M3.5.0/1,M10.5.0=Europe/London@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Luxembourg@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Madrid@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Malta@EET-2EEST,M3.5.0/3,M10.5.0/4=Europe/Mariehamn@MSK-3=Europe/Minsk@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Monaco@MSK-3=Europe/Moscow@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Oslo@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Paris@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Podgorica@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Prague@EET-2EEST,M3.5.0/3,M10.5.0/4=Europe/Riga@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Rome@SAMT-4=Europe/Samara@CET-1CEST,M3.5.0,M10.5.0/3=Europe/San Marino@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Sarajevo@MSK-3=Europe/Simferopol@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Skopje@EET-2EEST,M3.5.0/3,M10.5.0/4=Europe/Sofia@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Stockholm@EET-2EEST,M3.5.0/3,M10.5.0/4=Europe/Tallinn@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Tirane@<+04>-4=Europe/Ulyanovsk@EET-2EEST,M3.5.0/3,M10.5.0/4=Europe/Uzhgorod@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Vaduz@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Vatican@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Vienna@EET-2EEST,M3.5.0/3,M10.5.0/4=Europe/Vilnius@MSK-3=Europe/Volgograd@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Warsaw@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Zagreb@EET-2EEST,M3.5.0/3,M10.5.0/4=Europe/Zaporozhye@CET-1CEST,M3.5.0,M10.5.0/3=Europe/Zurich@EAT-3=Indian/Antananarivo@IOT-6=Indian/Chagos@CXT-7=Indian/Christmas@CCT-6:30=Indian/Cocos@EAT-3=Indian/Comoro@TFT-5=Indian/Kerguelen@SCT-4=Indian/Mahe@MVT-5=Indian/Maldives@MUT-4=Indian/Mauritius@EAT-3=Indian/Mayotte@RET-4=Indian/Reunion@WSST-13WSDT,M9.5.0/3,M4.1.0/4=Pacific/Apia@NZST-12NZDT,M9.5.0,M4.1.0/3=Pacific/Auckland@BST-11=Pacific/Bougainville@CHAST-12:45CHADT,M9.5.0/2:45,M4.1.0/3:45=Pacific/Chatham@CHUT-10=Pacific/Chuuk@EAST6EASST,M8.2.6/22,M5.2.6/22=Pacific/Easter@VUT-11=Pacific/Efate@PHOT-13=Pacific/Enderbury@TKT-13=Pacific/Fakaofo@FJT-12FJST,M11.1.0,M1.3.0/3=Pacific/Fiji@TVT-12=Pacific/Funafuti@GALT6=Pacific/Galapagos@GAMT9=Pacific/Gambier@SBT-11=Pacific/Guadalcanal@ChST-10=Pacific/Guam@HST10=Pacific/Honolulu@HST10=Pacific/Johnston@LINT-14=Pacific/Kiritimati@KOST-11=Pacific/Kosrae@MHT-12=Pacific/Kwajalein@MHT-12=Pacific/Majuro@MART9:30=Pacific/Marquesas@SST11=Pacific/Midway@NRT-12=Pacific/Nauru@NUT11=Pacific/Niue@NFT-11=Pacific/Norfolk@NCT-11=Pacific/Noumea@SST11=Pacific/Pago Pago@PWT-9=Pacific/Palau@PST8=Pacific/Pitcairn@PONT-11=Pacific/Pohnpei@PGT-10=Pacific/Port Moresby@CKT10=Pacific/Rarotonga@ChST-10=Pacific/Saipan@TAHT10=Pacific/Tahiti@GILT-12=Pacific/Tarawa@TOT-13=Pacific/Tongatapu@WAKT-12=Pacific/Wake@WFT-12=Pacific/Wallis@";

        $scope.timeZoneValues = [];
        $scope.basestations = [];
        $scope.nodesToApply = -1;

        function getTimeZoneOptions() {
            $scope.timeZoneValues = [];
            var a = zoneval.split("@");
            for (var i = 0; i < a.length; i++) {
                var val = a[i].split("=");
                var zone = {
                    "zone": val[0],
                    "name": val[1]
                };
                $scope.timeZoneValues.push(zone);
            }
        }


        $scope.init = function () {
            $scope.get_save_changes();
            $scope.management_general();
            $scope.management_logging();
            $scope.management_location();
            $scope.management_http();
            $scope.management_telnet();
            $scope.management_snmp();
            $scope.loadRegions();
            //alert($rootScope.selectedView);
            if ($rootScope.selectedView == 'management_general') {
                $scope.management_general();
            }
            if ($rootScope.selectedView == 'management_logging') {
                $scope.management_logging();
            }
            if ($rootScope.selectedView == 'management_location') {
                $scope.management_location();
            }
            if ($rootScope.selectedView == 'management_http/https') {
                $scope.management_http();
            }
            if ($rootScope.selectedView == 'telnet') {
                $scope.management_telnet();
            }
            if ($rootScope.selectedView == 'snmp') {
                $scope.management_snmp();
            }
            if ($rootScope.selectedView == 'reset') {
                //$scope.management_snmp();
                $scope.loadRegions();
            }
        }

        $scope.saveChangesObj = {};
        $scope.get_save_changes = function () {
            var url = 'api/v2/nodes/changes/' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.saveChangesObj = response.data;
                        $rootScope.managementapply = response.data.available;
                        $rootScope.managementchanges = response.data.changes;
                        console.log("$scope.saveChangesObj", $scope.saveChangesObj);
                    }
                });
        }

        //get call for management
        $scope.management_general = function () {

            getTimeZoneOptions();

            $scope.prevProperties = {};

            $scope.dyingGasp = [{
                "dyingGaspStatus": 0,
                "dyingGaspStatusVal": "Disable"
            }, {
                "dyingGaspStatus": 1,
                "dyingGaspStatusVal": "Enable"
            }];
            $scope.akc = [{
                "akcStatus": 0,
                "akcStatusVal": "Disable"
            }, {
                "akcStatus": 1,
                "akcStatusVal": "Enable"
            }];
            var url = 'api/v2/nodemanageview/systemconfig?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.system_general = response.data;
                        angular.copy(response.data, $scope.prevProperties);
                        if ($scope.system_general.gpsStatus == 0) {
                            $scope.system_general.gpsStat = false;
                        } else {
                            $scope.system_general.gpsStat = true;
                        }
                        if ($scope.system_general.ntpStatus == 0) {
                            $scope.system_general.ntpStat = false;
                        } else {
                            $scope.system_general.ntpStat = true;
                        }

                        if ($scope.system_general.ntpServerIP == '-NA-') {
                            $scope.system_general.ntpServerIP = '';
                        }

                        $scope.system_general.timeZone = $scope.selectTimeZone($scope.system_general.timeZone);

                        $scope.system_general.gaspstat = {
                            dyingGaspStatus: $scope.system_general.dyingGaspStatus
                        }
                        console.log("$scope.system_general", $scope.system_general);
                        //          $scope.viewNode = viewNode;
                    }
                });
        }

        $scope.selectTimeZone = function (key) {
            var selected = {};
            for (var i = 0; i < $scope.timeZoneValues.length; i++) {
                var val = $scope.timeZoneValues[i];
                if (val.zone == key) {
                    selected = val;
                }
            }
            return selected;
        }

        // Management > System > General POST call
        $scope.mgmt_system_general = function () {
            if ($scope.system_general.gpsStat == false) {
                $scope.system_general.gpsStatus = 0;
            } else {
                $scope.system_general.gpsStatus = 1;
            }
            if ($scope.system_general.ntpStat == false) {
                $scope.system_general.ntpStatus = 0;
            } else {
                $scope.system_general.ntpStatus = 1;
            }
            var generalObj = {
                "radio": $scope.system_general.radio,
                "nodeId": $state.params.nodeId,
                "status": $scope.system_general.status,
                "message": $scope.system_general.message,

                "ntpStatus": $scope.system_general.ntpStatus,
                "ntpServerIP": $scope.system_general.ntpServerIP,
                "timeZone": $scope.system_general.timeZone.zone,
                "gpsStatus": -1,
                "gpsInterval": -1,
                "dyingGaspStatus": -1,
                //                "akcStatus": $scope.system_general.akcstat.akcStatus,
                //"akcStatus": 0,
                "syslogServerIP": null,
                "syslogServerPort": -1,
                "tempLogStatus": -1,
                "tempLogInterval": -1,

                "custName": null,
                "custLocation": null,
                "custEmail": null,
                "custPhone": null,
                "baseStationId": null,
                "linkId": null
            }

            for (key in generalObj) {
                var val = generalObj[key]
                var val1 = $scope.prevProperties[key];
                if (generalObj[key] == val1) {
                    /*if (key == "channel") {
                        generalObj[key] = null;
                    } else {
                        generalObj[key] = -1;
                    }*/
                    generalObj[key] = null;
                    console.log('Not Changed ' + generalObj[key]);
                } else {
                    console.log(key + '*Changed ' + $scope.prevProperties[key]);
                }
            }

            var confirm = $scope.saveconfirm();
            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodemanageview/savesystemconfig',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: generalObj
                }).success(function () {
                    $scope.showAlert('success', 'Saved Successfully');
                    $scope.management_general();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error updating data: ' + msg);
                });
            });
        }
        //get call for logging
        $scope.management_logging = function () {
            $scope.prevProperties = {};
            var url = 'api/v2/nodemanageview/systemconfig?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.system_logging = response.data;
                        angular.copy(response.data, $scope.prevProperties);
                        if ($scope.system_logging.tempLogStatus == 0) {
                            $scope.system_logging.tmpstat = false;
                        } else {
                            $scope.system_logging.tmpstat = true;
                        }
                        console.log("$scope.system_logging", $scope.system_logging);
                        //           $scope.viewNode = viewNode;
                    }
                });
        }
        // Management > System > Logging POST call
        $scope.mgmt_system_logging = function () {
            if ($scope.system_logging.tmpstat == false) {
                $scope.system_logging.tempLogStatus = 0;
            } else {
                $scope.system_logging.tempLogStatus = 1;
            }
            var loggingObj = {
                "radio": $scope.system_logging.radio,
                "nodeId": $state.params.nodeId,
                "status": $scope.system_logging.status,
                "message": $scope.system_logging.message,

                "ntpStatus": -1,
                "ntpServerIP": null,
                "timeZone": null,
                "gpsStatus": -1,
                "gpsInterval": -1,
                "dyingGaspStatus": -1,
                /*"akcStatus": $scope.system_logging.akcStatus,*/

                "syslogServerIP": $scope.system_logging.syslogServerIP,
                "syslogServerPort": $scope.system_logging.syslogServerPort,
                "tempLogStatus": $scope.system_logging.tempLogStatus,
                "tempLogInterval": $scope.system_logging.tempLogInterval,

                "custName": null,
                "custLocation": null,
                "custEmail": null,
                "custPhone": null,
                "baseStationId": null,
                "linkId": null
            }

            for (key in loggingObj) {
                var val = loggingObj[key]
                if (loggingObj[key] == $scope.prevProperties[key]) {
                    if (isNaN(val)) {
                        loggingObj[key] = null;
                    } else {
                        if (key == "channel") {
                            loggingObj[key] = null;
                        } else {
                            loggingObj[key] = -1;
                        }
                    }
                    console.log('Not Changed ' + loggingObj[key]);
                } else {
                    console.log(key + '*Changed ' + $scope.prevProperties[key]);
                }
            }

            var confirm = $scope.saveconfirm();
            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodemanageview/savesystemconfig',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: loggingObj
                }).success(function () {
                    $scope.showAlert('success', 'Saved Successfully');
                    $scope.management_logging();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error updating data: ' + msg);
                });
            });
        }
        //get call for location
        $scope.management_location = function () {
            $scope.prevProperties = {};
            var url = 'api/v2/nodemanageview/systemconfig?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.system_location = response.data;
                        angular.copy(response.data, $scope.prevProperties);
                        console.log("$scope.system_location", $scope.system_location);
                        //       $scope.viewNode = viewNode;
                    }
                });
        }

        $scope.replaceHardware = function () {
            var n = nodesToApply
            var confirm = $scope.saveconfirm();
            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/profiles/rephard/' + n + '/' + $state.params.nodeId
                    /*headers: {
                        'Content-Type': 'application/json'
                    },
                    data: locationObj*/
                }).success(function () {
                    $scope.showAlert('success', 'Saved Successfully');
                    $scope.management_location();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error updating data: ' + msg);
                });
            });
        }

        // Management > System > Location POST call
        $scope.mgmt_system_location = function () {
            var locationObj = {
                "radio": $scope.system_location.radio,
                "nodeId": $state.params.nodeId,
                "status": $scope.system_location.status,
                "message": $scope.system_location.message,

                "ntpStatus": -1,
                "ntpServerIP": null,
                "timeZone": null,
                "gpsStatus": -1,
                "gpsInterval": -1,
                "dyingGaspStatus": -1,
                /*"akcStatus": $scope.system_location.akcStatus,*/

                "syslogServerIP": null,
                "syslogServerPort": -1,
                "tempLogStatus": -1,
                "tempLogInterval": -1,

                "custName": $scope.system_location.custName,
                "custLocation": $scope.system_location.custLocation,
                "custEmail": $scope.system_location.custEmail,
                "custPhone": $scope.system_location.custPhone,
                "baseStationId": $scope.system_location.baseStationId,
                "linkId": $scope.system_location.linkId
            }

            for (key in locationObj) {
                var val = locationObj[key]
                var val1 = $scope.prevProperties[key];
                if (locationObj[key] == val1) {
                    locationObj[key] = null;
                    console.log('Not Changed ' + locationObj[key]);
                } else {
                    console.log(key + '*Changed ' + $scope.prevProperties[key]);
                }
            }

            var confirm = $scope.saveconfirm();
            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodemanageview/savesystemconfig',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: locationObj
                }).success(function () {
                    $scope.showAlert('success', 'Saved Successfully');
                    $scope.management_location();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error updating data: ' + msg);
                });
            });
        }
        //get call for http
        $scope.management_http = function () {
            var url = 'api/v2/nodemanageview/serviceshttp?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.serviceshttpData = response.data;
                        if ($scope.serviceshttpData.httpStatus == 0) {
                            $scope.serviceshttpData.httpenable = false;
                        } else {
                            $scope.serviceshttpData.httpenable = true;
                        }
                        console.log("$scope.serviceshttpData", $scope.serviceshttpData);
                        //       $scope.viewNode = viewNode;
                    }
                });
        }

        $scope.resetPassword = function (pwd) {
            var pass = pwd;
            var changed = false;
            for (var i = 0; i < pass.length; i++) {
                if (pass.charAt(i) != '*') {
                    changed = true;
                    return pass;
                }
            }
            return null;
        }

        // Management > Services > HTTP  POST call
        $scope.mgmt_services_http = function () {
            if ($scope.serviceshttpData.httpenable == false) {
                $scope.serviceshttpData.httpStatus = 0;
            } else {
                $scope.serviceshttpData.httpStatus = 1;
            }
            var adPass = $scope.resetPassword($scope.serviceshttpData.adminPassword);
            var uPass = $scope.resetPassword($scope.serviceshttpData.userPassword);
            var suPass = $scope.resetPassword($scope.serviceshttpData.superUserPassword);
            var iPass = $scope.resetPassword($scope.serviceshttpData.installerPassword);

            if ($scope.serviceshttpData.adminPassword)
                var httpObj = {
                    "radio": $scope.serviceshttpData.radio,
                    "nodeId": $state.params.nodeId,
                    "status": $scope.serviceshttpData.status,
                    "message": $scope.serviceshttpData.message,
                    "adminPassword": adPass,
                    "userPassword": uPass,
                    "superUserPassword": suPass,
                    "installerPassword": iPass,
                    "httpStatus": -1,
                    "httpPort": -1
                }

            var confirm = $scope.saveconfirm();
            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodemanageview/savehttp',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: httpObj
                }).success(function () {
                    $scope.showAlert('success', 'Saved Successfully');
                    $scope.management_http();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error updating data: ' + msg);
                });
            });
        }
        //get call for telnet
        $scope.management_telnet = function () {
            var url = 'api/v2/nodemanageview/servicestelnet?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.servicestelnetData = response.data;
                        if ($scope.servicestelnetData.telnetStatus == 0) {
                            $scope.servicestelnetData.telnetenable = false;
                        } else {
                            $scope.servicestelnetData.telnetenable = true;
                        }
                        if ($scope.servicestelnetData.sshStatus == 0) {
                            $scope.servicestelnetData.sshenable = false;
                        } else {
                            $scope.servicestelnetData.sshenable = true;
                        }
                        console.log(" $scope.servicestelnetData", $scope.servicestelnetData);
                        //       $scope.viewNode = viewNode;
                    }
                });
        }
        // Management > Services > Telnet  POST call
        $scope.mgmt_services_telnet = function () {

            if ($scope.servicestelnetData.telnetenable == false) {
                $scope.servicestelnetData.telnetStatus = 0;
            } else {
                $scope.servicestelnetData.telnetStatus = 1;
            }
            if ($scope.servicestelnetData.sshenable == false) {
                $scope.servicestelnetData.sshStatus = 0;
            } else {
                $scope.servicestelnetData.sshStatus = 1;
            }
            var telnetObj = {
                "radio": $scope.servicestelnetData.radio,
                "nodeId": $state.params.nodeId,
                "status": $scope.servicestelnetData.status,
                "message": $scope.servicestelnetData.message,
                "telnetStatus": $scope.servicestelnetData.telnetStatus,
                "telnetSessions": $scope.servicestelnetData.telnetSessions,
                "sshStatus": $scope.servicestelnetData.sshStatus,
                "sshSessions": $scope.servicestelnetData.sshSessions
            }

            var confirm = $scope.saveconfirm();
            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodemanageview/savetelnet',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: telnetObj
                }).success(function () {
                    $scope.showAlert('success', 'Saved Successfully');
                    $scope.management_telnet();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error updating data: ' + msg);
                });
            });
        }
        //get call for snmp
        $scope.management_snmp = function () {
            $scope.prevSnmpProp = {};
            $scope.snmpVersionArray = [{
                "snmpVersion": "v1",
                "snmpVersionVal": "SNMPv1"
            }, {
                "snmpVersion": "any",
                "snmpVersionVal": "SNMPv1-v2c"
            }];
            var url = 'api/v2/nodemanageview/servicessnmp?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.servicessnmpData = response.data;
                        angular.copy(response.data, $scope.prevSnmpProp);
                        if ($scope.servicessnmpData.snmpStatus == 0) {
                            $scope.servicessnmpData.snmpenable = false;
                        } else {
                            $scope.servicessnmpData.snmpenable = true;
                        }
                        $scope.servicessnmpData.snmpVersionName = {
                            snmpVersion: $scope.servicessnmpData.snmpVersion
                        }
                        console.log(" $scope.servicessnmpData", $scope.servicessnmpData);
                    }
                });
        }


        $scope.mgmt_reset = function () {

            var confirm = $scope.resetConfirm();
            console.log("retain value" + $scope.retainIPReset)
            $mdDialog.show(confirm).then(function () {
                var reset = 0;
                if ($scope.retainIPReset == true) {
                    var reset = 1;
                }

                var url = 'api/v2/nodelinks/reset/' + $state.params.nodeId + '/' + reset;

                $http({
                    method: 'POST',
                    url: url,
                    headers: {
                        'Content-Type': 'application/json'
                    }
                }).success(function () {
                    $scope.showAlert('success', 'Saved Successfully');
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error updating data: ' + msg);
                });
            });

        }

        $scope.loadRegions = function () {
            var url = 'api/v2/treeview/regions';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.basestation = response.data;
                        $scope.regions = response.data;
                    }
                });
        }

        // On Region Change, Load Locations of selected region
        $scope.regionChange = function (regionId) {
            $scope.DynamicUrl = "&ar=reg&facilities=" + regionId.data.id;
            $scope.facility = regionId.data.id;

            var url = 'api/v2/treeview/regions/' + regionId.data.id + '/locations';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.locations = response.data;
                        $scope.facilities = "";
                    }
                });
        }

        // On Location Change, Load Facilities of selected location
        $scope.locationChange = function (locationID) {
            $scope.DynamicUrl = "&ar=loc&facilities=" + locationID.data.id;
            $scope.facility = locationID.data.id;

            var url = 'api/v2/treeview/locations/' + locationID.data.id + '/facilities';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.facilities = response.data;
                        //                                $scope.div_select = srcval;
                    }
                });
        }

        // On Facility Change, Load Nodes of selected Facility
        $scope.facilityChange = function (facilityId) {
            /* var rm = 'ap';
             if (radioMode == 'SU') {
                 rm = 'sta';
             }

             var lt = linkType.toLowerCase();*/
            $scope.basestations = [];
            $scope.nodesToApply = -1;
            $scope.DynamicUrl = "&ar=fac&facilities=" + facilityId.data.id;
            $scope.facility = facilityId.data.id;
            facilityId = facilityId.data.id;
            var url = 'api/v2/treeview/facility/' + facilityId + '/treenodes';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        //$scope.basestations = response.data;
                        for (var i = 0; i < response.data.length; i++) {
                            console.log(response.data[i].text);
                            $scope.basestations.push(response.data[i]);
                            if (response.data[i].children.length > 0) {
                                var child = response.data[i].children;
                                for (var j = 0; j < child.length; j++) {
                                    console.log(child[j].text);
                                    $scope.basestations.push(child[j]);
                                }
                            } /*else {
                                        console.log(response.data[i].text);
                                    }*/
                        }
                    }
                });
        }


        $scope.replaceHardware = function () {
            if ($scope.nodesToApply != -1) {
                var from = $scope.nodesToApply[0];
                $http({
                    method: 'POST',
                    url: 'api/v2/profiles/rephard/' + from + '/' + $state.params.nodeId,
                }).success(function () {
                    $scope.showAlert('success', 'Saved Successfully');
                    $scope.management_snmp();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error updating data: ' + msg);
                });
            }
        }

        $scope.selectedDevice = function (deviceID) {
            $scope.nodesToApply = [];
            if (deviceID.selected == "") {
                deviceID.selected = 'trselected';
                $scope.nodesToApply.push(deviceID.data.id);
            } else {
                deviceID.selected = '';
                var remo = -1;
                for (var i = 0; i < $scope.nodesToApply.length; i++) {
                    if ($scope.nodesToApply[i] == deviceID.data.id) {
                        $scope.nodesToApply.splice(i, 1);
                        i--;
                    }
                }
            }

        }

        $scope.saveconfirm = function (ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to update this changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')


            return confirm;
        };


        $scope.resetConfirm = function (ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to reset the changes?')
                .targetEvent(ev)
                .ok('Reset Device')
                .cancel('Cancel')


            return confirm;
        };

        $scope.resetPassword = function (pwd) {
            var pass = pwd;
            var changed = false;
            for (var i = 0; i < pass.length; i++) {
                if (pass.charAt(i) != '*') {
                    changed = true;
                    return pass;
                }
            }
            return null;
        }
        // Management > Services > SNMP  POST call
        $scope.mgmt_services_snmp = function () {
            if ($scope.servicessnmpData.snmpenable == false) {
                $scope.servicessnmpData.snmpStatus = 0;
            } else {
                $scope.servicessnmpData.snmpStatus = 1;
            }
            var rdPass = $scope.resetPassword($scope.servicessnmpData.readPassword);
            var hPass = $scope.resetPassword($scope.servicessnmpData.hostPassword);
            var wPass = $scope.resetPassword($scope.servicessnmpData.writePassword);
            var snmpObj = {
                "radio": $scope.servicessnmpData.radio,
                "nodeId": $state.params.nodeId,
                "status": $scope.servicessnmpData.status,
                "message": $scope.servicessnmpData.message,
                "snmpStatus": null,
                "snmpVersion": $scope.servicessnmpData.snmpVersionName.snmpVersion,
                "readPassword": rdPass,
                "writePassword": wPass,
                "hostAddress": $scope.servicessnmpData.hostAddress,
                "hostPassword": hPass
            }
            if (snmpObj.snmpVersion == $scope.prevSnmpProp.snmpVersion) {
                snmpObj.snmpVersion = null;
            }
            if (snmpObj.hostAddress == $scope.prevSnmpProp.hostAddress) {
                snmpObj.hostAddress = null;
            }
            var confirm = $scope.saveconfirm();
            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodemanageview/savesnmp',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: snmpObj
                }).success(function () {
                    $scope.showAlert('success', 'Saved Successfully');
                    $scope.management_snmp();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error updating data: ' + msg);
                });
            });
        }


  $scope.nodemanagementMasking = function (inputid, maskid) {
              var x = document.getElementById(inputid);
              var y = document.getElementById(maskid);
              if (x.type === "password") {
                x.type = "text";
                y.src = "./images/eye.png";
              } else {
                x.type = "password";
                y.src = "./images/eye-slash.png";
              }
            }

        //Password mask unmask functionality for Admin
        $scope.adminMasking = function () {
            var x = document.getElementById("input_j_passwordadmin");
            var y = document.getElementById("mask-revealadmin");
            if (x.type === "password") {
                x.type = "text";
                y.src = "./images/eye.png";
            } else {
                x.type = "password";
                y.src = "./images/eye-slash.png";
            }
        }

        //Password mask unmask functionality for User
        $scope.userMasking = function () {
            var x = document.getElementById("input_j_passworduser");
            var y = document.getElementById("mask-revealuser");
            if (x.type === "password") {
                x.type = "text";
                y.src = "./images/eye.png";
            } else {
                x.type = "password";
                y.src = "./images/eye-slash.png";
            }
        }

        //Password mask unmask functionality for Superuser
        $scope.superuserMasking = function () {
            var x = document.getElementById("input_j_password3");
            var y = document.getElementById("mask-reveal3");
            if (x.type === "password") {
                x.type = "text";
                y.src = "./images/eye.png";
            } else {
                x.type = "password";
                y.src = "./images/eye-slash.png";
            }
        }

        //Password mask unmask functionality for Installer
        $scope.installerMasking = function () {
            var x = document.getElementById("input_j_password4");
            var y = document.getElementById("mask-reveal4");
            if (x.type === "password") {
                x.type = "text";
                y.src = "./images/eye.png";
            } else {
                x.type = "password";
                y.src = "./images/eye-slash.png";
            }
        }

        //Read Password mask unmask functionality in SNMP
        $scope.readpasswordMasking = function () {
            var x = document.getElementById("input_j_password5");
            var y = document.getElementById("mask-reveal5");
            if (x.type === "password") {
                x.type = "text";
                y.src = "./images/eye.png";
            } else {
                x.type = "password";
                y.src = "./images/eye-slash.png";
            }
        }

        //Write Password mask unmask functionality in SNMP
        $scope.writepasswordMasking = function () {
            var x = document.getElementById("input_j_password6");
            var y = document.getElementById("mask-reveal6");
            if (x.type === "password") {
                x.type = "text";
                y.src = "./images/eye.png";
            } else {
                x.type = "password";
                y.src = "./images/eye-slash.png";
            }
        }

        $scope.changedManagementArray = [];
        $scope.managementObj = function (group, key, modelvalue, indexvalue) {
            if (key == 'ntpStat' || key == 'telnetenable' || key == 'sshenable' || key == 'snmpenable' || key == 'tmpstat') {
                if (modelvalue) {
                    modelvalue = 1;
                } else {
                    modelvalue = 0;
                }
            }
            // if(key=='adminPassword'){
            //     modelvalue = $scope.resetPassword($scope.serviceshttpData.adminPassword);
            // }           
            // var uPass = $scope.resetPassword($scope.serviceshttpData.userPassword);
            // var suPass = $scope.resetPassword($scope.serviceshttpData.superUserPassword);
            // var iPass = $scope.resetPassword($scope.serviceshttpData.installerPassword);
            if (modelvalue!="" && modelvalue!=null && modelvalue!=undefined) {
                $scope.exist = false;
                if ($scope.changedManagementArray.length > 0) {
                    for (var i = 0; i < $scope.changedManagementArray.length; i++) {
                        if ($scope.changedManagementArray[i].key == key) {
                            $scope.changedManagementArray[i].value = modelvalue;
                            $scope.exist = true;
                        }
                    }
                }
                if (!$scope.exist) {
                    $scope.changedManagementArray.push({ "group": group, "key": key, "value": modelvalue,"index":indexvalue });
                }
                console.log("changedManagementArray", $scope.changedManagementArray);
            }
        }

        $scope.saveManagement = function () {
            console.log("save management obj", $scope.changedManagementArray);
            if ($scope.changedManagementArray.length > 0) {
                var confirm = $scope.saveconfirm();
                $mdDialog.show(confirm).then(function () {
                    $http({
                        method: 'POST',
                        url: 'api/v2/nodemanageview/mansave/' + $state.params.nodeId,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        data: $scope.changedManagementArray
                    }).success(function () {
                        $scope.showAlert('success', 'Saved successfully.');
                        // $scope.management_general();
                        // $scope.management_logging();
                        // $scope.management_location();
                        // $scope.management_http();
                        // $scope.management_telnet();
                        // $scope.management_snmp();
                        // $scope.loadRegions();
                        $scope.changedManagementArray = [];
                        $scope.get_save_changes();
                    }).error(function (msg) {
                        $scope.showAlert('error', 'Error creating Data: ' + msg);
                    });
                });
            }
        }

        $scope.applyFunManagement = function () {
            $scope.get_save_changes();
            $("#showchangesManagement").modal('show');
        }

        $scope.commitManagement = function () {
            for (var i = 0; i < $scope.saveChangesObj.changes.length; i++) {
                var splitobj = $scope.saveChangesObj.changes[i].key.split('_');
                $scope.saveChangesObj.changes[i].group = splitobj[0];
                $scope.saveChangesObj.changes[i].key = splitobj[1];
            }
            console.log("commit", $scope.saveChangesObj.changes);
            $http({
                method: 'POST',
                url: 'api/v2/profiles/save/' + $state.params.nodeId,
                headers: {
                    'Content-Type': 'application/json'
                },
                data: $scope.saveChangesObj.changes
            }).success(function () {
                $scope.showAlert('success', 'Saved successfully.');
                $("#showchangesManagement").modal('hide');
                $scope.management_general();
                $scope.management_logging();
                $scope.management_location();
                $scope.management_http();
                $scope.management_telnet();
                $scope.management_snmp();
                $scope.loadRegions();
                $scope.get_save_changes();
            }).error(function (msg) {
                $("#showchangesManagement").modal('hide');
                $scope.showAlert('error', 'Error creating Data: ' + msg);
            });
        }

        $scope.revertManagement = function () {
            for (var i = 0; i < $scope.saveChangesObj.changes.length; i++) {
                var splitobj = $scope.saveChangesObj.changes[i].key.split('_');
                $scope.saveChangesObj.changes[i].group = splitobj[0];
                $scope.saveChangesObj.changes[i].key = splitobj[1];
            }
            $http({
                method: 'POST',
                url: 'api/v2/profiles/revert/' + $state.params.nodeId,
                headers: {
                    'Content-Type': 'application/json'
                },
                data: $scope.saveChangesObj.changes
            }).success(function () {
                $scope.showAlert('success', 'Saved successfully.');
                $("#showchangesManagement").modal('hide');
                $scope.management_general();
                $scope.management_logging();
                $scope.management_location();
                $scope.management_http();
                $scope.management_telnet();
                $scope.management_snmp();
                $scope.loadRegions();
                $scope.get_save_changes();
            }).error(function (msg) {
                $("#showchangesManagement").modal('hide');
                $scope.showAlert('error', 'Error creating Data: ' + msg);
            });
        }
    }
]);
