dashboard.controller("NodeViewNetworkController", ['$localStorage', '$rootScope', '$scope', '$mdDialog', '$http', '$state', 'dashboardService', 'Flash', '$interval',
    function ($localStorage, $rootScope, $scope, $mdDialog, $http, $state, dashboardService, Flash, $interval) {
        //    init method it checks selected view and activate get call based on rootscope.selectedView
        $scope.init = function () {
            $scope.get_save_changes();
            $scope.network_ip_config();
            $scope.network_vlan_config();
            $scope.network_ehhernet_dhcp();
            $scope.network_ehhernet_radius();
            $scope.network_ethernet_config();
            if ($rootScope.selectedView == 'network-dhcpconfig') {
                $scope.network_ehhernet_dhcp();
            }
            if ($rootScope.selectedView == 'network-ethernetradius') {
                $scope.network_ehhernet_radius();
            }
            if ($rootScope.selectedView == 'network-ethernetconfig') {
                $scope.network_ethernet_config();
            }
            if ($rootScope.selectedView == 'network-vlanconfig') {
                $scope.network_vlan_config();
            }
            if ($rootScope.selectedView == 'network-ipconfig') {
                $scope.network_ip_config();
            }
        }

        $scope.saveChangesObj = {};
        $scope.get_save_changes = function () {
            var url = 'api/v2/nodes/changes/' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.saveChangesObj = response.data;
                        $rootScope.networkapply = response.data.available;
                        $rootScope.networkchanges = response.data.changes;
                        console.log("$rootScope.networkchanges", $rootScope.networkchanges);
                        console.log("$scope.saveChangesObj", $scope.saveChangesObj);
                    }
                });
        }

        $scope.saveconfirm = function (ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to update this changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')


            return confirm;
        };
        //get call for network_ip_config;
        $scope.network_ip_config = function () {

            $scope.nrMode = $rootScope.radioMode;
            $scope.nrLink = $rootScope.linkType;
            $scope.prevProperties = {};

            /* $scope.nrMode = {
                 value: $rootScope.radioMode
             }*/
            $scope.networkMode = [{
                "mode": 1,
                "modeVal": "Bridge"
            }, {
                "mode": 2,
                "modeVal": "Routing"
            }];
            $scope.address = [{
                "addressType": 'static',
                "addressTypeVal": "Static"
            }, {
                "addressType": 'dhcp',
                "addressTypeVal": "Dynamic"
            }];
            $scope.netStatus = [{
                "status": 0,
                "statusVal": "Disable"
            }, {
                "status": 1,
                "statusVal": "Enable"
            }];
            var url = 'api/v2/nodenetview/ipconfig?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.netipconfigData = response.data;
                        var obj=$scope.netipconfigData.dnsIP.split(' ');
                        $scope.netipconfigData.dnsIP=obj[0];
                        $scope.netipconfigData.dnsIP1 = obj[1];
                        angular.copy(response.data, $scope.prevProperties);
                        $scope.netipconfigData.nMode = {
                            mode: $scope.netipconfigData.mode
                        }
                        $scope.netipconfigData.stat = {
                            status: $scope.netipconfigData.status
                        }
                        $scope.netipconfigData.adres = {
                            addressType: $scope.netipconfigData.addressType
                        }
                        //$scope.viewNode = viewNode;
                    }
                });
        }

        $scope.disableNetworkMode = function () {
            var disable = false;
            if ($scope.nrMode == 1) {
                disable = true;
            } else if ($scope.nrMode == 2) {
                if ($scope.nrLink != 2) {
                    disable = false;
                } else {
                    if ($scope.netipconfigData != undefined) {
                        var value = $scope.networkMode[0].mode;
                        var val = $scope.netipconfigData.nMode.mode;
                        if (val != value) {
                            $scope.netipconfigData.nMode = {
                                mode: value
                            }
                        }
                    }
                    disable = true;
                }

            }

            /*if ($scope.nrLink == 2) {
                if ($scope.netipconfigData != undefined) {
                    var value = $scope.networkMode[0].mode;
                    var val = $scope.netipconfigData.nMode.mode;
                    if (val != value) {
                        $scope.netipconfigData.nMode = {
                            mode:value
                        }
                    }
                }

                return true;
            }*/
            return disable;//netipconfigData.nMode
        }
   $scope.nodeMasking = function (inputid, maskid) {
              var x = document.getElementById(inputid);
              var y = document.getElementById(maskid);
              if (x.type === "password") {
                x.type = "text";
                y.src = "./images/eye.png";
              } else {
                x.type = "password";
                y.src = "./images/eye-slash.png";
              }
            }
        //post call for network_ip_config;
        $scope.network_ipconfig = function () {
            var obj = {
                "radio": $scope.netipconfigData.radio,
                "nodeId": $state.params.nodeId,
                "addressType": $scope.netipconfigData.adres.addressType,
                "ipAddress": $scope.netipconfigData.ipAddress,
                "netMask": $scope.netipconfigData.netMask,
                "gateway": $scope.netipconfigData.gateway,
                "dnsIP": $scope.netipconfigData.dnsIP,
                "clearStats": null,
                "mode": $scope.netipconfigData.nMode.mode,
                "natStatus": $scope.netipconfigData.stat.status,
                "wirelessIpAddress": $scope.netipconfigData.wirelessIpAddress,
                "wirelessNetMask": $scope.netipconfigData.wirelessNetMask
            }

            for (key in obj) {
                var val = obj[key]
                var val1 = $scope.prevProperties[key];
                if (obj[key] == val1) {
                    if (isNaN(val)) {
                        obj[key] = null;
                    } else {
                        obj[key] = -1;
                    }
                    console.log('Not Changed ' + obj[key]);
                } else {
                    console.log(key + '*Changed ' + $scope.prevProperties[key]);
                }
            }

            var confirm = $scope.saveconfirm();

            $mdDialog.show(confirm).then(function () {

                $http({
                    method: 'POST',
                    url: 'api/v2/nodenetview/uipconfig',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: obj
                }).success(function () {
                    $scope.showAlert('success', 'Saved successfully.');
                    $scope.network_ip_config();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error creating Data: ' + msg);
                });
            });
        }

        //get call for network valnconfig
        $scope.network_vlan_config = function () {
            $scope.vlanProfileObj = {};
            $scope.prevProperties = {};
            // $scope.radioMode = [{
            //         'name': "All",
            //         'value': -1
            //     },
            //     {
            //         'name': "AP",
            //         'value': 1
            //     }, {
            //         'name': "SU",
            //         'value': 2
            //     }
            // ];
            $scope.vlanModes = [{
                "vlanMode": 0,
                "vlanmodeVal": "Transparent"
            }, {
                "vlanMode": 1,
                "vlanmodeVal": "Access"
            }, {
                "vlanMode": 2,
                "vlanmodeVal": "Trunk"
            }, {
                "vlanMode": 3,
                "vlanmodeVal": "Q-in-Q"
            }];

            $scope.linkType = [{
                'name': "All",
                'value': -1
            }, {
                'name': "PTP",
                'value': 1
            }, {
                'name': "BackHaul",
                'value': 2
            }, {
                'name': "PTMP",
                'value': 3
            }];
            $scope.vlanStatus = [{
                "vlanStatus": 2,
                "vlanstatusVal": "Disable"
            }, {
                "vlanStatus": 1,
                "vlanstatusVal": "Enable"
            }];


            $scope.svLanEthObj = [{
                'name': '0x8100',
                'value': '0x0081'
            },
            {
                'name': '0x88a8',
                'value': '0xa888'
            },
            {
                'name': '0x9100',
                'value': '0x0091'
            },
            {
                'name': '0x9200',
                'value': '0x0092'
            }
            ];
            $scope.trunkObj = [{
                "vlanTrunkOptionId": 1,
                "trunkVal": "List"
            }, {
                "vlanTrunkOptionId": 2,
                "trunkVal": "All"
            }];
            var url = 'api/v2/nodenetview/vlanconfig?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        angular.copy(response.data, $scope.prevProperties);
                        $scope.vlanProfileObj.rMode = {
                            value: $rootScope.radioMode
                        }
                        $scope.vlanProfileObj.rmodeName = $rootScope.radioMode
                        $scope.vlanProfileObj.lType = {
                            value: response.data.linkType
                        }
                        $scope.vlanProfileObj.linkTypeName = $rootScope.linkType
                        $scope.vlanProfileObj.vlStatus = {
                            vlanStatus: response.data.vlanStatus
                        }
                        if (response.data.vlanStatus == 1) {
                            $scope.disableRemainingcomponents = true;

                        } else {
                            $scope.disableRemainingcomponents = false;
                            //first reset all values
                            $scope.vlanProfileObj.vlMode = '';
                            $scope.vlanProfileObj.vlanMgmtId = '';
                            $scope.vlanProfileObj.vlanAccessId = '';
                            $scope.vlanProfileObj.trnkMode = '';
                            $scope.vlanProfileObj.vlanTrunkId = '';
                            $scope.vlanProfileObj.sVlanID = '';
                            $scope.vlanProfileObj.svlanTypeID = '';
                            $scope.optionArray = [];
                        }

                        $scope.vlanProfileObj.vlMode = {
                            vlanMode: response.data.vlanMode
                        }
                        if (response.data.vlanMode == 3) {
                            $scope.selectedSubDiv = 'Q-in-Q';
                        } else if (response.data.vlanMode == 2) {
                            $scope.selectedSubDiv = 'Trunk';
                            //$scope.trunkvlanID = true;
                        } else if (response.data.vlanMode == 0) {
                            $scope.selectedSubDiv = 'Transparent';
                        } else if (response.data.vlanMode == 1) {
                            $scope.selectedSubDiv = 'Access';
                        }
                        // if(!$rootScope.linkType){
                        // var url = 'api/v2/nodemanageview/summary?nodeId=' +  $state.params.nodeId;
                        // $http.get(url)
                        //     .then(function (response) {
                        //         if (response.data) {
                        //             debugger
                        //             $rootScope.linkType= response.data.radio5Ghz.linkType;
                        //             console.log("nodeviewnetwork link type",$rootScope.linkType);
                        //             showVlanModes();                  
                        //         }
                        //     });                 
                        // }   
                        showVlanModes();
                        $scope.vlanProfileObj.vlanMgmtId = response.data.vlanMgmtId;
                        $scope.vlanProfileObj.vlanAccessId = response.data.vlanAccessId;
                        $scope.vlanProfileObj.trnkMode = {
                            vlanTrunkOptionId: response.data.vlanTrunkOptionId
                        }
                        if (response.data.vlanTrunkOptionId == 1) {
                            $scope.trunkvlanID = true;
                        } else {
                            $scope.trunkvlanID = false;
                        }
                        if (response.data.vlanTrunkId) {
                            $scope.optionArray = response.data.vlanTrunkId.split(' ');
                            $scope.trunkvlanID = true;
                        }
                        //$scope.vlanProfileObj.vlanTrunkId = response.data.vdto.vlanTrunkId;
                        $scope.vlanProfileObj.sVlanID = response.data.vlanSvlanId;
                        $scope.vlanProfileObj.svlanTypeID = {
                            value: response.data.vlanEtherType
                        }
                    }
                });
        }

        //vlan status change
        $scope.vlastatus = function (vstat) {
            if (vstat.vlanstatusVal == 'Disable') {
                $scope.disableRemainingcomponents = false;
                //first reset all values
                $scope.vlanProfileObj.vlMode = '';
                $scope.vlanProfileObj.vlanMgmtId = '';
                $scope.vlanProfileObj.vlanAccessId = '';
                $scope.vlanProfileObj.trnkMode = '';
                $scope.vlanProfileObj.vlanTrunkId = '';
                $scope.vlanProfileObj.sVlanID = '';
                $scope.vlanProfileObj.svlanTypeID = '';
                $scope.selectedSubDiv = "";
                $scope.trunkvlanID = false;
                $scope.optionArray = [];
            } else {
                $scope.disableRemainingcomponents = true;
                $scope.vlanProfileObj.vlanMgmtId = 1;
                showVlanModes();
            }
        }
        //radiotype change
        $scope.radioTypeChange = function (rMode) {
            $scope.vlanProfileObj.rmodeName = rMode.value;
            showVlanModes();
        }
        //link type change
        $scope.linkTypeChange = function (ltype) {
            $scope.vlanProfileObj.linkTypeName = ltype.value;

            showVlanModes();
        }

        function showVlanModes() {
            console.log("$scope.vlanProfileObj.rmodeName",$scope.vlanProfileObj.rmodeName);
            console.log("$scope.vlanProfileObj.linkTypeName ",$scope.vlanProfileObj.linkTypeName);
            if ($scope.vlanProfileObj.rmodeName && $scope.vlanProfileObj.linkTypeName) {
                if ($scope.vlanProfileObj.rmodeName == 2 && ($scope.vlanProfileObj.linkTypeName == 1 || $scope.vlanProfileObj.linkTypeName == 3)) {
                    $scope.vlanModes = [{
                        "vlanMode": 0,
                        "vlanmodeVal": "Transparent"
                    }, {
                        "vlanMode": 1,
                        "vlanmodeVal": "Access"
                    }, {
                        "vlanMode": 2,
                        "vlanmodeVal": "Trunk"
                    }, {
                        "vlanMode": 3,
                        "vlanmodeVal": "Q-in-Q"
                    }];
                    $scope.vlanProfileObj.vlMode = $scope.vlanModes[0];
                } else {
                    $scope.vlanModes = [{
                        "vlanMode": 0,
                        "vlanmodeVal": "Transparent"
                    }];
                    $scope.vlanProfileObj.vlMode = $scope.vlanModes[0];
                    $scope.selectedSubDiv = "";
                    $scope.vlanProfileObj.trnkMode = '';
                    $scope.vlanProfileObj.vlanTrunkId = '';
                    $scope.vlanProfileObj.vlanAccessId = '';
                    $scope.vlanProfileObj.sVlanID = '';
                    $scope.vlanProfileObj.svlanTypeID = '';
                    $scope.optionArray = [];
                }
            } else {
                $scope.vlanModes = [{
                    "vlanMode": 0,
                    "vlanmodeVal": "Transparent"
                }];
                $scope.vlanProfileObj.vlMode = $scope.vlanModes[0];
            }
        }

        //onchange method
        $scope.vlmodeChange = function (selectedvlmode) {
            if (selectedvlmode.vlanmodeVal == 'Transparent') {
                $scope.vlanProfileObj.trnkMode = '';
                $scope.vlanProfileObj.vlanTrunkId = '';
                $scope.vlanProfileObj.vlanAccessId = '';
                $scope.vlanProfileObj.sVlanID = '';
                $scope.vlanProfileObj.svlanTypeID = '';
                $scope.optionArray = [];
                $scope.selectedSubDiv = selectedvlmode.vlanmodeVal;
            } else if (selectedvlmode.vlanmodeVal == 'Access') {
                $scope.vlanProfileObj.trnkMode = '';
                $scope.vlanProfileObj.vlanTrunkId = '';
                $scope.vlanProfileObj.sVlanID = '';
                $scope.vlanProfileObj.svlanTypeID = '';
                $scope.optionArray = [];
                $scope.selectedSubDiv = selectedvlmode.vlanmodeVal;
            } else if (selectedvlmode.vlanmodeVal == 'Trunk') {
                $scope.vlanProfileObj.vlanAccessId = '';
                $scope.vlanProfileObj.sVlanID = '';
                $scope.vlanProfileObj.svlanTypeID = '';
                $scope.trunkObj = [{
                    "vlanTrunkOptionId": 1,
                    "trunkVal": "List"
                }, {
                    "vlanTrunkOptionId": 2,
                    "trunkVal": "All"
                }];
                $scope.vlanProfileObj.trnkMode = $scope.trunkObj[1];
                $scope.selectedSubDiv = selectedvlmode.vlanmodeVal;
                $scope.vltrunkChange($scope.vlanProfileObj.trnkMode);
            } else if (selectedvlmode.vlanmodeVal == 'Q-in-Q') {
                $scope.vlanProfileObj.vlanAccessId = '';
                $scope.selectedSubDiv = selectedvlmode.vlanmodeVal;

                $scope.vlanProfileObj.svlanTypeID = $scope.svLanEthObj[0];

                $scope.vlanProfileObj.trnkMode = $scope.trunkObj[1];
                $scope.selectedSubDiv = selectedvlmode.vlanmodeVal;
                $scope.vltrunkChange($scope.vlanProfileObj.trnkMode);
                $scope.vlanProfileObj.sVlanID = 100;
            }
        }
        //trunk change
        $scope.vltrunkChange = function (trnkMode) {
            if (trnkMode.trunkVal == 'List') {
                $scope.trunkvlanID = true;
            } else {
                $scope.trunkvlanID = false;
                $scope.optionArray = [];
            }
        }
        $scope.optionArray = [];

        $scope.changevlantrunk = false;
        //add trunk options temp
        $scope.addtrunkOptions = function () {           
            if ($scope.vlanProfileObj.vlanTrunkId && ($scope.vlanProfileObj.vlanTrunkId > 0 && $scope.vlanProfileObj.vlanTrunkId <= 4094)) {
                if ($scope.optionArray.length <= 100) {
                    var repeatVlanTrunkId = false;
                    for (var i = 0; i < $scope.optionArray.length; i++) {
                        if ($scope.optionArray[i] == $scope.vlanProfileObj.vlanTrunkId) {
                            repeatVlanTrunkId = true
                        }
                    }
                    if (!repeatVlanTrunkId) {
                        if($scope.optionArray.length>0){
                            if($scope.optionArray[0]=='-NA-'){
                                $scope.optionArray=[];
                            }
                        }
                        $scope.optionArray.push($scope.vlanProfileObj.vlanTrunkId);
                        $scope.changevlantrunk = true;
                    }

                } else {
                    $scope.showAlert("No more than 100 entries")
                }
            } else {
                $scope.showAlert("Please Enter Valid Input");
            }
            $scope.vlanProfileObj.vlanTrunkId = '';
        }

        //splice option
        $scope.deleteOption = function (ind) {
            $scope.optionArray.splice(ind, 1);
        }
        $scope.checkEthMTU = function(num) {
            if (num < 1500 || num > 9000) {
                $scope.ethProfileObj['ethMTU'] = "";
            }
        }
        //validationg vlan access id
        $scope.checknum = function (num, type) {
            if (num < 1 || num > 4094) {
                if (type == 'vlanMgmtId') {
                    $scope.vlanProfileObj[type] = "";
                } else if (type == 'vlanAccessId') {
                    $scope.vlanProfileObj[type] = "";
                } else if (type == 'sVlanID') {
                    $scope.vlanProfileObj[type] = "";
                } else if (type == 'vlanTrunkId') {
                    $scope.vlanProfileObj[type] = "";
                }
            }
        }
        //post call for vlan
        $scope.network_vlanconfig = function () {
            $scope.trunkID = "";
            if ($scope.optionArray.length > 0) {
                for (var i = 0; i < $scope.optionArray.length; i++) {
                    $scope.trunkID = $scope.trunkID + $scope.optionArray[i];
                    if (i + 1 < $scope.optionArray.length) {
                        $scope.trunkID = $scope.trunkID + " ";
                    }
                }
            }
            var obj = {
                "radio": $scope.vlanProfileObj.radio,
                "nodeId": $state.params.nodeId,
                "status": $scope.vlanProfileObj.status,
                "message": $scope.vlanProfileObj.message,
                "vlanStatus": $scope.vlanProfileObj.vlStatus.vlanStatus,
                "vlanMode": $scope.vlanProfileObj.vlMode ? $scope.vlanProfileObj.vlMode.vlanMode : null,
                "vlanMgmtId": $scope.vlanProfileObj.vlanMgmtId ? $scope.vlanProfileObj.vlanMgmtId : null,
                "vlanAccessId": $scope.vlanProfileObj.vlanAccessId ? $scope.vlanProfileObj.vlanAccessId : null,
                "vlanTrunkOptionId": $scope.vlanProfileObj.trnkMode ? $scope.vlanProfileObj.trnkMode.vlanTrunkOptionId : null,
                "vlanTrunkId": $scope.trunkID ? $scope.trunkID : null,
                "vlanSvlanId": $scope.vlanProfileObj.sVlanID ? $scope.vlanProfileObj.sVlanID : null,
                "vlanEtherType": $scope.vlanProfileObj.svlanTypeID ? $scope.vlanProfileObj.svlanTypeID.value : null,
                "vlanBackboneDestMAC": null,
                "vlanBackboneSrcMAC": null,
                "vlanBackboneVlanId": null,
                "vlanBackboneSrvInstanceVlanId": null
            }

            for (key in obj) {
                var val = obj[key]
                var val1 = $scope.prevProperties[key];
                if (obj[key] == val1) {
                    obj[key] = null;
                    console.log('Not Changed ' + obj[key]);
                } else {
                    console.log(key + '*Changed ' + $scope.prevProperties[key]);
                }
            }

            var confirm = $scope.saveconfirm();

            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodenetview/uvlanconfig',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: obj
                }).success(function () {
                    $scope.showAlert('success', 'Saved successfully.');
                    $scope.network_vlan_config();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error creating Data: ' + msg);
                });
            });
        }


        //get call for network ether config
        $scope.network_ethernet_config = function () {
            $scope.ethProfileObj = {};
            $scope.prevProperties = {};
            /* $scope.radioMode = [{
                     'name': "All",
                     'value': -1
                 },
                 {
                     'name': "AP",
                     'value': 1
                 }, {
                     'name': "SU",
                     'value': 2
                 }
             ];
             $scope.linkType = [{
                 'name': "All",
                 'value': -1
             }, {
                 'name': "PTP",
                 'value': 1
             }, {
                 'name': "BackHaul",
                 'value': 2
             }, {
                 'name': "PTMP",
                 'value': 3
             }];*/

            $scope.ethInActivityArray = [{
                "id": 0,
                "val": "Disable"
            }, {
                "id": 5,
                "val": "Enable"
            }];

            $scope.ethSpeedArray = [{
                "id": 0,
                "val": "Auto Negotiation"
            }, {
                "id": 4,
                "val": "100Mbps Full"
            }, {
                "id": 5,
                "val": "1000Mbps Full"
            }];
            var url = 'api/v2/nodenetview/ethconfig?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        angular.copy(response.data, $scope.prevProperties);
                        //$scope.ethProfileObj.ethName = response.data.name;
                        $scope.ethProfileObj.rMode = {
                            value: $rootScope.radioMode
                        }
                        $scope.ethProfileObj.lType = {
                            value: $rootScope.linkType
                        }
                        $scope.ethProfileObj.ethSpeed = {
                            id: response.data.ethMode
                        }
                        $scope.ethProfileObj.ethInactivity = {
                            id: response.data.ethInactivity
                        }
                        $scope.ethProfileObj.ethMTU = response.data.ethMTU
                        //$scope.viewNode = viewNode;                   
                    }
                });
        }
        //post call for network ether config
        $scope.network_ehhernet = function () {
            var obj = {
                "radio": $scope.ethProfileObj.radio,
                "nodeId": $state.params.nodeId,
                "ethInactivity": $scope.ethProfileObj.ethInactivity ? $scope.ethProfileObj.ethInactivity.id : $scope.ethProfileObj.ethInactivity,
                "ethMode": $scope.ethProfileObj.ethSpeed.id,
                "ethMTU": $scope.ethProfileObj.ethMTU ? $scope.ethProfileObj.ethMTU : $scope.ethProfileObj.ethMTU
            }
            for (key in obj) {
                var val = obj[key]
                var val1 = $scope.prevProperties[key];
                if (obj[key] == val1) {
                    if (isNaN(val)) {
                        obj[key] = null;
                    } else {
                        if (key == "channel") {
                            obj[key] = null;
                        } else {
                            obj[key] = -1;
                        }
                    }
                    console.log('Not Changed ' + obj[key]);
                } else {
                    console.log(key + '*Changed ' + $scope.prevProperties[key]);
                }
            }
            var confirm = $scope.saveconfirm();

            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodenetview/uetherconfig',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: obj
                }).success(function () {
                    $scope.showAlert('success', 'Saved successfully.');
                    $scope.network_ethernet_config();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error creating Data: ' + msg);
                });
            });

        }
        //get call for network ethernet radius
        $scope.network_ehhernet_radius = function () {
            $scope.prevProperties = {};
            /*$scope.radioMode = [{
                    'name': "All",
                    'value': -1
                },
                {
                    'name': "AP",
                    'value': 1
                }, {
                    'name': "SU",
                    'value': 2
                }
            ];
            $scope.linkType = [{
                'name': "All",
                'value': -1
            }, {
                'name': "PTP",
                'value': 1
            }, {
                'name': "BackHaul",
                'value': 2
            }, {
                'name': "PTMP",
                'value': 3
            }];*/
            $scope.radiusStatusArray = [{
                "id": 0,
                "val": "Disable"
            }, {
                "id": 1,
                "val": "Enable"
            }];

            var url = 'api/v2/nodenetview/radiusconfig?nodeId=' + $state.params.nodeId;
            $http.get(url, { showdiv: false })
                .then(function (response) {
                    if (response.data) {
                        $scope.radiusDefaultObj = {};
                        $scope.radiusProfileObj = {};
                        angular.copy(response.data, $scope.prevProperties);
                        $scope.radiusDefaultObj.rMode = {
                            value: $rootScope.radioMode
                        }
                        if ($rootScope.radioMode == 1) {
                            $scope.statusDiv = true;
                        } else {
                            $scope.statusDiv = false;
                        }
                        $scope.radiusDefaultObj.lType = {
                            value: $rootScope.linkType
                        }
                        //                    $scope.radiusDefaultObj.linkTypeName = response.data.linkType;
                        $scope.radiusDefaultObj.radiusStatus = {
                            id: response.data.radiusStatus
                        }
                        if ($rootScope.radioMode == 1 && response.data.radiusStatus == 1) {
                            $scope.subDiv = true;
                        } else {
                            $scope.subDiv = false;
                        }
                        $scope.radiusProfileObj.radiusPrimaryServer = response.data.radiusPrimaryServer;
                        $scope.radiusProfileObj.radiusPrimaryPort = response.data.radiusPrimaryPort;
                        $scope.radiusProfileObj.radiusPrimarySecret = response.data.radiusPrimarySecret;
                        $scope.radiusProfileObj.radiusSecondaryServer = response.data.radiusSecondaryServer;
                        $scope.radiusProfileObj.radiusSecondaryPort = response.data.radiusSecondaryPort;
                        $scope.radiusProfileObj.radiusSecondarySecret = response.data.radiusSecondarySecret;
                        $scope.radiusProfileObj.radiusAuthenticationTime = response.data.radiusAuthenticationTime;
                        $scope.radiusProfileObj.radiusRetryTime = response.data.radiusRetryTime;
                        $scope.radiusProfileObj.radiusRetryCount = response.data.radiusRetryCount;
                        $scope.radiusProfileObj.radiusRetryCountPeriod = response.data.radiusRetryCountPeriod;
                    }
                });
        }
        // Onchange for radius status
        $scope.radiusStatusChange = function (radiusStatus) {

            if (radiusStatus.val == 'Enable') {
                $scope.subDiv = true;
                //$scope.defaultProfileValues();
            } else {
                // set subDiv to false and clear the all subDiv components
                $scope.subDiv = false;
                //$scope.nullProfileValues();
            }
        }

        // IP Address check
        $scope.checkIP = function (ipAddress, group, type) {

            var ipRegex = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
            if (type == 'radiusPrimaryServer' || type == 'radiusSecondaryServer') {
                if (!ipAddress.match(ipRegex)) {
                    $scope[group][type] = "";
                }
            }
        }
        //Number Range check
        $scope.checknumport = function (num, group, type) {

            if (type == 'radiusPrimaryPort' || type == 'radiusSecondaryPort' || type == 'radiusRetryCount' || type == 'radiusRetryCountPeriod') {
                if (num < 1 || num > 65535) {
                    $scope.radiusProfileObj[type] = "";
                }
            } else if (type == 'radiusAuthenticationTime' || type == 'radiusRetryTime') {
                if (num < 10 || num > 65535) {
                    $scope.radiusProfileObj[type] = "";
                }
            }
        }
        //post call for network radius
        $scope.network_radius = function () {
            var obj = {
                "radio": $scope.radiusProfileObj.radio,
                "nodeId": $state.params.nodeId,
                "radiusStatus": $scope.radiusDefaultObj.radiusStatus ? $scope.radiusDefaultObj.radiusStatus.id : $scope.radiusStatusArray[0].id,
                "radiusPrimaryServer": $scope.radiusProfileObj.radiusPrimaryServer ? $scope.radiusProfileObj.radiusPrimaryServer : null,
                "radiusPrimaryPort": $scope.radiusProfileObj.radiusPrimaryPort ? $scope.radiusProfileObj.radiusPrimaryPort : null,
                "radiusPrimarySecret": $scope.radiusProfileObj.radiusPrimarySecret ? $scope.radiusProfileObj.radiusPrimarySecret : null,
                "radiusSecondaryServer": $scope.radiusProfileObj.radiusSecondaryServer ? $scope.radiusProfileObj.radiusSecondaryServer : null,
                "radiusSecondaryPort": $scope.radiusProfileObj.radiusSecondaryPort ? $scope.radiusProfileObj.radiusSecondaryPort : null,
                "radiusSecondarySecret": $scope.radiusProfileObj.radiusSecondarySecret ? $scope.radiusProfileObj.radiusSecondarySecret : null,
                "radiusAuthenticationTime": $scope.radiusProfileObj.radiusAuthenticationTime ? $scope.radiusProfileObj.radiusAuthenticationTime : null,
                "radiusRetryTime": $scope.radiusProfileObj.radiusRetryTime ? $scope.radiusProfileObj.radiusRetryTime : null,
                "radiusRetryCount": $scope.radiusProfileObj.radiusRetryCount ? $scope.radiusProfileObj.radiusRetryCount : null,
                "radiusRetryCountPeriod": $scope.radiusProfileObj.radiusRetryCountPeriod ? $scope.radiusProfileObj.radiusRetryCountPeriod : null
            }
            for (key in obj) {
                var val = obj[key]
                var val1 = $scope.prevProperties[key];
                if (obj[key] == val1) {
                    if (isNaN(val)) {
                        obj[key] = null;
                    } else {
                        obj[key] = -1;
                    }
                    //obj[key] = null;
                    console.log('Not Changed ' + obj[key]);
                } else {
                    console.log(key + '*Changed ' + $scope.prevProperties[key]);
                }
            }
            var confirm = $scope.saveconfirm();

            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodenetview/uradiusconfig',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: obj
                }).success(function () {
                    $scope.showAlert('success', 'Saved successfully.');
                    $scope.network_ehhernet_radius();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error creating Data: ' + msg);
                });
            });
        }

        //get call for network dhcp config
        $scope.network_ehhernet_dhcp = function () {
            $scope.defaultObj = {};
            $scope.fiveGHZObj = {};
            $scope.twopointfourGHZObj = {};
            $scope.prevProperties = {};
            /*$scope.radioMode = [{
                    'name': "All",
                    'value': -1
                },
                {
                    'name': "AP",
                    'value': 1
                }, {
                    'name': "SU",
                    'value': 2
                }
            ];*/
            /*$scope.linkType = [{
                'name': "All",
                'value': -1
            }, {
                'name': "PTP",
                'value': 1
            }, {
                'name': "BackHaul",
                'value': 2
            }, {
                'name': "PTMP",
                'value': 3
            }];*/
            $scope.dhcpServerArray = [{
                "id": 1,
                "val": "Disable"
            }, {
                "id": 0,
                "val": "Enable"
            }];
            var url = 'api/v2/nodenetview/dhcponfig?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.dhcpData = response.data;
                        angular.copy(response.data, $scope.prevProperties);
                        $scope.defaultObj.rMode = {
                            value: $rootScope.radioMode
                        }
                        $scope.defaultObj.lType = {
                            value: $rootScope.linkType
                        }
                        $scope.fiveGHZObj.dhcpServer = {
                            id: response.data.dhcpServer
                        }
                        if ($rootScope.radioMode == 1 && ($rootScope.linkType == 1 || $rootScope.linkType == 3)) {
                            $scope.fiveGHZ = true;
                        } else {
                            $scope.fiveGHZ = false;
                        }
                        if ($rootScope.radioMode == 1 && ($rootScope.linkType == 1 || $rootScope.linkType == 3) && response.data.dhcpServer == 0) {
                            $scope.subDiv5ghz = true;
                        } else {
                            $scope.subDiv5ghz = false;
                        }
                        $scope.fiveGHZObj.startIP = response.data.startIPAddress;
                        $scope.fiveGHZObj.endIP = response.data.endIPAddress;
                        $scope.fiveGHZObj.leaseTime = response.data.leaseTime;

                        $scope.twopointfourGHZObj.ipaddress = response.data.klanIPAddress;
                        $scope.twopointfourGHZObj.subnetmask = response.data.klanMask;

                        $scope.twopointfourGHZObj.dhcpServer = {
                            id: response.data.klandhcpServer
                        }

                        if (response.data.klandhcpServer == 0) {
                            $scope.subDiv2_4ghz = true;
                        }
                        $scope.twopointfourGHZObj.startIP = response.data.klanstartIPAddress;
                        $scope.twopointfourGHZObj.endIP = response.data.klanendIPAddress;
                        $scope.twopointfourGHZObj.leaseTime = response.data.klanleaseTime;
                    }
                });
        }

        //dhcp server sattsu change method
        $scope.dhcpServer5GHZ = function (dhcpServer) {
            if (dhcpServer.val == 'Disable') {
                $scope.subDiv5ghz = false;
                // $scope.subDiv2_4ghz = false;
                $scope.null5values();
            } else {
                $scope.subDiv5ghz = true;
                $scope.default5values();
            }
        }
        $scope.null5values = function() {
            $scope.fiveGHZObj.startIP = '';
            $scope.fiveGHZObj.endIP = '';
            $scope.fiveGHZObj.leaseTime = '';
        }
        $scope.default5values = function () {
            $scope.fiveGHZObj.startIP = '192.168.1.100';
            $scope.fiveGHZObj.endIP = '192.168.1.150';
            $scope.fiveGHZObj.leaseTime = 43200;
        }

        $scope.dhcpServer24GHZ = function (dhcpServer) {
            if (dhcpServer.val == 'Disable') {
                $scope.subDiv2_4ghz = false;
            } else {
                $scope.subDiv2_4ghz = true;
                $scope.default24values();
            }
        }
        $scope.default24values = function() {
            $scope.twopointfourGHZObj.startIP = '192.168.1.100';
            $scope.twopointfourGHZObj.endIP = '192.168.1.101';
            $scope.twopointfourGHZObj.leaseTime = 43200;
        }
        $scope.checkIP = function (ipAddress, group, type) {
            var ipRegex = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
            if (group == 'fiveGHZObj' || group == 'twopointfourGHZObj') {
                if (!ipAddress.match(ipRegex)) {
                    $scope[group][type] = "";
                }
            }
        }

        $scope.checkLeases = function (num, group, type) {
            if (num < 120 || num > 86400) {
                if (type == 'leaseTime') {
                    $scope[group][type] = "";
                }
            }
        }

        //post call for network dhcp
        $scope.network_dhcp = function () {
            var obj = {
                "radio": $scope.dhcpData.radio,
                "nodeId": $state.params.nodeId,
                //            "status": 0,
                //            "message": null,
                "dhcpServer": $scope.fiveGHZObj.dhcpServer ? $scope.fiveGHZObj.dhcpServer.id : null,
                "startIPAddress": $scope.fiveGHZObj.startIP ? $scope.fiveGHZObj.startIP : null,
                "endIPAddress": $scope.fiveGHZObj.endIP ? $scope.fiveGHZObj.endIP : null,
                "leaseTime": $scope.fiveGHZObj.leaseTime ? $scope.fiveGHZObj.leaseTime : null,
                "klanIPAddress": $scope.twopointfourGHZObj.ipaddress ? $scope.twopointfourGHZObj.ipaddress : null,
                "klanMask": $scope.twopointfourGHZObj.subnetmask ? $scope.twopointfourGHZObj.subnetmask : null,
                "klandhcpServer": $scope.twopointfourGHZObj.dhcpServer ? $scope.twopointfourGHZObj.dhcpServer.id : null,
                "klanstartIPAddress": $scope.twopointfourGHZObj.startIP ? $scope.twopointfourGHZObj.startIP : null,
                "klanendIPAddress": $scope.twopointfourGHZObj.endIP ? $scope.twopointfourGHZObj.endIP : null,
                "klanleaseTime": $scope.twopointfourGHZObj.leaseTime ? $scope.twopointfourGHZObj.leaseTime : null
            }
            for (key in obj) {
                var val = obj[key]
                var val1 = $scope.prevProperties[key];
                if (obj[key] == val1) {
                    if (isNaN(val)) {
                        obj[key] = null;
                    } else {
                        obj[key] = -1;
                    }
                    //obj[key] = null;
                    console.log('Not Changed ' + obj[key]);
                } else {
                    console.log(key + '*Changed ' + $scope.prevProperties[key]);
                }
            }
            var confirm = $scope.saveconfirm();

            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodenetview/udhcpconfig',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: obj
                }).success(function () {
                    $scope.showAlert('success', 'Saved successfully.');
                    $scope.network_ehhernet_dhcp();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error creating Data: ' + msg);
                });
            });
        }
        //splice option
        $scope.deleteOption = function (ind) {
            $scope.optionArray.splice(ind, 1);
        }

        $scope.changedNetworkArray = [];
        $scope.networkObj = function (group, key, modelvalue, indexvalue) {
            if (key == 'dnsIP') {
                modelvalue = $scope.netipconfigData.dnsIP + ' ' + $scope.netipconfigData.dnsIP1;
            }            
            if (modelvalue!="" && modelvalue!=null && modelvalue!=undefined) {
                $scope.exist = false;
                if ($scope.changedNetworkArray.length > 0) {
                    for (var i = 0; i < $scope.changedNetworkArray.length; i++) {
                        if ($scope.changedNetworkArray[i].key == key) {
                            $scope.changedNetworkArray[i].value = modelvalue;
                            $scope.exist = true;
                        }
                    }
                }
                if (!$scope.exist) {
                    $scope.changedNetworkArray.push({ "group": group, "key": key, "value": modelvalue,"index":indexvalue });
                }
                console.log("changedNetworkArray", $scope.changedNetworkArray);
            }else{
                if(key=='dhcp5_leaseTime'){
                    if ($scope.changedNetworkArray.length > 0) {
                        for (var i = 0; i < $scope.changedNetworkArray.length; i++) {
                            if ($scope.changedNetworkArray[i].key == key) {
                              $scope.changedNetworkArray.splice(i,1);
                            }
                        }
                    }
                }
                if(key=='dhcp2.4_leaseTime'){
                    if ($scope.changedNetworkArray.length > 0) {
                        for (var i = 0; i < $scope.changedNetworkArray.length; i++) {
                            if ($scope.changedNetworkArray[i].key == key) {
                              $scope.changedNetworkArray.splice(i,1);
                            }
                        }
                    }
                }
                console.log("changedNetworkArray", $scope.changedNetworkArray);
            }
        }

        $scope.saveNetwork = function () {            
            $scope.trunkID = "";
            if ($scope.changevlantrunk) {
                if ($scope.optionArray.length > 0) {
                    // for (var i = 0; i < $scope.optionArray.length; i++) {
                    //     $scope.trunkID = $scope.trunkID + $scope.optionArray[i];
                    //     if (i + 1 < $scope.optionArray.length) {
                    //         $scope.trunkID = $scope.trunkID + " ";
                    //     }
                    // }
                    // $scope.changedNetworkArray.push({ "group": 'vlan', "key": 'vlanTrunkId', "value": $scope.trunkID });
                    for (var i = 0; i < $scope.optionArray.length; i++) {
                        $scope.changedNetworkArray.push({ "group": 'vlan', "key": 'vlanTrunkId', "value": $scope.optionArray[i],"action":"A","index": '216'  });
                    }
                }
            }
            // if($scope.fiveGHZObj.leaseTime){
            //     $scope.exist = false;
            //     if ($scope.changedNetworkArray.length > 0) {
            //         for (var i = 0; i < $scope.changedNetworkArray.length; i++) {
            //             if ($scope.changedNetworkArray[i].key == 'dhcp5_leaseTime') {
            //                 $scope.changedNetworkArray[i].value = $scope.fiveGHZObj.leaseTime;
            //                 $scope.exist = true;
            //             }
            //         }
            //     }
            //     if (!$scope.exist) {
            //         $scope.changedNetworkArray.push({ "group": 'dhcp', "key": 'dhcp5_leaseTime', "value": $scope.fiveGHZObj.leaseTime });
            //     }
            // }
            // if($scope.twopointfourGHZObj.leaseTime){
            //     $scope.exist = false;
            //     if ($scope.changedNetworkArray.length > 0) {
            //         for (var i = 0; i < $scope.changedNetworkArray.length; i++) {
            //             if ($scope.changedNetworkArray[i].key == 'dhcp2.4_leaseTime') {
            //                 $scope.changedNetworkArray[i].value = $scope.twopointfourGHZObj.leaseTime;
            //                 $scope.exist = true;
            //             }
            //         }
            //     }
            //     if (!$scope.exist) {
            //         $scope.changedNetworkArray.push({ "group": 'dhcp', "key": 'dhcp2.4_leaseTime', "value": $scope.twopointfourGHZObj.leaseTime });
            //     }
            // }           
            console.log("save network obj", $scope.changedNetworkArray);
            if($scope.changedNetworkArray.length>0){
                var confirm = $scope.saveconfirm();
                $mdDialog.show(confirm).then(function () {    
                $http({
                    method: 'POST',
                    url: 'api/v2/nodenetview/netsave/' + $state.params.nodeId,
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: $scope.changedNetworkArray
                }).success(function () {
                    $scope.showAlert('success', 'Saved successfully.');
                    // $scope.network_ip_config();
                    // $scope.network_vlan_config();
                    // $scope.network_ehhernet_dhcp();
                    // $scope.network_ehhernet_radius();
                    // $scope.network_ethernet_config();
                    $scope.changedNetworkArray = [];
                    $scope.get_save_changes();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error creating Data: ' + msg);
                });
            });
            }         
        }

        $scope.applyFunNetwork = function () {
            $scope.get_save_changes();
            $("#showchangesNetwork").modal('show');
        }

        $scope.commitNetwork = function () {
            for (var i = 0; i < $scope.saveChangesObj.changes.length; i++) {
                var splitobj = $scope.saveChangesObj.changes[i].key.split('_');
                $scope.saveChangesObj.changes[i].group = splitobj[0];
                $scope.saveChangesObj.changes[i].key = splitobj[1];
            }
            console.log("commit", $scope.saveChangesObj.changes);
            $http({
                method: 'POST',
                url: 'api/v2/profiles/save/' + $state.params.nodeId,
                headers: {
                    'Content-Type': 'application/json'
                },
                data: $scope.saveChangesObj.changes
            }).success(function () {
                $scope.showAlert('success', 'Saved successfully.');
                $("#showchangesNetwork").modal('hide');
                $scope.network_ip_config();
                $scope.network_vlan_config();
                $scope.network_ehhernet_dhcp();
                $scope.network_ehhernet_radius();
                $scope.network_ethernet_config();
                $scope.get_save_changes();
            }).error(function (msg) {
                $("#showchangesNetwork").modal('hide');
                $scope.showAlert('error', 'Error creating Data: ' + msg);
            });
        }

        $scope.revertNetwork = function () {
            for (var i = 0; i < $scope.saveChangesObj.changes.length; i++) {
                var splitobj = $scope.saveChangesObj.changes[i].key.split('_');
                $scope.saveChangesObj.changes[i].group = splitobj[0];
                $scope.saveChangesObj.changes[i].key = splitobj[1];
            }
            $http({
                method: 'POST',
                url: 'api/v2/profiles/revert/' + $state.params.nodeId,
                headers: {
                    'Content-Type': 'application/json'
                },
                data: $scope.saveChangesObj.changes
            }).success(function () {
                $scope.showAlert('success', 'Saved successfully.');
                $("#showchangesNetwork").modal('hide');
                $scope.network_ip_config();
                $scope.network_vlan_config();
                $scope.network_ehhernet_dhcp();
                $scope.network_ehhernet_radius();
                $scope.network_ethernet_config();
                $scope.get_save_changes();
            }).error(function (msg) {
                $("#showchangesNetwork").modal('hide');
                $scope.showAlert('error', 'Error creating Data: ' + msg);
            });
        }
    }
]);
