dashboard.controller("NodeViewWirelessController", ['$localStorage', '$rootScope', '$scope', '$mdDialog', '$http', '$state', 'dashboardService', 'Flash',
    function ($localStorage, $rootScope, $scope, $mdDialog, $http, $state, dashboardService, Flash) {
        //    init method it checks selected view and activate get call based on rootscope.selectedView
        $scope.showEirp = false;
        $scope.init = function () {
            $scope.get_save_changes();
            $scope.load_5ghz_wireless_properties();
            $scope.load_5ghz_wireless_mimo();
            $scope.load_5ghz_wireless_ddrs();
            $scope.load_5ghz_wireless_security();
            $scope.load_5ghz_wireless_macacl();
            $scope.load_5ghz_dcs();
            $scope.load_2_4ghz_wireless_properties();
            $scope.load_2_4ghz_wireless_security();
            $scope.load_2_4ghz_wireless_macacl();
            if ($rootScope.selectedView == 'wl-5ghz-properties') {
                $scope.load_5ghz_wireless_properties();
            }
            if ($rootScope.selectedView == 'wl-5ghz-mimo') {
                $scope.load_5ghz_wireless_mimo();
            }
            if ($rootScope.selectedView == 'wl-5ghz-DDRS') {
                $scope.load_5ghz_wireless_ddrs();
            }
            if ($rootScope.selectedView == 'wl-5ghz-security') {
                $scope.load_5ghz_wireless_security();
            }
            if ($rootScope.selectedView == 'wl-5ghz-mac_acl') {
                $scope.load_5ghz_wireless_macacl();
            }
            if ($rootScope.selectedView == 'wl-5ghz-dcs') {
                $scope.load_5ghz_dcs();
            }
            if ($rootScope.selectedView == 'wl-2.4ghz-properties') {
                $scope.load_2_4ghz_wireless_properties();
            }
            if ($rootScope.selectedView == 'wl-2.4ghz-security') {
                $scope.load_2_4ghz_wireless_security();
            }
            if ($rootScope.selectedView == 'wl-2.4ghz-mac_acl') {
                $scope.load_2_4ghz_wireless_macacl();
            }
        }

        $scope.saveChangesObj = {};        
        $scope.get_save_changes = function () {
            var url = 'api/v2/nodes/changes/' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.saveChangesObj = response.data;
                        $rootScope.wirelessapply=response.data.available;
                        $rootScope.wirelesschanges=response.data.changes;
                        console.log("$scope.saveChangesObj", $scope.saveChangesObj);
                    }
                });
        }

        $scope.radioTypeChange = function () {                     
            if ($scope.propertiesData.radioMode.mType == 'ap' && $scope.propertiesData.lnktype.linkType == 3) {
              $scope.showAtpcStat = false;
              $scope.showEirp = false;
            } else {
              $scope.showAtpcStat = true;
            }
            if ($scope.showAtpcStat) {
              $scope.atpcStatusChange();
            }            
            if ($scope.ddrsData.ddrsStatusName.ddrsStatus == 1) {
              $scope.max_min = true;
              $scope.txRate = false;
            } else if ($scope.ddrsData.ddrsStatusName.ddrsStatus == 2) {
              $scope.max_min = false;
              $scope.txRate = true;
            }
            $scope.chanegStream($scope.ddrsData.spacialStreamName);                     
          }

        $scope.atpcStatusChange = function () {
            $scope.ddrsData.transmitPower = 26;
            if ($scope.ddrsData.atpcStatusName.atpcStatus == 1) {
                $scope.showEirp = true;
            } else {
                $scope.showEirp = false;
            }
        }


        $scope.saveconfirm = function (ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to update this changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')


            return confirm;
        };
        //get call for 5ghz_wireless_properties();
        $scope.load_5ghz_wireless_properties = function () {
            $scope.linkTypeData = [{
                "linkType": 1,
                "linkTypeVal": "PTP"
            }, {
                "linkType": 2,
                "linkTypeVal": "Backhaul"
            }, {
                "linkType": 3,
                "linkTypeVal": "PTMP"
            }/*, {
                    "linkType": 4,
                    "linkTypeVal": "PTMP-SMAC2"
                }*/];
            $scope.radiomode = [{
                "mType": "sta",
                "rmode": "Outdoor Subscriber"
            }, {
                "mType": "ap",
                "rmode": "Outdoor Base"
            }];
            $scope.country = [
                {
                    "countryCode": 5011,
                    "countryName": "US 5GHz Non-DFS"
                },
                {
                    "countryCode": 5012,
                    "countryName": "US 5GHz All"
                },
                {
                    "countryCode": 5013,
                    "countryName": "US 4.9GHz"
                }
            ];
            $scope.operationalMode = [{
                "opMode": "11ac"
            }, {
                "opMode": "11nc"
            }];
            $scope.bw = [{
                "bandWIdthID": "HT20",
                "bandWidth": "20MHZ"

            }, {
                "bandWIdthID": "HT40+",
                "bandWidth": "40MHZ"

            }, {
                "bandWIdthID": "HT80",
                "bandWidth": "80MHZ"
            }];
            $scope.traffic = [{
                "trafficShaping": 1,
                "trafficShapingVal": "Enable"
            }, {
                "trafficShaping": 0,
                "trafficShapingVal": "Disable"
            }];
            $scope.dcsarray = [{
                "id": 1,
                "val": "Enable"
            }, {
                "id": 0,
                "val": "Disable"
            }];

            $scope.loadChannels = function () {
                $scope.channel_one = [];
                $scope.val = 5105;
                $scope.channel_one[0] = {
                    "channel": 'auto',
                    "channelVal": 'Auto'
                };

                var start1 = 22;
                var end1 = 68;
                var start2 = 0;
                var end2 = 0;
                var start3 = 0;
                var end3 = 0;
                var start4 = 0;
                var end4 = 0;
                var freq1 = 5110;
                var freq2 = 5480;
              $scope.bw = [{
                    "bandWIdthID": "HT20",
                    "bandWidth": "20MHZ"

                  }, {
                    "bandWIdthID": "HT40+",
                    "bandWidth": "40MHZ"

                  }, {
                    "bandWIdthID": "HT80",
                    "bandWidth": "80MHZ"
                  }];
                if ($scope.propertiesData.countries.countryCode == 5018) {
                    if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT20') {
                        start1 = 22;
                        end1 = 68;
                        start2 = 96;
                        end2 = 183;
                        freq1 = 5110;
                        freq2 = 5480;
                    } else if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT40' || $scope.propertiesData.bndwdt.bandWIdthID == 'HT40+') {
                        start1 = 24;
                        end1 = 66;
                        start2 = 98;
                        end2 = 181;
                        freq1 = 5120;
                        freq2 = 5490;
                    } else if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT80') {
                        start1 = 28;
                        end1 = 62;
                        start2 = 102;
                        end2 = 177;
                        freq1 = 5140;
                        freq2 = 5140;
                    }

                } else if ($scope.propertiesData.countries.countryCode == 5019) {
                    if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT20') {
                        start1 = 22;
                        end1 = 183;
                        start2 = 0;
                        end2 = 0;
                        freq1 = 5110;
                        freq2 = 5915;
                    } else if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT40' || $scope.propertiesData.bndwdt.bandWIdthID == 'HT40+') {
                        start1 = 24;
                        end1 = 181;
                        start2 = 0;
                        end2 = 0;
                        freq1 = 5120;
                        freq2 = 5905;
                    } else if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT80') {
                        start1 = 28;
                        end1 = 177;
                        start2 = 0;
                        end2 = 0;
                        freq1 = 5140;
                        freq2 = 5850;
                    }
                }
                else if ($scope.propertiesData.countries.countryCode == 5011) {
                    if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT20') {
                        start1 = 36;
                        end1 = 48;
                        start2 = 149;
                        end2 = 165;
                        freq1 = 5180;
                        freq2 = 5745;
                    } else if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT40' || $scope.propertiesData.bndwdt.bandWIdthID == 'HT40+') {
                        start1 = 38;
                        end1 = 46;
                        start2 = 151;
                        end2 = 159;
                        freq1 = 5190;
                        freq2 = 5755;
                    } else if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT80') {
                        start1 = 42;
                        end1 = 42;
                        start2 = 155;
                        end2 = 155;
                        freq1 = 5210;
                        freq2 = 5775;
                    }
                }
                else if ($scope.propertiesData.countries.countryCode == 5012) {
                    if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT20') {
                        start1 = 36;
                        end1 = 48;
                        start2 = 52;
                        end2 = 64;
                        start3 = 100;
                        end3 = 165;
                        start4 = 0;
                        end4 = 0;
                        freq1 = 5180;
                        freq2 = 5260;
                        freq3 = 5500;
                    } else if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT40' || $scope.propertiesData.bndwdt.bandWIdthID == 'HT40+') {
                        start1 = 38;
                        end1 = 46;
                        start2 = 54;
                        end2 = 62;
                        start3 = 102;
                        end3 = 159;
                        start4 = 0;
                        end4 = 0;
                        freq1 = 5190;
                        freq2 = 5270;
                        freq3 = 5510;
                    } else if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT80') {
                        start1 = 42;
                        end1 = 42;
                        start2 = 58;
                        end2 = 58;
                        start3 = 106;
                        end3 = 122;
                        start4 = 155;
                        end4 = 155;
                        freq1 = 5210;
                        freq2 = 5290;
                        freq3 = 5530;
                        freq4 = 5775;
                    }
                }
                else if ($scope.propertiesData.countries.countryCode == 5013) {
                   $scope.bw = [{
                        "bandWIdthID": "HT20",
                        "bandWidth": "20MHZ"
                      }];
                    if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT20') {
                        start1 = 190;
                        end1 = 196;
                        start2 = 0;
                        end2 = 0;
                        freq1 = 4950;
                    }
                }

                var freqVal;
                for (var i = start1, freq = freq1; i <= end1; i++, freq = freq + 5) {
                    $scope.freqVal = freq + 'MHz';
                    $scope.channel_one.push({
                        "channel": i,
                        "channelVal": i + ' (' + $scope.freqVal + ')'
                    });
                }
                // if ($scope.propertiesData.countries.countryCode == 5018) {
                if(start2!=0){
                    for (var i = start2, freq = freq2; i <= end2; i++, freq = freq + 5) {
                        $scope.freqVal = freq + 'MHz';
                        $scope.channel_one.push({
                            "channel": i,
                            "channelVal": i + ' (' + $scope.freqVal + ')'
                        });
                    }
                }
                if(start3!=0){
                    for (var i = start3, freq = freq3; i <= end3; i++, freq = freq + 5) {
                        $scope.freqVal = freq + 'MHz';
                        $scope.channel_one.push({
                            "channel": i,
                            "channelVal": i + ' (' + $scope.freqVal + ')'
                        });
                    }
                }
                if(start4!=0){
                    for (var i = start4, freq = freq4; i <= end4; i++, freq = freq + 5) {
                        $scope.freqVal = freq + 'MHz';
                        $scope.channel_one.push({
                            "channel": i,
                            "channelVal": i + ' (' + $scope.freqVal + ')'
                        });
                    }
                }
                //}

                //$scope.propertiesData.chnnl.channel = $scope.channel_one[0];
            }

            $scope.prevPropertiesData = {};

            var url = 'api/v2/nodewirelessview/propertiesf?nodeId=' + $state.params.nodeId;
            $http.get(url).then(function (response) {
                if (response.data) {
                    $scope.propertiesData = response.data;
                    angular.copy(response.data, $scope.prevPropertiesData);
                    $scope.propertiesData.mode = {
                        opMode: $scope.propertiesData.opMode
                    }
                    $scope.propertiesData.radioMode = {
                        mType: $scope.propertiesData.radioMode
                    }
                    $scope.propertiesData.countries = {
                        countryCode: $scope.propertiesData.country
                    }
                    $scope.propertiesData.bndwdt = {
                        bandWIdthID: $scope.propertiesData.bandwidth
                    }
                    $scope.loadChannels();
                    if ($scope.propertiesData.channel == 'auto'||$scope.propertiesData.channel == 'Auto') {
                          $scope.propertiesData.chnnl = {
                              channel: 'auto'
                          }
                    } else {
                        $scope.propertiesData.chnnl = {
                            channel: parseInt($scope.propertiesData.channel)
                        }
                    }
                    $scope.propertiesData.trfshp = {
                        trafficShaping: $scope.propertiesData.trafficShaping
                    }
                    $scope.propertiesData.lnktype = {
                        linkType: $scope.propertiesData.linkType
                    }
                    if ($scope.propertiesData.hideSSID == 0) {
                        $scope.propertiesData.hideSSIDVal = false;
                    } else {
                        $scope.propertiesData.hideSSIDVal = true;
                    }
                    if ($scope.propertiesData.radioMode.mType == 'ap' && $scope.propertiesData.lnktype.linkType == 3) {
                        $scope.showAtpcStat = false;
                      } else {
                        $scope.showAtpcStat = true;
                      }
                       $scope.load_5ghz_wireless_ddrs
                    // console.log("$scope.propertiesData", $scope.propertiesData);
                }
            });
        }
        //post call for 5ghz properties
        $scope.wl_5ghz_properties = function () {
            if ($scope.propertiesData.hideSSIDVal) {
                $scope.propertiesData.hideSSID = 1;
            } else {
                $scope.propertiesData.hideSSID = 0;
            }
            var channel = $scope.propertiesData.chnnl.channel;
            if (channel == -1) {
                channel = 'auto';
            }
            var propertiesObj = {
                "radio": $scope.propertiesData.radio,
                "nodeId": $state.params.nodeId,
                "status": $scope.propertiesData.status,
                "message": $scope.propertiesData.message,
                "radioMode": $scope.propertiesData.radioMode.mType,
                "ssid": $scope.propertiesData.ssid,
                "country": $scope.propertiesData.countries.countryCode,
                "opMode": $scope.propertiesData.mode.opMode,
                "bandwidth": $scope.propertiesData.bndwdt.bandWIdthID,
                "channel": channel + '',
                /*"distance": $scope.propertiesData.distance,*/
                "trafficShaping": $scope.propertiesData.trfshp.trafficShaping,
                "upLinkLimit": $scope.propertiesData.upLinkLimit,
                "downLinkLimit": $scope.propertiesData.downLinkLimit,
                "hideSSID": $scope.propertiesData.hideSSID,
                "wirelessInactivityTimer": $scope.propertiesData.wirelessInactivityTimer,
                "linkInactivityTimer": $scope.propertiesData.linkInactivityTimer,
                "suService": $scope.propertiesData.suService,
                "macACLStatus": $scope.propertiesData.macACLStatus,
                "macACLAddress": $scope.propertiesData.macACLAddress,
                "linkType": $scope.propertiesData.lnktype.linkType,
                "radio2Enable": $scope.propertiesData.radio2Enable,
                "maxSUCount": $scope.propertiesData.maxSUCount,
                "retries": $scope.propertiesData.retries
            }

            for (key in propertiesObj) {
                var val = propertiesObj[key]
                if (propertiesObj[key] == $scope.prevPropertiesData[key]) {
                    if (isNaN(val)) {
                        propertiesObj[key] = null;
                    } else {
                        if (key == "channel") {
                            propertiesObj[key] = null;
                        } else {
                            propertiesObj[key] = -1;
                        }
                    }
                    console.log('Not Changed ' + propertiesObj[key]);
                } else {
                    console.log(key + '*Changed ' + $scope.prevPropertiesData[key]);
                }
            }

            var confirm = $scope.saveconfirm();

            $mdDialog.show(confirm).then(function () {

                $http({
                    method: 'POST',
                    url: 'api/v2/nodewirelessview/savefiveg',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: propertiesObj
                }).success(function (res) {
                    if ($scope.propertiesData.radioMode.mType == 'ap') {
                        $rootScope.radioMode = 1;
                    } else if ($scope.propertiesData.radioMode.mType == 'sta') {
                        $rootScope.radioMode = 2;
                    }
                    $rootScope.linkType = $scope.propertiesData.lnktype.linkType;
                    $scope.showAlert('success', 'Saved successfully.');
                    $scope.load_5ghz_wireless_properties();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error creating Data: ' + msg);
                });

            });

        }

        $scope.onBandwidthChange = function () {
            if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT20') {
                $scope.propertiesData.upLinkLimit = 192000;
                $scope.propertiesData.downLinkLimit = 192000;
            } else if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT40+') {
                $scope.propertiesData.upLinkLimit = 400000;
                $scope.propertiesData.downLinkLimit = 400000;
            } else if ($scope.propertiesData.bndwdt.bandWIdthID == 'HT80') {
                $scope.propertiesData.upLinkLimit = 867000;
                $scope.propertiesData.downLinkLimit = 867000;
            }
            $scope.loadChannels();
        }


        //get call for mimo method
        $scope.load_5ghz_wireless_mimo = function () {
            $scope.prevPropertiesData = {};
            var url = 'api/v2/nodewirelessview/mimof?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {

                    if (response.data) {
                        $scope.mimoData = response.data;
                        angular.copy(response.data, $scope.prevPropertiesData)
                        /*$scope.mimoData.txa1 = true;
                        $scope.mimoData.txa2 = false;*/
                        if ($scope.mimoData.txChaimMask == 1) {
                            $scope.mimoData.txa1 = true;
                            $scope.mimoData.txa2 = false;
                        } else if ($scope.mimoData.txChaimMask == 2) {
                            $scope.mimoData.txa1 = false;
                            $scope.mimoData.txa2 = true;
                        } else if ($scope.mimoData.txChaimMask == 3) {
                            $scope.mimoData.txa1 = true;
                            $scope.mimoData.txa2 = true;
                        } else{
                              $scope.mimoData.txa1 = false;
                              $scope.mimoData.txa2 = false;
                        }

                        if ($scope.mimoData.rxChainMask == 1) {
                            $scope.mimoData.rxa1 = true;
                            $scope.mimoData.rxa2 = false;
                        } else if ($scope.mimoData.rxChainMask == 2) {
                            $scope.mimoData.rxa1 = false;
                            $scope.mimoData.rxa2 = true;
                        } else if ($scope.mimoData.rxChainMask == 3){
                            $scope.mimoData.rxa1 = true;
                            $scope.mimoData.rxa2 = true;
                        }else{
                             $scope.mimoData.rxa1 = false;
                             $scope.mimoData.rxa2 = false;
                        }
                        // console.log("$scope.mimoData", $scope.mimoData);
                        //$scope.viewNode = viewNode;
                    }
                });
        }

        //post call for mimo method
        $scope.wl_5ghz_mimo = function () {

            if ($scope.mimoData.txa1 && $scope.mimoData.txa2) {
                $scope.mimoData.txChainMask = 3;
            } else if ($scope.mimoData.txa1 == true && $scope.mimoData.txa2 == false) {
                $scope.mimoData.txChainMask = 1;
            } else if ($scope.mimoData.txa1 == false && $scope.mimoData.txa2 == true) {
                $scope.mimoData.txChainMask = 2;
            } else if ($scope.mimoData.txa1 == false && $scope.mimoData.txa2 == false) {
                $scope.mimoData.txChainMask = 0;
            }

            if ($scope.mimoData.rxa1 && $scope.mimoData.rxa2) {
                $scope.mimoData.rxChainMask = 3;
            } else if ($scope.mimoData.rxa1 == true && $scope.mimoData.rxa2 == false) {
                $scope.mimoData.rxChainMask = 1;
            } else if ($scope.mimoData.rxa1 == false && $scope.mimoData.rxa2 == true) {
                $scope.mimoData.rxChainMask = 2;
            } else if ($scope.mimoData.rxa1 == false && $scope.mimoData.rxa2 == false) {
                $scope.mimoData.rxChainMask = 0;
            }


            if ($scope.mimoData.txChainMask === 0 || $scope.mimoData.rxChainMask === 0) {
                $scope.showAlert('error', 'Please Select atlease one chainmask');
            } else {
                var mimoobj = {
                    "radio": $scope.mimoData.radio,
                    "nodeId": $state.params.nodeId,
                    "shortGI": $scope.mimoData.shortGI,
                    "amsdu": $scope.mimoData.amsdu,
                    "ampdu": $scope.mimoData.ampdu,
                    "txChainMask": $scope.mimoData.txChainMask,
                    "rxChainMask": $scope.mimoData.rxChainMask
                }
                for (key in mimoobj) {
                    var val = mimoobj[key]
                    if (mimoobj[key] == $scope.prevPropertiesData[key]) {
                        if (isNaN(val)) {
                            mimoobj[key] = null;
                        } else {
                            if (key == "channel") {
                                mimoobj[key] = null;
                            } else {
                                mimoobj[key] = -1;
                            }
                        }
                        console.log('Not Changed ' + mimoobj[key]);
                    } else {
                        console.log(key + '*Changed ' + $scope.prevPropertiesData[key]);
                    }
                }
                var confirm = $scope.saveconfirm();

                $mdDialog.show(confirm).then(function () {
                    $http({
                        method: 'POST',
                        url: 'api/v2/nodewirelessview/savewire5mimo',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        data: mimoobj
                    }).success(function () {
                        $scope.showAlert('success', 'Saved successfully.');
                        $scope.load_5ghz_wireless_mimo();
                    }).error(function (msg) {
                        $scope.showAlert('error', 'Error creating Data: ' + msg);
                    });

                });
            }

        }


        //get call for ddrs
        $scope.load_5ghz_wireless_ddrs = function () {

            $scope.ddrsStatusArray = [{
                "ddrsStatus": 1,
                "ddrsStatusVal": "Enable"
            }, {
                "ddrsStatus": 2,
                "ddrsStatusVal": "Disable"
            }];
            $scope.spacialStreamArray = [{
                "spacialStream": 1,
                "spacialStreamVal": "Single"
            }, {
                "spacialStream": 2,
                "spacialStreamVal": "Dual"
            },
            {
                "spacialStream": 3,
                "spacialStreamVal": "Auto"
            }
            ];
            $scope.atpcStatusArray = [{
                "atpcStatus": 1,
                "atpcStatusVal": "Enable"
            }, {
                "atpcStatus": 2,
                "atpcStatusVal": "Disable"
            }];
            $scope.modIndexArraymin = [];
            $scope.modIndexArraymax = [];
            $scope.modIndexArraytxRate = [];
            $scope.txRate = false;
            $scope.max_min = false;
            $scope.prevPropertiesData = {};
            var url = 'api/v2/nodewirelessview/ddrsatpcf?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {

                    //               $scope.viewNode = viewNode;
                    if (response.data) {
                        $scope.ddrsData = response.data;
                        angular.copy(response.data, $scope.prevPropertiesData);
                        $scope.ddrsData.ddrsStatusName = {
                            ddrsStatus: $scope.ddrsData.ddrsStatus
                        }
                        if ($scope.ddrsData.ddrsStatus == 2) {
                            $scope.spacialStreamArray.pop();
                        }
                        $scope.ddrsData.spacialStreamName = {
                            spacialStream: $scope.ddrsData.spacialStream
                        }
                        if ($scope.ddrsData.spacialStream == 1) {
                            if ($scope.ddrsData.ddrsStatus == 1) {
                                $scope.max_min = true;
                            }

                            for (var i = 0; i < 10; i++) {
                                $scope.mcsval = 'MCS' + i;
                                $scope.modIndexArraymin.push({
                                    "minModIndex": i,
                                    "modeIndexVal": $scope.mcsval
                                });
                                $scope.modIndexArraymax.push({
                                    "maxModIndex": i,
                                    "modeIndexVal": $scope.mcsval
                                });
                                $scope.modIndexArraytxRate.push({
                                    "txRateIndex": i,
                                    "modeIndexVal": $scope.mcsval
                                });
                            }
                        } else if ($scope.ddrsData.spacialStream == 2) {
                            if ($scope.ddrsData.ddrsStatus == 1) {
                                $scope.max_min = true;
                            }
                            for (var i = 10; i < 20; i++) {
                                $scope.mcsval = 'MCS' + i;
                                $scope.modIndexArraymin.push({
                                    "minModIndex": i,
                                    "modeIndexVal": $scope.mcsval
                                });
                                $scope.modIndexArraymax.push({
                                    "maxModIndex": i,
                                    "modeIndexVal": $scope.mcsval
                                });
                                $scope.modIndexArraytxRate.push({
                                    "txRateIndex": i,
                                    "modeIndexVal": $scope.mcsval
                                });
                            }
                            //$scope.modIndexArraytxRate = $scope.modIndexArraymax;
                        } /*else {
                            $scope.txRate = true;
                        }*/
                        if ($scope.ddrsData.ddrsStatus == 2) {
                            $scope.txRate = true;
                            $scope.max_min = false;
                        }
                        $scope.ddrsData.atpcStatusName = {
                            atpcStatus: $scope.ddrsData.atpcStatus
                        }
                        $scope.ddrsData.modIndexNamemin = {
                            minModIndex: response.data.minModIndex
                        }
//                        $scope.ddrsData.modIndexNamemax = {
//                            maxModIndex: response.data.maxModIndex
//                        }
                        $scope.ddrsData.modIndexNamemax = $scope.modIndexArraymax[$scope.modIndexArraymax.length-1];
                        $scope.ddrsData.txRateIndexName = {
                            txRateIndex: response.data.txRate
                        }
                        // console.log("$scope.ddrsData", $scope.ddrsData);
                    }
                });
        }

        $scope.ddrsStatusSelection = function (ddrsStatus) {
            var json = {
                "spacialStream": 3,
                "spacialStreamVal": "Auto"
            };
            if (ddrsStatus == 1) {
                if ($scope.spacialStreamArray.length == 2) {
                    $scope.spacialStreamArray.push(json);
                }
                $scope.max_min = true;
                $scope.txRate = false;
            } else if (ddrsStatus == 2) {
                $scope.max_min = false;
                $scope.txRate = true;
                $scope.spacialStreamArray.pop();
            }
            $scope.ddrsData.spacialStreamName = $scope.spacialStreamArray[0];
            $scope.chanegStream($scope.ddrsData.spacialStreamName);
        }

        //stream change
        $scope.chanegStream = function (streamValue) {
            $scope.modIndexArraymin = [];
            $scope.modIndexArraymax = [];
            $scope.modIndexArraytxRate = [];
            $scope.max_min = true;
            if (streamValue.spacialStream == 1) {
                for (var i = 0; i < 10; i++) {
                    $scope.mcsval = 'MCS' + i;
                    $scope.modIndexArraymin.push({
                        "minModIndex": i,
                        "modeIndexVal": $scope.mcsval
                    });
                    $scope.modIndexArraymax.push({
                        "maxModIndex": i,
                        "modeIndexVal": $scope.mcsval
                    });
                    $scope.modIndexArraytxRate.push({
                        "txRateIndex": i,
                        "modeIndexVal": $scope.mcsval
                    });
                }
                // Commented by Srinivas to handle the case in a single loop
                /*for (var i = 0; i < 10; i++) {
                    $scope.mcsval = 'MCS' + i;
                    $scope.modIndexArraymax.push({
                        "maxModIndex": i,
                        "modeIndexVal": $scope.mcsval
                    });
                }*/
                $scope.ddrsData.modIndexNamemax = $scope.modIndexArraymax[9];
                $scope.ddrsData.modIndexNamemin = $scope.modIndexArraymin[0];
                $scope.ddrsData.txRateIndexName = $scope.modIndexArraytxRate[3]
            } else if (streamValue.spacialStream == 2) {
                for (var i = 10; i < 20; i++) {
                    $scope.mcsval = 'MCS' + i;
                    $scope.modIndexArraymin.push({
                        "minModIndex": i,
                        "modeIndexVal": $scope.mcsval
                    });
                    $scope.modIndexArraymax.push({
                        "maxModIndex": i,
                        "modeIndexVal": $scope.mcsval
                    });

                    $scope.modIndexArraytxRate.push({
                        "txRateIndex": i,
                        "modeIndexVal": $scope.mcsval
                    });
                }

                $scope.ddrsData.modIndexNamemax = $scope.modIndexArraymax[9];
                $scope.ddrsData.modIndexNamemin = $scope.modIndexArraymin[0];
                $scope.ddrsData.txRateIndexName = $scope.modIndexArraytxRate[3]
            } else {
                $scope.max_min = false;
            }
            if ($scope.ddrsData.ddrsStatusName.ddrsStatus == 2) {
                $scope.max_min = false;
                $scope.txRate = true;
            }
        }
        //post call for ddrs
        $scope.wl_5ghz_ddrs = function () {
            var ddrsObj = {
                "radio": $scope.ddrsData.radio,
                "nodeId": $state.params.nodeId,
                "ddrsStatus": $scope.ddrsData.ddrsStatusName.ddrsStatus,
                "spacialStream": $scope.ddrsData.spacialStreamName.spacialStream,
                "minModIndex": $scope.ddrsData.modIndexNamemin.minModIndex,
                "maxModIndex": $scope.ddrsData.modIndexNamemax.maxModIndex,
                "txRate": $scope.ddrsData.txRateIndexName.txRateIndex,
                "ddrsRateIncTimer": $scope.ddrsData.ddrsRateIncTimer,
                "ddrsRateDecTimer": $scope.ddrsData.ddrsRateDecTimer,
                "ddrsRateIncThresh": $scope.ddrsData.ddrsRateIncThresh,
                "ddrsRateIncRTXThresh": $scope.ddrsData.ddrsRateIncRTXThresh,
                "ddrsRateDecRTXThreshl": $scope.ddrsData.ddrsRateDecRTXThreshl,
                "atpcStatus": $scope.ddrsData.atpcStatusName.atpcStatus,
                "transmitPower": $scope.ddrsData.transmitPower
            }
            for (key in ddrsObj) {
                var val = ddrsObj[key]
                if (ddrsObj[key] == $scope.prevPropertiesData[key]) {
                    if (isNaN(val)) {
                        ddrsObj[key] = null;
                    } else {
                        if (key == "channel") {
                            ddrsObj[key] = null;
                        } else {
                            ddrsObj[key] = -1;
                        }
                    }
                    console.log('Not Changed ' + ddrsObj[key]);
                } else {
                    console.log(key + '*Changed ' + $scope.prevPropertiesData[key]);
                }
            }
            var confirm = $scope.saveconfirm();

            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodewirelessview/savewire5ddrs',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: ddrsObj
                }).success(function () {
                    $scope.showAlert('success', 'Saved successfully.');
                    $scope.load_5ghz_wireless_ddrs();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error creating Data: ' + msg);
                });

            });
        }

        //get call for security
        $scope.load_5ghz_wireless_security = function () {
            $scope.prevPropertiesData = {};
            $scope.encryptionarray5 = [{
                "encryption": "none",
                "encryptionVal": "None"
            }, {
                "encryption": "psk2+ccmp",
                "encryptionVal": "AES-256"//"WPA2-PSK"
            }];

            var url = 'api/v2/nodewirelessview/securityf?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {

                    if (response.data) {

                        $scope.securityData = response.data;
                        angular.copy(response.data, $scope.prevPropertiesData);
                        if ($scope.securityData.encryption == 'psk2+ccmp') {
                            $scope.encKey = true;
                        }
                        $scope.securityData.encpt = {
                            encryption: $scope.securityData.encryption
                        }
                        // console.log(" $scope.securityData", $scope.securityData);
                        //$scope.viewNode = viewNode;
                    }
                });
        }
        //on change for security
        $scope.enctypeChange = function (encTypeVal) {
            if (encTypeVal.encryptionVal == 'AES-256') {
                $scope.encKey = true;
            } else {
                $scope.encKey = false;
            }
        }
        $scope.enctypeChange2 = function (encTypeVal) {
            if (encTypeVal.encryptionVal == 'AES-128') {
                $scope.encKey2 = true;
            } else {
                $scope.encKey2 = false;
            }
        }

        //security post method
        $scope.wl_5ghz_security = function () {
            var skey = $scope.securityData.encryptionKey;
            if (skey == 'none') {
                skey = null;
            }
            var securityObj = {
                "radio": $scope.securityData.radio,
                "nodeId": $state.params.nodeId,
                "encryption": $scope.securityData.encpt.encryption,
                "encryptionKey": skey
            }

            for (key in securityObj) {
                var val = securityObj[key]
                if (securityObj[key] == $scope.prevPropertiesData[key]) {
                    if (isNaN(val)) {
                        securityObj[key] = null;
                    } else {
                        if (key == "channel") {
                            securityObj[key] = null;
                        } else {
                            securityObj[key] = -1;
                        }
                    }
                    console.log('Not Changed ' + securityObj[key]);
                } else {
                    console.log(key + '*Changed ' + $scope.prevPropertiesData[key]);
                }
            }

            var confirm = $scope.saveconfirm();

            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodewirelessview/savefivesecurity',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: securityObj
                }).success(function () {
                    $scope.showAlert('success', 'Saved successfully.');
                    $scope.load_5ghz_wireless_security();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error creating Data: ' + msg);
                });
            });
        }
        //5Ghz macacl
        $scope.load_5ghz_wireless_macacl = function () {
            $scope.prevPropertiesData = {};
            $scope.macACLStatusArray = [{
                "macACLStatus": "disable",
                "macACLStatusVal": "Disable"
            }, {
                "macACLStatus": "allow",
                "macACLStatusVal": "Allow"
            }, {
                "macACLStatus": "deny",
                "macACLStatusVal": "Deny"
            }];
            var url = 'api/v2/nodewirelessview/propertiesf?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.macACLData = response.data;
                        angular.copy(response.data, $scope.prevPropertiesData);
                        $scope.macACLData.macACLStatusName = {
                            macACLStatus: $scope.macACLData.macACLStatus
                        }
                        if ($scope.macACLData.macACLAddress == "-NA-" || $scope.macACLData.macACLAddress == null) {
                            $scope.macACLData.macACLAddress = "";
                            $scope.macAddr5 = [];
                        } else {
                            if ($scope.macACLData.macACLAddress) {
                                $scope.macAddr5 = $scope.macACLData.macACLAddress.split(" ");
                            }
                            $scope.macACLData.macACLAddress = "";
                        }
                        // console.log("$scope.macACLData", $scope.macACLData);
                    }
                });
        }


        //5 post call for mac acl
        $scope.wl_5_macacl = function () {
            $scope.macString = "";
            var macaclObj = {
                "nodeId": $state.params.nodeId,
                "macACLStatus": $scope.macACLData.macACLStatusName.macACLStatus,
                "macACLAddress": $scope.macAddr5.join(" ")
            }

            for (key in macaclObj) {
                var val = macaclObj[key]
                if (macaclObj[key] == $scope.prevPropertiesData[key]) {
                    if (isNaN(val)) {
                        macaclObj[key] = null;
                    } else {
                        if (key == "channel") {
                            macaclObj[key] = null;
                        } else {
                            macaclObj[key] = -1;
                        }
                    }
                    console.log('Not Changed ' + macaclObj[key]);
                } else {
                    console.log(key + '*Changed ' + $scope.prevPropertiesData[key]);
                }
            }

            var confirm = $scope.saveconfirm();

            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2//nodewirelessview/savemaclfg',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: macaclObj
                }).success(function () {
                    $scope.showAlert('success', 'Saved successfully.');
                    $scope.load_5ghz_wireless_macacl();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error creating Data: ' + msg);
                });
            });
        }

        // $scope.addmacAddr = function(mac) {
        //     if ($scope.macAddr.length <= 32) {
        //         $scope.macAddr.push(mac)
        //         $scope.macACLData.macACLAddress = '';
        //     } else {
        //         $scope.showAlert('failed', 'Entries must be lessthan 32.');
        //     }

        // }
        $scope.checkupdownlimit = function (num, group, type) {
            if (type == 'upLinkLimit' || type == 'downLinkLimit') {
                if (num < 64 || num > 867000) {
                    $scope.propertiesData[type] = "";
                }
            }
        }

        $scope.keycheck=function(key,type){
            if (key.length < 8 || key.length > 63) {
                if (type == 'encryptionKey') {
                    $scope.securityData[type] = "";
                }
            }  
        }

        $scope.keycheck24=function(key,type){
            if (key.length < 8 || key.length > 63) {
                if (type == 'encryptionKey') {
                    $scope.securityData2[type] = "";
                }
            }  
        }

        $scope.macAddr5 = [];
        $scope.addmacAddr5 = function (mac) {
            if (mac == undefined || mac.length == 0) {
                $scope.showAlert('failed', 'Please enter a valid MAC address.');
                return;
            }
            if ($scope.macAddr5.length < 32) {
                var itemFound = $scope.macAddr5.find(x => x === mac);
                if (!itemFound) {
                    $scope.macAddr5.push(mac);
                       $scope.changedWirelessArray.push({ "group": 'securitymac', "key": 'mac5_macACLAddress', "value": mac,"action":"A","index": '127' });
                }
                $scope.macACLData.macACLAddress = '';
            } else {
                $scope.showAlert('failed', 'Entries must be lessthan 32.');
            }
        }
        $scope.macAddr2 = [];
        $scope.addmacAddr2 = function (mac) {
            if (mac == undefined || mac.length == 0) {
                $scope.showAlert('failed', 'Please enter a valid MAC address.');
                return;
            }
            if ($scope.macAddr2.length < 32) {
                var itemFound1 = $scope.macAddr2.find(x => x === mac);
                if (!itemFound1) {
                    $scope.macAddr2.push(mac);
                    $scope.changedWirelessArray.push({ "group": 'security2.4', "key": 'mac2.4_macACLAddress', "value": mac,"action":"A","index": '142'  });
                }
                $scope.macACLData2.macACLAddress = '';
            } else {
                $scope.showAlert('failed', 'Entries must be lessthan 32.');
            }
        }

        //2.4 temp remove call for mac acl
        $scope.removeMacAddr5 = function (mac1,val) {
            $scope.changedWirelessArray.push({ "group": 'securitymac', "key": 'mac5_macACLAddress', "value": mac1,"action":"D","index": '127'  });
            $scope.macAddr5.splice(val, 1);
        }
        $scope.removeMacAddr2 = function (mac,val) {
            $scope.changedWirelessArray.push({ "group": 'security2.4', "key": 'mac2.4_macACLAddress', "value": mac,"action":"D" ,"index": '142' });
            $scope.macAddr2.splice(val, 1);
        }
        //5Ghz macacl
        $scope.dcsdata={};
        $scope.load_5ghz_dcs = function () {
        var url = 'api/v2/nodewirelessview/dcsf?nodeId=' + $state.params.nodeId;
                    $http.get(url)
                        .then(function (response) {
                            if (response.data) {
                                $scope.dcsdata=response.data;
                                $scope.rtxthreshhold=$scope.dcsdata.dcsThreshold;
                                if($scope.dcsdata.dcsStatus==1){
                                    $scope.dcsdata.dcsstatus=$scope.dcsarray[0];
                                }else{
                                    $scope.dcsdata.dcsstatus=$scope.dcsarray[1];
                                }
                            }
                        });
//            var url = 'api/v2/nodewirelessview/propertiesf?nodeId=' + $state.params.nodeId;
//            $http.get(url)
//                .then(function (response) {
//                    if (response.data) {
//
//                    }
//                });
        }

        //2.4 properties
        //2.4 ghz properites get call
        $scope.propertiesData2 = {};
        $scope.load_2_4ghz_wireless_properties = function () {
            $scope.prevPropertiesData = {};
            $scope.radiostatusarray = [{
                'radio': 0,
                "statusVal": "Enable"
            }, {
                'radio': 1,
                "statusVal": "Disable"
            }];

            $scope.disbleLegacyArray = [{
                'disableLegacy': "0x000F",
                "statusVal": "Enable"
            }, {
                'disableLegacy': "0",
                "statusVal": "Disable"
            }];

            $scope.channelarray = [];
            $scope.val = 2407;
            $scope.channelarray[0] = {
                "channel": -1,
                "channelVal": 'Auto'
            }
            for (var i = 1; i < 14; i++) {
                $scope.val = $scope.val + 5;
                $scope.mhzval = $scope.val + 'MHZ';
                $scope.channelarray.push({
                    "channel": i,
                    "channelVal": i + '(' + $scope.mhzval + ')'
                });
            }

            /*$scope.channelarray.unshift({
                "channel": "auto",
                "channelVal": 'auto'
            });*/
            /*$scope.disablelegacyarray = [{
                'legacy': "0x000F",
                "legacyVal": "Enable"
            }, {
                'legacy': "0",
                "legacyVal": "Disable"
            }];*/
            var url = 'api/v2/nodewirelessview/propertiest?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {

                    if (response.data) {
                        $scope.propertiesData2 = response.data;
                        angular.copy(response.data, $scope.prevPropertiesData);
                        if ($scope.propertiesData2.radioMode == "ap") {
                            $scope.propertiesData2.radioModeName = "Access Point"
                        }
                        if ($scope.propertiesData2.country == "643") {
                            if ($rootScope.buildCode && $rootScope.buildCode == "US") {
                                $scope.propertiesData2.countryName = "US"
                            } else {
                                $scope.propertiesData2.countryName = "India"
                            }

                        }
                        if ($scope.propertiesData2.opMode == "11ng") {
                            $scope.propertiesData2.opModeName = "11NG"
                        }
                        if ($scope.propertiesData2.bandwidth == "HT20") {
                            $scope.propertiesData2.bandwidthName = "20MHz"
                        }
                        $scope.propertiesData2.radiostat = {
                            radio: $scope.propertiesData2.radio2Enable
                        }
                        $scope.propertiesData2.disableLegacy = {
                            disableLegacy: $scope.propertiesData2.disableLegacy
                        }
                        if ($scope.propertiesData2.channel == 'auto'|| $scope.propertiesData2.channel == 'Auto') {
                            $scope.propertiesData2.channelData = {
                                channel: -1
                            }
                        } else {
                            $scope.propertiesData2.channelData = {
                                channel: parseInt($scope.propertiesData2.channel)
                            }
                        }

                        if ($scope.propertiesData2.hideSSID == 0) {
                            $scope.propertiesData2.hideSSIDVal = false;
                        } else {
                            $scope.propertiesData2.hideSSIDVal = true;
                        }
                        // console.log("$scope.propertiesData2", $scope.propertiesData2);
                        //$scope.viewNode = viewNode;
                    }
                });
        }
        //post call for 2.4 ghz properties
        $scope.wl_2_4ghz_properties = function () {
            if ($scope.propertiesData2.hideSSIDVal) {
                $scope.propertiesData2.hideSSID = 1;
            } else {
                $scope.propertiesData2.hideSSID = 0;
            }
            var channel = $scope.propertiesData2.channelData.channel;
            if (channel == -1) {
                channel = 'auto';
            }
            var propertiesObj = {
                "radio": $scope.propertiesData2.radio,
                "nodeId": $state.params.nodeId,
                "status": $scope.propertiesData2.radiostat.radio,
                "message": $scope.propertiesData2.message,
                "radioMode": $scope.propertiesData2.radioMode,
                "ssid": $scope.propertiesData2.ssid,
                "country": $scope.propertiesData2.country,
                "opMode": $scope.propertiesData2.opMode,
                "bandwidth": $scope.propertiesData2.bandwidth,
                "channel": channel,
                /*"distance": $scope.propertiesData2.distance,*/
                "trafficShaping": null,
                "upLinkLimit": null,
                "downLinkLimit": null,
                "hideSSID": $scope.propertiesData2.hideSSID,
                "wirelessInactivityTimer": null,
                "linkInactivityTimer": null,
                "suService": null,
                "macACLStatus": null,
                "macACLAddress": null,
                "linkType": null,
                "disableLegacy": $scope.propertiesData2.disableLegacy.disableLegacy,
                "radio2Enable": $scope.propertiesData2.radiostat.radio
            }
            for (key in propertiesObj) {
                var val = propertiesObj[key]
                if (propertiesObj[key] == $scope.prevPropertiesData[key]) {
                    if (isNaN(val)) {
                        propertiesObj[key] = null;
                    } else {
                        if (key == "disableLegacy") {
                            propertiesObj[key] = null;
                        } else {
                            propertiesObj[key] = -1;
                        }
                    }
                    console.log('Not Changed ' + propertiesObj[key]);
                } else {
                    console.log(key + '*Changed ' + $scope.prevPropertiesData[key]);
                }
            }
            var confirm = $scope.saveconfirm();

            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodewirelessview/savetwog',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: propertiesObj
                }).success(function () {
                    $scope.showAlert('success', 'Saved successfully.');
                    $scope.load_2_4ghz_wireless_properties();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error creating Data: ' + msg);
                });
            });

        }

        //2.4 security
        //get call for 2.4 wireless security
        $scope.securityData2 = {};
        $scope.load_2_4ghz_wireless_security = function () {
            $scope.encKey2 = false;
            $scope.encryptionarray = [{
                "encryption": "none",
                "encryptionVal": "None"
            }, {
                "encryption": "psk2+ccmp",
                "encryptionVal": "AES-128"//"WPA2-PSK"
            }];

            var url = 'api/v2/nodewirelessview/security?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {

                    if (response.data) {
                        $scope.securityData2 = response.data;
                        $scope.securityData2.encpt = {
                            encryption: $scope.securityData2.encryption
                        }
                        //$scope.viewNode = viewNode;
                        if ($scope.securityData2.encryption == 'psk2+ccmp') {
                            $scope.encKey2 = true;
                        }
                        // console.log("$scope.securityData2", $scope.securityData2);
                    }
                });
        }
        //post call for 2.4 wireless security
        $scope.wl_2_4_security = function () {
            var skey = $scope.securityData2.encryptionKey;
            if (skey == 'none') {
                skey = null;
            }
            var secirityObj = {
                "radio": $scope.securityData2.radio,
                "nodeId": $state.params.nodeId,
                "status": $scope.securityData2.status,
                "message": $scope.securityData2.message,
                "encryption": $scope.securityData2.encpt.encryption,
                "encryptionKey": skey
            }
            var confirm = $scope.saveconfirm();

            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodewirelessview/savetwosecurity',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: secirityObj
                }).success(function () {
                    $scope.showAlert('success', 'Saved successfully.');
                    $scope.load_2_4ghz_wireless_security();
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error creating Data: ' + msg);
                });
            });
        }


        //2.4 mac acl
        //2.4 get call for mac acl
        $scope.macACLData2 = {};
        $scope.macACLData = {};
        $scope.load_2_4ghz_wireless_macacl = function () {
            $scope.macACLStatusArray = [{
                "macACLStatus": "disable",
                "macACLStatusVal": "Disable"
            }, {
                "macACLStatus": "allow",
                "macACLStatusVal": "Allow"
            }, {
                "macACLStatus": "deny",
                "macACLStatusVal": "Deny"
            }];
            var url = 'api/v2/nodewirelessview/propertiest?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {

                    if (response.data) {
                        $scope.macACLData2 = response.data;
                        $scope.macACLData2.macACLStatusName = {
                            macACLStatus: $scope.macACLData2.macACLStatus
                        }
                        if ($scope.macACLData2.macACLAddress == "-NA-" || $scope.macACLData2.macACLAddress == null) {
                            $scope.macACLData2.macACLAddress = "";
                            $scope.macAddr2 = [];
                        } else {
                            $scope.macAddr2 = $scope.macACLData2.macACLAddress.split(" ");
                            $scope.macACLData2.macACLAddress = "";
                        }
                        // console.log("$scope.macACLData2", $scope.macACLData2);
                        //$scope.viewNode = viewNode;
                    }
                });
        }
        //2.4 post call for mac acl
        $scope.wl_2_4_macacl = function () {
            $scope.macString = "";
            var macaclObj = {
                "nodeId": $state.params.nodeId,
                "macACLStatus": $scope.macACLData2.macACLStatusName.macACLStatus,
                "macACLAddress": $scope.macAddr2.join(" ")
            }

            var confirm = $scope.saveconfirm();

            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2//nodewirelessview/savemacltg',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: macaclObj
                }).success(function () {
                    $scope.showAlert('success', 'Saved successfully.');
                }).error(function (msg) {
                    $scope.showAlert('error', 'Error creating Data: ' + msg);
                });
            });
        }

        //2.4 temp remove call for mac acl


        //Encription Key mask unmask functionality for 5ghz
        $scope.masking = function () {
            var x = document.getElementById("input_j_password");
            var y = document.getElementById("mask-reveal");
            if (x.type === "password") {
                x.type = "text";
                y.src = "./images/eye.png";
            } else {
                x.type = "password";
                y.src = "./images/eye-slash.png";
            }
        }

        //Encription Key mask unmask functionality for 2.4ghz
        $scope.masking2 = function () {
            var x = document.getElementById("input_j_password2");
            var y = document.getElementById("mask-reveal2");
            if (x.type === "password") {
                x.type = "text";
                y.src = "./images/eye.png";
            } else {
                x.type = "password";
                y.src = "./images/eye-slash.png";
            }
        }
        $scope.resetPassword = function (pwd) {
            var pass = pwd;
            var changed = false;
            if(pass.length>0){
                for (var i = 0; i < pass.length; i++) {
                    if (pass.charAt(i) != '*') {
                        changed = true;
                        return pass;
                    }
                }
            }
            return null;
        }
        $scope.changedWirelessArray = [];
        $scope.wirelessObj = function (group, key, modelvalue,indexvalue) {
            if (key == 'txa1' || key == 'txa2') {
                if ($scope.mimoData.txa1 && $scope.mimoData.txa2) {
                    $scope.mimoData.txChainMask = 3;
                } else if ($scope.mimoData.txa1 == true && $scope.mimoData.txa2 == false) {
                    $scope.mimoData.txChainMask = 1;
                } else if ($scope.mimoData.txa1 == false && $scope.mimoData.txa2 == true) {
                    $scope.mimoData.txChainMask = 2;
                } else if ($scope.mimoData.txa1 == false && $scope.mimoData.txa2 == false) {
                    $scope.mimoData.txChainMask = 0;
                }
                $scope.exist = false;
                if ($scope.changedWirelessArray.length > 0) {
                    for (var i = 0; i < $scope.changedWirelessArray.length; i++) {
                        if ($scope.changedWirelessArray[i].key == "txChainMask" && $scope.changedWirelessArray[i].group == group) {
                            $scope.changedWirelessArray[i].value = $scope.mimoData.txChainMask;
                            $scope.exist = true;
                        }
                    }
                }
                if (!$scope.exist) {
                    $scope.changedWirelessArray.push({ "group": group, "key": "txChainMask", "value": $scope.mimoData.txChainMask });
                }
                modelvalue = "";
            }
            if (key == 'rxa1' || key == 'rxa2') {
                if ($scope.mimoData.rxa1 && $scope.mimoData.rxa2) {
                    $scope.mimoData.rxChainMask = 3;
                } else if ($scope.mimoData.rxa1 == true && $scope.mimoData.rxa2 == false) {
                    $scope.mimoData.rxChainMask = 1;
                } else if ($scope.mimoData.rxa1 == false && $scope.mimoData.rxa2 == true) {
                    $scope.mimoData.rxChainMask = 2;
                } else if ($scope.mimoData.rxa1 == false && $scope.mimoData.rxa2 == false) {
                    $scope.mimoData.rxChainMask = 0;
                }
                $scope.exist = false;
                if ($scope.changedWirelessArray.length > 0) {
                    for (var i = 0; i < $scope.changedWirelessArray.length; i++) {
                        if ($scope.changedWirelessArray[i].key == "rxChainMask" && $scope.changedWirelessArray[i].group == group) {
                            $scope.changedWirelessArray[i].value = $scope.mimoData.rxChainMask;
                            $scope.exist = true;
                        }
                    }
                }
                if (!$scope.exist) {
                    $scope.changedWirelessArray.push({ "group": group, "key": "rxChainMask", "value": $scope.mimoData.rxChainMask,"index":indexvalue  });
                }
                modelvalue = "";
            }
            // $scope.changedWirelessArray.push({ "group": 'mimoddrs', "key": 'txChainMask', "value": $scope.mimoData.txChainMask });
            // $scope.changedWirelessArray.push({ "group": 'mimoddrs', "key": 'rxChainMask', "value": $scope.mimoData.rxChainMask });
            if(key=='hideSSIDVal'){
                if(modelvalue){
                    modelvalue=1;
                }else{
                    modelvalue=0;
                }
            }
            if (modelvalue!="" && modelvalue!=null && modelvalue!=undefined) {
                //if(modelvalue==0){
                    $scope.exist = false;
                    if ($scope.changedWirelessArray.length > 0) {
                        for (var i = 0; i < $scope.changedWirelessArray.length; i++) {
                            if ($scope.changedWirelessArray[i].key == key && $scope.changedWirelessArray[i].group == group) {
                                $scope.changedWirelessArray[i].value = modelvalue;
                                $scope.exist = true;
                            }
                        }
                    }
                    if (!$scope.exist) {
                        $scope.changedWirelessArray.push({ "group": group, "key": key, "value": modelvalue,"index":indexvalue  });
                    }
               // }               
            }
            if(modelvalue==0){
                 if ($scope.changedWirelessArray.length > 0) {
                        for (var i = 0; i < $scope.changedWirelessArray.length; i++) {
                            if ($scope.changedWirelessArray[i].key == key && $scope.changedWirelessArray[i].group == group) {
                                $scope.changedWirelessArray[i].value = modelvalue;
                                $scope.exist = true;
                            }
                        }
                    }
                    if (!$scope.exist) {
                        $scope.changedWirelessArray.push({ "group": group, "key": key, "value": modelvalue,"index":indexvalue  });
                    }
            }
            console.log("changedWirelessArray", $scope.changedWirelessArray);
        }

        $scope.wirelesssave = function () {
//            if ($scope.macAddr5.length > 0) {
//               // var value = $scope.macAddr5.join(" ");
//               // $scope.changedWirelessArray.push({ "group": 'securitymac', "key": 'mac5_macACLAddress', "value": value });
//               for(var i=0;i<$scope.macAddr5.length;i++){
//                $scope.changedWirelessArray.push({ "group": 'securitymac', "key": 'mac5_macACLAddress', "value": $scope.macAddr5[i],"action":"A"  });
//               }
//            }
            // if ($scope.macAddr2.length > 0) {
            //     // var value = $scope.macAddr2.join(" ");
            //     // $scope.changedWirelessArray.push({ "group": 'security2.4', "key": 'mac2.4_macACLAddress', "value": value });
            //     for(var i=0;i<$scope.macAddr2.length;i++){
            //         $scope.changedWirelessArray.push({ "group": 'security2.4', "key": 'mac2.4_macACLAddress', "value": $scope.macAddr2[i],"action":"A"  });
            //        }
            // }
            if ($scope.propertiesData.radioMode.mType != 'ap' && $scope.propertiesData.radioMode.mType != null) {
                var bandwidthFound = $scope.changedWirelessArray.findIndex(x => x.key === 'bndwdt');
                if (bandwidthFound != -1) {
                    $scope.changedWirelessArray.splice(bandwidthFound, 1);
                }
                var chnnlFound = $scope.changedWirelessArray.findIndex(x => x.key === 'chnnl');
                if (chnnlFound != -1) {
                    $scope.changedWirelessArray.splice(chnnlFound, 1);
                }
            }
            if ($scope.propertiesData.radioMode.mType != 'sta' && $scope.propertiesData.radioMode.mType != null) {
                var winatimerFound = $scope.changedWirelessArray.findIndex(x => x.key === 'chnwirelessInactivityTimernl');
                if (winatimerFound != -1) {
                    $scope.changedWirelessArray.splice(winatimerFound, 1);
                }

                var linkinatimerFound = $scope.changedWirelessArray.findIndex(x => x.key === 'chnlinkInactivityTimernl');
                if (linkinatimerFound != -1) {
                    $scope.changedWirelessArray.splice(linkinatimerFound, 1);
                }
            }
            if ($scope.propertiesData.radioMode.mType == 'ap' && $scope.propertiesData.lnktype.linkType == 3) {
            } else {
                var maxSUFound = $scope.changedWirelessArray.findIndex(x => x.key === 'maxSUCount');
                if (maxSUFound != -1) {
                    $scope.changedWirelessArray.splice(maxSUFound, 1);
                }
            }
            if (!$scope.max_min) {
                var modIndexNameminFound = $scope.changedWirelessArray.findIndex(x => x.key === 'modIndexNamemin');
                if (modIndexNameminFound != -1) {
                    $scope.changedWirelessArray.splice(modIndexNameminFound, 1);
                }
                var modIndexNamemaxFound = $scope.changedWirelessArray.findIndex(x => x.key === 'modIndexNamemax');
                if (modIndexNamemaxFound != -1) {
                    $scope.changedWirelessArray.splice(modIndexNamemaxFound, 1);
                }
            }
            if (!$scope.txRate) {
                var txRateIndexNameFound = $scope.changedWirelessArray.findIndex(x => x.key === 'txRateIndexName');
                if (txRateIndexNameFound != -1) {
                    $scope.changedWirelessArray.splice(txRateIndexNameFound, 1);
                }
            }
            if ($scope.ddrsData.atpcStatusName.atpcStatus != 2 && $scope.ddrsData.atpcStatusName.atpcStatus != null) {
                var transmitPowerFound = $scope.changedWirelessArray.findIndex(x => x.key === 'transmitPower');
                if (transmitPowerFound != -1) {
                    $scope.changedWirelessArray.splice(transmitPowerFound, 1);
                }
            }
            if (!$scope.showEirp) {
                var eirpStatusFound = $scope.changedWirelessArray.findIndex(x => x.key === 'eirpStatus');
                if (eirpStatusFound != -1) {
                    $scope.changedWirelessArray.splice(eirpStatusFound, 1);
                }
            }
            //mimo
            // if ($scope.mimoData.txChainMask === 0 || $scope.mimoData.rxChainMask === 0) {
            //     $scope.showAlert('error', 'Please Select atlease one chainmask');
            // } else {
            console.log("save wireless obj", $scope.changedWirelessArray);
            if($scope.changedWirelessArray.length>0){
                var confirm = $scope.saveconfirm();
                $mdDialog.show(confirm).then(function () {    
                    $http({
                        method: 'POST',
                        url: 'api/v2/nodewirelessview/wirsave/' + $state.params.nodeId,
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        data: $scope.changedWirelessArray
                    }).success(function () {
                        // $scope.load_5ghz_wireless_properties();
                        // $scope.load_5ghz_wireless_mimo();
                        // $scope.load_5ghz_wireless_ddrs();
                        // $scope.load_5ghz_wireless_security();
                        // $scope.load_5ghz_wireless_macacl();
                        // $scope.load_5ghz_dcs();
                        // $scope.load_2_4ghz_wireless_properties();
                        // $scope.load_2_4ghz_wireless_security();
                        // $scope.load_2_4ghz_wireless_macacl();
                        $scope.get_save_changes();
                        $scope.showAlert('success', 'Saved successfully.');
                        $scope.changedWirelessArray = [];
                    }).error(function (msg) {
                        $scope.showAlert('error', 'Error creating Data: ' + msg);
                    });    
                });               
            }
            //}
        }

        $scope.applyFunWireless = function () {
            $scope.get_save_changes();
            $("#showchangesWireless").modal('show');
        }

        $scope.commitWireless = function () {
            for(var i=0;i<$scope.saveChangesObj.changes.length;i++){
                var splitobj = $scope.saveChangesObj.changes[i].key.split('_');
                $scope.saveChangesObj.changes[i].group=splitobj[0];
                $scope.saveChangesObj.changes[i].key=splitobj[1];
            }
            console.log("commit", $scope.saveChangesObj.changes);
            $http({
                method: 'POST',
                url: 'api/v2/profiles/save/' + $state.params.nodeId,
                headers: {
                    'Content-Type': 'application/json'
                },
                data: $scope.saveChangesObj.changes
            }).success(function () {
                $scope.showAlert('success', 'Commited successfully.');
                $("#showchangesWireless").modal('hide');
                $scope.load_5ghz_wireless_properties();
                $scope.load_5ghz_wireless_mimo();
                $scope.load_5ghz_wireless_ddrs();
                $scope.load_5ghz_wireless_security();
                $scope.load_5ghz_wireless_macacl();
                $scope.load_5ghz_dcs();
                $scope.load_2_4ghz_wireless_properties();
                $scope.load_2_4ghz_wireless_security();
                $scope.load_2_4ghz_wireless_macacl();
                $scope.get_save_changes();
            }).error(function (msg) {
                $("#showchangesWireless").modal('hide');
                $scope.showAlert('error', 'Error creating Data: ' + msg);
            });
        }

        $scope.revertWireless=function(){
            for(var i=0;i<$scope.saveChangesObj.changes.length;i++){
                var splitobj = $scope.saveChangesObj.changes[i].key.split('_');
                $scope.saveChangesObj.changes[i].group=splitobj[0];
                $scope.saveChangesObj.changes[i].key=splitobj[1];
            }
            $http({
                method: 'POST',
                url: 'api/v2/profiles/revert/' + $state.params.nodeId,
                headers: {
                    'Content-Type': 'application/json'
                },
                data: $scope.saveChangesObj.changes
            }).success(function () {
                $scope.load_5ghz_wireless_properties();
                $scope.load_5ghz_wireless_mimo();
                $scope.load_5ghz_wireless_ddrs();
                $scope.load_5ghz_wireless_security();
                $scope.load_5ghz_wireless_macacl();
                $scope.load_5ghz_dcs();
                $scope.load_2_4ghz_wireless_properties();
                $scope.load_2_4ghz_wireless_security();
                $scope.load_2_4ghz_wireless_macacl();
                $scope.get_save_changes();
                $scope.showAlert('success', 'Reverted successfully.');
                $("#showchangesWireless").modal('hide');
            }).error(function (msg) {
                $("#showchangesWireless").modal('hide');
                $scope.showAlert('error', 'Error creating Data: ' + msg);
            });
        }

    }
]);

/*****
    Changes..
    2019-06-03 ---> fixed issues related to UI
                    added Max SU count, retries
    2019-06-04 ---> removed support for Distance in 5Ghz

*/
