﻿dashboard.controller("NodeViewController", ['$localStorage', '$rootScope', '$scope', '$mdDialog', '$http', '$state', 'dashboardService', 'Flash', '$interval', '$window',
    function ($localStorage, $rootScope, $scope, $mdDialog, $http, $state, dashboardService, Flash, $interval, $window,) {
        //$scope.callstore = $localStorage.teststore;
        var vm = this;
        $scope.vm.node = {};
        $scope.nodeLinks = [];
        $scope.nodeViewTimer = null;
        $scope.responseReceived = true;
        $scope.provButtonLabel = "Provision"
        $scope.enableProvButton = 0;
        $scope.enableSUSButton = -1;
        $scope.cpuBar = null;
        $scope.memoryBar = null;
        $scope.remoteIP = ""
        $scope.enableRemote = false;
        $scope.remoteId = null;
        $scope.rerender = "rerender";
        $scope.showSUService = false;

        $scope.tempUnicode = '0x2109';
        // $scope.devicestatus=false;

        $scope.vhtTable = [
            { "index": 0, "dataRt": 7, "pwrDiff": 0, "minRSSI": -89, "eDataRt": 6 },
            { "index": 1, "dataRt": 14, "pwrDiff": 0, "minRSSI": -87, "eDataRt": 11 },
            { "index": 2, "dataRt": 21, "pwrDiff": 0, "minRSSI": -86, "eDataRt": 17 },
            { "index": 3, "dataRt": 28, "pwrDiff": 0, "minRSSI": -82, "eDataRt": 22 },
            { "index": 4, "dataRt": 43, "pwrDiff": 0, "minRSSI": -80, "eDataRt": 34 },
            { "index": 5, "dataRt": 57, "pwrDiff": 1, "minRSSI": -76, "eDataRt": 46 },
            { "index": 6, "dataRt": 65, "pwrDiff": 1, "minRSSI": -74, "eDataRt": 52 },
            { "index": 7, "dataRt": 72, "pwrDiff": 3, "minRSSI": -73, "eDataRt": 58 },
            { "index": 8, "dataRt": 86, "pwrDiff": 3, "minRSSI": -69, "eDataRt": 69 },
            { "index": 9, "dataRt": 96, "pwrDiff": 3, "minRSSI": -67, "eDataRt": 77 },
            { "index": 10, "dataRt": 14, "pwrDiff": 0, "minRSSI": -89, "eDataRt": 11 },
            { "index": 11, "dataRt": 28, "pwrDiff": 0, "minRSSI": -87, "eDataRt": 21 },
            { "index": 12, "dataRt": 43, "pwrDiff": 0, "minRSSI": -86, "eDataRt": 34 },
            { "index": 13, "dataRt": 57, "pwrDiff": 0, "minRSSI": -84, "eDataRt": 43 },
            { "index": 14, "dataRt": 86, "pwrDiff": 0, "minRSSI": -82, "eDataRt": 66 },
            { "index": 15, "dataRt": 115, "pwrDiff": 1, "minRSSI": -77, "eDataRt": 88 },
            { "index": 16, "dataRt": 130, "pwrDiff": 1, "minRSSI": -76, "eDataRt": 100 },
            { "index": 17, "dataRt": 144, "pwrDiff": 3, "minRSSI": -72, "eDataRt": 110 },
            { "index": 18, "dataRt": 173, "pwrDiff": 3, "minRSSI": -69, "eDataRt": 126 },
            { "index": 19, "dataRt": 192, "pwrDiff": 3, "minRSSI": -67, "eDataRt": 145 }
        ];
      
        // $scope.myFunction=function(){
        //     var x = document.getElementById("myTopnav");
        //     if (x.className === "topnav") {
        //       x.className += " responsive";
        //     } else {
        //       x.className = "topnav pull-right";
        //     }
        // }
        
        // init method calling for get summary data
        $scope.init = function () {
            $('#mydiv').show();

            $scope.checkpaRoute = window.location.hash.includes("topology");
            if ($scope.checkpaRoute) {
                $scope.fontClass1 = "fontsize-12";
                $scope.fontClass2 = "fontsize-12";
                $scope.nodeviewfont="fontsize-18";
                $scope.monitordiv="col-md-4 col-sm-4 col-lg-4";
                $scope.systemstatisticsdiv="col-md-3 col-sm-3 col-lg-3 paddingleftright";
                $scope.mappaddingreset = true;
            } else {
                $scope.fontClass1 = "fontsize-14"
                $scope.fontClass2 = "fontsize-14";
                $scope.nodeviewfont="fontsize-22";
                $scope.monitordiv="col-md-3 col-sm-3 col-lg-3";
                $scope.systemstatisticsdiv="col-md-2 col-sm-2 col-lg-2 paddingleftright";
                $scope.mappaddingreset = false;
            }
            $scope.showSUService = false;
            if ($state.params.nodeId) {
                $localStorage.nodeId = $state.params.nodeId;
                $scope.ndID = $state.params.nodeId;
            } else {
                $state.params.nodeId = $localStorage.nodeId;
                $scope.ndID = $state.params.nodeId;
            }
            if ($state.params.nodeId) {
                $scope.loadNodeByIdOnStart($state.params.nodeId);
                $scope.loadcpu_memory($state.params.nodeId);
                $scope.loadNodeById($state.params.nodeId);
                //$scope.loadDBData($state.params.nodeId);
            }
            $scope.cpuBar = new ldBar("#cpu");
            var bar2 = angular.element('#cpu').ldBar;
            $scope.cpuBar.set(0);

            $scope.memoryBar = new ldBar("#memory");
            var bar = angular.element('#memory').ldBar;
            $scope.memoryBar.set(0);
            var metrics = $rootScope.metrics;
            if (!metrics) {
                metrics = $rootScope.buildCode;
            }
            $scope.buildCode = metrics;
            if (metrics == 'US') {
                $scope.tempUnicode = 'F';
            } else {
                $scope.tempUnicode = 'C';
            }

        }

        $scope.$on('$destroy', function () {
            $scope.stopTimer();
        });

        /*$scope.startLinkTimer = function(nodeId) {
            $scope.nodeViewTimer = $interval(function() {
                $scope.loadLinkDetails(nodeId)
            }, 3000);
        }*/




        $scope.summaryDashTimer = function () {
            /* $scope.throughputtimer = $interval(function() {
                 $scope.liveWirelessData()
             }, 3000);*/
        }

        $scope.stopTimer = function () {
            if (angular.isDefined($scope.nodeViewTimer)) {

                $interval.cancel($scope.nodeViewTimer);
            }
            /*if (angular.isDefined($scope.throughputtimer)) {
                $interval.cancel($scope.throughputtimer);
            }*/
        }

        $scope.enableDisableProvButton = function () {
            if ($scope.enableProvButton == 0) {
                return true;
            } else {
                return false;
            }

        }

        $scope.enableDisableSUSerButton = function () {
            if ($scope.enableSUSButton == -1) {
                return true;
            } else {
                return false;
            }

        }

        $rootScope.nodelatitude="";
        $rootScope.nodelongitude="";
        //summary data
        $scope.loadNodeById = function (nodeId) {
            var url = 'api/v2/nodemanageview/summary?nodeId=' + nodeId;
            return $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.vm.node = response.data;
                        if($scope.vm.node.latitude){
                            $rootScope.nodelatitude=$scope.vm.node.latitude;
                        }
                        if($scope.vm.node.longitude){
                            $rootScope.nodelongitude=$scope.vm.node.longitude;
                        }
                        if ($scope.vm.node.radio24Ghz != null && $scope.vm.node.radio24Ghz.radioMode == 'ap') {
                            if ($rootScope.builCode && $rootScope.builCode == 'US') {
                                $scope.vm.node.radio24Ghz.radioMode = 'Management'
                            } else {
                                $scope.vm.node.radio24Ghz.radioMode = 'Access Point'
                            }
                        }
                        if ($scope.vm.node.systemConfig) {
                            $scope.vm.node.systemConfig.custNameEllipse = ellipsemodel(response.data.systemConfig.custName,10,8);
                        }
                        if ($scope.vm.node.ipConfig) {
                            $scope.vm.node.ipConfig.ipAddressEllipse = ellipsemodel(response.data.ipConfig.ipAddress,15,8);
                        }
                        if ($scope.vm.node.radio5Ghz) {
                            if($scope.vm.node.radio5Ghz.ssid){
                            $scope.vm.node.radio5Ghz.ssidEllipse = ellipsemodel($scope.vm.node.radio5Ghz.ssid,13,11);
                        }
                        }
                        if ($scope.vm.node.radio5Ghz) {
                            if($scope.vm.node.radio5Ghz.radioMode){
                            $scope.vm.node.radio5Ghz.radioModeEllipse = ellipsemodel($scope.vm.node.radio5Ghz.radioMode,13,11);
                        }
                        }

                        if ($scope.vm.node.radio24Ghz) {
                            if($scope.vm.node.radio24Ghz.ssid){
                                $scope.vm.node.radio24Ghz.ssidEllipse = ellipsemodel($scope.vm.node.radio24Ghz.ssid,13,11);
                            }
                        }                        
                        if ($scope.vm.node.radio24Ghz) {
                            if($scope.vm.node.radio24Ghz.radioMode){
                            $scope.vm.node.radio24Ghz.radioModeEllipse = ellipsemodel($scope.vm.node.radio24Ghz.radioMode,13,11);
                        }
                        }
                        $rootScope.linkType = $scope.vm.node.radio5Ghz.linkType;
                        if (response.data.provisioned) {
                            $scope.provButtonLabel = "UnProvision"
                            $scope.enableProvButton = 1;
                        } else {
                            $scope.provButtonLabel = "Provision"
                            $scope.enableProvButton = 2;
                        }

                        if (response.data.suService == 1) {
                            $scope.suservButtonLabel = "Disable"
                            $scope.enableSUSButton = 1;
                            //$scope.showSUService = true;
                        } else if (response.data.suService == 0) {
                            $scope.suservButtonLabel = "Enable"
                            $scope.enableSUSButton = 2;
                            //$scope.showSUService = true;
                        } else {
                            $scope.suservButtonLabel = "Disable"
                            $scope.enableSUSButton = -1;
                        }

                        if (response.data.radio5Ghz.radioMode == 'sta') {
                            $scope.showSUService = true;
                        }

                        if (response.data.remoteId != null) {
                            $scope.remoteIP = response.data.remoteIP;
                            $scope.enableRemote = true;
                            $scope.showSUService = true;
                            $scope.remoteId = response.data.remoteId;
                        }
                        $rootScope.ipAddress = response.data.ipConfig.ipAddress;
                        return response.data;
                    }
                });
        }



        // Initialize and add the map
        $scope.initMap = function () {
            // The location of Uluru
            const uluru = { lat: -25.344, lng: 131.036 };
            var mapid = document.getElementById("map_node");
            // The map, centered at Uluru
            const map = new google.maps.Map(document.getElementById("map_node"), {
                zoom: 4,
                center: uluru,
            });
            // The marker, positioned at Uluru
            const marker = new google.maps.Marker({
                position: uluru,
                map: map,
            });
        }

        $scope.$watch(function () {
            var metrics = $rootScope.metrics;

            if (!metrics) {
                metrics = $rootScope.buildCode;
            }
            $scope.buildCode = metrics;
            if (metrics == 'US') {
                $scope.tempUnicode = 'F';
            } else {
                $scope.tempUnicode = 'C';
            }
            return $rootScope.buildCode;
        }, function () {
            var metrics = $rootScope.metrics;

            if (!metrics) {
                metrics = $rootScope.buildCode;
            }
            $scope.buildCode = metrics;
            //$scope.buildCode = $rootScope.buildCode;
        }, true);

        $scope.loadDBData = function (nodeId) {
            var url = 'api/v2/nodemanageview/summarydb?nodeId=' + nodeId;
            return $http.get(url, { showdiv: false })
                .then(function (response) {
                    if (response.data) {

                        //$scope.vm.node = response.data;
                        /*$scope.vm.node.systemConfig.sysTime = response.data.systemConfig.sysTime;
                        $scope.vm.node.systemConfig.firmwareVersion = response.data.systemConfig.firmwareVersion

                        //firmwareVersion
                        if ($scope.vm.node.provisioned) {
                            $scope.provButtonLabel = "UnProvision"
                            $scope.enableProvButton = 1;
                        } else {
                            $scope.provButtonLabel = "Provision"
                            $scope.enableProvButton = 2;
                        }*/

                        $rootScope.ipAddress = response.data.ipConfig.ipAddress;


                        return response.data;
                    }
                });
        }

        function ellipsemodel(str,count, displaycount) {
            // If string length is longer than 10
            if (str.length > count) {
                return str.substr(0, displaycount) + ' ... ';// + str.substr(str.length - 5, str.length);
            }
            return str;
        }
        $scope.loadLinkDetails = function (nodeId) {

            if ($scope.responseReceived == true) {
                $scope.responseReceived = false;
                var url = 'api/v2/nodelinks/linkstats?ipAddress=' + nodeId;
                return $http.get(url)
                    .then(function (response) {
                        if (response.data) {
                            $scope.nodeLinks = response.data.links;
                            $scope.responseReceived = true;
                            return response.data;
                        }
                    });
            }

        }

        // Node Action methods
        $scope.actionNode = function (action_type) {
            if (action_type === 'rescan') {
                var confirmMsg = 'Are you sure you wish to rescan device?';
                var confirm = $scope.saveconfirm(undefined, confirmMsg);
                $mdDialog.show(confirm).then(function () {
                    $http({
                        method: 'POST',
                        url: 'api/v2/nodes/rescanNode',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        data: $state.params.nodeId
                    }).success(function () {
                        $scope.showAlert('Success', 'Rescanning of the node initiated');
                    }).error(function (msg) {
                        $scope.showAlert('Error', 'Failed to resan the node: ' + msg);
                    })
                });

            } else if (action_type === "commit") {
                var confirmMsg = 'Are you sure you wish to commit the changes? \n Any unsaved changes will be committed to device';
                var confirm = $scope.saveconfirm(undefined, confirmMsg);
                $mdDialog.show(confirm).then(function () {
                    $http({
                        method: 'POST',
                        url: 'api/v2/nodelinks/commit?nodeId=' + $state.params.nodeId,
                        headers: {
                            'Content-Type': 'application/json'
                        }
                    }).success(function () {
                        $scope.showAlert('Success', 'Commit of the node initiated');
                    }).error(function (msg) {
                        $scope.showAlert('Error', 'Failed to commit the node: ' + msg);
                    });
                })

            } else if (action_type === "reboot") {
                var confirmMsg = 'Are you sure you wish to reboot the node? Any unsaved changes will be lost.';
                var confirm = $scope.saveconfirm(undefined, confirmMsg);
                $mdDialog.show(confirm).then(function () {
                    $http({
                        method: 'POST',
                        url: 'api/v2/nodelinks/reboot?nodeId=' + $state.params.nodeId,
                        headers: {
                            'Content-Type': 'application/json'
                        }
                    }).success(function () {
                        $scope.showAlert('Success', 'Reboot of the node initiated');
                    }).error(function (msg) {
                        $scope.showAlert('Error', 'Failed to reboot the node: ' + msg);
                    });
                })

            } else if (action_type === "provision") {
                if ($scope.enableProvButton != 0) {
                    var URL = '';
                    var confirmMsg = 'Are you sure you wish to provision device?'
                    if ($scope.enableProvButton == 1) {
                        URL = 'api/v2/profiles/' + $state.params.nodeId + '/unprov'
                        confirmMsg = 'Are you sure you wish to unprovision device?'
                    } else if ($scope.enableProvButton == 2) {
                        URL = 'api/v2/profiles/' + $state.params.nodeId + '/prov'
                    }
                    var confirm = $scope.saveconfirm(undefined, confirmMsg);
                    $mdDialog.show(confirm).then(function () {
                        $http({
                            method: 'POST',
                            url: URL,
                            headers: {
                                'Content-Type': 'application/json'
                            }
                        }).success(function () {
                            $scope.showAlert('Success', 'Initiated device Provisioning process');
                            if ($scope.enableProvButton == 1) {
                                $scope.provButtonLabel = "Provision"
                                $scope.enableProvButton = 2;
                            } else if ($scope.enableProvButton == 2) {
                                $scope.provButtonLabel = "UnProvision"
                                $scope.enableProvButton = 1;
                            }
                        }).error(function (msg) {
                            $scope.showAlert('Error', 'Failed due to : ' + msg);
                        });

                    })
                }
            } else if (action_type === 'suserv') {
                if ($scope.enableSUSButton != -1) {
                    var URL = '';
                    var confirmMsg = 'Are you sure you wish to enable SU Service?'
                    if ($scope.enableSUSButton == 1) {
                        URL = 'api/v2/nodelinks/suser/' + $state.params.nodeId + '/0';
                        confirmMsg = 'Are you sure you wish to disable SU Service?';
                    } else if ($scope.enableSUSButton == 2) {
                        URL = 'api/v2/nodelinks/suser/' + $state.params.nodeId + '/1';
                    }
                    var confirm = $scope.saveconfirm(undefined, confirmMsg);
                    $mdDialog.show(confirm).then(function () {
                        $http({
                            method: 'POST',
                            url: URL,
                            headers: {
                                'Content-Type': 'application/json'
                            }
                        }).success(function () {
                            $scope.showAlert('Success', 'Initiated device Provisioning process');
                            if ($scope.enableProvButton == 1) {
                                $scope.suservButtonLabel = "Enable"
                                $scope.enableProvButton = 2;
                            } else if ($scope.enableProvButton == 2) {
                                $scope.suservButtonLabel = "Disable"
                                $scope.enableProvButton = 1;
                            }
                            var checkRoute = window.location.hash.includes("topology");
                            if (checkRoute) {
                                $scope.init();
                                var ele = document.getElementsByClassName("btn-secondary");
                                if (ele != null) {
                                    for (var i = 0; i < ele.length; i++) {
                                        if (ele[i].className.includes("active")) {
                                            ele[i].classList.remove("active");
                                            break;
                                        }
                                    }
                                    ele[0].classList.add("active");
                                }
                            } else {
                                $window.location.reload(true);
                            }
                        }).error(function (msg) {
                            $scope.showAlert('Error', 'Failed due to : ' + msg);
                        });

                    })
                }
            }
        }

        //Open Screen on click
        $scope.openNode = function (type) {
            if (type == "summary") {
                $scope.viewNode = "summary";
            } else if (type == "network") {
                $scope.viewNode = "network";
            } else if (type == "management") {
                $scope.viewNode = "management";
            }
            else if (type == "wireless") {
                $scope.viewNode = "wireless";
            }
            else if (type == "monitor") {
              $state.params.lastView='';
                $scope.viewNode = "monitor";
            }
        }

        $scope.showAlert = function (msgType, msg, ev) {
            $mdDialog.show(
                $mdDialog.alert()
                    .parent(angular.element(document.querySelector('#popupContainer')))
                    .clickOutsideToClose(true)
                    .title(msgType)
                    .textContent(msg)
                    .ariaLabel('Alert')
                    .ok('OK')
                    .targetEvent(ev)
            );
        };
        // window.onresize = resize;
        // function resize() {
        //     var el = document.getElementById('nav-id');
        //     var divHeight = el.offsetHeight
        //     var lineHeight = parseInt(el.style.lineHeight);
        //     var lines = divHeight / lineHeight;
        //     alert("Lines: " + lines);
        // }

        // $scope.countLines=function() {
        //     var el = document.getElementById('buttoncontent');
        //     var divHeight = el.offsetHeight
        //     var lineHeight = parseInt(el.style.lineHeight);
        //     var lines = divHeight / lineHeight;
        //     alert("Lines: " + lines);
        //  }
        // nodeview accordion menu default highlite
        $scope.activeheader = 'Summary';
        if ($state.params.lastView == "app.Events") {
            $scope.viewNode = 'monitor';//'node_events';
            $scope.eventsActive = "active";
            $scope.summaryActive = "";
            $scope.linkActivecss = "background-color:rgb(246, 246, 246);color:black";
            $rootScope.$emit("callevents", {});
            $scope.activeheader = 'Monitor';
        } else if ($state.params.lastView == "app.linkStats") {
            $scope.viewNode = 'monitor';
            $scope.eventsActive = "active";
            $scope.summaryActive = "";
            $scope.linkActivecss = "background-color:rgb(246, 246, 246);color:black";
            $rootScope.$emit("calllinkstatistics", {});
            $scope.activeheader = 'Monitor';
        } else if ($state.params.lastView == "app.wireless") {
            $scope.viewNode = 'wireless_statistics';
            $scope.eventsActive = "active";
            $scope.summaryActive = "";
            $scope.linkActivecss = "";
            $scope.wirelessActivecss = "background-color:rgb(246, 246, 246);color:black";
        } else if ($state.params.lastView == "app.linkDetail") {
            $scope.viewNode = 'linkdetail';
            $scope.eventsActive = "active";
            $scope.summaryActive = "";
            $scope.linkActivecss = "background-color:rgb(246, 246, 246);color:black";
        } else {
            $scope.viewNode = 'summary';
            $scope.summaryActive = "active";
            $scope.summaryActivecss = "background-color:rgb(246, 246, 246);color:black";
            $scope.eventActive = "";
            $scope.linkActivecss = "";
        }


        $scope.opensystemstatistics=function(){
            $scope.viewNode = "monitor";
            $scope.activeheader = 'Monitor';
            $scope.active = 'Monitor';
            if($rootScope.graphclickeventnew==undefined || $rootScope.graphclickeventnew==''){
                $rootScope.graphclickeventnew=3;
            }
            $state.params.lastView='app.systemstatistics';
            $rootScope.$emit("callsystemstat", {});
        }


        //    nodeview sidemenu on click page open methos
        $scope.showDiv = function (viewNode) {
            if (viewNode == 'wl-5ghz-properties') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wl-5ghz-mimo') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;

            } else if (viewNode == 'wl-5ghz-DDRS') {

                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wl-5ghz-security') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wl-5ghz-mac_acl') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wl-5ghz-dcs') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wl-2.4ghz-properties') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wl-2.4ghz-security') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'summary') {
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wl-2.4ghz-mac_acl') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'network-ipconfig') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'network-vlanconfig') {

                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;

            } else if (viewNode == 'network-ethernetconfig') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;

            } else if (viewNode == 'network-ethernetradius') {

                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;

            } else if (viewNode == 'network-dhcpconfig') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;

            } else if (viewNode == 'management_general') {

                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;

            } else if (viewNode == 'management_logging') {

                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'management_location') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'management_http/https') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'telnet') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'snmp') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'reset') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'linkstat') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wireless_statistics') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'ethernet_statistics') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'system_statistics') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'node_events') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'linkdetail') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'spectrum') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            }
        }

        $rootScope.$on("Callinit", function (event, args) {
            $scope.init(args.nodeId);
            //$rootScope.$emit("CallinitGraph",{});
        })

        $scope.loadNodeByIdOnStart = function (nodeId) {            
            var url = 'api/v2/nodemanageview/summarydb?nodeId=' + nodeId;
            return $http.get(url, { showdiv: false })
                .then(function (response) {
                    if (response.data) {
                        $scope.vm.node = response.data;
                        if($scope.vm.node.latitude){
                            $rootScope.nodelatitude=$scope.vm.node.latitude;
                        }
                        if($scope.vm.node.longitude){
                            $rootScope.nodelongitude=$scope.vm.node.longitude;
                        }
                        $rootScope.devicestatus=$scope.vm.node.nodeStatus;                       
                        console.log("$rootScope.devicestatus",$rootScope.devicestatus);
                        if ($scope.vm.node.systemConfig) {
                            $scope.vm.node.systemConfig.custNameEllipse = ellipsemodel(response.data.systemConfig.custName,10,8);
                        }
                        if ($scope.vm.node.ipConfig) {
                            $scope.vm.node.ipConfig.ipAddressEllipse = ellipsemodel(response.data.ipConfig.ipAddress,15,8);
                        }
                        if ($scope.vm.node.provisioned) {
                            $scope.provButtonLabel = "UnProvision"
                            $scope.enableProvButton = 1;
                        } else {
                            $scope.provButtonLabel = "Provision"
                            $scope.enableProvButton = 2;
                        }
                        if (response.data.suService == 1) {
                            $scope.suservButtonLabel = "Disable"
                            $scope.enableSUSButton = 1;
                            //$scope.showSUService = true;
                        } else if (response.data.suService == 0) {
                            $scope.suservButtonLabel = "Enable"
                            $scope.enableSUSButton = 2;
                            //$scope.showSUService = true;
                        } else {
                            $scope.suservButtonLabel = "Disable"
                            $scope.enableSUSButton = -1;
                        }

                        if (response.data.radio5Ghz.radioMode == 'sta') {
                            $scope.showSUService = true;
                        }

                        // $scope.vm.node.systemConfig.temperature = 35;
                        var metrics = $rootScope.metrics;

                        if (!metrics) {
                            metrics = $rootScope.buildCode;
                        }
                        $scope.buildCode = metrics;
                        if (metrics == 'US') {
                            $scope.vm.node.systemConfig.temperature = ($scope.vm.node.systemConfig.temperature * 1.8) + 32;
                        }

                        if ($scope.vm.node.remoteId != null) {
                            $scope.remoteIP = $scope.vm.node.remoteIP;
                            $scope.enableRemote = true;
                            $scope.showSUService = true;
                            $scope.remoteId = $scope.vm.node.remoteId;
                        }
                        $rootScope.ipAddress = $scope.vm.node.ipConfig.ipAddress;
                        if ($scope.vm.node.radio24Ghz != null && $scope.vm.node.radio24Ghz.radioMode == 'ap') {
                            if ($rootScope.builCode && $rootScope.builCode == 'US') {
                                $scope.vm.node.radio24Ghz.radioMode = 'Management'
                            } else {
                                $scope.vm.node.radio24Ghz.radioMode = 'Access Point'
                            }

                            $rootScope.radioMode = 1;
                        }
                        if ($scope.vm.node.radio5Ghz.radioMode == 'sta') {
                            $scope.vm.node.radio5Ghz.radioMode = 'Outdoor Subscriber'
                            //this rootscope is used for under network tab screens
                            $rootScope.radioMode = 2;
                        } else {
                            $scope.vm.node.radio5Ghz.radioMode = 'Outdoor Base'
                            $rootScope.radioMode = 1;
                        }
                        if ($scope.vm.node.ipConfig.mode == 2) {
                            $scope.vm.node.ipConfig.mode = 'Enable';
                        } else {
                            $scope.vm.node.ipConfig.mode = 'Disable';
                        }
                        if ($scope.vm.node.vlan.vlanStatus == 2) {
                            $scope.vm.node.vlan.vlanStatus = 'Disable';
                        } else {
                            $scope.vm.node.vlan.vlanStatus = 'Enable';
                        }
                        //$rootScope.linkType = $scope.vm.node.radio5Ghz.linkType;
                        console.log("nodeview js linktype", $rootScope.linkType);
                        if ($scope.vm.node.radio24Ghz) {
                            if ($scope.vm.node.radio24Ghz.channel == 'auto') {
                                $scope.vm.node.radio24Ghz.channel = 'Auto'
                            }
                        }
                        if ($scope.vm.node.radio5Ghz.channel == 'auto') {
                            $scope.vm.node.radio5Ghz.channel = 'Auto'
                        }
                        if ($scope.vm.node.radio5Ghz.bandwidth == 'HT20') {
                            $scope.vm.node.radio5Ghz.bandwidth = '20 Mhz';
                        } else if ($scope.vm.node.radio5Ghz.bandwidth == 'HT40+') {
                            $scope.vm.node.radio5Ghz.bandwidth = '40 Mhz';
                        } else if ($scope.vm.node.radio5Ghz.bandwidth == 'HT40-') {
                            $scope.vm.node.radio5Ghz.bandwidth = '40 Mhz';
                        }
                        else if ($scope.vm.node.radio5Ghz.bandwidth == 'HT480') {
                            $scope.vm.node.radio5Ghz.bandwidth = '80 Mhz';
                        }
                        if ($scope.vm.node.radio24Ghz) {
                            if ($scope.vm.node.radio24Ghz.bandwidth == 'HT20') {
                                $scope.vm.node.radio24Ghz.bandwidth = '20 Mhz';
                            } else if ($scope.vm.node.radio24Ghz.bandwidth == 'HT40+') {
                                $scope.vm.node.radio24Ghz.bandwidth = '40+ Mhz';
                            } else if ($scope.vm.node.radio24Ghz.bandwidth == 'HT40-') {
                                $scope.vm.node.radio24Ghz.bandwidth = '40- Mhz';
                            }
                        }
                        return response.data;
                    }
                });
        }

        $scope.loadcpu_memory = function (nodeid) {
            $http.get('api/v2/nodelinks/usage?nodeId=' + nodeid, { showdiv: false }).then(function (response) {
                // Check and remove oldest data from Array if it reaches the defined arrayLimit
                var cpuUsage = response.data.cpu;
                var memoryUsage = response.data.memory;

                $scope.cpuBar.set(parseFloat(cpuUsage));

                $scope.memoryBar.set(parseFloat(memoryUsage));
            });
        }

        // To redirect to Node view page
        $scope.showNode = function (nodeId, lastView) {
            $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });

        }

        // To redirect to Node view page
        $scope.showLinks = function () {
            $scope.eventsActive = "active";
            $scope.summaryActive = "";
            $scope.showDiv('linkstat')

        }

        $scope.showLinkDetail = function (remoteIP, macaddress, localMode, remoteMode, lerssi, rerssi, lmcsIdx) {
            $scope.eventsActive = "active";
            $scope.summaryActive = "";
            $rootScope.macaddress = macaddress;
            if (localMode == 'sta') {
                $rootScope.localMode = 'SU';
            } else {
                $rootScope.localMode = 'AP';
            }
            if (remoteMode == 'sta') {
                $rootScope.remoteMode = 'SU';
            } else {
                $rootScope.remoteMode = 'AP';
            }
            var tmpVhtTable = [];
            $rootScope.lerssi = lerssi;
            for (var i = 0; i < $scope.vhtTable.length; i++) {
                if ($scope.vhtTable[i].index == lmcsIdx) {
                    //tmpVhtTable.push($scope.vhtTable[i]);
                    $rootScope.lerssi = lerssi - $scope.vhtTable[i].pwrDiff;
                }
            }

            $rootScope.rerssi = rerssi;
            $rootScope.rip = remoteIP;
            $rootScope.$emit("calllinkdetails", {});
            $scope.showDiv('linkdetail')
        }

        $scope.showLinkDetailNew = function (remoteIP, macaddress, localMode, remoteMode, lerssi, rerssi, lmcsIdx) {
            $scope.eventsActive = "active";
            $scope.summaryActive = "";
            $rootScope.macaddress = macaddress;
            if (localMode == 'sta') {
                $rootScope.localMode = 'SU';
            } else {
                $rootScope.localMode = 'AP';
            }
            if (remoteMode == 'sta') {
                $rootScope.remoteMode = 'SU';
            } else {
                $rootScope.remoteMode = 'AP';
            }
            var tmpVhtTable = [];
            $rootScope.lerssi = lerssi;
            for (var i = 0; i < $scope.vhtTable.length; i++) {
                if ($scope.vhtTable[i].index == lmcsIdx) {
                    //tmpVhtTable.push($scope.vhtTable[i]);
                    $rootScope.lerssi = lerssi - $scope.vhtTable[i].pwrDiff;
                }
            }
            $rootScope.rerssi = rerssi;
            $rootScope.rip = remoteIP;
            $rootScope.$emit("calllinkdetails", {});
            //$scope.showDiv('linkdetail')
        }

        $scope.showLinksNodeHome = function () {
            $state.go('app.nodeView', { "nodeId": $state.params.nodeId, "lastView": 'summary' });
        }
        //        post methods starts hear
        //save conformation
        $scope.saveconfirm = function (ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to update this changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')


            return confirm;
        };

        $scope.saveconfirm = function (ev, msg) {
            var confirm = $mdDialog.confirm()
                .title(msg)
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')


            return confirm;
        };

        function loadAccordian() {
            $("#accordian a").click(function () {
                var link = $(this);
                var closest_ul = link.closest("ul");
                var parallel_active_links = closest_ul.find(".active")
                var closest_li = link.closest("li");
                var link_status = closest_li.hasClass("active");
                var count = 0;

                closest_ul.find("ul").slideUp(function () {
                    if (++count == closest_ul.find("ul").length)
                        parallel_active_links.removeClass("active");
                });

                if (!link_status) {
                    closest_li.children("ul").slideDown();
                    closest_li.addClass("active");
                }
            })
            $('.activeItem').click(function (e) {
                $('.activeItem').css("background-color", "white", "color", "black");
                $(this).css("background-color", "#f6f6f6", "color", "white", "font-weight", "bold");
            });

        }





        // nodeview side toggle menu
        $(document).ready(function () {
            loadAccordian();
            //$scope.initMap();
        })
    }

]);
