﻿dashboard.controller("NodeViewSummaryController", ['$localStorage', '$rootScope', '$scope', '$window', '$mdDialog', '$http', '$q', '$state', 'dashboardService', 'Flash', '$interval', '$timeout',
    function ($localStorage, $rootScope, $scope, $window, $mdDialog, $http, $q, $state, dashboardService, Flash, $interval, $timeout) {
        //$scope.callstore = $localStorage.teststore;
        var vm = this;
        $scope.vm.node = {};
        $scope.nodeLinks = [];
        $scope.nodeViewTimer = null;
        $scope.responseReceived = true;
        $scope.provButtonLabel = "Provision"
        $scope.enableProvButton = 0;
        // $scope.cpuBar = null;
        // $scope.memoryBar = null;
        $scope.remoteIP = ""
        $scope.enableRemote = false;
        $scope.remoteId = null;
        $scope.rerender = "rerender";
        $scope.icmpAvg = 0;
        $scope.vlanMode = null;
        $scope.graphFilterVar = 1;
        $scope.showRemoteDeviceBtn = false;
        var wireless_throughput_ctx = null;
        var wirelessThroughputChart = null;

        var response_time_ctx = null;
        var responseTimeChart = null;

        $scope.tempUnicode = '0x2109';

        $rootScope.graphclickeventnew='';
        //$scope.liveGraphWidth = '100%';
        /*var sytem_cpu_ctx = null;
        var systemCPUChart = null;

        var sytem_memory_ctx = null;
        var systemMemoryChart = null;*/
        $scope.intervalTime = 3000;
        $scope.arrayLimit = 61;

        $scope.changeData = [];

        $scope.channelNumbers = [];

        $scope.rectWidth = 10.7;
        $scope.rectHeight = 30;
        $scope.country = [
            {
                "countryCode": 5011,
                "countryName": "US 5GHz Non-DFS"
            },
            {
                "countryCode": 5012,
                "countryName": "US 5GHz All"
            },
            {
                "countryCode": 5013,
                "countryName": "US 4.9GHz"
            }
        ];
        $scope.ethSpeedArray = [{
            "id": 0,
            "val": "Auto Negotiation"
        }, {
            "id": 4,
            "val": "100Mbps Full"
        }, {
            "id": 5,
            "val": "1000Mbps Full"
        }];

        $scope.encryptionarray = [{
            "encryption": "none",
            "encryptionVal": "None"
        }, {
            "encryption": "psk2+ccmp",
            "encryptionVal": "AES-128"//"WPA2-PSK"
        }];
        $scope.chartReady = false;
        $scope.ipAddressSelected = {
            ipAddress: "",
            macAddress: "",
            nodeId: null
        };
        $scope.liveGraph = [true, true, true, true];
        $scope.graphChartConfig = [null, null, null, null];
        $scope.chartMap = {};
        $scope.intervalTime = 3000; // Chart Interval Time in milliseconds
        $scope.arrayLimit = 61;     // Chart data array limit
        $scope.selectGraph = [{
            "val": "Local SNR",
            "id": "lsnr"
        }, {
            "val": "Remote SNR",
            "id": "rsnr"
        },
        {
            "val": "MCS",
            "id": "mcs"
        },
        {
            "val": "Utilization",
            "id": "util"
        },
        ];


        var link_char1 = null;
        var chatObj1 = null;

        var link_char2 = null;
        var chatObj2 = null;

        var link_char3 = null;
        var chatObj3 = null;

        var link_char4 = null;
        var chatObj4 = null;

        $scope.macaddress = '';

        $scope.localMode = '';

        $scope.remoteMode = '';

        $scope.remoteIPlinks = '';

        $scope.local_snr_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'A1         ',//'A1        ',
                    backgroundColor: 'rgba(24,178,157,1)',
                    borderColor: 'rgba(24,178,157,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'A2        ',
                    backgroundColor: 'rgba(102,51,153,1)',
                    borderColor: 'rgba(102,51,153,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: true, text: "Local SNR", position: 'bottom', padding: 0, lineHeight: 1 },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'top',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: false,
                            labelString: 'Local SNR',
                            position: 'bottom',
                            fontStyle: 'bold'
                        },
                        display: true,
                        ticks: { beginAtZero: true }
                    }],
                },
                elements: {
                    line: { tension: 0 }
                }
            }
        };

        $scope.remote_snr_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'A1       ',
                    backgroundColor: 'rgba(24,178,157,1)',
                    borderColor: 'rgba(24,178,157,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'A2',
                    backgroundColor: 'rgba(102,51,153,1)',
                    borderColor: 'rgba(102,51,153,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: true, text: "Remote SNR", position: 'bottom', padding: 0, lineHeight: 1 },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'top',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: false,
                            labelString: 'Remote SNR',
                            fontStyle: 'bold'
                        },
                        display: true,
                        ticks: { beginAtZero: true }
                    }],
                },
                elements: {
                    line: { tension: 0 }
                }
            }
        };


        $scope.link_mcs_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'local     ',
                    backgroundColor: 'rgba(24,178,157,1)',
                    borderColor: 'rgba(24,178,157,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'remote',
                    backgroundColor: 'rgba(102,51,153,1)',
                    borderColor: 'rgba(102,51,153,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: true, text: "MCS", position: 'bottom', padding: 0, lineHeight: 1 },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'top',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: false,
                            labelString: 'MCS',
                            fontStyle: 'bold'
                        },
                        display: true,
                        ticks: { beginAtZero: true }
                    }],
                },
                elements: {
                    line: { tension: 0 }
                }
            }
        };

        $scope.link_util_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'In       ',
                    backgroundColor: 'rgba(239,201,76,1)',
                    borderColor: 'rgba(239,201,76,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'Out',
                    backgroundColor: 'rgba(226,122,63,1)',
                    borderColor: 'rgba(226,122,63,0.4)',
                    fill: false,
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: true, text: "Utilization", position: 'bottom', padding: 0, lineHeight: 1 },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'top',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: false,
                            labelString: 'Utilization',
                            fontStyle: 'bold'
                        },
                        display: true,
                        ticks: { beginAtZero: true }
                    }],
                },
                elements: {
                    line: { tension: 0 }
                }
            }
        };

        /*function getRandomInt(max) {
            return Math.floor(Math.random() * Math.floor(100));
        }
          var j = 0;
          for (var i = 1; i <= 183; i++) {
                //j = j + 10;
              var specData = {
              "channel": i ,
              "utilization" : getRandomInt(100),
                "position": (i * $scope.rectWidth )

            };
            j++;
            $scope.changeData.push(specData);
          }*/



        $scope.swireless_throughput_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'Transmit Rate (Mb)',
                    backgroundColor: 'rgba(255,120,0,0.4)',
                    borderColor: 'rgba(255,120,0,0.6)',
                    fill: 'origin',
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'Receive Rate (Mb)',
                    backgroundColor: 'rgba(74,179,252,0.5)',
                    borderColor: 'rgba(74,179,252,0.6)',
                    fill: 'origin',
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }, {
                    label: 'Total Rate (Mb)',
                    backgroundColor: 'rgba(195,178,241,0.6)',
                    borderColor: 'rgba(195,178,241,0.6)',
                    fill: 'origin',
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: true },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'bottom',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'Throughput (in Mbps)'
                        },
                        display: true,
                        ticks: { beginAtZero: true }
                    }],
                },
                elements: {
                    line: { tension: 0.5 }
                }
            }
        };

        $scope.icmp_response_config = {
            type: 'line',
            data: {
                labels: [],
                datasets: [{
                    label: 'Latency (in ms)',
                    backgroundColor: 'rgba(84,201,232,1)',
                    borderColor: 'rgba(84,201,232,0.4)',
                    fill: 'origin',
                    pointRadius: 1,
                    pointHitRadius: 5,
                    data: []
                }]
            },
            options: {
                title: { display: true },
                animation: { duration: 0 },
                hover: { animationDuration: 0 },
                responsiveAnimationDuration: 0,
                maintainAspectRatio: false,
                legend: {
                    display: true,
                    position: 'bottom',
                    labels: { boxWidth: 12 }
                },
                showLines: true,
                scales: {
                    xAxes: [{
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                            quarter: 'MMM YYYY'
                        }
                    }],
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'Latency (NMS <--> Radio)'
                        },
                        display: true,
                        ticks: { beginAtZero: true }
                    }],
                },
                elements: {
                    line: { tension: 0 }
                }
            }
        };

        $scope.selectednodetype=localStorage.getItem('selectednodetype');
        if($scope.selectednodetype=='switch') {
            localStorage.setItem("mapload", true);
        } else {
            localStorage.setItem("mapload", false);
        }

        $rootScope.mapload = false;
        // init method calling for get summary data
        $scope.init = function (timerFlag) {
            $('#mydiv').show();
            if ($state.params.nodeId) {
                $localStorage.nodeId = $state.params.nodeId;
            } else {
                $state.params.nodeId = $localStorage.nodeId;
            }
            var metrics = $rootScope.metrics;
            if (!metrics) {
                metrics = $rootScope.buildCode;
            }
            $scope.buildCode = metrics;
            if (metrics == 'US') {
                $scope.tempUnicode = 'F';
            } else {
                $scope.tempUnicode = 'C';
            }
            if ($state.params.nodeId) {
                $scope.getreqItemsProperties();
                $scope.loadNodeByIdOnStart($state.params.nodeId);
                if($scope.selectednodetype=='') {       //call for nodeview page not in switch
                      $scope.loadNodeById($state.params.nodeId);
                      $scope.spectralTimerFunc();
                      $scope.summaryDashTimer();
                }
                $scope.loadDBDataTimer($state.params.nodeId);
                if (!timerFlag) {
                    $scope.load();
                }
            } else {
                $state.params.nodeId = $localStorage.nodeId;
            }
            // $scope.cpuBar = new ldBar("#cpu");
            // var bar2 = angular.element('#cpu').ldBar;
            // $scope.cpuBar.set(0);

            // $scope.memoryBar = new ldBar("#memory");
            // var bar = angular.element('#memory').ldBar;
            // $scope.memoryBar.set(0);
            $scope.isActive = false;
        }

        $scope.toggledisable = false;
        $scope.togglebtn = function (flag) { 
            $scope.toggledisable = true;
            $scope.isActive = !$scope.isActive;
            $scope.graphEvent($scope.graphFilterVar);
        }

        function initConfig() {
            $http.get('api/v2/nodelinks/specstatus?nodeId=' + $state.params.nodeId, { showdiv: false }).then(function (response) {
                var res = response.data;
                $scope.spec_status = res.status;
                /*if ($scope.spec_status == 1) {
                    $scope.spectralTimerFunc();
                }*/
                if ($scope.spec_status == 0) {
                    $scope.stopSpecTimer();
                }
                $q.when($scope.spec_status);

            });
        }

        function destoryNinitLinkGraph(live) {
            destroyNInitLinkSNRGraph(live);
            destroyNInitRemoteSNRraph(live);
            destroyNInitMCSGraph(live);
            destroyNInitUtilGraph(live);
        }

        function destroyNInitLinkSNRGraph(isLive) {
            destroyNInitGraph1(true, $scope.local_snr_config);
            $scope.graphChartConfig[0] = $scope.local_snr_config;
        }

        function destroyNInitRemoteSNRraph(isLive) {
            destroyNInitGraph2(true, $scope.remote_snr_config);
            $scope.graphChartConfig[1] = $scope.remote_snr_config;
        }

        function destroyNInitMCSGraph(isLive) {
            destroyNInitGraph3(true, $scope.link_mcs_config);
            $scope.graphChartConfig[2] = $scope.link_mcs_config;
        }

        function destroyNInitUtilGraph(isLive) {
            destroyNInitGraph4(true, $scope.link_util_config);
            $scope.graphChartConfig[3] = $scope.link_util_config;
        }

        function destroyNInitGraph1(isLive, config) {
            if (chatObj1 != null) {
                chatObj1.destroy();
            }

            if (isLive) {
                config.options.scales.xAxes[0] = {
                    gridLines: {
                        display: false
                    }
                };
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];

            } else {
                var seriesConfig = {
                    gridLines: {
                        display: false
                    },
                    type: 'time',
                    distribution: 'series',
                    displayFormats: {
                        quarter: 'MMM YYYY'
                    }
                }
                config.options.scales.xAxes[0] = seriesConfig;
            }
            //config.options.scales.yAxes[0].scaleLabel.labelString = 'SNR ' + $scope.localMode;
            chatObj1 = new Chart(link_char1, config);
            if (isLive) {
                config.data.labels = [];
                // Initialize the Config null data to display window on start
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                    } else {
                        config.data.labels[i] = "";
                    }
                    if (config.data.datasets.length > 0) {
                        for (var j = 0; j < config.data.datasets.length; j++) {
                            config.data.datasets[j].data[i] = null;
                        }
                    }
                }
            } else {
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];
            }
        }
        function destroyNInitGraph2(isLive, config) {
            if (chatObj2 != null) {
                chatObj2.destroy();
            }

            if (isLive) {
                config.options.scales.xAxes[0] = {
                    gridLines: {
                        display: false
                    }
                };
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];

            } else {
                var seriesConfig = {
                    gridLines: {
                        display: false
                    },
                    type: 'time',
                    distribution: 'series',
                    displayFormats: {
                        quarter: 'MMM YYYY'
                    }
                }
                config.options.scales.xAxes[0] = seriesConfig;
            }
            //config.options.scales.yAxes[0].scaleLabel.labelString = 'RSSI ' + $scope.remoteMode;
            chatObj2 = new Chart(link_char2, config);
            if (isLive) {
                config.data.labels = [];
                // Initialize the Config null data to display window on start
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                    } else {
                        config.data.labels[i] = "";
                    }
                    if (config.data.datasets.length > 0) {
                        for (var j = 0; j < config.data.datasets.length; j++) {
                            config.data.datasets[j].data[i] = null;
                        }
                    }
                }
            } else {
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];
            }
        }
        function destroyNInitGraph3(isLive, config) {
            if (chatObj3 != null) {
                chatObj3.destroy();
            }

            if (isLive) {
                config.options.scales.xAxes[0] = {
                    gridLines: {
                        display: false
                    }
                };
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];

            } else {
                var seriesConfig = {
                    gridLines: {
                        display: false
                    },
                    type: 'time',
                    distribution: 'series',
                    displayFormats: {
                        quarter: 'MMM YYYY'
                    }
                }
                config.options.scales.xAxes[0] = seriesConfig;
            }
            //config.options.scales.yAxes[0].scaleLabel.labelString = 'SNR ' + $scope.localMode;
            chatObj3 = new Chart(link_char3, config);
            if (isLive) {
                config.data.labels = [];
                // Initialize the Config null data to display window on start
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                    } else {
                        config.data.labels[i] = "";
                    }
                    if (config.data.datasets.length > 0) {
                        for (var j = 0; j < config.data.datasets.length; j++) {
                            config.data.datasets[j].data[i] = null;
                        }
                    }
                }
            } else {
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];
            }
        }

        function destroyNInitGraph4(isLive, config) {
            if (chatObj4 != null) {
                chatObj4.destroy();
            }

            if (isLive) {
                config.options.scales.xAxes[0] = {
                    gridLines: {
                        display: false
                    }
                };
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];

            } else {
                var seriesConfig = {
                    gridLines: {
                        display: false
                    },
                    type: 'time',
                    distribution: 'series',
                    displayFormats: {
                        quarter: 'MMM YYYY'
                    }
                }
                config.options.scales.xAxes[0] = seriesConfig;
            }
            //config.options.scales.yAxes[0].scaleLabel.labelString = 'SNR ' + $scope.remoteMode;
            chatObj4 = new Chart(link_char4, config);
            if (isLive) {
                config.data.labels = [];
                // Initialize the Config null data to display window on start
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                    } else {
                        config.data.labels[i] = "";
                    }
                    if (config.data.datasets.length > 0) {
                        for (var j = 0; j < config.data.datasets.length; j++) {
                            config.data.datasets[j].data[i] = null;
                        }
                    }
                }
            } else {
                if (config.data.datasets.length > 0) {
                    for (var i = 0; i < config.data.datasets.length; i++) {
                        config.data.datasets[i].data = []
                    }
                }
                config.data.labels = [];
            }
        }

        //load graph data
        $scope.load = function () {
        console.log("Called load method start");
            var url = 'api/v2/nodelinks/linkstats?nodeId=' + $state.params.nodeId;
            $http.get(url, { showdiv: false })
                .then(function (response) {
                    if (response.data) {
                        $scope.linkStat = response.data.links;
                        // $scope.linkStat = [{ "macAddress": "1c:82:59:b0:00:ae", "ipAddress": "192.168.1.3", "localLinkId": "0", "remoteLinkId": "24", "localCustName": "OR100_Base_22", "remoteCustName": "OR100_SU24", "distance": "1.1648284011692156", "localSignalA1": "-52", "localSignalA2": "-53", "remoteSignalA1": "-52", "remoteSignalA2": "-54", "localSNRA1": "42", "localSNRA2": "41", "remoteSNRA1": "43", "remoteSNRA2": "41", "localDropped": "1", "remoteDropped": "0", "rateRx": "43", "rateTx": "43", "throughputIn": "0.20", "throughputOut": "0.00", "nodeId": 2, "localRTX": null, "remoteRTX": null, "localRadioMode": "ap", "remoteRadioMode": "sta", "channel": null, "lNoise": "-94", "rNoise": "-95", "serialNumber": "19AT60400058", "locEstRSSI": -41, "remEstRSSI": -41, "localMCS": 4, "linkUptime": "04:22:59:32", "latitude": "28.6691", "longitude": "77.0929", "discovered": true },
                        // { "macAddress": "1c:82:59:b0:00:ae", "ipAddress": "192.168.201.173", "localLinkId": "0", "remoteLinkId": "24", "localCustName": "OR100_Base_22", "remoteCustName": "OR100_SU24", "distance": "1.1648284011692156", "localSignalA1": "-52", "localSignalA2": "-53", "remoteSignalA1": "-52", "remoteSignalA2": "-54", "localSNRA1": "42", "localSNRA2": "41", "remoteSNRA1": "43", "remoteSNRA2": "41", "localDropped": "1", "remoteDropped": "0", "rateRx": "43", "rateTx": "43", "throughputIn": "0.20", "throughputOut": "0.00", "nodeId": 2, "localRTX": null, "remoteRTX": null, "localRadioMode": "ap", "remoteRadioMode": "sta", "channel": null, "lNoise": "-94", "rNoise": "-95", "serialNumber": "19AT60400058", "locEstRSSI": -41, "remEstRSSI": -41, "localMCS": 4, "linkUptime": "04:22:59:32", "latitude": "28.640783", "longitude": "77.105324", "discovered": true }
                        // ];
                        if ($scope.linkStat.length > 0) {
                            $scope.ipAddressSelected = {
                                ipAddress: $scope.linkStat[0].ipAddress,
                                macAddress: $scope.linkStat[0].macAddress,
                                nodeId: $scope.linkStat[0].nodeId
                            };
                            if (!$scope.ipAddressSelected.nodeId) {
                                $scope.showRemoteDeviceBtn = true;
                            }
                            console.log("links summary",$scope.linkStat);
                            $rootScope.macaddress = $scope.linkStat[0].macAddress;
                            if ($scope.linkStat[0].localRadioMode == 'sta') {
                                $rootScope.localMode = 'SU';
                            } else {
                                $rootScope.localMode = 'AP';
                            }
                            if ($scope.linkStat[0].remoteRadioMode == 'sta') {
                                $rootScope.remoteMode = 'SU';
                            } else {
                                $rootScope.remoteMode = 'AP';
                            }
                            $rootScope.lerssi = $scope.linkStat[0].locEstRSSI;
                            $rootScope.rerssi = $scope.linkStat[0].remEstRSSI;
                            $rootScope.rip = $scope.linkStat[0].localMCS;
                            $scope.chartReady = true;
                            if ($rootScope.macaddress) {
                                $scope.macaddress = $rootScope.macaddress.replace(/:/g, "");
                                $scope.macaddress = $scope.macaddress.toLowerCase();
                            }
                            $scope.localMode = $rootScope.localMode;
                            $scope.remoteMode = $rootScope.remoteMode;
                            $scope.lerssi = $rootScope.lerssi;
                            $scope.rerssi = $rootScope.rerssi;
                            var nodeid = $state.params.nodeId;
                            $scope.markers = [];
                            $scope.bounds = new google.maps.LatLngBounds();
                             var l = 1;
                            var lo = 1;
                            if ($scope.vm.node.latitude == "-" || $scope.vm.node.latitude == "null" || $scope.vm.node.latitude == undefined) {
                                $scope.vm.node.latitude = null;
                                var lat = 0;
                            } else {
                                if ($scope.vm.node.latitude && ($scope.vm.node.latitude.endsWith('s') || $scope.vm.node.latitude.endsWith('S'))) {
                                    l = l * -1;
                                }
                                var lat = parseFloat($scope.vm.node.latitude);
                                 lat = lat * l;
                            }
                            if ($scope.vm.node.longitude == "-" || $scope.vm.node.longitude == "null" || $scope.vm.node.longitude == undefined) {
                                $scope.vm.node.longitude = null;
                                var lon = 0;
                            } else {
                                if ($scope.vm.node.longitude && ($scope.vm.node.longitude.endsWith('w') || $scope.vm.node.longitude.endsWith('W'))) {
                                    lo = lo * -1;
                                }
                                var lon = parseFloat($scope.vm.node.longitude);
                                lon = lon * lo;
                            }
                            var startPoint = new google.maps.LatLng(lat, lon);
                            //var cNode = new google.maps.LatLng(parseFloat(nodeObj.latitude), parseFloat(nodeObj.longitude));
                            $scope.bounds.extend(startPoint);
                            for (var i = 0; i < $scope.linkStat.length; i++) {
                                if ($scope.linkStat[i].latitude == "null"||$scope.linkStat[i].latitude == null) {
                                    $scope.linkStat[i].latitude = 0;
                                }
                                if ($scope.linkStat[i].longitude == "null"||$scope.linkStat[i].longitude == null) {
                                    $scope.linkStat[i].longitude = 0;
                                }
                                if($scope.linkStat[i].latitude!=0||$scope.linkStat[i].longitude!=0){
                                    $scope.showlinksonmap($scope.linkStat[i], startPoint);
                                }
                            }
                            debugger
                            if(lat!=0 && lon!=0){
                                $scope.mapsummary.fitBounds($scope.bounds);
                            }
                            debugger
                            console.log("node id" + nodeid);
                            console.log("macaddress" + $scope.macaddress);
                        }else{
                              $scope.showRemoteDeviceBtn = true;
                        }
                        $scope.graph1Model = $scope.selectGraph[0];
                        $scope.graph2Model = $scope.selectGraph[1];
                        $scope.graph3Model = $scope.selectGraph[2];
                        $scope.graph4Model = $scope.selectGraph[3];
                        //$scope.selectedGraph = ['lrssi','rrssi','lsnr','mcs'];
                        $scope.chartMap['lsnr'] = 'lsnra1,lsnra2';
                        $scope.chartMap['rsnr'] = 'rsnra1,rsnra2';
                        $scope.chartMap['mcs'] = 'lmcs,rmcs';
                        $scope.chartMap['util'] = 'in,out';
                        $scope.remoteIPlinks = $rootScope.rip;
                        if($scope.selectednodetype=='') {
                            link_char1 = document.getElementById("link_char11").getContext("2d");
                            link_char2 = document.getElementById("link_char12").getContext("2d");
                            link_char3 = document.getElementById("link_char13").getContext("2d");
                            link_char4 = document.getElementById("link_char14").getContext("2d");
                            destoryNinitLinkGraph(true);
                            //$scope.liveLinkData();
                            liveLinkDataTimer($scope.ipAddressSelected.macAddress, $scope.ipAddressSelected.nodeId);
                        }
                    }
                    localStorage.setItem("mapload", true);
                    $rootScope.mapload = true;
                    $('#mydiv').hide();
                },function (error){
                   localStorage.setItem("mapload", true);
                   $rootScope.mapload = true;
                   $('#mydiv').hide();
                   console.log("load method error");
                 });
        }
        var vPaths = [];
        $scope.markerHashMap = new Map();
        $scope.showlinksonmap = function (nodeObj, startPoint) {
             var l = 1;
            var lo = 1;
            if (nodeObj.latitude) {
                if (nodeObj.latitude.endsWith('s') || nodeObj.latitude.endsWith('S')) {
                    l = l * -1;
                }
                var lat = parseFloat(nodeObj.latitude);
                lat = lat * l;
            } else {
                //$scope.vm.node.latitude = null;
                var lat = null;
            }
            if (nodeObj.longitude) {
                if (nodeObj.longitude.endsWith('w') || nodeObj.longitude.endsWith('W')) {
                    lo = lo * -1;
                }
                var lon = parseFloat(nodeObj.longitude);
                lon = lon * lo;
            } else {
                //$scope.vm.node.longitude = null
                var lon = null;
            }
            var myLatlng = new google.maps.LatLng(lat, lon);
            if (nodeObj.remoteRadioMode == 'ap') {
                var mode = 'ap';
            } else {
                var mode = 'sta'
            }
            var iconURL = getIcon(mode, $scope.vm.node.nodeStatus);

            var marker = new google.maps.Marker({
                map: $scope.mapsummary,
                position: myLatlng,
                icon: iconURL,
                title:nodeObj.ipAddress
            });
            vPaths.push([startPoint, myLatlng]);
            var polyline = new google.maps.Polygon({
                paths: vPaths,
                icon: iconURL,
                strokeWeight: 2,
                strokeOpacity: 1
            });
            polyline.setMap($scope.mapsummary);
            $scope.bounds.extend(marker.position);
        }

//        var apUpIcon = "images/ap_nms_icon.png";
//        var apDownIcon = "images/ap_nms_icon_disable.png";
//
//        var su4UpURL = "images/su4_nms_icon.png";
//        var su4DownURL = "images/su4_nms_icon_disable.png";
        var su4UpURL = "images/ap_nms_icon.png";
        var su4DownURL = "images/ap_nms_icon_disable.png";

        var apUpIcon = "images/su4_nms_icon.png";
        var apDownIcon = "images/su4_nms_icon_disable.png";
        function getIcon(type, status) {
            if (type == 'ap'||type=='Outdoor Base') {
                if (status) {
                    return apUpIcon;
                } else {
                    return apDownIcon;
                }
            } else {
                if (status) {
                    return su4UpURL;
                } else {
                    return su4DownURL;
                }
            }
        }

        function liveLinkDataTimer(macAddress, nodeId) {
            $scope.liveLinkTimer = $interval(function () { $scope.liveLinkData(macAddress, nodeId) }, $scope.intervalTime);
        }

        $scope.stopLinkDataTimer = function () {
            if (angular.isDefined($scope.liveLinkTimer)) {
                $interval.cancel($scope.liveLinkTimer);
            }
        }

        $scope.changeChartsData = function (obj) {
            // if (!$scope.liveGraph[0]) {
            //     return;
            // }
            if (obj.macAddress) {
                $scope.macaddress = obj.macAddress.replace(/:/g, "");
                $scope.macaddress = obj.macAddress.toLowerCase();
                $scope.nodeId = obj.nodeId;
                if (!$scope.nodeId) {
                    $scope.showRemoteDeviceBtn = true;
                }
                $scope.stopLinkDataTimer();
                destoryNinitLinkGraph(true);
                liveLinkDataTimer($scope.macaddress, $scope.nodeId);
                // $http.get('api/v2/nodelinks/linkdet/' + $state.params.nodeId + '?mac=' + $scope.macaddress, { showdiv: false }).then(function (response) {
                //     var linkData = response.data.links;
                //     if (linkData.length > 0) {
                //         if ($scope.liveGraph[0]) {
                //             $scope.spliceData($scope.graphChartConfig[0]);
                //             $scope.pushLiveData(linkData);
                //         }
                //         if ($scope.liveGraph[1]) {
                //             $scope.spliceData($scope.graphChartConfig[1]);
                //             $scope.pushLiveData(linkData);
                //         }
                //         if ($scope.liveGraph[2]) {
                //             $scope.spliceData($scope.graphChartConfig[2]);
                //             $scope.pushLiveData(linkData);
                //         }
                //         if ($scope.liveGraph[3]) {
                //             $scope.spliceData($scope.graphChartConfig[3]);
                //             $scope.pushLiveData(linkData);
                //         }

                //         chatObj1.update();
                //         chatObj2.update();
                //         chatObj3.update();
                //         chatObj4.update();
                //     }


                // });
            }
        }

        //get remote data
        $scope.getRemoteData = function (ipAddressSelected) {
            console.log("remote device", ipAddressSelected);
            $scope.ipAddressSelected = {
                ipAddress: ipAddressSelected.ipAddress,
                macAddress: ipAddressSelected.macAddress,
                nodeId: ipAddressSelected.nodeId
            };
            var data = {
                id: ipAddressSelected.nodeId,
                systemname: ipAddressSelected.nodeId
            }
            var obj = {
                text: ipAddressSelected.ipAddress,
                data: data
            };
            $rootScope.$emit("Calltabname", { tabobj: obj });
            if ($scope.ipAddressSelected.nodeId) {
                $scope.SelectednodeId = $scope.ipAddressSelected.nodeId;
                console.log($scope.SelectednodeId);
                if ($scope.SelectednodeId) {
                    $state.params.nodeId = $scope.SelectednodeId;
                    $localStorage.nodeId = $state.params.nodeId;
                    //$scope.$destroy();
                    // $scope.stopTimer();
                    // $scope.init();
                    // initGraph();
                    // $rootScope.$emit("CallNodeByIdOnStart",{nodeId : $scope.SelectednodeId});
                    var checkRoute = window.location.hash.includes("topology");
                    if (checkRoute) {
                        $scope.stopTimer();
                        $scope.init();
                        initGraph();
                        var ele = document.getElementsByClassName("btn-secondary");
                        if (ele != null) {
                            for (var i = 0; i < ele.length; i++) {
                                if (ele[i].className.includes("active")) {
                                    ele[i].classList.remove("active");
                                    break;
                                }
                            }
                            ele[0].classList.add("active");
                        }
                        $rootScope.$emit("Callinit", { nodeId: $scope.SelectednodeId });
                    } else {
                        $window.location.reload(true);
                    }

                }
            }
        }

        // $rootScope.$on("CallinitGraph", function(){
        //     initGraph();
        // })

        //load chart data
        $scope.liveLinkData = function (macAddress, nodeId) {
            if (!$scope.liveGraph[0]) {
                return;
            }
            macAddress = macAddress.replace(/:/g, "");
            macAddress = macAddress.toLowerCase();
            $http.get('api/v2/nodelinks/linkdet/' + $state.params.nodeId + '?mac=' + macAddress, { showdiv: false }).then(function (response) {
                var linkData = response.data.links;
                if (linkData.length > 0) {
                    if ($scope.liveGraph[0]) {
                        $scope.spliceData($scope.graphChartConfig[0]);
                        $scope.pushLiveData(linkData);
                    }
                    if ($scope.liveGraph[1]) {
                        $scope.spliceData($scope.graphChartConfig[1]);
                        $scope.pushLiveData(linkData);
                    }
                    if ($scope.liveGraph[2]) {
                        $scope.spliceData($scope.graphChartConfig[2]);
                        $scope.pushLiveData(linkData);
                    }
                    if ($scope.liveGraph[3]) {
                        $scope.spliceData($scope.graphChartConfig[3]);
                        $scope.pushLiveData(linkData);
                    }

                    chatObj1.update();
                    chatObj2.update();
                    chatObj3.update();
                    chatObj4.update();
                }


            });

        }

        $scope.spliceData = function (config) {
            for (var i = 0; i < config.data.datasets.length; i++) {
                if (config.data.datasets[i].data.length >= $scope.arrayLimit) {
                    config.data.datasets[i].data.splice(0, 1);
                }
            }
        }

        $scope.pushLiveData = function (linkData) {
            $scope.pushLocalSNRLive(linkData);
            $scope.pushRemoteSNRLive(linkData);
            $scope.pushMCSLive(linkData);
            $scope.pushUtilLive(linkData);
        }

        $scope.pushLocalSNRLive = function (linkData) {
            $scope.local_snr_config.data.datasets[0].data.push(linkData[0].localSNRA1);
            $scope.local_snr_config.data.datasets[1].data.push(linkData[0].localSNRA2);
        }

        $scope.pushRemoteSNRLive = function (linkData) {
            $scope.remote_snr_config.data.datasets[0].data.push(linkData[0].remoteSNRA1);
            $scope.remote_snr_config.data.datasets[1].data.push(linkData[0].remoteSNRA2);
        }
        $scope.pushMCSLive = function (linkData) {
            $scope.link_mcs_config.data.datasets[0].data.push(linkData[0].rateTx);
            $scope.link_mcs_config.data.datasets[1].data.push(linkData[0].rateRx);

        }

        $scope.pushUtilLive = function (linkData) {
            $scope.link_util_config.data.datasets[0].data.push(linkData[0].throughputIn);
            $scope.link_util_config.data.datasets[1].data.push(linkData[0].throughputOut);
        }

        //get country name and security
        $scope.getreqItemsProperties = function () {
            $scope.prop5ghzCountry = "";
            $scope.prop24ghzCountry = "";
            $scope.sec5ghz = "";
            $scope.sec24ghz = "";
            $scope.ethSpeed = "";

            var url = 'api/v2/nodewirelessview/propertiesf?nodeId=' + $state.params.nodeId;
            $http.get(url).then(function (response) {
                if (response.data) {
                    $scope.properties5Data = response.data;
                    for (var i = 0; i < $scope.country.length; i++) {
                        if ($scope.properties5Data.country == $scope.country[i].countryCode) {
                            $scope.prop5ghzCountry = $scope.country[i].countryName;
                            break;
                        }
                    }
                }
            });

            var url = 'api/v2/nodewirelessview/propertiest?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {

                    if (response.data) {
                        $scope.properties24Data = response.data;

                        if ($scope.properties24Data.country == "643") {
                            if ($rootScope.buildCode && $rootScope.buildCode == "US") {
                                $scope.prop24ghzCountry = "US"
                            } else {
                                $scope.prop24ghzCountry = "India"
                            }

                        }
                    }
                });


            var url = 'api/v2/nodewirelessview/securityf?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {

                    if (response.data) {

                        $scope.securityData5ghz = response.data;
                        $scope.securityData5ghz.encpt = {
                            encryption: $scope.securityData5ghz.encryption
                        }
                        for (var i = 0; i < $scope.encryptionarray.length; i++) {
                            if ($scope.securityData5ghz.encryption == $scope.encryptionarray[i].encryption) {
                                //$scope.sec5ghz = $scope.encryptionarray[i].encryptionVal;
                                if ($scope.securityData5ghz.encryption == 'psk2+ccmp') {
                                    $scope.sec5ghz = 'AES-256';
                                }
                                break;
                            }
                        }
                    }
                });

            var url = 'api/v2/nodewirelessview/security?nodeId=' + $state.params.nodeId;
            $http.get(url)
                .then(function (response) {

                    if (response.data) {
                        $scope.securityData24ghz = response.data;
                        $scope.securityData24ghz.encpt = {
                            encryption: $scope.securityData24ghz.encryption
                        }
                        for (var i = 0; i < $scope.encryptionarray.length; i++) {
                            if ($scope.securityData24ghz.encryption == $scope.encryptionarray[i].encryption) {
                                $scope.sec24ghz = $scope.encryptionarray[i].encryptionVal;
                                if ($scope.sec24ghz == 'psk2+ccmp') {
                                    $scope.sec24ghz = 'AES-128';
                                }
                                break;
                            }
                        }
                    }
                });

            // var url = 'api/v2/nodenetview/ethconfig?nodeId=' + $state.params.nodeId;
            // $http.get(url)
            //     .then(function (response) {
            //         if (response.data) {
            //             for (var i = 0; i < $scope.ethSpeedArray.length; i++) {
            //                 if (response.data.ethMode == $scope.ethSpeedArray[i].id) {
            //                     $scope.ethSpeed = $scope.ethSpeedArray[i].Val;
            //                     break;
            //                 }
            //             }
            //         }
            //     });
        }

        $scope.spectralTimerFunc = function () {
            $scope.spectralTimer = $interval(function () {
                initConfig();
                $scope.loadSpectrumResults()
            }, 6000);
        }

        $scope.stopSpecTimer = function () {
            if (angular.isDefined($scope.spectralTimer)) {
                $interval.cancel($scope.spectralTimer);
            }
        }

        $scope.loadSpectrumResults = function () {
            $scope.changeData = [];
            $scope.channelNumbers = [];
            $http.get('api/v2/nodelinks/spectrum?nodeId=' + $state.params.nodeId, { showdiv: false }).then(function (response) {
                // Check and remove oldest data from Array if it reaches the defined arrayLimit
                console.log(response.data);
                var len = response.data.length - 1;
                for (var i = 0; i < response.data.length; i++) {
                    var spec = response.data[i];
                    var style = 'rgb(255,0,0)';
                    if (spec.utilization < 5) {
                        style = 'rgb(0,255,0)';
                    } else if (spec.utilization < 10) {
                        style = 'rgb(255,255,0)';
                    } else if (spec.utilization < 15) {
                        style = 'rgb(255,165,0)';
                    }
                    var a1style = 'rgb(0,255,0)';
                    if (spec.signalA1 < 0 && spec.signalA1 > -40) {
                        a1style = 'rgb(255,0,0)';
                    } else if (spec.signalA1 < -40 && spec.signalA1 > -60) {
                        a1style = 'rgb(255,165,0)';
                    } else if (spec.signalA1 > -80 && spec.signalA1 < -60) {
                        a1style = 'rgb(255,255,0)';
                    }

                    var a2style = 'rgb(0,255,0)';
                    if (spec.signalA2 < 0 && spec.signalA2 > -40) {
                        a2style = 'rgb(255,0,0)';
                    } else if (spec.signalA2 < -40 && spec.signalA2 > -60) {
                        a2style = 'rgb(255,165,0)';
                    } else if (spec.signalA2 > -80 && spec.signalA2 < -60) {
                        a2style = 'rgb(255,255,0)';
                    }

                    var specData = {
                        "channel": spec.channel,
                        "a1": spec.signalA1,
                        "a2": spec.signalA2,
                        "utilization": spec.utilization,
                        "fill": style,
                        "filla1": a1style,
                        "filla2": a2style,
                        "position": (i * $scope.rectWidth) + 31.635513

                    };

                    $scope.changeData.push(specData);


                    var c = spec.channel;

                    if (i != 0) {
                        if (spec.channel % 5 != 0)
                            c = '';

                    }

                    var channel = {
                        "channel": c,
                        "position": (i * $scope.rectWidth) + 31.635513

                    };
                    $scope.channelNumbers.push(channel);

                }

            });

        }

        function getRandomInt(max) {
            return Math.floor(Math.random() * Math.floor(100));
        }

        function initOtherGraphs() {
            wireless_throughput_ctx = document.getElementById("summary_throughput_chart").getContext("2d");
            response_time_ctx = document.getElementById("summary_response_chart").getContext("2d");
        }

        function initGraph() {
            initOtherGraphs();
            destoryNinitGraph(true);
            destoryNinitResponseGraph(true);
        }

        function destoryNinitGraph(live) {
            $scope.toggledisable = true;
            if (wirelessThroughputChart != null) {
                wirelessThroughputChart.destroy();
            }
            if (live) {
                $scope.swireless_throughput_config.options.scales.xAxes[0] = {};
            } else {
                var seriesConfig = {
                    ticks: {
                        fontSize: 8
                    },
                    type: 'time',
                    distribution: 'series',
                    displayFormats: {
                        quarter: 'MMM YYYY'
                    }
                };
                $scope.swireless_throughput_config.options.scales.xAxes[0] = seriesConfig;
            }
            wirelessThroughputChart = new Chart(wireless_throughput_ctx, $scope.swireless_throughput_config);
            if (live) {
                // Initialize the Config null data to display window on start
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        $scope.swireless_throughput_config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                        // $scope.icmp_response_config.data.labels[i] = ((($scope.arrayLimit-1)-i) * ($scope.intervalTime/1000))/60 + 'm';
                    } else {
                        $scope.swireless_throughput_config.data.labels[i] = "";
                        //$scope.icmp_response_config.data.labels[i] = "";
                    }
                    $scope.swireless_throughput_config.data.datasets[0].data[i] = null;
                    $scope.swireless_throughput_config.data.datasets[1].data[i] = null;
                    $scope.swireless_throughput_config.data.datasets[2].data[i] = null;
                }
            } else {

                $scope.swireless_throughput_config.data.datasets[0].data = [];
                $scope.swireless_throughput_config.data.datasets[1].data = [];
                $scope.swireless_throughput_config.data.datasets[2].data = [];
                $scope.swireless_throughput_config.data.labels = [];
            }
         
                $scope.toggledisable = false;
                  
        }

        function destoryNinitResponseGraph(live) {
            $scope.toggledisable = true;
            if (responseTimeChart != null) {
                responseTimeChart.destroy();
            }
            if (live) {
                $scope.icmp_response_config.options.scales.xAxes[0] = {};
            } else {
                var seriesConfigic = {
                    ticks: {
                        fontSize: 8
                    },
                    type: 'time',
                    distribution: 'series',
                    displayFormats: {
                        quarter: 'MMM YYYY'
                    }
                }
                $scope.icmp_response_config.options.scales.xAxes[0] = seriesConfigic;
            }
            responseTimeChart = new Chart(response_time_ctx, $scope.icmp_response_config)
            if (live) {
                // Initialize the Config null data to display window on start
                for (i = 0; i < $scope.arrayLimit; i++) {
                    if (i % 20 == 0) {
                        $scope.icmp_response_config.data.labels[i] = ((($scope.arrayLimit - 1) - i) * ($scope.intervalTime / 1000)) / 60 + 'm';
                    } else {
                        $scope.icmp_response_config.data.labels[i] = "";

                    }
                    $scope.icmp_response_config.data.datasets[0].data[i] = null;
                }
            } else {

                $scope.icmp_response_config.data.datasets[0].data = [];
                $scope.icmp_response_config.data.labels = [];
            }
          
                $scope.toggledisable = false;
        }

        $scope.addWirelessData = function () {
            if (wirelessThroughputChart != null) {
                $scope.toggledisable = true;
                $http.get('rest/measurements/node%5B' + $state.params.nodeId + '%5D.nodeSnmp%5B%5D?aggregation=AVERAGE&duration=' + $scope.duration, { showdiv: false }).then(function (response) {
                    var timeStamps = response.data.timestamps
                    var rxthroughput = response.data.columns[0].values;
                    var txThroughtput = response.data.columns[1].values;
                    var prxThroughput = 0;
                    var ptxThroughput = 0;
                    var crxThroughput = 0;
                    var ctxThroughput = 0;
                    for (var i = 0; i < timeStamps.length - 1; i++) {

                        if (rxthroughput[i] == 'NaN') {
                            rxthroughput[i] = 0;
                        }
                        if (txThroughtput[i] == 'NaN') {
                            txThroughtput[i] = 0;
                        }
                        var d = new Date(timeStamps[i]);
                        
                        //$scope.wireless_throughput_config.data.labels[i] = moment(timeStamps[i]);
                        $scope.swireless_throughput_config.data.labels[i] = moment(d.toISOString());
                        $scope.swireless_throughput_config.data.datasets[0].data.push(parseFloat(txThroughtput[i]).toFixed(2));
                        $scope.swireless_throughput_config.data.datasets[1].data.push(parseFloat(rxthroughput[i]).toFixed(2));
                        $scope.swireless_throughput_config.data.datasets[2].data.push(parseFloat(rxthroughput[i] + txThroughtput[i]).toFixed(2));
                    }
                    setTimeout(() => {
                        wirelessThroughputChart.update();
                        }, 500)                 
                    $scope.toggledisable = false;
                });
            }
        }
        $scope.addResponseData = function () {
            if (responseTimeChart != null) {
                $scope.toggledisable = true;
                var avg = 0;
                $http.get('rest/measurements/icmp/node%5B' + $state.params.nodeId + '%5D.responseTime%5B' + $rootScope.ipAddress + '%5D?aggregation=AVERAGE&relaxed=true&duration=' + $scope.duration, { showdiv: false }).then(function (response) {
                    var timeStamps = response.data.timestamps
                    var rxthroughput = response.data.columns[0].values;
                    var length = rxthroughput.length;
                    for (var i = 0; i < timeStamps.length - 1; i++) {
                        if (rxthroughput[i] == 'NaN') {
                            rxthroughput[i] = 0;
                        }

                        var d = new Date(timeStamps[i]);

                        //$scope.wireless_throughput_config.data.labels[i] = moment(timeStamps[i]);
                        $scope.icmp_response_config.data.labels[i] = moment(d.toISOString());
                        avg += Number(rxthroughput[i]);
                        $scope.icmp_response_config.data.datasets[0].data.push(parseFloat(rxthroughput[i]).toFixed(3));
                    }
                    if (length != 0) {
                        $scope.icmpAvg = parseFloat(avg / length).toFixed(3);
                    }
                    setTimeout(() => {
                        responseTimeChart.update();
                        }, 500);                    
                    $scope.toggledisable = false;
                });
            }
        }

        $scope.liveWirelessData = function () {
            if ($scope.isActive == false) {
                $http.get('api/v2/nodelinks/wirelessstats?nodeId=' + $state.params.nodeId, { showdiv: false }).then(function (response) {
                    // Check and remove oldest data from Array if it reaches the defined arrayLimit
                    if ($scope.swireless_throughput_config.data.datasets[0].data.length >= $scope.arrayLimit) {
                        $scope.swireless_throughput_config.data.datasets[0].data.splice(0, 1);
                        $scope.swireless_throughput_config.data.datasets[1].data.splice(0, 1);
                        $scope.swireless_throughput_config.data.datasets[2].data.splice(0, 1);
                    }


                    $scope.swireless_throughput_config.data.datasets[0].data.push(parseFloat(response.data.txThroughput).toFixed(2));
                    $scope.swireless_throughput_config.data.datasets[1].data.push(parseFloat(response.data.rxThroughtput).toFixed(2));
                    var value = parseFloat(response.data.txThroughput) + parseFloat(response.data.rxThroughtput);
                    value = value.toFixed(2);
                    $scope.swireless_throughput_config.data.datasets[2].data.push(value);

                    // Update the charts
                    if (wirelessThroughputChart != null) {
                        wirelessThroughputChart.update();
                    }
                });

                // $http.get('api/v2/nodelinks/usage?nodeId=' + $state.params.nodeId, { showdiv: false }).then(function (response) {
                //     // Check and remove oldest data from Array if it reaches the defined arrayLimit
                //     var cpuUsage = response.data.cpu;
                //     var memoryUsage = response.data.memory;

                //     $scope.cpuBar.set(parseFloat(cpuUsage));

                //     $scope.memoryBar.set(parseFloat(memoryUsage));


                //     var metrics = $rootScope.metrics;

                //     if (!metrics) {
                //         metrics = $rootScope.buildCode;
                //     }
                //     $scope.buildCode = metrics;
                //     $scope.vm.node.systemConfig.temperature = 35;
                //     if ($scope.vm.node && $scope.vm.node.systemConfig) {
                //         $scope.vm.node.systemConfig.temperature = response.data.temp;
                //         if (metrics == 'US') {
                //             $scope.vm.node.systemConfig.temperature = ($scope.vm.node.systemConfig.temperature * 1.8) + 32;
                //         }
                //     }


                // });
            }
        }

        $scope.liveICMPData = function () {
            if ($scope.isActive == true) {
                $http.get('api/v2/nodelinks/ping?nodeId=' + $state.params.nodeId, { showdiv: false }).then(function (response) {
                    // Check and remove oldest data from Array if it reaches the defined arrayLimit
                    if ($scope.icmp_response_config.data.datasets[0].data.length >= $scope.arrayLimit) {
                        $scope.icmp_response_config.data.datasets[0].data.splice(0, 1);
                    }

                    $scope.icmp_response_config.data.datasets[0].data.push(parseFloat(response.data.rtt).toFixed(3));
                    var avg = 0;
                    var count = 0;
                    for (var i = 0; i < $scope.icmp_response_config.data.datasets[0].data.length; i++) {
                        if ($scope.icmp_response_config.data.datasets[0].data[i] != null) {
                            avg = avg + parseFloat($scope.icmp_response_config.data.datasets[0].data[i]);
                            count++;
                        }

                    }
                    if ($scope.icmp_response_config.data.datasets[0].data.length != 0) {
                        $scope.icmpAvg = parseFloat(avg / count).toFixed(3);
                    }

                    // Update the charts
                    if (responseTimeChart != null) {
                        responseTimeChart.update();
                    }
                });
            }
        }

        $scope.$on('$destroy', function () {
            $scope.stopTimer();
        });

        $scope.stopTimer = function () {
            $scope.stopThroughputTimer();
            //$scope.stopThroughputTimerOnly();
            $scope.stopDBTimer();
            $scope.stopSpecTimer();
            $scope.stopLinkDataTimer();
        }


        $scope.loadDBDataTimer = function (nodeId) {
            $scope.summaryTimer = $interval(function () {
                $scope.loadNodeById(nodeId)
            }, 60000);
        }


        $scope.summaryDashTimer = function () {
            $scope.throughputtimer = $interval(function () {
                $scope.liveWirelessData();
                $scope.liveICMPData();
            }, 3000);
        }

        $scope.stopThroughputTimer = function () {
            if (angular.isDefined($scope.throughputtimer)) {
                $interval.cancel($scope.throughputtimer);
            if(wirelessThroughputChart!=null)
               {
                	wirelessThroughputChart.destroy();
                }
                wirelessThroughputChart = null;
                if(responseTimeChart!=null){
                	responseTimeChart.destroy();
                }
                responseTimeChart = null;

            }
        }

        $scope.stopThroughputTimerOnly = function () {
            if (angular.isDefined($scope.throughputtimer)) {
                $interval.cancel($scope.throughputtimer);
            }
        }

        $scope.stopThroughputTimerOnCondition = function () {
            if (angular.isDefined($scope.throughputtimer)) {
                $interval.cancel($scope.throughputtimer);
                if ($scope.isActive == false) {
                    wirelessThroughputChart.destroy();
                    wirelessThroughputChart = null;
                } else {
                    responseTimeChart.destroy();
                    responseTimeChart = null;
                }
            }
        }

        $scope.stopDBTimer = function () {
            if (angular.isDefined($scope.summaryTimer)) {
                $interval.cancel($scope.summaryTimer);
                /*wirelessThroughputChart.destroy();
                wirelessThroughputChart = null;*/
            }
        }

        $scope.enableProvButton = function () {
            if ($scope.enableProvButton == 0) {
                return true;
            } else {
                return false;
            }
        }

        $scope.graphEvent = function (event) {
            destoryNinitGraph();
            destoryNinitResponseGraph();
            console.log($rootScope.ipAddress)
            if (event == 2) {
                $scope.graphFilterVar = 2;
                $scope.duration = "1h";
                $scope.stopThroughputTimerOnCondition();
                if ($scope.isActive == false) {
                    destoryNinitGraph(false);
                    $scope.addWirelessData();
                } else {
                    destoryNinitResponseGraph(false);
                    $scope.addResponseData();
                }
            } else if (event == 3) {
                $scope.graphFilterVar = 3;
                $scope.duration = "1d";
                $scope.stopThroughputTimerOnCondition();
                if ($scope.isActive == false) {
                    destoryNinitGraph(false);
                    $scope.addWirelessData();
                } else {
                    destoryNinitResponseGraph(false);
                    $scope.addResponseData();
                }
            } else if (event == 4) {
                $scope.graphFilterVar = 4;
                $scope.duration = "1m";
                $scope.stopThroughputTimerOnCondition();
                if ($scope.isActive == false) {
                    destoryNinitGraph(false);
                    $scope.addWirelessData();
                } else {
                    destoryNinitResponseGraph(false);
                    $scope.addResponseData();
                }
            } else if (event == 5) {
                $scope.graphFilterVar = 5;
                $scope.duration = "1w";
                $scope.stopThroughputTimerOnCondition();
                if ($scope.isActive == false) {
                    destoryNinitGraph(false);
                    $scope.addWirelessData();
                } else {
                    destoryNinitResponseGraph(false);
                    $scope.addResponseData();
                }
            } else {
                $scope.graphFilterVar = 1;
                $scope.stopThroughputTimerOnCondition();
                destoryNinitGraph(true);
                destoryNinitResponseGraph(true);
                $scope.duration = "1h";
                $scope.summaryDashTimer();
            }
            //elemWidth.style.width = null;
            //console.log('selecte ' + $scope.duration);
        }
        function ellipsemodel(str, count, displaycount) {
            // If string length is longer than 10
            if(str){
                if (str.length > count) {
                    return str.substr(0, displaycount) + ' ... ';// + str.substr(str.length - 5, str.length);
                }
            }
            return str;
        }
        //summary data
        $scope.loadNodeById = function (nodeId) {
            var url = 'api/v2/nodemanageview/summary?nodeId=' + nodeId;
            return $http.get(url, { showdiv: false })
                .then(function (response) {
                    if (response.data) {
                        $scope.vm.node = response.data;
                        if($scope.vm.node.latitude){
                            $rootScope.nodelatitude=$scope.vm.node.latitude;
                        }
                        if($scope.vm.node.longitude){
                            $rootScope.nodelongitude=$scope.vm.node.longitude;
                        }
                        if ($scope.vm.node.remotePartners2 == null) {
                            $scope.vm.node.remotePartners2 = 0;
                        }
                        console.log("$scope.vm.node summary", $scope.vm.node);
                        if ($scope.vm.node.systemConfig) {
                            if (response.data.systemConfig.sysTime) {
                                var splitUpTime = response.data.systemConfig.sysTime.split(":");
                                splitUpTime[0] = splitUpTime[0] + "d";
                                splitUpTime[1] = splitUpTime[1] + "h";
                                splitUpTime[2] = splitUpTime[2] + "m";
                                splitUpTime[3] = splitUpTime[3] + "s";
                                $scope.vm.node.systemConfig.sysTime = splitUpTime.join(" ");
                                $scope.vm.node.systemConfig.custName = response.data.systemConfig.custName;
                            }
                        }
                        if ($scope.vm.node.systemConfig) {
                            $scope.vm.node.systemConfig.custNameEllipse = ellipsemodel(response.data.systemConfig.custName, 10, 8);
                        }
                        if ($scope.vm.node.ipConfig) {
                            $scope.vm.node.ipConfig.ipAddressEllipse = ellipsemodel(response.data.ipConfig.ipAddress, 15, 8);
                        }
                        if (response.data.vlan.vlanMode == 3) {
                            $scope.vlanMode = 'Q-in-Q';
                        } else if (response.data.vlan.vlanMode == 2) {
                            $scope.vlanMode = 'Trunk';
                        } else if (response.data.vlan.vlanMode == 0) {
                            $scope.vlanMode = 'Transparent';
                        } else if (response.data.vlan.vlanMode == 1) {
                            $scope.vlanMode = 'Access';
                        }

                        if ($scope.vm.node.systemConfig) {
                            $scope.vm.node.systemConfig.firmwareVersion = response.data.systemConfig.firmwareVersion
                        }

                        var metrics = $rootScope.metrics;

                        if (!metrics) {
                            metrics = $rootScope.buildCode;
                        }
                        $scope.buildCode = metrics;
                        if (metrics == 'US') {
                            $scope.vm.node.systemConfig.temperature = ($scope.vm.node.systemConfig.temperature * 1.8) + 32;
                        }

                        //firmwareVersion
                        if ($scope.vm.node.provisioned) {
                            $scope.provButtonLabel = "UnProvision"
                            $scope.enableProvButton = 1;
                        } else {
                            $scope.provButtonLabel = "Provision"
                            $scope.enableProvButton = 2;
                        }

                        if ($scope.vm.node.remoteId != null) {
                            $scope.remoteIP = response.data.remoteIP;
                            $scope.enableRemote = true;
                            $scope.remoteId = response.data.remoteId;
                        }
                        $rootScope.ipAddress = response.data.ipConfig.ipAddress;
                        if ($scope.vm.node.radio5Ghz) {
                            if (response.data.radio5Ghz.radioMode == 'sta') {
                                $scope.vm.node.radio5Ghz.radioMode = 'Outdoor Subscriber'
                                //this rootscope is used for under network tab screens
                                $rootScope.radioMode = 2;
                            } else {
                                $scope.vm.node.radio5Ghz.radioMode = 'Outdoor Base'
                                $rootScope.radioMode = 1;
                            }
                            $rootScope.linkType = $scope.vm.node.radio5Ghz.linkType;
                            if ($scope.vm.node.radio5Ghz) {
                                if ($scope.vm.node.radio5Ghz.ssid) {
                                    $scope.vm.node.radio5Ghz.ssidEllipse = ellipsemodel($scope.vm.node.radio5Ghz.ssid, 13, 11);
                                }
                            }
                            if ($scope.vm.node.radio5Ghz) {
                                if ($scope.vm.node.radio5Ghz.radioMode) {
                                    $scope.vm.node.radio5Ghz.radioModeEllipse = ellipsemodel($scope.vm.node.radio5Ghz.radioMode, 13, 11);
                                }
                            }
                            console.log("loadNodeById link type", $rootScope.linkType);
                            if (response.data.radio5Ghz.channel == 'auto') {
                                $scope.vm.node.radio5Ghz.channel = 'Auto'
                            }
                            // if ($scope.vm.node.radio5Ghz.bandwidth == 'HT20') {
                            //     $scope.vm.node.radio5Ghz.bandwidth = '20 Mhz';
                            // } else if ($scope.vm.node.radio5Ghz.bandwidth == 'HT40+') {
                            //     $scope.vm.node.radio5Ghz.bandwidth = '40 Mhz';
                            // } else if ($scope.vm.node.radio5Ghz.bandwidth == 'HT40-') {
                            //     $scope.vm.node.radio5Ghz.bandwidth = '40 Mhz';
                            // }
                            // else if ($scope.vm.node.radio5Ghz.bandwidth == 'HT480') {
                            //     $scope.vm.node.radio5Ghz.bandwidth = '80 Mhz';
                            // }
                            $scope.vm.node.radio5Ghz.ssid = response.data.radio5Ghz.ssid;
                        }
                        if ($scope.vm.node.radio24Ghz != null && $scope.vm.node.radio24Ghz.radioMode == 'ap') {
                            if ($rootScope.builCode && $rootScope.builCode == 'US') {
                                $scope.vm.node.radio24Ghz.radioMode = 'Management'
                            } else {
                                $scope.vm.node.radio24Ghz.radioMode = 'Access Point'
                            }
                        }
                        if ($scope.vm.node.radio24Ghz) {
                            if ($scope.vm.node.radio24Ghz.ssid) {
                                $scope.vm.node.radio24Ghz.ssidEllipse = ellipsemodel($scope.vm.node.radio24Ghz.ssid, 13, 11);
                            }
                        }
                        if ($scope.vm.node.radio24Ghz) {
                            if ($scope.vm.node.radio24Ghz.radioMode) {
                                $scope.vm.node.radio24Ghz.radioModeEllipse = ellipsemodel($scope.vm.node.radio24Ghz.radioMode, 13, 11);
                            }
                        }
                        if ($scope.vm.node.ipConfig) {
                            if ($scope.vm.node.ipConfig.mode == 2) {
                                $scope.vm.node.ipConfig.mode = 'Enable';
                            } else {
                                $scope.vm.node.ipConfig.mode = 'Disable';
                            }
                        }
                        if ($scope.vm.node.vlan.vlanStatus == 2) {
                            $scope.vm.node.vlan.vlanStatus = 'Disable';
                        } else {
                            $scope.vm.node.vlan.vlanStatus = 'Enable';
                        }
                        return response.data;
                    }
                });
        }

        $scope.grapheventsummary = 1;
        $scope.loadNodeByIdOnStart = function (nodeId) {
            var url = 'api/v2/nodemanageview/summarydb?nodeId=' + nodeId;
            return $http.get(url, { showdiv: false })
                .then(function (response) {
                    if (response.data) {
                        $scope.vm.node = response.data;
                        if($scope.vm.node.latitude){
                            $rootScope.nodelatitude=$scope.vm.node.latitude;
                        }
                        if($scope.vm.node.longitude){
                            $rootScope.nodelongitude=$scope.vm.node.longitude;
                        }
                        $rootScope.devicestatus = $scope.vm.node.nodeStatus;
                        if (!$rootScope.devicestatus) {
                            $scope.grapheventsummary = 2;
                            if($scope.selectednodetype=='') {
                                $scope.graphEvent($scope.grapheventsummary);
                            }
                        }
                        if ($scope.vm.node.remotePartners2 == null) {
                            $scope.vm.node.remotePartners2 = 0;
                        }
                        console.log("$scope.vm.node", $scope.vm.node)
                        if (!$scope.vm.node.image) {
                            $scope.vm.node.image = "RouterImg.png";
                        }
                        var splitUpTime = response.data.systemConfig.sysTime.split(":");
                        splitUpTime[0] = splitUpTime[0] + "d";
                        splitUpTime[1] = splitUpTime[1] + "h";
                        splitUpTime[2] = splitUpTime[2] + "m";
                        splitUpTime[3] = splitUpTime[3] + "s";
                        $scope.vm.node.systemConfig.sysTime = splitUpTime.join(" ");
                        if ($scope.vm.node.systemConfig) {
                            $scope.vm.node.systemConfig.custNameEllipse = ellipsemodel(response.data.systemConfig.custName, 10, 8);
                        }
                        if ($scope.vm.node.ipConfig) {
                            $scope.vm.node.ipConfig.ipAddressEllipse = ellipsemodel(response.data.ipConfig.ipAddress, 15, 8);
                        }
                        if (response.data.vlan.vlanMode == 3) {
                            $scope.vlanMode = 'Q-in-Q';
                        } else if (response.data.vlan.vlanMode == 2) {
                            $scope.vlanMode = 'Trunk';
                        } else if (response.data.vlan.vlanMode == 0) {
                            $scope.vlanMode = 'Transparent';
                        } else if (response.data.vlan.vlanMode == 1) {
                            $scope.vlanMode = 'Access';
                        }

                        if ($scope.vm.node.provisioned) {
                            $scope.provButtonLabel = "UnProvision"
                            $scope.enableProvButton = 1;
                        } else {
                            $scope.provButtonLabel = "Provision"
                            $scope.enableProvButton = 2;
                        }
                        // $scope.vm.node.systemConfig.temperature = 35;
                        var metrics = $rootScope.metrics;

                        if (!metrics) {
                            metrics = $rootScope.buildCode;
                        }
                        $scope.buildCode = metrics;
                        if (metrics == 'US') {
                            $scope.vm.node.systemConfig.temperature = ($scope.vm.node.systemConfig.temperature * 1.8) + 32;
                        }

                        if ($scope.vm.node.remoteId != null) {
                            $scope.remoteIP = $scope.vm.node.remoteIP;
                            $scope.enableRemote = true;
                            $scope.remoteId = $scope.vm.node.remoteId;
                        }
                        $rootScope.ipAddress = $scope.vm.node.ipConfig.ipAddress;
                        if ($scope.vm.node.radio24Ghz != null && $scope.vm.node.radio24Ghz.radioMode == 'ap') {
                            if ($rootScope.builCode && $rootScope.builCode == 'US') {
                                $scope.vm.node.radio24Ghz.radioMode = 'Management'
                            } else {
                                $scope.vm.node.radio24Ghz.radioMode = 'Access Point'
                            }

                            $rootScope.radioMode = 1;
                        }
                        if ($scope.vm.node.radio5Ghz.radioMode == 'sta') {
                            $scope.vm.node.radio5Ghz.radioMode = 'Outdoor Subscriber'
                            //this rootscope is used for under network tab screens
                            $rootScope.radioMode = 2;
                        } else {
                            $scope.vm.node.radio5Ghz.radioMode = 'Outdoor Base'
                            $rootScope.radioMode = 1;
                        }
                        if ($scope.vm.node.ipConfig.mode == 2) {
                            $scope.vm.node.ipConfig.mode = 'Enable';
                        } else {
                            $scope.vm.node.ipConfig.mode = 'Disable';
                        }
                        if ($scope.vm.node.vlan.vlanStatus == 2) {
                            $scope.vm.node.vlan.vlanStatus = 'Disable';
                        } else {
                            $scope.vm.node.vlan.vlanStatus = 'Enable';
                        }
                        if ($scope.vm.node.radio5Ghz) {
                            if ($scope.vm.node.radio5Ghz.ssid) {
                                $scope.vm.node.radio5Ghz.ssidEllipse = ellipsemodel($scope.vm.node.radio5Ghz.ssid, 13, 11);
                            }
                        }
                        if ($scope.vm.node.radio5Ghz) {
                            if ($scope.vm.node.radio5Ghz.radioMode) {
                                $scope.vm.node.radio5Ghz.radioModeEllipse = ellipsemodel($scope.vm.node.radio5Ghz.radioMode, 13, 11);
                            }
                        }

                        if ($scope.vm.node.radio24Ghz) {
                            if ($scope.vm.node.radio24Ghz.ssid) {
                                $scope.vm.node.radio24Ghz.ssidEllipse = ellipsemodel($scope.vm.node.radio24Ghz.ssid, 13, 11);
                            }
                        }
                        if ($scope.vm.node.radio24Ghz) {
                            if ($scope.vm.node.radio24Ghz.radioMode) {
                                $scope.vm.node.radio24Ghz.radioModeEllipse = ellipsemodel($scope.vm.node.radio24Ghz.radioMode, 13, 11);
                            }
                        }
                        // $rootScope.linkType = $scope.vm.node.radio5Ghz.linkType;
                        console.log("loadNodeByIdOnStart link type", $rootScope.linkType);
                        if ($scope.vm.node.radio24Ghz != null && $scope.vm.node.radio24Ghz.channel == 'auto') {
                            $scope.vm.node.radio24Ghz.channel = 'Auto'
                        }
                        if ($scope.vm.node.radio24Ghz != null && $scope.vm.node.radio5Ghz.channel == 'auto') {
                            $scope.vm.node.radio5Ghz.channel = 'Auto'
                        }
                        if ($scope.vm.node.radio5Ghz.bandwidth == 'HT20') {
                            $scope.vm.node.radio5Ghz.bandwidth = '20 Mhz';
                        } else if ($scope.vm.node.radio5Ghz.bandwidth == 'HT40+') {
                            $scope.vm.node.radio5Ghz.bandwidth = '40 Mhz';
                        } else if ($scope.vm.node.radio5Ghz.bandwidth == 'HT40-') {
                            $scope.vm.node.radio5Ghz.bandwidth = '40 Mhz';
                        }
                        else if ($scope.vm.node.radio5Ghz.bandwidth == 'HT480') {
                            $scope.vm.node.radio5Ghz.bandwidth = '80 Mhz';
                        }

                        if ($scope.vm.node.radio24Ghz) {
                            if ($scope.vm.node.radio24Ghz.bandwidth == 'HT20') {
                                $scope.vm.node.radio24Ghz.bandwidth = '20 Mhz';
                            } else if ($scope.vm.node.radio24Ghz.bandwidth == 'HT40+') {
                                $scope.vm.node.radio24Ghz.bandwidth = '40+ Mhz';
                            } else if ($scope.vm.node.radio24Ghz.bandwidth == 'HT40-') {
                                $scope.vm.node.radio24Ghz.bandwidth = '40- Mhz';
                            }
                        }
                        if($scope.selectednodetype=='') {
                            $scope.initMap();
                        }
                        return response.data;
                    }
                });
        }


        $scope.loadDBData = function (nodeId) {
            var url = 'api/v2/nodemanageview/summarydb?nodeId=' + nodeId;
            return $http.get(url, { showdiv: false })
                .then(function (response) {
                    if (response.data) {
                        if ($scope.vm.node.systemConfig) {
                            $scope.vm.node.systemConfig.custNameEllipse = ellipsemodel(response.data.systemConfig.custName, 10, 8);
                        }
                        if ($scope.vm.node.ipConfig) {
                            $scope.vm.node.ipConfig.ipAddressEllipse = ellipsemodel(response.data.ipConfig.ipAddress, 15, 8);
                        }
                        //$scope.vm.node = response.data;
                        if ($scope.vm.node.systemConfig) {
                            var splitUpTime = response.data.systemConfig.sysTime.split(":");
                            splitUpTime[0] = splitUpTime[0] + "d";
                            splitUpTime[1] = splitUpTime[1] + "h";
                            splitUpTime[2] = splitUpTime[2] + "m";
                            splitUpTime[3] = splitUpTime[3] + "s";
                            $scope.vm.node.systemConfig.sysTime = splitUpTime.join(" ");
                            $scope.vm.node.systemConfig.custName = response.data.systemConfig.custName;
                        }

                        if (response.data.vlan.vlanMode == 3) {
                            $scope.vlanMode = 'Q-in-Q';
                        } else if (response.data.vlan.vlanMode == 2) {
                            $scope.vlanMode = 'Trunk';
                        } else if (response.data.vlan.vlanMode == 0) {
                            $scope.vlanMode = 'Transparent';
                        } else if (response.data.vlan.vlanMode == 1) {
                            $scope.vlanMode = 'Access';
                        }

                        if ($scope.vm.node.systemConfig) {
                            $scope.vm.node.systemConfig.firmwareVersion = response.data.systemConfig.firmwareVersion
                        }


                        //firmwareVersion
                        if ($scope.vm.node.provisioned) {
                            $scope.provButtonLabel = "UnProvision"
                            $scope.enableProvButton = 1;
                        } else {
                            $scope.provButtonLabel = "Provision"
                            $scope.enableProvButton = 2;
                        }

                        if ($scope.vm.node.remoteId != null) {
                            $scope.remoteIP = response.data.remoteIP;
                            $scope.enableRemote = true;
                            $scope.remoteId = response.data.remoteId;
                        }
                        $rootScope.ipAddress = response.data.ipConfig.ipAddress;
                        if ($scope.vm.node.radio5Ghz) {
                            if (response.data.radio5Ghz.radioMode == 'sta') {
                                $scope.vm.node.radio5Ghz.radioMode = 'Outdoor Subscriber'
                                //this rootscope is used for under network tab screens
                                $rootScope.radioMode = 2;
                            } else {
                                $scope.vm.node.radio5Ghz.radioMode = 'Outdoor Base'
                                $rootScope.radioMode = 1;
                            }
                            //$rootScope.linkType = $scope.vm.node.radio5Ghz.linkType;
                            console.log("loadDBData link type", $rootScope.linkType);
                            if (response.data.radio5Ghz.channel == 'auto') {
                                $scope.vm.node.radio5Ghz.channel = 'Auto'
                            }
                            if ($scope.vm.node.radio5Ghz.bandwidth == 'HT20') {
                                $scope.vm.node.radio5Ghz.bandwidth = '20 Mhz';
                            } else if ($scope.vm.node.radio5Ghz.bandwidth == 'HT40+') {
                                $scope.vm.node.radio5Ghz.bandwidth = '40 Mhz';
                            } else if ($scope.vm.node.radio5Ghz.bandwidth == 'HT40-') {
                                $scope.vm.node.radio5Ghz.bandwidth = '40 Mhz';
                            }
                            else if ($scope.vm.node.radio5Ghz.bandwidth == 'HT480') {
                                $scope.vm.node.radio5Ghz.bandwidth = '80 Mhz';
                            }
                            $scope.vm.node.radio5Ghz.ssid = response.data.radio5Ghz.ssid;
                        }

                        if ($scope.vm.node.ipConfig) {
                            if ($scope.vm.node.ipConfig.mode == 2) {
                                $scope.vm.node.ipConfig.mode = 'Enable';
                            } else {
                                $scope.vm.node.ipConfig.mode = 'Disable';
                            }
                        }
                        if ($scope.vm.node.vlan.vlanStatus == 2) {
                            $scope.vm.node.vlan.vlanStatus = 'Disable';
                        } else {
                            $scope.vm.node.vlan.vlanStatus = 'Enable';
                        }
                        return response.data;
                    }
                });
        }


        // Node Action methods
        $scope.actionNode = function (action_type) {
            if (action_type === 'rescan') {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodes/rescanNode',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: $state.params.nodeId
                }).success(function () {
                    $scope.showAlert('Success', 'Rescanning of the node initiated');
                }).error(function (msg) {
                    $scope.showAlert('Error', 'Failed to resan the node: ' + msg);
                });
            } else if (action_type === "commit") {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodelinks/commit?nodeId=' + $state.params.nodeId,
                    headers: {
                        'Content-Type': 'application/json'
                    }
                }).success(function () {
                    $scope.showAlert('Success', 'Commit of the node initiated');
                }).error(function (msg) {
                    $scope.showAlert('Error', 'Failed to commit the node: ' + msg);
                });
            } else if (action_type === "reboot") {
                $http({
                    method: 'POST',
                    url: 'api/v2/nodelinks/reboot?nodeId=' + $state.params.nodeId,
                    headers: {
                        'Content-Type': 'application/json'
                    }
                }).success(function () {
                    $scope.showAlert('Success', 'Reboot of the node initiated');
                }).error(function (msg) {
                    $scope.showAlert('Error', 'Failed to reboot the node: ' + msg);
                });
            } else if (action_type === "provision") {
                if ($scope.enableProvButton != 0) {
                    var URL = '';
                    var confirmMsg = 'Are you sure you wish to provistion device?'
                    if ($scope.enableProvButton == 1) {
                        URL = 'api/v2/profiles/' + $state.params.nodeId + '/unprov'
                        confirmMsg = 'Are you sure you wish to unprovistion device?'
                    } else if ($scope.enableProvButton == 2) {
                        URL = 'api/v2/profiles/' + $state.params.nodeId + '/prov'
                    }
                    var confirm = $scope.saveconfirm();
                    $mdDialog.show(confirm).then(function () {
                        $http({
                            method: 'POST',
                            url: URL,
                            headers: {
                                'Content-Type': 'application/json'
                            }
                        }).success(function () {
                            $scope.showAlert('Success', 'Initiated device Provisioning process');
                            if ($scope.enableProvButton == 1) {
                                $scope.provButtonLabel = "Provision"
                                $scope.enableProvButton = 2;
                            } else if ($scope.enableProvButton == 2) {
                                $scope.provButtonLabel = "UnProvision"
                                $scope.enableProvButton = 1;
                            }
                        }).error(function (msg) {
                            $scope.showAlert('Error', 'Failed due to : ' + msg);
                        });

                    })
                }
            }
        }

        $scope.showAlert = function (msgType, msg, ev) {
            $mdDialog.show(
                $mdDialog.alert()
                    .parent(angular.element(document.querySelector('#popupContainer')))
                    .clickOutsideToClose(true)
                    .title(msgType)
                    .textContent(msg)
                    .ariaLabel('Alert')
                    .ok('OK')
                    .targetEvent(ev)
            );
        };

        // nodeview accordion menu default highlite
        if ($state.params.lastView == "app.Events") {
            $scope.viewNode = 'node_events';
            $scope.eventsActive = "active";
            $scope.summaryActive = "";
            $scope.eventActivecss = "background-color:rgb(246, 246, 246);color:black";
        } /*else if ($state.params.lastView == "app.Events") {
            $scope.viewNode = 'linkstat';
            $scope.eventsActive = "active";
            $scope.summaryActive = "";
            $scope.eventActivecss = "background-color:rgb(246, 246, 246);color:black";
        }*/  else {
            $scope.viewNode = 'summary';
            $scope.eventsActive = "";
            $scope.summaryActive = "active";
            $scope.summaryActivecss = "background-color:rgb(246, 246, 246);color:black";
            $scope.eventActive = "";
        }

        //    nodeview sidemenu on click page open methos
        $scope.showDiv = function (viewNode) {
            if (viewNode == 'wl-5ghz-properties') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wl-5ghz-mimo') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;

            } else if (viewNode == 'wl-5ghz-DDRS') {

                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wl-5ghz-security') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wl-5ghz-mac_acl') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wl-5ghz-dcs') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wl-2.4ghz-properties') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wl-2.4ghz-security') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'summary') {
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wl-2.4ghz-mac_acl') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'network-ipconfig') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'network-vlanconfig') {

                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;

            } else if (viewNode == 'network-ethernetconfig') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;

            } else if (viewNode == 'network-ethernetradius') {

                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;

            } else if (viewNode == 'network-dhcpconfig') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;

            } else if (viewNode == 'management_general') {

                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;

            } else if (viewNode == 'management_logging') {

                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'management_location') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'management_http/https') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'telnet') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'snmp') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'linkstat') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'wireless_statistics') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'ethernet_statistics') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'system_statistics') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            } else if (viewNode == 'node_events') {
                $rootScope.selectedView = viewNode;
                $scope.viewNode = viewNode;
            }

        }

        // To redirect to Node view page
        $scope.showNode = function (nodeId, lastView) {
            $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });

        }

        // To redirect to Node view page
        $scope.showLinks = function () {
            /*$scope.eventsActive = "active";
            $scope.summaryActive = "";
            $scope.showDiv('linkstat')*/
            $state.go('app.nodeView', { "nodeId": $state.params.nodeId, "lastView": 'app.linkStats' });
        }

        $scope.showLinksNodeHome = function () {
            $scope.rerender = "";
            $scope.eventsActive = "";
            $scope.summaryActive = "active";
            //$scope.showDiv('linkstat')
            $scope.viewNode = 'summary';
            $scope.summaryActivecss = "background-color:rgb(246, 246, 246);color:black";
            $scope.showDiv('summary')
            loadAccordian();
            $scope.rerender = "rerender";

        }
        //        post methods starts hear
        //save conformation
        $scope.saveconfirm = function (ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to update this changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')


            return confirm;
        };

        $scope.$watch('spec_status', function (newObj, oldObj) {
            if (newObj == 0) {
                $scope.loadSpectrumResults();
            }

        });


        $scope.$watch(function () {
            var metrics = $rootScope.metrics;

            if (!metrics) {
                metrics = $rootScope.buildCode;
            }
            $scope.buildCode = metrics;
            if (metrics == 'US') {
                $scope.tempUnicode = 'F';
            } else {
                $scope.tempUnicode = 'C';
            }
            return $rootScope.buildCode;
        }, function () {
            var metrics = $rootScope.metrics;

            if (!metrics) {
                metrics = $rootScope.buildCode;
            }
            $scope.buildCode = metrics;
            //$scope.buildCode = $rootScope.buildCode;
        }, true);

        /*unction loadAccordian() {
            $("#accordian a").click(function() {
                            var link = $(this);
                            var closest_ul = link.closest("ul");
                            var parallel_active_links = closest_ul.find(".active")
                            var closest_li = link.closest("li");
                            var link_status = closest_li.hasClass("active");
                            var count = 0;

                            closest_ul.find("ul").slideUp(function() {
                                if (++count == closest_ul.find("ul").length)
                                    parallel_active_links.removeClass("active");
                            });

                            if (!link_status) {
                                closest_li.children("ul").slideDown();
                                closest_li.addClass("active");
                            }
                        })
                        $('.activeItem').click(function(e) {
                            $('.activeItem').css("background-color", "white", "color", "black");
                            $(this).css("background-color", "#f6f6f6", "color", "white", "font-weight", "bold");
                        });

        }

        // nodeview side toggle menu
        $(document).ready(function() {
            loadAccordian();

        })*/

        // Initialize and add the map
        $scope.initMap = function () {
            if ($scope.vm.node.latitude == "-" || $scope.vm.node.latitude == "null" || $scope.vm.node.latitude == undefined) {
                $scope.vm.node.latitude = null;
            }
            if ($scope.vm.node.longitude == "-" || $scope.vm.node.longitude == "null" || $scope.vm.node.longitude == undefined) {
                $scope.vm.node.longitude = null;
            }
            if ($scope.vm.node.latitude && $scope.vm.node.longitude) {

                var l = 1;
                var lo = 1;
                if ($scope.vm.node.longitude && ($scope.vm.node.longitude.endsWith('w') || $scope.vm.node.longitude.endsWith('W'))) {
                    lo = lo * -1;
                }

                if ($scope.vm.node.latitude && ($scope.vm.node.latitude.endsWith('s') || $scope.vm.node.latitude.endsWith('S'))) {
                    l = l * -1;
                }
                // The location of Uluru
                var lat = parseFloat($scope.vm.node.latitude);
                var lon = parseFloat($scope.vm.node.longitude);

                lat = lat * l;
                lon = lon * lo;

                // var lat = parseFloat("28.669177");
                // var lon = parseFloat("77.092958");               
                const uluru = { lat: lat, lng: lon };
                var mapid = document.getElementById("map_node");
                // The map, centered at Uluru
                $scope.mapsummary = new google.maps.Map(document.getElementById("map_node"), {
                    zoom: 8,
                    center: uluru,
                    streetViewControl: false
                });
                // The marker, positioned at Uluru
                var iconURL = getIcon($scope.vm.node.radio5Ghz.radioMode, $scope.vm.node.nodeStatus);
                const marker = new google.maps.Marker({
                    position: uluru,
                    title: $scope.vm.node.ipConfig.ipAddress,
                    icon: iconURL,
                    map: $scope.mapsummary,
                });
            }else{
                var mapid = document.getElementById("map_node");
                var mapOptions = {
                    zoom: 8,
                    center: new google.maps.LatLng('24.555035', '-81.780629'),
                    streetViewControl: false
                }
                $scope.mapsummary = new google.maps.Map(document.getElementById("map_node"), mapOptions);
            }
            // else {
            //     var lat = 13.0827;
            //     var lon = 80.2707;
            //     const uluru = { lat: lat, lng: lon };
            //     var mapid = document.getElementById("map_node");
            //     // The map, centered at Uluru
            //     $scope.mapsummary = new google.maps.Map(document.getElementById("map_node"), {
            //         zoom: 8,
            //         center: uluru,
            //     });
            // }
            // localStorage.setItem("mapload", true);
            // $rootScope.mapload = true;
            // $('#mydiv').hide();
        }
//        setTimeout(() => {
//            console.log("stop loader");
//            localStorage.setItem("mapload", true);
//            $rootScope.mapload = true;
//            $('#mydiv').hide();
//        }, 10000);
        if($scope.selectednodetype=='') {
            $(document).ready(function () {
                initGraph();
            })
        }

    }

]);
