dashboard.controller("RadiusProfileConfigController", ['$rootScope', '$scope', '$mdDialog', '$http', '$state', '$location', 'dashboardService', 'Flash',
    function($rootScope, $scope, $mdDialog, $http, $state, $location, dashboardService, Flash) {

        $scope.tableWidth = "col-md-12";
        $scope.filter = {};
        $scope.radiusDefaultObj = {};
        $scope.radiusProfileObj = {};
        //radio mode
        $scope.radioMode = [{
                'name': "All",
                'value': -1
            },
            {
                'name': "AP",
                'value': 1
            }, {
                'name': "SU",
                'value': 2
            }
        ];
        //link types
        $scope.linkType = [{
            'name': "All",
            'value': -1
        }, {
            'name': "PTP",
            'value': 1
        }, {
            'name': "BackHaul",
            'value': 2
        }, {
            'name': "PTMP",
            'value': 3
        }];
        //radius types
        $scope.radiusStatusArray = [{
            "id": 0,
            "val": "Disable"
        }, {
            "id": 1,
            "val": "Enable"
        }];

        //set Profile Default values
        $scope.defaultProfileValues = function() {
            $scope.radiusProfileObj.radiusPrimaryServer = '192.168.1.100';
            $scope.radiusProfileObj.radiusPrimaryPort = 1812;
            $scope.radiusProfileObj.radiusPrimarySecret = 'public';
            $scope.radiusProfileObj.radiusSecondaryServer = '192.168.1.100';
            $scope.radiusProfileObj.radiusSecondaryPort = 1812;
            $scope.radiusProfileObj.radiusSecondarySecret = 'public'
            $scope.radiusProfileObj.radiusAuthenticationTime = 21600;
            $scope.radiusProfileObj.radiusRetryTime = 300;
            $scope.radiusProfileObj.radiusRetryCount = 3;
            $scope.radiusProfileObj.radiusRetryCountPeriod = 3;
        }

        //set Profile Null values
        $scope.nullProfileValues = function() {
                $scope.radiusProfileObj.radiusPrimaryServer = '';
                $scope.radiusProfileObj.radiusPrimaryPort = '';
                $scope.radiusProfileObj.radiusPrimarySecret = '';
                $scope.radiusProfileObj.radiusSecondaryServer = '';
                $scope.radiusProfileObj.radiusSecondaryPort = '';
                $scope.radiusProfileObj.radiusSecondarySecret = ''
                $scope.radiusProfileObj.radiusAuthenticationTime = '';
                $scope.radiusProfileObj.radiusRetryTime = '';
                $scope.radiusProfileObj.radiusRetryCount = '';
                $scope.radiusProfileObj.radiusRetryCountPeriod = '';
            }
            //from config controller to this method calling
            //if config controller click radius this method initates
        $rootScope.$on("init_radius", function() {
            $scope.init();
        });

        $scope.init = function() {
            $scope.defProfileObj = {};
            $scope.defProfileObj.radiusPrimaryServer = '';
            $scope.defProfileObj.radiusPrimaryPort = '';
            $scope.defProfileObj.radiusPrimarySecret = '';
            $scope.defProfileObj.radiusSecondaryServer = '';
            $scope.defProfileObj.radiusSecondaryPort = '';
            $scope.defProfileObj.radiusSecondarySecret = ''
            $scope.defProfileObj.radiusAuthenticationTime = '';
            $scope.defProfileObj.radiusRetryTime = '';
            $scope.defProfileObj.radiusRetryCount = '';
            $scope.defProfileObj.radiusRetryCountPeriod = '';
            $scope.vdefProfileObj = {};
            $scope.vdefProfileObj.radiusPrimaryServer = 'required';
            $scope.vdefProfileObj.radiusPrimaryPort = 'required';
            $scope.vdefProfileObj.radiusPrimarySecret = 'required';
            $scope.vdefProfileObj.radiusSecondaryServer = 'required';
            $scope.vdefProfileObj.radiusSecondaryPort = 'required';
            $scope.vdefProfileObj.radiusSecondarySecret = 'required'
            $scope.vdefProfileObj.radiusAuthenticationTime = 'required';
            $scope.vdefProfileObj.radiusRetryTime = 'required';
            $scope.vdefProfileObj.radiusRetryCount = 'required';
            $scope.vdefProfileObj.radiusRetryCountPeriod = 'required';
            if (!$rootScope.profileID) {
                $scope.create_radius_profile = true;
                $scope.edit_radius_profile = false;
                $scope.radiusDefaultObj = {};
                $scope.radiusProfileObj = {};
                $scope.radiusDefaultObj.rMode = $scope.radioMode[0];
                $scope.radiusDefaultObj.lType = $scope.linkType[0];
                if ($scope.radiusDefaultObj.rMode.value == '1') {
                    $scope.statusDiv = true;
                } else {
                    $scope.statusDiv = false;
                }
                $scope.radiusDefaultObj.radiusStatus = $scope.radiusStatusArray[0];
                if ($scope.radiusDefaultObj.radiusStatus.val == 'Enable') {
                    $scope.subDiv = true;
                }
            } else {
                $scope.create_radius_profile = false;
                $scope.edit_radius_profile = true;
                $scope.radiusDefaultObj = {};
                $scope.radiusProfileObj = {};
                var url = 'api/v2/profiles/template/get?profile=' + $rootScope.profileID;
                $http.get(url).then(function(response) {
                    $scope.radiusDefaultObj.radiusProfileName = response.data.name;
                    $scope.radiusDefaultObj.rMode = {
                        value: response.data.radioMode
                    }
                    if (response.data.radioMode == 1) {
                        $scope.statusDiv = true;
                    } else {
                        $scope.statusDiv = false;
                    }
                    $scope.radiusDefaultObj.lType = {
                        value: response.data.linkType
                    }
                    $scope.radiusDefaultObj.radiusStatus = {
                        id: response.data.rdto.radiusStatus
                    }
                    if (response.data.radioMode == 1 && response.data.rdto.radiusStatus == 1) {
                        $scope.subDiv = true;
                    } else {
                        $scope.subDiv = false;
                    }
                    $scope.radiusProfileObj.radiusPrimaryServer = response.data.rdto.radiusPrimaryServer;
                    $scope.radiusProfileObj.radiusPrimaryPort = response.data.rdto.radiusPrimaryPort;
                    $scope.radiusProfileObj.radiusPrimarySecret = response.data.rdto.radiusPrimarySecret;
                    $scope.radiusProfileObj.radiusSecondaryServer = response.data.rdto.radiusSecondaryServer;
                    $scope.radiusProfileObj.radiusSecondaryPort = response.data.rdto.radiusSecondaryPort;
                    $scope.radiusProfileObj.radiusSecondarySecret = response.data.rdto.radiusSecondarySecret;
                    $scope.radiusProfileObj.radiusAuthenticationTime = response.data.rdto.radiusAuthenticationTime;
                    $scope.radiusProfileObj.radiusRetryTime = response.data.rdto.radiusRetryTime;
                    $scope.radiusProfileObj.radiusRetryCount = response.data.rdto.radiusRetryCount;
                    $scope.radiusProfileObj.radiusRetryCountPeriod = response.data.rdto.radiusRetryCountPeriod;
                });
            }
        }

        $scope.removeProperty = function(propery) {
            console.log(propery);
            //propery = null;
            $scope.radiusProfileObj[propery] = null;
            $scope.vdefProfileObj[propery] = '';
            $scope.defProfileObj[propery] = 'display:none;';
        }

        $scope.showForm = function(selectedForm) {
            $scope.openForm = true;
            $scope.tableWidth = "col-md-7";
            $scope.selectedForm = selectedForm;
        }

        //onchange for Radio mode AP or SU
        $scope.radioTypeChange = function(rmode) {
            if (rmode.value == '1') {
                $scope.statusDiv = true;
                $scope.radiusDefaultObj.radiusStatus = $scope.radiusStatusArray[0];
            } else {
                $scope.statusDiv = false;
                $scope.subDiv = false;
                $scope.nullProfileValues();
                $scope.radiusDefaultObj.radiusStatus = null;
            }
        }

        // Onchange for radius status
        $scope.radiusStatusChange = function(radiusStatus) {

            if (radiusStatus.val == 'Enable') {
                $scope.subDiv = true;
                $scope.defaultProfileValues();
            } else {
                // set subDiv to false and clear the all subDiv components
                $scope.subDiv = false;
                $scope.nullProfileValues();
            }
        }

        // IP Address check
        $scope.checkIP = function(ipAddress, group, type) {

            var ipRegex = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
            if (type == 'radiusPrimaryServer' || type == 'radiusSecondaryServer') {
                if (!ipAddress.match(ipRegex)) {
                    $scope[group][type] = "";
                }
            }
        }

        //Number Range check
        $scope.checknum = function(num, group, type) {

            if (type == 'radiusPrimaryPort' || type == 'radiusSecondaryPort' || type == 'radiusRetryCount' || type == 'radiusRetryCountPeriod') {
                if (num < 1 || num > 65535) {
                    $scope.radiusProfileObj[type] = "";
                }
            } else if (type == 'radiusAuthenticationTime' || type == 'radiusRetryTime') {
                if (num < 10 || num > 65535) {
                    $scope.radiusProfileObj[type] = "";
                }
            }
        }

        // Create Radius Profile
        $scope.createRadiusProfile = function() {

            var radiusObj = {
                "profileType": 3,
                "name": $scope.radiusDefaultObj.radiusProfileName.split(" ").join(""),
                "radioMode": $scope.radiusDefaultObj.rMode.value,
                "linkType": $scope.radiusDefaultObj.lType.value,
                "rdto": {
                    "radio": 0,
                    "nodeId": 0,
                    "status": 0,
                    "message": null,
                    "radiusStatus": $scope.radiusDefaultObj.radiusStatus ? $scope.radiusDefaultObj.radiusStatus.id : $scope.radiusStatusArray[0].id,
                    "radiusPrimaryServer": $scope.radiusProfileObj.radiusPrimaryServer ? $scope.radiusProfileObj.radiusPrimaryServer : null,
                    "radiusPrimaryPort": $scope.radiusProfileObj.radiusPrimaryPort ? $scope.radiusProfileObj.radiusPrimaryPort : null,
                    "radiusPrimarySecret": $scope.radiusProfileObj.radiusPrimarySecret ? $scope.radiusProfileObj.radiusPrimarySecret : null,
                    "radiusSecondaryServer": $scope.radiusProfileObj.radiusSecondaryServer ? $scope.radiusProfileObj.radiusSecondaryServer : null,
                    "radiusSecondaryPort": $scope.radiusProfileObj.radiusSecondaryPort ? $scope.radiusProfileObj.radiusSecondaryPort : null,
                    "radiusSecondarySecret": $scope.radiusProfileObj.radiusSecondarySecret ? $scope.radiusProfileObj.radiusSecondarySecret : null,
                    "radiusAuthenticationTime": $scope.radiusProfileObj.radiusAuthenticationTime ? $scope.radiusProfileObj.radiusAuthenticationTime : null,
                    "radiusRetryTime": $scope.radiusProfileObj.radiusRetryTime ? $scope.radiusProfileObj.radiusRetryTime : null,
                    "radiusRetryCount": $scope.radiusProfileObj.radiusRetryCount ? $scope.radiusProfileObj.radiusRetryCount : null,
                    "radiusRetryCountPeriod": $scope.radiusProfileObj.radiusRetryCountPeriod ? $scope.radiusProfileObj.radiusRetryCountPeriod : null
                }
            }
            var confirm = $scope.createConfirm();
            $mdDialog.show(confirm).then(function() {
                $http({
                    method: 'POST',
                    url: 'api/v2/profiles/template',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: radiusObj
                }).success(function() {
                    $scope.showAlert('Success', 'Created successfully.');
                    $scope.radiusDefaultObj = {};
                    $scope.radiusProfileObj = {};
                    $scope.ttype = 3;
                    $scope.$emit("defaultCall", $scope.ttype);
                    $scope.$emit("toggleFormFunction");

                }).error(function(msg) {
                    $scope.showAlert('Error', 'Error creating Data: ' + msg);
                });
            });
        }

        // Update Radius Profile
        $scope.updateRadiusProfile = function() {

            var radiusObj = {
                "profileType": 3,
                "name": $scope.radiusDefaultObj.radiusProfileName.split(" ").join(""),
                "radioMode": $scope.radiusDefaultObj.rMode.value,
                "linkType": $scope.radiusDefaultObj.lType.value,
                "profileId": $rootScope.profileID,
                "rdto": {
                    "radio": 0,
                    "nodeId": 0,
                    "status": 0,
                    "message": null,
                    "radiusStatus": $scope.radiusDefaultObj.radiusStatus ? $scope.radiusDefaultObj.radiusStatus.id : $scope.radiusStatusArray[0].id,
                    "radiusPrimaryServer": $scope.radiusProfileObj.radiusPrimaryServer ? $scope.radiusProfileObj.radiusPrimaryServer : null,
                    "radiusPrimaryPort": $scope.radiusProfileObj.radiusPrimaryPort ? $scope.radiusProfileObj.radiusPrimaryPort : null,
                    "radiusPrimarySecret": $scope.radiusProfileObj.radiusPrimarySecret ? $scope.radiusProfileObj.radiusPrimarySecret : null,
                    "radiusSecondaryServer": $scope.radiusProfileObj.radiusSecondaryServer ? $scope.radiusProfileObj.radiusSecondaryServer : null,
                    "radiusSecondaryPort": $scope.radiusProfileObj.radiusSecondaryPort ? $scope.radiusProfileObj.radiusSecondaryPort : null,
                    "radiusSecondarySecret": $scope.radiusProfileObj.radiusSecondarySecret ? $scope.radiusProfileObj.radiusSecondarySecret : null,
                    "radiusAuthenticationTime": $scope.radiusProfileObj.radiusAuthenticationTime ? $scope.radiusProfileObj.radiusAuthenticationTime : null,
                    "radiusRetryTime": $scope.radiusProfileObj.radiusRetryTime ? $scope.radiusProfileObj.radiusRetryTime : null,
                    "radiusRetryCount": $scope.radiusProfileObj.radiusRetryCount ? $scope.radiusProfileObj.radiusRetryCount : null,
                    "radiusRetryCountPeriod": $scope.radiusProfileObj.radiusRetryCountPeriod ? $scope.radiusProfileObj.radiusRetryCountPeriod : null
                }
            }
            var confirm = $scope.saveconfirm();

            $mdDialog.show(confirm).then(function() {
                $http({
                    method: 'POST',
                    url: 'api/v2/profiles/template/update',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: radiusObj
                }).success(function() {
                    $scope.showAlert('Success', 'Saved successfully.');
                    $scope.radiusDefaultObj = {};
                    $scope.radiusProfileObj = {};
                    $scope.ttype = 3;
                    $scope.$emit("defaultCall", $scope.ttype);
                    $scope.$emit("toggleFormFunction");

                }).error(function(msg) {
                    $scope.showAlert('Error', 'Error creating Data: ' + msg);
                });
            });

        }

        //create conformation
        $scope.createConfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to create this profile?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };
        //save conformation
        $scope.saveconfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to update these changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };
        $scope.showAlert = function(msgType, msg, ev) {
            $mdDialog.show(
                $mdDialog.alert()
                .parent(angular.element(document.querySelector('#popupContainer')))
                .clickOutsideToClose(true)
                .title(msgType)
                .textContent(msg)
                .ariaLabel('Alert')
                .ok('OK')
                .targetEvent(ev)
            );
        };


        //close the selected form
        $scope.toggleForm = function() {
            $scope.$emit("toggleFormFunction");

        }
    }
]);
