﻿dashboard.controller("ReportsController", ['$rootScope', '$scope', '$mdDialog', '$http', '$state', '$location', 'dashboardService', 'Flash', '$localStorage','$interval',
    function ($rootScope, $scope, $mdDialog, $http, $state, $location, dashboardService, Flash, $localStorage,$interval) {

        // Default bindings
        $scope.pagesizes = [10, 25, 50, 100];
        $scope.pagesize = $scope.pagesizes[1];
        $scope.currentpage = 1;
        $scope.nodes = [];
        $scope.reportNode = null;
        $scope.selectedNodes = [];
        $scope.totalNodesCount = 0;
        $scope.activeNodesCount = 0;
        $scope.currentViewNodeId = '';
        $scope.iconsbackground = '#D7D7D7';

        /*$scope.resizeMode = "OverflowResizer"*/
        $scope.reportJson = {
            "duration": "1h",
            "cpu": true,
            "memory": true,
            "temp": true,
            "throughput": true,
            "transmitPac": true,
            "phyErr": true,
            "ethput": true,
            "etransBytes": true,
            "crc": true,
            "snr": true,
            "rssi": true,
            "mcs": true,
            "lutil": true,
            "biterr": true,
            "icmp": true
        }
        // Scope selection
        if ($localStorage.selectedView) {
            // If scope is present in local storage
            $scope.selectedMode = $localStorage.selectedView;
        } else {
            // If scope is not present in local storage
            $scope.selectedMode = "Global";
        }

        // Default Init function
        $scope.init = function () {
            $scope.loadNodes();
            $scope.loadActiveNodesCount();
            starttimer();
        }

        $scope.convertRadioMode = function (radioMode) {
            if (radioMode != null || radioMode != undefined) {
                if ('sta' == radioMode) {
                    return 'SU';
                }
                return radioMode.toUpperCase();
            }
            return radioMode;
        }

        $scope.gotoLinkStats = function (nodeId, lastView) {
            $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });
        }

        $scope.convertBandwidth = function (bandwidth) {
            if (bandwidth == 'HT20') {
                bandwidth = '20 Mhz';
            } else if (bandwidth == 'HT40+') {
                bandwidth = '40+ Mhz';
            } else if (bandwidth == 'HT40-') {
                bandwidth = '40- Mhz';
            } else if (bandwidth == 'HT80') {
                bandwidth = '80 Mhz';
            }
            return bandwidth;
        }
        $scope.searchText='';
        $scope.searchTextvalue='';

        function starttimer(){
            $scope.timer = $interval(function () { $scope.loadNodes();$scope.loadActiveNodesCount(); }, 15000);
        }

        $scope.$on('$destroy', function () {
            $scope.stopTimer();
        });
        $scope.stopTimer = function () {
            if (angular.isDefined($scope.timer)) {
                $interval.cancel($scope.timer);
            }
        }
        // Load devices/node in the Table
        $scope.loadNodes = function () {
            // Add sort parameters if not available
            if (!$scope.sortField) {
                $scope.orderBy = 'id'
                $scope.sortField = 'id';
            }
            if (!$scope.sortOrder) {
                $scope.sortOrder = 'asc'
            }
            // Add Scope to the URL
            if (!$localStorage.facilitiesArray) {
                $scope.url = '';
            } else {
                $scope.url = '&ar=' + $localStorage.ar + '&';
                var facilitiesArray = $localStorage.facilitiesArray;
                for (var j = 0; j < facilitiesArray.length; j++) {
                    $scope.url = $scope.url + 'fac=' + facilitiesArray[j];
                    if ((j + 1) != facilitiesArray.length) {
                        $scope.url = $scope.url + '&';
                    }
                }
            }
            // Generate config
            var config = {
                params: {
                    'offset': (($scope.currentpage - 1) * $scope.pagesize),
                    'limit': $scope.pagesize,
                    'order': $scope.sortOrder,
                    'orderBy': $scope.sortField,
                    '_s': $scope.url
                }
            };
            // URL formation
            if($scope.searchText!=''){
                var url = 'api/v2/nodes?_s=assetRecord.serialNumber==' + $scope.searchText + ',label==' + $scope.searchText+',sysName==' + $scope.searchText+'&'+$scope.url+'&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=' + $scope.sortOrder + '&orderBy=' + $scope.sortField ;
            }else{
                var url = 'api/v2/nodes?_s='+$scope.url+'&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=' + $scope.sortOrder + '&orderBy=' + $scope.sortField ;
            }
            $http.get(url, { showdiv: false })
                .then(function (response) {
                    if (response.data) {
                        $scope.totalNodesCount = response.data.totalCount; // Total number of devices
                        $scope.nodes = response.data.node;
                        console.log("get nodes", $scope.nodes);
                        for (var i = 0; i < $scope.nodes.length; i++) {
                            $scope.nodes[i].isChecked = false;
                            $scope.nodes[i].sysUptime = $scope.timeticksToString($scope.nodes[i].sysUptime);
                            /*if ($scope.nodes[i].id == $scope.reportNode) {
                                $scope.nodes[i].isChecked = true;
                            }*/
                            var found = $scope.selectedNodes.find(function (element) {
                                return element == $scope.nodes[i].id;
                            });
                            if (found) {
                                $scope.nodes[i].isChecked = true;
                            }

                        }
                        // Pagination button condition
                        if (response.data.node.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        }else{
                            $scope.nextBtnDisable = false;
                        }
                        $scope.TotalPages = response.data.node.length;
                        if ($scope.nodes == null) {
                            $scope.TotalPages = 0;
                        }
                        $scope.pagenumber = Math.ceil($scope.nodes.length / $scope.pagesize);
                        if ($scope.pagenumber == 0) {
                            $scope.pagenumber = 1;
                        }
                    }
                }
                );
        }

        $scope.pad = function (n, width) {
            var n = n + '';
            return n.length >= width ? n : new Array(width - n.length + 1).join('0') + n;
        }

        $scope.timeticksToString = function (timeTicks) {
            //StringBuilder builder = new StringBuilder();
            timeTicks /= 100;
            var seconds = Math.floor((timeTicks / 10) % 60);
            var minutes = Math.floor((timeTicks / 60) % 60);
            var hours = Math.floor((timeTicks / 3600) % 24);
            var days = Math.floor(timeTicks / 86400);
            var dd = $scope.pad(days, 2) + ":" + $scope.pad(hours, 2) + ":" + $scope.pad(minutes, 2) + ":" + $scope.pad(seconds, 2);
            /*builder.append(days + ":");
            builder.append(String.format("%02d",hours) + ":");
            builder.append(String.format("%02d",minutes) + ":");
            builder.append(String.format("%02d",seconds));*/

            return dd;
        }

        // Load the device counters
        $scope.loadActiveNodesCount = function () {
            $http.get('api/v2/nodes/active/count')
                .then(function (response) {
                    if (response.data) {
                        $scope.activeNodesCount = response.data;
                    }
                }
                );
        }

        // Change the page size of the table
        $scope.changePageSize = function (pagesize) {
            $scope.currentpage = 1; // Set Current pag to 1
            $scope.pagesize = pagesize;
            // Scope filter to URL
            if (!$localStorage.facilitiesArray) {
                $scope.url = 'assetRecord.serialNumber==' + $scope.searchText + ',label==' + $scope.searchText+',sysName==' + $scope.searchText
            } else {
                //$scope.url = 'ar=' + $localStorage.ar + '&';
                $scope.url = 'assetRecord.serialNumber==' + $scope.searchText + ',label==' + $scope.searchText+',sysName==' + $scope.searchText+'& ar=' + $localStorage.ar;
                var facilitiesArray = $localStorage.facilitiesArray;
                for (var j = 0; j < facilitiesArray.length; j++) {
                    $scope.url = $scope.url + 'fac=' + facilitiesArray[j];
                    if ((j + 1) != facilitiesArray.length) {
                        $scope.url = $scope.url + '&';
                    }
                }
            }
            // Generate config for URL
            var config = {
                params: {
                    'offset': (($scope.currentpage - 1) * $scope.pagesize),
                    'limit': $scope.pagesize,
                    'orderBy': $scope.sortField,
                    'order': $scope.sortOrder,
                    '_s': $scope.url
                }
            };
            if($scope.searchText!=''){
                var url = 'api/v2/nodes?_s='+$scope.url+'&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=' + $scope.sortOrder + '&orderBy=' + $scope.sortField;
            }else{
                var url = 'api/v2/nodes?_s=&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=' + $scope.sortOrder + '&orderBy=' + $scope.sortField;
            }

            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.totalNodesCount = response.data.totalCount;
                        $scope.nodes = response.data.node;
                        $scope.TotalPages = response.data.totalCount;
                        for (var i = 0; i < $scope.nodes.length; i++) {
                            $scope.nodes[i].sysUptime = $scope.timeticksToString($scope.nodes[i].sysUptime);
                            $scope.nodes[i].isChecked = false;
                            /*if ($scope.nodes[i].id == $scope.reportNode) {
                                $scope.nodes[i].isChecked = true;
                            }*/
                            var found = $scope.selectedNodes.find(function (element) {
                                return element == $scope.nodes[i].id;
                            });
                            if (found) {
                                $scope.nodes[i].isChecked = true;
                            }

                        }
                        // Pagination button condition
                        if (response.data.node.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        } else {
                            $scope.nextBtnDisable = false;
                        }
                        if ($scope.nodes == null) {
                            $scope.TotalPages = 0;

                        }
                        $scope.pagenumber = Math.ceil($scope.nodes.length / $scope.pagesize);
                        if ($scope.pagenumber == 0) {
                            $scope.pagenumber = 1;
                        }
                    }
                }
                );
        }



        // Paging function of Device Table
        $scope.paging = function (type, totalPages, val) {
            // Set current page based on val
            if (type == 'previous') {
                --$scope.currentpage;
            } else if (type == 'next') {
                ++$scope.currentpage;
            }
            // Scope filter to URL
            if (!$localStorage.facilitiesArray) {
                $scope.url = 'assetRecord.serialNumber==' + $scope.searchText + ',label==' + $scope.searchText+',sysName==' + $scope.searchText
            } else {
                $scope.url = 'assetRecord.serialNumber==' + $scope.searchText + ',label==' + $scope.searchText +',sysName==' + $scope.searchText+'&ar=' + $localStorage.ar;
                var facilitiesArray = $localStorage.facilitiesArray;
                for (var j = 0; j < facilitiesArray.length; j++) {
                    $scope.url = $scope.url + 'fac=' + facilitiesArray[j];
                    if ((j + 1) != facilitiesArray.length) {
                        $scope.url = $scope.url + '&';
                    }
                }
            }
            // Generate config for URL
            var config = {
                params: {
                    'offset': (($scope.currentpage - 1) * $scope.pagesize),
                    'limit': $scope.pagesize,
                    'orderBy': $scope.sortField,
                    'order': $scope.sortOrder,
                    '_s': +$scope.url
                }
            };
            // URL Formation
            if($scope.searchText!=''){
                var url = 'api/v2/nodes?_s='+$scope.url+'&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=' + $scope.sortOrder + '&orderBy=' + $scope.sortField;
            }else{
                var url = 'api/v2/nodes?_s=&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=' + $scope.sortOrder + '&orderBy=' + $scope.sortField;
            }

            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.totalNodesCount = response.data.totalCount;
                        $scope.nodes = response.data.node;
                        for (var i = 0; i < $scope.nodes.length; i++) {
                            $scope.nodes[i].isChecked = false;
                            $scope.nodes[i].sysUptime = $scope.timeticksToString($scope.nodes[i].sysUptime);
                            /*if ($scope.nodes[i].id == $scope.reportNode) {
                                $scope.nodes[i].isChecked = true;
                            }*/
                            var found = $scope.selectedNodes.find(function (element) {
                                return element == $scope.nodes[i].id;
                            });
                            if (found) {
                                $scope.nodes[i].isChecked = true;
                            }
                        }
                        // Pagination button condition
                        if (type == "next") {
                            if (response.data.node.length < $scope.pagesize) {
                                $scope.nextBtnDisable = true;
                            }else{
                                $scope.nextBtnDisable = false;
                            }
                        } else {
                            if (response.data.node.length >= $scope.pagesize) {
                                $scope.nextBtnDisable = false;
                            }else{
                                $scope.nextBtnDisable = true;
                            }
                        }
                        if ($scope.nodes == null) {
                            $scope.TotalPages = 0;
                        }
                        $scope.pagenumber = Math.ceil($scope.nodes.length / $scope.pagesize);
                        if ($scope.pagenumber == 0) {
                            $scope.pagenumber = 1;
                        }
                    }
                });
        }

        // Sorting of the Device Table
        $scope.sort = function (sortField) {
            $scope.currentpage = 1; // Make the page to 1

           if(sortField == 'id'){   //ip address
                sortField='ipConfig.ipAddress';
           }
           if(sortField=='elevation'){
                sortField='assetRecord.elevation';
           }
            if(sortField=='facility'){
                sortField='facility.name';
            }

            if (sortField == $scope.sortField) {
                // If clicked on same field
                $scope.sortOrder = $scope.sortOrder == 'asc' ? 'desc' : 'asc'; // Change Sort Order
            } else {
                // If clicked on different field
                $scope.sortField = sortField;
                $scope.sortOrder = 'asc';
            }
            $scope.loadNodes();
        }

        // Rescan a selected device
        $scope.rescanNode = function (node) {
            $http({
                method: 'POST',
                url: 'api/v2/nodes/rescanNode',
                headers: { 'Content-Type': 'application/json' },
                data: node
            }).success(function () {
                //$scope.showAlert('success', 'Rescanning of the node initiated');
                $scope.showAlertCustom('success', 'Rescanning of the node initiated');
            }).error(function (msg) {
                //$scope.showAlert('error', 'Cannot apply the profile: ' + msg);
                $scope.showAlertCustom('Error', 'Cannot apply the profile: ' + msg);
            });
        }

        // Not using/Asked to remove the feature - Modal To delete a device
        $scope.deleteConfirm = function (nodeId, ev) {
            $(".fixedheaderdashboard").css("background-color", "transparent");
            $scope.iconsbackground = 'grey';
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to delete this Node?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No');
            $mdDialog.show(confirm).then(function () {
                $(".fixedheaderdashboard").css("background-color", "white");
                $scope.iconsbackground = '#D7D7D7';
                $scope.deleteNode(nodeId);
            });
        };


        $scope.clearsearch = function () {
            $scope.clearSearch = false;
            $scope.currentpage=1;
            $scope.activeNodesCount=0;
            $scope.totalNodesCount=0;
            $scope.searchText = '';
            $scope.searchTextvalue='';
            starttimer();
            $scope.loadNodes();
            $scope.loadActiveNodesCount();
        }

        $scope.searchNode = function () {
            // Add sort parameters if not available
            if (!$scope.sortField) {
                $scope.orderBy = 'id'
                $scope.sortField = 'id';
            }
            if (!$scope.sortOrder) {
                $scope.sortOrder = 'asc'
            }
            $scope.currentpage=1;
           $scope.searchText = $scope.searchTextvalue;
            // Add Scope to the URL
            var url = 'assetRecord.serialNumber==' + $scope.searchText + ',label==' + $scope.searchText+',sysName==' + $scope.searchText
            // Generate config
            var config = {
                params: {
                    'offset': (($scope.currentpage - 1) * $scope.pagesize),
                    'limit': $scope.pagesize,
                    'order': $scope.sortOrder,
                    'orderBy': $scope.sortField,
                    '_s': url
                }
            };
            $scope.clearSearch = true;
            // URL formation
            if($scope.searchText!=''){
                var url = 'api/v2/nodes?_s='+url+'&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=' + $scope.sortOrder + '&orderBy=' + $scope.sortField;
            }else{
                var url = 'api/v2/nodes?_s=&limit=' + $scope.pagesize + '&offset=' + (($scope.currentpage - 1) * $scope.pagesize) + '&order=' + $scope.sortOrder + '&orderBy=' + $scope.sortField;
            }

            // var url = 'api/v2/nodes?_s=' + url;
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.stopTimer();
                        $scope.totalNodesCount = response.data.totalCount; // Total number of devices
                        var activeCount = 0;
                        $scope.nodes = response.data.node;
                        for (var i = 0; i < $scope.nodes.length; i++) {
                            $scope.nodes[i].isChecked = false;
                            if($scope.nodes[i].active) {
                                activeCount++;
                            }
                            $scope.nodes[i].sysUptime = $scope.timeticksToString($scope.nodes[i].sysUptime);
                            /*if ($scope.nodes[i].id == $scope.reportNode) {
                                $scope.nodes[i].isChecked = true;
                            }*/
                            var found = $scope.selectedNodes.find(function (element) {
                                return element == $scope.nodes[i].id;
                            });
                            if (found) {
                                $scope.nodes[i].isChecked = true;
                            }

                        }
                        $scope.activeNodesCount = activeCount;
                        // Pagination button condition
                        if (response.data.node.length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        }else{
                            $scope.nextBtnDisable = false;
                        }
                        $scope.TotalPages = response.data.node.length;
                        if ($scope.nodes == null) {
                            $scope.TotalPages = 0;
                        }
                        $scope.pagenumber = Math.ceil($scope.nodes.length / $scope.pagesize);
                        if ($scope.pagenumber == 0) {
                            $scope.pagenumber = 1;
                        }
                    } else {
                        $scope.nodes = [];
                    }
                }
                );
        }

        // Not Using/Asked to remove the feature - To delete a device
        $scope.deleteNode = function (node) {
            if ($scope.selectedNodes.length > 0) {
                var nodeCheck = [];
                var nodeData = [];
                if ($scope.selectedNodes.length == 1) {
                    var confirmMsg = 'All the device data will be lost. Are you sure you want to delete the device?';
                } else {
                    var confirmMsg = 'All the selected devices data will be lost. Are you sure you want to delete the selected devices?';
                }
                $(".fixedheaderdashboard").css("background-color", "transparent");
                $scope.iconsbackground = 'grey';
                var confirm = $scope.saveconfirm(undefined, confirmMsg);
                //var cData = 'nodeCheck=' + nodeCheck + '&nodeData=' + nodeData;
                $mdDialog.show(confirm).then(function () {
                    $(".fixedheaderdashboard").css("background-color", "white");
                    $scope.iconsbackground = '#D7D7D7';
                    var cData = '';
                    for (var i = 0; i < $scope.selectedNodes.length; i++) {
                        if (i != 0) {
                            cData = cData + '&';
                        }
                        cData = cData + 'nodeCheck=' + $scope.selectedNodes[i] + '&' + 'nodeData=' + $scope.selectedNodes[i];
                        /*nodeCheck.push('nodeCheck=' + $scope.selectedNodes[i]);
                        nodeData.push('nodeData='$scope.selectedNodes[i]);*/
                    }

                    //var cData = 'nodeCheck=' + nodeCheck + '&nodeData=' + nodeData;
                    $http({
                        url: 'admin/deleteSelNodes',
                        method: "POST",
                        data: cData
                        , headers: {
                            'Content-Type': 'application/x-www-form-urlencoded'
                        }
                    }).then(function (response) {
                        console.log(response.data);
                        $scope.message = response.data;
                        //$scope.showAlert('Success', 'Device deleted succesfuly');
                        // $scope.showAlertCustom('Success', 'Device deleted succesfuly');
                        $(".fixedheaderdashboard").css("background-color", "transparent");
                        $scope.iconsbackground = 'grey';
                        var confirm = $scope.saveconfirmdelete("Device deleted succesfully");
                        $mdDialog.show(confirm).then(function () {
                            $(".fixedheaderdashboard").css("background-color", "white");
                            $scope.iconsbackground = '#D7D7D7';
                            $scope.loadNodes();
                            $scope.selectAll=false;
                        });
                    }, function (response) {
                        //fail case
                        if (response.status == 403) {
                            //$scope.showAlert('Warning', 'User is forbidden for delete operation');
                            $scope.showAlertCustom('Warning', 'User is forbidden for delete operation');
                        } else {
                            console.log(response);
                            $scope.message = response;
                            //$scope.showAlert('Error', 'Failed to delete the device due to : ' + msg);
                            $scope.showAlertCustom('Error', 'Failed to delete the device due to : ' + msg);
                        }
                    });
                })
            } else {
                // $scope.showAlert('Warning', 'No devices have been selected for deletion.');
                $scope.showAlertCustom('Warning', 'No devices have been selected for deletion.');
            }
        }

        // To redirect to Node view page
        $scope.showNode = function (nodeId, lastView,type) {
            //$state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });
             if (type == 'Switch') {
                    localStorage.setItem('selectednodetype','switch');
                    localStorage.setItem("modetype",'');
                        $state.go('app.swnodeView', { "nodeId": nodeId, "lastView": lastView });
                } else {
                    localStorage.setItem('selectednodetype','');
                        $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });
                }
        }

        $scope.gotoLinkStats = function(nodeId, lastView,type) {
            if (type == 'Switch') {
                localStorage.setItem('selectednodetype','switch');
                lastView='app.system';
                $state.go('app.swnodeView', { "nodeId": nodeId, "lastView": lastView });
            } else {
                localStorage.setItem('selectednodetype','');
                $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });
            }
        }

        function arrayRemove(arr, value) {

            return arr.filter(function (ele) {
                return ele != value;
            });

        }

        $scope.generateReport = function (node) {
            if (node.isChecked == true) {
                $scope.reportNode = null;
                 node.isChecked=false;
                $scope.selectedNodes = arrayRemove($scope.selectedNodes, node.id);
            } else {
                $scope.reportNode = node.id;
                node.isChecked=true;
                $scope.selectedNodes.push(node.id);
            }
//            for (var i = 0; i < $scope.nodes.length; i++) {
//                if ($scope.nodes[i].id == $scope.reportNode) {
//                    $scope.nodes[i].isChecked = true;
//                }
//            }
        }


        $scope.inventoryReport = function () {
            var reportCols = { "cols": [] }
            for (var i = 0; i < $scope.cols.length; i++) {
                if ($scope.cols[i].status) {
                    console.log($scope.cols[i])
                    reportCols.cols.push($scope.cols[i].sortField);
                }

            }

            $http({
                method: 'POST',
                url: 'api/v2/nodes/export_to_csv',
                headers: { 'Content-Type': 'application/json' },
                data: reportCols
            }).success(function (data, status, headers) {
                headers = headers();

                var filename = headers['x-filename'];
                var contentType = headers['content-type'];

                var linkElement = document.createElement('a');
                try {
                    var blob = new Blob([data], { type: contentType });
                    var url = window.URL.createObjectURL(blob);

                    linkElement.setAttribute('href', url);
                    linkElement.setAttribute("download", filename);

                    var clickEvent = new MouseEvent("click", {
                        "view": window,
                        "bubbles": true,
                        "cancelable": false
                    });
                    linkElement.dispatchEvent(clickEvent);
                } catch (ex) {
                    console.log(ex);
                }
            }).error(function (msg) {
                //$scope.showAlert('error', 'Cannot apply the profile: ' + msg);
                $scope.showAlertCustom('Error', 'Cannot apply the profile: ' + msg);
            });
        }

        $scope.selectAllRows = function () {
            $scope.selectedNodes = [];
            $scope.selAll = event.target.checked;
            for (var i = 0; i < $scope.nodes.length; i++) {
                $scope.nodes[i].isChecked = $scope.selAll;
                if ($scope.nodes[i].isChecked) {
                    $scope.selectedNodes.push($scope.nodes[i].id);
                }
            }
        }

        $scope.saveconfirm = function (ev, msg) {
            var confirm = $mdDialog.confirm()
                .title(msg)
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };
        $scope.saveconfirmdelete = function (msg, ev) {
            var confirm = $mdDialog.confirm()
                .title('Success')
                .textContent(msg)
                .ok('Ok')
            return confirm;
        };
        $scope.generateSingleReport = function (duration, ev) {
            var generate = false;
            var m = 1;
            $("#dropdownMenu2").dropdown("toggle");
            if ($scope.selectedNodes.length > 1) {
                // $scope.showAlert('Failure', 'Please select a single node to generate report.');
                $scope.showAlertCustom('Failure', 'Please select a single node to generate report.');
                m = 2;
            } else if ($scope.selectedNodes.length == 1) {
                generate = true;
                $scope.reportNode = $scope.selectedNodes[0];
            } else {

            }
            if (generate) {
                $(".fixedheaderdashboard").css("background-color", "transparent");
                $scope.iconsbackground = 'grey';
                var confirm = $mdDialog.confirm()
                    .title('Are you sure you want to generate report?')
                    .targetEvent(ev)
                    .ok('Yes')
                    .cancel('No');
                $mdDialog.show(confirm).then(function () {
                    $(".fixedheaderdashboard").css("background-color", "white");
                    $scope.iconsbackground = '#D7D7D7';
                    var url = 'api/v2/nodes/export_to_pdf/' + $scope.reportNode + '/' + duration;
                    window.open(url);
                });
            } else {
                if (m == 1) {
                    //$scope.showAlert('Failure', 'Please select any node to generate report.');
                    $scope.showAlertCustom('Failure', 'Please select any node to generate report.');
                }

            }
        }


        // Check local storage of Columns to load
        if (!$localStorage.flag_R) {
            $scope.cols = [
                { 'label': 'System Name', 'sortField': 'sysName', 'status': true, 'alignment': 'text-align:left' },
                { 'label': 'Primary IP', 'sortField': 'id', 'status': true, 'alignment': 'text-align:left' },
                { 'label': 'MAC Address', 'sortField': 'macAddress', 'status': true, 'alignment': 'text-align:left' },
                { 'label': 'Serial Number', 'sortField': 'assetRecord.serialNumber', 'status': true , 'alignment': 'text-align:left'},
                { 'label': 'Model Number', 'sortField': 'assetRecord.modelNumber', 'status': true,'alignment': 'text-align:left' },
                { 'label': 'Firmware', 'sortField': 'assetRecord.firmware', 'status': true,'alignment': 'text-align:right' },
                { 'label': 'Product Code', 'sortField': 'productCode', 'status': false },
                { 'label': 'Radio Mode', 'sortField': 'radioMode', 'status': false },
                { 'label': 'Operation Mode', 'sortField': 'opMode', 'status': false },
                { 'label': 'Frequency', 'sortField': 'frequency', 'status': false },
                { 'label': 'Bandwidth', 'sortField': 'bandwidth', 'status': false, },
                { 'label': 'Channel', 'sortField': 'channel', 'status': false },
                { 'label': 'Ethernet Speed', 'sortField': 'assetRecord.ethernetSpeed', 'status': false },
                { 'label': 'Latitude', 'sortField': 'latitude', 'status': false },
                { 'label': 'Longitude', 'sortField': 'longitude', 'status': false },
                { 'label': 'Elevation', 'sortField': 'elevation', 'status': false },
                { 'label': 'SSID', 'sortField': 'ssid', 'status': false, },
                { 'label': 'Local SNR', 'sortField': 'lsnr', 'status': false },
                { 'label': 'Remote Partners', 'sortField': 'remotePartners', 'status': false },
                { 'label': 'Backup IP', 'sortField': 'fallbackIP', 'status': false,  },
                { 'label': 'UpTime', 'sortField': 'sysUptime', 'status': true },
                { 'label': 'Netmask', 'sortField': 'ipConfig.netMask', 'status': false, },
                { 'label': 'Gateway', 'sortField': 'ipConfig.gateway', 'status': false,},
                { 'label': 'Region', 'sortField': 'region', 'status': false,  },
                { 'label': 'Facility', 'sortField': 'facility', 'status': false,}

            ];

            $scope.reports = [
                { 'label': '1 hour', 'alignment': 'text-align:left' },
                { 'label': '1 day', 'alignment': 'text-align:left' },
                { 'label': '1 week', 'alignment': 'text-align:left' },
                { 'label': '1 month', 'alignment': 'text-align:left' }
            ];
            $scope.allToggle = false;
            //            $localStorage.allToggle_R = false;
        } else {
            $scope.cols = $localStorage.cols_R;
            $scope.allToggle = $localStorage.allToggle_R;
        }

        // To show or hide columns in Reports table
        $scope.showhideColinReports = function (colObj, ind) {
            $scope.cols[ind].status = colObj.status;
            $localStorage.flag_R = true;
            $localStorage.cols_R = $scope.cols;
            $scope.allToggle = false;
            $localStorage.allToggle_R = false;
            //$scope.cols = $localStorage.cols_R;
        }

        // To show all or default columns in table
        $scope.showAllCol = function (allToggle) {
            if (allToggle) {
                $scope.cols = [
                    { 'label': 'System Name', 'sortField': 'sysName', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Primary IP', 'sortField': 'id', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'MAC Address', 'sortField': 'macAddress', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Serial Number', 'sortField': 'assetRecord.serialNumber', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Model Number', 'sortField': 'assetRecord.modelNumber', 'status': true,'alignment': 'text-align:left' },
                    { 'label': 'Firmware', 'sortField': 'assetRecord.firmware', 'status': true ,'alignment': 'text-align:right'},
                    { 'label': 'Product Code', 'sortField': 'productCode', 'status': true },
                    { 'label': 'Radio Mode', 'sortField': 'radioMode', 'status': true },
                    { 'label': 'Operation Mode', 'sortField': 'opMode', 'status': true },
                    { 'label': 'Frequency', 'sortField': 'frequency', 'status': true },
                    { 'label': 'Bandwidth', 'sortField': 'bandwidth', 'status': true,  },
                    { 'label': 'Channel', 'sortField': 'channel', 'status': true },
                    { 'label': 'Ethernet Speed', 'sortField': 'assetRecord.ethernetSpeed', 'status': true },
                    { 'label': 'Latitude', 'sortField': 'latitude', 'status': true },
                    { 'label': 'Longitude', 'sortField': 'longitude', 'status': true },
                    { 'label': 'Elevation', 'sortField': 'elevation', 'status': true },
                    { 'label': 'SSID', 'sortField': 'ssid', 'status': true, },
                    { 'label': 'Local SNR', 'sortField': 'lsnr', 'status': true },
                    { 'label': 'Remote Partners', 'sortField': 'remotePartners', 'status': true },
                    { 'label': 'Backup IP', 'sortField': 'fallbackIP', 'status': true, },
                    { 'label': 'UpTime', 'sortField': 'sysUptime', 'status': true },
                    { 'label': 'Netmask', 'sortField': 'ipConfig.netMask', 'status': true },
                    { 'label': 'Gateway', 'sortField': 'ipConfig.gateway', 'status': true },
                    { 'label': 'Region', 'sortField': 'region', 'status': true },
                    { 'label': 'Facility', 'sortField': 'facility', 'status': true}

                ];
                $scope.allToggle = true;
                $localStorage.allToggle_R = true;
            } else {
                $scope.cols = [
                    { 'label': 'System Name', 'sortField': 'sysName', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Primary IP', 'sortField': 'primaryIP', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'MAC Address', 'sortField': 'macAddress', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Serial Number', 'sortField': 'assetRecord.serialNumber', 'status': true, 'alignment': 'text-align:left' },
                    { 'label': 'Model Number', 'sortField': 'assetRecord.modelNumber', 'status': true ,'alignment': 'text-align:left'},
                    { 'label': 'Firmware', 'sortField': 'assetRecord.firmware', 'status': true,'alignment': 'text-align:right' },
                    { 'label': 'Product Code', 'sortField': 'productcode', 'status': false },
                    { 'label': 'Radio Mode', 'sortField': 'radioMode', 'status': false },
                    { 'label': 'Operation Mode', 'sortField': 'opMode', 'status': false },
                    { 'label': 'Frequency', 'sortField': 'frequency', 'status': false },
                    { 'label': 'Bandwidth', 'sortField': 'bandwidth', 'status': false },
                    { 'label': 'Channel', 'sortField': 'channel', 'status': false },
                    { 'label': 'Ethernet Speed', 'sortField': 'ethernetSpeed', 'status': false },
                    { 'label': 'Latitude', 'sortField': 'latitude', 'status': false },
                    { 'label': 'Longitude', 'sortField': 'longitude', 'status': false },
                    { 'label': 'Elevation', 'sortField': 'elevation', 'status': false },
                    { 'label': 'SSID', 'sortField': 'ssid', 'status': false},
                    { 'label': 'Local SNR', 'sortField': 'lsnr', 'status': false },
                    { 'label': 'Remote Partners', 'sortField': 'remotePartners', 'status': false },
                    { 'label': 'Backup IP', 'sortField': 'fallbackIP', 'status': false},
                    { 'label': 'UpTime', 'sortField': 'sysUptime', 'status': true },
                    { 'label': 'Netmask', 'sortField': 'ipConfig.netMask', 'status': false },
                    { 'label': 'Gateway', 'sortField': 'ipConfig.gateway', 'status': false },
                    { 'label': 'Region', 'sortField': 'region', 'status': false},
                    { 'label': 'Facility', 'sortField': 'facility', 'status': false }

                ];
                $scope.allToggle = false;
                $localStorage.allToggle_R = false;
            }
            $localStorage.flag_R = true;
            $localStorage.cols_R = $scope.cols;
        }

        // Columns Dropoown Open
        $("document").ready(function () {
            $('.dropdown-menu').on('click', function (e) {
                if ($(this).hasClass('dropdown-menu')) {
                    e.stopPropagation();
                }
            });

            $('.reportdown-menu').on('click', function (e) {
                if ($(this).hasClass('reportdown-menu')) {
                    e.stopPropagation();
                }
            });
        });

        // Alert function for the controller
        $scope.showAlert = function (msgType, msg, ev) {
            $mdDialog.show(
                $mdDialog.alert()
                    .parent(angular.element(document.querySelector('#popupContainer')))
                    .clickOutsideToClose(true)
                    .title(msgType)
                    .textContent(msg)
                    .ariaLabel('Alert')
                    .ok('OK')
                    .targetEvent(ev)
            );
        };

        $scope.showalertreports = function (title, msg, ev) {
            var confirm = $mdDialog.confirm()
                .title(title)
                .textContent(msg)
                .targetEvent(ev)
                .ok('Ok')
            return confirm;
        }

        $scope.regionsData='';
        $scope.locationData='';
        $scope.facData='';
        // Scope Start
        // Display Scope Modal function
        $scope.showpopup = function () {
            $scope.errNotify = '';
            if ($localStorage.selectedView) {
                $scope.value = $localStorage.selectedView;
                $scope.div_select = $localStorage.selectedView;
                //new added for displaying previous selection in popup
                 if($localStorage.facilities==undefined){
                    $localStorage.facilities=[];
                }
                if($localStorage.locations==undefined){
                    $localStorage.locations=[];
                }
                if($localStorage.regions==undefined){
                    $localStorage.regions=[];
                }
                if($localStorage.basestations==undefined){
                    $localStorage.basestations=[];
                }
                 if($localStorage.facilities.length>0){
                   $scope.facilities=$localStorage.facilities;
                }
                if($localStorage.locations.length>0){
                   $scope.locations=$localStorage.locations;
                }
                if($localStorage.regions.length>0){
                   $scope.regions=$localStorage.regions;
                }
                if($localStorage.basestations.length>0){
                   $scope.basestations=$localStorage.basestations;
                }
                 $scope.regionsData =$localStorage.regionselectedid;
                 $scope.locationData =$localStorage.locationselectedid;
                 $scope.facData =$localStorage.facilityselectedid;
                $("#myModal").modal("show");
                //$scope.modeSelection($scope.div_select);
            } else {
                $scope.value = "Global";
                $scope.div_select = "Global";
                $scope.modeSelection($scope.div_select);
                $("#myModal").modal("show");

            }
        }

        $scope.showReportpopup = function () {
            $scope.errNotify = '';
              $scope.reportJson = {
                        "duration": "1h",
                        "cpu": true,
                        "memory": true,
                        "temp": true,
                        "throughput": true,
                        "transmitPac": true,
                        "phyErr": true,
                        "ethput": true,
                        "etransBytes": true,
                        "crc": true,
                        "snr": true,
                        "rssi": true,
                        "mcs": true,
                        "lutil": true,
                        "biterr": true,
                        "icmp": true
                    }
            $("#nodeReportModal").modal("show");
        }


        loadRegions();
        function loadRegions(){
            var url = 'api/v2/treeview/regions';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.regions = response.data;
                    }
                });
        }

        // Radio Buttons for tab selection function
        $scope.modeSelection = function (srcval) {
            $scope.errNotify = '';
            if (srcval == 'Global') {
                // If Selected tab is Global
                $scope.div_select = srcval;
            } else if (srcval == 'Region') {
                // If Selected tab is Region
//                var url = 'api/v2/treeview/regions';
//                $http.get(url)
//                    .then(function (response) {
//                        if (response.data) {
//                            $scope.node = response.data;
//                            $scope.regions = response.data;
//                            $scope.div_select = srcval;
//                        }
//                    });
                     $scope.div_select = srcval;
            } else if (srcval == 'Facility') {
                // If Selected tab is Facility
//                var url = 'api/v2/treeview/regions';
//                $http.get(url)
//                    .then(function (response) {
//                        if (response.data) {
//                            $scope.regions = response.data;
//                            $scope.div_select = srcval;
//                        }
//                    });
                      $scope.div_select = srcval;
            } else if (srcval == 'Location') {
                // If Selected tab is Location
//                var url = 'api/v2/treeview/regions';
//                $http.get(url)
//                    .then(function (response) {
//                        if (response.data) {
//                            $scope.regions = response.data;
//                            $scope.div_select = srcval;
//                        }
//                    });
                         $scope.div_select = srcval;
            } else if (srcval == 'Basestation') {
                // If Selected tab is Basestation
//                var url = 'api/v2/treeview/regions';
//                $http.get(url)
//                    .then(function (response) {
//                        if (response.data) {
//                            $scope.basestation = response.data;
//                            $scope.regions = response.data;
//                            $scope.div_select = srcval;
//                        }
//                    });
                      $scope.div_select = srcval;
            }
        }

        // On Region Change, Load Locations of selected region
        $scope.regionChange = function (regionId) {
          $localStorage.regionselectedid=regionId;
            var url = 'api/v2/treeview/regions/' + regionId.data.id + '/locations';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.locations = response.data;
                    }
                });
        }

        // On Location Change, Load Facilities of selected Location
        $scope.locationChange = function (locationID) {
         $localStorage.locationselectedid=locationID;
            var url = 'api/v2/treeview/locations/' + locationID.data.id + '/facilities';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.facilities = response.data;
                    }
                });
        }

        // On Facility Change, Load Basestations of selected facility
        $scope.facilityChange = function (facilityId) {
           $localStorage.facilityselectedid=facilityId;
           var facilityId1 = facilityId.data.id;
            var url = 'api/v2/treeview/facility/' + facilityId1 + '/treenodes';
            $http.get(url)
                .then(function (response) {
                    if (response.data) {
                        $scope.basestations = response.data;
                    }
                });
        }

        // Selected Facilities using Checkbox
        $scope.selectedFac = function (selectedFacility) {
            if (selectedFacility.checked) {
                selectedFacility.checked = false;
            } else {
                selectedFacility.checked = true;
            }
        }

        // Selected Regions using Checkbox
        $scope.selectedReg = function (selectedRegion) {
            if (selectedRegion.checked) {
                selectedRegion.checked = false;
            } else {
                selectedRegion.checked = true;
            }
        }

        // Selected Locations using Checkbox
        $scope.selectedLocation = function (selectedLocation) {
            if (selectedLocation.checked) {
                selectedLocation.checked = false;
            } else {
                selectedLocation.checked = true;
            }
        }

        // Selected Base Stations using Checkbox
        $scope.selectedBst = function (selectedBasestation) {
            if (selectedBasestation.checked) {
                selectedBasestation.checked = false;
            } else {
                selectedBasestation.checked = true;
            }
        }

        $scope.generatePdfReport = function () {
            console.log("" + $scope.reportJson);
            $("#nodeReportModal").modal("hide"); // Close modal
            $('body').removeClass('modal-open');
            $('.modal-backdrop').remove();

            var json = JSON.stringify($scope.reportJson);
            for (var i = 0; i < $scope.nodes.length; i++) {
                if ($scope.nodes[i].isChecked) {
                   $scope.reportNode=$scope.nodes[i].id;
                }
            }
            if($scope.reportNode!=null){
            $http({
                    method: 'GET',
                    url: 'api/v2/nodes/pdf/' + $scope.reportNode + '?d=' + json,
                    /*headers: { 'Content-Type': 'application/json' },
                    data: $scope.reportJson*/
                }).success(function (data, status, headers) {
                    headers = headers();

                    var filename = headers['x-filename'];
                    var contentType = headers['content-type'];

                    var linkElement = document.createElement('a');
                    try {
                        var darr = base64ToArrayBuffer(data);
                        var blob = new Blob([darr], { type: 'application/pdf' });
                        var url = window.URL.createObjectURL(blob);

                        linkElement.setAttribute('href', url);
                        linkElement.setAttribute("download", filename);

                        var clickEvent = new MouseEvent("click", {
                            "view": window,
                            "bubbles": true,
                            "cancelable": false
                        });
                        linkElement.dispatchEvent(clickEvent);
                    } catch (ex) {
                        console.log(ex);
                    }
                }).error(function (msg) {
                    // $scope.showAlert('error', 'Cannot apply the profile: ' + msg);
                    $scope.showAlertCustom('Error', 'Cannot apply the profile: ' + msg);
                });
            }else{
                    $scope.showAlertCustom('Info', 'Select lines to generate report ');
            }

        }

        function base64ToArrayBuffer(base64) {
            var binaryString = window.atob(base64);
            var binaryLen = binaryString.length;
            var bytes = new Uint8Array(binaryLen);
            for (var i = 0; i < binaryLen; i++) {
                var ascii = binaryString.charCodeAt(i);
                bytes[i] = ascii;
            }
            return bytes;
        }

        // Scope Apply Function or Change Scope Function
        $scope.apply = function () {
            if ($scope.div_select == 'Global') {
                // If Global Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $localStorage.ar = "glob";
                $localStorage.facilitiesArray = null;
                $("#myModal").modal("hide"); // Close modal
                $('body').removeClass('modal-open');
                $('.modal-backdrop').remove();
                showpageloading(true); // Display loading icon
                $state.reload(); // Page State reload
                showpageloading(false); // Stop displaying loading icon
            } else if ($scope.div_select == 'Facility') {
                // If Facility Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $scope.facilities = $scope.facilities;
                $localStorage.facilities=$scope.facilities;
                if (!$scope.facilities) {
                    // If no facility is selected
                    $scope.errNotify = 'Please select facilities';
                } else {
                    $scope.tempArryFac = [];
                    for (var i = 0; i < $scope.facilities.length; i++) {
                        if ($scope.facilities[i].facisChecked) {
                            $scope.tempArryFac.push($scope.facilities[i].data.id);
                        }
                    }
                    if ($scope.tempArryFac.length == 0) {
                        // If no facility is selected
                        $scope.errNotify = 'Please select facilities';
                    } else {
                        $localStorage.facilitiesArray = $scope.tempArryFac;
                        $localStorage.ar = "fac";
                        $("#myModal").modal("hide");
                        $('body').removeClass('modal-open');
                        $('.modal-backdrop').remove();
                        showpageloading(true);
                        $state.reload();
                        showpageloading(false);
                    }
                }
            } else if ($scope.div_select == "Location") {
                // If Location Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $scope.locations = $scope.locations;
                $localStorage.locations=$scope.locations;
                if (!$scope.locations) {
                    // If no location is selected
                    $scope.errNotify = "Please select locations";
                } else {
                    $scope.tempArrLoc = [];
                    for (var i = 0; i < $scope.locations.length; i++) {
                        if ($scope.locations[i].locisChecked) {
                            $scope.tempArrLoc.push($scope.locations[i].data.id);
                        }
                    }
                    if ($scope.tempArrLoc.length == 0) {
                        // If no location is selected
                        $scope.errNotify = "Please select locations";
                    } else {
                        $localStorage.facilitiesArray = $scope.tempArrLoc;
                        $localStorage.ar = "loc";
                        $("#myModal").modal("hide");
                        $('body').removeClass('modal-open');
                        $('.modal-backdrop').remove();
                        showpageloading(true);
                        $state.reload();
                        showpageloading(false);
                    }
                }
            } else if ($scope.div_select == 'Region') {
                // If Region Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $scope.regions = $scope.regions;
                $localStorage.regions=$scope.regions;
                if (!$scope.regions) {
                    // If no Region is selected
                    $scope.errNotify = "Please select regions";
                } else {
                    $scope.tempArryReg = [];
                    for (var i = 0; i < $scope.regions.length; i++) {
                        if ($scope.regions[i].regisChecked) {
                            $scope.tempArryReg.push($scope.regions[i].data.id);
                        }
                    }
                    if ($scope.tempArryReg.length == 0) {
                        // If no Region is selected
                        $scope.errNotify = "Please select regions";
                    } else {
                        $localStorage.facilitiesArray = $scope.tempArryReg;
                        $localStorage.ar = "reg";
                        $("#myModal").modal("hide");
                        $('body').removeClass('modal-open');
                        $('.modal-backdrop').remove();
                        $state.reload();
                    }
                }
            } else if ($scope.div_select == 'Basestation') {
                // If Basestation Radio button is selected
                $localStorage.selectedView = $scope.div_select;
                $scope.basestations = $scope.basestations;
                $localStorage.basestations=$scope.basestations;
                if (!$scope.basestations) {
                    // If no base station is selected
                    $scope.errNotify = "Please select basestations";
                } else {
                    $scope.tempArryBst = [];
                    for (var i = 0; i < $scope.basestations.length; i++) {
                        if ($scope.basestations[i].bstisChecked) {
                            $scope.tempArryBst.push($scope.basestations[i].data.id);
                        }
                    }
                    if ($scope.tempArryBst.length == 0) {
                        // If no base station is selected
                        $scope.errNotify = "Please select basestations";
                    } else {
                        $localStorage.facilitiesArray = $scope.tempArryBst;
                        $localStorage.ar = "node";
                        $("#myModal").modal("hide");
                        $('body').removeClass('modal-open');
                        $('.modal-backdrop').remove();
                        $state.reload();
                    }
                }
            }
        }
        // Scope End
        $scope.showAlertCustom = function (title, msg) {
            $(".fixedheaderdashboard").css("background-color", "transparent");
            $scope.iconsbackground = 'grey';
            var confirm = $scope.showalertreports(title, msg);
            $mdDialog.show(confirm).then(function () {
                $(".fixedheaderdashboard").css("background-color", "white");
                $scope.iconsbackground = '#D7D7D7';
            });
        }
    }]);
