﻿dashboard.controller("SettingsController", ['$rootScope', '$scope', '$mdDialog', '$http', '$q','$state', '$location', 'dashboardService', 'Flash',
    function ($rootScope, $scope, $mdDialog, $http, $q,$state, $location, dashboardService, Flash) {

        // Data Initialization
        var vm = this;
        $scope.selectedPage = 'regions';
        $scope.activeClass = "background-color:rgb(246, 246, 246);color:black";
        $scope.tableWidth = "col-md-8";
        $scope.selectedForm = "createRegion";
        $scope.openForm = true;

        // Default Table values
        $scope.pagesizes = [10, 25, 50, 100];
        $scope.pagesize = $scope.pagesizes[0];
        $scope.currentpage = 1;
        $scope.nextBtnDisable = false;
        $scope.sortField = 'name';
        $scope.sortOrder = 'asc';
        $scope.repeatPass = '';

        // Default Arrays & objects
        $scope.regions = [];
        $scope.locations = [];
        $scope.facilities = [];
        $scope.users = [];
        $scope.snmpConfig = {};
        $scope.thresholds = {};
        $scope.thresholdIndex = -1;
        $scope.thresholdlType = null;
        $scope.newsnmp = {};
        $scope.newnotification = {};
        $scope.selectedDef = {};
        $scope.enableNotifs = false;
        $scope.notifications = [];
        $scope.pathDelays = ['0s','1s','2s','5s','10s','15s','30s','1m','2m','5m','10m','15m','30m','1h','2h','3h','6h','12h','1d'];
        $scope.ueis = {};
        $scope.paths = {};
        $scope.pathText = "Create";
        //$scope.editPath = {};
        $scope.ugr = {};
        $scope.existingUsers = [];
        $scope.newUsers = [];
        $scope.editUsers = [];
        $scope.javaEmail = {}
        $scope.noticeStatus = "unknown";
        $scope.newGroup = {
            "user":[]
        }
        $scope.newPath =
        {
            "name": "",
            "initialDelay": "0s",
            "initialTargets": [],
            "escalations": []
        };

        //$scope.isFtp = false;

        //$scope.newPath.escalations.targets=[];

       $scope.metricSelect = [{
                "val": "US",
                "id": "US"

            }, {
                "val": "Asia",
                "id": "IND"

            }
       ];

       $scope.enableDisable = [{
               "val": "Enable",
               "id": "true"

           }, {
               "val": "Disable",
               "id": "false"

           }
       ];


        // New Objects
        $scope.newRegion = {
            'name': '',
            'type': 0
        };
        $scope.newLocation = {
            'name': '',
            'type': 1
        };
        $scope.newFacility = {
            'region': {
                'id': ''
            }
        };
        $scope.newUser = {};

        //Page Selection based on Tab
        $scope.showPage = function (selectedPage) {
            if (selectedPage == 'regions') {
                $scope.selectedPage = selectedPage;
                $scope.sortField = 'name';
                $scope.sortOrder = 'asc';
                $scope.tableWidth = "col-md-8";
                $scope.reverse = false;
                $scope.selectedForm = "createRegion";
                $scope.openForm = true;
            } else if (selectedPage == 'locations') {
                $scope.selectedPage = selectedPage;
                $scope.sortField = 'name';
                $scope.sortOrder = 'asc';
                $scope.reverse = false;
                $scope.tableWidth = "col-md-8";
                $scope.selectedForm = "createLocation";
                $scope.openForm = true;
                $scope.loadAllRegions();
            }
            else if (selectedPage == 'facilities') {
                $scope.pagesize = $scope.pagesizes[0];
                $scope.currentpage = 1;
                $scope.nextBtnDisable = false;
                $scope.selectedPage = selectedPage;
                $scope.sortField = 'name';
                $scope.sortOrder = 'asc';
                $scope.reverse = false;
                $scope.tableWidth = "col-md-8";
                $scope.selectedForm = "createFacility";
                $scope.openForm = true;
                $scope.loadAllRegions();
            } else if (selectedPage == 'users') {
                $scope.pagesize = $scope.pagesizes[0];
                $scope.currentpage = 1;
                $scope.nextBtnDisable = false;
                $scope.selectedPage = selectedPage;
                $scope.sortField = 'user-id';
                $scope.sortOrder = 'asc';
                $scope.reverse = false;
                $scope.tableWidth = "col-md-8";
                $scope.openForm = true;
                $scope.selectedForm = "createUser";
                $scope.newUser.roleData = 'ROLE_READONLY';
                $scope.loadAllRegions();
            } else if (selectedPage == 'groups') {
                $scope.pagesize = $scope.pagesizes[0];
                $scope.currentpage = 1;
                $scope.nextBtnDisable = false;
                $scope.ugrLoad();
                $scope.selectedPage = selectedPage;
                $scope.sortField = 'name';
                $scope.sortOrder = 'asc';
                $scope.reverse = false;
                $scope.tableWidth = "col-md-8";
                $scope.openForm = true;
                $scope.selectedForm = "createGroup";
                $scope.newUser.roleData = 'ROLE_READONLY';
                $scope.loadGroups();
                $scope.newGroup['user'] = [];

            } else if (selectedPage == 'snmpconfig') {
                $scope.selectedPage = selectedPage;
                $scope.tableWidth = "col-md-8";
                $scope.openForm = true;
                $scope.selectedForm = "createsnmp";
            } else if (selectedPage == 'noticeConfig') {
                $scope.selectedPage = selectedPage;
                $scope.tableWidth = "col-md-8";
                $scope.openForm = true;
                $scope.selectedForm = "createnewnotice";
                $scope.shnotifrm = 'listNotify';
            }  else if (selectedPage == 'threshold') {
                $scope.selectedPage = selectedPage;
                $scope.tableWidth = "col-md-8";
                $scope.openForm = true;
                $scope.selectedForm = "threshold";
                $scope.toggleForm();
            } else if (selectedPage == 'config') {
                $scope.selectedPage = selectedPage;
                $scope.selectedForm = "editConfig";
            }
        }

        $scope.masking = function (inputid,imgid) {
            var x = document.getElementById(inputid);
            var y = document.getElementById(imgid);
            if (x.type === "password") {
                x.type = "text";
                y.src = "./images/eye.png";
            } else {
                x.type = "password";
                y.src = "./images/eye-slash.png";
            }
        }
        $scope.resetPassword = function (pwd) {
            var pass = pwd;
            var changed = false;
            for (var i = 0; i < pass.length; i++) {
                if (pass.charAt(i) != '*') {
                    changed = true;
                    return pass;
                }
            }
            return null;
        }

        $scope.shownotifForm = function (selectedForm) {
            //if (selectedForm createNotify)
            $scope.shnotifrm =selectedForm;
        }

        $scope.showTForm = function (selectedForm, ltype,index) {
            $scope.thresholdlType = ltype;
            $scope.showForm(selectedForm,index);
        }

        // Form Selection
        $scope.showForm = function (selectedForm, obj) {
            if (selectedForm == 'createRegion') {
                $scope.selectedForm = selectedForm;
            } else if (selectedForm == 'editRegion') {
                $scope.selectedForm = selectedForm;
            } else if (selectedForm == 'createLocation') {
                $scope.loadAllRegions();  // Load Regions in to form
                $scope.selectedForm = selectedForm;
            } else if (selectedForm == 'editLocation') {
                $scope.selectedForm = selectedForm;
                // Load Regions and bind the location's region
                $http.get('api/v2/treeview/regions').then(function (response) {
                    if (response.data) {
                        $scope.allRegions = response.data;
                        $scope.editLocationLoad(obj);
                    }
                });
            } else if (selectedForm == 'createFacility') {
                $scope.selectedForm = selectedForm;
                $scope.loadAllRegions();  // Load Regions in to form
            } else if (selectedForm == 'editFacility') {
                $scope.selectedForm = selectedForm;
                // Load Regions and bind the facility's region
                $http.get('api/v2/treeview/regions').then(function (response) {
                    if (response.data) {
                        $scope.allRegions = response.data;
                        // Load Locations and bind the facility's location
                        $http.get('api/v2/treeview/regions/' + obj.regionId + '/locations').then(function (response1) {
                            if (response1.data) {
                                $scope.regionLocations = response1.data;
                                $scope.editFacilityLoad(obj);
                            }
                        });
                    }
                });
            } else if (selectedForm == 'createUser') {
                $scope.newUser.roleData = 'ROLE_READONLY';
                $scope.newUser.password = '';
                $scope.selectedForm = selectedForm;
                $scope.loadAllRegions();  // Load Regions in to form
            }  else if (selectedForm == 'createGroup') {
               //$scope.newUser.roleData = 'ROLE_READONLY';
               $scope.selectedForm = selectedForm;
               $scope.loadGroups();  // Load Regions in to form
               $scope.ugrLoad();
               $scope.newGroup['user'] = [];
           } else if (selectedForm == 'editUser') {
                $scope.selectedForm = selectedForm;
                // Load Regions and bind the user's region
                $http.get('api/v2/treeview/regions').then(function (response) {
                    if (response.data) {
                        $scope.allRegions = response.data;
                        $scope.editUserLoad(obj);
                    }
                });
            } else if (selectedForm == 'editGroup') {
                $scope.selectedForm = selectedForm;
                $scope.ugrLoad();
                $scope.selectedGroup = obj;
                             // Load Regions and bind the user's region

             } else if (selectedForm == 'snmp-config') {
                 $scope.newUser.roleData = 'ROLE_READONLY';
                 $scope.selectedForm = selectedForm;
                 $scope.selectedDef={};
                 $scope.loadAllRegions();  // Load Regions in to form
            } else if (selectedForm == 'createnewsnmp') {
                 //$scope.newUser.roleData = 'ROLE_READONLY';
                 $scope.selectedForm = selectedForm;
                 $scope.selectedDef={};
                 $scope.newsnmp.version = $scope.snmpVersionArray[1];
                 //$scope.loadAllRegions();  // Load Regions in to form
            } else if (selectedForm == 'editsnmp') {
                 $scope.selectedForm = selectedForm;
                 angular.copy(obj,$scope.selectedDef);
                 $scope.selectedDef.version = {
                     snmpVersion: obj.version
                 }
                 console.log("ddd");
            } else if (selectedForm == 'editthreshold') {
                  $scope.selectedForm = selectedForm;
                  $scope.thresholdIndex = obj;
                  $http.get('api/v2/threshold/get/'+$scope.thresholdlType+'/'+obj).then(function (response) {
                      if (response.data) {
                          $scope.selectedDef = response.data;
                          //$scope.editUserLoad(obj);
                      }
                  });
                  console.log("ddd");
             } else if (selectedForm == 'editnotice') {
                $scope.selectedForm = selectedForm;
                $scope.selectedDef = {};
                angular.copy(obj,$scope.selectedDef);
            } else if (selectedForm == 'createNotify') {
                 $scope.selectedForm = selectedForm;
            } else if (selectedForm == 'createDestination') {
                 $scope.selectedForm = selectedForm;
                 $scope.pathText = "Create";
            }

            $scope.tableWidth = "col-md-8";
            $scope.openForm = true;

        }

        // Toggle Form - To open and close form
        $scope.toggleForm = function () {
            $scope.selectedForm = "";
            $scope.openForm = false;
            $scope.tableWidth = "col-lg-12 col-md-12 col-sm-12 col-xs-12";
            $scope.newFacility = {
                'region': {
                    'id': ''
                }
            };
        }

        $scope.toggleToDefault = function() {
            $scope.selectedForm = "createsnmp";
            $scope.newPath =
            {
                "name": "",
                "initialDelay": "0s",
                "initialTargets": [],
                "escalations": []
            };
            $scope.newFacility = {
                'region': {
                    'id': ''
                }
            };
            $scope.newnotification = {};
        }

        // Pagination method
        $scope.paging = function (val, page) {
            if (val == 'previous') {
                --$scope.currentpage;
            } else if (val == 'next') {
                ++$scope.currentpage;
            }
            // Generating Config
            $scope.config = {
                params: {
                    '_s': "",
                    'limit': $scope.pagesize,
                    'offset': (($scope.currentpage - 1) * $scope.pagesize),
                    'orderBy': $scope.sortField,
                    'order': $scope.sortOrder
                }
            };
            // API call based on page selection
            if (page == 'regions') {
                $http.get('api/v2/regions', $scope.config).then(function (response) {
                    if(response.status==200){
                        if (response.data) {
                            $scope.regions = response.data.region;
                            if (val == "next") {
                                if ($scope[page].length < $scope.pagesize) {
                                    $scope.nextBtnDisable = true;
                                }
                            } else {
                                if ($scope[page].length >= $scope.pagesize) {
                                    $scope.nextBtnDisable = false;
                                }
                            }
                        }
                    } else if(response.status==204){
                        $scope.nextBtnDisable = true;
                    }
                });
            } else if (page == 'locations') {
                $http.get('api/v2/locations', $scope.config).then(function (response) {
                  if(response.status==200){
                    if (response.data) {
                        $scope.locations = response.data.region;
                         if (val == "next") {
                            if ($scope[page].length < $scope.pagesize) {
                                $scope.nextBtnDisable = true;
                            }
                        } else {
                            if ($scope[page].length >= $scope.pagesize) {
                                $scope.nextBtnDisable = false;
                            }
                        }
                    }
                     } else if(response.status==204){
                                            $scope.nextBtnDisable = true;
                                        }
                });
            } else if (page == 'facilities') {
                $http.get('api/v2/facilities', $scope.config).then(function (response) {
                      if(response.status==200){
                    if (response.data) {
                        $scope.facilities = response.data.facility;
                         if (val == "next") {
                            if ($scope[page].length < $scope.pagesize) {
                                $scope.nextBtnDisable = true;
                            }
                        } else {
                            if ($scope[page].length >= $scope.pagesize) {
                                $scope.nextBtnDisable = false;
                            }
                        }
                    }
                     } else if(response.status==204){
                                            $scope.nextBtnDisable = true;
                                        }
                });
            } else if (page == 'users') {
                // Different config to accomodate GET users API
                $scope.config = {
                    params: {
                        'limit': $scope.pagesize,
                        'offset': (($scope.currentpage - 1) * $scope.pagesize),
                        'sort': $scope.sortOrder
                    }
                };
                $http.get('rest/users/list', $scope.config).then(function (response) {
                     if(response.status==200){
                    if (response.data) {
                        $scope.users = response.data.users;
                         if (val == "next") {
                            if ($scope[page].length < $scope.pagesize) {
                                $scope.nextBtnDisable = true;
                            }
                        } else {
                            if ($scope[page].length >= $scope.pagesize) {
                                $scope.nextBtnDisable = false;
                            }
                        }
                    }
                     } else if(response.status==204){
                                            $scope.nextBtnDisable = true;
                                        }
                });
            }
            // Pagination button condition
//            if (val == "next") {
//                if ($scope[page].length < $scope.pagesize) {
//                    $scope.nextBtnDisable = true;
//                }
//            } else {
//                if ($scope[page].length >= $scope.pagesize) {
//                    $scope.nextBtnDisable = false;
//                }
//            }
        }

        // Page size change method
        $scope.changePageSize = function (pagesize, page) {
            $scope.currentpage = 1;
            $scope.pagesize = pagesize;
            // Generating Config
            $scope.config = {
                params: {
                    '_s': "",
                    'limit': $scope.pagesize,
                    'offset': (($scope.currentpage - 1) * $scope.pagesize),
                    'orderBy': $scope.sortField,
                    'order': $scope.sortOrder
                }
            };
            // API call based on page
            if (page == 'regions') {
                $http.get('api/v2/regions', $scope.config).then(function (response) {
                    if (response.data) {
                        $scope.regions = response.data.region;
                          if ($scope[page].length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        } else {
                            $scope.nextBtnDisable = false;
                        }
                    }
                });
            } else if (page == 'locations') {
                $http.get('api/v2/locations', $scope.config).then(function (response) {
                    if (response.data) {
                        $scope.locations = response.data.region;
                          if ($scope[page].length < $scope.pagesize) {
                            $scope.nextBtnDisable = true;
                        } else {
                            $scope.nextBtnDisable = false;
                        }
                    }
                });
            } else if (page == 'facilities') {
                $http.get('api/v2/facilities', $scope.config).then(function (response) {
                    if (response.data) {
                        $scope.facilities = response.data.facility;
                          if ($scope[page].length < $scope.pagesize) {
                                $scope.nextBtnDisable = true;
                            } else {
                                $scope.nextBtnDisable = false;
                            }
                    }
                });
            } else if (page == 'users') {
                // Different config to accomodate GET users API
                $scope.config = {
                    params: {
                        'limit': $scope.pagesize,
                        'offset': (($scope.currentpage - 1) * $scope.pagesize),
                        'sort': $scope.sortOrder
                    }
                };
                $http.get('rest/users/list', $scope.config).then(function (response) {
                    if (response.data) {
                        $scope.users = response.data.users;
                          if ($scope[page].length < $scope.pagesize) {
                                $scope.nextBtnDisable = true;
                            } else {
                                $scope.nextBtnDisable = false;
                            }
                    }
                });
            }
            // Pagination button condition
//            if ($scope[page].length < $scope.pagesize) {
//                $scope.nextBtnDisable = true;
//            } else {
//                $scope.nextBtnDisable = false;
//            }
        }

        // Sort Method
        $scope.sort = function (sortField, page) {
            $scope.sortField = sortField;
            $scope.currentpage = 1;
            // Assign sort by & sort order
            if ($scope.sortOrder == 'desc') {
                $scope.sortOrder = 'asc';
                $scope.reverse = false;
            } else {
                $scope.sortOrder = 'desc';
                $scope.reverse = true;
            }
            // Generating Config
            $scope.config = {
                params: {
                    '_s': "",
                    'limit': $scope.pagesize,
                    'offset': (($scope.currentpage - 1) * $scope.pagesize),
                    'orderBy': $scope.sortField,
                    'order': $scope.sortOrder
                }
            };
            // API call based on page
            if (page == 'regions') {
                $http.get('api/v2/regions', $scope.config).then(function (response) {
                    if (response.data) {
                        $scope.regions = response.data.region;
                         if ($scope[page].length < $scope.pagesize) {
                                        $scope.nextBtnDisable = true;
                                    } else {
                                        $scope.nextBtnDisable = false;
                                    }
                    }
                });
            } else if (page == 'locations') {
                $http.get('api/v2/locations', $scope.config).then(function (response) {
                    if (response.data) {
                        $scope.locations = response.data.region;
                         if ($scope[page].length < $scope.pagesize) {
                                        $scope.nextBtnDisable = true;
                                    } else {
                                        $scope.nextBtnDisable = false;
                                    }
                    }
                });
            } else if (page == 'facilities') {
                $http.get('api/v2/facilities', $scope.config).then(function (response) {
                    if (response.data) {
                        $scope.facilities = response.data.facility;
                         if ($scope[page].length < $scope.pagesize) {
                                        $scope.nextBtnDisable = true;
                                    } else {
                                        $scope.nextBtnDisable = false;
                                    }
                    }
                });
            } else if (page == 'users') {
                // Different config to accomodate GET users API
                $scope.config = {
                    params: {
                        'limit': $scope.pagesize,
                        'offset': (($scope.currentpage - 1) * $scope.pagesize),
                        'sort': $scope.sortOrder
                    }
                };
                $http.get('rest/users/list', $scope.config).then(function (response) {
                    if (response.data) {
                        $scope.users = response.data.users;
                         if ($scope[page].length < $scope.pagesize) {
                                        $scope.nextBtnDisable = true;
                                    } else {
                                        $scope.nextBtnDisable = false;
                                    }
                    }
                });
            }
            // Pagination button condition
//            if ($scope[page].length < $scope.pagesize) {
//                $scope.nextBtnDisable = true;
//            } else {
//                $scope.nextBtnDisable = false;
//            }
        }

        // Load Regions
        $scope.loadRegions = function () {
            $scope.pagesize = 10;
            $scope.currentpage = 1;
            $scope.sortField = 'name';
            $scope.sortOrder = "asc";
            // Generate URL config
            $scope.config = {
                params: {
                    '_s': "",
                    'limit': $scope.pagesize,
                    'offset': (($scope.currentpage - 1) * $scope.pagesize),
                    'orderBy': $scope.sortField,
                    'order': $scope.sortOrder
                }
            };
            $http.get('api/v2/regions', $scope.config).then(function (response) {
                if (response.data) {
                    $scope.regions = response.data.region;
                    // Pagination button condition
                    if (response.data.region.length < $scope.pagesize) {
                        $scope.nextBtnDisable = true;
                    } else {
                        $scope.nextBtnDisable = false;
                    }
                }
            });
        }

        // Load  All Regions - Used for Locations & Facilities
        $scope.loadAllRegions = function () {
            $http.get('api/v2/treeview/regions').then(function (response) {
                if (response.data) {
                    $scope.allRegions = response.data;
                }
            });
        }

        // Create Region
        $scope.createRegion = function () {
            $http({
                method: 'POST',
                url: 'api/v2/regions',
                headers: { 'Content-Type': 'application/json' },
                data: $scope.newRegion
            }).success(function () {
                $scope.showAlert('Success', 'Region has been created successfully.');
                $scope.newRegion = {};
                $scope.loadRegions();
                $scope.toggleForm();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating the region: ' + msg);
            });
        };

        // Load on Edit Region
        $scope.editRegionLoad = function (selectedRegion) {
            $scope.selectedRegion = selectedRegion;
        }

        // Save in Edit Region
        $scope.editRegion = function (selectedRegionId) {
            $http({
                method: 'PUT',
                url: 'api/v2/regions/' + selectedRegionId,
                headers: { 'Content-Type': 'application/json' },
                data: $scope.selectedRegion
            }).success(function () {
                $scope.showAlert('Success', 'The Region has been updated successfully.');
                $scope.selectedRegion = {};
                $scope.loadRegions();
                $scope.toggleForm();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error updating the region: ' + msg);
            });
        };

        // Delete Region Modal
        $scope.deleteRegionModal = function (regionId, regionName, ev) {
            $scope.toggleForm(); // Close any open form
            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Are you sure you want to delete this region?')
                /*.textContent('Facilities associated with this region will also be deleted.')*/
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No');
            // On Confirm
            $mdDialog.show(confirm).then(function () {
                $scope.deleteRegion(regionId, regionName);
            });
        };

        // Delete Region
        $scope.deleteRegion = function (regionId, regionName) {
        // Check to see if the region is default
            if (regionName != 'DefaultRegion') {
                $http({
                    method: 'DELETE',
                    url: 'api/v2/regions/' + regionId
                }).success(function () {
                    $scope.showAlert('Success', 'The region has been deleted successfully.');
                    $scope.loadRegions();
                    $scope.loadFacilities();
                }).error(function (response,msg) {
                    if (msg == 412) {
                        $scope.showAlert('Warning', regionName + ' Region contains one or more Locations.  Delete Locations containing in ' + regionName + ' before deleting.');
                    } else if (msg == 403) {
                        $scope.showAlert('Warning', 'User is forbidden for delete operation');
                    } else {
                        $scope.showAlert('Error', 'Error deleting the region: ' + msg);
                    }

                });
            } else {
                $scope.showAlert('Error', 'Unable to delete region: ' + regionName);
            }
        }

        // Load Locations
        $scope.loadLocations = function () {
            $scope.pagesize = 10;
            $scope.currentpage = 1;
            $scope.sortField = 'name';
            $scope.sortOrder = "asc";
            // Generate URL Config
            $scope.config = {
                params: {
                    '_s': "",
                    'limit': $scope.pagesize,
                    'offset': (($scope.currentpage - 1) * $scope.pagesize),
                    'orderBy': $scope.sortField,
                    'order': $scope.sortOrder
                }
            };
            $http.get('api/v2/locations', $scope.config).then(function (response) {
                if (response.data) {
                    $scope.locations = response.data.region;
                    if (response.data.region.length < $scope.pagesize) {
                        $scope.nextBtnDisable = true;
                    } else {
                        $scope.nextBtnDisable = false;
                    }
                }
            });
        }

        // Create Location
        $scope.createLocation = function () {
            $scope.newLocation.parent = $scope.newLocation.parent.data.id;
            $http({
                method: 'POST',
                url: 'api/v2/locations',
                headers: { 'Content-Type': 'application/json' },
                data: $scope.newLocation
            }).success(function () {
                $scope.showAlert('Success', 'Location has been created successfully.');
                $scope.newLocation = {}; // Clear the form
                $scope.loadLocations(); // Load Locations
                $scope.toggleForm(); // Close form
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating the location: ' + msg);
            });
        };

        // Load on Edit Location
        $scope.editLocationLoad = function (selectedLocation) {
            $scope.selectedLocation = selectedLocation;
            // Load the Location's region to the dropdown
            $scope.locationData = {
                text: selectedLocation.parent,
                data: {
                    id: selectedLocation.parentId
                }
            };
        }

        $scope.loadNotifications = function () {
            $http.get('api/v2/eventnotice/list', $scope.config).then(function (response) {
                if (response.data) {
                    $scope.notifications = response.data;
                }
            });
            $scope.notificationStatus();
            $scope.loadUeis();
            $scope.loadPaths();
            $scope.ugrLoad();
        }

        $scope.notificationStatusText = function() {
            if ('On' == $scope.noticeStatus) {
                return 'Disable';
            } else if ('Off' == $scope.noticeStatus) {
                return 'Enable';
            }
        }

        $scope.notificationStatus = function () {
            $http.get('api/v2/eventnotice/status', $scope.config).then(function (response) {
                if (response.data) {
                    $scope.noticeStatus = response.data.status;
                    //console.log($scope.ueis);
                }
            });
        }

        $scope.updateNotifDStatus = function () {
            if ('On' == $scope.noticeStatus) {
                $scope.noticeStatus = 'Off';
            } else if ('Off' == $scope.noticeStatus) {
                $scope.noticeStatus = 'On';
            }
            $http({
                method: 'POST',
                url: 'api/v2/eventnotice/notice/'+$scope.noticeStatus,
                headers: { 'Content-Type': 'application/json' },
                data: null
            }).success(function () {
                //$scope.showAlert('Success', 'The facility has been created successfully.');
                $scope.notificationStatus();
               // $scope.toggleForm();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating the facility: ' + msg);
            });
        };

        $scope.loadDestinationPaths = function () {
            $http.get('api/v2/eventnotice/pathd', $scope.config).then(function (response) {
                if (response.data) {
                    $scope.notifications = response.data;
                }
            });

            $scope.loadUeis();
            $scope.loadPaths();
            $scope.ugrLoad();
        }

        $scope.loadUeis = function () {
            $http.get('api/v2/eventnotice/ueis?vend=keywest', $scope.config).then(function (response) {
                if (response.data) {
                    $scope.ueis = response.data;
                    console.log($scope.ueis);
                }
            });
        }

        $scope.loadPaths = function () {
            $http.get('api/v2/eventnotice/pathd', $scope.config).then(function (response) {
                if (response.data) {
                    $scope.paths = response.data;
                    console.log($scope.paths);
                }
            });
        }


        $scope.createnotification = function () {
            $scope.newnotification.uei = $scope.newnotification.uei.key;
            $scope.newnotification.path = $scope.newnotification.path.name;
            $http({
                method: 'POST',
                url: 'api/v2/eventnotice/add',
                headers: { 'Content-Type': 'application/json' },
                data: $scope.newnotification
            }).success(function () {
                $scope.showAlert('Success', 'The facility has been created successfully.');
                $scope.newnotification = {};
                $scope.toggleForm();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating the facility: ' + msg);
            });
        };


        $scope.updateNotificationStatus = function (notice,status) {
            console.log(notice.name + ' ' + status);
            $http({
                method: 'POST',
                url: 'api/v2/eventnotice/notice/' + notice.name + '/' + notice.status,
                headers: { 'Content-Type': 'application/json' },
                data: null
            }).success(function () {
                $scope.showAlert('Success', 'The facility has been created successfully.');
                $scope.newnotification = {};
                $scope.toggleForm();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating the facility: ' + msg);
            });
        };



        $scope.deleteNotice = function (notice) {
            $http({
                method: 'POST',
                url: 'api/v2/eventnotice/delete/'+notice.name,
                headers: { 'Content-Type': 'application/json' },
                data: null
            }).success(function () {
                $scope.showAlert('Success', 'The facility has been created successfully.');
                $scope.selectedDef = {};
                $scope.loadNotifications();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating the facility: ' + msg);
            });
        };

        $scope.updatenotification = function (oldConfig) {
                $http({
                    method: 'POST',
                    url: 'api/v2/eventnotice/add',
                    headers: { 'Content-Type': 'application/json' },
                    data: oldConfig
                }).success(function () {
                    $scope.showAlert('Success', 'The facility has been created successfully.');
                    $scope.selectedDef = {};
                    $scope.toggleForm();
                }).error(function (msg) {
                    $scope.showAlert('Error', 'Error creating the facility: ' + msg);
                });
            };

        $scope.createPath = function () {
            $http({
                method: 'POST',
                url: 'api/v2/eventnotice/path/add',
                headers: { 'Content-Type': 'application/json' },
                data: $scope.newPath
            }).success(function () {
                $scope.showAlert('Success', 'The facility has been created successfully.');
                $scope.newPath =
                {
                    "name": "",
                    "initialDelay": "0s",
                    "initialTargets": [],
                    "escalations": []
                };
                $scope.toggleForm();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating the facility: ' + msg);
            });
        };
        $scope.updatePath = function (v) {
            $scope.newPath = JSON.parse(v);
            $scope.pathText="Update";
        };

        $scope.deletePath = function (v) {
            path = JSON.parse(v);
            pathText="Create";
            //console.log($scope.editPath);
            $http({
                method: 'POST',
                url: 'api/v2/eventnotice/path/delete/'+path.name,
                headers: { 'Content-Type': 'application/json' },
                data: null
            }).success(function () {
                $scope.showAlert('Success', 'The facility has been created successfully.');
                $scope.newPath =
                {
                    "name": "",
                    "initialDelay": "0s",
                    "initialTargets": [],
                    "escalations": []
                };
                $scope.loadPaths();
                $scope.toggleForm();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating the facility: ' + msg);
            });
        };

        $scope.ugrLoad = function () {
            // Generate URL config

            $http.get('api/v2/eventnotice/ugrlist', $scope.config).then(function (response) {
                if (response.data) {
                    $scope.ugr = response.data;

            }});
        }



        $scope.addEscalation = function($event) {
            var us = $scope.ugr.users;
                           var parentEl = angular.element(document.body);
                           $mdDialog.show({
                             parent: parentEl,
                             targetEvent: $event,
                             template:
                                    '<md-dialog style="min-width:300px;min-height:240px;" aria-label="List dialog"><md-dialog-content>' +
                                    '<div class="card-header bg-info sub-header card-mb-a"> Target</div>' +
                                    '<div class="form-group" style="width:50%;padding-left:20px;"><label class="control-label">Initial Delay</label>' +
                                    '<div><select class="form-control" data-ng-model="newTarget.initialDelay" ng-options="delay as delay for delay in pathDelays"></select></div>'+
                                    '</div>' +
                                    '<div class="form-group" style="width:100%;padding-left:20px;">' +
                                    '<div class="row">' +
                                    '<div class="col-md-6"><label class="control-label">Users</label></div>' +
                                    '<div class="col-md-6"><label class="control-label">Groups</label></div>' +
                                    '<div class="col-md-6">' +
                                    '<div class="form-group">' +
                                    '<select multiple  data-ng-model="newTarget.users" size="4" style=width:125px;><option data-ng-repeat="user in usr.users" value="{{user}}">{{user}}</option></select>'+
                                    '</div>' +
                                    '</div>' +
                                    '<div class="col-md-6">' +
                                    '<div class="form-group">' +
                                    '<select multiple data-ng-model="newTarget.groups" size="4" style=width:125px;><option data-ng-repeat="user in usr.groups" value="{{user}}">{{user}}</option></select>' +
                                    '</div>' +
                                    '</div>' +
                                    '</div>' +
                                    '</div>'+
                                    '<div class="card-header bg-info sub-header card-mb-a"> </div>' +
                                    '<div class="row"><div class="col-md-8"></div><div class="col-md-2"><center><button class="btn btn-primary" data-ng-click="addTarget()">Add</button></center>' +
                                    '</div><div class="col-md-2"><center><button class="btn btn-primary" data-ng-click="closeDialog()">Close</button></center></div></div>' +
                                    '</md-dialog-content></md-dialog>',
                             locals: {
                               items: $scope.ugr,
                               idelay: $scope.pathDelays
                             },
                             controller: DialogController
                          });
                          function DialogController($scope, $mdDialog, items,idelay) {
                              $scope.usr = items;
                              $scope.pathDelays = idelay;
                              $scope.newTarget = {
                                  "initialDelay":"0s",
                                  "users":[],
                                  "groups":[],
                              }
                              $scope.addTarget = function() {
                                  console.log("add Target"+$scope.newTarget);
                                  addEscalation($scope.newTarget);
                                  $mdDialog.hide();
                                  //$scope.newPath.initialTargets.push()
                              }
                              $scope.closeDialog = function() {
                                $mdDialog.hide();
                              }
                            }
        }

        $scope.showInitialTargets = function($event) {
            var us = $scope.ugr.users;
                           var parentEl = angular.element(document.body);
                           $mdDialog.show({
                             parent: parentEl,
                             targetEvent: $event,
                             template:
                                    '<md-dialog style="min-width:300px;min-height:240px;" aria-label="List dialog"><md-dialog-content>' +
                                    '<div class="card-header bg-info sub-header card-mb-a"> Target</div>' +
                                    '<div class="form-group" style="width:50%;padding-left:20px;"><label class="control-label">Initial Delay</label>' +
                                    '<div><select class="form-control" data-ng-model="newTarget.initialDelay" ng-options="delay as delay for delay in pathDelays"></select></div>'+
                                    '</div>' +
                                    '<div class="form-group" style="width:100%;padding-left:20px;">' +
                                    '<div class="row">' +
                                    '<div class="col-md-6"><label class="control-label">Users</label></div>' +
                                    '<div class="col-md-6"><label class="control-label"></label></div>' +
                                    '<div class="col-md-6">' +
                                    '<div class="form-group">' +
                                    '<select multiple  data-ng-model="newTarget.users" size="4" style=width:125px;><option data-ng-repeat="user in usr.users" value="{{user}}">{{user}}</option></select>'+
                                    '</div>' +
                                    '</div>' +
                                    '<div class="col-md-6">' +
                                    '<div class="form-group">' +
                                    /*'<select multiple data-ng-model="newTarget.groups" size="4" style=width:125px;><option data-ng-repeat="user in usr.groups" value="{{user}}">{{user}}</option></select>' +*/
                                    '</div>' +
                                    '</div>' +
                                    '</div>' +
                                    '</div>'+
                                    '<div class="card-header bg-info sub-header card-mb-a"> </div>' +
                                    '<div class="row"><div class="col-md-6"></div><div class="col-md-2"><center><button class="btn btn-primary" data-ng-click="addTarget()">Add</button></center>' +
                                    '</div><div class="col-md-2"><center><button class="btn btn-primary" data-ng-click="closeDialog()">Close</button></center></div></div>' +
                                    '</md-dialog-content></md-dialog>',
                             locals: {
                               items: $scope.ugr,
                               idelay: $scope.pathDelays
                             },
                             controller: DialogController
                          });
                          function DialogController($scope, $mdDialog, items,idelay) {
                            $scope.usr = items;
                            $scope.pathDelays = idelay;
                            $scope.newTarget = {
                                "initialDelay":"0s",
                                "users":[],
                                "groups":[],
                            }
                            $scope.addTarget = function() {
                                console.log("add Target"+$scope.newTarget);
                                addTarget($scope.newTarget);
                                $mdDialog.hide();
                                //$scope.newPath.initialTargets.push()
                            }
                            $scope.closeDialog = function() {
                              $mdDialog.hide();
                            }
                          }
        }

        function addTarget(trgt) {
            console.log("called from popup");
            var escalation = {
                "delay":trgt.initialDelay,
                "targets":[]
            }
            var users = trgt.users;
            for(var i = 0; i < users.length; i++) {
                var target = {
                                "autoNotify":"on",
                                "interval":"0s",
                                "name":users[i],
                                "commands": ["javaEmail"]
                            } ;
                 $scope.newPath.initialTargets.push(target);
            }
            /*var groups = trgt.groups;
            for(var i = 0; i < groups.length; i++) {
                var target = {
                                "autoNotify":"on",
                                "interval":"5m",
                                "name":groups[i],
                                "commands": ["javaEmail"]
                            } ;
                escalation.targets.push(target);
            }
            $scope.newPath.initialTargets.push(escalation);*/
        }

        function addEscalation(trgt) {
            console.log("called from popup");
            var escalation = {
                "delay":trgt.initialDelay,
                "targets":[]
            }
            var users = trgt.users;
            for(var i = 0; i < users.length; i++) {
                var target = {
                                "autoNotify":"on",
                                "interval":"0s",
                                "name":users[i],
                                "commands": ["javaEmail"]
                            } ;
                 escalation.targets.push(target);
            }
            var groups = trgt.groups;
            for(var i = 0; i < groups.length; i++) {
                var target = {
                                "autoNotify":"on",
                                "interval":"5m",
                                "name":groups[i],
                                "commands": ["javaEmail"]
                            } ;
                escalation.targets.push(target);
            }
            $scope.newPath.escalations.push(escalation);
        }
        // Selected Location
        $scope.selectedLoc = function (selLoc) {
            $scope.locationData = {
                text: selLoc.text,
                data: {
                    id: selLoc.data.id
                }
            };
        }

        // Save in Edit Location
        $scope.editLocation = function (selectedLocationId) {
            $scope.selectedLocation.parent = $scope.locationData.data.id;
            delete $scope.selectedLocation.parentId;  // Delete the property
            $http({
                method: 'PUT',
                url: 'api/v2/locations/' + selectedLocationId,
                headers: { 'Content-Type': 'application/json' },
                data: $scope.selectedLocation
            }).success(function () {
                $scope.showAlert('Success', 'The Location has been updated successfully.');
                $scope.selectedLocation = {};
                $scope.loadLocations();
                $scope.toggleForm();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error updating the location: ' + msg);
            });
        };

        // Delete Location Modal
        $scope.deleteLocationModal = function (locationId, locationName, ev) {
            $scope.toggleForm();
            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Are you sure you want to delete this location?')
                /*.textContent('Facilities associated with this locations will also be deleted.')*/
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No');
            // If selected yes
            $mdDialog.show(confirm).then(function () {
                $scope.deleteLocation(locationId, locationName);
            });
        };

        // Delete Location
        $scope.deleteLocation = function (locationId, locationName) {
            // Check if the selected location is default location
            if (locationName != 'DefaultLocation') {
                $http({
                    method: 'DELETE',
                    url: 'api/v2/locations/' + locationId
                }).success(function () {
                    $scope.showAlert('Success', 'The location has been deleted successfully.');
                    $scope.loadLocations();
                }).error(function (response,msg) {
                    if (msg == 412) {
                        $scope.showAlert('Warning', locationName + ' Location contains one or more facilities.  Delete facilities containing in '+ locationName + ' before deleting.');
                    } else if (msg == 403) {
                      $scope.showAlert('Warning', 'User is forbidden for delete operation');
                  } else {
                        $scope.showAlert('Error', 'Error deleting the location: ' + msg);
                    }
                });
            } else {
                $scope.showAlert('Error', 'Unable to delete location: ' + regionName);
            }
        }

        // Load Facilities
        $scope.loadFacilities = function () {
            // Generate URL config
            $scope.config = {
                params: {
                    '_s': "",
                    'limit': $scope.pagesize,
                    'offset': (($scope.currentpage - 1) * $scope.pagesize),
                    'orderBy': $scope.sortField,
                    'order': $scope.sortOrder
                }
            };
            $http.get('api/v2/facilities', $scope.config).then(function (response) {
                if (response.data) {
                    $scope.facilities = response.data.facility;
                    // Pagination button condition
                    if (response.data.facility.length < $scope.pagesize) {
                        $scope.nextBtnDisable = true;
                    } else {
                        $scope.nextBtnDisable = false;
                    }
                }
            });
        }

        // On region change, load locations of selected region
        $scope.regionChange = function (region) {
            if ($scope.newFacility.region) {
                $scope.newFacility.region.id = '';
                $scope.regionLocations = "";
            }

            var url = 'api/v2/treeview/regions/' + region.data.id + '/locations';
            $http.get(url).then(function (response) {
                if (response.data) {
                    $scope.regionLocations = response.data;
                }
            });
        }

        // On location change, load facilities of selected location
        $scope.locationChange = function (location) {

            $scope.newFacility.region.id = location.data.id
        }

        // Create Facility
        $scope.createFacility = function () {
            /*if (!$scope.newFacility.region) {
                $scope.newFacility['region'] = $scope.location;
            }*/
            $http({
                method: 'POST',
                url: 'api/v2/facilities',
                headers: { 'Content-Type': 'application/json' },
                data: $scope.newFacility
            }).success(function () {
                $scope.showAlert('Success', 'The facility has been created successfully.');
                //$scope.newFacility = {};
                $scope.allRegions = [];
                //$scope.regionLocations = [];
                $scope.loadFacilities();
                $scope.toggleForm();
                $scope.newFacility = {
                    'region': {
                        'id': ''
                    }
                };
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating the facility: ' + msg);
            });
        };

        // Load on Edit Facility
        $scope.editFacilityLoad = function (selectedFacility) {
            $scope.selectedFacility = selectedFacility;
            // Bind Facility's region
            $scope.regionData = {
                text: selectedFacility.regionName,
                data: {
                    id: selectedFacility.regionId
                }
            };
            // Bind Facility's location
            $scope.locationData = {
                text: selectedFacility.locationName,
                data: {
                    id: selectedFacility.locationId
                }
            };
        }

        // Save in Edit Facility
        $scope.editFacility = function (selectedFacilityId) {
            //$scope.selectedFacility.region = {};
            // Delete unwanted properties in the selected facility
            //delete $scope.selectedFacility.regionId;
            //delete $scope.selectedFacility.regionName;
            //delete $scope.selectedFacility.locationId;
            //delete $scope.selectedFacility.locationName;
            if ($scope.newFacility.region.id && $scope.newFacility.region.id.length != 0) {
                $scope.selectedFacility.locationId = $scope.newFacility.region.id;
            } /*else {
                $scope.selectedFacility.region.id = $scope.selectedFacility.locationId;
            }*/
            $scope.updatedFacility = {
                "id": 35,
                "latitude": "44.6",
                "locationId": 2,
                "locationName": "DefaultLocation",
                "longitude": "33.4",
                "name": "Facility2",
                "regionId": 1,
                "regionName" : "DefaultRegion"
            }


            $http({
                method: 'POST',
                url: 'api/v2/facilities/update',
                headers: { 'Content-Type': 'application/json' },
                data: $scope.selectedFacility
            }).success(function () {
                $scope.showAlert('Success', 'The Facility has been updated successfully.');
                $scope.selectedFacility = {};
                $scope.loadFacilities();
                $scope.toggleForm();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error updating the facility: ' + msg);
            });
        };

        // Delete Facility Modal
        $scope.deleteFacilityModal = function (facilityId, facilityName, ev) {
            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Are you sure you want to delete this facility?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No');
                // When clicked on Ok
            $mdDialog.show(confirm).then(function () {
                $scope.deleteFacility(facilityId, facilityName);
            });
        };

        // Delete Facility
        $scope.deleteFacility = function (facilityId, facilityName) {
        // Check if the selected facility is Default Facility
            if (facilityName != 'DefaultFacility') {
                $http({
                    method: 'DELETE',
                    url: 'api/v2/facilities/' + facilityId
                }).success(function () {
                    $scope.showAlert('Success', 'The facility has been deleted successfully.');
                    $scope.loadFacilities();
                }).error(function (response,errorCode) {
                    if (errorCode == 412) {
                        $scope.showAlert('Warning', facilityName + ' Facility contains devices.  Move devices to different facility before deleting.');
                    } else if (errorCode == 403) {
                          $scope.showAlert('Warning', 'User is forbidden for delete operation');
                      } else {
                        $scope.showAlert('Error', 'Error deleting the facility: ' + msg);
                    }

                });
            } else {
                $scope.showAlert('Error', 'Unable to delete facility: ' + facilityName);
            }
        }

        // Load Facilities
        $scope.loadUsers = function () {
            // Generate URL config
            $scope.config = {
                params: {
                    'limit': $scope.pagesize,
                    'offset': (($scope.currentpage - 1) * $scope.pagesize),
                    'sort': $scope.sortOrder
                }
            };
            $http.get('rest/users/list', $scope.config).then(function (response) {
                if (response.data) {
                    $scope.users = response.data.users;
                    // Pagination button condition
                    if (response.data.users.length < $scope.pagesize) {
                        $scope.nextBtnDisable = true;
                    } else {
                        $scope.nextBtnDisable = false;
                    }
                }
            });
        }

        $scope.loadGroups = function () {
            $http.get('rest/groups', $scope.config).then(function (response) {
                if (response.data) {
                    $scope.groups = response.data.group;
                    $q.when($scope.groups);
                }
            });
        }


        $scope.loadSnmpConfig = function () {
            $http.get('api/v2/nodelinks/snmpconfig?begin=&end=').then(function (response) {
                if (response.data) {
                    $scope.snmpConfig = response.data;
                    $scope.snmpConfig.version = {
                        snmpVersion: response.data.version
                    }
                    $q.when($scope.snmpConfig);
                }
            });

        }

        $scope.loadThresholds = function () {
            $scope.thresholds = [];
            $http.get('api/v2/threshold/list').then(function (response) {
                if (response.data) {
                    //$scope.thresholds = response.data;
                    var data = response.data;
                    if (data.thresholds) {
                        for (var i = 0; i< data.thresholds.length; i++) {
                            data.thresholds[i]['ltype'] = 'threshold';
                            data.thresholds[i]['index'] = i;
                            $scope.thresholds.push(data.thresholds[i]);
                        }
                    }
                    if (data.expressions) {
                        for (var i = 0; i< data.expressions.length; i++) {
                            data.expressions[i]['ltype'] = 'expression';
                            data.expressions[i]['index'] = i;
                            $scope.thresholds.push(data.expressions[i]);
                        }
                    }
                    $q.when($scope.thresholds);
                }
            });

        }


        $scope.reloadServerConfiguration = function () {
            $http.get('api/v2/threshold/reload').then(function (response) {
                /*if (response.data) {
                    $scope.thresholds = response.data;
                    $q.when($scope.thresholds);
                }*/
            });

        }



        $scope.snmpVersionArray = [{
            "snmpVersion": "v1",
            "snmpVersionVal": "SNMPv1"
        }, {
            "snmpVersion": "v2c",
            "snmpVersionVal": "SNMPv1-v2c"
        }];

        $scope.createnewSnmp = function() {
            console.log("update default SNMP");
            var ver = $scope.newsnmp.version;
            $scope.newsnmp.version = ver.snmpVersion;
            $http({
                method: 'POST',
                url: 'api/v2/nodelinks/udefinition',
                headers: {
                    'Content-Type': 'application/json'
                },
                data: $scope.newsnmp
            }).success(function() {
                $scope.showAlert('Success', 'Created successfully.');
            }).error(function(msg) {
                $scope.showAlert('Error', 'Error creating Data: ' + msg);
            });
            $scope.snmpConfig = {};
            $scope.loadSnmpConfig();
            $scope.toggleToDefault();
            $scope.newsnmp = {}
        }

        $scope.editsnmp = function(selDef) {
            var ver = selDef.version;
            selDef.version = ver.snmpVersion;
            console.log("update default SNMP" + selDef);
            $http({
                method: 'POST',
                url: 'api/v2/nodelinks/udefinition',
                headers: {
                    'Content-Type': 'application/json'
                },
                data: selDef
            }).success(function() {
                $scope.showAlert('Success', 'Created successfully.');
                $scope.snmpConfig.definition = [];
                $scope.loadSnmpConfig();
                $scope.toggleToDefault();
            }).error(function(msg) {
                $scope.showAlert('Error', 'Error creating Data: ' + msg);
                $scope.toggleToDefault();
            });

        }

        $scope.updatethreshold = function(selDef, ev) {
            if ($scope.thresholdIndex == -1) {
                return;
            }
            if ($scope.thresholdlType == -1) {
                return;
            }
            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Modifying the changes require reloading of threshold configuration. Are you sure you want to apply this changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No');
            $mdDialog.show(confirm).then(function () {
                $http({
                    method: 'POST',
                    url: 'api/v2/threshold/update/' + $scope.thresholdlType + '/'+ $scope.thresholdIndex,
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: selDef
                }).success(function() {
                    $scope.showAlert('Success', 'Created successfully.');
                    //$scope.snmpConfig.definition = [];
                    $scope.loadThresholds();
                    $scope.toggleForm();
                }).error(function(msg) {
                    $scope.showAlert('Error', 'Error creating Data: ' + msg);
                    $scope.toggleForm();
                });
            });


        }


        // Create User
        // Uses XML instead of JSON format
        // Need to format the body in XML
        $scope.createUser = function () {
            $scope.newUser.password= $scope.resetPassword($scope.newUser.password);
            $http({
                method: 'POST',
                url: 'rest/users',
                headers: { 'Content-Type': 'application/xml' },
                data: '<user>' +
                    '<user-id>' + $scope.newUser.username + '</user-id>' +
                    '<password>' + $scope.newUser.password + '</password>' +
                    '<full-name>' + $scope.newUser.fullName + '</full-name>' +
                    '<region-id>' + $scope.newUser.regionId + '</region-id>' +
                    '<email>' + $scope.newUser.email + '</email>' +
                    '<role>' + $scope.newUser.roleData + '</role>' +
                    '</user>'
            }).success(function () {
                $scope.showAlert('Success', 'The user has been created successfully.');
                $scope.newUser = {};
                $scope.loadUsers();
                $scope.toggleForm();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating the user: ' + msg);
            });
        };

        $scope.createGroup = function () {
            $http({
                method: 'POST',
                url: 'rest/groups',
                headers: { 'Content-Type': 'application/json' },
                data: $scope.newGroup
            }).success(function () {
                $scope.showAlert('Success', 'The user has been created successfully.');
                $scope.newGroup = {};
                $scope.loadGroups();
                $scope.toggleForm();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating the user: ' + msg);
            });
        };

        $scope.updateGroup = function () {
            $http({
                method: 'POST',
                url: 'rest/groups',
                headers: { 'Content-Type': 'application/json' },
                data: $scope.selectedGroup
            }).success(function () {
                $scope.showAlert('Success', 'The user has been created successfully.');
                $scope.newGroup = {};
                $scope.loadGroups();
                $scope.toggleForm();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error creating the user: ' + msg);
            });
        };

        $scope.addUserGrp = function(usr) {
            //$newGroup.users
            console.log(usr);
            for (var i = 0; i < usr.length; i++) {
                if ($scope.newGroup.user) {
                    var inde = $scope.newGroup.user.indexOf(usr[i]);
                    if ( inde === -1) {
                        $scope.newGroup.user.push(usr[i]);
                    }
                } else {
                    $scope.newGroup['user'] = [];
                    $scope.newGroup.user.push(usr[i]);
                }
            }

        }

        $scope.remUserGrpAdd = function(usr) {
            var removeList=[];
            for (var i = 0; i < usr.length; i++) {
                var j = 0;
                while(j < $scope.newGroup.user.length) {
                    if ($scope.newGroup.user[j] == usr) {
                        $scope.newGroup.user.splice(j,1);
                    } else {
                        ++j;
                    }
                }
            }
        }

        $scope.remUserGrp = function(usr) {
            var removeList=[];
            for (var i = 0; i < usr.length; i++) {
                var j = 0;
                while(j < $scope.selectedGroup.user.length) {
                    if ($scope.selectedGroup.user[j] == usr) {
                        $scope.selectedGroup.user.splice(j,1);
                    } else {
                        ++j;
                    }
                }
            }
        }

        $scope.edituserGrp = function(usr) {
                    //$newGroup.users
            console.log(usr);
            for (var i = 0; i < usr.length; i++) {
                if ($scope.selectedGroup.user) {
                    var inde = $scope.selectedGroup.user.indexOf(usr[i]);
                    if (inde == -1) {
                        $scope.selectedGroup.user.push(usr[i]);
                    }
                } else {
                    $scope.selectedGroup['user'] = [];
                    $scope.selectedGroup.user.push(usr[i]);
                }
            }

        }

        // Load on Edit User
        $scope.editUserLoad = function (selectedUser) {
            $scope.selectedUser = selectedUser;
            $scope.repeatPass = $scope.selectedUser.password;
            $scope.locationData = {
                text: selectedUser['region-name'],
                data: {
                    id: selectedUser['region-id']
                }
            };
            $scope.selectedUser.roleData = selectedUser.role;
        }

        // When region is changed in User form
        $scope.regChangeforUsers = function (selectedRegVal) {
            $scope.locationData = {
                text: selectedRegVal.text,
                data: {
                    id: selectedRegVal.data.id
                }
            };
        }

        // Save in Edit User
        // Uses XML instead of JSON format
        // Need to format the body in XML
        $scope.editUser = function (selectedUserId) {           
            $scope.selectedUser['region-id'] = $scope.locationData.data.id;
            var pwd = $scope.selectedUser.password;
            if ($scope.selectedUser.password == undefined) {
                pwd = '';
            }
            //$scope.newUser.password= $scope.resetPassword($scope.newUser.password);
            var obj = '<user>' +
                '<user-id>' + $scope.selectedUser['user-id'] + '</user-id>' +
                '<password>' + pwd + '</password>' +
                '<full-name>' + $scope.selectedUser['full-name'] + '</full-name>' +
                '<region-id>' + $scope.selectedUser['region-id'] + '</region-id>' +
                '<email>' + $scope.selectedUser.email + '</email>' +
                '<role>' + $scope.selectedUser.roleData + '</role>' +
                '</user>';
            $http({
                method: 'PUT',
                url: 'rest/users/' + selectedUserId,
                headers: { 'Content-Type': 'application/xml' },
                data: obj
            }).success(function () {
                $scope.showAlert('Success', 'The User has been updated successfully.');
                $scope.selectedUser = {};
                $scope.loadUsers();
                $scope.toggleForm();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error updating the User: ' + msg);
            });
        };

        // Delete User Modal
        $scope.deleteUserModal = function (userName, ev) {
            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Are you sure you want to delete this user?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No');
                // When user selected "Yes"
            $mdDialog.show(confirm).then(function () {
                $scope.deleteUser(userName);
            });
        };

        // Delete User
        $scope.deleteUser = function (selectedUserId) {
            $http({
                method: 'DELETE',
                url: 'rest/users/' + selectedUserId['user-id']
            }).success(function () {
                $scope.showAlert('Success', 'The user has been deleted successfully.');
                $scope.loadUsers();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error deleting the user: ' + msg);
            });
        }

        $scope.deleteGroupModal = function (groupName, ev) {
                    var confirm = $mdDialog.confirm({
                        onComplete: function afterShowAnimation() {
                            var $dialog = angular.element(document.querySelector('md-dialog'));
                            var $actionsSection = $dialog.find('md-dialog-actions');
                            var $cancelButton = $actionsSection.children()[0];
                            var $confirmButton = $actionsSection.children()[1];
                            angular.element($confirmButton).removeClass('md-focused');
                            angular.element($cancelButton).addClass('md-focused');
                            $cancelButton.focus();
                        }
                    })
                        .title('Are you sure you want to delete this group?')
                        .targetEvent(ev)
                        .ok('Yes')
                        .cancel('No');
                        // When user selected "Yes"
                    $mdDialog.show(confirm).then(function () {
                        $scope.deleteGroup(groupName);
                    });
                };

                // Delete User
                $scope.deleteGroup = function (groupid) {
                    $http({
                        method: 'DELETE',
                        url: 'rest/groups/' + groupid
                    }).success(function () {
                        $scope.showAlert('Success', 'The grouop has been deleted successfully.');
                        $scope.loadGroups();
                    }).error(function (msg) {
                        $scope.showAlert('Error', 'Error deleting the group: ' + msg);
                    });
                }

        //Load Server Configurations
        $scope.loadConfigs = function () {
            var paramObj = { 'params': { 'limit': 0 } };
            $http.get('api/v2/systemprops/list', paramObj)
                .then(function (response) {
                    if (response.data) {
                        //                console.log(response.data);
                        $scope.sConfig = response.data;
                        if ($scope.sConfig.isftp != null && $scope.sConfig.isftp == 'true') {
                            $scope.sConfig.isftp = true;
                        } else {
                            $scope.sConfig.isftp = false;
                        }
                        //$scope.isFtp
                        $rootScope.metrics = response.data.metrics;
                    }
                });
        }

        $scope.loadMailConfig = function () {
            //var paramObj = { 'params': { 'limit': 0 } };
            $http.get('api/v2/eventnotice/mail')
                .then(function (response) {
                    if (response.data) {
                        $scope.javaEmail = response.data;
                    }
                });
        }

        // Update Server Configuration Modal
        $scope.updateMailConfig = function (sConfig, ev) {
            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Are you sure you want to apply this changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No');
                //When clicked on "Yes"
            $mdDialog.show(confirm).then(function () {
                $scope.updateMailConfigDet(sConfig);
            });
        };

        $scope.updateMailConfigDet = function (sConfig) {
            $scope.javaEmail.authPwd = $scope.resetPassword($scope.javaEmail.authPwd);
            $http({
                method: 'POST',
                url: 'api/v2/eventnotice/mail/update',
                headers: { 'Content-Type': 'application/json' },
                data: $scope.javaEmail
            }).success(function () {
                $scope.showAlert('Success', 'The system property has been updated successfully.');
                $scope.sConfig = {};
                $scope.loadConfigs();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error updating the system property: ' + msg);
            });
        };

        // Update Server Configuration Modal
        $scope.editConfigModal = function (sConfig, ev) {

            var confirm = $mdDialog.confirm({
                onComplete: function afterShowAnimation() {
                    var $dialog = angular.element(document.querySelector('md-dialog'));
                    var $actionsSection = $dialog.find('md-dialog-actions');
                    var $cancelButton = $actionsSection.children()[0];
                    var $confirmButton = $actionsSection.children()[1];
                    angular.element($confirmButton).removeClass('md-focused');
                    angular.element($cancelButton).addClass('md-focused');
                    $cancelButton.focus();
                }
            })
                .title('Are you sure you want to apply this changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No');
                //When clicked on "Yes"
            $mdDialog.show(confirm).then(function () {
                $scope.editConfig(sConfig);
            });
        };

        // Update Server Configuration
        $scope.editConfig = function (sConfig) {
            $scope.sConfig.traphostpwd = $scope.resetPassword($scope.sConfig.traphostpwd);
            //$scope.sConfig.password = $scope.resetPassword($scope.sConfig.password);
            $http({
                method: 'POST',
                url: 'api/v2/systemprops/update',
                headers: { 'Content-Type': 'application/json' },
                data: $scope.sConfig
            }).success(function () {
                $scope.showAlert('Success', 'The system property has been updated successfully.');
                $scope.sConfig = {};
                $scope.loadConfigs();
            }).error(function (msg) {
                $scope.showAlert('Error', 'Error updating the system property: ' + msg);
            });
        };

        // Show Alert function for controller
        $scope.showAlert = function (msgType, msg, ev) {
            $mdDialog.show(
                $mdDialog.alert()
                    .parent(angular.element(document.querySelector('#popupContainer')))
                    .clickOutsideToClose(true)
                    .title(msgType)
                    .textContent(msg)
                    .ariaLabel('Alert')
                    .ok('OK')
                    .targetEvent(ev)
            );
        };


        $scope.changeMetrics = function(metric) {
            console.log(metric);
        }

        $scope.showRearm = function(value) {
            if (value == 'ABSOLUTE_CHANGE' || value == 'RELATIVE_CHANGE') {
                return false;
            }
            return true;
        }

        // Accordion Function
        $(document).ready(function () {
            $("#accordian a").click(function () {
                var link = $(this);
                var closest_ul = link.closest("ul");
                var parallel_active_links = closest_ul.find(".active")
                var closest_li = link.closest("li");
                var link_status = closest_li.hasClass("active");
                var count = 0;

                closest_ul.find("ul").slideUp(function () {
                    if (++count == closest_ul.find("ul").length)
                        parallel_active_links.removeClass("active");
                });
                if (!link_status) {
                    closest_li.children("ul").slideDown();
                    closest_li.addClass("active");
                }
            })
            $('.activeItem').click(function (e) {
                $('.activeItem').css("background-color", "white", "color", "black");
                $(this).css("background-color", "#f6f6f6", "color", "white", "font-weight", "bold");
            });
        })

    }]);

    dashboard.directive("compareTo", function ()

      {

          return {

              require: "ngModel",

              scope:

              {

                  repeatPassword: "=compareTo"

              },

              link: function (scope, element, attributes, paramval)

              {

                  paramval.$validators.compareTo = function (val)

                  {

                      return val == scope.repeatPassword;

                  };

                  scope.$watch("repeatPassword", function ()

                  {

                      paramval.$validate();

                  });

              }

          };

      });
