dashboard.controller("SNMPProfileConfigController", ['$rootScope', '$scope', '$mdDialog', '$http', '$state', '$location', 'dashboardService', 'Flash',
    function($rootScope, $scope, $mdDialog, $http, $state, $location, dashboardService, Flash) {

        //this is default width
        $scope.tableWidth = "col-md-12";
           /* $scope.snmpVersionArray = [{
                "version": 1,
                "versionVal": "Enable"
            }, {
                "version": 2,
                "version": "Disable"
            }];*/


        $scope.defaultObj = {};


        $scope.snmpVersionArray = [
            {
                'name': "v1",
                'value': 'v1'
            }, {
                'name': "v2c",
                'value': 'any'
            }
        ];


        //radio mode
        $scope.radioMode = [{
            'name': "All",
            'value': -1
        }, {
            'name': "AP",
            'value': 1
        }, {
            'name': "SU",
            'value': 2
        }];
        //link types
        $scope.linkType = [{
            'name': "All",
            'value': -1
        }, {
            'name': "PTP",
            'value': 1
        }, {
            'name': "BackHaul",
            'value': 2
        }, {
            'name': "PTMP",
            'value': 3
        }];

        //from config controller to this method calling
        //if config controller click wireless this method initates
        $rootScope.$on("init_snmp", function() {

            $scope.init();
        });
        $scope.init = function() {

            $scope.defProfileObj = {};
            $scope.defProfileObj.versionName = '';
            $scope.defProfileObj.readPassword = '';
            $scope.defProfileObj.writePassword = '';

            if (!$rootScope.profileID) {

                $scope.snmpProfileObj = {};
                $scope.create_snmp_profile = true;
                $scope.edit_snmp_profile = false;

                $scope.defaultObj.rMode = $scope.radioMode[0];
                $scope.defaultObj.lType = $scope.linkType[0];
                $scope.snmpProfileObj.versionName=$scope.snmpVersionArray[1];

            } else {
                $scope.snmpProfileObj = {};
                $scope.mimoData = {};
                $scope.create_snmp_profile = false;
                $scope.edit_snmp_profile = true;
                var url = 'api/v2/profiles/template/get?profile=' + $rootScope.profileID;
                $http.get(url).then(function(response) {
                    $scope.snmpProfileObj.profileName = response.data.name;
                    $scope.defaultObj.rMode = {
                        value: response.data.radioMode
                    }
                    $scope.defaultObj.lType = {
                        value: response.data.linkType
                    }

                    $scope.snmpProfileObj.versionName = {
                        value:response.data.snmpdto.snmpVersion
                    }
                    $scope.snmpProfileObj.readPassword = response.data.snmpdto.readPassword;
                    $scope.snmpProfileObj.writePassword = response.data.snmpdto.writePassword;
                });
            }
        }
            //radionstatus array

        //close the selected form
        $scope.toggleForm = function() {
                $scope.$emit("toggleFormFunction");
        }

        $scope.removeProperty = function(propery) {
            console.log(propery);
            //propery = null;
            $scope.snmpProfileObj[propery] = null;
            $scope.defProfileObj[propery] = 'display:none;';
        }

            //post call for wireless profile
        $scope.createSNMPProfile = function() {
            var snmpObj = {
                "profileType": 7,
                "name": $scope.snmpProfileObj.profileName.split(" ").join(""),
                "radioMode": $scope.defaultObj.rMode ? $scope.defaultObj.rMode.value : null,
                "linkType": $scope.defaultObj.lType ? $scope.defaultObj.lType.value : null,
                "snmpdto": {
                    "radio": 0,
                    "nodeId": 0,
                    "status": 0,
                    "message": null,
                    "snmpVersion": $scope.snmpProfileObj.versionName.value,
                    "snmpStatus": null,
                    "hostAddress": null,
                    "hostPassword": null,
                    "readPassword": $scope.snmpProfileObj.readPassword,
                    "writePassword": $scope.snmpProfileObj.writePassword,
                }
            }

                //   hear is our service call
            var confirm = $scope.createConfirm();

            $mdDialog.show(confirm).then(function() {
                $http({
                    method: 'POST',
                    url: 'api/v2/profiles/template',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: snmpObj
                }).success(function() {
                    $scope.showAlert('Success', 'Saved successfully.');
                    $scope.snmpProfileObj = {};
                    $scope.ttype = 7;
                    $scope.$emit("defaultCall", $scope.ttype);
                    $scope.$emit("toggleFormFunction");
                    //$scope.init();
                    //$scope.init();
                }).error(function(msg) {
                    $scope.showAlert('Error', 'Error creating Data: ' + msg);
                });
            });

        }



            //update call for wireless profile
        $scope.updateSNMPProfile = function() {
            var snmpObj = {
                "profileType": 7,
                "name": $scope.snmpProfileObj.profileName.split(" ").join(""),
                "profileId": $rootScope.profileID,
                "radioMode": $scope.defaultObj.rMode ? $scope.defaultObj.rMode.value : null,
                "linkType": $scope.defaultObj.lType ? $scope.defaultObj.lType.value : null,
                "snmpdto": {
                    "radio": 0,
                    "nodeId": 0,
                    "status": 0,
                    "message": null,
                    "snmpVersion": $scope.snmpProfileObj.versionName.value,
                    "snmpStatus": null,
                    "hostAddress": null,
                    "hostPassword": null,
                    "readPassword": $scope.snmpProfileObj.readPassword,
                    "writePassword": $scope.snmpProfileObj.writePassword,
                }
            }

                    //   hear is our service call
                var confirm = $scope.saveconfirm();

                $mdDialog.show(confirm).then(function() {
                    $http({
                        method: 'POST',
                        url: 'api/v2/profiles/template/update',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        data: snmpObj
                    }).success(function() {
                        $scope.showAlert('Success', 'Updated successfully.');
                        $scope.ttype = 7;
                        $scope.$emit("defaultCall", $scope.ttype);
                        $scope.$emit("toggleFormFunction");
                    }).error(function(msg) {
                        $scope.showAlert('Error', 'Error updating Data: ' + msg);
                    });
                });

            }



            //  this method is used for removing undefined and null ke values from object
        function clean(obj) {
            for (var propName in obj) {
                if (obj[propName] === null || obj[propName] === undefined || obj[propName] === "") {
                    delete obj[propName];
                }
            }
            return obj;
        }
        //create conformation
        $scope.createConfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to create this profile?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };
        //update conformation
        $scope.saveconfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to update these changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };


    }
]);
