﻿dashboard.controller("SWNodeViewController", ['$localStorage', '$rootScope', '$scope', '$mdDialog', '$http', '$state', 'dashboardService', 'Flash', '$interval',
    function($localStorage, $rootScope, $scope, $mdDialog, $http, $state, dashboardService, Flash, $interval) {
        //$scope.callstore = $localStorage.teststore;
        var vm = this;
        $scope.vm.node = {};
        $scope.sdp = {};
        $scope.nodeViewTimer = null;
        $scope.responseReceived = true;
        $scope.provButtonLabel = "Provision"
        $scope.enableProvButton = 0;
        $scope.cpuBar = null;
        $scope.remoteIP = ""
        $scope.enableRemote = false;
        $scope.remoteId = null;
        $scope.rerender = "rerender";
        $scope.ifdata = [];
        $scope.ports = 4;
        $scope.portsdata = [[{"ifIndex":1101,"ifType":6,"ifSpeed":"0 Mb/sec","ifPhyAddress":"","ifOperStatus":"Up","ifMtu":"","duplex":"Auto","ifDesc":"Port 1/1/1","adminStatus":"Up","status":'#808080'},{"ifIndex":1102,"ifType":6,"ifSpeed":"0 Mb/sec","ifPhyAddress":"","ifOperStatus":"Down","ifMtu":"","duplex":"Auto","ifDesc":"Port 1/1/2","adminStatus":"Up","status":'#808080'},{"ifIndex":1103,"ifType":6,"ifSpeed":"0 Mb/sec","ifPhyAddress":"","ifOperStatus":"Down","ifMtu":"","duplex":"Auto","ifDesc":"Port 1/1/3","adminStatus":"Up","status":'#808080'},{"ifIndex":1104,"ifType":6,"ifSpeed":"0 Mb/sec","ifPhyAddress":"","ifOperStatus":"Down","ifMtu":"","duplex":"Auto","ifDesc":"Port 1/1/4","adminStatus":"Up","status":'#808080'}],[{"ifIndex":1201,"ifType":6,"ifSpeed":"0 Mb/sec","ifPhyAddress":"","ifOperStatus":"Down","ifMtu":"","duplex":"Auto","ifDesc":"Port 1/2/1","adminStatus":"Up","status":'#808080'},{"ifIndex":1202,"ifType":6,"ifSpeed":"0 Mb/sec","ifPhyAddress":"","ifOperStatus":"Down","ifMtu":"","duplex":"Auto","ifDesc":"Port 1/2/2","adminStatus":"Up","status":'#808080'},{"ifIndex":1203,"ifType":6,"ifSpeed":"0 Mb/sec","ifPhyAddress":"","ifOperStatus":"Down","ifMtu":"","duplex":"Auto","ifDesc":"Port 1/2/3","adminStatus":"Up","status":'#808080'},{"ifIndex":1204,"ifType":6,"ifSpeed":"0 Mb/sec","ifPhyAddress":"","ifOperStatus":"Down","ifMtu":"","duplex":"Auto","ifDesc":"Port 1/2/4","adminStatus":"Up","status":'#808080'}]];
    $scope.checkpaRoute = localStorage.getItem("modetype");
    if ($scope.checkpaRoute=='tmarc') {
        $scope.fontClass1 = "padding-left: 25px;";
    } else {
        $scope.fontClass1 = "max-width: 12.666667%;padding-left: 25px;";
    }

    $scope.viewMonitor='system statistics';

    $scope.slectedMonitor = function (type) {
            $scope.viewMonitor = type;
        }
    $scope.activeheader = 'Summary';
        // init method calling for get summary data
        $scope.init = function() {
            if($state.params.nodeId){
                $localStorage.nodeId = $state.params.nodeId;
            } else {
                $state.params.nodeId = $localStorage.nodeId;
            }
           /* $scope.cpuBar = new ldBar("#cpu");
            var bar2 =  angular.element('#cpu').ldBar;
            $scope.cpuBar.set(0);

            $scope.memoryBar = new ldBar("#memory");
            var bar =  angular.element('#memory').ldBar;
            $scope.memoryBar.set(0);*/

            $scope.loadNodeByIdOnStart($state.params.nodeId);
            $scope.loadcpu_memory($state.params.nodeId);
            $scope.loadSDPData($state.params.nodeId);
            $scope.loadIfData($state.params.nodeId);
            $scope.summaryDashTimer();
            //$scope.loadDBData($state.params.nodeId);
        }


        // init method calling for get summary data
        $scope.summaryInit = function() {
            if($state.params.nodeId){
                $localStorage.nodeId = $state.params.nodeId;
            } else {
                $state.params.nodeId = $localStorage.nodeId;
            }
            $scope.cpuBar = new ldBar("#cpu");
            var bar2 =  angular.element('#cpu').ldBar;
            $scope.cpuBar.set(0);

            $scope.memoryBar = new ldBar("#memory");
            var bar =  angular.element('#memory').ldBar;
            $scope.memoryBar.set(0);
            $scope.summaryDashTimer();
            $scope.loadNodeByIdOnStart($state.params.nodeId);
            $scope.loadSDPData($state.params.nodeId);
            $scope.loadcpu_memory($state.params.nodeId);
            $scope.loadIfData($state.params.nodeId);

            //$scope.loadDBData($state.params.nodeId);
        }

        $scope.$on('$destroy', function() {

            $scope.stopTimer();
        });

        /*$scope.startLinkTimer = function(nodeId) {
            $scope.nodeViewTimer = $interval(function() {
                $scope.loadLinkDetails(nodeId)
            }, 3000);
        }*/


        $scope.summaryDashTimer = function() {
            $scope.throughputtimer = $interval(function() {
//                $scope.cpumemorydata()
                $scope.loadcpu_memory($state.params.nodeId);
            }, 3000);
        }

        $scope.stopTimer = function() {
//                if (angular.isDefined($scope.nodeViewTimer)) {
//                    $interval.cancel($scope.nodeViewTimer);
//                }
                if (angular.isDefined($scope.throughputtimer)) {
                    $interval.cancel($scope.throughputtimer);
                }
            }

        $scope.enableDisableProvButton = function() {
            if ($scope.enableProvButton == 0) {
                return true;
            } else {
                return false;
            }

        }
        //summary data
        $scope.loadNodeById = function(nodeId) {
            var url = 'api/v2/nodemanageview/summary?nodeId=' + nodeId;
            return $http.get(url)
                .then(function(response) {
                    if (response.data) {
                        //$scope.vm.node = response.data;

                        if (response.data.provisioned) {
                            $scope.provButtonLabel = "UnProvision"
                            $scope.enableProvButton = 1;
                        } else {
                            $scope.provButtonLabel = "Provision"
                            $scope.enableProvButton = 2;
                        }
                        if (response.data.remoteId != null) {
                            $scope.remoteIP = response.data.remoteIP;
                            $scope.enableRemote = true;
                            $scope.remoteId = response.data.remoteId;
                        }
                        $rootScope.ipAddress = response.data.ipConfig.ipAddress;
                        return response.data;
                    }
                });
        }

        $scope.loadIfData = function(nodeId) {
        //113
            var url = 'api/v2/nodelinks/switchif/' + nodeId;
            return $http.get(url,{showdiv:true})
                .then(function(response) {
                    if (response.data) {
                        if (response.data.length > 0) {
                            $scope.portsdata = response.data;
                            for (var j = 0; j < $scope.portsdata.length;j++) {
                                for (var i = 0; i < $scope.portsdata[j].length; i++) {
                                    if ($scope.portsdata[j][i].status == 1) {
                                       $scope.portsdata[j][i].status = "#00ff00";
                                    } else {
                                        $scope.portsdata[j][i].status = "#ff0000";
                                    }

                                    /*if ($scope.portsdata[j][i].adminStatus == 'Up') {
                                       $scope.portsdata[j][i].adminStatus = "#00ff00";
                                    } else {
                                        $scope.portsdata[j][i].adminStatus = "#ff0000";
                                    }*/
                                }
                            }
                        }
                        return response.data;
                    }
                });
        }

    $scope.openswsystemstatistics=function(){
        $scope.viewNode = "monitor";
        $scope.activeheader = 'Monitor';
        $scope.active='Monitor';
        $scope.viewMonitor='system statistics';
    }

        $scope.openNode = function (type) {
            if (type == "summary") {
                $scope.viewNode = "summary";
                 $scope.summaryDashTimer();
            }
            else if (type == "monitor") {
                $rootScope.graphclickeventnewsw=3;
                $scope.viewNode = "monitor";
                $scope.viewMonitor = 'system statistics';
                $scope.stopTimer();
            }
        }

        // Node Action methods
        $scope.actionNode = function(action_type) {
            if (action_type === 'rescan') {
                var confirmMsg = 'Are you sure you wish to rescan device?';
                var confirm = $scope.saveconfirm(undefined,confirmMsg);
                $mdDialog.show(confirm).then(function(){
                    $http({
                        method: 'POST',
                        url: 'api/v2/nodes/rescanNode',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        data: $state.params.nodeId
                    }).success(function() {
                        $scope.showAlert('Success', 'Rescanning of the node initiated');
                    }).error(function(msg) {
                        $scope.showAlert('Error', 'Failed to resan the node: ' + msg);
                    })
                });

            } else if (action_type === "commit") {
                var confirmMsg = 'Are you sure you wish to commit the changes? \n Any unsaved changes will be commited to device';
                var confirm = $scope.saveconfirm(undefined,confirmMsg);
                $mdDialog.show(confirm).then(function(){
                    $http({
                        method: 'POST',
                        url: 'api/v2/nodelinks/commit?nodeId=' + $state.params.nodeId,
                        headers: {
                            'Content-Type': 'application/json'
                        }
                    }).success(function() {
                        $scope.showAlert('Success', 'Commit of the node initiated');
                    }).error(function(msg) {
                        $scope.showAlert('Error', 'Failed to commit the node: ' + msg);
                    });
                })

            } else if (action_type === "reboot") {
                var confirmMsg = 'Are you sure you wish to reboot the node? Any unsaved changes will be lost.';
                var confirm = $scope.saveconfirm(undefined,confirmMsg);
                $mdDialog.show(confirm).then(function(){
                    $http({
                        method: 'POST',
                        url: 'api/v2/nodelinks/reboot?nodeId=' + $state.params.nodeId,
                        headers: {
                            'Content-Type': 'application/json'
                        }
                    }).success(function() {
                        $scope.showAlert('Success', 'Reboot of the node initiated');
                    }).error(function(msg) {
                        $scope.showAlert('Error', 'Failed to reboot the node: ' + msg);
                    });
                })

            }else if (action_type === "provision") {
                if ($scope.enableProvButton != 0) {
                    var URL = '';
                    var confirmMsg = 'Are you sure you wish to provistion device?'
                    if ($scope.enableProvButton == 1) {
                        URL = 'api/v2/profiles/'+$state.params.nodeId+'/unprov'
                        confirmMsg = 'Are you sure you wish to unprovistion device?'
                    } else if ($scope.enableProvButton == 2) {
                        URL = 'api/v2/profiles/'+$state.params.nodeId+'/prov'
                    }
                       var confirm = $scope.saveconfirm(undefined,confirmMsg);
                       $mdDialog.show(confirm).then(function(){
                            $http({
                                method: 'POST',
                                url: URL,
                                headers: {
                                    'Content-Type': 'application/json'
                                }
                            }).success(function() {
                                $scope.showAlert('Success', 'Initiated device Provisioning process');
                                if ($scope.enableProvButton == 1) {
                                    $scope.provButtonLabel = "Provision"
                                    $scope.enableProvButton = 2;
                                } else if ($scope.enableProvButton == 2) {
                                    $scope.provButtonLabel = "UnProvision"
                                    $scope.enableProvButton = 1;
                                }
                            }).error(function(msg) {
                                $scope.showAlert('Error', 'Failed due to : ' + msg);
                            });

                       })
                }
             }
        }

        $scope.showAlert = function(msgType, msg, ev) {
            $mdDialog.show(
                $mdDialog.alert()
                .parent(angular.element(document.querySelector('#popupContainer')))
                .clickOutsideToClose(true)
                .title(msgType)
                .textContent(msg)
                .ariaLabel('Alert')
                .ok('OK')
                .targetEvent(ev)
            );
        };

        // nodeview accordion menu default highlite
        // nodeview accordion menu default highlite
            if ($state.params.lastView == "app.Events") {
                $scope.viewNode = 'node_events';
                $scope.eventsActive = "active";
                $scope.summaryActive = "";
                $scope.eventActivecss = "background-color:rgb(246, 246, 246);color:black";
            } else if ($state.params.lastView == "app.linkStats") {
                $scope.viewNode = 'linkstat';
                $scope.eventsActive = "active";
                $scope.summaryActive = "";
                $scope.linkActivecss = "background-color:rgb(246, 246, 246);color:black";
            }  else if ($state.params.lastView == "app.wireless") {
                $scope.viewNode = 'wireless_statistics';
                $scope.eventsActive = "active";
                $scope.summaryActive = "";
                $scope.linkActivecss = "";
                $scope.wirelessActivecss = "background-color:rgb(246, 246, 246);color:black";
            } else if ($state.params.lastView == "app.linkDetail") {
                 $scope.viewNode = 'linkdetail';
                 $scope.eventsActive = "active";
                 $scope.summaryActive = "";
                 $scope.linkActivecss = "background-color:rgb(246, 246, 246);color:black";
             }
             else if ($state.params.lastView == "app.system") {
                 $scope.viewNode = "monitor";
                    $scope.viewMonitor = 'system statistics';
                    //systemActivecss
                    $scope.eventsActive = "active";
                    $scope.summaryActive = "";
                    $scope.systemActivecss = "background-color:rgb(246, 246, 246);color:black";
                      $scope.activeheader = 'Monitor';
                } else {
                $scope.viewNode = 'summary';
                $scope.summaryActive = "active";
                $scope.summaryActivecss = "background-color:rgb(246, 246, 246);color:black";
                $scope.eventActive = "";
                $scope.linkActivecss="";
            }

            app.system

            //    nodeview sidemenu on click page open methos
            $scope.showDiv = function(viewNode) {
                if (viewNode == 'wl-5ghz-properties') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'wl-5ghz-mimo') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;

                } else if (viewNode == 'wl-5ghz-DDRS') {

                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'wl-5ghz-security') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'wl-5ghz-mac_acl') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'wl-5ghz-dcs') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'wl-2.4ghz-properties') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'wl-2.4ghz-security') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'summary') {
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'wl-2.4ghz-mac_acl') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'network-ipconfig') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'network-vlanconfig') {

                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;

                } else if (viewNode == 'network-ethernetconfig') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;

                } else if (viewNode == 'network-ethernetradius') {

                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;

                } else if (viewNode == 'network-dhcpconfig') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;

                } else if (viewNode == 'management_general') {

                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;

                } else if (viewNode == 'management_logging') {

                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'management_location') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'management_http/https') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'telnet') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'snmp') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'reset') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'linkstat') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'wireless_statistics') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'ethernet_statistics') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'system_statistics') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'node_events') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'if_statistics') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                } else if (viewNode == 'spectrum') {
                    $rootScope.selectedView = viewNode;
                    $scope.viewNode = viewNode;
                }

            }


    $scope.loadcpu_memory = function (nodeid) {
            $http.get('api/v2/nodelinks/swusage?nodeId=' + nodeid, { showdiv: false }).then(function (response) {
                // Check and remove oldest data from Array if it reaches the defined arrayLimit
                $scope.cpuUsage = response.data.cpu;
                $scope.memoryUsage = response.data.memory;
                if(!$scope.cpuUsage){
                    $scope.cpuUsage=0;
                }
                if(!$scope.memoryUsage){
                                    $scope.memoryUsage=0;
                                }
            });
        }

//   $scope.cpumemorydata = function () {
//
//            $http.get('api/v2/nodelinks/swusage?nodeId=' + $state.params.nodeId,{showdiv:false}).then(function(response) {
//
//                var cpuUsage = response.data.cpu;
//                var memoryUsage = response.data.memory;
//                 $scope.cpuBar.set(parseFloat(cpuUsage));
//
//                 $scope.memoryBar.set(parseFloat(memoryUsage));
//
//
//            });
//        }


        $scope.swnode={};
        $scope.loadNodeByIdOnStart = function(nodeId) {
            var url = 'api/v2/nodemanageview/summarydb?nodeId=' + nodeId;
            return $http.get(url,{showdiv:false})
                .then(function(response) {
                    if (response.data) {

                        $scope.swnode = response.data;
                         $rootScope.devicestatus = $scope.swnode.nodeStatus;
//                           if(!$rootScope.devicestatus){
//                                 $rootScope.graphclickeventnewsw=2;
//                            }else{
//                                 $rootScope.graphclickeventnewsw=1;
//                            }
                        $rootScope.graphclickeventnewsw=3;
                        $rootScope.ipAddress = $scope.swnode.ipConfig.ipAddress;
                        if (response.data.provisioned) {
                            $scope.provButtonLabel = "UnProvision"
                            $scope.enableProvButton = 1;
                        } else {
                            $scope.provButtonLabel = "Provision"
                            $scope.enableProvButton = 2;
                        }
//                        if ($scope.swnode.systemConfig) {
//                            if($scope.swnode.systemConfig.custName){
//                                $scope.swnode.systemConfig.custNameEllipse = ellipsemodel($scope.swnode.systemConfig.custName, 10, 8);
//                            }
//                        }
                        if ($scope.swnode.model) {
                                $scope.swnode.systemConfig.custNameEllipse = ellipsemodel($scope.swnode.model, 10, 8);
                        }
                        if ($scope.swnode.ipConfig) {
                            if($scope.swnode.ipConfig.ipAddress){
                                $scope.swnode.ipConfig.ipAddressEllipse = ellipsemodel($scope.swnode.ipConfig.ipAddress, 15, 8);
                            }
                        }
                           console.log("swnodevie start",$scope.swnode);
                        return response.data;
                    }
                });
        }

        function ellipsemodel(str, count, displaycount) {
            // If string length is longer than 10
            if (str.length > count) {
                return str.substr(0, displaycount) + ' ... ';// + str.substr(str.length - 5, str.length);
            }
            return str;
        }

        $scope.loadSDPData = function(nodeId) {
        var url = 'api/v2/nodelinks/vpls/' + nodeId;

            return $http.get(url,{showdiv:false})
                .then(function(response) {
                    if (response.data) {

                        $scope.sdp = response.data;
                        return response.data;
                    }
                });
        }

            $scope.showportstats = function (port, portvalue) {
                    //alert('asdfsd');
//                    $scope.viewNode = 'if_statistics';
//                    $rootScope.selectedView = $scope.viewNode;
//                    $scope.eventsActive = "active";
//                    $scope.summaryActive = "";
//                    $scope.linkActivecss = "background-color:rgb(246, 246, 246);color:black";
                    $scope.active = 'Monitor';
                     $scope.viewNode = "monitor";
                    $scope.viewMonitor='if statistics';
                    $rootScope.ifIndex = {
                                                                     "val": port,
                                                                     "id": portvalue

                                                                 };
            }

        // To redirect to Node view page
        $scope.showNode = function (nodeId, lastView) {
            $state.go('app.nodeView', { "nodeId": nodeId, "lastView": lastView });

        }


 //        post methods starts hear
        //save conformation
        $scope.saveconfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to update this changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')


            return confirm;
        };

        $scope.saveconfirm = function(ev,msg) {
                var confirm = $mdDialog.confirm()
                    .title(msg)
                    .targetEvent(ev)
                    .ok('Yes')
                    .cancel('No')


                return confirm;
        };

        function loadAccordian() {
            $("#accordian a").click(function() {
                var link = $(this);
                var closest_ul = link.closest("ul");
                var parallel_active_links = closest_ul.find(".active")
                var closest_li = link.closest("li");
                var link_status = closest_li.hasClass("active");
                var count = 0;

                closest_ul.find("ul").slideUp(function() {
                    if (++count == closest_ul.find("ul").length)
                        parallel_active_links.removeClass("active");
                });

                if (!link_status) {
                    closest_li.children("ul").slideDown();
                    closest_li.addClass("active");
                }
            })
            $('.activeItem').click(function(e) {
                $('.activeItem').css("background-color", "white", "color", "black");
                $(this).css("background-color", "#f6f6f6", "color", "white", "font-weight", "bold");
            });

        }

        // nodeview side toggle menu
        $(document).ready(function() {
            loadAccordian();

        })


}]);




dashboard.controller("SWNodeViewMonitorController", ['$localStorage', '$rootScope', '$scope', '$mdDialog', '$http', '$q','$state', 'dashboardService', 'Flash', '$interval',
 function($localStorage, $rootScope, $scope, $mdDialog, $http, $q,$state, dashboardService, Flash, $interval) {
  $scope.graphclickevent=1;
     $scope.system_init = function() {
            $scope.duration = "1h";
            $scope.cpuduration = "1h";
            $scope.memduration = "1h";
            $scope.temduration = "1h";
            $scope.disduration = "1h";
            $scope.liveGraph = ['cpu','mem','tem','dis'];
            $scope.eventCode = -1;
            $scope.intervalTime = 3000; // Chart Interval Time in milliseconds
            $scope.arrayLimit = 61;     // Chart data array limit

//  if(!$rootScope.devicestatus){
//        $rootScope.graphclickeventnewsw=2;
//       }

            $scope.reference = false;
            $scope.byrReference = false;
            // Ethernet Errors Chart Configuration
            $scope.system_cpu_config = {
                type: 'line',
                data: {
                    labels: [],
                    datasets: [{
                        label: 'CPU',
                        backgroundColor: 'rgba(220,83,83,1)',
                        borderColor: 'rgba(220,83,83,0.4)',
                        fill: 'origin',
                        pointRadius: 1,
                        pointHitRadius: 5,
                        data: []
                    }]
                },
                options: {
                    title: { display: false, text: "CPU" },
                    animation: { duration: 0},
                    hover: { animationDuration: 0 },
                    responsiveAnimationDuration: 0,
                    maintainAspectRatio: false,
                    legend: {
                        display: true,
                        position: 'top',
                        labels: { boxWidth: 12 }
                    },
                    showLines: true,
                    scales: {
                    xAxes: [{
                            ticks: {
                                fontSize: 10
                            },
                            type: 'time',
                            distribution: 'series',
                            displayFormats: {
                                quarter: 'MMM YYYY'
                            }
                        }],
                        yAxes: [{
                            scaleLabel: {
                                display: true,
                                labelString: 'CPU'
                            },
                            display: true,
                            ticks: {
                                                        beginAtZero: true,
                                                        steps: 10,
                                                        stepValue: 5,
                                                        max: 100
                                                    }
                        }],
                    },
                    elements: {
                        line: { tension: 0 }
                    }
                }
            };

            // Ethernet Errors Chart Configuration

            $scope.system_memory_config = {
                type: 'line',
                data: {
                    labels: [],
                    datasets: [{
                        label: 'Memory',
                        backgroundColor: 'rgba(249, 224, 144,1)',
                        borderColor: 'rgba(249, 224, 144,0.4)',
                        fill: 'origin',
                        pointRadius: 1,
                        pointHitRadius: 5,
                        data: []
                    }]
                },
                options: {
                    title: { display: false, text: "Memory" },
                    animation: { duration: 0},
                    hover: { animationDuration: 0 },
                    responsiveAnimationDuration: 0,
                    maintainAspectRatio: false,
                    legend: {
                        display: true,
                        position: 'top',
                        labels: { boxWidth: 12 }
                    },
                    showLines: true,
                    scales: {
                    xAxes: [{
                                                ticks: {
                                                    fontSize: 8
                                                },
                                                type: 'time',
                                                distribution: 'series',
                                                displayFormats: {
                                                    quarter: 'MMM YYYY'
                                                }
                                            }],
                        yAxes: [{
                            scaleLabel: {
                                display: true,
                                labelString: 'Memory'
                            },
                            display: true,
                            ticks: {
                                beginAtZero: true,
                                steps: 10,
                                stepValue: 5,
                                max: 100
                            }
                        }],
                    },
                    elements: {
                        line: { tension: 0 }
                    }
                }
            };

            $scope.system_temp_config = {
                type: 'line',
                data: {
                    labels: [],
                    datasets: [{
                        label: 'Temparature',
                        backgroundColor: 'rgba(167, 36,97,1)',
                        borderColor: 'rgba(167, 36,97,0.4)',
                        fill: 'origin',
                        pointRadius: 1,
                        pointHitRadius: 5,
                        data: []
                    }]
                },
                options: {
                    title: { display: false, text: "Temparature" },
                    animation: { duration: 0},
                    hover: { animationDuration: 0 },
                    responsiveAnimationDuration: 0,
                    maintainAspectRatio: false,
                    legend: {
                        display: true,
                        position: 'top',
                        labels: { boxWidth: 12 }
                    },
                    showLines: true,
                    scales: {
                    xAxes: [{
                                                ticks: {
                                                    fontSize: 10
                                                },
                                                type: 'time',
                                                distribution: 'series',
                                                displayFormats: {
                                                    quarter: 'MMM YYYY'
                                                }
                                            }],
                        yAxes: [{
                            scaleLabel: {
                                display: true,
                                labelString: 'Temparature'
                            },
                            display: true,
                            ticks: {
                                beginAtZero: true,
                                /*steps: 10,
                                stepValue: 5*//*,
                                max: 100*/
                            }
                        }],
                    },
                    elements: {
                        line: { tension: 0 }
                    }
                }
            };

            $scope.system_distance_config = {
                type: 'line',
                data: {
                    labels: [],
                    datasets: [{
                        label: 'Distance',
                        backgroundColor: 'rgba(255, 147, 92,0.4)',
                        borderColor: 'rgba(255, 147, 92,0.6)',
                        fill: 'origin',
                        pointRadius: 1,
                        pointHitRadius: 5,
                        data: []
                    }]
                },
                options: {
                    title: { display: false, text: "Distance" },
                    animation: { duration: 0 },
                    hover: { animationDuration: 0 },
                    //events: [],
                    responsiveAnimationDuration: 0,
                    maintainAspectRatio: false,
                    legend: {
                        display: true,
                        position: 'top',
                        labels: { boxWidth: 12 }
                    },
                    showLines: true,
                    scales: {
                        xAxes: [{
                            ticks: {
                                fontSize: 10
                            },
                            type: 'time',
                            distribution: 'series',
                            displayFormats: {
                                quarter: 'MMM YYYY'
                            }
                        }],
                        yAxes: [{
                            scaleLabel: {
                                display: true,
                                labelString: 'Distance'
                            },
                            display: true,
                            ticks: {
                                beginAtZero: true,
                                steps: 5,
                                stepValue: 5,
                                max: 100
                            }
                        }],
                    },
                    elements: {
                        line: { tension: 0 }
                    }
                }
            };

            // Initialize the Config null data to display window on start

             var sytem_cpu_ctx = null;
             var systemCPUChart = null;

             var sytem_memory_ctx = null;
             var systemMemoryChart = null;

             var sytem_temp_ctx = null;
             var systemTempChart = null;

            var sytem_distance_ctx = null;
            var systemDistanceChart = null;

             initGraph()
             systemData();

             function destroyNinitCPUGraph(live) {
                 if (systemCPUChart != null) {
                     systemCPUChart.destroy();
                 }
                 if (live) {
                     $scope.system_cpu_config.options.scales.xAxes[0] = {};
                     $scope.system_cpu_config.data.datasets[0].data = [];
                     $scope.system_cpu_config.data.labels = [];
                 } else {
                     var seriesConfig = {
                                            ticks: {
                                               fontSize: 12,
                                               autoSkip: false,
                                               maxRotation: 50,
                                               minRotation: 50
                                            },
                                            type: 'time',
                                            distribution: 'series',
                                            displayFormats: {
                                                            quarter: 'MMM YYYY'
                                            }
                                        }
                    $scope.system_cpu_config.options.scales.xAxes[0] = seriesConfig;
                 }
                 systemCPUChart = new Chart(sytem_cpu_ctx, $scope.system_cpu_config);
                 if (live) {
                    $scope.system_cpu_config.data.labels = [];
                  // Initialize the Config null data to display window on start
                     for(i=0; i<$scope.arrayLimit; i++) {
                         if(i%20 == 0){
                             $scope.system_cpu_config.data.labels[i] = ((($scope.arrayLimit-1)-i) * ($scope.intervalTime/1000))/60 + 'm';
                         } else {
                             $scope.system_cpu_config.data.labels[i] = "";
                         }
                         $scope.system_cpu_config.data.datasets[0].data[i] = null;
                     }
                 } else {
                     $scope.system_cpu_config.data.datasets[0].data = [];
                     $scope.system_cpu_config.data.labels = [];
                }
             }

            function destoryNinitMemGraph(live) {

                 if (systemMemoryChart != null) {
                     systemMemoryChart.destroy();
                 }
                 if (live) {
                     $scope.system_memory_config.options.scales.xAxes[0] = {};
                     $scope.system_memory_config.data.datasets[0].data = [];
                     $scope.system_memory_config.data.labels = [];
                 } else {
                     var seriesConfig = {
                                            ticks: {
                                              fontSize: 12,
                                                                                            autoSkip: false,
                                                                                            maxRotation: 50,
                                                                                            minRotation: 50
                                            },
                                            type: 'time',
                                            distribution: 'series',
                                            displayFormats: {
                                                            quarter: 'MMM YYYY'
                                            }
                                        }
                    $scope.system_memory_config.options.scales.xAxes[0] = seriesConfig;
                 }
                 systemMemoryChart = new Chart(sytem_memory_ctx, $scope.system_memory_config);
                 if (live) {
                  // Initialize the Config null data to display window on start
                     for(i=0; i<$scope.arrayLimit; i++) {
                         if(i%20 == 0){
                             $scope.system_memory_config.data.labels[i] = ((($scope.arrayLimit-1)-i) * ($scope.intervalTime/1000))/60 + 'm';
                         } else {
                             $scope.system_memory_config.data.labels[i] = "";
                         }
                         $scope.system_memory_config.data.datasets[0].data[i] = null;
                     }
                 } else {

                     $scope.system_memory_config.data.datasets[0].data = [];
                     $scope.system_memory_config.data.labels = [];
                }
             }

            function destoryNinitTempGraph(live) {
                  if (systemTempChart != null) {
                      systemTempChart.destroy();
                  }
                  if (live) {
                      $scope.system_temp_config.options.scales.xAxes[0] = {};
                      $scope.system_temp_config.data.datasets[0].data = [];
                      $scope.system_temp_config.data.labels = [];

                  } else {
                      var seriesConfig = {
                                             ticks: {
                                                                           fontSize: 12,
                                                                           autoSkip: false,
                                                                           maxRotation: 50,
                                                                           minRotation: 50
                                                                        },
                                             type: 'time',
                                             distribution: 'series',
                                             displayFormats: {
                                                             quarter: 'MMM YYYY'
                                             }
                                         }
                     $scope.system_temp_config.options.scales.xAxes[0] = seriesConfig;
                  }
                   var metrics = $rootScope.metrics;

                   if (!metrics) {
                       metrics = $rootScope.buildCode;
                   }
                  if (metrics == 'US') {
                      $scope.system_temp_config.options.scales.yAxes[0].scaleLabel.labelString = 'Temperature (Fahrenheit)';
                  } else {
                      $scope.system_temp_config.options.scales.yAxes[0].scaleLabel.labelString = 'Temperature (Celcius)';
                  }

                  systemTempChart = new Chart(sytem_temp_ctx, $scope.system_temp_config);
                  if (live) {
                   // Initialize the Config null data to display window on start
                      for(i=0; i<$scope.arrayLimit; i++) {
                          if(i%20 == 0){
                              $scope.system_temp_config.data.labels[i] = ((($scope.arrayLimit-1)-i) * ($scope.intervalTime/1000))/60 + 'm';
                          } else {
                              $scope.system_temp_config.data.labels[i] = "";
                          }
                          $scope.system_temp_config.data.datasets[0].data[i] = null;
                      }
                  } else {
                        $scope.system_temp_config.data.datasets[0].data = [];
                        $scope.system_temp_config.data.labels = [];
                    }
            }

//            function destoryNinitDistGraph(live) {
//                   if (systemDistanceChart != null) {
//                       systemDistanceChart.destroy();
//                   }
//                   if (live) {
//                       $scope.system_distance_config.options.scales.xAxes[0] = {};
//                       $scope.system_distance_config.data.datasets[0].data = [];
//                       $scope.system_distance_config.data.labels = [];
//                   } else {
//                       var seriesConfig = {
//                                              ticks: {
//                                                  fontSize: 8
//                                              },
//                                              type: 'time',
//                                              distribution: 'series',
//                                              displayFormats: {
//                                                              quarter: 'MMM YYYY'
//                                              }
//                                          }
//                      $scope.system_distance_config.options.scales.xAxes[0] = seriesConfig;
//                   }
//                   systemDistanceChart = new Chart(sytem_distance_ctx, $scope.system_distance_config);
//                   if (live) {
//                    // Initialize the Config null data to display window on start
//                       for(i=0; i<$scope.arrayLimit; i++) {
//                           if(i%20 == 0){
//                               $scope.system_distance_config.data.labels[i] = ((($scope.arrayLimit-1)-i) * ($scope.intervalTime/1000))/60 + 'm';
//                           } else {
//                               $scope.system_distance_config.data.labels[i] = "";
//                           }
//                           $scope.system_distance_config.data.datasets[0].data[i] = null;
//                       }
//                   } else {
//                       $scope.system_distance_config.data.datasets[0].data = [];
//                       $scope.system_distance_config.data.labels = [];
//                  }
//               }

             function initOtherGraphs() {
                 sytem_cpu_ctx = document.getElementById("system_cpu_chart").getContext("2d");
                 sytem_memory_ctx = document.getElementById("system_memory_chart").getContext("2d");
                 sytem_temp_ctx = document.getElementById("system_temp_chart").getContext("2d");
                 //sytem_distance_ctx = document.getElementById("system_distance_chart").getContext("2d");
             }

             function initGraph() {
                 initOtherGraphs();
                 destroyNinitCPUGraph(true);
                 destoryNinitMemGraph(true);
                 destoryNinitTempGraph(true);
                // destoryNinitDistGraph(true);
             }


            // Ethernet Data Timer
            function systemData() {
                $scope.systemDataTimer = $interval(function() { $scope.liveSystemData() }, $scope.intervalTime);
            }

            // Ethernet Data Destroy timer
            $scope.$on('$destroy', function() {
    //            console.log("User left the ethernet page");
                $scope.stopSystemTimer();
            });


            $scope.liveSystemData = function () {

                var size = $scope.liveGraph.length;

                if (size == 0) {
                    return;
                }

                $http.get('api/v2/nodelinks/swusage?nodeId=' + $state.params.nodeId,{showdiv:false}).then(function(response) {
                    //$scope.liveGraph = ['cpu','','',''];
                    //Arrays.sort($scope.liveGraph);
                    //int res = Arrays.binarySearch($scope.liveGraph, "cpu");
                    var cpuAvai = $scope.isLiveAvail('cpu');
                    var memAvai = $scope.isLiveAvail('mem');
                    var temAvai = $scope.isLiveAvail('tem');
                   // var disAvai = $scope.isLiveAvail('dis');
                    if (memAvai) {
                        //$scope.system_memory_config.data.datasets[0].data.splice(0,1);
                        if($scope.system_memory_config.data.datasets[0].data.length >= $scope.arrayLimit) {
                            $scope.system_memory_config.data.datasets[0].data.splice(0,1);
                        }
                    }
                    if (temAvai) {
                        //$scope.system_temp_config.data.datasets[0].data.splice(0,1);
                        if($scope.system_temp_config.data.datasets[0].data.length >= $scope.arrayLimit) {
                            $scope.system_temp_config.data.datasets[0].data.splice(0,1);
                        }
                    }
                    if (cpuAvai) {
                        if($scope.system_cpu_config.data.datasets[0].data.length >= $scope.arrayLimit) {
                            $scope.system_cpu_config.data.datasets[0].data.splice(0,1);
                        }

                    }
//                    if (disAvai) {
//                        if ($scope.system_distance_config.data.datasets[0].data.length >= $scope.arrayLimit) {
//                            $scope.system_distance_config.data.datasets[0].data.splice(0, 1);
//                        }
//                    }
                    // Check and remove oldest data from Array if it reaches the defined arrayLimit

                        // Bind new data from response to the chart configs
                    //$scope.ethernet_data = response.data;

                    if (cpuAvai) {
                        var cpuUsage = response.data.cpu;
                        $scope.system_cpu_config.data.datasets[0].data.push(cpuUsage);
                        systemCPUChart.update();
                    }

                    if (memAvai) {
                        var memoryUsage = response.data.memory;
                        $scope.system_memory_config.data.datasets[0].data.push(memoryUsage);
                        systemMemoryChart.update();
                    }

                    if (temAvai) {
                        var tempUsage = response.data.temp;
                        var metrics = $rootScope.metrics;

                                       if (!metrics) {
                                           metrics = $rootScope.buildCode;
                                       }
                        if (metrics == 'US') {
                            tempUsage = (tempUsage * 1.8) + 32;
                        }
                        $scope.system_temp_config.data.datasets[0].data.push(tempUsage);
                        systemTempChart.update();
                    }
//                      if (disAvai) {
//                            angular.copy(response.data, $scope.distance_data);
//                            var distance = 0;
//                            if ($scope.pdistance_data.latitude) {
//                                var lat1 = parseFloat($scope.distance_data.latitude).toFixed(6);
//                                var lat2 = parseFloat($scope.pdistance_data.latitude).toFixed(6);
//                                var lon1 = parseFloat($scope.distance_data.longitude).toFixed(6);
//                                var lon2 = parseFloat($scope.pdistance_data.longitude).toFixed(6);
//                                if ($scope.reference) {
//                                    lat2 = $scope.rlatitude;
//                                    lon2 = $scope.rlongitude;
//                                }
//                                distance = distanceDelta(lat1, lon1, lat2, lon2, 'm');
//                            } else {
//                                distance = 0;
//                            }
//
//                            angular.copy(response.data, $scope.pdistance_data);
//                            $scope.system_distance_config.data.datasets[0].data.push(distance);
//                            systemDistanceChart.update();
//                        }
                });
            }

            // Ethernet Data Stop timer
            $scope.stopSystemTimer = function() {
                if (angular.isDefined($scope.systemDataTimer)) {
    //                console.log("Stopping the ethernet timer");
                    $interval.cancel($scope.systemDataTimer);
                }
            }

            $scope.removeReference = function() {
                if($scope.reference == false) {
                    $scope.rlatitude = 0;
                    $scope.rlongitude = 0;
                    $scope.graphEvent($scope.eventCode);
                }
            }

            $scope.reloadGeoGraph = function() {
                if ($scope.reference) {
                    $scope.byrReference = true;
                    $scope.rlatitude = angular.element(document.getElementById("rlatitude")).val();
                    $scope.rlongitude = angular.element(document.getElementById("rlongitude")).val();
                    $scope.graphEvent($scope.eventCode);
                }
            }

            $scope.isLiveAvail = function(val) {
                var res = $scope.liveGraph.indexOf(val);
                return res >= 0 ? true : false;
                //return true;
            }
            $scope.addSystemCPUData= function (isLive) {
                if (systemCPUChart != null && !isLive) {
                   var url = 'rest/measurements/node%5B' + $state.params.nodeId + '%5D.nodeSnmp%5B%5D?aggregation=AVERAGE&att=nodecpu&duration=' + $scope.cpuduration;
                  if ($scope.cpuduration == '1c') {
                    url = 'rest/measurements/node%5B' + $state.params.nodeId + '%5D.nodeSnmp%5B%5D?aggregation=AVERAGE&att=nodecpu&duration=' + $scope.cpuduration + '&start=' + $scope.startsDate + '&end=' + $scope.endsDate;
                    }
                    $http.get(url, {showdiv:false}).then(function(response) {
                        var timeStamps = response.data.timestamps
                        var systemcpu = response.data.columns[0].values;
                        for (var i = 0;i<timeStamps.length - 1;i++) {
                            if(systemcpu[i] == 'NaN') {
                                systemcpu[i] = 0;
                            }
                            var d = new Date(timeStamps[i]);
                            $scope.system_cpu_config.data.labels[i] = d;
                            $scope.system_cpu_config.data.datasets[0].data.push(systemcpu[i].toFixed(2));

                        }
                        systemCPUChart.update();
                    });
                }
            }

             $scope.showportstats = function (port, portvalue) {
                alert('asdfsd');
                $scope.viewNode = 'if_statistics';
                $scope.eventsActive = "active";
                $scope.summaryActive = "";
                $scope.linkActivecss = "background-color:rgb(246, 246, 246);color:black";
            }

            $scope.addSystemMemData= function (isLive) {
                if (systemMemoryChart != null && !isLive) {
                    var url='rest/measurements/node%5B'+$state.params.nodeId+'%5D.nodeSnmp%5B%5D?aggregation=AVERAGE&att=nodememory&duration='+$scope.memduration;
                    if ($scope.cpuduration == '1c') {
                        url = 'rest/measurements/node%5B' + $state.params.nodeId + '%5D.nodeSnmp%5B%5D?aggregation=AVERAGE&att=nodememory&duration=' + $scope.memduration + '&start=' + $scope.startsDate + '&end=' + $scope.endsDate;
                    }
                    $http.get(url, {showdiv:false}).then(function(response) {
                        var timeStamps = response.data.timestamps
                        var systemmemory = response.data.columns[0].values;
                        for (var i = 0;i<timeStamps.length - 1;i++) {
                            if(systemmemory[i] == 'NaN') {
                                systemmemory[i] = 0;
                            }
                            var d = new Date(timeStamps[i]);
                            $scope.system_memory_config.data.labels[i] = d;
                            $scope.system_memory_config.data.datasets[0].data.push(systemmemory[i].toFixed(2));
                        }
                        systemMemoryChart.update();

                    });
                }
            }

            $scope.addSystemTemData= function (isLive) {
                if (systemTempChart != null && !isLive) {
                    var url='rest/measurements/node%5B'+$state.params.nodeId+'%5D.nodeSnmp%5B%5D?aggregation=AVERAGE&att=cputemperature&duration='+$scope.temduration;
                     if ($scope.cpuduration == '1c') {
                        url = 'rest/measurements/node%5B' + $state.params.nodeId + '%5D.nodeSnmp%5B%5D?aggregation=AVERAGE&att=cputemperature&duration=' + $scope.temduration + '&start=' + $scope.startsDate + '&end=' + $scope.endsDate;
                    }
                    $http.get(url,{showdiv:false}).then(function(response) {
                        var timeStamps = response.data.timestamps
                        var systemtemp = response.data.columns[0].values;
                        for (var i = 0;i<timeStamps.length - 1;i++) {
                            if(systemtemp[i] == 'NaN') {
                                systemtemp[i] = 0;
                            }
                            var d = new Date(timeStamps[i]);
                            $scope.system_temp_config.data.labels[i] = d;
                            var tempUsage = parseFloat(systemtemp[i]).toFixed(2);
                             var metrics = $rootScope.metrics;
                               if (!metrics) {
                                   metrics = $rootScope.buildCode;
                               }
                            if (metrics == 'US') {
                                tempUsage = (tempUsage * 1.8) + 32;
                            }
                            $scope.system_temp_config.data.datasets[0].data.push(parseFloat(tempUsage).toFixed(2));
                        }
                        systemTempChart.update();

                    });
                }
            }

//            $scope.addSystemDisData = function (isLive) {
//                if (systemDistanceChart != null && !isLive) {
//                    var url = 'rest/measurements/node%5B' + $state.params.nodeId + '%5D.nodeSnmp%5B%5D?aggregation=LAST&att=latitude,longitude&duration=' + $scope.disduration;
//                    if ($scope.disduration == '1c') {
//                        url = 'rest/measurements/node%5B' + $state.params.nodeId + '%5D.nodeSnmp%5B%5D?aggregation=LAST&att=latitude,longitude&duration=' + $scope.disduration + '&start=' + $scope.startsDate + '&end=' + $scope.endsDate;
//                    }
//                    $http.get(url, { showdiv: false }).then(function (response) {
//                        var timeStamps = response.data.timestamps
//                        var latitude = response.data.columns[1].values;
//                        var longitude = response.data.columns[0].values;
//                        for (var i = 0; i < timeStamps.length - 1; i++) {
//                            if (latitude[i] == 'NaN') {
//                                latitude[i] = 0;
//                            }
//                            if (longitude[i] == 'NaN') {
//                                longitude[i] = 0;
//                            }
//                            var lat1 = parseFloat(latitude[i]).toFixed(6);
//                            var lon1 = parseFloat(longitude[i]).toFixed(6);
//                            var lat2 = parseFloat(latitude[i + 1]).toFixed(6);
//                            var lon2 = parseFloat(longitude[i + 1]).toFixed(6);
//                            if ($scope.reference) {
//                                lat2 = $scope.rlatitude;
//                                lon2 = $scope.rlongitude;
//                            }
//                            var d = new Date(timeStamps[i]);
//                            $scope.system_distance_config.data.labels[i] = (d.toISOString());//d;
//                            var dDelta = distanceDelta(lat1, lon1, lat2, lon2, 'm');
//                            $scope.system_distance_config.data.datasets[0].data.push(dDelta);
//                        }
//                        systemDistanceChart.update();
//
//                    });
//                }
//            }


            $scope.addOrRemoveElement = function(il,ele) {
                var index = $scope.liveGraph.indexOf(ele);
                if (il) {
                    if (index == -1) {
                        $scope.liveGraph.push(ele);
                    }
                } else {
                    if (index != -1) {
                        $scope.liveGraph.splice(index,1);
                    }
                }

            }

            $scope.showCustomeData = function () {
                console.log($scope.startDate);
                console.log($scope.endDate);
                $scope.startsDate = new Date($scope.startDate).getTime();
                $scope.endsDate = new Date($scope.endDate).getTime();
                $scope.graphEvent('cpu', 6)
            }

            $scope.graphEvent = function(gra,event) {
                $scope.eventCode = event;
                //$scope.liveGraph = ['cpu','','',''];
                var isLive = false;
                var d = "1h";
                if (event == 2) {
                    d = "1h";
                      $scope.graphclickevent=2;
                } else if (event == 3) {
                    d = "1d";
                      $scope.graphclickevent=3;
                } else if (event == 4) {
                    d = "1m";
                      $scope.graphclickevent=4;
                } else if (event == 5) {
                     d = "1w";
                       $scope.graphclickevent=5;
                }  else if (event == 6) {
                   d = "1c";
                } else {
                    d = "1h";
                    isLive = true;
                    $scope.graphclickevent=1;
                }
                      $rootScope.graphclickeventnewsw=$scope.graphclickevent;
                 if (gra == 'cpu') {
                        $scope.cpuduration = d;
                        $scope.memduration = d;
                        $scope.temduration = d;
                        $scope.disduration = d;
                        $scope.addOrRemoveElement(isLive, 'cpu');
                        $scope.addOrRemoveElement(isLive, 'mem');
                        $scope.addOrRemoveElement(isLive, 'tem');
                        //$scope.addOrRemoveElement(isLive, 'dis');
                        destroyNinitCPUGraph(isLive);
                        destoryNinitMemGraph(isLive);
                        destoryNinitTempGraph(isLive);
                       // destoryNinitDistGraph(isLive);
                        $scope.addSystemCPUData(isLive);
                        $scope.addSystemMemData(isLive);
                        $scope.addSystemTemData(isLive);
                        //$scope.addSystemDisData(isLive);
                    }

//                if (gra == 'cpu') {
//                    $scope.cpuduration =d;
//                    $scope.addOrRemoveElement(isLive,'cpu');
//                    destroyNinitCPUGraph(isLive);
//                    $scope.addSystemCPUData(isLive);
//
//                } else if (gra =='mem') {
//                    $scope.memduration = d;
//                    $scope.addOrRemoveElement(isLive,'mem');
//                    destoryNinitMemGraph(isLive);
//                    $scope.addSystemMemData(isLive);
//                } else if (gra == 'tem') {
//                    $scope.temduration = d;
//                    $scope.addOrRemoveElement(isLive,'tem');
//                    destoryNinitTempGraph(isLive);
//                    $scope.addSystemTemData(isLive);
//                }
                /*else if (gra == 'dis') {
                    $scope.disduration = d;
                    $scope.addOrRemoveElement(isLive,'dis');
                    destoryNinitDistGraph(isLive);
                    $scope.addSystemDisData(isLive);
                }*/

                //destoryNinitGraph();

                //console.log('selecte ' + $scope.duration);
            }
          setTimeout(() => {
            $scope.graphEvent('cpu',$rootScope.graphclickeventnewsw);
            }, 1000);
         }

         $scope.if_init = function() {
            //console.log("if called");

            $scope.ifIndex = {
                 "val": 1101,
                 "id": "port 1/1/1"

             };
            if ($rootScope.ifIndex) {
                $scope.ifIndex = $rootScope.ifIndex;
            }
            $scope.liveGraph = [true,true,true,true];
            $scope.graphDura = [true,true,true,true];
            $scope.graphChartConfig = [null,null,null,null,null,null,null,null];
            $scope.chartMap = {};
            $scope.octdur = 0;
            $scope.selectGraph = [
                {
                    "val": 1101,
                    "id": "Port 1/1/1"

                }, {
                    "val": 1102,
                    "id": "Port 1/1/2"

                }, {
                    "val": 1103,
                    "id": "Port 1/1/3"
                }, {
                     "val": 1104,
                     "id": "Port 1/1/4"
                 },
                {
                    "val": 1201,
                    "id": "Port 1/2/1"

                }, {
                    "val": 1202,
                    "id": "Port 1/2/2"

                }, {
                    "val": 1203,
                    "id": "Port 1/2/3"
                }, {
                     "val": 1204,
                     "id": "Port 1/2/4"
                 }
               ];

               $scope.intervalTime = 3000; // Chart Interval Time in milliseconds
               $scope.arrayLimit = 61;     // Chart data array limit

               $scope.pifdata = {};

                var link_char1 = null;
                var chatObj1 = null;

                var link_char2 = null;
                var chatObj2 = null;

                var link_char3 = null;
                var chatObj3 = null;

                var link_char4 = null;
                var chatObj4 = null;
                $scope.graph1Model = $scope.selectGraph[0];
                $scope.graph2Model = $scope.selectGraph[1];
                $scope.graph3Model = $scope.selectGraph[2];
                $scope.graph4Model = $scope.selectGraph[3];

                $scope.chartMap['oct'] = 'ifInNUcastPkts,ifOutNUcastPkts';
                $scope.chartMap['pac'] = 'ifInUcastPkts,ifOutUcastPkts';
                $scope.chartMap['err'] = 'ifInErrors,ifOutErrors';
                $scope.chartMap['dis'] = 'ifInDiscards,ifOutDiscards';



                $scope.oct_chart_config = {
                    type: 'line',
                    data: {
                        labels: [],
                        datasets: [{
                           label: 'In',
                           backgroundColor: 'rgba(26,108,140,1)',
                           borderColor: 'rgba(26,108,140,0.4)',
                           fill: false,
                           pointRadius: 0,
                           pointHitRadius: 5,
                           data: []
                       }, {
                            label: 'Out',
                            backgroundColor: 'rgba(60,37,74,1)',
                            borderColor: 'rgba(60,37,74,0.4)',
                            fill: false,
                            pointRadius: 0,
                            pointHitRadius: 5,
                            data: []
                        }]
                    },
                    options: {
                        title: { display: false, text: "Non Unicast Packets" },
                        animation: { duration: 0},
                        hover: { animationDuration: 0 },
                        responsiveAnimationDuration: 0,
                        maintainAspectRatio: false,
                        legend: {
                            display: true,
                            position: 'top',
                            labels: { boxWidth: 12 }
                        },
                        showLines: true,
                        scales: {
                            xAxes: [{
                                gridLines: {
                                    display:false
                                },
                                type: 'time',
                                distribution: 'series',
                                displayFormats: {
                                    quarter: 'MMM YYYY'
                                }
                            }],
                            yAxes: [{
                                scaleLabel: {
                                    display: true,
                                    labelString: 'Non Unicast Packets',
                                    fontStyle:'bold'
                                },
                                display: true,
                                ticks: {
                                        beginAtZero: true,
                                        /*min: -100*/
                                    }

                            }],
                        },
                        elements: {
                            line: { tension: 0 }
                        }
                    }
                };

                    // Wireless Packets Chart Configuration
                    $scope.pac_chart_config = {
                        type: 'line',
                        data: {
                            labels: [],
                            datasets: [{
                               label: 'In',
                               backgroundColor: 'rgba(26,108,140,1)',
                               borderColor: 'rgba(26,108,140,0.4)',
                               fill: false,
                               pointRadius: 0,
                               pointHitRadius: 5,
                               data: []
                           }, {
                                label: 'Out',
                                backgroundColor: 'rgba(60,37,74,1)',
                                borderColor: 'rgba(60,37,74,0.4)',
                                fill: false,
                                pointRadius: 0,
                                pointHitRadius: 5,
                                data: []
                            }]
                        },
                        options: {
                            title: { display: false, text: "Unicast Packets" },
                            animation: { duration: 0},
                            hover: { animationDuration: 0 },
                            responsiveAnimationDuration: 0,
                            maintainAspectRatio: false,
                            legend: {
                                display: true,
                                position: 'top',
                                labels: { boxWidth: 12 }
                            },
                            showLines: true,
                            scales: {
                                xAxes: [{
                                    type: 'time',
                                    distribution: 'series',
                                    displayFormats: {
                                        quarter: 'MMM YYYY'
                                    }
                                }],
                                yAxes: [{
                                    scaleLabel: {
                                        display: true,
                                        labelString: 'Unicast Packets',
                                        fontStyle:'bold'
                                    },
                                    display: true,
                                    ticks: {
                                        beginAtZero: true,
                                        /*min: -100*/
                                    }
                                }],
                            },
                            elements: {
                                line: { tension: 0 }
                            }
                        }

                    };

                    $scope.err_chart_config = {
                        type: 'line',
                        data: {
                            labels: [],
                            datasets: [{
                               label: 'In',
                               backgroundColor: 'rgba(24,178,157,1)',
                               borderColor: 'rgba(24,178,157,0.4)',
                               fill: false,
                               pointRadius: 1,
                               pointHitRadius: 5,
                               data: []
                           }, {
                                label: 'Out',
                                backgroundColor: 'rgba(102,51,153,1)',
                                borderColor: 'rgba(102,51,153,0.4)',
                                fill: false,
                                pointRadius: 1,
                                pointHitRadius: 5,
                                data: []
                            }]
                        },
                        options: {
                            title: { display: false, text: "Errors" },
                            animation: { duration: 0},
                            hover: { animationDuration: 0 },
                            responsiveAnimationDuration: 0,
                            maintainAspectRatio: false,
                            legend: {
                                display: true,
                                position: 'top',
                                labels: { boxWidth: 12 }
                            },
                            showLines: true,
                            scales: {
                                xAxes: [{
                                    type: 'time',
                                    distribution: 'series',
                                    displayFormats: {
                                        quarter: 'MMM YYYY'
                                    }
                                }],
                                yAxes: [{
                                    scaleLabel: {
                                        display: true,
                                        labelString: 'Errors',
                                        fontStyle:'bold'
                                    },
                                    display: true,
                                    ticks: { beginAtZero: true }
                                }],
                            },
                            elements: {
                                line: { tension: 0 }
                            }
                        }
                    };

                    $scope.dis_chart_config = {
                        type: 'line',
                        data: {
                            labels: [],
                            datasets: [{
                               label: 'In',
                               backgroundColor: 'rgba(24,178,157,1)',
                               borderColor: 'rgba(24,178,157,0.4)',
                               fill: false,
                               pointRadius: 1,
                               pointHitRadius: 5,
                               data: []
                           }, {
                                label: 'Out',
                                backgroundColor: 'rgba(102,51,153,1)',
                                borderColor: 'rgba(102,51,153,0.4)',
                                fill: false,
                                pointRadius: 1,
                                pointHitRadius: 5,
                                data: []
                            }]
                        },
                        options: {
                            title: { display: false, text: "Discards" },
                            animation: { duration: 0},
                            hover: { animationDuration: 0 },
                            responsiveAnimationDuration: 0,
                            maintainAspectRatio: false,
                            legend: {
                                display: true,
                                position: 'top',
                                labels: { boxWidth: 12 }
                            },
                            showLines: true,
                            scales: {
                                xAxes: [{
                                    type: 'time',
                                    distribution: 'series',
                                    displayFormats: {
                                        quarter: 'MMM YYYY'
                                    }
                                }],
                                yAxes: [{
                                    scaleLabel: {
                                        display: true,
                                        labelString: 'Discards',
                                        fontStyle:'bold'
                                    },
                                    display: true,
                                    ticks: { beginAtZero: true }
                                }],
                            },
                            elements: {
                                line: { tension: 0 }
                            }
                        }
                    };

            initGraph();

            function initGraph() {
                initOtherGraphs();
                destoryNinitLinkGraph(true)
                liveLinkDataTimer();
            }

            function destoryNinitLinkGraph(live) {
                destroyNInitLocalRSSIGraph(live);
                destroyNInitRemoteRSSIGraph(live);
                destroyNInitLinkSNRGraph(live);
                destroyNInitRemoteSNRraph(live);
            }

            function liveLinkDataTimer() {
                $scope.liveLinkTimer = $interval(function() { $scope.liveLinkData() }, $scope.intervalTime);
            }

            $scope.$on('$destroy', function() {
        //                console.log("left node view");
                $scope.stopLinkDataTimer();
            });

            $scope.stopLinkDataTimer = function() {
                if (angular.isDefined($scope.liveLinkTimer)) {
        //                console.log("Stopping the timer");
                    $interval.cancel($scope.liveLinkTimer);
                }
            }

            function initOtherGraphs() {
                link_char1 = document.getElementById("octets_chart").getContext("2d");
                link_char2 = document.getElementById("packetsuni_chart").getContext("2d");
                link_char3 = document.getElementById("errors_chart").getContext("2d");
                link_char4 = document.getElementById("discards_chart").getContext("2d");

            }

            $scope.spliceData = function(config) {
                for (var i = 0; i < config.data.datasets.length; i++) {
                    if (config.data.datasets[i].data.length >= $scope.arrayLimit) {
                        config.data.datasets[i].data.splice(0,1);
                    }
                }
            }

            $scope.pushLocalRSSILive = function(linkData) {
                var inpac = 0;
                var outpac = 0;
                if ($scope.pifdata != undefined) {
                    inpac = linkData.ifInNUcastPkts - $scope.pifdata.ifInNUcastPkts;
                    outpac = linkData.ifOutNUcastPkts - $scope.pifdata.ifOutNUcastPkts;
                }
                $scope.oct_chart_config.data.datasets[0].data.push(inpac);
                $scope.oct_chart_config.data.datasets[1].data.push(outpac);
            }

            $scope.pushRemoteRSSILive = function(linkData) {
                var inpac = 0;
                var outpac = 0;
                if ($scope.pifdata != undefined) {
                    inpac = linkData.ifInUcastPkts - $scope.pifdata.ifInUcastPkts;
                    outpac = linkData.ifInUcastPkts - $scope.pifdata.ifInUcastPkts;
                }
                $scope.pac_chart_config.data.datasets[0].data.push(inpac);
                $scope.pac_chart_config.data.datasets[1].data.push(outpac);

            }
            $scope.pushLocalSNRLive = function(linkData) {
                var inpac = 0;
                var outpac = 0;
                if ($scope.pifdata != undefined) {
                    inpac = linkData.ifInErrors - $scope.pifdata.ifInErrors;
                    outpac = linkData.ifOutErrors - $scope.pifdata.ifOutErrors;
                }
                $scope.err_chart_config.data.datasets[0].data.push(inpac);
                $scope.err_chart_config.data.datasets[1].data.push(outpac);
            }

            $scope.pushRemoteSNRLive = function(linkData) {
                var inpac = 0;
                var outpac = 0;
                if ($scope.pifdata != undefined) {
                    inpac = linkData.ifInDiscards - $scope.pifdata.ifInDiscards;
                    outpac = linkData.ifOutDiscards - $scope.pifdata.ifOutDiscards;
                }
                $scope.dis_chart_config.data.datasets[0].data.push(inpac);
                $scope.dis_chart_config.data.datasets[1].data.push(outpac);
            }

            $scope.pushLiveData = function(linkData) {
                $scope.pushLocalRSSILive(linkData);
                $scope.pushRemoteRSSILive(linkData);
                $scope.pushLocalSNRLive(linkData);
                $scope.pushRemoteSNRLive(linkData);
                angular.copy(linkData, $scope.pifdata);

            }

            $scope.liveLinkData = function () {
                if($scope.graphclickevent==1){
                     $http.get('api/v2/nodelinks/ifIndex/' + $state.params.nodeId +'/'+$scope.ifIndex.val,{showdiv:false}).then(function(response) {
                        var linkData = response.data;
                         if ($scope.liveGraph[0]) {
                            $scope.spliceData($scope.graphChartConfig[0]);
                            //$scope.pushLiveData(linkData);
                         }
                         if ($scope.liveGraph[1]) {
                            $scope.spliceData($scope.graphChartConfig[1]);
                            //$scope.pushLiveData(linkData);
                         }
                         if ($scope.liveGraph[2]) {
                            $scope.spliceData($scope.graphChartConfig[2]);
                            //$scope.pushLiveData(linkData);
                         }
                         if ($scope.liveGraph[3]) {
                            $scope.spliceData($scope.graphChartConfig[3]);

                         }
                        $scope.pushLiveData(linkData);

                        chatObj1.update();
                        chatObj2.update();
                        chatObj3.update();
                        chatObj4.update();

                    });
                }
            }

            function destroyNInitGraph1(isLive,config) {
                if (chatObj1!=null) {
                    chatObj1.destroy();
                }

                if (isLive) {
                     config.options.scales.xAxes[0] = {
                        gridLines: {
                                            display:false
                                        }
                     };
                     if (config.data.datasets.length > 0) {
                        for (var i = 0; i< config.data.datasets.length;i++) {
                            config.data.datasets[i].data = []
                        }
                     }
                     config.data.labels = [];

                 } else {
                     var seriesConfig = {
                        gridLines: {
                            display:false
                        },
                         ticks: {
                                                       fontSize: 12,
                                                       autoSkip: false,
                                                       maxRotation: 50,
                                                       minRotation: 50
                                                    },
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                                        quarter: 'MMM YYYY'
                        }
                    }
                    config.options.scales.xAxes[0] = seriesConfig;
                 }
                 //config.options.scales.yAxes[0].scaleLabel.labelString = 'RSSI ' + $scope.localMode;
                 chatObj1 = new Chart(link_char1, config);
                  if (isLive) {
                     config.data.labels = [];
                   // Initialize the Config null data to display window on start
                      for(i=0; i<$scope.arrayLimit; i++) {
                          if(i%20 == 0){
                              config.data.labels[i] = ((($scope.arrayLimit-1)-i) * ($scope.intervalTime/1000))/60 + 'm';
                          } else {
                              config.data.labels[i] = "";
                          }
                          if (config.data.datasets.length > 0) {
                              for (var j = 0; j< config.data.datasets.length;j++) {
                                  config.data.datasets[j].data[i] = null;
                              }
                           }
                      }
                  } else {
                      if (config.data.datasets.length > 0) {
                          for (var i = 0; i< config.data.datasets.length;i++) {
                              config.data.datasets[i].data = []
                          }
                       }
                      config.data.labels  = [];
                 }
            }
            function destroyNInitGraph2(isLive,config) {
                if (chatObj2!=null) {
                    chatObj2.destroy();
                }

                if (isLive) {
                     config.options.scales.xAxes[0] = {
                        gridLines: {
                                            display:false
                                        }
                     };
                     if (config.data.datasets.length > 0) {
                        for (var i = 0; i< config.data.datasets.length;i++) {
                            config.data.datasets[i].data = []
                        }
                     }
                     config.data.labels = [];

                 } else {
                     var seriesConfig = {
                        gridLines: {
                            display:false
                        },
                         ticks: {
                                                       fontSize: 12,
                                                       autoSkip: false,
                                                       maxRotation: 50,
                                                       minRotation: 50
                                                    },
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                                        quarter: 'MMM YYYY'
                        }
                    }
                    config.options.scales.xAxes[0] = seriesConfig;
                 }
                //config.options.scales.yAxes[0].scaleLabel.labelString = 'RSSI ' + $scope.remoteMode;
                 chatObj2 = new Chart(link_char2, config);
                  if (isLive) {
                     config.data.labels = [];
                   // Initialize the Config null data to display window on start
                      for(i=0; i<$scope.arrayLimit; i++) {
                          if(i%20 == 0){
                              config.data.labels[i] = ((($scope.arrayLimit-1)-i) * ($scope.intervalTime/1000))/60 + 'm';
                          } else {
                              config.data.labels[i] = "";
                          }
                          if (config.data.datasets.length > 0) {
                              for (var j = 0; j< config.data.datasets.length;j++) {
                                  config.data.datasets[j].data[i] = null;
                              }
                           }
                      }
                  } else {
                      if (config.data.datasets.length > 0) {
                          for (var i = 0; i< config.data.datasets.length;i++) {
                              config.data.datasets[i].data = []
                          }
                       }
                      config.data.labels  = [];
                 }
            }
            function destroyNInitGraph3(isLive,config) {
                if (chatObj3!=null) {
                    chatObj3.destroy();
                }

                if (isLive) {
                     config.options.scales.xAxes[0] = {
                        gridLines: {
                                            display:false
                                        }
                     };
                     if (config.data.datasets.length > 0) {
                        for (var i = 0; i< config.data.datasets.length;i++) {
                            config.data.datasets[i].data = []
                        }
                     }
                     config.data.labels = [];

                 } else {
                     var seriesConfig = {
                        gridLines: {
                            display:false
                        },
                         ticks: {
                                                       fontSize: 12,
                                                       autoSkip: false,
                                                       maxRotation: 50,
                                                       minRotation: 50
                                                    },
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                                        quarter: 'MMM YYYY'
                        }
                    }
                    config.options.scales.xAxes[0] = seriesConfig;
                 }
                 //config.options.scales.yAxes[0].scaleLabel.labelString = 'SNR ' + $scope.localMode;
                 chatObj3 = new Chart(link_char3, config);
                  if (isLive) {
                     config.data.labels = [];
                   // Initialize the Config null data to display window on start
                      for(i=0; i<$scope.arrayLimit; i++) {
                          if(i%20 == 0){
                              config.data.labels[i] = ((($scope.arrayLimit-1)-i) * ($scope.intervalTime/1000))/60 + 'm';
                          } else {
                              config.data.labels[i] = "";
                          }
                          if (config.data.datasets.length > 0) {
                              for (var j = 0; j< config.data.datasets.length;j++) {
                                  config.data.datasets[j].data[i] = null;
                              }
                           }
                      }
                  } else {
                      if (config.data.datasets.length > 0) {
                          for (var i = 0; i< config.data.datasets.length;i++) {
                              config.data.datasets[i].data = []
                          }
                       }
                      config.data.labels  = [];
                 }
            }

            function destroyNInitGraph4(isLive,config) {
                if (chatObj4!=null) {
                    chatObj4.destroy();
                }

                if (isLive) {
                     config.options.scales.xAxes[0] = {
                        gridLines: {
                                            display:false
                                        }
                     };
                     if (config.data.datasets.length > 0) {
                        for (var i = 0; i< config.data.datasets.length;i++) {
                            config.data.datasets[i].data = []
                        }
                     }
                     config.data.labels = [];

                 } else {
                     var seriesConfig = {
                        gridLines: {
                            display:false
                        },
                         ticks: {
                                                       fontSize: 12,
                                                       autoSkip: false,
                                                       maxRotation: 50,
                                                       minRotation: 50
                                                    },
                        type: 'time',
                        distribution: 'series',
                        displayFormats: {
                                        quarter: 'MMM YYYY'
                        }
                    }
                    config.options.scales.xAxes[0] = seriesConfig;
                 }
                //config.options.scales.yAxes[0].scaleLabel.labelString = 'SNR ' + $scope.remoteMode;
                 chatObj4 = new Chart(link_char4, config);
                  if (isLive) {
                     config.data.labels = [];
                   // Initialize the Config null data to display window on start
                      for(i=0; i<$scope.arrayLimit; i++) {
                          if(i%20 == 0){
                              config.data.labels[i] = ((($scope.arrayLimit-1)-i) * ($scope.intervalTime/1000))/60 + 'm';
                          } else {
                              config.data.labels[i] = "";
                          }
                          if (config.data.datasets.length > 0) {
                              for (var j = 0; j< config.data.datasets.length;j++) {
                                  config.data.datasets[j].data[i] = null;
                              }
                           }
                      }
                  } else {
                      if (config.data.datasets.length > 0) {
                          for (var i = 0; i< config.data.datasets.length;i++) {
                              config.data.datasets[i].data = []
                          }
                       }
                      config.data.labels  = [];
                 }
            }

            function destroyNInitLocalRSSIGraph(isLive) {
                destroyNInitGraph1(true,$scope.oct_chart_config);
                $scope.graphChartConfig[0] = $scope.oct_chart_config;
            }

            function destroyNInitRemoteRSSIGraph(isLive) {
                destroyNInitGraph2(true,$scope.pac_chart_config);
                $scope.graphChartConfig[1] = $scope.pac_chart_config;
            }

            function destroyNInitLinkSNRGraph(isLive) {
                destroyNInitGraph3(true,$scope.err_chart_config);
                $scope.graphChartConfig[2] = $scope.err_chart_config;
            }

            function destroyNInitRemoteSNRraph(isLive) {
                destroyNInitGraph4(true,$scope.dis_chart_config);
                 $scope.graphChartConfig[3] = $scope.dis_chart_config;
            }

            $scope.addLocalRSSIData = function(data) {
                var timeStamps = data.timestamps
                var values0 = data.columns[0].values;
                var values1 = data.columns[1].values;

                for (var i = 0; i < timeStamps.length - 1; i++) {
                    if (values0[i] == 'NaN') {
                        values0[i] = 0;
                    }
                    if (values1[i] == 'NaN') {
                        values1[i] = 0;
                    }
                    var d = new Date(timeStamps[i]);
                    $scope.oct_chart_config.data.labels[i] = d;
                    $scope.oct_chart_config.data.datasets[0].data.push(parseFloat(values0[i]).toFixed(0));
                    $scope.oct_chart_config.data.datasets[1].data.push(parseFloat(values1[i]).toFixed(0));
                    /*$scope.oct_chart_config.data.datasets[2].data.push($scope.lerssi);*/

                }
            }

            $scope.addRemoteRSSIData = function(data) {
                var timeStamps = data.timestamps
                var values0 = data.columns[0].values;
                var values1 = data.columns[1].values;

                for (var i = 0; i < timeStamps.length - 1; i++) {
                    if (values0[i] == 'NaN') {
                        values0[i] = 0;
                    }
                    if (values1[i] == 'NaN') {
                        values1[i] = 0;
                    }
                    var d = new Date(timeStamps[i]);
                    $scope.pac_chart_config.data.labels[i] = d;
                    $scope.pac_chart_config.data.datasets[0].data.push(parseFloat(values0[i]).toFixed(0));
                    $scope.pac_chart_config.data.datasets[1].data.push(parseFloat(values1[i]).toFixed(0));
                    /*$scope.pac_chart_config.data.datasets[2].data.push($scope.rerssi);*/

                }
            }
            $scope.addLocalSNRData = function(data) {
                var timeStamps = data.timestamps
                var values0 = data.columns[0].values;
                var values1 = data.columns[1].values;

                for (var i = 0; i < timeStamps.length -1; i++) {
                    if (values0[i] == 'NaN') {
                        values0[i] = 0;
                    }
                    if (values1[i] == 'NaN') {
                        values1[i] = 0;
                    }
                    var d = new Date(timeStamps[i]);
                    $scope.err_chart_config.data.labels[i] = d;
                    $scope.err_chart_config.data.datasets[0].data.push(parseFloat(values0[i]).toFixed(0));
                    $scope.err_chart_config.data.datasets[1].data.push(parseFloat(values1[i]).toFixed(0));

                }
            }

            $scope.addRemoteSNRData = function(data) {
                var timeStamps = data.timestamps
                var values0 = data.columns[0].values;
                var values1 = data.columns[1].values;

                for (var i = 0; i < timeStamps.length -1; i++) {
                    if (values0[i] == 'NaN') {
                        values0[i] = 0;
                    }
                    if (values1[i] == 'NaN') {
                        values1[i] = 0;
                    }
                    var d = new Date(timeStamps[i]);
                    $scope.dis_chart_config.data.labels[i] = d;
                    $scope.dis_chart_config.data.datasets[0].data.push(parseFloat(values0[i]).toFixed(0));
                    $scope.dis_chart_config.data.datasets[1].data.push(parseFloat(values1[i]).toFixed(0));

                }
            }


            $scope.changeGraphData = function (isLive) {

                $scope.clickId('#octl');
                $scope.clickId('#pacl');
                $scope.clickId('#errl');
                $scope.clickId('#disl');
                $scope.graphEvent('oct',$scope.selectedraphevent,1);
                $scope.graphEvent('pac',$scope.selectedraphevent,2);
                $scope.graphEvent('err',$scope.selectedraphevent,3);
                $scope.graphEvent('dis',$scope.selectedraphevent,4);

            }

            $scope.clickId = function(id) {
                var octl = angular.element(id);
                if (octl) {
                    octl.click();
                }
            }

            $scope.addLinkData = function(gra,duration,data,id) {
                var url= 'rest/measurements/node%5B'+$state.params.nodeId+'%5D.tifIndex%5B'+ $scope.ifIndex.val+'%5D?aggregation=AVERAGE&att='+data+'&duration='+duration;
                  if (duration == '1c') {
                    url = 'rest/measurements/node%5B'+$state.params.nodeId+'%5D.tifIndex%5B'+ $scope.ifIndex.val+'%5D?aggregation=AVERAGE&att='+data+'&duration='+duration + '&start=' + $scope.startsDate + '&end=' + $scope.endsDate;
                }
                 $http.get(url, {showdiv:false}).then(function(response) {
                        $scope.addResponseDataToGraph(response.data,id,gra);
                    });
            }
            $scope.addResponseDataToGraph = function(data,id,gra) {
                //var config = $scope.graphChartConfig[id];
                if (gra == 'oct') {
                     $scope.addLocalRSSIData(data);
                } else if (gra == 'pac') {
                     $scope.addRemoteRSSIData(data);
                } else if (gra == 'err') {
                     $scope.addLocalSNRData(data);
                } else if (gra == 'dis') {
                    $scope.addRemoteSNRData(data);
                }
                if (id == 1) {
                    chatObj1.update();
                } else if (id == 2) {
                    chatObj2.update();
                } else if (id == 3) {
                    chatObj3.update();
                } else if (id == 4) {
                    chatObj4.update();
                }
            }

            $scope.showCustomeDataif = function () {
                console.log($scope.startDate);
                console.log($scope.endDate);
                $scope.startsDate = new Date($scope.startDate).getTime();
                $scope.endsDate = new Date($scope.endDate).getTime();
                $scope.graphEvent('oct',6,1);  //oct with selected tab like hour, day
                 $scope.graphEvent('pac',6,2);
                 $scope.graphEvent('err',6,3);
                 $scope.graphEvent('dis',6,4);
            }


            $scope.selectedraphevent=1;
            $scope.clickgraphevent=function(gra,id){
            $scope.selectedraphevent=id;
                $scope.graphEvent('oct',id,1);  //oct with selected tab like hour, day
                $scope.graphEvent('pac',id,2);
                $scope.graphEvent('err',id,3);
                $scope.graphEvent('dis',id,4);

            }

            $scope.graphEvent = function(gra,event,id) {
               $scope.eventCode = event;
               var isLive = false;

               var d = "1h";
               if (event == 2) {
                   d = "1h";
                    $scope.graphclickevent=2;
               } else if (event == 3) {
                   d = "1d";
                        $scope.graphclickevent=3;
               } else if (event == 4) {
                   d = "1m";
                        $scope.graphclickevent=4;
               } else if (event == 5) {
                    d = "1w";
                         $scope.graphclickevent=5;
                } else if (event == 6) {
                  d = "1c";
              } else {
                   d = "1h";
                   isLive = true;
                      $scope.graphclickevent=1;
               }
            $rootScope.graphclickeventnewsw=$scope.graphclickevent;
                var data = $scope.chartMap[gra];
               if (id == 1) {                                   //oct
                    $scope.liveGraph[0] = isLive;
                    $scope.graphDura [0] = id;
                     $scope.octdur = event;
                    destroyNInitGraph1(isLive,$scope.graphChartConfig[0]);
               } else if (id == 2) {                                //pac
                    $scope.liveGraph[1] = isLive;
                    $scope.graphDura [1] = id;
                    destroyNInitGraph2(isLive,$scope.graphChartConfig[1]);
               } else if (id == 3) {                                    //err
                    $scope.liveGraph[2] = isLive;
                    $scope.graphDura [2] = id;
                    destroyNInitGraph3(isLive,$scope.graphChartConfig[2]);
               } else if (id ==  4) {                                  //dis
                    $scope.liveGraph[3] = isLive;
                    $scope.graphDura [3] = id;
                    destroyNInitGraph4(isLive,$scope.graphChartConfig[3]);
                    //
               }
               if (!isLive) {
                    $scope.addLinkData(gra,d,data,id);
               }
            }

   $scope.clickgraphevent('oct',$rootScope.graphclickeventnewsw);
         } // end if_init(
 }]);