dashboard.controller("VlanProfileConfigController", ['$rootScope', '$scope', '$mdDialog', '$http', '$state', '$location', 'dashboardService', 'Flash',
    function($rootScope, $scope, $mdDialog, $http, $state, $location, dashboardService, Flash) {

        //this is default width
        $scope.tableWidth = "col-md-12";

        $scope.filter = {};
        //radio mode
        $scope.radioMode = [{
                'name': "All",
                'value': -1
            },
            {
                'name': "AP",
                'value': 1
            }, {
                'name': "SU",
                'value': 2
            }
        ];
        //vlan modes
        $scope.vlanModes = [{
            "vlanMode": 0,
            "vlanmodeVal": "Transparent"
        }, {
            "vlanMode": 1,
            "vlanmodeVal": "Access"
        }, {
            "vlanMode": 2,
            "vlanmodeVal": "Trunk"
        }, {
            "vlanMode": 3,
            "vlanmodeVal": "Q-in-Q"
        }];
        //link types
        $scope.linkType = [{
            'name': "All",
            'value': -1
        }, {
            'name': "PTP",
            'value': 1
        }, {
            'name': "BackHaul",
            'value': 2
        }, {
            'name': "PTMP",
            'value': 3
        }];
        //vlan status
        $scope.vlanStatus = [{
            "vlanStatus": 2,
            "vlanstatusVal": "Disable"
        }, {
            "vlanStatus": 1,
            "vlanstatusVal": "Enable"
        }];

        //ethernet types
        $scope.svLanEthObj = [{
                'name': '0x8100',
                'value': '0x0081'
            },
            {
                'name': '0x88a8',
                'value': '0xa888'
            },
            {
                'name': '0x9100',
                'value': '0x0091'
            },
            {
                'name': '0x9200',
                'value': '0x0092'
            }
        ];
        //trunk object
        $scope.trunkObj = [{
            "vlanTrunkOptionId": 1,
            "trunkVal": "List"
        }, {
            "vlanTrunkOptionId": 2,
            "trunkVal": "All"
        }];
        //from config controller to this method calling
        //if config controller click vlanprofile this method initates
        $rootScope.$on("init_vlan", function() {
            $scope.init();
        });
        $scope.init = function() {
                $scope.avlanProfileObj = {};
                $scope.avlanProfileObj.vlanStatus='';
                $scope.avlanProfileObj.vlanMode='';
                $scope.avlanProfileObj.vlanMgmtId='';
                $scope.avlanProfileObj.vlanAccessId='';
                $scope.avlanProfileObj.vlanTrunkOptionId='';
                $scope.avlanProfileObj.vlanTrunkId='';
                $scope.avlanProfileObj.vlanSvlanId='';
                $scope.avlanProfileObj.vlanEtherType='';
                $scope.vdefProfileObj = {};
                $scope.vdefProfileObj.vlanStatus='required';
                $scope.vdefProfileObj.vlanMode='required';
                $scope.vdefProfileObj.vlanMgmtId='required';
                $scope.vdefProfileObj.vlanAccessId='required';
                $scope.vdefProfileObj.vlanTrunkOptionId='required';
                $scope.vdefProfileObj.vlanTrunkId='required';
                $scope.vdefProfileObj.vlanSvlanId='required';
                $scope.vdefProfileObj.vlanEtherType='required';
                if (!$rootScope.profileID) {
                    $scope.create_vlan_profile = true;
                    $scope.edit_vlan_profile = false;
                    $scope.vlanProfileObj = {};
                    $scope.vlanProfileObj.rMode = $scope.radioMode[0];
                    $scope.vlanProfileObj.lType = $scope.linkType[0];
                    $scope.vlanProfileObj.vlStatus = $scope.vlanStatus[1];
                    $scope.vlanProfileObj.vlanMgmtId = 1;
                    if ($scope.vlanProfileObj.vlStatus.vlanstatusVal == 'Enable') {
                        $scope.disableRemainingcomponents = true;
                        showVlanModes();
                    } else { $scope.disableRemainingcomponents = false; }
                } else {
                    $scope.create_vlan_profile = false;
                    $scope.edit_vlan_profile = true;

                    $scope.vlanProfileObj = {};
                    var url = 'api/v2/profiles/template/get?profile=' + $rootScope.profileID;
                    //  var url = 'api/v2/profiles/template/list?ttype=' +$scope.ttype +'&ltype=' +$scope.ltype + '&rtype=' +$scope.rtype;

                    $http.get(url).then(function(response) {
                        $scope.vlanProfileObj.vlanProfileName = response.data.name;
                        $scope.vlanProfileObj.rMode = {
                            value: response.data.radioMode
                        }
                        $scope.vlanProfileObj.rmodeName = response.data.radioMode;
                        $scope.vlanProfileObj.lType = {
                            value: response.data.linkType
                        }
                        $scope.vlanProfileObj.linkTypeName = response.data.linkType;
                        $scope.vlanProfileObj.vlStatus = {
                            vlanStatus: response.data.vdto.vlanStatus
                        }
                        if (response.data.vdto.vlanStatus == 1) {
                            $scope.disableRemainingcomponents = true;

                        } else {
                            $scope.disableRemainingcomponents = false;
                            //first reset all values
                            $scope.vlanProfileObj.vlMode = '';
                            $scope.vlanProfileObj.vlanMgmtId = '';
                            $scope.vlanProfileObj.vlanAccessId = '';
                            $scope.vlanProfileObj.trnkMode = '';
                            $scope.vlanProfileObj.vlanTrunkId = '';
                            $scope.vlanProfileObj.sVlanID = '';
                            $scope.vlanProfileObj.svlanTypeID = '';
                            $scope.optionArray = [];
                        }

                        $scope.vlanProfileObj.vlMode = {
                            vlanMode: response.data.vdto.vlanMode
                        }
                        if (response.data.vdto.vlanMode == 3) {
                            $scope.selectedSubDiv = 'Q-in-Q';
                        } else if (response.data.vdto.vlanMode == 2) {
                            $scope.selectedSubDiv = 'Trunk';
                        } else if (response.data.vdto.vlanMode == 0) {
                            $scope.selectedSubDiv = 'Transparent';
                        } else if (response.data.vdto.vlanMode == 1) {
                            $scope.selectedSubDiv = 'Access';
                        }

                        //showVlanModes();
                        $scope.vlanProfileObj.vlanMgmtId = response.data.vdto.vlanMgmtId;
                        $scope.vlanProfileObj.vlanAccessId = response.data.vdto.vlanAccessId;
                        $scope.vlanProfileObj.trnkMode = {
                            vlanTrunkOptionId: response.data.vdto.vlanTrunkOptionId
                        }
                        if (response.data.vdto.vlanTrunkOptionId == 1) {
                            $scope.trunkvlanID = true;
                        }
                        if (response.data.vdto.vlanTrunkId) {
                            $scope.optionArray = response.data.vdto.vlanTrunkId.split(' ');
                            $scope.trunkvlanID = true;
                        }
                        //$scope.vlanProfileObj.vlanTrunkId = response.data.vdto.vlanTrunkId;
                        $scope.vlanProfileObj.sVlanID = response.data.vdto.vlanSvlanId;
                        $scope.vlanProfileObj.svlanTypeID = {
                            value: response.data.vdto.vlanEtherType
                        }
                    });
                }
            }
            //vlan status change
        $scope.vlastatus = function(vstat) {
                if (vstat.vlanstatusVal == 'Disable') {
                    $scope.disableRemainingcomponents = false;
                    //first reset all values
                    $scope.vlanProfileObj.vlMode = '';
                    $scope.vlanProfileObj.vlanMgmtId = '';
                    $scope.vlanProfileObj.vlanAccessId = '';
                    $scope.vlanProfileObj.trnkMode = '';
                    $scope.vlanProfileObj.vlanTrunkId = '';
                    $scope.vlanProfileObj.sVlanID = '';
                    $scope.vlanProfileObj.svlanTypeID = '';
                    $scope.selectedSubDiv = "";
                    $scope.trunkvlanID = false;
                    $scope.optionArray = [];
                } else {
                    $scope.disableRemainingcomponents = true;
                    $scope.vlanProfileObj.vlanMgmtId = 1;
                    showVlanModes();
                }
            }
            //radio type change
        $scope.radioTypeChange = function(rMode) {
                $scope.vlanProfileObj.rmodeName = rMode.value;
                showVlanModes();
            }
            //link type change
        $scope.linkTypeChange = function(ltype) {
            $scope.vlanProfileObj.linkTypeName = ltype.value;
            showVlanModes();
        }

        $scope.removeProperty = function(propery) {
            console.log(propery);
            //propery = null;
            $scope.vlanProfileObj[propery] = null;
            $scope.avlanProfileObj[propery] = 'display:none;';
            $scope.vdefProfileObj[propery]  ='';
        }

        function showVlanModes() {

            if ($scope.vlanProfileObj.rmodeName && $scope.vlanProfileObj.linkTypeName) {
                if ($scope.vlanProfileObj.rmodeName == 2 && ($scope.vlanProfileObj.linkTypeName == 1 || $scope.vlanProfileObj.linkTypeName == 3)) {
                    $scope.vlanModes = [{
                        "vlanMode": 0,
                        "vlanmodeVal": "Transparent"
                    }, {
                        "vlanMode": 1,
                        "vlanmodeVal": "Access"
                    }, {
                        "vlanMode": 2,
                        "vlanmodeVal": "Trunk"
                    }, {
                        "vlanMode": 3,
                        "vlanmodeVal": "Q-in-Q"
                    }];
                    $scope.vlanProfileObj.vlMode = $scope.vlanModes[0];
                } else {
                    $scope.vlanModes = [{
                        "vlanMode": 0,
                        "vlanmodeVal": "Transparent"
                    }];
                    $scope.vlanProfileObj.vlMode = $scope.vlanModes[0];
                    $scope.selectedSubDiv = "";
                    $scope.vlanProfileObj.trnkMode = '';
                    $scope.vlanProfileObj.vlanTrunkId = '';
                    $scope.vlanProfileObj.vlanAccessId = '';
                    $scope.vlanProfileObj.sVlanID = '';
                    $scope.vlanProfileObj.svlanTypeID = '';
                    $scope.optionArray = [];
                }
            } else {
                $scope.vlanModes = [{
                    "vlanMode": 0,
                    "vlanmodeVal": "Transparent"
                }];
                $scope.vlanProfileObj.vlMode = $scope.vlanModes[0];
            }
        }
        //close the selected form
        $scope.toggleForm = function() {
                $scope.$emit("toggleFormFunction");
            }
            //onchange method
        $scope.vlmodeChange = function(selectedvlmode) {
                console.log("vlmo", selectedvlmode);
                if (selectedvlmode.vlanmodeVal == 'Transparent') {
                    $scope.vlanProfileObj.trnkMode = '';
                    $scope.vlanProfileObj.vlanTrunkId = '';
                    $scope.vlanProfileObj.vlanAccessId = '';
                    $scope.vlanProfileObj.sVlanID = '';
                    $scope.vlanProfileObj.svlanTypeID = '';
                    $scope.optionArray = [];
                    $scope.selectedSubDiv = selectedvlmode.vlanmodeVal;
                } else if (selectedvlmode.vlanmodeVal == 'Access') {
                    $scope.vlanProfileObj.trnkMode = '';
                    $scope.vlanProfileObj.vlanTrunkId = '';
                    $scope.vlanProfileObj.sVlanID = '';
                    $scope.vlanProfileObj.svlanTypeID = '';
                    $scope.optionArray = [];
                    $scope.selectedSubDiv = selectedvlmode.vlanmodeVal;
                } else if (selectedvlmode.vlanmodeVal == 'Trunk') {
                    $scope.vlanProfileObj.vlanAccessId = '';
                    $scope.vlanProfileObj.sVlanID = '';
                    $scope.vlanProfileObj.svlanTypeID = '';
                    $scope.trunkObj = [{
                        "vlanTrunkOptionId": 1,
                        "trunkVal": "List"
                    }, {
                        "vlanTrunkOptionId": 2,
                        "trunkVal": "All"
                    }];
                    $scope.vlanProfileObj.trnkMode = $scope.trunkObj[1];
                    $scope.selectedSubDiv = selectedvlmode.vlanmodeVal;
                } else if (selectedvlmode.vlanmodeVal == 'Q-in-Q') {
                    $scope.vlanProfileObj.vlanAccessId = '';
                    $scope.selectedSubDiv = selectedvlmode.vlanmodeVal;

                    $scope.vlanProfileObj.svlanTypeID = $scope.svLanEthObj[0];

                    $scope.vlanProfileObj.trnkMode = $scope.trunkObj[1];
                    $scope.selectedSubDiv = selectedvlmode.vlanmodeVal;
                    $scope.vlanProfileObj.sVlanID = 100;
                }

            }
            //trunk change method
        $scope.vltrunkChange = function(trnkMode) {
            if (trnkMode.trunkVal == 'List') {
                $scope.trunkvlanID = true;
            } else {
                $scope.trunkvlanID = false;
                $scope.optionArray = [];
            }
        }
        $scope.optionArray = [];
        // add trunk options upto 100
        $scope.addtrunkOptions = function() {
            if ($scope.vlanProfileObj.vlanTrunkId && ($scope.vlanProfileObj.vlanTrunkId > 0 && $scope.vlanProfileObj.vlanTrunkId <= 4094)) {
                if ($scope.optionArray.length <= 100) {
                    var repeatVlanTrunkId = false;
                    for (var i = 0; i < $scope.optionArray.length; i++) {
                        if ($scope.optionArray[i] == $scope.vlanProfileObj.vlanTrunkId) {
                            repeatVlanTrunkId = true
                        }
                    }
                    if (!repeatVlanTrunkId) {
                        $scope.optionArray.push($scope.vlanProfileObj.vlanTrunkId);
                    }

                } else {
                    $scope.showAlert("No more than 100 entries")
                }
            } else {
                $scope.showAlert("Please Enter Valid Input");
            }
            $scope.vlanProfileObj.vlanTrunkId = '';
        }

        //splice option
        $scope.deleteOption = function(ind) {
                $scope.optionArray.splice(ind, 1);
            }
            //vlan access id validate
        $scope.checknum = function(num, type) {
                if (num < 1 || num > 4094) {
                    if (type == 'vlanMgmtId') {
                        $scope.vlanProfileObj[type] = "";
                    } else if (type == 'vlanAccessId') {
                        $scope.vlanProfileObj[type] = "";
                    } else if (type == 'sVlanID') {
                        $scope.vlanProfileObj[type] = "";
                    }
                }
            }
            //post call for valn profile
        $scope.createVlanProfile = function() {
            $scope.trunkID = "";
            if ($scope.optionArray.length > 0) {
                for (var i = 0; i < $scope.optionArray.length; i++) {
                    $scope.trunkID = $scope.trunkID + $scope.optionArray[i];
                    if (i + 1 < $scope.optionArray.length) {
                        $scope.trunkID = $scope.trunkID + " ";
                    }
                }
            }
            var vlanObj = {
                    "profileType": 1,
                    "name": $scope.vlanProfileObj.vlanProfileName.split(" ").join(""),
                    "radioMode": $scope.vlanProfileObj.rMode.value,
                    "linkType": $scope.vlanProfileObj.lType.value,
                    "vdto": {
                        "radio": 0,
                        "nodeId": 0,
                        "status": 0,
                        "message": null,
                        "vlanStatus": $scope.vlanProfileObj.vlStatus ? $scope.vlanProfileObj.vlStatus.vlanStatus : null,
                        "vlanMode": $scope.vlanProfileObj.vlMode ? $scope.vlanProfileObj.vlMode.vlanMode : null,
                        "vlanMgmtId": $scope.vlanProfileObj.vlanMgmtId ? $scope.vlanProfileObj.vlanMgmtId : null,
                        "vlanAccessId": $scope.vlanProfileObj.vlanAccessId ? $scope.vlanProfileObj.vlanAccessId : null,
                        "vlanTrunkOptionId": $scope.vlanProfileObj.trnkMode ? $scope.vlanProfileObj.trnkMode.vlanTrunkOptionId : null,
                        "vlanTrunkId": $scope.trunkID ? $scope.trunkID : null,
                        "vlanSvlanId": $scope.vlanProfileObj.sVlanID ? $scope.vlanProfileObj.sVlanID : null,
                        "vlanEtherType": $scope.vlanProfileObj.svlanTypeID ? $scope.vlanProfileObj.svlanTypeID.value : null,
                        "vlanBackboneDestMAC": null,
                        "vlanBackboneSrcMAC": null,
                        "vlanBackboneVlanId": null,
                        "vlanBackboneSrvInstanceVlanId": null
                    }
                }
                //   hear is our service call
            console.log("postObj", JSON.stringify(vlanObj));
            var confirm = $scope.createConfirm();

            $mdDialog.show(confirm).then(function() {
                $http({
                    method: 'POST',
                    url: 'api/v2/profiles/template',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    data: vlanObj
                }).success(function() {
                    $scope.showAlert('Success', 'Created successfully.');
                    $scope.vlanProfileObj = {};
                    $scope.optionArray = [];
                    $scope.ttype = 1;
                    $scope.$emit("defaultCall", $scope.ttype);
                    $scope.$emit("toggleFormFunction");
                    $scope.init();
                }).error(function(msg) {
                    $scope.showAlert('Error', 'Error creating Data: ' + msg);
                });
            });

        }

        //update vlan profile
        $scope.updateVlanProfile = function() {

                $scope.trunkID = "";
                if ($scope.optionArray.length > 0) {
                    for (var i = 0; i < $scope.optionArray.length; i++) {
                        $scope.trunkID = $scope.trunkID + $scope.optionArray[i];
                        if (i + 1 < $scope.optionArray.length) {
                            $scope.trunkID = $scope.trunkID + " ";
                        }
                    }
                }
                var vlanObj = {
                    "profileType": 1,
                    "name": $scope.vlanProfileObj.vlanProfileName.split(" ").join(""),
                    "profileId": $rootScope.profileID,
                    "radioMode": $scope.vlanProfileObj.rMode.value,
                    "linkType": $scope.vlanProfileObj.lType.value,
                    "vdto": {
                        "radio": 0,
                        "nodeId": 0,
                        "status": 0,
                        "message": null,
                        "vlanStatus": $scope.vlanProfileObj.vlStatus.vlanStatus,
                        "vlanMode": $scope.vlanProfileObj.vlMode ? $scope.vlanProfileObj.vlMode.vlanMode : null,
                        "vlanMgmtId": $scope.vlanProfileObj.vlanMgmtId ? $scope.vlanProfileObj.vlanMgmtId : null,
                        "vlanAccessId": $scope.vlanProfileObj.vlanAccessId ? $scope.vlanProfileObj.vlanAccessId : null,
                        "vlanTrunkOptionId": $scope.vlanProfileObj.trnkMode ? $scope.vlanProfileObj.trnkMode.vlanTrunkOptionId : null,
                        "vlanTrunkId": $scope.trunkID ? $scope.trunkID : null,
                        "vlanSvlanId": $scope.vlanProfileObj.sVlanID ? $scope.vlanProfileObj.sVlanID : null,
                        "vlanEtherType": $scope.vlanProfileObj.svlanTypeID ? $scope.vlanProfileObj.svlanTypeID.value : null,
                        "vlanBackboneDestMAC": null,
                        "vlanBackboneSrcMAC": null,
                        "vlanBackboneVlanId": null,
                        "vlanBackboneSrvInstanceVlanId": null
                    }
                }

                //var finalObj = clean(vlanObj);

                //   hear is our service call
                var confirm = $scope.saveconfirm();

                $mdDialog.show(confirm).then(function() {
                    $http({
                        method: 'POST',
                        url: 'api/v2/profiles/template/update',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        data: vlanObj
                    }).success(function() {
                        $scope.showAlert('Success', 'Updated successfully.');
                        //$scope.vlanProfileObj = {};
                        $scope.ttype = 1;
                        $scope.$emit("defaultCall", $scope.ttype);
                        $scope.$emit("toggleFormFunction");
                    }).error(function(msg) {
                        $scope.showAlert('Error', 'Error updating Data: ' + msg);
                    });
                });

            }
            //  this method is used for removing undefined and null ke values from object
        function clean(obj) {
            for (var propName in obj) {
                if (obj[propName] === null || obj[propName] === undefined || obj[propName] === "") {
                    delete obj[propName];
                }
            }
            return obj;
        }
        //create conformation
        $scope.createConfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to create this profile?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };
        //update conformation
        $scope.saveconfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to update these changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')


            return confirm;
        };

    }
]);
