dashboard.controller("WirelessProfileConfigController", ['$rootScope', '$scope', '$mdDialog', '$http', '$state', '$location', 'dashboardService', 'Flash',
    function($rootScope, $scope, $mdDialog, $http, $state, $location, dashboardService, Flash) {

        //this is default width
        $scope.tableWidth = "col-md-12";
        $scope.wirelessProfileObj = {};
        $scope.filter = {};
        $scope.defaultObj = {};
        //radio mode
        $scope.radioMode = [ {
            'name': "AP",
            'value': 1
        }, {
            'name': "SU",
            'value': 2
        }];
        //link types
        $scope.linkType = [ {
            'name': "PTP",
            'value': 1
        }, {
            'name': "BackHaul",
            'value': 2
        }, {
            'name': "PTMP",
            'value': 3
        }];
        //country array
        $scope.country5Array = [
//        {
//            "id": 5018,
//            "val": "INDIA"
//        }, {
//            "id": 5019,
//            "val": "5 GHz"
//        }, {
//            "id": 5011,
//            "val": "US"
//        },
          {
                    "id": 5011,
                    "val": "US 5GHz Non-DFS"
                },
                {
                    "id": 5012,
                    "val": "US 5GHz All"
                },
                {
                    "id": 5013,
                    "val": "US 4.9GHz"
                }
        ];
        //bandwidth array
        $scope.bandwidth5Array = [{
            "id": "HT20",
            "val": "20MHZ"
        }, {
            "id": "HT40",
            "val": "40MHZ"
        }, {
            "id": "HT80",
            "val": "80MHZ"
        }];
        //channel array
        $scope.channel5Array = [];
        $scope.loadChannels = function () {
            $scope.channel5Array = [];

            var start1 = 22;
            var end1 = 68;
            var start2 = 0;
            var end2 = 0;
             var start3 = 0;
              var end3 = 0;
              var start4 = 0;
              var end4 = 0;
            var freq1 = 5110;
            var freq2 = 5480;
        $scope.bandwidth5Array = [{
            "id": "HT20",
            "val": "20MHZ"
        }, {
            "id": "HT40",
            "val": "40MHZ"
        }, {
            "id": "HT80",
            "val": "80MHZ"
        }];

            if (!$scope.wirelessProfileObj.country5) {
                $scope.wirelessProfileObj.country5 = $scope.country5Array[0];
            }
            if ($scope.wirelessProfileObj.country5.id == 5018) {
                if ($scope.wirelessProfileObj.bandwidth5.id == 'HT20') {
                    start1 = 22;
                    end1 = 68;
                    start2 = 96;
                    end2 = 183;
                    freq1 = 5110;
                    freq2 = 5480;
                } else if ($scope.wirelessProfileObj.bandwidth5.id == 'HT40') {
                    start1 = 24;
                    end1 = 66;
                    start2 = 98;
                    end2 = 181;
                    freq1 = 5120;
                    freq2 = 5490;
                } else if ($scope.wirelessProfileObj.bandwidth5.id == 'HT80') {
                    start1 = 28;
                    end1 = 62;
                    start2 = 102;
                    end2 = 177;
                    freq1 = 5140;
                    freq2 = 5510;
                }

            } else if ($scope.wirelessProfileObj.country5.id == 5019) {
                if ($scope.wirelessProfileObj.bandwidth5.id == 'HT20') {
                    start1 = 22;
                    end1 = 183;
                    start2 = 0;
                    end2 = 0;
                    freq1 = 5110;
                    freq2 = 5915;
                } else if ($scope.wirelessProfileObj.bandwidth5.id == 'HT40') {
                    start1 = 24;
                    end1 = 181;
                    start2 = 0;
                    end2 = 0;
                    freq1 = 5120;
                    freq2 = 5905;
                } else if ($scope.wirelessProfileObj.bandwidth5.id == 'HT80') {
                    start1 = 28;
                    end1 = 177;
                    start2 = 0;
                    end2 = 0;
                    freq1 = 5140;
                    freq2 = 5850;
                }
            }
//            else if ($scope.wirelessProfileObj.country5.id == 5011) {
//                 if ($scope.wirelessProfileObj.bandwidth5.id == 'HT20') {
//                     start1 = 36;
//                     end1 = 48;
//                     start2 = 149;
//                     end2 = 165;
//                     freq1 = 5180;
//                     freq2 = 5745;
//                 } else if ($scope.wirelessProfileObj.bandwidth5.id == 'HT40') {
//                     start1 = 38;
//                     end1 = 46;
//                     start2 = 151;
//                     end2 = 159;
//                     freq1 = 5190;
//                     freq2 = 5755;
//                 } else if ($scope.wirelessProfileObj.bandwidth5.id == 'HT80') {
//                     start1 = 42;
//                     end1 = 42;
//                     start2 = 155;
//                     end2 = 155;
//                     freq1 = 5210;
//                     freq2 = 0;
//                 }
//             }
else if ($scope.wirelessProfileObj.country5.id == 5011) {
                    if ($scope.wirelessProfileObj.bandwidth5.id == 'HT20') {
                        start1 = 36;
                        end1 = 48;
                        start2 = 149;
                        end2 = 165;
                        freq1 = 5180;
                        freq2 = 5745;
                    } else if ($scope.wirelessProfileObj.bandwidth5.id == 'HT40' || $scope.wirelessProfileObj.bandwidth5.id == 'HT40+') {
                        start1 = 38;
                        end1 = 46;
                        start2 = 151;
                        end2 = 159;
                        freq1 = 5190;
                        freq2 = 5755;
                    } else if ($scope.wirelessProfileObj.bandwidth5.id == 'HT80') {
                        start1 = 42;
                        end1 = 42;
                        start2 = 155;
                        end2 = 155;
                        freq1 = 5210;
                        freq2 = 5775;
                    }
                }
                else if ($scope.wirelessProfileObj.country5.id == 5012) {
                    if ($scope.wirelessProfileObj.bandwidth5.id == 'HT20') {
                        start1 = 36;
                        end1 = 48;
                        start2 = 52;
                        end2 = 64;
                        start3 = 100;
                        end3 = 165;
                        start4 = 0;
                        end4 = 0;
                        freq1 = 5180;
                        freq2 = 5260;
                        freq3 = 5500;
                    } else if ($scope.wirelessProfileObj.bandwidth5.id == 'HT40' || $scope.wirelessProfileObj.bandwidth5.id == 'HT40+') {
                        start1 = 38;
                        end1 = 46;
                        start2 = 54;
                        end2 = 62;
                        start3 = 102;
                        end3 = 159;
                        start4 = 0;
                        end4 = 0;
                        freq1 = 5190;
                        freq2 = 5270;
                        freq3 = 5510;
                    } else if ($scope.wirelessProfileObj.bandwidth5.id == 'HT80') {
                        start1 = 42;
                        end1 = 42;
                        start2 = 58;
                        end2 = 58;
                        start3 = 106;
                        end3 = 122;
                        start4 = 155;
                        end4 = 155;
                        freq1 = 5210;
                        freq2 = 5290;
                        freq3 = 5530;
                        freq4 = 5775;
                    }
                }
                else if ($scope.wirelessProfileObj.country5.id == 5013) {
             $scope.bandwidth5Array = [{
                       "id": "HT20",
                       "val": "20MHZ"
                   }];
                    if ($scope.wirelessProfileObj.bandwidth5.id == 'HT20') {
                        start1 = 190;
                        end1 = 196;
                        start2 = 0;
                        end2 = 0;
                        freq1 = 4950;
                    }
                }
            var freqVal;
            for (var i = start1, freq = freq1; i <= end1; i++, freq = freq + 5) {
                $scope.freqVal = freq + 'MHz';

                $scope.channel5Array.push({
                    "id": i,
                    "val": i + ' (' + $scope.freqVal + ')'
                });
            }
            if(start2!=0){
            // if ($scope.wirelessProfileObj.country5.id == 5018  || $scope.wirelessProfileObj.country5.id == 5011 ) {
                for (var i = start2, freq = freq2; i <= end2; i++, freq = freq + 5) {
                    $scope.freqVal = freq + 'MHz';
                    $scope.channel5Array.push({
                        "id": i,
                        "val": i + ' (' + $scope.freqVal + ')'
                    });
                }
                //   }
            }
            if(start3!=0){
                for (var i = start3, freq = freq3; i <= end3; i++, freq = freq + 5) {
                    $scope.freqVal = freq + 'MHz';
                    $scope.channel5Array.push({
                        "id": i,
                        "val": i + ' (' + $scope.freqVal + ')'
                    });
                }
            }
            if(start4!=0){
                for (var i = start4, freq = freq4; i <= end4; i++, freq = freq + 5) {
                    $scope.freqVal = freq + 'MHz';
                    $scope.channel5Array.push({
                        "id": i,
                        "val": i + ' (' + $scope.freqVal + ')'
                    });
                }
            }
            $scope.wirelessProfileObj.channel5 = $scope.channel5Array[0];
        }
        //from config controller to this method calling
        //if config controller click wireless this method initates
        $rootScope.$on("init_wireless", function() {

            $scope.init();
        });
        $scope.init = function() {
                $scope.defProfileObj = {};
                $scope.defProfileObj.ssid5 = '';
                $scope.defProfileObj.country5 = '';
                $scope.defProfileObj.bandwidth5 = '';
                $scope.defProfileObj.channel5 = '';
                $scope.defProfileObj.radioStatus24 = '';
                $scope.defProfileObj.ssid24 = '';
                $scope.defProfileObj.channel24 = '';
                $scope.defProfileObj.disableLegacy24 = '';
                $scope.defProfileObj.hideSSID24Val = '';
                $scope.defProfileObj.maxClients24 = '';
                $scope.defProfileObj.upLink = '';
                $scope.defProfileObj.downLink = '';
                $scope.defProfileObj.inactiveTimer = '';
                $scope.vdefProfileObj = {};
                $scope.vdefProfileObj.ssid5 = '';
                $scope.vdefProfileObj.country5 = '';
                $scope.vdefProfileObj.bandwidth5 = '';
                $scope.vdefProfileObj.channel5 = '';
                $scope.vdefProfileObj.radioStatus24 = '';
                $scope.vdefProfileObj.ssid24 = '';
                $scope.vdefProfileObj.channel24 = '';
                $scope.vdefProfileObj.disableLegacy24 = '';
                $scope.vdefProfileObj.hideSSID24Val = '';
                $scope.vdefProfileObj.maxClients24 = '';
                $scope.vdefProfileObj.upLink = '';
                $scope.vdefProfileObj.downLink = '';
                $scope.vdefProfileObj.inactiveTimer = '';



                if (!$rootScope.profileID) {


                    $scope.create_wireless_profile = true;
                    $scope.edit_wireless_profile = false;
                    $scope.defaultObj.rMode = $scope.radioMode[0];
                    $scope.defaultObj.lType = $scope.linkType[2];


                    $scope.apRadioMode = true;
                    $scope.wirelessProfileObj = {};
                    $scope.wirelessProfileObj.ssid5 = "OR100";//"SifySMAC3";
                    if ($rootScope.buildCode && $rootScope.buildCode == "US") {
                        $scope.wirelessProfileObj.country5 = $scope.country5Array[2];
                    } else {
                        $scope.wirelessProfileObj.country5 = $scope.country5Array[0];
                    }

                    $scope.wirelessProfileObj.rMode = $scope.radioMode[0];
                    $scope.wirelessProfileObj.lType = $scope.linkType[2];

                    $scope.wirelessProfileObj.bandwidth5 = $scope.bandwidth5Array[0];
                    $scope.loadChannels();
                    $scope.wirelessProfileObj.channel5 = $scope.channel5Array[0];

                    $scope.wirelessProfileObj.radioStatus24 = $scope.radioStatus24Array[0];
                    $scope.wirelessProfileObj.ssid24 = "SMAC3_Wi-Fi";
                    $scope.wirelessProfileObj.channel24 = $scope.channel24Array[0];
                    $scope.wirelessProfileObj.disableLegacy24 = $scope.disableLegacy24Array[0];
                    $scope.wirelessProfileObj.hideSSID24Val = true;
                    $scope.wirelessProfileObj.maxClients24 = 2;
                    $scope.wirelessProfileObj.upLink = '86700';
                    $scope.wirelessProfileObj.downLink = '86700';
                    $scope.wirelessProfileObj.inactiveTimer = '15';

                    $scope.wirelessProfileObj.trafficeShapeStat = null;
                } else {
                    $scope.wirelessProfileObj = {};
                    $scope.create_wireless_profile = false;
                    $scope.edit_wireless_profile = true;
                    var url = 'api/v2/profiles/template/get?profile=' + $rootScope.profileID;


                    $http.get(url).then(function(response) {

                        $scope.wirelessProfileObj.wirelessProfileName = response.data.name;
                        $scope.wirelessProfileObj.rMode = {
                            value: response.data.radioMode
                        }
                        $scope.wirelessProfileObj.lType = {
                            value: response.data.linkType
                        }

                        if ($scope.wirelessProfileObj.rMode.value == 1) {
                            $scope.apRadioMode = true;
                        }
                        $scope.wirelessProfileObj.ssid5 = response.data.wdto.radioFiveSSID;

                        $scope.wirelessProfileObj.upLink = response.data.wdto.upLink;
                        $scope.wirelessProfileObj.downLink = response.data.wdto.downLink;
                        $scope.wirelessProfileObj.inactiveTimer = response.data.wdto.inactiveTimer;

                        $scope.wirelessProfileObj.trafficShape = {
                            id: response.data.wdto.trafficShape
                        }

                        $scope.wirelessProfileObj.country5 = {
                            id: response.data.wdto.radioFiveCountry
                        }

                        for( var i = 0; i< $scope.bandwidth5Array.length; i++) {
                            if ($scope.bandwidth5Array[i].id == response.data.wdto.radioFiveBandwidth) {
                                $scope.wirelessProfileObj.bandwidth5 = $scope.bandwidth5Array[i];
                            }
                        }
                        $scope.loadChannels();
                        /*$scope.wirelessProfileObj.bandwidth5 = {
                            id: response.data.wdto.radioFiveBandwidth
                        }*/

                        $scope.wirelessProfileObj.channel5 = {
                            id: parseInt(response.data.wdto.radioFiveChannel)
                        }

                        $scope.wirelessProfileObj.radioStatus24 = {
                            id: response.data.wdto.radioTwoStatus
                        }
                        $scope.wirelessProfileObj.ssid24 = response.data.wdto.radioTwoSSID;

                        $scope.wirelessProfileObj.channel24 = {
                            id: response.data.wdto.radioTwoChannel
                        }

                        $scope.wirelessProfileObj.disableLegacy24 = {
                            id: response.data.wdto.radioTwoLegacyStatus
                        }

                        if (response.data.wdto.radioTwoHideSSID == 1) {
                            $scope.wirelessProfileObj.hideSSID24Val = true;
                        } else {
                            $scope.wirelessProfileObj.hideSSID24Val = false;
                        }

                        $scope.wirelessProfileObj.maxClients24 = response.data.wdto.radioTwoMaxClients;


                    });
                }
            }
            //radionstatus array
        $scope.radioStatus24Array = [{
            "id": 0,
            "val": "Enable"
        }, {
            "id": 1,
            "val": "Disable"
        }];
        //channel array
        $scope.channel24Array = [{ "id": "auto", "val": "ACS" }];
        var freqVal;
        for (var i = 1, freq = 2412; i <= 14; i++, freq = freq + 5) {
            $scope.freqVal = freq + 'MHz';
            //     console.log(freq, freqVal, $scope.freqVal);
            $scope.channel24Array.push({
                "id": i,
                "val": i + ' (' + $scope.freqVal + ')'
            });
        }
        //legacy array
        $scope.disableLegacy24Array = [{
            "id": 15,
            "val": "Enable"
        }, {
            "id": 0,
            "val": "Disable"
        }];

        $scope.trafficeShapeStat = [{
            "id": 1,
            "val": "Enable"
        }, {
            "id": 0,
            "val": "Disable"
        }];

        $scope.radioTypeChangeMain = function(rMode) {

            if ($scope.wirelessProfileObj.rMode != null) {
                $scope.wirelessProfileObj.rMode = rMode;
                $scope.radioTypeChange($scope.wirelessProfileObj.rMode);
            } else {
                if (rMode.name != 'AP') {
                    $scope.apRadioMode = false;
                }
            }
        }


        //radio type onchange
        $scope.radioTypeChange = function(rMode) {

            if ($scope.wirelessProfileObj.rMode.name == 'AP') {
                $scope.apRadioMode = true;
                $scope.wirelessProfileObj.bandwidth5 = $scope.bandwidth5Array[0];
                $scope.wirelessProfileObj.channel5 = $scope.channel5Array[0];

            } else {
                $scope.apRadioMode = false;
                $scope.wirelessProfileObj.bandwidth5 = "";
                $scope.wirelessProfileObj.channel5 = "";

            }
            $scope.loadChannels();
        }

        $scope.removeProperty = function(propery) {
            console.log(propery);
            //propery = null;
            $scope.wirelessProfileObj[propery] = null;
            $scope.defProfileObj[propery] = 'display:none;';
            $scope.vdefProfileObj[propery] = '';
        }


        //close the selected form
        $scope.toggleForm = function() {
                $scope.$emit("toggleFormFunction");

            }
            //check max clients lessthan 1 and graterthan 10
        $scope.checkMaxClients = function(num, group, type) {

                if (num < 1 || num > 10) {
                    if (type == 'maxClients24') {
                        $scope.wirelessProfileObj[type] = "";
                    }
                }
            }
            //post call for wireless profile
        $scope.createWirelessProfile = function() {
                if ($scope.wirelessProfileObj.hideSSID24Val != null) {
                    if ($scope.wirelessProfileObj.hideSSID24Val) {
                        $scope.wirelessProfileObj.hideSSID24Val = 1;
                    } else {
                        $scope.wirelessProfileObj.hideSSID24Val = 0;
                    }
                }

                if($scope.apRadioMode) {
                    $scope.wirelessProfileObj.inactiveTimer = null;
                } else {
                    $scope.wirelessProfileObj.channel5 = null;
                }
                var wirelessObj = {
                    "profileType": 5,
                    "name": $scope.wirelessProfileObj.wirelessProfileName.split(" ").join(""),
                    "radioMode": $scope.defaultObj.rMode ? $scope.defaultObj.rMode.value : null,
                    "linkType": $scope.defaultObj.lType ? $scope.defaultObj.lType.value : null,
                    "wdto": {
                        "radio": 0,
                        "nodeId": 0,
                        "status": 0,
                        "message": null,
                        "radioFiveSSID": $scope.wirelessProfileObj.ssid5 ? $scope.wirelessProfileObj.ssid5 : null,
                        "radioFiveLinkType": $scope.wirelessProfileObj.lType ? $scope.wirelessProfileObj.lType.value : null,
                        "radioFiveMode": $scope.wirelessProfileObj.rMode ? $scope.wirelessProfileObj.rMode.value : null,
                        "radioFiveCountry": $scope.wirelessProfileObj.country5 ? $scope.wirelessProfileObj.country5.id : null,
                        "radioFiveOpMode": null,
                        "inactiveTimer":$scope.wirelessProfileObj.inactiveTimer ? $scope.wirelessProfileObj.inactiveTimer : null,
                        "upLink":$scope.wirelessProfileObj.upLink ? $scope.wirelessProfileObj.upLink : null,
                        "downLink":$scope.wirelessProfileObj.downLink ? $scope.wirelessProfileObj.downLink : null,
                        "trafficShape":$scope.wirelessProfileObj.trafficShape ? $scope.wirelessProfileObj.trafficShape.id : null,
                        "radioFiveBandwidth": $scope.wirelessProfileObj.bandwidth5 ? $scope.wirelessProfileObj.bandwidth5.id : null,
                        "radioFiveChannel": $scope.wirelessProfileObj.channel5 ? $scope.wirelessProfileObj.channel5.id : null,
                        "radioTwoStatus": $scope.wirelessProfileObj.radioStatus24 ? $scope.wirelessProfileObj.radioStatus24.id : null,
                        "radioTwoSSID": $scope.wirelessProfileObj.ssid24 ? $scope.wirelessProfileObj.ssid24 : null,
                        "radioTwoChannel": $scope.wirelessProfileObj.channel24 ? $scope.wirelessProfileObj.channel24.id : null,
                        "radioTwoLegacyStatus": $scope.wirelessProfileObj.disableLegacy24 ? $scope.wirelessProfileObj.disableLegacy24.id : null,
                        "radioTwoHideSSID": ($scope.wirelessProfileObj.hideSSID24Val == 1 || $scope.wirelessProfileObj.hideSSID24Val == 0 ) ? $scope.wirelessProfileObj.hideSSID24Val : null,
                        "radioTwoMaxClients": $scope.wirelessProfileObj.maxClients24 ? $scope.wirelessProfileObj.maxClients24 : null
                    }
                }

                //   hear is our service call
                var confirm = $scope.createConfirm();

                $mdDialog.show(confirm).then(function() {
                    $http({
                        method: 'POST',
                        url: 'api/v2/profiles/template',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        data: wirelessObj
                    }).success(function() {
                        $scope.showAlert('Success', 'Saved successfully.');
                        $scope.wirelessProfileObj = {};
                        $scope.ttype = 5;
                        $scope.$emit("defaultCall", $scope.ttype);
                        $scope.$emit("toggleFormFunction");
                        //$scope.init();
                        //$scope.init();
                    }).error(function(msg) {
                        $scope.showAlert('Error', 'Error creating Data: ' + msg);
                    });
                });

            }
            //update call for wireless profile
        $scope.updateWirelessProfile = function() {
                if ($scope.wirelessProfileObj.hideSSID24Val != null) {
                    if ($scope.wirelessProfileObj.hideSSID24Val) {
                        $scope.wirelessProfileObj.hideSSID24Val = 1;
                    } else {
                        $scope.wirelessProfileObj.hideSSID24Val = 0;
                    }
                }

                var wirelessObj = {
                        "profileType": 5,
                        "name": $scope.wirelessProfileObj.wirelessProfileName.split(" ").join(""),
                        "profileId": $rootScope.profileID,
                        "radioMode": $scope.defaultObj.rMode ? $scope.defaultObj.rMode.value : null,
                        "linkType": $scope.defaultObj.lType ? $scope.defaultObj.lType.value : null,
                        "wdto": {
                            "radio": 0,
                            "nodeId": 0,
                            "status": 0,
                            "message": null,
                            "radioFiveSSID": $scope.wirelessProfileObj.ssid5 ? $scope.wirelessProfileObj.ssid5 : null,
                            "radioFiveLinkType": $scope.wirelessProfileObj.lType ? $scope.wirelessProfileObj.lType.value : null,
                            "radioFiveMode": $scope.wirelessProfileObj.rMode ? $scope.wirelessProfileObj.rMode.value : null,
                            "radioFiveCountry": $scope.wirelessProfileObj.country5 ? $scope.wirelessProfileObj.country5.id : null,
                            "radioFiveOpMode": null,
                            "inactiveTimer":$scope.wirelessProfileObj.inactiveTimer ? $scope.wirelessProfileObj.inactiveTimer : null,
                            "upLink":$scope.wirelessProfileObj.upLink ? $scope.wirelessProfileObj.upLink : null,
                            "downLink":$scope.wirelessProfileObj.downLink ? $scope.wirelessProfileObj.downLink : null,
                            "trafficShape":$scope.wirelessProfileObj.trafficShape ? $scope.wirelessProfileObj.trafficShape.id : null,
                            "radioFiveBandwidth": $scope.wirelessProfileObj.bandwidth5 ? $scope.wirelessProfileObj.bandwidth5.id : null,
                            "radioFiveChannel": $scope.wirelessProfileObj.channel5 ? $scope.wirelessProfileObj.channel5.id : null,
                            "radioTwoStatus": $scope.wirelessProfileObj.radioStatus24 ? $scope.wirelessProfileObj.radioStatus24.id : null,
                            "radioTwoSSID": $scope.wirelessProfileObj.ssid24 ? $scope.wirelessProfileObj.ssid24 : null,
                            "radioTwoChannel": $scope.wirelessProfileObj.channel24 ? $scope.wirelessProfileObj.channel24.id : null,
                            "radioTwoLegacyStatus": $scope.wirelessProfileObj.disableLegacy24 ? $scope.wirelessProfileObj.disableLegacy24.id : null,
                            "radioTwoHideSSID": ($scope.wirelessProfileObj.hideSSID24Val == 1 || $scope.wirelessProfileObj.hideSSID24Val == 0 ) ? $scope.wirelessProfileObj.hideSSID24Val : null,
                            "radioTwoMaxClients": $scope.wirelessProfileObj.maxClients24 ? $scope.wirelessProfileObj.maxClients24 : null
                        }
                    }
                    //   hear is our service call
                var confirm = $scope.saveconfirm();

                $mdDialog.show(confirm).then(function() {
                    $http({
                        method: 'POST',
                        url: 'api/v2/profiles/template/update',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        data: wirelessObj
                    }).success(function() {
                        $scope.showAlert('Success', 'Updated successfully.');
                        $scope.ttype = 5;
                        $scope.$emit("defaultCall", $scope.ttype);
                        $scope.$emit("toggleFormFunction");
                    }).error(function(msg) {
                        $scope.showAlert('Error', 'Error updating Data: ' + msg);
                    });
                });

            }
            //  this method is used for removing undefined and null ke values from object
        function clean(obj) {
            for (var propName in obj) {
                if (obj[propName] === null || obj[propName] === undefined || obj[propName] === "") {
                    delete obj[propName];
                }
            }
            return obj;
        }
        //create conformation
        $scope.createConfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to create this profile?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };
        //update conformation
        $scope.saveconfirm = function(ev) {
            var confirm = $mdDialog.confirm()
                .title('Are you sure you want to update these changes?')
                .targetEvent(ev)
                .ok('Yes')
                .cancel('No')
            return confirm;
        };


    }
]);
