/*
	@license Angular Treeview version 0.1.6
	ⓒ 2013 AHN JAE-HA http://github.com/eu81273/angular.treeview
	License: MIT


	[TREE attribute]
	angular-treeview: the treeview directive
	tree-id : each tree's unique id.
	tree-model : the tree model on $scope.
	node-id : each node's id
	node-label : each node's label
	node-children: each node's children

	<div
		data-angular-treeview="true"
		data-tree-id="tree"
		data-tree-model="roleList"
		data-node-id="roleId"
		data-node-label="roleName"
		data-node-children="children" >
	</div>
*/

(function (angular) {
    'use strict';
    angular.module('angularTreeview', []).directive('treeModel', ['$compile', '$location', '$state', '$http', function ($compile, $location, $state, $http) {
        return {
            restrict: 'A',
            link: function (scope, element, attrs) {
                var treeId = attrs.treeId; // Node Tree Id
                var treeModel = attrs.treeModel; // Node Tree
                var nodeId = attrs.nodeId || 'id'; // Node Id
                var nodeType = attrs.nodeType || 'data.mode'; // Node Type
                var nodeLabel = attrs.nodeLabel || 'label'; // Node Label
                var nodeChildren = attrs.nodeChildren || 'children'; // Node Children

                // Tree Template - To generate HTML code to display tree view on clicks
                var template =
                    '<ul class="treeview">' +
                    '<li data-ng-repeat="node in ' + treeModel + '" >' +
                    //						    '<i class="minus" data-ng-show="!selectedNode.collapsed"></i> ' +
                    //                            '<i class="plus" data-ng-show="selectedNode.collapsed"></i> ' +
                    '<i class="{{node.' + nodeType + '}}" ng-show=node.data.active></i> ' +
                    '<i class="{{node.' + nodeType + '}}down" ng-show=!node.data.active></i> ' +
                    '<span style="width:100px;display:inline-block;outline:none;" data-ng-class="node.selected" class="highlightText" context-menu="{{node.' + nodeType + '}}" data-ng-click="' + treeId + '.selectNodeLabel(node)"><span id="root-node">{{node.' + nodeLabel + '}}</span></span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' +
                    /*'<span style="float:center;">' +*/
                    '<i class="next{{node.' + nodeType + '}}" style="text-align:right;float:right;height:20px;" ng-show=node.data.active data-ng-click="' + treeId + '.next(node)"></i> ' +
                    '<i class="modify{{node.' + nodeType + '}}" style="text-align:right;float:right;height:20px;" ng-show=node.data.active data-ng-click="' + treeId + '.quickedit(node)"></i> ' +


                    '<i class="next{{node.' + nodeType + '}}down" style="text-align:right;float:right;height:20px;" ng-show=!node.data.active data-ng-click="' + treeId + '.next(node)"></i> ' +
                    '<i class="modify{{node.' + nodeType + '}}down" style="text-align:right;float:right;height:20px;" ng-show=!node.data.active data-ng-click="' + treeId + '.quickedit(node)"></i> ' +

                    /*'</span>' +*/
                    '<div style="outline:none;" data-ng-hide="node.collapsed" data-tree-id="' + treeId + '" data-tree-model="node.' + nodeChildren + '" data-node-id=' + nodeId + ' data-node-label=' + nodeLabel + ' data-node-children=' + nodeChildren + '></div>' +
                    '<i class="normal{{node.' + nodeType + '}}" data-ng-show="node.collapsed" data-tree-id="' + treeId + '" data-tree-model="node.' + nodeChildren + '" data-node-id=' + nodeId + ' data-node-label=' + nodeLabel + ' data-node-children=' + nodeChildren + '></i>'

                '</li>' +
                    '</ul>';

                // Check tree id, tree model
                if (treeId && treeModel) {
                    // Root node
                    if (attrs.angularTreeview) {
                        // Create tree object if not exists
                        scope[treeId] = scope[treeId] || {};
                        // If node head clicks,
                        scope[treeId].selectNodeHead = scope[treeId].selectNodeHead || function (selectedNode) {
                            selectedNode.collapsed = !selectedNode.collapsed; //Collapse or Expand
                        };
                        scope[treeId].next = scope[treeId].selectNodeLabel || function (selectedNode) {
                            if (selectedNode.data.active) {
                                $state.go('app.nodeView', { "nodeId": selectedNode.data.id, "lastView": "app.topology" });
                            } else {
                                $state.go('app.nodeView', { "nodeId": selectedNode.data.id, "lastView": "app.topology" });
                            }
                        }
                        scope[treeId].quickedit = scope[treeId].selectNodeLabel || function (selectedNode) {
                            if (!selectedNode.data.active) {
                                return;
                            }
                            scope.nodeID = selectedNode.data.id;
                            scope.showmodalcontent = true;
                            scope.colclass = "col-md-6";
                            if (scope.systemdiv) {
                                scope.addrType = [{ "addressType": "dhcp", "addressesVal": "Dynamic" }, { "addressType": "static", "addressesVal": "Static" }];
                                scope.vlanStatus = [{ "vlanStatus": 1, "vlanStatusVal": "Enable" }, { "vlanStatus": 0, "vlanStatusVal": "Disable" }];
                                scope.vlanMode = [{ "vlanMode": 0, "vlanModeVal": "Transparent" }];
                                var url = 'api/v2/nodenetview/quicksystem?nodeId=' + scope.nodeID;
                                $http.get(url)
                                    .then(function (response) {
                                        if (response.data) {
                                            scope.systemData = response.data;
                                            scope.systemData.addr = {
                                                addressType: scope.systemData.ipConfig.addressType
                                            }
                                            scope.systemData.vlanStat = {
                                                vlanStatus: scope.systemData.vlan.vlanStatus
                                            }
                                            scope.systemData.vlanMod = {
                                                vlanMode: scope.systemData.vlan.vlanMode
                                            }
                                        }
                                    });
                            }
                            if (scope.location) {
                                var url = 'api/v2/nodemanageview/quicklocation?nodeId=' + scope.nodeID;
                                $http.get(url)
                                    .then(function (response) {

                                        if (response.data) {
                                            scope.locationData = response.data;
                                        }
                                    });
                            }
                            if (scope.oneghzdiv) {
                                scope.radiomode = [{ "radioMode": 'ap', "rmodeVal": "Outdoor Base" }, { "radioMode": 'sta', "rmodeVal": "Outdoor Subscriber" }];
                                scope.country = [{ "countryCode": 5018, "countryName": "INDIA" }];
                                scope.operationalMode = [{ "opMode": "11ac" }, { "opMode": "11nc" }];
                                scope.bw = [{ "bandWIdthID": "HT40", "bandWidth": "40Mhz" }, { "bandWIdthID": "HT20", "bandWidth": "20Mhz" }, { "bandWIdthID": "HT80", "bandWidth": "80Mhz" }];
                                scope.channel_one = [];
                                scope.val = 5105;
                                for (var i = 22; i < 184; i++) {
                                    scope.val = scope.val + 5;
                                    scope.mhzval = scope.val + 'MHZ';
                                    scope.channel_one.push({ "channel": i, "channelVal": i + '(' + scope.mhzval + ')' });
                                }
                                var url = 'api/v2/nodewirelessview/quickfiveg?nodeId=' + scope.nodeID;
                                $http.get(url)
                                    .then(function (response) {
                                        if (response.data) {
                                            scope.wireLessData = response.data;
                                            scope.wireLessData.chnnl = {
                                                channel: parseInt(scope.wireLessData.channel)
                                            }
                                            scope.wireLessData.mode = {
                                                opMode: scope.wireLessData.opMode
                                            }

                                            scope.wireLessData.countries = {
                                                countryCode: scope.wireLessData.country
                                            }
                                            scope.wireLessData.bndwdt = {
                                                bandWIdthID: scope.wireLessData.bandwidth
                                            }
                                            scope.wireLessData.rMode = {
                                                radioMode: scope.wireLessData.radioMode
                                            }
                                        }
                                    });
                            }
                            if (scope.twoghzdiv) {
                                scope.radiomode2 = [{ "radioMode": 'ap', "rmodeVal": "Access Point" }, { "radioMode": 'sta', "rmodeVal": "Client" }];
                                scope.country2 = [{ "countryCode": 643, "countryName": "INDIA" }];
                                scope.operationalMode = [{ "opMode": "11ac" }, { "opMode": "11nc" }];
                                scope.bw = [{ "bandWIdthID": "HT40", "bandWidth": "40MHZ" }, { "bandWIdthID": "HT20", "bandWidth": "20MHZ" }, { "bandWIdthID": "HT80", "bandWidth": "80MHZ" }];
                                scope.channel_two = [];
                                scope.val = 2137;
                                for (var i = 1; i < 14; i++) {
                                    scope.val = scope.val + 5;
                                    scope.mhzval = scope.val + 'MHZ';
                                    scope.channel_two.push({ "channel": i, "channelVal": i + '(' + scope.mhzval + ')' });
                                }
                                scope.channel_two.unshift({ "channel": 0, "channelVal": 'auto' })
                                var url = 'api/v2/nodewirelessview/quicktwog?nodeId=' + scope.nodeID;
                                $http.get(url)
                                    .then(function (response) {
                                        if (response.data) {
                                            scope.wireLess_Data = response.data;
                                            if (scope.wireLess_Data.country == '643') {
                                                scope.wireLess_Data.countryCD = 'INDIA';
                                            }
                                            scope.wireLess_Data.chnnl = {
                                                channelVal: scope.wireLess_Data.channel
                                            }
                                            scope.wireLess_Data.bndwdt = {
                                                bandWIdthID: scope.wireLess_Data.bandwidth
                                            }
                                            if (scope.wireLess_Data.radioMode == 'ap') {
                                                scope.wireLess_Data.radioMode = 'Access Point'
                                            } else { scope.wireLess_Data.radioMode = 'Client' }
                                        }
                                    });
                            }
                        }
                        // On Node Click in Tree view
                        scope[treeId].selectNodeLabel = scope[treeId].selectNodeLabel || function (selectedNode) {
                            /*if (selectedNode.data.type=='node' && !selectedNode.data.active) {
                                return;
                            }*/
                            //remove highlight from previous node
                            if (scope[treeId].currentNode && scope[treeId].currentNode.selected) {
                                scope[treeId].currentNode.selected = undefined;
                            }
                            //set highlight to selected node
                            selectedNode.selected = 'selected';
                            // Display or hide charts based on tree view node selection
                            if (selectedNode.data.mode == 'sta' || selectedNode.data.mode == 'ap') {
                                // If selected node is device
                                $state.params.nodeId = selectedNode.data.id;
                                if (selectedNode.data.mode == 'sta') {
                                    $state.params.mode = 2;
                                } else {
                                    $state.params.mode = 1;
                                }
                                $state.params.mode
                                scope.nodeID = selectedNode.data.id;
                                if (selectedNode.data.type=='node' && selectedNode.data.active) {
                                   scope.system();
                                   scope.mapDynamicHeight = "width:100%;height:63vh;position:relative;overflow:hidden;";
                                   scope.chartGrid = true; // Display Chart
                                } else {
                                    scope.chartGrid = false;
                                    scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden;"; // Full Height for Map
                                }

                                // scope.device_init();
                            } else {
                            // If selected node is not a device
                                scope.chartGrid = false;
                                scope.mapDynamicHeight = "width:100%;height:89vh;position:relative;overflow:hidden;"; // Full Height for Map
                            }
                            //set currentNode
                            scope[treeId].currentNode = selectedNode;
                        };
                    }
                    //Rendering template.
                    element.html('').append($compile(template)(scope));
                }
            }
        };
    }]);
})(angular);
