<%--
<jsp:include page="/includes/bootstrap.jsp" flush="false">
  <jsp:param name="title" value="Login" />
  <jsp:param name="nonavbar" value="true" />
</jsp:include>
--%>
<%@ taglib prefix='c' uri='http://java.sun.com/jsp/jstl/core'%>
<%--
/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2006-2015 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2015 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/
--%>
<jsp:include page="/includes/mobile-app-promo.jsp" flush="false" />

<style>
  html {
    position: relative;
    min-height: 100%;
  }
    @import "compass/css3";

* { box-sizing: border-box; }

body {
    font-family: "HelveticaNeue-Light","Helvetica Neue Light","Helvetica Neue",Helvetica,Arial,"Lucida Grande",sans-serif;
    color:white;
    font-size:12px;
    background: white;
}

.login-container {
    background:white;
    width:800px;
    height:400px;
    margin:30px auto;
    border-radius:0.4em;
    overflow:hidden;
    position:relative;
    color:white;
    box-shadow: 0 5px 10px 5px rgba(0,0,0,0.2);
    margin-top: 10%;
}
<%--
.login-container:after {
    content:"";
    display:block;
    position:absolute;
    height:1px;
    width:100px;
    left:20%;
    background:linear-gradient(left, #111, #444, #b6b6b8, #444, #111);
    top:0;
}

.login-container:before {
    content:"";
    display:block;
    position:absolute;
    width:8px;
    height:5px;
    border-radius:50%;
    left:34%;
    top:-7px;
    box-shadow: 0 0 6px 4px #fff;
}
--%>
.info-container {
    padding-top: 10px;
    padding-left: 40px;
    padding-right:10px;
    width:400px;
    background:#663399;
    height:100%;
    float:left;
}
.form-container {
    padding-top: 120px;
    padding-left: 40px;
    padding-right: 60px;
    padding-top: 120px;
    width:400px;
    height:100%;
    background:#FFFFFF;
    float:right;
}

.login-header{
    padding-top: 25px;
    color:white;
    font-size: 16px;
    font-family: 'Open Sans', sans-serif;
}

.login-description {
    color:white;
    font-size: 14px;
    font-weight:500;
    font-family: 'Open Sans', sans-serif;
}
.component-label{
    color: #666666;
    font-size: 12px;
    font-weight: 500;
    font-family: 'Open Sans', sans-serif;
    padding-bottom:5px;
}
.error-message{
    color: #ff5555;
    font-size: 14px;
    font-weight:500;
    font-family: 'Open Sans', sans-serif;
}

.eye-icon {
    float: right;
    margin-right: 10px;
    position: relative;
    z-index: 2;
    margin-top: -40px;
    color:#666666;
}

input:-webkit-autofill {
    -webkit-box-shadow: 0 0 0 1000px white inset !important;
}
<%--
.inset {
 	padding:15px;
}
--%>

.inset {
 	padding-left:15px;
 	padding-right:55px;
}

form h1 {
    font-size:18px;
    text-shadow:0 1px 0 black;
    text-align:center;
    <%-- padding:15px 0; --%>
    border-bottom:1px solid #ffffff;
    position:relative;
}
<%--
form h1:after {
    content:"";
    display:block;
    width:250px;
    height:100px;
    position:absolute;
    top:0;
    left:50px;
    pointer-events:none;
    transform:rotate(70deg);
    background:linear-gradient(50deg, rgba(255,255,255,0.15), rgba(0,0,0,0));
}
--%>

label {
 	color:#666666;
 	font-size:12px;
 	font-weight:600;
    display:block;
    padding-bottom:9px;
}

input[type=text],
input[type=password]{
    width:100%;
    padding:8px 5px;
    border:1px solid #999999;
    box-shadow: 0 1px 0 rgba(255,255,255,0.1);
    background-color:white;
    color:black;
    border-radius:0.3em;
    margin-bottom:20px;
}

label[for=remember]{
    color:white;
    display:inline-block;
    padding-bottom:0;
    padding-top:5px;
}

input[type=checkbox] {
    display:inline-block;
    vertical-align:top;
}


.p-container {
 	padding:0 20px 20px 20px;
}

.p-container:after {
    clear:both;
    display:table;
    content:"";
}

.p-container span {
    display:block;
    float:left;
    color:#0d93ff;
    padding-top:8px;
}
<%--
input[type=submit] {
    padding:5px 20px;
    border:1px solid rgba(0,0,0,0.4);
    text-shadow:0 -1px 0 rgba(0,0,0,0.4);
    box-shadow:
    inset 0 1px 0 rgba(255,255,255,0.3),
    inset 0 10px 10px rgba(255,255,255,0.1);
    border-radius:0.3em;
    background:#00a0df;
    color:white;
    fonbt-weight:bold;
    float:right;
    font-weight:bold;
    cursor:pointer;
    font-size:13px;
}
--%>
  input[type=submit] {
    padding:5px 20px;
    border:1px solid rgba(0,0,0,0.4);
    inset 0 1px 0 rgba(255,255,255,0.3),
    inset 0 10px 10px rgba(255,255,255,0.1);
    border-radius:0.3em;
    background:#f6f6f6;
    color:#666666;
    font-weight: 900;
    cursor:pointer;
    font-size:12px;
}

</style>

<%--
<form  id="loginForm" role="form" action="<c:url value='j_spring_security_check'/>" method="post">

  <h1 style="background-color:white"><img src="./images/keywestlogo.png"></h1><hr/>
  <div class="inset">
  <p>
    <label for="input_j_username">Username</label>
    <input type="text" id="input_j_username" name="j_username"
    <c:if test="${not empty param.login_error}">value='<c:out value="${SPRING_SECURITY_LAST_USERNAME}"/>'</c:if>
     autofocus="autofocus" autocomplete="username" />

    <label for="j_password">Password</label>
    <input type="password" id="input_j_password" name="j_password" autocomplete="current-password">
    <center>
      <input type="submit" name="Login" value="Log in">
    </center>
  </p>
  <p style="display:none">
    <input type="checkbox" name="remember" id="remember">
    <label for="remember">Remember me for 14 days</label>
  </p>
  </div>
  <p class="p-container">
   <c:if test="${not empty param.login_error}">
    <table width="100%" align="center">
       <tr>
       <td align="center">
          <p id="login-attempt-failed" class="p-container text-danger" style="color:red;">
                  <strong>log in failed, please try again..</strong>
          </p>
       </td>
       </tr>
       </table>
    </c:if>
  </p>
  <input name="j_usergroups" type="hidden" value=""/>

  <script type="text/javascript">
    if (document.getElementById) {
      document.getElementById('input_j_username').focus();
    }
  </script>
</form>
 --%>

<title>ORNMS</title>
<link rel="shortcut icon" type="image/ico" href="./images/favico.ico"/>
<link href="https://use.fontawesome.com/releases/v5.7.0/css/all.css" rel="stylesheet" type="text/css">

<div class="container">
    <div class="login-container">
    <div class="info-container">

        <h1><img style="height: 350px;" src="./images/keywestlogo_login.svg"></h1>
    </div>

     <form  class="form-container" id="loginForm" role="form" action="<c:url value='j_spring_security_check'/>" method="post">
        <div>
            <input type="text" id="input_j_username" name="j_username" placeholder="Username"
            <c:if test="${not empty param.login_error}">value='<c:out value="${SPRING_SECURITY_LAST_USERNAME}"/>'</c:if>
            autofocus="autofocus" autocomplete="username" />

            <input type="password" style="margin-bottom:15px;" id="input_j_password" name="j_password" placeholder="Password" autocomplete="current-password">

            <img id="mask-reveal" class="eye-icon" style="height:15px;width:15px;display:inline;" src="./images/eye-slash.png" onclick="masking()">
            <%--  <p id="mask-reveal" class="fas fa-eye-slash eye-icon" style="display:inline;" onclick="masking()"></p> --%>
            <%-- <p style="color:#666666;margin-top:unset;margin-bottom:20px;"><input type="checkbox" style="margin-top:unset;margin-left:unset;" onclick="masking()"> Show Password </p> --%>
            <input type="submit" name="Login" value="LOGIN" style="display:block;">
        </div>
        <p class="p-container">
            <c:if test="${not empty param.login_error}">
            <table width="100%" align="center">
                <tr>
                <td align="center">
                    <p id="login-attempt-failed" class="error-message">log in failed, please try again..


                    </p>
                </td>
                </tr>
            </table>
            </c:if>
        </p>
       <input name="j_usergroups" type="hidden" value=""/>

       <script type="text/javascript">
         if (document.getElementById) {
           document.getElementById('input_j_username').focus();
         }

        <%-- Masks and unmasks the password along with icon change--%>
        function masking() {
          var x = document.getElementById("input_j_password");
          var y = document.getElementById("mask-reveal");
          if (x.type === "password") {
            x.type = "text";
            y.src = "./images/eye.png";
            <%-- y.class="fas fa-eye eye-icon"; --%>
          } else {
            x.type = "password";
            y.src = "./images/eye-slash.png";
            <%--  y.class="fas fa-eye-slash eye-icon"; --%>
          }
        }
       </script>
     </form>
    </div>
</div>

 <center>
 <label>&#169; 2021, Copyright KEYWEST NETWORKS. ALL RIGHTS RESERVED.</label>
 </center>
<jsp:include page="/includes/bootstrap-footer.jsp" flush="false" />
