#!/bin/bash 
### Script for installing ORNMS

echo '          ----------ORNMS----------          '
INSTALL_APACHE=false
INSTALL_POSTGRES=false
CONFIGURE_POSTGRES=false
ORNMS_INSTALLED=false
ORNMS_CONFIG_FILE="/opt/ornms/etc/configured"
ORNMS_INSTALL_FOLDER="/opt/ornms/bin/ornms"
ORNMS_CORE_VERSION="ornms-core_0.0.1-1.2021073_all.deb"
ORNMS_JETTY="ornms-webapp-jetty_0.0.1-1.2021073_all.deb"
ORNMS_SERVICE="/etc/systemd/system/ornms.service"
INSTALL_SERVICE=false

checkApache(){
	echo '          ----------Validating Apache----------          '
	APACHE=$(apache2 -v | sed -n 's/.*Server version: //p')
	if [ -z "$APACHE" ];
	then
		INSTALL_APACHE=true
	fi
}

checkJava(){
	echo '          ----------Validating Java--------          '
	local JAVA_HIGHER=`java -version 2>&1 | grep 'version' 2>&1 | awk -F\" '{ split($2,a,"."); print a[1]}'`
	local JAVA_EIGHT=`java -version 2>&1 | grep 'version' 2>&1 | awk -F\" '{ split($2,a,"."); print a[2]}'`
	#JAVA_VERSION=`java -version 2>&1 | grep 'version' 2>&1 | awk -F\" '{ split($2,a,"."); print a[2]}'`
	JAVA_VERSION=`java -version 2>&1 | grep 'version' 2>&1 | awk -F\" '{ split($2,a,"."); print a[2]}'`
	echo ''$JAVA_RELEASE
	
	if [ -z "$JAVA_VERSION" ];
	then
		JAVA_VERSION=true
	else
		if [ "$JAVA_HIGHER" -gt 8 ]; then
			JAVA_VERSION=true
		elif [ "$JAVA_EIGHT" -eq 8 ]; then
			JAVA_VERSION=false	
		fi
	fi
}

checkPostgres(){
	echo '          ----------Validating Postgres----------          '
	POSTGRES=$(which psql);
	
	if [ -z "$POSTGRES" ]; then
		POSTGRES_VER=""
	else
		POSTGRES_VER=$("$POSTGRES" --version | sed -ne 's/[^0-9]*\(\([0-9]\.\)\{0,4\}[0-9][^.]\).*/\1/p')
	fi
        echo $POSTGRES_VER	
	if [ $POSTGRES_VER -gt 10 ]; then
		echo 'Should add -Q for configuring'
	else
		echo 'default db configuration'
	fi
	if [ -z "$POSTGRES_VER" ];
	then
		INSTALL_POSTGRES=true
	fi
}

configurePostgres(){
	echo '          ----------Configuring Postgres----------          '
	checkPostgres;
	POSTGRES_CONFIG="/etc/postgresql/$POSTGRES_VER/main"

	echo "$POSTGRES_CONFIG"

	if ! $INSTALL_POSTGRES; 
	then
		if [ -d "$POSTGRES_CONFIG" ] && [ -f "$POSTGRES_CONFIG/pg_hba.conf" ];
		then
			echo "postgres folder exists and will try to configure postgres"
			CONFIGURE_POSTGRES=false
		else
			echo "POSTGRES folder does not exist"
			CONFIGURE_POSTGRES=true
		fi
	fi
	if ! $ORNMS_INSTALLED; then
		sudo cp /tmp/pg_hba.conf $POSTGRES_CONFIG
		sudo -u postgres psql -f /tmp/opennms.sql
		/etc/init.d/postgresql restart	
	fi

}

checkIfNMSInstalled(){
	
	if [ -f $ORNMS_INSTALL_FOLDER ];
	then
		echo "NMS is installed previously"
		ORNMS_INSTALLED=true;
	else
		echo "NMS is not installed previously"
		ORNMS_INSTALLED=false;
	fi
	if [ -f $ORNMS_CONFIG_FILE ]; 
	then
		#echo "ORNMS is already installed"
		CONFIGURE_POSTGRES=false
		INSTALL_POSTGRES=false
	fi
	if $ORNMS_INSTALLED; then
		if [ -f $ORNMS_SERVICE ]; then
			echo "Stopping ornms service ......."
			systemctl stop ornms	
		fi
	fi

}

installNMS(){
	dpkg -i /tmp/$ORNMS_CORE_VERSION
	dpkg -i /tmp/$ORNMS_JETTY
}

installApache(){
	if $INSTALL_APACHE; then
		echo "Installing Apache....."
		sudo apt-get -y install apache2
	else
		echo "Apache already installed"
	fi
}

installJDK(){
	echo "$JAVA_VERSION"
	if $JAVA_VERSION; then
		echo "Installing JDK....."
		sudo apt-get -y install openjdk-8-jdk
	else
		echo "JDK already installed"
	fi
}

installPostgres(){
	if $INSTALL_POSTGRES; then
		echo "installing Postgres....."
		sudo sh -c 'echo "deb http://apt.postgresql.org/pub/repos/apt $(lsb_release -cs)-pgdg main" > /etc/apt/sources.list.d/pgdg.list'
		wget --quiet -O - https://www.postgresql.org/media/keys/ACCC4CF8.asc | sudo apt-key add -
		sudo apt-get update
		sudo apt-get -y install postgresql-10
		CONFIGURE_POSTGRES=true
	else
		echo "Installed postgreSQL $POSTGRES_VER" version
	fi
}

configureNMS(){

	ADD_Q=''
	echo $POSTGRES_VER
	if [ "$POSTGRES_VER" -gt 10 ]; then
        	ADD_Q=' -Q'
        fi

	sudo /opt/ornms/bin/runjava -s
	sudo /opt/ornms/bin/install -dis$ADD_Q
	
	se=$(servicEexists)
	echo $se
	if [ "$se" == '1' ] ; then
		echo "Service exists"
	else
		echo "Installing ornms service...."
		sed -i 's/<PG_VER>/'$POSTGRES_VER'/' "/tmp/ornms.service"
		sudo cp /tmp/ornms.service /etc/systemd/system/
		sudo systemctl daemon-reload
		sudo systemctl enable ornms
	fi
	echo "Starting ornms service......"
	sudo systemctl start ornms
}

servicEexists() {
	ret='1'
	if [ -f $ORNMS_SERVICE ] ; then
		ret='1'
	else
		ret='0'
	fi
	echo $ret
	return $ret
}

start(){
	
	
	checkIfNMSInstalled;

	if ! $ORNMS_INSTALLED; then
		echo '          ----------Installing ORNMS for the first time----------          '
	else
		echo '          ----------Upgrading ORNMS for the first time----------          '
	fi
	
	checkApache;
	installApache;
	checkPostgres;
	installPostgres;
	checkIfNMSInstalled;
	checkJava;
	installJDK;
	installNMS;
	configurePostgres;
	configureNMS;
	
}

FUNCTIONS_LOADED=0

start;



